/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;

public class UcanloadDriver
implements Driver {
    private static Driver d;
    private static SQLException ex;
    public static final String URL_PREFIX = "jdbc:ucanaccess://";

    static {
        try {
            File f;
            DriverManager.registerDriver(new UcanloadDriver());
            String home = System.getProperty("UCANACCESS_HOME");
            if (home == null) {
                String classLocation = String.valueOf(UcanloadDriver.class.getName().replace('.', '/')) + ".class";
                ClassLoader loader = UcanloadDriver.class.getClassLoader();
                String classLocationString = loader.getResource(classLocation).toString();
                if (classLocationString.indexOf("ucanload.jar!") > 0) {
                    String jarLocationString = classLocationString.substring(9, classLocationString.indexOf("ucanload.jar!", 0));
                    File jarFolder = new File(jarLocationString);
                    home = jarFolder.getParent();
                }
            }
            if (home == null) {
                throw UcanloadDriver.noHome();
            }
            File dir = new File(home);
            File lib = new File(home, "lib");
            if (!lib.exists()) {
                throw UcanloadDriver.wrongHome();
            }
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            };
            File[] ucajar = dir.listFiles(fnf);
            File[] libjars = lib.listFiles(fnf);
            ArrayList<URL> au = new ArrayList<URL>();
            File[] fileArray = ucajar;
            int n = ucajar.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                au.add(f.toURI().toURL());
                ++n2;
            }
            fileArray = libjars;
            n = libjars.length;
            n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                au.add(f.toURI().toURL());
                ++n2;
            }
            URL[] ucadURL = au.toArray(new URL[au.size()]);
            URLClassLoader ucadLd = URLClassLoader.newInstance(ucadURL);
            d = (Driver)ucadLd.loadClass("net.ucanaccess.jdbc.UcanaccessDriver").newInstance();
        }
        catch (Exception e) {
            ex = (SQLException)(e instanceof SQLException ? e : new SQLException(e));
        }
    }

    private static SQLException noHome() {
        return new SQLException("The UCANACCESS_HOME system variable isn't defined:\n it should be:\n-DUCANACCESS_HOME=<your path to the UCanAccess-3.x.x-bin folder> ");
    }

    private static SQLException wrongHome() {
        return new SQLException("UCANACCESS_HOME system variable doesn't point to the correct ucanaccess home\n it should be:\n -DUCANACCESS_HOME=<your path to the UCanAccess-3.x.x-bin folder>");
    }

    private static void check() throws SQLException {
        if (ex != null) {
            throw ex;
        }
        if (d == null) {
            throw UcanloadDriver.wrongHome();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX) && url.length() > URL_PREFIX.length();
    }

    @Override
    public Connection connect(String url, Properties pr) throws SQLException {
        UcanloadDriver.check();
        return d.connect(url, pr);
    }

    public boolean equals(Object obj) {
        return d.equals(obj);
    }

    @Override
    public int getMajorVersion() {
        return d.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return d.getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties arg1) throws SQLException {
        return d.getPropertyInfo(url, arg1);
    }

    @Override
    public boolean jdbcCompliant() {
        return d.jdbcCompliant();
    }
}

