/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import xeadEditor.DialogCheckLayout;
import xeadEditor.DialogCheckLayoutByteaField;
import xeadEditor.DialogCheckLayoutCheckBox;
import xeadEditor.DialogCheckLayoutComboBox;
import xeadEditor.DialogCheckLayoutDateField;
import xeadEditor.DialogCheckLayoutFYearBox;
import xeadEditor.DialogCheckLayoutImageField;
import xeadEditor.DialogCheckLayoutMSeqBox;
import xeadEditor.DialogCheckLayoutPromptCallField;
import xeadEditor.DialogCheckLayoutReferTable;
import xeadEditor.DialogCheckLayoutTextArea;
import xeadEditor.DialogCheckLayoutTextField;
import xeadEditor.DialogCheckLayoutUrlField;
import xeadEditor.DialogCheckLayoutYMonthBox;

class DialogCheckLayoutField
extends JPanel {
    private static final long serialVersionUID = 1L;
    Element functionFieldElement_ = null;
    Element tableElement = null;
    private String fieldName = "";
    private String fieldRemarks = "";
    private String dataSourceName = "";
    private String tableID_ = "";
    private String tableAlias_ = "";
    private String fieldID_ = "";
    private String fieldCaption = "";
    private String dataType = "";
    private int dataSize = 5;
    private int decimalSize = 0;
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private String fieldOptions = "";
    private ArrayList<String> fieldOptionList;
    private int fieldRows = 1;
    private JPanel jPanelField = new JPanel();
    private JLabel jLabelField = new JLabel();
    private JPanel jPanelFieldComment = null;
    private JLabel jLabelFieldComment = null;
    private JButton jButtonToRefferZipNo = null;
    private boolean isEditable = true;
    private boolean isHorizontal = false;
    private boolean isAutoDetailRowNumber = false;
    private int positionMargin = 0;
    private JComponent component = new JTextField("TEST");
    private DialogCheckLayout dialog_;

    public DialogCheckLayoutField(Element functionFieldElement, boolean isOnEditablePanel, DialogCheckLayout dialog) {
        FontMetrics metrics;
        String wrkStr;
        this.dialog_ = dialog;
        this.functionFieldElement_ = functionFieldElement;
        this.fieldOptions = this.functionFieldElement_.getAttribute("FieldOptions");
        this.fieldOptionList = this.dialog_.getEditor().getOptionList(this.fieldOptions);
        this.dataSourceName = this.functionFieldElement_.getAttribute("DataSource");
        StringTokenizer workTokenizer = new StringTokenizer(this.dataSourceName, ".");
        this.tableAlias_ = workTokenizer.nextToken();
        this.tableID_ = this.dialog_.getTableIDOfTableAlias(this.tableAlias_);
        this.fieldID_ = workTokenizer.nextToken();
        if (isOnEditablePanel) {
            if (this.tableID_.equals(this.dialog_.getPrimaryTable().getTableID()) && this.tableAlias_.equals(this.tableID_)) {
                this.isEditable = true;
                int i = 0;
                while (i < this.dialog_.getPrimaryTable().getKeyFieldList().size()) {
                    if (this.dialog_.getPrimaryTable().getKeyFieldList().get(i).equals(this.fieldID_)) {
                        this.isEditable = false;
                        break;
                    }
                    ++i;
                }
            } else {
                this.isEditable = false;
            }
        } else {
            this.isEditable = false;
        }
        if (this.fieldOptionList.contains("HORIZONTAL")) {
            this.isHorizontal = true;
        }
        if (!(wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "HORIZONTAL")).equals("")) {
            this.isHorizontal = true;
            this.positionMargin = Integer.parseInt(wrkStr);
        }
        if (!(wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "VERTICAL")).equals("")) {
            this.positionMargin = Integer.parseInt(wrkStr);
        }
        Element workElement = this.dialog_.getEditor().getSpecificFieldElement(this.tableID_, this.fieldID_);
        this.fieldName = workElement.getAttribute("Name");
        this.fieldRemarks = this.dialog_.getEditor().substringLinesWithTokenOfEOL(workElement.getAttribute("Remarks"), "<br>");
        this.dataType = workElement.getAttribute("Type");
        this.dataTypeOptions = workElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = this.dialog_.getEditor().getOptionList(this.dataTypeOptions);
        this.fieldCaption = workElement.getAttribute("Name").equals("") ? workElement.getAttribute("ID") : this.fieldName;
        this.dataSize = Integer.parseInt(workElement.getAttribute("Size"));
        if (!workElement.getAttribute("Decimal").equals("")) {
            this.decimalSize = Integer.parseInt(workElement.getAttribute("Decimal"));
        }
        if (!(wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "CAPTION")).equals("")) {
            this.fieldCaption = wrkStr;
        }
        this.jLabelField.setText(this.fieldCaption);
        this.jLabelField.setFocusable(false);
        this.jLabelField.setHorizontalAlignment(4);
        this.jLabelField.setVerticalAlignment(1);
        this.jLabelField.setFont(new Font(this.dialog_.driverFontName_, 0, 18));
        if (this.fieldOptionList.contains("CAPTION_LENGTH_VARIABLE")) {
            metrics = this.jLabelField.getFontMetrics(this.jLabelField.getFont());
            this.jLabelField.setPreferredSize(new Dimension(metrics.stringWidth(this.fieldCaption), 25));
        } else {
            int captionWidth = 150;
            wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "CAPTION_WIDTH");
            if (!wrkStr.equals("")) {
                captionWidth = Integer.parseInt(wrkStr);
            }
            this.jLabelField.setPreferredSize(new Dimension(captionWidth, 25));
            DialogCheckLayout.adjustFontSizeToGetPreferredWidthOfLabel(this.jLabelField, captionWidth);
        }
        this.component.setPreferredSize(new Dimension(120, this.dialog_.getFieldUnitHeight()));
        if (this.fieldOptionList.contains("PROMPT_LIST")) {
            DialogCheckLayoutReferTable referTable = null;
            ArrayList<DialogCheckLayoutReferTable> referTableList = this.dialog_.getReferTableList();
            int i = 0;
            while (i < referTableList.size()) {
                if (referTableList.get(i).getTableID().equals(this.tableID_) && (referTableList.get(i).getTableAlias().equals("") || referTableList.get(i).getTableAlias().equals(this.tableAlias_))) {
                    referTable = referTableList.get(i);
                    break;
                }
                ++i;
            }
            this.component = new DialogCheckLayoutComboBox(this.functionFieldElement_, this.dataTypeOptions, referTable, this.dialog_);
        } else {
            wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "PROMPT_CALL");
            if (!wrkStr.equals("")) {
                this.component = new DialogCheckLayoutPromptCallField(functionFieldElement, this.isEditable, this.dialog_);
            } else {
                wrkStr = dialog.getFunctionElement().getAttribute("Type");
                if (!(!this.isEditable || !wrkStr.equals("XF200") && !wrkStr.equals("XF310") || this.dialog_.getEditor().getOptionValueWithKeyword(this.dataTypeOptions, "KUBUN").equals("") && this.dialog_.getEditor().getOptionValueWithKeyword(this.dataTypeOptions, "VALUES").equals(""))) {
                    this.component = new DialogCheckLayoutComboBox(this.functionFieldElement_, this.dataTypeOptions, null, this.dialog_);
                } else if (!this.dialog_.getEditor().getOptionValueWithKeyword(this.dataTypeOptions, "BOOLEAN").equals("")) {
                    this.component = new DialogCheckLayoutCheckBox(this.isEditable, this.dialog_);
                } else if (this.dataType.equals("VARCHAR") || this.dataType.equals("LONG VARCHAR")) {
                    DialogCheckLayoutTextArea textarea = new DialogCheckLayoutTextArea(this.dataSize, this.dataTypeOptions, this.fieldOptions, this.isEditable, this.dialog_);
                    this.fieldRows = textarea.getRows();
                    this.component = textarea;
                } else if (this.dataTypeOptionList.contains("URL")) {
                    this.component = new DialogCheckLayoutUrlField(this.dataSize, this.fieldOptions, this.isEditable, this.dialog_);
                } else if (this.dataTypeOptionList.contains("IMAGE")) {
                    DialogCheckLayoutImageField imagefield = new DialogCheckLayoutImageField(this.fieldOptions, this.dataSize, this.isEditable, this.dialog_);
                    this.fieldRows = imagefield.getRows();
                    this.component = imagefield;
                } else {
                    this.component = this.dataType.equals("DATE") ? new DialogCheckLayoutDateField(this.isEditable, this.dialog_) : (this.dataType.equals("BYTEA") ? new DialogCheckLayoutByteaField(this.dialog_) : (this.dataTypeOptionList.contains("YMONTH") ? new DialogCheckLayoutYMonthBox(this.isEditable, this.dialog_) : (this.dataTypeOptionList.contains("MSEQ") ? new DialogCheckLayoutMSeqBox(this.isEditable, this.dialog_) : (this.dataTypeOptionList.contains("FYEAR") ? new DialogCheckLayoutFYearBox(this.isEditable, this.dialog_) : (this.isAutoDetailRowNumber ? (this.dataSize < 5 ? new DialogCheckLayoutTextField("STRING", 5, 0, "", "", this.isEditable, this.dialog_) : new DialogCheckLayoutTextField("STRING", this.dataSize, 0, "", "", this.isEditable, this.dialog_)) : new DialogCheckLayoutTextField(this.getBasicType(), this.dataSize, this.decimalSize, this.dataTypeOptions, this.fieldOptions, this.isEditable, this.dialog_))))));
                }
            }
        }
        this.component.setBounds(new Rectangle(5, 0, this.component.getPreferredSize().width, this.component.getPreferredSize().height));
        this.jPanelField.setLayout(null);
        this.jPanelField.setPreferredSize(new Dimension(this.component.getPreferredSize().width + 5, this.component.getPreferredSize().height));
        this.jPanelField.add(this.component);
        this.setFocusable(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanelField, "Center");
        if (this.fieldOptionList.contains("NO_CAPTION")) {
            this.setPreferredSize(new Dimension(this.component.getWidth() + 10, this.component.getPreferredSize().height));
        } else {
            this.setPreferredSize(new Dimension(this.component.getWidth() + this.jLabelField.getPreferredSize().width + 10, this.component.getPreferredSize().height));
            this.add((Component)this.jLabelField, "West");
        }
        wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "COMMENT");
        if (!wrkStr.equals("")) {
            this.jLabelFieldComment = new JLabel();
            this.jLabelFieldComment.setText(wrkStr);
            this.jLabelFieldComment.setForeground(Color.blue);
            this.jLabelFieldComment.setFont(new Font(this.dialog_.driverFontName_, 0, 16));
            metrics = this.jLabelFieldComment.getFontMetrics(this.jLabelFieldComment.getFont());
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + metrics.stringWidth(wrkStr) + 6, this.getPreferredSize().height));
        }
        if (this.dataTypeOptionList.contains("ZIPADRS") && isOnEditablePanel && this.isEditable) {
            this.jButtonToRefferZipNo = new JButton();
            this.jButtonToRefferZipNo.setText("<");
            this.jButtonToRefferZipNo.setFont(new Font("SansSerif", 0, 9));
            this.jButtonToRefferZipNo.setPreferredSize(new Dimension(37, this.getPreferredSize().height));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 34, this.getPreferredSize().height));
        }
        if (this.jButtonToRefferZipNo != null || this.jLabelFieldComment != null) {
            this.jPanelFieldComment = new JPanel();
            this.jPanelFieldComment.setLayout(new BorderLayout());
            int width = 2;
            if (this.jButtonToRefferZipNo != null) {
                width += this.jButtonToRefferZipNo.getPreferredSize().width;
            }
            if (this.jLabelFieldComment == null) {
                this.add((Component)this.jButtonToRefferZipNo, "East");
            } else {
                width = width + this.jLabelFieldComment.getPreferredSize().width + 3;
                this.jPanelFieldComment.add((Component)this.jLabelFieldComment, "Center");
                if (this.jButtonToRefferZipNo != null) {
                    this.jPanelFieldComment.add((Component)this.jButtonToRefferZipNo, "West");
                }
                this.jPanelFieldComment.setPreferredSize(new Dimension(width, this.component.getHeight()));
                this.add((Component)this.jPanelFieldComment, "East");
            }
        }
        wrkStr = this.decimalSize > 0 ? "<html>" + this.fieldName + " " + this.dataSourceName + " (" + this.dataSize + "," + this.decimalSize + ")<br>" + this.fieldRemarks : "<html>" + this.fieldName + " " + this.dataSourceName + " (" + this.dataSize + ")<br>" + this.fieldRemarks;
        this.setToolTipText(wrkStr);
        this.component.setToolTipText(wrkStr);
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public int getPositionMargin() {
        return this.positionMargin;
    }

    public int getRows() {
        return this.fieldRows;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getCaption() {
        return this.fieldCaption;
    }

    public String getBasicType() {
        return this.dialog_.getEditor().getBasicTypeOf(this.dataType);
    }

    public ArrayList<String> getTypeOptionList() {
        return this.dataTypeOptionList;
    }

    public ArrayList<String> getFieldOptionList() {
        return this.fieldOptionList;
    }
}

