/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JTextField;
import xeadEditor.DialogCheckLayout;

class DialogCheckLayoutTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private String basicType_ = "";
    private int digits_ = 5;
    private int decimal_ = 0;
    private ArrayList<String> dataTypeOptionList;
    private String fieldOptions_;
    private DialogCheckLayout dialog_;

    public DialogCheckLayoutTextField(String basicType, int digits, int decimal, String dataTypeOptions, String fieldOptions, boolean isEditable, DialogCheckLayout dialog) {
        String wrkStr1;
        this.dialog_ = dialog;
        this.basicType_ = basicType;
        this.digits_ = digits;
        this.decimal_ = decimal;
        this.dataTypeOptionList = this.dialog_.getEditor().getOptionList(dataTypeOptions);
        this.fieldOptions_ = fieldOptions;
        if (this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT")) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setFont(new Font(this.dialog_.driverFontName_, 0, 18));
        this.setFocusable(false);
        String value = "";
        int fieldWidth = 0;
        if (this.dataTypeOptionList.contains("KANJI") || this.dataTypeOptionList.contains("ZIPADRS")) {
            value = this.dialog_.getStringData("KANJI", digits, 0, this.dataTypeOptionList);
            fieldWidth = this.digits_ * 18 + 10;
        } else {
            wrkStr1 = this.dialog_.getEditor().getOptionValueWithKeyword(dataTypeOptions, "KUBUN");
            String wrkStr2 = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions_, "PROMPT_CALL");
            if (!wrkStr1.equals("") && wrkStr2.equals("")) {
                try {
                    FontMetrics metrics = this.getFontMetrics(this.getFont());
                    StringBuffer buf1 = new StringBuffer();
                    buf1.append("select * from ");
                    buf1.append(this.dialog_.getEditor().getSystemUserVariantsTableID());
                    buf1.append(" where IDUSERKUBUN = '");
                    buf1.append(wrkStr1);
                    buf1.append("' order by SQLIST");
                    Connection connection = this.dialog_.getEditor().getDatabaseConnection("");
                    if (connection != null && !connection.isClosed()) {
                        Statement statement = connection.createStatement();
                        ResultSet result = statement.executeQuery(buf1.toString());
                        while (result.next()) {
                            wrkStr1 = result.getString("TXUSERKUBUN").trim();
                            if (metrics.stringWidth(wrkStr1) > fieldWidth) {
                                fieldWidth = metrics.stringWidth(wrkStr1);
                            }
                            if (!value.equals("")) continue;
                            value = wrkStr1;
                        }
                        fieldWidth += 10;
                    }
                }
                catch (Exception exception) {}
            } else if (this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT")) {
                value = this.dialog_.getStringData("NUMBER", digits, this.decimal_, this.dataTypeOptionList);
                fieldWidth = value.length() * 11 + 15;
            } else if (this.basicType_.equals("DATETIME")) {
                value = "9999/99/99 HH:MM:SS.SSS";
                fieldWidth = 264;
            } else {
                value = this.dialog_.getStringData("STRING", digits, 0, this.dataTypeOptionList);
                fieldWidth = this.digits_ * 11 + 10;
            }
        }
        this.setText(value);
        super.setEditable(isEditable);
        if (fieldWidth > 800) {
            fieldWidth = 800;
        }
        int fieldHeight = this.dialog_.getFieldUnitHeight();
        wrkStr1 = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions_, "WIDTH");
        if (!wrkStr1.equals("")) {
            fieldWidth = Integer.parseInt(wrkStr1);
        }
        this.setPreferredSize(new Dimension(fieldWidth, fieldHeight));
    }
}

