/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.undo.UndoManager;
import xeadEditor.DialogAssistList;
import xeadEditor.DialogEditScript_jTextAreaStatement_caretAdapter;
import xeadEditor.DialogEditScript_jTextAreaStatement_keyAdapter;
import xeadEditor.Editor;

public class DialogEditScript
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JPanel jPanelInformation = new JPanel();
    private JPanel jPanelScan = new JPanel();
    private JLabel jLabelScanText = new JLabel();
    private JTextField jTextFieldScanText = new JTextField();
    private JCheckBox jCheckBoxScanText = new JCheckBox();
    private JLabel jLabelReplaceText = new JLabel();
    private JTextField jTextFieldReplaceText = new JTextField();
    private JCheckBox jCheckBoxReplaceAll = new JCheckBox();
    private JLabel jLabelFunctionKeys1 = new JLabel();
    private JLabel jLabelFunctionKeys2 = new JLabel();
    private JLabel jLabelFunctionKeys3 = new JLabel();
    private JPanel jPanelStatement = new JPanel();
    private JPanel jPanelStatementHeader = new JPanel();
    private JLabel jLabelStatementHeader = new JLabel();
    private JLabel jLabelStatementCursorPos = new JLabel();
    private JScrollPane jScrollPaneStatement = new JScrollPane();
    private JTextArea jTextAreaStatement = new JTextArea();
    private JScrollPane jScrollPaneFieldInformation = new JScrollPane();
    private JTextArea jTextAreaFieldInformation = new JTextArea();
    private JSplitPane jSplitPane = new JSplitPane();
    private Editor frame_;
    private Action helpAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.frame_.browseHelp();
        }
    };
    private Action scanAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.frame_.scanStringInTextArea(DialogEditScript.this.jTextAreaStatement, DialogEditScript.this.jTextFieldScanText.getText(), DialogEditScript.this.jCheckBoxScanText.isSelected(), DialogEditScript.this.jTextFieldReplaceText.getText(), DialogEditScript.this.jCheckBoxReplaceAll.isSelected());
        }
    };
    private Action checkAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.frame_.checkSyntaxError(DialogEditScript.this.jTextAreaStatement.getText(), true);
        }
    };
    private Action indentAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.indentRows();
        }
    };
    private Action commentAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.commentRows();
        }
    };
    private Action pasteAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.frame_.pasteTextToIndent(DialogEditScript.this.jScrollPaneStatement);
        }
    };
    private Action undoAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.undo();
        }
    };
    private Action redoAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.redo();
        }
    };
    private Action modeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.changeMode();
        }
    };
    private Action listMethodsAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditScript.this.dialogAssistList.listMethods(DialogEditScript.this.jScrollPaneStatement);
        }
    };
    private String originalText = "";
    private String idModeText = "";
    private String returnText = "";
    private UndoManager undoManager = new UndoManager();
    private DialogAssistList dialogAssistList;

    public DialogEditScript(Editor frame) {
        super(frame, "", true);
        this.frame_ = frame;
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanelStatement.setLayout(new BorderLayout());
        this.jPanelStatement.add((Component)this.jPanelStatementHeader, "North");
        this.jPanelStatement.add((Component)this.jScrollPaneStatement, "Center");
        this.jPanelStatementHeader.setLayout(new BorderLayout());
        this.jPanelStatementHeader.setPreferredSize(new Dimension(200, 25));
        this.jLabelStatementHeader.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelStatementHeader.setText(" " + res.getString("Script"));
        this.jLabelStatementHeader.setPreferredSize(new Dimension(150, 25));
        this.jLabelStatementCursorPos.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelStatementCursorPos.setForeground(Color.darkGray);
        this.jLabelStatementCursorPos.setHorizontalAlignment(0);
        this.jLabelStatementCursorPos.setPreferredSize(new Dimension(80, 25));
        this.jLabelStatementCursorPos.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jPanelStatementHeader.add((Component)this.jLabelStatementHeader, "West");
        this.jPanelStatementHeader.add((Component)this.jLabelStatementCursorPos, "East");
        this.jPanelScan.setPreferredSize(new Dimension(10, 181));
        this.jPanelScan.setLayout(null);
        this.jLabelScanText.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelScanText.setText(res.getString("ScanStringInScript"));
        this.jLabelScanText.setHorizontalAlignment(4);
        this.jLabelScanText.setBounds(new Rectangle(5, 10, 90, 20));
        this.jTextFieldScanText.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldScanText.setBounds(new Rectangle(100, 7, 340, 25));
        this.jTextFieldScanText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getComponent()).selectAll();
            }
        });
        this.jLabelReplaceText.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelReplaceText.setText(res.getString("ReplaceStringInScript"));
        this.jLabelReplaceText.setHorizontalAlignment(4);
        this.jLabelReplaceText.setBounds(new Rectangle(5, 39, 90, 20));
        this.jTextFieldReplaceText.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldReplaceText.setBounds(new Rectangle(100, 36, 340, 25));
        this.jTextFieldReplaceText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getComponent()).selectAll();
            }
        });
        this.jCheckBoxScanText.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxScanText.setBounds(new Rectangle(5, 68, 230, 22));
        this.jCheckBoxScanText.setText(res.getString("CaseSensitive"));
        this.jCheckBoxReplaceAll.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxReplaceAll.setBounds(new Rectangle(240, 68, 230, 22));
        this.jCheckBoxReplaceAll.setText(res.getString("ReplaceAll"));
        this.jLabelFunctionKeys1.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFunctionKeys1.setText(res.getString("ScriptEditorFunctionKeys1"));
        this.jLabelFunctionKeys1.setBounds(new Rectangle(11, 99, 450, 20));
        this.jLabelFunctionKeys2.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFunctionKeys2.setText(res.getString("ScriptEditorFunctionKeys2"));
        this.jLabelFunctionKeys2.setBounds(new Rectangle(11, 125, 450, 20));
        this.jLabelFunctionKeys3.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFunctionKeys3.setText(res.getString("ScriptEditorFunctionKeys3"));
        this.jLabelFunctionKeys3.setBounds(new Rectangle(11, 151, 450, 20));
        this.jPanelScan.add(this.jLabelScanText);
        this.jPanelScan.add(this.jTextFieldScanText);
        this.jPanelScan.add(this.jCheckBoxScanText);
        this.jPanelScan.add(this.jLabelReplaceText);
        this.jPanelScan.add(this.jTextFieldReplaceText);
        this.jPanelScan.add(this.jCheckBoxReplaceAll);
        this.jPanelScan.add(this.jLabelFunctionKeys1);
        this.jPanelScan.add(this.jLabelFunctionKeys2);
        this.jPanelScan.add(this.jLabelFunctionKeys3);
        this.jPanelInformation.setLayout(new BorderLayout());
        this.jPanelInformation.add((Component)this.jScrollPaneFieldInformation, "Center");
        this.jPanelInformation.add((Component)this.jPanelScan, "South");
        this.jScrollPaneFieldInformation.setBorder(BorderFactory.createEtchedBorder());
        this.jTextAreaStatement.setBackground(this.frame_.colorScriptBackground);
        this.jTextAreaStatement.setForeground(this.frame_.colorScriptForeground);
        this.jTextAreaStatement.setCaretColor(this.frame_.colorScriptCaret);
        this.jTextAreaStatement.setEditable(true);
        this.jTextAreaStatement.setOpaque(true);
        this.jTextAreaStatement.setTabSize(4);
        this.jTextAreaStatement.addCaretListener(new DialogEditScript_jTextAreaStatement_caretAdapter(this));
        this.jTextAreaStatement.addKeyListener(new DialogEditScript_jTextAreaStatement_keyAdapter(this));
        this.jTextAreaStatement.getDocument().addUndoableEditListener(this.undoManager);
        ActionMap am = this.jTextAreaStatement.getActionMap();
        am.put("paste-from-clipboard", this.pasteAction);
        this.jScrollPaneStatement.getViewport().setView(this.jTextAreaStatement);
        this.jTextAreaFieldInformation.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaFieldInformation.setEditable(false);
        this.jTextAreaFieldInformation.setOpaque(false);
        this.jScrollPaneFieldInformation.getViewport().add(this.jTextAreaFieldInformation);
        this.jSplitPane.setOrientation(1);
        this.jSplitPane.setDividerLocation(450);
        this.jSplitPane.add((Component)this.jPanelStatement, "right");
        this.jSplitPane.add((Component)this.jPanelInformation, "left");
        InputMap inputMap = this.jSplitPane.getInputMap(1);
        inputMap.clear();
        ActionMap actionMap = this.jSplitPane.getActionMap();
        actionMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(112, 0), "HELP");
        actionMap.put("HELP", this.helpAction);
        inputMap.put(KeyStroke.getKeyStroke(118, 0), "CHECK");
        actionMap.put("CHECK", this.checkAction);
        inputMap.put(KeyStroke.getKeyStroke(114, 0), "SCAN");
        actionMap.put("SCAN", this.scanAction);
        inputMap.put(KeyStroke.getKeyStroke(73, 128), "INDENT");
        actionMap.put("INDENT", this.indentAction);
        inputMap.put(KeyStroke.getKeyStroke(47, 128), "COMMENT");
        actionMap.put("COMMENT", this.commentAction);
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "UNDO");
        actionMap.put("UNDO", this.undoAction);
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "REDO");
        actionMap.put("REDO", this.redoAction);
        inputMap.put(KeyStroke.getKeyStroke(78, 128), "MODE");
        actionMap.put("MODE", this.modeAction);
        inputMap.put(KeyStroke.getKeyStroke(32, 128), "LIST");
        actionMap.put("LIST", this.listMethodsAction);
        this.dialogAssistList = new DialogAssistList(this.frame_, this);
        this.setResizable(true);
        Rectangle screenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int screenWidth = (int)screenRect.getWidth();
        int screenHeight = (int)screenRect.getHeight();
        this.setPreferredSize(new Dimension(screenWidth, screenHeight));
        this.getContentPane().add((Component)this.jSplitPane, "Center");
    }

    public String request(String subtitle, String idText, String fieldInfo, int caretPos, String nameText) {
        this.setTitle(String.valueOf(res.getString("EditTableScriptTitle")) + " - " + subtitle);
        this.jTextAreaFieldInformation.setText(fieldInfo);
        this.jTextAreaFieldInformation.setCaretPosition(0);
        this.originalText = idText;
        this.returnText = idText;
        this.idModeText = idText;
        if (nameText.equals("")) {
            this.jTextAreaStatement.setText(idText);
            this.jTextAreaStatement.setEditable(true);
        } else {
            this.jTextAreaStatement.setText(nameText);
            this.jTextAreaStatement.setEditable(false);
        }
        this.jTextAreaStatement.getCaret().setVisible(true);
        this.jTextAreaStatement.setCaretPosition(caretPos);
        this.jTextAreaStatement.setFont(new Font(this.frame_.scriptFontName, 0, this.frame_.scriptFontSize));
        this.jTextAreaStatement.requestFocus();
        this.undoManager.discardAllEdits();
        super.setVisible(true);
        return this.returnText;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            int rtn = 0;
            String edittedText = "";
            edittedText = this.jTextAreaStatement.isEditable() ? this.jTextAreaStatement.getText() : this.idModeText;
            String scriptError = this.frame_.checkSyntaxError(edittedText, false);
            if (edittedText.equals(this.originalText)) {
                if (scriptError.equals("")) {
                    super.setVisible(false);
                } else {
                    Object[] bts = new Object[]{res.getString("Close"), res.getString("BackToEdit")};
                    rtn = JOptionPane.showOptionDialog(this, String.valueOf(res.getString("ScriptError")) + "\n" + scriptError, res.getString("EditTableScriptTitle"), -1, 1, null, bts, bts[0]);
                    if (rtn == 0) {
                        super.setVisible(false);
                    }
                }
            } else {
                Object[] bts = new Object[]{res.getString("CloseSaving"), res.getString("CloseNotSaving"), res.getString("BackToEdit")};
                rtn = scriptError.equals("") ? JOptionPane.showOptionDialog(this, res.getString("ScriptChangesMessage"), res.getString("EditTableScriptTitle"), -1, 1, null, bts, bts[0]) : JOptionPane.showOptionDialog(this, String.valueOf(res.getString("ScriptError")) + "\n" + scriptError + "\n\n" + res.getString("ScriptChangesMessage"), res.getString("EditTableScriptTitle"), -1, 1, null, bts, bts[0]);
                if (rtn == 0) {
                    this.returnText = edittedText;
                    super.setVisible(false);
                }
                if (rtn == 1) {
                    this.returnText = this.originalText;
                    super.setVisible(false);
                }
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    public boolean isEditable() {
        return this.jTextAreaStatement.isEditable();
    }

    public int getCaretPosition() {
        return this.jTextAreaStatement.getCaretPosition();
    }

    void jTextAreaStatement_caretUpdate(CaretEvent e) {
        this.dialogAssistList.setVisible(false);
        if (this.jTextAreaStatement.isEditable()) {
            Point pos = this.frame_.getCaretPositionInText(this.jTextAreaStatement);
            this.jLabelStatementCursorPos.setText(String.valueOf(pos.x) + " : " + pos.y);
        } else {
            this.jLabelStatementCursorPos.setText("NAME");
        }
    }

    public void indentRows() {
        this.frame_.indentRows(this.jScrollPaneStatement);
    }

    public void commentRows() {
        this.frame_.commentRows(this.jScrollPaneStatement);
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
            if (this.jTextAreaStatement.getText().equals("") && this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void changeMode() {
        int caretPos = this.jTextAreaStatement.getCaretPosition();
        String text = this.jTextAreaStatement.getText().substring(0, caretPos);
        int pos = 0;
        int rowsOfCursor = 0;
        while (pos > -1) {
            if ((pos = text.indexOf("\n", pos)) <= -1) continue;
            ++pos;
            ++rowsOfCursor;
        }
        if (this.jTextAreaStatement.isEditable()) {
            this.jTextAreaStatement.setEditable(false);
            this.jLabelStatementCursorPos.setText("NAME");
            String nameModeText = this.idModeText = this.jTextAreaStatement.getText();
            int i = 0;
            while (i < this.frame_.dataSourceIDList.size()) {
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".value", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".value");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".prompter", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".prompter");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".oldValue", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".oldValue");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".valueChanged", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".valueChanged");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".color", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".color");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".editable", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".editable");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".enabled", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".enabled");
                nameModeText = nameModeText.replaceAll(String.valueOf(this.frame_.dataSourceAliasList.get(i)) + "_" + this.frame_.dataSourceIDList.get(i) + ".error", String.valueOf(this.frame_.dataSourceAliasNameList.get(i)) + "_" + this.frame_.dataSourceNameList.get(i) + ".error");
                ++i;
            }
            nameModeText = this.frame_.translateTableOperationInScript(nameModeText);
            this.jTextAreaStatement.setText(nameModeText);
        } else {
            this.jTextAreaStatement.setEditable(true);
            this.jTextAreaStatement.setText(this.idModeText);
        }
        text = this.jTextAreaStatement.getText();
        pos = 0;
        int wrkInt = 0;
        while (wrkInt < rowsOfCursor) {
            pos = text.indexOf("\n", pos);
            ++pos;
            ++wrkInt;
        }
        this.jTextAreaStatement.setCaretPosition(pos);
        this.jTextAreaStatement.getCaret().setVisible(true);
    }

    void jTextAreaStatement_keyTyped(KeyEvent e) {
        if ((e.getModifiersEx() & 0x80) == 0 && !this.jTextAreaStatement.isEditable()) {
            int position = this.jTextAreaStatement.getCaretPosition();
            JOptionPane.showMessageDialog(null, res.getString("ErrorMessage128"));
            this.jTextAreaStatement.setCaretPosition(position);
            this.jTextAreaStatement.getCaret().setVisible(true);
        }
    }
}

