/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogEditTableKeyFields_jButtonCloseDialog_actionAdapter;
import xeadEditor.DialogEditTableKeyFields_jButtonOperateField_actionAdapter;
import xeadEditor.DialogEditTableKeyFields_jButtonReturn_actionAdapter;
import xeadEditor.DialogEditTableKeyFields_jMenuItemToRemove_actionAdapter;
import xeadEditor.DialogEditTableKeyFields_jMenuItemToSetAscDesc_actionAdapter;
import xeadEditor.DialogEditTableKeyFields_jTableFieldList_listSelectionAdapter;
import xeadEditor.DialogEditTableKeyFields_jTableKeyFieldList_listSelectionAdapter;
import xeadEditor.DialogEditTableKeyFields_jTableKeyFieldList_mouseAdapter;
import xeadEditor.DialogEditTableKeyFields_jTableKeyFieldList_mouseMotionAdapter;
import xeadEditor.Editor;

public class DialogEditTableKeyFields
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private Editor frame_;
    private BorderLayout borderLayoutMain = new BorderLayout();
    private JPanel panelMain = new JPanel();
    private JScrollPane jScrollPaneFieldList = new JScrollPane();
    private TableModelReadOnlyList tableModelFieldList = new TableModelReadOnlyList();
    private JTable jTableFieldList = new JTable(this.tableModelFieldList);
    private JScrollPane jScrollPaneKeyFieldList = new JScrollPane();
    private TableModelReadOnlyList tableModelKeyFieldList = new TableModelReadOnlyList();
    private JTable jTableKeyFieldList = new JTable(this.tableModelKeyFieldList);
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private DefaultTableCellRenderer rendererTableHeader = null;
    private DefaultTableCellRenderer rendererAlignmentCenter = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentLeft = new DefaultTableCellRenderer();
    private JPanel jPanelButtons = new JPanel();
    private JButton jButtonCloseDialog = new JButton();
    private JButton jButtonOperateField = new JButton();
    private JButton jButtonReturn = new JButton();
    private JPopupMenu jPopupMenu = new JPopupMenu();
    private JMenuItem jMenuItemToSetAscDesc = new JMenuItem();
    private JMenuItem jMenuItemToRemove = new JMenuItem();
    private ArrayList<String> currentKeyFieldIDList = new ArrayList();
    private ArrayList<String> currentKeyFieldAscDescList = new ArrayList();
    private String edittedKeyFields = "";
    private Editor.SortableDomElementListModel fieldSortingList;
    private Element tableElement_;
    private String keyType_;
    private boolean isTableBeingSetup = false;
    private int dragObjectRow = 0;
    private int dragTargetRow = 0;

    public DialogEditTableKeyFields(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogEditTableKeyFields(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.panelMain.setBorder(null);
        this.panelMain.setLayout(this.borderLayoutMain);
        this.panelMain.add((Component)this.jScrollPaneFieldList, "North");
        this.panelMain.add((Component)this.jPanelButtons, "South");
        this.panelMain.add((Component)this.jScrollPaneKeyFieldList, "Center");
        this.jTableFieldList.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableFieldList.setBackground(SystemColor.control);
        this.jTableFieldList.setAutoResizeMode(0);
        this.jTableFieldList.setSelectionMode(0);
        this.jTableFieldList.getSelectionModel().addListSelectionListener(new DialogEditTableKeyFields_jTableFieldList_listSelectionAdapter(this));
        this.jTableFieldList.setRowSelectionAllowed(true);
        this.jTableFieldList.setRowHeight(24);
        this.tableModelFieldList.addColumn("No.");
        this.tableModelFieldList.addColumn(res.getString("FieldID"));
        this.tableModelFieldList.addColumn(res.getString("FieldName"));
        this.column0 = this.jTableFieldList.getColumnModel().getColumn(0);
        this.column1 = this.jTableFieldList.getColumnModel().getColumn(1);
        this.column2 = this.jTableFieldList.getColumnModel().getColumn(2);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(360);
        this.column2.setPreferredWidth(360);
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableFieldList.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableFieldList.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jScrollPaneFieldList.getViewport().add((Component)this.jTableFieldList, null);
        this.jScrollPaneFieldList.setPreferredSize(new Dimension(100, 300));
        this.jTableKeyFieldList.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableKeyFieldList.setBackground(SystemColor.control);
        this.jTableKeyFieldList.setAutoResizeMode(0);
        this.jTableKeyFieldList.setSelectionMode(0);
        this.jTableKeyFieldList.getSelectionModel().addListSelectionListener(new DialogEditTableKeyFields_jTableKeyFieldList_listSelectionAdapter(this));
        this.jTableKeyFieldList.addMouseListener(new DialogEditTableKeyFields_jTableKeyFieldList_mouseAdapter(this));
        this.jTableKeyFieldList.addMouseMotionListener(new DialogEditTableKeyFields_jTableKeyFieldList_mouseMotionAdapter(this));
        this.jTableKeyFieldList.setRowSelectionAllowed(true);
        this.jTableKeyFieldList.setRowHeight(24);
        this.tableModelKeyFieldList.addColumn("No.");
        this.tableModelKeyFieldList.addColumn(res.getString("KeyFieldID"));
        this.tableModelKeyFieldList.addColumn(res.getString("KeyFieldName"));
        this.tableModelKeyFieldList.addColumn("A/D");
        this.column0 = this.jTableKeyFieldList.getColumnModel().getColumn(0);
        this.column1 = this.jTableKeyFieldList.getColumnModel().getColumn(1);
        this.column2 = this.jTableKeyFieldList.getColumnModel().getColumn(2);
        this.column3 = this.jTableKeyFieldList.getColumnModel().getColumn(3);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(335);
        this.column2.setPreferredWidth(335);
        this.column3.setPreferredWidth(50);
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentCenter);
        this.jTableKeyFieldList.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableKeyFieldList.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jScrollPaneKeyFieldList.getViewport().add((Component)this.jTableKeyFieldList, null);
        this.jPanelButtons.setBorder(null);
        this.jPanelButtons.setPreferredSize(new Dimension(100, 43));
        this.jButtonCloseDialog.setBounds(new Rectangle(40, 8, 100, 27));
        this.jButtonCloseDialog.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCloseDialog.setText(res.getString("Close"));
        this.jButtonCloseDialog.addActionListener(new DialogEditTableKeyFields_jButtonCloseDialog_actionAdapter(this));
        this.jButtonOperateField.setBounds(new Rectangle(300, 8, 200, 27));
        this.jButtonOperateField.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonOperateField.setText(res.getString("EditKeyFieldsToPutIntoKey"));
        this.jButtonOperateField.addActionListener(new DialogEditTableKeyFields_jButtonOperateField_actionAdapter(this));
        this.jButtonReturn.setBounds(new Rectangle(660, 8, 100, 27));
        this.jButtonReturn.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonReturn.setText("OK");
        this.jButtonReturn.addActionListener(new DialogEditTableKeyFields_jButtonReturn_actionAdapter(this));
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.add(this.jButtonCloseDialog);
        this.jPanelButtons.add(this.jButtonOperateField);
        this.jPanelButtons.add(this.jButtonReturn);
        this.jMenuItemToSetAscDesc.setText(res.getString("EditKeyFieldsToSetAscDesc"));
        this.jMenuItemToSetAscDesc.addActionListener(new DialogEditTableKeyFields_jMenuItemToSetAscDesc_actionAdapter(this));
        this.jMenuItemToRemove.setText(res.getString("EditKeyFieldsToRemove"));
        this.jMenuItemToRemove.addActionListener(new DialogEditTableKeyFields_jMenuItemToRemove_actionAdapter(this));
        this.jPopupMenu.add(this.jMenuItemToSetAscDesc);
        this.jPopupMenu.addSeparator();
        this.jPopupMenu.add(this.jMenuItemToRemove);
        this.setResizable(false);
        this.setTitle(res.getString("AddKeyMessage"));
        this.getContentPane().add(this.panelMain);
        this.setPreferredSize(new Dimension(800, 600));
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public String request(Element tableElement, String keyType, String keyFields) {
        this.dragObjectRow = -1;
        this.dragTargetRow = -1;
        this.tableElement_ = tableElement;
        this.keyType_ = keyType;
        this.edittedKeyFields = keyFields;
        this.currentKeyFieldIDList.clear();
        this.currentKeyFieldAscDescList.clear();
        StringTokenizer workTokenizer = new StringTokenizer(keyFields, ";");
        while (workTokenizer.hasMoreTokens()) {
            String fieldID = workTokenizer.nextToken();
            if (this.keyType_.equals("XK")) {
                if (fieldID.contains("(D)")) {
                    fieldID = fieldID.replace("(D)", "");
                    this.currentKeyFieldAscDescList.add("D");
                } else {
                    this.currentKeyFieldAscDescList.add("A");
                }
            } else {
                this.currentKeyFieldAscDescList.add("-");
            }
            this.currentKeyFieldIDList.add(fieldID);
        }
        NodeList nodeList = this.tableElement_.getElementsByTagName("Field");
        this.fieldSortingList = this.frame_.getSortedListModel(nodeList, "Order");
        this.setupFields();
        this.jButtonOperateField.setEnabled(false);
        if (this.tableModelFieldList.getRowCount() > 0 && this.tableModelKeyFieldList.getRowCount() == 0) {
            this.jTableFieldList.setRowSelectionInterval(0, 0);
            this.jTableFieldList.requestFocus();
        }
        super.setVisible(true);
        return this.edittedKeyFields;
    }

    void setupFields() {
        Element element;
        int rowCount;
        this.isTableBeingSetup = true;
        if (this.tableModelFieldList.getRowCount() > 0) {
            rowCount = this.tableModelFieldList.getRowCount();
            int i = 0;
            while (i < rowCount) {
                this.tableModelFieldList.removeRow(0);
                ++i;
            }
        }
        int rowNumber = 1;
        int i = 0;
        while (i < this.fieldSortingList.getSize()) {
            element = (Element)this.fieldSortingList.getElementAt(i);
            if (!this.frame_.getOptionList(element.getAttribute("TypeOptions")).contains("VIRTUAL") && !this.currentKeyFieldIDList.contains(element.getAttribute("ID"))) {
                Object[] Cell = new Object[]{rowNumber++, element.getAttribute("ID"), element.getAttribute("Name")};
                this.tableModelFieldList.addRow(Cell);
            }
            ++i;
        }
        if (this.tableModelKeyFieldList.getRowCount() > 0) {
            rowCount = this.tableModelKeyFieldList.getRowCount();
            int i2 = 0;
            while (i2 < rowCount) {
                this.tableModelKeyFieldList.removeRow(0);
                ++i2;
            }
        }
        rowNumber = 1;
        i = 0;
        while (i < this.currentKeyFieldIDList.size()) {
            int j = 0;
            while (j < this.fieldSortingList.getSize()) {
                element = (Element)this.fieldSortingList.getElementAt(j);
                if (element.getAttribute("ID").equals(this.currentKeyFieldIDList.get(i))) {
                    Object[] Cell = new Object[]{rowNumber++, element.getAttribute("ID"), element.getAttribute("Name"), this.currentKeyFieldAscDescList.get(i)};
                    this.tableModelKeyFieldList.addRow(Cell);
                }
                ++j;
            }
            ++i;
        }
        this.isTableBeingSetup = false;
    }

    void jTableFieldList_valueChanged() {
        if (this.jTableFieldList.getSelectedRowCount() > 0 && !this.isTableBeingSetup) {
            this.jTableKeyFieldList.clearSelection();
            this.jButtonOperateField.setEnabled(true);
            this.jButtonOperateField.setText(res.getString("EditKeyFieldsToPutIntoKey"));
        }
    }

    void jTableKeyFieldList_valueChanged() {
        if (this.jTableKeyFieldList.getSelectedRowCount() > 0 && !this.isTableBeingSetup) {
            this.jTableFieldList.clearSelection();
            this.jButtonOperateField.setEnabled(true);
            this.jButtonOperateField.setText(res.getString("EditKeyFieldsToRemoveFromKey"));
        }
    }

    void jButtonCloseDialog_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jButtonOperateField_actionPerformed(ActionEvent e) {
        if (this.jButtonOperateField.getText().equals(res.getString("EditKeyFieldsToRemoveFromKey"))) {
            this.jMenuItemToRemove_actionPerformed(null);
        } else {
            int wrkInt = this.jTableFieldList.getSelectedRow();
            String fieldID = this.tableModelFieldList.getValueAt(wrkInt, 1).toString();
            this.currentKeyFieldIDList.add(fieldID);
            if (this.keyType_.equals("XK")) {
                this.currentKeyFieldAscDescList.add("A");
            } else {
                this.currentKeyFieldAscDescList.add("-");
            }
            this.setupFields();
            if (this.tableModelFieldList.getRowCount() > wrkInt) {
                this.jTableFieldList.setRowSelectionInterval(wrkInt, wrkInt);
                this.jTableFieldList.requestFocus();
            } else if (this.tableModelFieldList.getRowCount() > 0) {
                this.jTableFieldList.setRowSelectionInterval(this.tableModelFieldList.getRowCount() - 1, this.tableModelFieldList.getRowCount() - 1);
                this.jTableFieldList.requestFocus();
            } else {
                this.jButtonOperateField.setEnabled(false);
            }
        }
    }

    void jTableKeyFieldList_mousePressed(MouseEvent e) {
        try {
            if ((e.getModifiers() & 0x10) == 16) {
                this.dragTargetRow = this.dragObjectRow = this.jTableKeyFieldList.rowAtPoint(e.getPoint());
                this.jTableKeyFieldList.setRowSelectionInterval(this.dragObjectRow, this.dragObjectRow);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
            e1.printStackTrace();
        }
    }

    void jTableKeyFieldList_mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 16 && this.jTableKeyFieldList.getRowCount() > 1) {
            this.jTableKeyFieldList.setRowSelectionAllowed(false);
            this.dragTargetRow = this.jTableKeyFieldList.rowAtPoint(e.getPoint());
            if (this.dragTargetRow == -1) {
                this.dragTargetRow = this.jTableKeyFieldList.getRowCount() - 1;
            }
            Rectangle cellRec1 = this.jTableKeyFieldList.getCellRect(this.dragObjectRow, this.dragObjectRow, false);
            Rectangle listRec = this.jTableKeyFieldList.getBounds();
            Graphics2D g2 = (Graphics2D)this.jTableKeyFieldList.getGraphics();
            g2.setColor(this.jTableKeyFieldList.getSelectionBackground());
            g2.drawRect(0, cellRec1.y, listRec.width, cellRec1.height);
            g2.drawRect(1, cellRec1.y + 1, listRec.width - 2, cellRec1.height - 2);
            if (this.dragTargetRow != this.dragObjectRow) {
                Rectangle cellRec2 = this.jTableKeyFieldList.getCellRect(this.dragTargetRow, this.dragTargetRow, false);
                g2.setColor(Color.cyan);
                g2.fillRect(0, cellRec2.y + cellRec2.height - 3, listRec.width, 3);
                this.setCursor(DragSource.DefaultMoveDrop);
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    void jTableKeyFieldList_mouseReleased(MouseEvent e) {
        this.jTableKeyFieldList.setRowSelectionAllowed(true);
        if ((e.getModifiers() & 0x10) == 16) {
            try {
                this.setCursor(new Cursor(3));
                if (this.dragTargetRow != this.dragObjectRow && this.dragObjectRow != -1) {
                    ArrayList<String> workFieldIDList = new ArrayList<String>();
                    ArrayList<String> workAscDescList = new ArrayList<String>();
                    String objectRowFieldID = this.currentKeyFieldIDList.get(this.dragObjectRow);
                    String objectRowAscDesc = this.currentKeyFieldAscDescList.get(this.dragObjectRow);
                    int i = 0;
                    while (i < this.currentKeyFieldIDList.size()) {
                        if (i != this.dragObjectRow) {
                            workFieldIDList.add(this.currentKeyFieldIDList.get(i));
                            workAscDescList.add(this.currentKeyFieldAscDescList.get(i));
                        }
                        if (i == this.dragTargetRow) {
                            workFieldIDList.add(objectRowFieldID);
                            workAscDescList.add(objectRowAscDesc);
                        }
                        ++i;
                    }
                    this.currentKeyFieldIDList = workFieldIDList;
                    this.currentKeyFieldAscDescList = workAscDescList;
                    this.setupFields();
                    int workIndex = this.currentKeyFieldIDList.indexOf(objectRowFieldID);
                    this.jTableKeyFieldList.setRowSelectionInterval(workIndex, workIndex);
                    this.dragObjectRow = -1;
                    this.dragTargetRow = -1;
                }
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
    }

    void jMenuItemToSetAscDesc_actionPerformed(ActionEvent e) {
        int wrkInt = this.jTableKeyFieldList.getSelectedRow();
        if (this.keyType_.equals("XK")) {
            if (this.currentKeyFieldAscDescList.get(wrkInt).equals("A")) {
                this.currentKeyFieldAscDescList.set(wrkInt, "D");
            } else {
                this.currentKeyFieldAscDescList.set(wrkInt, "A");
            }
        }
        this.setupFields();
    }

    void jMenuItemToRemove_actionPerformed(ActionEvent e) {
        int wrkInt = this.jTableKeyFieldList.getSelectedRow();
        this.currentKeyFieldIDList.remove(wrkInt);
        this.currentKeyFieldAscDescList.remove(wrkInt);
        this.setupFields();
        if (this.tableModelKeyFieldList.getRowCount() > wrkInt) {
            this.jTableKeyFieldList.setRowSelectionInterval(wrkInt, wrkInt);
            this.jTableKeyFieldList.requestFocus();
        } else if (this.tableModelKeyFieldList.getRowCount() > 0) {
            this.jTableKeyFieldList.setRowSelectionInterval(this.tableModelKeyFieldList.getRowCount() - 1, this.tableModelKeyFieldList.getRowCount() - 1);
            this.jTableKeyFieldList.requestFocus();
        } else {
            this.jButtonOperateField.setEnabled(false);
            this.jTableKeyFieldList.clearSelection();
        }
    }

    void jButtonReturn_actionPerformed(ActionEvent e) {
        StringBuffer bf = new StringBuffer();
        int i = 0;
        while (i < this.currentKeyFieldIDList.size()) {
            if (bf.length() > 0) {
                bf.append(";");
            }
            bf.append(this.currentKeyFieldIDList.get(i));
            if (this.keyType_.equals("XK") && this.currentKeyFieldAscDescList.get(i).equals("D")) {
                bf.append("(D)");
            }
            ++i;
        }
        this.edittedKeyFields = bf.toString();
        this.setVisible(false);
    }

    void jTableKeyFieldList_mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 16) {
            int selectedRow = this.jTableKeyFieldList.rowAtPoint(e.getPoint());
            this.jTableKeyFieldList.setRowSelectionInterval(selectedRow, selectedRow);
            if (this.keyType_.equals("XK")) {
                this.jMenuItemToSetAscDesc.setEnabled(true);
            } else {
                this.jMenuItemToSetAscDesc.setEnabled(false);
            }
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class TableModelReadOnlyList
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelReadOnlyList() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

