/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xeadEditor.DialogImportModel_jButtonCloseDialog_actionAdapter;
import xeadEditor.DialogImportModel_jButtonImport_actionAdapter;
import xeadEditor.DialogImportModel_jButtonRefresh_actionAdapter;
import xeadEditor.DialogImportModel_jComboBoxSubsystemFrom_actionAdapter;
import xeadEditor.DialogImportModel_jTableElementListFrom_listSelectionAdapter;
import xeadEditor.Editor;

public class DialogImportModel
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private Editor frame_;
    private JPanel panelMain = new JPanel();
    private JPanel jPanelNorth = new JPanel();
    private JPanel jPanelCenter = new JPanel();
    private JPanel jPanelCenterTop = new JPanel();
    private JPanel jPanelSouth = new JPanel();
    private JScrollPane jScrollPaneElementListFrom = new JScrollPane();
    private TableModelReadOnlyList tableModelElementListFrom = new TableModelReadOnlyList();
    private JTable jTableElementListFrom = new JTable(this.tableModelElementListFrom);
    private JLabel jLabelSubsystemFrom = new JLabel();
    private JComboBox<String> jComboBoxSubsystemFrom = new JComboBox();
    private JCheckBox jCheckBoxOverrideID = new JCheckBox();
    private JScrollPane jScrollPaneMessage = new JScrollPane();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JLabel jLabelFileNameFrom = new JLabel();
    private JTextField jTextFieldFileNameFrom = new JTextField();
    private JLabel jLabelSystemNameFrom = new JLabel();
    private JTextField jTextFieldSystemNameFrom = new JTextField();
    private JLabel jLabelSystemVersionFrom = new JLabel();
    private JTextField jTextFieldSystemVersionFrom = new JTextField();
    private ArrayList<Element> subsystemNodeListFrom = null;
    private NodeList dataTypeNodeListFrom = null;
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private TableColumn column4;
    private DefaultTableCellRenderer rendererAlignmentCenter = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentRight = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentLeft = new DefaultTableCellRenderer();
    private JButton jButtonCloseDialog = new JButton();
    private JButton jButtonImport = new JButton();
    private JButton jButtonRefresh = new JButton();
    private Document domDocumentImportingFrom = null;
    private NodeList functionTypeList = null;
    private NodeList currentFunctionList = null;
    private NodeList currentTableList = null;
    private NodeList tableListInModel = null;
    private NodeList functionListInModel = null;
    private ArrayList<String> newlyAddedTableIDList = new ArrayList();
    private ArrayList<String> newlyAddedFunctionIDList = new ArrayList();
    private boolean isListBeingRebuild = false;
    private boolean isToConvertCamel = true;
    private boolean isToUseTableNameToCreateTable = false;
    private Element subsystemElementFrom = null;

    public DialogImportModel(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogImportModel(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(new BorderLayout());
        this.panelMain.setPreferredSize(new Dimension(850, 750));
        this.panelMain.setBorder(BorderFactory.createEtchedBorder());
        this.panelMain.add((Component)this.jPanelNorth, "North");
        this.panelMain.add((Component)this.jPanelCenter, "Center");
        this.panelMain.add((Component)this.jPanelSouth, "South");
        this.jPanelNorth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelNorth.setPreferredSize(new Dimension(800, 74));
        this.jLabelFileNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFileNameFrom.setHorizontalAlignment(4);
        this.jLabelFileNameFrom.setHorizontalTextPosition(10);
        this.jLabelFileNameFrom.setText(res.getString("FileNameImporting"));
        this.jLabelFileNameFrom.setBounds(new Rectangle(5, 12, 180, 20));
        this.jTextFieldFileNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldFileNameFrom.setBounds(new Rectangle(190, 9, 625, 25));
        this.jTextFieldFileNameFrom.setEditable(false);
        this.jLabelSystemNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSystemNameFrom.setHorizontalAlignment(4);
        this.jLabelSystemNameFrom.setHorizontalTextPosition(10);
        this.jLabelSystemNameFrom.setText(res.getString("SystemNameImporting"));
        this.jLabelSystemNameFrom.setBounds(new Rectangle(5, 43, 180, 20));
        this.jTextFieldSystemNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldSystemNameFrom.setBounds(new Rectangle(190, 40, 380, 25));
        this.jTextFieldSystemNameFrom.setEditable(false);
        this.jLabelSystemVersionFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSystemVersionFrom.setHorizontalAlignment(4);
        this.jLabelSystemVersionFrom.setHorizontalTextPosition(10);
        this.jLabelSystemVersionFrom.setText(res.getString("SystemVersion"));
        this.jLabelSystemVersionFrom.setBounds(new Rectangle(580, 43, 130, 20));
        this.jTextFieldSystemVersionFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldSystemVersionFrom.setBounds(new Rectangle(715, 40, 100, 25));
        this.jTextFieldSystemVersionFrom.setEditable(false);
        this.jPanelNorth.setLayout(null);
        this.jPanelNorth.add(this.jLabelFileNameFrom);
        this.jPanelNorth.add(this.jTextFieldFileNameFrom);
        this.jPanelNorth.add(this.jLabelSystemNameFrom);
        this.jPanelNorth.add(this.jTextFieldSystemNameFrom);
        this.jPanelNorth.add(this.jLabelSystemVersionFrom);
        this.jPanelNorth.add(this.jTextFieldSystemVersionFrom);
        this.jLabelSubsystemFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSubsystemFrom.setHorizontalAlignment(4);
        this.jLabelSubsystemFrom.setHorizontalTextPosition(10);
        this.jLabelSubsystemFrom.setText(res.getString("SubsystemImportingFrom"));
        this.jLabelSubsystemFrom.setBounds(new Rectangle(5, 12, 180, 20));
        this.jComboBoxSubsystemFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jComboBoxSubsystemFrom.setBounds(new Rectangle(190, 9, 330, 25));
        this.jComboBoxSubsystemFrom.addActionListener(new DialogImportModel_jComboBoxSubsystemFrom_actionAdapter(this));
        this.jCheckBoxOverrideID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxOverrideID.setBounds(new Rectangle(540, 9, 200, 25));
        this.jCheckBoxOverrideID.setText(res.getString("OverrideID"));
        this.jPanelCenterTop.setPreferredSize(new Dimension(100, 43));
        this.jPanelCenterTop.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelCenterTop.setLayout(null);
        this.jPanelCenterTop.add(this.jLabelSubsystemFrom);
        this.jPanelCenterTop.add(this.jComboBoxSubsystemFrom);
        this.jPanelCenterTop.add(this.jCheckBoxOverrideID);
        this.jScrollPaneElementListFrom.getViewport().add((Component)this.jTableElementListFrom, null);
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setWrapStyleWord(true);
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setBackground(SystemColor.control);
        this.jScrollPaneMessage.setPreferredSize(new Dimension(800, 170));
        this.jScrollPaneMessage.getViewport().add((Component)this.jTextAreaMessage, null);
        this.jPanelCenter.setLayout(new BorderLayout());
        this.jPanelCenter.add((Component)this.jPanelCenterTop, "North");
        this.jPanelCenter.add((Component)this.jScrollPaneElementListFrom, "Center");
        this.jPanelCenter.add((Component)this.jScrollPaneMessage, "South");
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentRight.setHorizontalAlignment(4);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.jTableElementListFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableElementListFrom.setBackground(SystemColor.control);
        this.jTableElementListFrom.setAutoResizeMode(0);
        this.jTableElementListFrom.setSelectionMode(0);
        this.jTableElementListFrom.getSelectionModel().addListSelectionListener(new DialogImportModel_jTableElementListFrom_listSelectionAdapter(this));
        this.jTableElementListFrom.setRowSelectionAllowed(true);
        this.jTableElementListFrom.setRowHeight(24);
        this.tableModelElementListFrom.addColumn("No.");
        this.tableModelElementListFrom.addColumn("ID");
        this.tableModelElementListFrom.addColumn(res.getString("ElementName"));
        this.tableModelElementListFrom.addColumn(res.getString("ElementType"));
        this.tableModelElementListFrom.addColumn(res.getString("ElementStatus"));
        this.column0 = this.jTableElementListFrom.getColumnModel().getColumn(0);
        this.column1 = this.jTableElementListFrom.getColumnModel().getColumn(1);
        this.column2 = this.jTableElementListFrom.getColumnModel().getColumn(2);
        this.column3 = this.jTableElementListFrom.getColumnModel().getColumn(3);
        this.column4 = this.jTableElementListFrom.getColumnModel().getColumn(4);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(120);
        this.column2.setPreferredWidth(310);
        this.column3.setPreferredWidth(245);
        this.column4.setPreferredWidth(95);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentLeft);
        this.column4.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableElementListFrom.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jPanelSouth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSouth.setPreferredSize(new Dimension(800, 43));
        this.jButtonCloseDialog.setBounds(new Rectangle(20, 8, 100, 27));
        this.jButtonCloseDialog.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCloseDialog.setText(res.getString("Close"));
        this.jButtonCloseDialog.addActionListener(new DialogImportModel_jButtonCloseDialog_actionAdapter(this));
        this.jButtonImport.setBounds(new Rectangle(300, 8, 200, 27));
        this.jButtonImport.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonImport.setText(res.getString("Import"));
        this.jButtonImport.addActionListener(new DialogImportModel_jButtonImport_actionAdapter(this));
        this.jButtonImport.setEnabled(false);
        this.jButtonImport.setFocusCycleRoot(true);
        this.jButtonRefresh.setBounds(new Rectangle(680, 8, 150, 27));
        this.jButtonRefresh.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonRefresh.setText(res.getString("Refresh"));
        this.jButtonRefresh.addActionListener(new DialogImportModel_jButtonRefresh_actionAdapter(this));
        this.jButtonRefresh.setEnabled(false);
        this.jPanelSouth.setLayout(null);
        this.jPanelSouth.add(this.jButtonCloseDialog);
        this.jPanelSouth.add(this.jButtonImport);
        this.jPanelSouth.add(this.jButtonRefresh);
        this.setTitle(res.getString("ImportDialogModelTitle"));
        this.setResizable(false);
        this.getContentPane().add(this.panelMain);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public boolean request(String fileName) {
        try {
            this.isListBeingRebuild = false;
            this.newlyAddedTableIDList.clear();
            this.newlyAddedFunctionIDList.clear();
            this.jTextAreaMessage.setText(res.getString("ImportModelMessage0"));
            this.jButtonImport.setEnabled(false);
            this.subsystemElementFrom = null;
            this.jTextFieldFileNameFrom.setText(fileName);
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(fileName)));
            this.domDocumentImportingFrom = parser.getDocument();
            NodeList nodeList = this.domDocumentImportingFrom.getElementsByTagName("System");
            Element systemElementImportFrom = (Element)nodeList.item(0);
            this.isToConvertCamel = !systemElementImportFrom.getAttribute("DDLConvertCamel").equals("false");
            if (systemElementImportFrom.getAttribute("UseTableNameToCreateTable").equals("true")) {
                this.isToUseTableNameToCreateTable = true;
            }
            this.jTextFieldSystemNameFrom.setText(systemElementImportFrom.getAttribute("Name"));
            this.jTextFieldSystemVersionFrom.setText(systemElementImportFrom.getAttribute("Version"));
            this.functionTypeList = this.domDocumentImportingFrom.getElementsByTagName("FunctionType");
            this.currentTableList = this.frame_.getDomDocument().getElementsByTagName("Table");
            this.currentFunctionList = this.frame_.getDomDocument().getElementsByTagName("Function");
            this.tableListInModel = this.domDocumentImportingFrom.getElementsByTagName("Table");
            this.functionListInModel = this.domDocumentImportingFrom.getElementsByTagName("Function");
            this.jComboBoxSubsystemFrom.removeAllItems();
            this.jComboBoxSubsystemFrom.addItem(res.getString("SelectFromList"));
            this.dataTypeNodeListFrom = this.domDocumentImportingFrom.getElementsByTagName("DataType");
            this.subsystemNodeListFrom = new ArrayList();
            this.subsystemNodeListFrom.add(null);
            NodeList nodelist = this.domDocumentImportingFrom.getElementsByTagName("Subsystem");
            Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodelist, "SortKey");
            int i = 0;
            while (i < sortingList.getSize()) {
                Element element = (Element)sortingList.getElementAt(i);
                this.jComboBoxSubsystemFrom.addItem(String.valueOf(element.getAttribute("SortKey")) + " " + element.getAttribute("Name"));
                this.subsystemNodeListFrom.add(element);
                ++i;
            }
            super.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, String.valueOf(res.getString("FailedToParse")) + "\n\n" + e.getMessage());
            e.printStackTrace();
        }
        return this.newlyAddedTableIDList.size() > 0 || this.newlyAddedFunctionIDList.size() > 0;
    }

    private String convertCamelNotation(String originalText) {
        StringBuffer bf = new StringBuffer();
        String currLetter = "";
        String nextLetter = "";
        if (this.isToConvertCamel) {
            if (originalText.equals(originalText.toUpperCase())) {
                return originalText;
            }
            int i = 0;
            while (i < originalText.length()) {
                currLetter = originalText.substring(i, i + 1);
                nextLetter = i < originalText.length() - 1 ? originalText.substring(i + 1, i + 2) : "";
                if (!currLetter.equals("") && !currLetter.equals("\u3000")) {
                    if (i > 0 && currLetter.equals(currLetter.toUpperCase()) && !nextLetter.equals(nextLetter.toUpperCase())) {
                        bf.append("_");
                    }
                    bf.append(currLetter.toUpperCase());
                }
                ++i;
            }
        } else {
            return originalText;
        }
        return bf.toString();
    }

    public void jComboBoxSubsystemFrom_actionPerformed(ActionEvent e) {
        block17: {
            this.isListBeingRebuild = true;
            this.subsystemElementFrom = null;
            String subsystemID = "";
            this.jButtonRefresh.setEnabled(false);
            this.jButtonImport.setEnabled(false);
            if (this.subsystemNodeListFrom != null && this.jComboBoxSubsystemFrom.getSelectedIndex() >= 0) {
                try {
                    try {
                        this.setCursor(new Cursor(3));
                        if (this.tableModelElementListFrom.getRowCount() > 0) {
                            int rowCount = this.tableModelElementListFrom.getRowCount();
                            int i = 0;
                            while (i < rowCount) {
                                this.tableModelElementListFrom.removeRow(0);
                                ++i;
                            }
                        }
                        this.subsystemElementFrom = this.subsystemNodeListFrom.get(this.jComboBoxSubsystemFrom.getSelectedIndex());
                        if (this.subsystemElementFrom != null) {
                            String wrkStr;
                            Object[] Cell;
                            Element element;
                            subsystemID = this.subsystemElementFrom.getAttribute("ID");
                            this.jButtonRefresh.setEnabled(true);
                            int rowNumber = 1;
                            NodeList nodelist = this.domDocumentImportingFrom.getElementsByTagName("Table");
                            Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodelist, "SortKey");
                            int i = 0;
                            while (i < sortingList.getSize()) {
                                element = (Element)sortingList.getElementAt(i);
                                if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                                    Cell = new Object[5];
                                    Cell[0] = new TableRowNumber(rowNumber++, element, "Table", this);
                                    Cell[1] = this.isToUseTableNameToCreateTable ? this.convertCamelNotation(element.getAttribute("Name")) : (element.getAttribute("Alias").equals("") ? this.convertCamelNotation(element.getAttribute("SortKey")) : this.convertCamelNotation(element.getAttribute("Alias")));
                                    Cell[2] = element.getAttribute("Name");
                                    Cell[3] = "TABLE";
                                    wrkStr = this.getStatusOfTable(element);
                                    Cell[4] = wrkStr.startsWith("ALTERED:") ? "ALTERED" : (wrkStr.startsWith("ERROR:") ? "ERROR" : wrkStr);
                                    ((TableRowNumber)Cell[0]).setMessage(wrkStr);
                                    if (Cell[4].equals("NEW") || Cell[4].equals("ALTERED")) {
                                        Cell[1] = "<html><b>" + Cell[1];
                                        Cell[2] = "<html><b>" + Cell[2];
                                        Cell[3] = "<html><b>" + Cell[3];
                                        Cell[4] = "<html><b>" + Cell[4];
                                    }
                                    this.tableModelElementListFrom.addRow(Cell);
                                }
                                ++i;
                            }
                            nodelist = this.domDocumentImportingFrom.getElementsByTagName("Function");
                            sortingList = this.frame_.getSortedListModel(nodelist, "SortKey");
                            i = 0;
                            while (i < sortingList.getSize()) {
                                element = (Element)sortingList.getElementAt(i);
                                if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                                    Cell = new Object[5];
                                    Cell[0] = new TableRowNumber(rowNumber++, element, "Function", this);
                                    Cell[1] = element.getAttribute("SortKey");
                                    Cell[2] = element.getAttribute("Name");
                                    Cell[3] = "???";
                                    int j = 0;
                                    while (j < this.functionTypeList.getLength()) {
                                        Element functionTypeElement = (Element)this.functionTypeList.item(j);
                                        if (functionTypeElement.getAttribute("ID").equals(element.getAttribute("FunctionTypeID"))) {
                                            Cell[3] = String.valueOf(functionTypeElement.getAttribute("SortKey")) + " " + functionTypeElement.getAttribute("Name");
                                        }
                                        ++j;
                                    }
                                    wrkStr = this.getStatusOfFunction(element);
                                    Cell[4] = wrkStr.startsWith("ALTERED:") ? "ALTERED" : (wrkStr.startsWith("ERROR:") ? "ERROR" : wrkStr);
                                    ((TableRowNumber)Cell[0]).setMessage(wrkStr);
                                    if (Cell[4].equals("NEW") || Cell[4].equals("ALTERED")) {
                                        Cell[1] = "<html><b>" + Cell[1];
                                        Cell[2] = "<html><b>" + Cell[2];
                                        Cell[3] = "<html><b>" + Cell[3];
                                        Cell[4] = "<html><b>" + Cell[4];
                                    }
                                    this.tableModelElementListFrom.addRow(Cell);
                                }
                                ++i;
                            }
                        }
                        this.jTextAreaMessage.setText(res.getString("ImportModelMessage1"));
                    }
                    catch (Exception e1) {
                        this.jTextAreaMessage.setText(e1.getStackTrace().toString());
                        this.setCursor(new Cursor(0));
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.setCursor(new Cursor(0));
                    throw throwable;
                }
                this.setCursor(new Cursor(0));
            }
        }
        this.isListBeingRebuild = false;
    }

    public void jTableElementListFrom_valueChanged(ListSelectionEvent e) {
        this.jButtonImport.setEnabled(false);
        if (this.jTableElementListFrom.getSelectedRow() != -1 && !this.isListBeingRebuild) {
            this.jTableElementListFrom.paintImmediately(this.jTableElementListFrom.getBounds());
            TableRowNumber tableRowNumber = (TableRowNumber)this.tableModelElementListFrom.getValueAt(this.jTableElementListFrom.getSelectedRow(), 0);
            String message = tableRowNumber.getMessage();
            if (message.startsWith("ERROR:")) {
                this.jButtonImport.setEnabled(false);
                this.jTextAreaMessage.setText(String.valueOf(res.getString("ImportModelMessage20")) + message.replace("ERROR:", "\n" + res.getString("ImportModelMessage29") + "\n"));
            }
            if (message.startsWith("ALTERED:")) {
                this.jButtonImport.setEnabled(true);
                this.jTextAreaMessage.setText(String.valueOf(res.getString("ImportModelMessage18")) + message.replace("ALTERED:", "\n" + res.getString("ImportModelMessage30") + "\n"));
            }
            if (message.equals("NEW")) {
                this.jButtonImport.setEnabled(true);
                this.jTextAreaMessage.setText(res.getString("ImportModelMessage3"));
            }
            if (message.equals("IDENTICAL")) {
                this.jTextAreaMessage.setText(res.getString("ImportModelMessage19"));
            }
            this.jTextAreaMessage.setCaretPosition(0);
        }
    }

    private String getStatusOfTable(Element elementFrom) {
        String wrk;
        int i;
        int j;
        Element fieldElementInto;
        int j2;
        String alias;
        Element fieldElementFrom;
        NodeList nodeList;
        String status = "";
        Element elementInto = null;
        ArrayList<String> aliasList = new ArrayList<String>();
        StringBuffer error = new StringBuffer();
        DefaultListModel fieldListInto = null;
        NodeList keyListInto = null;
        StringBuffer altered = new StringBuffer();
        int countOfErrors = 0;
        int countOfAltered = 0;
        int i2 = 0;
        while (i2 < this.currentTableList.getLength()) {
            Element workElement = (Element)this.currentTableList.item(i2);
            if (this.isToUseTableNameToCreateTable) {
                if (workElement.getAttribute("ID").equals(this.convertCamelNotation(elementFrom.getAttribute("Name")))) {
                    elementInto = workElement;
                    break;
                }
            } else if (elementFrom.getAttribute("Alias").equals("")) {
                if (workElement.getAttribute("ID").equals(this.convertCamelNotation(elementFrom.getAttribute("SortKey")))) {
                    elementInto = workElement;
                    break;
                }
            } else if (workElement.getAttribute("ID").equals(this.convertCamelNotation(elementFrom.getAttribute("Alias")))) {
                elementInto = workElement;
                break;
            }
            ++i2;
        }
        if (elementInto != null) {
            if (!elementInto.getAttribute("Name").equals(elementFrom.getAttribute("Name"))) {
                altered.append(String.valueOf(++countOfAltered) + "." + res.getString("ImportModelMessage21") + elementInto.getAttribute("Name") + res.getString("ImportModelMessage22") + "\n");
            }
            if (!elementInto.getAttribute("Remarks").equals(elementFrom.getAttribute("Descriptions"))) {
                altered.append(String.valueOf(++countOfAltered) + "." + res.getString("Remarks") + "\n");
            }
            if (!elementInto.getAttribute("SubsystemID").equals(this.subsystemElementFrom.getAttribute("SortKey"))) {
                altered.append(String.valueOf(++countOfAltered) + "." + res.getString("ImportModelMessage23") + elementInto.getAttribute("SubsystemID") + res.getString("ImportModelMessage22") + "\n");
            }
            nodeList = elementInto.getElementsByTagName("Field");
            fieldListInto = this.frame_.getSortedListModel(nodeList, "Order");
            keyListInto = elementInto.getElementsByTagName("Key");
        }
        nodeList = elementFrom.getElementsByTagName("TableField");
        Editor.SortableDomElementListModel fieldListFrom = this.frame_.getSortedListModel(nodeList, "SortKey");
        i2 = 0;
        while (i2 < fieldListFrom.size()) {
            fieldElementFrom = (Element)fieldListFrom.getElementAt(i2);
            alias = fieldElementFrom.getAttribute("Alias").equals("") ? fieldElementFrom.getAttribute("Name") : this.convertCamelNotation(fieldElementFrom.getAttribute("Alias"));
            if (alias.equals("")) {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage14") + " FieldName=" + fieldElementFrom.getAttribute("Name") + "\n");
            } else if (aliasList.contains(alias)) {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage17") + " FieldName=" + fieldElementFrom.getAttribute("Name") + "\n");
            } else {
                HashMap<String, String> attrMap = this.convertDataTypeIDToAttrMap(fieldElementFrom.getAttribute("DataTypeID"));
                String dataType = attrMap.get("Type");
                boolean isValidType = false;
                j2 = 0;
                while (j2 < this.frame_.jComboBoxTableFieldType.getItemCount()) {
                    if (this.frame_.jComboBoxTableFieldType.getItemAt(j2).equals(dataType)) {
                        isValidType = true;
                        break;
                    }
                    ++j2;
                }
                if (isValidType) {
                    if (fieldListInto != null) {
                        boolean fieldIsAdded = true;
                        j2 = 0;
                        while (j2 < fieldListInto.getSize()) {
                            fieldElementInto = (Element)((Editor.SortableDomElementListModel)fieldListInto).getElementAt(j2);
                            if (fieldElementInto.getAttribute("ID").equals(alias)) {
                                fieldIsAdded = false;
                                if (!fieldElementInto.getAttribute("Name").equals(fieldElementFrom.getAttribute("Name"))) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("Name") + ":" + fieldElementFrom.getAttribute("Name") + "\n");
                                }
                                if (!fieldElementInto.getAttribute("Remarks").equals(fieldElementFrom.getAttribute("Descriptions"))) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("Remarks") + "\n");
                                }
                                if (fieldElementInto.getAttribute("Nullable").equals("T") && fieldElementFrom.getAttribute("NotNull").equals("true") || fieldElementInto.getAttribute("Nullable").equals("F") && fieldElementFrom.getAttribute("NotNull").equals("false")) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + "NotNull" + ":" + fieldElementFrom.getAttribute("NotNull") + "\n");
                                }
                                if (!attrMap.get("Type").equals(fieldElementInto.getAttribute("Type"))) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("DataType") + ":" + attrMap.get("Type") + "\n");
                                }
                                if (i2 != j2) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("ListOrder") + "\n");
                                }
                                if (!(attrMap.get("Type").equals("DATE") || attrMap.get("Type").equals("DATETIME") || attrMap.get("Type").startsWith("TIME"))) {
                                    if (!attrMap.get("Size").equals(fieldElementInto.getAttribute("Size"))) {
                                        altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("FieldSize") + ":" + attrMap.get("Size") + "\n");
                                    }
                                    if (!attrMap.get("Decimal").equals(fieldElementInto.getAttribute("Decimal"))) {
                                        altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("Decimal") + ":" + attrMap.get("Decimal") + "\n");
                                    }
                                }
                                if (fieldElementInto.getAttribute("NoUpdate").equals("T") && fieldElementFrom.getAttribute("NoUpdate").equals("false") || fieldElementInto.getAttribute("NoUpdate").equals("F") && fieldElementFrom.getAttribute("NoUpdate").equals("true")) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("NoUpdate") + ":" + fieldElementFrom.getAttribute("NoUpdate") + "\n");
                                }
                                if (fieldElementInto.getAttribute("TypeOptions").contains("VIRTUAL") && !fieldElementFrom.getAttribute("AttributeType").equals("DERIVABLE")) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("AttributeType") + ":" + fieldElementFrom.getAttribute("AttributeType") + "\n");
                                }
                                if (fieldElementInto.getAttribute("TypeOptions").contains("VIRTUAL") || !fieldElementFrom.getAttribute("AttributeType").equals("DERIVABLE")) break;
                                altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage24") + res.getString("AttributeType") + ":" + fieldElementFrom.getAttribute("AttributeType") + "\n");
                                break;
                            }
                            ++j2;
                        }
                        if (fieldIsAdded) {
                            altered.append(String.valueOf(++countOfAltered) + "." + "Field " + alias + res.getString("ImportModelMessage25") + "\n");
                        }
                    }
                } else {
                    error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage13") + " Field=" + fieldElementFrom.getAttribute("Name") + "(" + alias + ")" + " DataType=" + dataType + "\n");
                }
            }
            aliasList.add(alias);
            ++i2;
        }
        if (fieldListInto != null) {
            j = 0;
            while (j < fieldListInto.size()) {
                boolean fieldIsDeleted = true;
                fieldElementInto = (Element)((Editor.SortableDomElementListModel)fieldListInto).getElementAt(j);
                i = 0;
                while (i < fieldListFrom.size()) {
                    fieldElementFrom = (Element)fieldListFrom.getElementAt(i);
                    alias = this.convertCamelNotation(fieldElementFrom.getAttribute("Alias"));
                    if (alias.equals(fieldElementInto.getAttribute("ID"))) {
                        fieldIsDeleted = false;
                        break;
                    }
                    ++i;
                }
                if (fieldIsDeleted) {
                    altered.append(String.valueOf(++countOfAltered) + "." + "Field " + fieldElementInto.getAttribute("ID") + res.getString("ImportModelMessage26") + "\n");
                }
                ++j;
            }
        }
        if (keyListInto != null) {
            Element keyElementInto;
            String keyFieldID;
            String keyType;
            Element keyElementFrom;
            NodeList keyListFrom = elementFrom.getElementsByTagName("TableKey");
            i2 = 0;
            while (i2 < keyListFrom.getLength()) {
                keyElementFrom = (Element)keyListFrom.item(i2);
                keyType = keyElementFrom.getAttribute("Type");
                if (!keyType.equals("FK") && !keyType.equals("XK")) {
                    keyFieldID = this.getFieldIDListOfTableKeyFrom(elementFrom, keyElementFrom);
                    boolean keyIsAdded = true;
                    j2 = 0;
                    while (j2 < keyListInto.getLength()) {
                        keyElementInto = (Element)keyListInto.item(j2);
                        if (keyType.equals("PK") && keyElementInto.getAttribute("Type").equals(keyType)) {
                            keyIsAdded = false;
                            if (keyElementInto.getAttribute("Fields").equals(keyFieldID)) break;
                            altered.append(String.valueOf(++countOfAltered) + "." + keyType + " With Fields[" + keyFieldID + "]" + res.getString("ImportModelMessage27") + "\n");
                            break;
                        }
                        if (!keyType.equals("PK") && keyElementInto.getAttribute("Type").equals(keyType) && keyElementInto.getAttribute("Fields").equals(keyFieldID)) {
                            keyIsAdded = false;
                            break;
                        }
                        ++j2;
                    }
                    if (!keyType.equals("PK") && keyIsAdded) {
                        altered.append(String.valueOf(++countOfAltered) + "." + keyType + " With Fields[" + keyFieldID + "]" + res.getString("ImportModelMessage27") + "\n");
                    }
                }
                ++i2;
            }
            j = 0;
            while (j < keyListInto.getLength()) {
                keyElementInto = (Element)keyListInto.item(j);
                if (!(keyElementInto.getAttribute("Type").equals("PK") || keyElementInto.getAttribute("Type").equals("FK") || keyElementInto.getAttribute("Type").equals("XK"))) {
                    boolean keyIsDeleted = true;
                    i = 0;
                    while (i < keyListFrom.getLength()) {
                        keyElementFrom = (Element)keyListFrom.item(i);
                        keyType = keyElementFrom.getAttribute("Type");
                        keyFieldID = this.getFieldIDListOfTableKeyFrom(elementFrom, keyElementFrom);
                        if (keyElementInto.getAttribute("Type").equals(keyType) && keyElementInto.getAttribute("Fields").equals(keyFieldID)) {
                            keyIsDeleted = false;
                            break;
                        }
                        ++i;
                    }
                    if (keyIsDeleted) {
                        altered.append(String.valueOf(++countOfAltered) + "." + keyElementInto.getAttribute("Type") + " With Fields[" + keyElementInto.getAttribute("Fields") + "]" + res.getString("ImportModelMessage26") + "\n");
                    }
                }
                ++j;
            }
        }
        status = elementInto == null ? ((wrk = error.toString()).equals("") ? "NEW" : "ERROR:" + wrk) : ((wrk = error.toString()).equals("") ? ((wrk = altered.toString()).equals("") ? "IDENTICAL" : "ALTERED:" + wrk) : "ERROR:" + wrk);
        return status;
    }

    private String getFieldIDListOfTableKeyFrom(Element tableElementFrom, Element keyElementFrom) {
        String fieldIDs = "";
        ArrayList<String> fieldInternalIDList = new ArrayList<String>();
        ArrayList<String> fieldExternalIDList = new ArrayList<String>();
        NodeList fieldListFrom = tableElementFrom.getElementsByTagName("TableField");
        NodeList nodeList = keyElementFrom.getElementsByTagName("TableKeyField");
        Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodeList, "SortKey");
        int i = 0;
        while (i < sortingList.getSize()) {
            Element workElement1 = (Element)sortingList.getElementAt(i);
            String internalID = workElement1.getAttribute("FieldID");
            String externalID = "";
            int j = 0;
            while (j < fieldListFrom.getLength()) {
                Element workElement2 = (Element)fieldListFrom.item(j);
                if (workElement2.getAttribute("ID").equals(internalID)) {
                    externalID = workElement2.getAttribute("Alias").equals("") ? this.convertCamelNotation(workElement2.getAttribute("Name")) : this.convertCamelNotation(workElement2.getAttribute("Alias"));
                    if (!keyElementFrom.getAttribute("Type").equals("XK")) break;
                    if (workElement1.getAttribute("AscDesc").equals("D")) {
                        externalID = String.valueOf(externalID) + "(D)";
                        break;
                    }
                    externalID = String.valueOf(externalID) + "(A)";
                    break;
                }
                ++j;
            }
            fieldInternalIDList.add(internalID);
            fieldExternalIDList.add(externalID);
            ++i;
        }
        i = 0;
        while (i < fieldExternalIDList.size()) {
            if (!fieldIDs.equals("")) {
                fieldIDs = String.valueOf(fieldIDs) + ";";
            }
            fieldIDs = String.valueOf(fieldIDs) + (String)fieldExternalIDList.get(i);
            ++i;
        }
        return fieldIDs;
    }

    private String getStatusOfFunction(Element elementFrom) throws Exception {
        String wrk;
        NodeList nodeList;
        Element workElement;
        String status = "";
        Element elementInto = null;
        StringBuffer error = new StringBuffer();
        StringBuffer altered = new StringBuffer();
        int countOfErrors = 0;
        int countOfAltered = 0;
        int i = 0;
        while (i < this.currentFunctionList.getLength()) {
            workElement = (Element)this.currentFunctionList.item(i);
            if (workElement.getAttribute("ID").equals(elementFrom.getAttribute("SortKey"))) {
                elementInto = workElement;
                break;
            }
            ++i;
        }
        if (elementInto != null) {
            if (!elementInto.getAttribute("Name").equals(elementFrom.getAttribute("Name"))) {
                altered.append(String.valueOf(++countOfAltered) + "." + res.getString("ImportModelMessage21") + elementInto.getAttribute("Name") + res.getString("ImportModelMessage22") + "\n");
            }
            if (!elementInto.getAttribute("SubsystemID").equals(this.subsystemElementFrom.getAttribute("SortKey"))) {
                altered.append(String.valueOf(++countOfAltered) + "." + res.getString("ImportModelMessage23") + elementInto.getAttribute("SubsystemID") + res.getString("ImportModelMessage22") + "\n");
            }
        }
        String functionType = "";
        int i2 = 0;
        while (i2 < this.functionTypeList.getLength()) {
            workElement = (Element)this.functionTypeList.item(i2);
            if (workElement.getAttribute("ID").equals(elementFrom.getAttribute("FunctionTypeID"))) {
                functionType = workElement.getAttribute("SortKey").trim();
                break;
            }
            ++i2;
        }
        if (!(functionType.equals("XF000") || functionType.equals("XF100") || functionType.equals("XF110") || functionType.equals("XF200") || functionType.equals("XF290") || functionType.equals("XF300") || functionType.equals("XF310") || functionType.equals("XF390"))) {
            error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage12") + "(" + functionType + ")\n");
        } else if (elementInto != null && !elementInto.getAttribute("Type").equals(functionType)) {
            error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage28") + elementInto.getAttribute("Type") + res.getString("ImportModelMessage22") + "\n");
        }
        if (functionType.equals("XF100") || functionType.equals("XF110") || functionType.equals("XF200") || functionType.equals("XF290")) {
            String primaryTableExternalID = "";
            nodeList = elementFrom.getElementsByTagName("IOTable");
            if (nodeList.getLength() == 1) {
                workElement = (Element)nodeList.item(0);
                primaryTableExternalID = this.convertTableInternalIDToExternalID(workElement.getAttribute("TableID"));
            } else {
                i2 = 0;
                while (i2 < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i2);
                    if (workElement.getAttribute("Position").equals("PRIMARY") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("PRIMARY") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("PrimaryTable").toUpperCase())) {
                        primaryTableExternalID = this.convertTableInternalIDToExternalID(workElement.getAttribute("TableID"));
                        break;
                    }
                    ++i2;
                }
            }
            if (primaryTableExternalID.equals("")) {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage6") + "\n");
            } else if (this.isExistingTable(primaryTableExternalID)) {
                if (elementInto != null && elementInto.getAttribute("Type").equals(functionType) && !elementInto.getAttribute("PrimaryTable").equals(primaryTableExternalID)) {
                    altered.append(String.valueOf(++countOfAltered) + "." + res.getString("PrimaryTable") + ":" + primaryTableExternalID + "\n");
                }
            } else {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage7") + "(" + primaryTableExternalID + ")\n");
            }
        }
        if (functionType.equals("XF300") || functionType.equals("XF310") || functionType.equals("XF390")) {
            String headerTableExternalID = "";
            String headerTableInternalID = "";
            ArrayList<String> detailTableExternalIDList = new ArrayList<String>();
            ArrayList<String> detailTableInternalIDList = new ArrayList<String>();
            nodeList = elementFrom.getElementsByTagName("IOTable");
            int i3 = 0;
            while (i3 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i3);
                if (workElement.getAttribute("Position").equals("HEADER") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("HEADER") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("HeaderTable").toUpperCase())) {
                    headerTableInternalID = workElement.getAttribute("TableID");
                    headerTableExternalID = this.convertTableInternalIDToExternalID(headerTableInternalID);
                    break;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < nodeList.getLength()) {
                String wrkStr;
                workElement = (Element)nodeList.item(i3);
                if ((workElement.getAttribute("Position").equals("DETAIL") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("DETAIL") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("DetailTable").toUpperCase())) && !(wrkStr = this.convertTableInternalIDToExternalID(workElement.getAttribute("TableID"))).equals("")) {
                    detailTableInternalIDList.add(workElement.getAttribute("TableID"));
                    detailTableExternalIDList.add(wrkStr);
                }
                ++i3;
            }
            if (headerTableExternalID.equals("")) {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage8") + "\n");
            } else if (this.isExistingTable(headerTableExternalID)) {
                if (elementInto != null && elementInto.getAttribute("Type").equals(functionType) && !elementInto.getAttribute("HeaderTable").equals(headerTableExternalID)) {
                    altered.append(String.valueOf(++countOfAltered) + "." + res.getString("HDRTable") + ":" + headerTableExternalID + "\n");
                }
            } else {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage9") + "(" + headerTableExternalID + ")\n");
            }
            if (detailTableExternalIDList.size() == 0) {
                error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage10") + "\n");
            } else {
                int numberOfValidDetailTables = 0;
                int i4 = 0;
                while (i4 < detailTableExternalIDList.size()) {
                    if (this.isExistingTable((String)detailTableExternalIDList.get(i4)) && this.isValidWithKeys(headerTableInternalID, (String)detailTableInternalIDList.get(i4))) {
                        ++numberOfValidDetailTables;
                        if (elementInto != null) {
                            if (functionType.equals("XF310") && !elementInto.getAttribute("DetailTable").equals(detailTableExternalIDList.get(i4))) {
                                altered.append(String.valueOf(++countOfAltered) + "." + res.getString("DTLTable") + ":" + (String)detailTableExternalIDList.get(i4) + "\n");
                            }
                            if (functionType.equals("XF300") || functionType.equals("XF390")) {
                                NodeList detailTabList = elementInto.getElementsByTagName("Detail");
                                boolean isFound = false;
                                int j = 0;
                                while (j < detailTabList.getLength()) {
                                    workElement = (Element)detailTabList.item(j);
                                    if (workElement.getAttribute("Table").equals(detailTableExternalIDList.get(i4))) {
                                        isFound = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!isFound) {
                                    altered.append(String.valueOf(++countOfAltered) + "." + res.getString("DTLTable") + ":" + (String)detailTableExternalIDList.get(i4) + "\n");
                                }
                            }
                        }
                    }
                    ++i4;
                }
                if (numberOfValidDetailTables == 0) {
                    error.append(String.valueOf(++countOfErrors) + "." + res.getString("ImportModelMessage10") + "\n");
                }
            }
        }
        status = elementInto == null ? ((wrk = error.toString()).equals("") ? "NEW" : "ERROR:" + wrk) : ((wrk = error.toString()).equals("") ? ((wrk = altered.toString()).equals("") ? "IDENTICAL" : "ALTERED:" + wrk) : "ERROR:" + wrk);
        return status;
    }

    private boolean isValidWithKeys(String headerTableID, String detailTableID) {
        return !this.getDetailKeys(headerTableID, detailTableID)[0].equals("*ERROR");
    }

    private String[] getDetailKeys(String headerTableInternalID, String detailTableInternalID) {
        Element element;
        String[] keyFields = new String[]{"", ""};
        int index = 0;
        String keyFieldsOfHeaderTable = "";
        String keyFieldsOfDetailTable = "";
        ArrayList<String> headerPKFieldTypeList = new ArrayList<String>();
        ArrayList<String> detailPKFieldTypeList = new ArrayList<String>();
        String tableExternalID = this.convertTableInternalIDToExternalID(headerTableInternalID);
        Element headerTableElement = this.getCurrentTableElementWithID(tableExternalID);
        NodeList headerTableKeyNodeList = headerTableElement.getElementsByTagName("Key");
        NodeList headerTableFieldNodeList = headerTableElement.getElementsByTagName("Field");
        Element headerTableKeyElement = null;
        int i = 0;
        while (i < headerTableKeyNodeList.getLength()) {
            element = (Element)headerTableKeyNodeList.item(i);
            if (element.getAttribute("Type").equals("PK")) {
                headerTableKeyElement = element;
                break;
            }
            ++i;
        }
        tableExternalID = this.convertTableInternalIDToExternalID(detailTableInternalID);
        Element detailTableElement = this.getCurrentTableElementWithID(tableExternalID);
        NodeList detailTableKeyNodeList = detailTableElement.getElementsByTagName("Key");
        NodeList detailTableFieldNodeList = detailTableElement.getElementsByTagName("Field");
        Element detailTableKeyElement = null;
        int i2 = 0;
        while (i2 < detailTableKeyNodeList.getLength()) {
            element = (Element)detailTableKeyNodeList.item(i2);
            if (element.getAttribute("Type").equals("PK")) {
                detailTableKeyElement = element;
                break;
            }
            ++i2;
        }
        if (headerTableKeyElement == null || detailTableKeyElement == null) {
            keyFields[0] = "*ERROR";
        } else {
            boolean isErrorWithKey = false;
            StringTokenizer tokenizer1 = new StringTokenizer(headerTableKeyElement.getAttribute("Fields"), ";");
            StringTokenizer tokenizer2 = new StringTokenizer(detailTableKeyElement.getAttribute("Fields"), ";");
            if (tokenizer1.countTokens() < tokenizer2.countTokens()) {
                int i3;
                String fieldID;
                while (tokenizer1.hasMoreTokens()) {
                    fieldID = tokenizer1.nextToken();
                    i3 = 0;
                    while (i3 < headerTableFieldNodeList.getLength()) {
                        element = (Element)headerTableFieldNodeList.item(i3);
                        if (element.getAttribute("ID").equals(fieldID)) {
                            headerPKFieldTypeList.add(element.getAttribute("Type"));
                        }
                        ++i3;
                    }
                }
                while (tokenizer2.hasMoreTokens()) {
                    fieldID = tokenizer2.nextToken();
                    i3 = 0;
                    while (i3 < detailTableFieldNodeList.getLength()) {
                        element = (Element)detailTableFieldNodeList.item(i3);
                        if (element.getAttribute("ID").equals(fieldID)) {
                            detailPKFieldTypeList.add(element.getAttribute("Type"));
                        }
                        ++i3;
                    }
                }
                i3 = 0;
                while (i3 < headerPKFieldTypeList.size()) {
                    keyFieldsOfHeaderTable = i3 == 0 ? (String)headerPKFieldTypeList.get(i3) : String.valueOf(keyFieldsOfHeaderTable) + ";" + (String)headerPKFieldTypeList.get(i3);
                    index = detailPKFieldTypeList.indexOf(headerPKFieldTypeList.get(i3));
                    if (index == -1) {
                        isErrorWithKey = true;
                        break;
                    }
                    keyFieldsOfDetailTable = i3 == 0 ? (String)detailPKFieldTypeList.get(index) : String.valueOf(keyFieldsOfDetailTable) + ";" + (String)detailPKFieldTypeList.get(index);
                    ++i3;
                }
                if (!isErrorWithKey) {
                    i3 = 0;
                    while (i3 < detailPKFieldTypeList.size()) {
                        if (!headerPKFieldTypeList.contains(detailPKFieldTypeList.get(i3))) {
                            keyFieldsOfDetailTable = String.valueOf(keyFieldsOfDetailTable) + ";" + (String)detailPKFieldTypeList.get(i3);
                        }
                        ++i3;
                    }
                    keyFields[0] = this.getFieldsOfKey(headerTableInternalID, keyFieldsOfHeaderTable, false);
                    keyFields[1] = this.getFieldsOfKey(detailTableInternalID, keyFieldsOfDetailTable, true);
                }
            } else {
                isErrorWithKey = true;
            }
            if (isErrorWithKey) {
                keyFields = this.getKeysAccordingToRelationship(headerTableElement, detailTableElement);
            }
        }
        return keyFields;
    }

    private String[] getKeysAccordingToRelationship(Element headerTableElement, Element detailTableElement) {
        String[] keys = new String[]{"", ""};
        String internalHeaderTableID = this.getInternalTableID(headerTableElement.getAttribute("ID"));
        String internalDetailTableID = this.getInternalTableID(detailTableElement.getAttribute("ID"));
        NodeList relationshipList = this.domDocumentImportingFrom.getElementsByTagName("Relationship");
        int i = 0;
        while (i < relationshipList.getLength()) {
            Element relationshipElement = (Element)relationshipList.item(i);
            if (relationshipElement.getAttribute("Table1ID").equals(internalHeaderTableID) && relationshipElement.getAttribute("Table2ID").equals(internalDetailTableID) && relationshipElement.getAttribute("Type").equals("REFFER")) {
                keys[0] = this.getFieldsOfKey(internalHeaderTableID, relationshipElement.getAttribute("TableKey1ID"), false);
                keys[1] = this.getFieldsOfKey(internalDetailTableID, relationshipElement.getAttribute("TableKey2ID"), true);
                break;
            }
            ++i;
        }
        if (keys[0].equals("")) {
            keys[0] = "*ERROR";
        }
        return keys;
    }

    private String getInternalTableID(String externalID) {
        String internalID = "";
        int i = 0;
        while (i < this.tableListInModel.getLength()) {
            Element element = (Element)this.tableListInModel.item(i);
            if (element.getAttribute("SortKey").equals(externalID)) {
                internalID = element.getAttribute("ID");
                break;
            }
            ++i;
        }
        return internalID;
    }

    private String getFieldsOfKey(String internalTableID, String internalKeyID, boolean isDetailKeys) {
        String keyFields = "";
        ArrayList<String> keyFieldIDList = new ArrayList<String>();
        ArrayList<String> primaryKeyFieldIDList = new ArrayList<String>();
        int i = 0;
        while (i < this.tableListInModel.getLength()) {
            Element element = (Element)this.tableListInModel.item(i);
            if (element.getAttribute("ID").equals(internalTableID)) {
                NodeList fieldList = element.getElementsByTagName("TableField");
                NodeList keyList = element.getElementsByTagName("TableKey");
                int j = 0;
                while (j < keyList.getLength()) {
                    Element element3;
                    int m;
                    Element element2;
                    int k;
                    Editor.SortableDomElementListModel sortingList;
                    NodeList keyFieldList;
                    Element element1 = (Element)keyList.item(j);
                    if (element1.getAttribute("ID").equals(internalKeyID)) {
                        keyFieldList = element1.getElementsByTagName("TableKeyField");
                        sortingList = this.frame_.getSortedListModel(keyFieldList, "SortKey");
                        k = 0;
                        while (k < sortingList.getSize()) {
                            element2 = (Element)sortingList.getElementAt(k);
                            m = 0;
                            while (m < fieldList.getLength()) {
                                element3 = (Element)fieldList.item(m);
                                if (element2.getAttribute("FieldID").equals(element3.getAttribute("ID"))) {
                                    keyFieldIDList.add(this.convertCamelNotation(element3.getAttribute("Alias")));
                                }
                                ++m;
                            }
                            ++k;
                        }
                    }
                    if (isDetailKeys && element1.getAttribute("Type").equals("PK")) {
                        keyFieldList = element1.getElementsByTagName("TableKeyField");
                        sortingList = this.frame_.getSortedListModel(keyFieldList, "SortKey");
                        k = 0;
                        while (k < sortingList.getSize()) {
                            element2 = (Element)sortingList.getElementAt(k);
                            m = 0;
                            while (m < fieldList.getLength()) {
                                element3 = (Element)fieldList.item(m);
                                if (element2.getAttribute("FieldID").equals(element3.getAttribute("ID"))) {
                                    primaryKeyFieldIDList.add(this.convertCamelNotation(element3.getAttribute("Alias")));
                                }
                                ++m;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                StringBuffer bf = new StringBuffer();
                if (keyFieldIDList.contains("")) {
                    keyFields = "";
                    break;
                }
                int j2 = 0;
                while (j2 < keyFieldIDList.size()) {
                    if (j2 > 0) {
                        bf.append(";");
                    }
                    bf.append((String)keyFieldIDList.get(j2));
                    ++j2;
                }
                if (isDetailKeys) {
                    j2 = 0;
                    while (j2 < primaryKeyFieldIDList.size()) {
                        if (!keyFieldIDList.contains(primaryKeyFieldIDList.get(j2))) {
                            if (!bf.toString().equals("")) {
                                bf.append(";");
                            }
                            bf.append((String)primaryKeyFieldIDList.get(j2));
                        }
                        ++j2;
                    }
                }
                keyFields = bf.toString();
                break;
            }
            ++i;
        }
        return keyFields;
    }

    private HashMap<String, String> convertDataTypeIDToAttrMap(String dataTypeID) {
        String dataType = "";
        String dataSize = "0";
        String dataDecimal = "";
        HashMap<String, String> attrMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.dataTypeNodeListFrom.getLength()) {
            Element element = (Element)this.dataTypeNodeListFrom.item(i);
            if (element.getAttribute("ID").equals(dataTypeID)) {
                String wrkStr = element.getAttribute("SQLExpression").toUpperCase();
                dataSize = element.getAttribute("Length");
                int pos1 = wrkStr.indexOf("(", 0);
                if (pos1 > 0) {
                    dataType = wrkStr.substring(0, pos1);
                    int pos2 = wrkStr.indexOf(".", pos1);
                    if (pos2 > 0) {
                        dataSize = wrkStr.substring(pos1 + 1, pos2);
                        int pos3 = wrkStr.indexOf(")", pos2);
                        if (pos3 <= 0) break;
                        dataDecimal = wrkStr.substring(pos2 + 1, pos3);
                        break;
                    }
                    pos2 = wrkStr.indexOf(")", pos1);
                    if (pos2 <= 0) break;
                    dataSize = wrkStr.substring(pos1 + 1, pos2);
                    break;
                }
                dataType = wrkStr;
                break;
            }
            ++i;
        }
        attrMap.put("Type", dataType);
        attrMap.put("Size", dataSize);
        attrMap.put("Decimal", dataDecimal);
        return attrMap;
    }

    private String convertTableInternalIDToExternalID(String internalID) {
        String externalID = "";
        int i = 0;
        while (i < this.tableListInModel.getLength()) {
            Element element = (Element)this.tableListInModel.item(i);
            if (element.getAttribute("ID").equals(internalID)) {
                externalID = element.getAttribute("SortKey");
                break;
            }
            ++i;
        }
        return externalID;
    }

    private String convertFunctionInternalIDToExternalID(String internalID) {
        String externalID = "";
        int i = 0;
        while (i < this.functionListInModel.getLength()) {
            Element element = (Element)this.functionListInModel.item(i);
            if (element.getAttribute("ID").equals(internalID)) {
                externalID = element.getAttribute("SortKey");
                break;
            }
            ++i;
        }
        return externalID;
    }

    void jButtonImport_actionPerformed(ActionEvent e) {
        String message = "";
        Element currentElement = null;
        if (this.jTableElementListFrom.getSelectedRow() != -1) {
            TableRowNumber tableRowNumber = (TableRowNumber)this.tableModelElementListFrom.getValueAt(this.jTableElementListFrom.getSelectedRow(), 0);
            Element element = tableRowNumber.getElement();
            String id = this.convertCamelNotation(element.getAttribute("SortKey"));
            if (this.isToUseTableNameToCreateTable) {
                id = this.convertCamelNotation(element.getAttribute("Name"));
            } else if (!element.getAttribute("Alias").equals("")) {
                id = this.convertCamelNotation(element.getAttribute("Alias"));
            }
            if (this.jCheckBoxOverrideID.isSelected()) {
                id = JOptionPane.showInputDialog(null, res.getString("ImportModelMessage4"), id);
            }
            if (id != null) {
                if (id.equals("")) {
                    message = res.getString("ImportModelMessage5");
                } else {
                    try {
                        int i;
                        NodeList currentElementList;
                        boolean isNotExisting;
                        this.setCursor(new Cursor(3));
                        id = id.toUpperCase();
                        this.createSubsystemIfNotExisting();
                        if (tableRowNumber.isTable()) {
                            isNotExisting = true;
                            currentElementList = this.frame_.getDomDocument().getElementsByTagName("Table");
                            i = 0;
                            while (i < currentElementList.getLength()) {
                                currentElement = (Element)currentElementList.item(i);
                                if (currentElement.getAttribute("ID").equals(id)) {
                                    isNotExisting = false;
                                    break;
                                }
                                ++i;
                            }
                            if (isNotExisting) {
                                this.importToCreateTable(element, id);
                            } else {
                                this.importToUpdateTable(element, currentElement);
                            }
                            if (!this.newlyAddedTableIDList.contains(id)) {
                                this.newlyAddedTableIDList.add(id);
                            }
                            message = "Table " + id + " " + res.getString("ImportModelMessage15");
                        }
                        if (tableRowNumber.isFunction()) {
                            isNotExisting = true;
                            currentElementList = this.frame_.getDomDocument().getElementsByTagName("Function");
                            i = 0;
                            while (i < currentElementList.getLength()) {
                                currentElement = (Element)currentElementList.item(i);
                                if (currentElement.getAttribute("ID").equals(id)) {
                                    isNotExisting = false;
                                    break;
                                }
                                ++i;
                            }
                            if (isNotExisting) {
                                this.importToCreateFunction(element, id);
                            } else {
                                this.importToUpdateFunction(element, currentElement);
                            }
                            if (!this.newlyAddedFunctionIDList.contains(id)) {
                                this.newlyAddedFunctionIDList.add(id);
                            }
                            message = "Function " + id + " " + res.getString("ImportModelMessage15");
                        }
                        String cellText = (String)this.tableModelElementListFrom.getValueAt(this.jTableElementListFrom.getSelectedRow(), 1);
                        this.tableModelElementListFrom.setValueAt(cellText.replaceFirst("<html><b>", ""), this.jTableElementListFrom.getSelectedRow(), 1);
                        cellText = (String)this.tableModelElementListFrom.getValueAt(this.jTableElementListFrom.getSelectedRow(), 2);
                        this.tableModelElementListFrom.setValueAt(cellText.replaceFirst("<html><b>", ""), this.jTableElementListFrom.getSelectedRow(), 2);
                        cellText = (String)this.tableModelElementListFrom.getValueAt(this.jTableElementListFrom.getSelectedRow(), 3);
                        this.tableModelElementListFrom.setValueAt(cellText.replaceFirst("<html><b>", ""), this.jTableElementListFrom.getSelectedRow(), 3);
                        cellText = (String)this.tableModelElementListFrom.getValueAt(this.jTableElementListFrom.getSelectedRow(), 4);
                        this.tableModelElementListFrom.setValueAt(cellText.replaceFirst("<html><b>", ""), this.jTableElementListFrom.getSelectedRow(), 4);
                    }
                    finally {
                        this.setCursor(new Cursor(0));
                    }
                }
                this.jTextAreaMessage.setText(message);
            }
        }
    }

    void jButtonRefresh_actionPerformed(ActionEvent e) {
        this.jComboBoxSubsystemFrom_actionPerformed(null);
    }

    private void createSubsystemIfNotExisting() {
        boolean isExistingSubsystem = false;
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("Subsystem");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element workElement = (Element)nodeList.item(i);
            if (workElement.getAttribute("ID").equals(this.subsystemElementFrom.getAttribute("SortKey"))) {
                isExistingSubsystem = true;
                break;
            }
            ++i;
        }
        if (!isExistingSubsystem) {
            Element subsystemElement = this.frame_.getDomDocument().createElement("Subsystem");
            subsystemElement.setAttribute("ID", this.subsystemElementFrom.getAttribute("SortKey"));
            subsystemElement.setAttribute("Name", this.subsystemElementFrom.getAttribute("Name"));
            subsystemElement.setAttribute("Remarks", this.subsystemElementFrom.getAttribute("Descriptions"));
            Element systemElementImportInto = (Element)nodeList.item(0);
            systemElementImportInto.appendChild(subsystemElement);
        }
    }

    private void importToCreateTable(Element modelElement, String tableID) {
        Element childElement;
        Element workElement1;
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("System");
        Element systemElementImportInto = (Element)nodeList.item(0);
        Element newElementToBeAdded = this.frame_.getDomDocument().createElement("Table");
        systemElementImportInto.appendChild(newElementToBeAdded);
        newElementToBeAdded.setAttribute("ID", tableID);
        newElementToBeAdded.setAttribute("Name", modelElement.getAttribute("Name"));
        newElementToBeAdded.setAttribute("Remarks", modelElement.getAttribute("Descriptions"));
        newElementToBeAdded.setAttribute("SubsystemID", this.subsystemElementFrom.getAttribute("SortKey"));
        nodeList = modelElement.getElementsByTagName("TableField");
        Editor.SortableDomElementListModel fieldSortingList = this.frame_.getSortedListModel(nodeList, "SortKey");
        int i = 0;
        while (i < fieldSortingList.getSize()) {
            workElement1 = (Element)fieldSortingList.getElementAt(i);
            childElement = this.frame_.getDomDocument().createElement("Field");
            if (workElement1.getAttribute("Alias").equals("")) {
                childElement.setAttribute("ID", workElement1.getAttribute("Name"));
            } else {
                childElement.setAttribute("ID", workElement1.getAttribute("Alias"));
            }
            childElement.setAttribute("Name", workElement1.getAttribute("Name"));
            childElement.setAttribute("Remarks", workElement1.getAttribute("Descriptions"));
            childElement.setAttribute("Order", Editor.getFormatted4ByteString(i * 10));
            HashMap<String, String> attrMap = this.convertDataTypeIDToAttrMap(workElement1.getAttribute("DataTypeID"));
            childElement.setAttribute("Type", attrMap.get("Type"));
            childElement.setAttribute("Size", attrMap.get("Size"));
            childElement.setAttribute("Decimal", attrMap.get("Decimal"));
            if (workElement1.getAttribute("NotNull").equals("true")) {
                childElement.setAttribute("Nullable", "F");
            } else {
                childElement.setAttribute("Nullable", "T");
            }
            if (workElement1.getAttribute("NoUpdate").equals("true")) {
                childElement.setAttribute("NoUpdate", "T");
            } else {
                childElement.setAttribute("NoUpdate", "F");
            }
            if (workElement1.getAttribute("AttributeType").equals("DERIVABLE")) {
                childElement.setAttribute("TypeOptions", "VIRTUAL");
            } else {
                childElement.setAttribute("TypeOptions", "");
            }
            newElementToBeAdded.appendChild(childElement);
            ++i;
        }
        childElement = this.frame_.getDomDocument().createElement("Key");
        childElement.setAttribute("Type", "PK");
        StringBuffer bf = new StringBuffer();
        nodeList = modelElement.getElementsByTagName("TableKey");
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            workElement1 = (Element)nodeList.item(i2);
            if (workElement1.getAttribute("Type").equals("PK")) {
                NodeList nodeList2 = workElement1.getElementsByTagName("TableKeyField");
                Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodeList2, "SortKey");
                int j = 0;
                while (j < sortingList.getSize()) {
                    Element workElement2 = (Element)sortingList.getElementAt(j);
                    int k = 0;
                    while (k < fieldSortingList.getSize()) {
                        Element workElement3 = (Element)fieldSortingList.getElementAt(k);
                        if (workElement3.getAttribute("ID").equals(workElement2.getAttribute("FieldID"))) {
                            if (j > 0) {
                                bf.append(";");
                            }
                            bf.append(workElement3.getAttribute("Alias"));
                        }
                        ++k;
                    }
                    ++j;
                }
                break;
            }
            ++i2;
        }
        childElement.setAttribute("Fields", bf.toString());
        newElementToBeAdded.appendChild(childElement);
        nodeList = modelElement.getElementsByTagName("TableKey");
        i2 = 0;
        while (i2 < nodeList.getLength()) {
            workElement1 = (Element)nodeList.item(i2);
            if (workElement1.getAttribute("Type").equals("SK") || workElement1.getAttribute("Type").equals("XK")) {
                childElement = this.frame_.getDomDocument().createElement("Key");
                childElement.setAttribute("Type", workElement1.getAttribute("Type"));
                childElement.setAttribute("Fields", this.getFieldIDListOfTableKeyFrom(modelElement, workElement1));
                newElementToBeAdded.appendChild(childElement);
            }
            ++i2;
        }
    }

    private void importToUpdateTable(Element modelTableElement, Element currentTableElement) {
        Element workElement2;
        int j;
        Element childElement;
        Element workElement1;
        currentTableElement.setAttribute("Name", modelTableElement.getAttribute("Name"));
        currentTableElement.setAttribute("Remarks", modelTableElement.getAttribute("Descriptions"));
        currentTableElement.setAttribute("SubsystemID", this.subsystemElementFrom.getAttribute("SortKey"));
        NodeList currentFieldList = currentTableElement.getElementsByTagName("Field");
        NodeList currentKeyList = currentTableElement.getElementsByTagName("Key");
        NodeList nodeList = modelTableElement.getElementsByTagName("TableField");
        Editor.SortableDomElementListModel fieldSortingList = this.frame_.getSortedListModel(nodeList, "SortKey");
        int i = 0;
        while (i < fieldSortingList.getSize()) {
            workElement1 = (Element)fieldSortingList.getElementAt(i);
            boolean isToCreateField = false;
            childElement = null;
            j = 0;
            while (j < currentFieldList.getLength()) {
                workElement2 = (Element)currentFieldList.item(j);
                if (workElement1.getAttribute("Alias").equals("")) {
                    if (workElement2.getAttribute("ID").equals(workElement1.getAttribute("Name"))) {
                        childElement = workElement2;
                        break;
                    }
                } else if (workElement2.getAttribute("ID").equals(workElement1.getAttribute("Alias"))) {
                    childElement = workElement2;
                    break;
                }
                ++j;
            }
            if (childElement == null) {
                isToCreateField = true;
                childElement = this.frame_.getDomDocument().createElement("Field");
                currentTableElement.appendChild(childElement);
            }
            childElement.setAttribute("Name", workElement1.getAttribute("Name"));
            childElement.setAttribute("Remarks", workElement1.getAttribute("Descriptions"));
            childElement.setAttribute("Order", Editor.getFormatted4ByteString(i * 10));
            HashMap<String, String> attrMap = this.convertDataTypeIDToAttrMap(workElement1.getAttribute("DataTypeID"));
            childElement.setAttribute("Type", attrMap.get("Type"));
            childElement.setAttribute("Size", attrMap.get("Size"));
            childElement.setAttribute("Decimal", attrMap.get("Decimal"));
            if (workElement1.getAttribute("NotNull").equals("true")) {
                childElement.setAttribute("Nullable", "F");
            } else {
                childElement.setAttribute("Nullable", "T");
            }
            if (workElement1.getAttribute("NoUpdate").equals("true")) {
                childElement.setAttribute("NoUpdate", "T");
            } else {
                childElement.setAttribute("NoUpdate", "F");
            }
            if (isToCreateField) {
                if (workElement1.getAttribute("Alias").equals("")) {
                    childElement.setAttribute("ID", workElement1.getAttribute("Name"));
                } else {
                    childElement.setAttribute("ID", workElement1.getAttribute("Alias"));
                }
                if (workElement1.getAttribute("AttributeType").equals("DERIVABLE")) {
                    childElement.setAttribute("TypeOptions", "VIRTUAL");
                } else {
                    childElement.setAttribute("TypeOptions", "");
                }
            }
            ++i;
        }
        nodeList = modelTableElement.getElementsByTagName("TableKey");
        i = 0;
        while (i < nodeList.getLength()) {
            workElement1 = (Element)nodeList.item(i);
            if (workElement1.getAttribute("Type").equals("SK") || workElement1.getAttribute("Type").equals("XK")) {
                childElement = null;
                j = 0;
                while (j < currentKeyList.getLength()) {
                    workElement2 = (Element)currentKeyList.item(j);
                    if (this.isIdenticalKeyDefinition(modelTableElement, workElement1, workElement2)) {
                        childElement = workElement2;
                        break;
                    }
                    ++j;
                }
                if (childElement == null) {
                    childElement = this.frame_.getDomDocument().createElement("Key");
                    childElement.setAttribute("Type", workElement1.getAttribute("Type"));
                    childElement.setAttribute("Fields", this.getFieldIDListOfTableKeyFrom(modelTableElement, workElement1));
                    currentTableElement.appendChild(childElement);
                }
            }
            ++i;
        }
    }

    private boolean isIdenticalKeyDefinition(Element modelTableElement, Element modelKeyElement, Element currentKeyElement) {
        boolean isIdentical = false;
        String keyFieldIDFrom = this.getFieldIDListOfTableKeyFrom(modelTableElement, modelKeyElement);
        if (modelKeyElement.getAttribute("Type").equals("SK") && currentKeyElement.getAttribute("Fields").equals(keyFieldIDFrom)) {
            isIdentical = true;
        }
        if (modelKeyElement.getAttribute("Type").equals("XK")) {
            String keyFieldIDCurrent = "";
            StringTokenizer tokenizer = new StringTokenizer(currentKeyElement.getAttribute("Fields"), ";");
            while (tokenizer.hasMoreTokens()) {
                String wrkStr = tokenizer.nextToken();
                if (!wrkStr.endsWith("(A)") && !wrkStr.endsWith("(D)")) {
                    wrkStr = String.valueOf(wrkStr) + "(A)";
                }
                if (!keyFieldIDCurrent.equals("")) {
                    keyFieldIDCurrent = String.valueOf(keyFieldIDCurrent) + ";";
                }
                keyFieldIDCurrent = String.valueOf(keyFieldIDCurrent) + wrkStr;
            }
            if (keyFieldIDCurrent.equals(keyFieldIDFrom)) {
                isIdentical = true;
            }
        }
        return isIdentical;
    }

    private void importToCreateFunction(Element modelElement, String functionID) {
        Element grandChildElement;
        ArrayList<String> headerPKFieldIDList;
        String dataType;
        Element childElement;
        Editor.SortableDomElementListModel sortingList;
        int i;
        Element workElement;
        String primaryTableID = "";
        String headerTableID = "";
        ArrayList<String> detailTableIDList = new ArrayList<String>();
        ArrayList<String> detailTableKeysList = new ArrayList<String>();
        ArrayList<String> headerTableKeysList = new ArrayList<String>();
        String detailKeyFields = "";
        Element primaryTableElement = null;
        Element headerTableElement = null;
        ArrayList<Element> detailTableElementList = new ArrayList<Element>();
        String functionType = "";
        int i2 = 0;
        while (i2 < this.functionTypeList.getLength()) {
            workElement = (Element)this.functionTypeList.item(i2);
            if (workElement.getAttribute("ID").equals(modelElement.getAttribute("FunctionTypeID"))) {
                functionType = workElement.getAttribute("SortKey").trim();
                break;
            }
            ++i2;
        }
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("System");
        Element systemElementImportInto = (Element)nodeList.item(0);
        Element newElementToBeAdded = this.frame_.getDomDocument().createElement("Function");
        systemElementImportInto.appendChild(newElementToBeAdded);
        newElementToBeAdded.setAttribute("ID", functionID);
        newElementToBeAdded.setAttribute("Name", modelElement.getAttribute("Name"));
        newElementToBeAdded.setAttribute("SubsystemID", this.subsystemElementFrom.getAttribute("SortKey"));
        newElementToBeAdded.setAttribute("Type", functionType);
        if (functionType.equals("XF100") || functionType.equals("XF110") || functionType.equals("XF200") || functionType.equals("XF290")) {
            nodeList = modelElement.getElementsByTagName("IOTable");
            if (nodeList.getLength() == 1) {
                workElement = (Element)nodeList.item(0);
                primaryTableID = this.convertTableInternalIDToExternalID(workElement.getAttribute("TableID"));
            } else {
                int i3 = 0;
                while (i3 < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i3);
                    if (workElement.getAttribute("Position").equals("PRIMARY") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("PRIMARY") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("PrimaryTable").toUpperCase())) {
                        primaryTableID = this.convertTableInternalIDToExternalID(workElement.getAttribute("TableID"));
                        break;
                    }
                    ++i3;
                }
            }
            primaryTableElement = this.getCurrentTableElementWithID(primaryTableID);
        }
        if (functionType.equals("XF300") || functionType.equals("XF310") || functionType.equals("XF390")) {
            String headerTableInternalID = "";
            String detailTableInternalID = "";
            nodeList = modelElement.getElementsByTagName("IOTable");
            int i4 = 0;
            while (i4 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i4);
                if (workElement.getAttribute("Position").equals("HEADER") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("HEADER") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("HeaderTable").toUpperCase())) {
                    headerTableInternalID = workElement.getAttribute("TableID");
                    headerTableID = this.convertTableInternalIDToExternalID(headerTableInternalID);
                    headerTableElement = this.getCurrentTableElementWithID(headerTableID);
                    break;
                }
                ++i4;
            }
            i = 0;
            while (i < nodeList.getLength()) {
                String tableID;
                workElement = (Element)nodeList.item(i);
                if ((workElement.getAttribute("Position").equals("DETAIL") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("DETAIL") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("DetailTable").toUpperCase())) && this.isExistingTable(tableID = this.convertTableInternalIDToExternalID(detailTableInternalID = workElement.getAttribute("TableID"))) && this.isValidWithKeys(headerTableInternalID, detailTableInternalID)) {
                    detailTableIDList.add(tableID);
                    String[] keys = this.getDetailKeys(headerTableInternalID, detailTableInternalID);
                    headerTableKeysList.add(keys[0]);
                    detailTableKeysList.add(keys[1]);
                    detailTableElementList.add(this.getCurrentTableElementWithID(tableID));
                }
                ++i;
            }
        }
        if (functionType.equals("XF000")) {
            String comment = "";
            if (!modelElement.getAttribute("Summary").equals("")) {
                comment = "//" + modelElement.getAttribute("Summary") + "\n";
            }
            if (!modelElement.getAttribute("Descriptions").equals("")) {
                comment = String.valueOf(comment) + "//" + modelElement.getAttribute("Descriptions") + "\n";
            }
            newElementToBeAdded.setAttribute("Script", comment);
        }
        if (functionType.equals("XF100")) {
            newElementToBeAdded.setAttribute("PrimaryTable", primaryTableID);
            newElementToBeAdded.setAttribute("KeyFields", "");
            newElementToBeAdded.setAttribute("OrderBy", "");
            newElementToBeAdded.setAttribute("Size", "AUTO");
            newElementToBeAdded.setAttribute("InitialMsg", "");
            newElementToBeAdded.setAttribute("InitialListing", "T");
            nodeList = modelElement.getElementsByTagName("FunctionUsedByThis");
            if (nodeList.getLength() == 1) {
                workElement = (Element)nodeList.item(0);
                newElementToBeAdded.setAttribute("DetailFunction", this.convertFunctionInternalIDToExternalID(workElement.getAttribute("FunctionID")));
            } else {
                newElementToBeAdded.setAttribute("DetailFunction", "NONE");
            }
            nodeList = primaryTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            int i5 = 0;
            while (i5 < sortingList.getSize()) {
                if (i5 >= 5) break;
                workElement = (Element)sortingList.getElementAt(i5);
                childElement = this.frame_.getDomDocument().createElement("Column");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i5 * 10));
                childElement.setAttribute("DataSource", String.valueOf(primaryTableID) + "." + workElement.getAttribute("ID"));
                childElement.setAttribute("FieldOptions", "");
                newElementToBeAdded.appendChild(childElement);
                ++i5;
            }
            i5 = 0;
            while (i5 < sortingList.getSize()) {
                if (i5 >= 3) break;
                workElement = (Element)sortingList.getElementAt(i5);
                childElement = this.frame_.getDomDocument().createElement("Filter");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i5 * 10));
                childElement.setAttribute("DataSource", String.valueOf(primaryTableID) + "." + workElement.getAttribute("ID"));
                dataType = workElement.getAttribute("Type");
                if (this.frame_.getBasicTypeOf(dataType).equals("INTEGER") || this.frame_.getBasicTypeOf(dataType).equals("FLOAT")) {
                    childElement.setAttribute("FieldOptions", "IGNORE_IF_ZERO");
                } else {
                    childElement.setAttribute("FieldOptions", "");
                }
                newElementToBeAdded.appendChild(childElement);
                ++i5;
            }
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "0");
            childElement.setAttribute("Number", "3");
            childElement.setAttribute("Caption", res.getString("Close"));
            childElement.setAttribute("Action", "EXIT");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "3");
            childElement.setAttribute("Number", "6");
            childElement.setAttribute("Caption", res.getString("Add"));
            childElement.setAttribute("Action", "ADD");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "6");
            childElement.setAttribute("Number", "12");
            childElement.setAttribute("Caption", res.getString("Output"));
            childElement.setAttribute("Action", "OUTPUT");
            newElementToBeAdded.appendChild(childElement);
        }
        if (functionType.equals("XF110")) {
            newElementToBeAdded.setAttribute("PrimaryTable", primaryTableID);
            newElementToBeAdded.setAttribute("KeyFields", "");
            newElementToBeAdded.setAttribute("OrderBy", "");
            newElementToBeAdded.setAttribute("BatchTable", "");
            newElementToBeAdded.setAttribute("BatchKeyFields", "");
            newElementToBeAdded.setAttribute("BatchWithKeyFields", "");
            newElementToBeAdded.setAttribute("Size", "AUTO");
            newElementToBeAdded.setAttribute("InitialMsg", "");
            newElementToBeAdded.setAttribute("InitialListing", "T");
            nodeList = primaryTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            int i6 = 0;
            while (i6 < sortingList.getSize()) {
                if (i6 >= 5) break;
                workElement = (Element)sortingList.getElementAt(i6);
                childElement = this.frame_.getDomDocument().createElement("Column");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i6 * 10));
                childElement.setAttribute("DataSource", String.valueOf(primaryTableID) + "." + workElement.getAttribute("ID"));
                childElement.setAttribute("FieldOptions", "");
                newElementToBeAdded.appendChild(childElement);
                ++i6;
            }
            i6 = 0;
            while (i6 < sortingList.getSize()) {
                if (i6 >= 3) break;
                workElement = (Element)sortingList.getElementAt(i6);
                childElement = this.frame_.getDomDocument().createElement("Filter");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i6 * 10));
                childElement.setAttribute("DataSource", String.valueOf(primaryTableID) + "." + workElement.getAttribute("ID"));
                dataType = workElement.getAttribute("Type");
                if (this.frame_.getBasicTypeOf(dataType).equals("INTEGER") || this.frame_.getBasicTypeOf(dataType).equals("FLOAT")) {
                    childElement.setAttribute("FieldOptions", "IGNORE_IF_ZERO");
                } else {
                    childElement.setAttribute("FieldOptions", "");
                }
                newElementToBeAdded.appendChild(childElement);
                ++i6;
            }
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "0");
            childElement.setAttribute("Number", "3");
            childElement.setAttribute("Caption", res.getString("Close"));
            childElement.setAttribute("Action", "EXIT");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "2");
            childElement.setAttribute("Number", "4");
            childElement.setAttribute("Caption", res.getString("Previous"));
            childElement.setAttribute("Action", "PREV");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "4");
            childElement.setAttribute("Number", "5");
            childElement.setAttribute("Caption", res.getString("Next"));
            childElement.setAttribute("Action", "NEXT");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "4");
            childElement.setAttribute("Number", "5");
            childElement.setAttribute("Caption", res.getString("Update"));
            childElement.setAttribute("Action", "UPDATE");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "6");
            childElement.setAttribute("Number", "12");
            childElement.setAttribute("Caption", res.getString("Output"));
            childElement.setAttribute("Action", "OUTPUT");
            newElementToBeAdded.appendChild(childElement);
        }
        if (functionType.equals("XF200")) {
            newElementToBeAdded.setAttribute("PrimaryTable", primaryTableID);
            newElementToBeAdded.setAttribute("KeyFields", "");
            newElementToBeAdded.setAttribute("Size", "AUTO");
            newElementToBeAdded.setAttribute("InitialMsg", "");
            nodeList = primaryTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            int i7 = 0;
            while (i7 < sortingList.getSize()) {
                workElement = (Element)sortingList.getElementAt(i7);
                childElement = this.frame_.getDomDocument().createElement("Field");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i7 * 10));
                childElement.setAttribute("DataSource", String.valueOf(primaryTableID) + "." + workElement.getAttribute("ID"));
                childElement.setAttribute("FieldOptions", "");
                newElementToBeAdded.appendChild(childElement);
                ++i7;
            }
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "0");
            childElement.setAttribute("Number", "3");
            childElement.setAttribute("Caption", res.getString("Close"));
            childElement.setAttribute("Action", "EXIT");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "2");
            childElement.setAttribute("Number", "5");
            childElement.setAttribute("Caption", res.getString("Edit"));
            childElement.setAttribute("Action", "EDIT");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "3");
            childElement.setAttribute("Number", "7");
            childElement.setAttribute("Caption", res.getString("Copy"));
            childElement.setAttribute("Action", "COPY");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "4");
            childElement.setAttribute("Number", "9");
            childElement.setAttribute("Caption", res.getString("Delete"));
            childElement.setAttribute("Action", "DELETE");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "6");
            childElement.setAttribute("Number", "12");
            childElement.setAttribute("Caption", res.getString("Output"));
            childElement.setAttribute("Action", "OUTPUT");
            newElementToBeAdded.appendChild(childElement);
        }
        if (functionType.equals("XF290")) {
            newElementToBeAdded.setAttribute("PrimaryTable", primaryTableID);
            newElementToBeAdded.setAttribute("KeyFields", "");
            newElementToBeAdded.setAttribute("PageSize", "A4");
            newElementToBeAdded.setAttribute("Direction", "NORMAL");
            newElementToBeAdded.setAttribute("Margins", "50;50;50;50");
            newElementToBeAdded.setAttribute("WithPageNumber", "F");
            String defaultFontID = "";
            NodeList fontList = this.frame_.getDomDocument().getElementsByTagName("PrintFont");
            sortingList = this.frame_.getSortedListModel(fontList, "FontName");
            Element fontElement = (Element)sortingList.getElementAt(0);
            defaultFontID = fontElement.getAttribute("ID");
            childElement = this.frame_.getDomDocument().createElement("Phrase");
            childElement.setAttribute("Order", "0000");
            childElement.setAttribute("Block", "HEADER");
            childElement.setAttribute("Value", "&Text(" + modelElement.getAttribute("Name").replace("\u306e\u5370\u5237", "").replace("\u306e\u767a\u884c", "") + ")");
            childElement.setAttribute("Alignment", "CENTER");
            childElement.setAttribute("FontID", defaultFontID);
            childElement.setAttribute("FontSize", "15");
            childElement.setAttribute("FontStyle", "BOLD");
            newElementToBeAdded.appendChild(childElement);
            nodeList = primaryTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            i = 0;
            while (i < sortingList.getSize()) {
                if (i >= 5) break;
                workElement = (Element)sortingList.getElementAt(i);
                childElement = this.frame_.getDomDocument().createElement("Phrase");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString((i + 1) * 10));
                childElement.setAttribute("Block", "PARAGRAPH");
                childElement.setAttribute("Value", "&DataSource(" + primaryTableID + "." + workElement.getAttribute("ID") + ")");
                childElement.setAttribute("Alignment", "LEFT");
                childElement.setAttribute("AlignmentMargin", "0");
                childElement.setAttribute("FontID", defaultFontID);
                childElement.setAttribute("FontSize", "12");
                childElement.setAttribute("FontStyle", "");
                newElementToBeAdded.appendChild(childElement);
                ++i;
            }
        }
        if (functionType.equals("XF300")) {
            String headerKeyFields = "";
            headerPKFieldIDList = new ArrayList<String>();
            nodeList = headerTableElement.getElementsByTagName("Key");
            int i8 = 0;
            while (i8 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i8);
                if (workElement.getAttribute("Type").equals("PK")) {
                    headerKeyFields = workElement.getAttribute("Fields");
                    StringTokenizer tokenizer = new StringTokenizer(headerKeyFields, ";");
                    while (tokenizer.hasMoreTokens()) {
                        headerPKFieldIDList.add(tokenizer.nextToken());
                    }
                    break;
                }
                ++i8;
            }
            newElementToBeAdded.setAttribute("HeaderTable", headerTableID);
            newElementToBeAdded.setAttribute("HeaderKeyFields", "");
            newElementToBeAdded.setAttribute("HeaderFunction", "");
            newElementToBeAdded.setAttribute("Size", "AUTO");
            nodeList = headerTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            i8 = 0;
            while (i8 < sortingList.getSize()) {
                if (i8 >= 7) break;
                workElement = (Element)sortingList.getElementAt(i8);
                childElement = this.frame_.getDomDocument().createElement("Field");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i8 * 10));
                childElement.setAttribute("DataSource", String.valueOf(headerTableID) + "." + workElement.getAttribute("ID"));
                childElement.setAttribute("FieldOptions", "");
                newElementToBeAdded.appendChild(childElement);
                ++i8;
            }
            int p = 0;
            while (p < detailTableElementList.size() || p < 20) {
                if (((String)detailTableKeysList.get(p)).equals("")) {
                    nodeList = ((Element)detailTableElementList.get(p)).getElementsByTagName("Key");
                    int i9 = 0;
                    while (i9 < nodeList.getLength()) {
                        workElement = (Element)nodeList.item(i9);
                        if (workElement.getAttribute("Type").equals("PK")) {
                            detailKeyFields = workElement.getAttribute("Fields");
                            break;
                        }
                        ++i9;
                    }
                } else {
                    detailKeyFields = (String)detailTableKeysList.get(p);
                }
                childElement = this.frame_.getDomDocument().createElement("Detail");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString((p + 1) * 10));
                childElement.setAttribute("Table", (String)detailTableIDList.get(p));
                childElement.setAttribute("HeaderKeyFields", (String)headerTableKeysList.get(p));
                childElement.setAttribute("KeyFields", this.getAdjustedOrderOfKeyFields(headerTableID, (String)headerTableKeysList.get(p), (String)detailTableIDList.get(p), detailKeyFields));
                childElement.setAttribute("DetailFunction", "NONE");
                childElement.setAttribute("Caption", ((Element)detailTableElementList.get(p)).getAttribute("Name"));
                childElement.setAttribute("InitialMsg", "");
                childElement.setAttribute("InitialListing", "T");
                newElementToBeAdded.appendChild(childElement);
                int columnCount = 0;
                nodeList = ((Element)detailTableElementList.get(p)).getElementsByTagName("Field");
                sortingList = this.frame_.getSortedListModel(nodeList, "Order");
                int i10 = 0;
                while (i10 < sortingList.getSize()) {
                    if (columnCount >= 5) break;
                    workElement = (Element)sortingList.getElementAt(i10);
                    if (!headerPKFieldIDList.contains(workElement.getAttribute("ID"))) {
                        grandChildElement = this.frame_.getDomDocument().createElement("Column");
                        grandChildElement.setAttribute("Order", Editor.getFormatted4ByteString(columnCount * 10));
                        grandChildElement.setAttribute("DataSource", String.valueOf((String)detailTableIDList.get(p)) + "." + workElement.getAttribute("ID"));
                        grandChildElement.setAttribute("FieldOptions", "");
                        childElement.appendChild(grandChildElement);
                        ++columnCount;
                    }
                    ++i10;
                }
                grandChildElement = this.frame_.getDomDocument().createElement("Button");
                grandChildElement.setAttribute("Position", "0");
                grandChildElement.setAttribute("Number", "3");
                grandChildElement.setAttribute("Caption", res.getString("Close"));
                grandChildElement.setAttribute("Action", "EXIT");
                childElement.appendChild(grandChildElement);
                grandChildElement = this.frame_.getDomDocument().createElement("Button");
                grandChildElement.setAttribute("Position", "2");
                grandChildElement.setAttribute("Number", "6");
                grandChildElement.setAttribute("Caption", res.getString("Add"));
                grandChildElement.setAttribute("Action", "ADD");
                childElement.appendChild(grandChildElement);
                grandChildElement = this.frame_.getDomDocument().createElement("Button");
                grandChildElement.setAttribute("Position", "4");
                grandChildElement.setAttribute("Number", "8");
                grandChildElement.setAttribute("Caption", res.getString("HDRData"));
                grandChildElement.setAttribute("Action", "HEADER");
                childElement.appendChild(grandChildElement);
                grandChildElement = this.frame_.getDomDocument().createElement("Button");
                grandChildElement.setAttribute("Position", "6");
                grandChildElement.setAttribute("Number", "12");
                grandChildElement.setAttribute("Caption", res.getString("Output"));
                grandChildElement.setAttribute("Action", "OUTPUT");
                childElement.appendChild(grandChildElement);
                ++p;
            }
        }
        if (functionType.equals("XF310")) {
            String headerKeyFields = "";
            headerPKFieldIDList = new ArrayList();
            nodeList = headerTableElement.getElementsByTagName("Key");
            int i11 = 0;
            while (i11 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i11);
                if (workElement.getAttribute("Type").equals("PK")) {
                    headerKeyFields = workElement.getAttribute("Fields");
                    StringTokenizer tokenizer = new StringTokenizer(headerKeyFields, ";");
                    while (tokenizer.hasMoreTokens()) {
                        headerPKFieldIDList.add(tokenizer.nextToken());
                    }
                    break;
                }
                ++i11;
            }
            nodeList = ((Element)detailTableElementList.get(0)).getElementsByTagName("Key");
            i11 = 0;
            while (i11 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i11);
                if (workElement.getAttribute("Type").equals("PK")) {
                    detailKeyFields = workElement.getAttribute("Fields");
                    break;
                }
                ++i11;
            }
            newElementToBeAdded.setAttribute("HeaderTable", headerTableID);
            newElementToBeAdded.setAttribute("HeaderKeyFields", headerKeyFields);
            newElementToBeAdded.setAttribute("DetailTable", (String)detailTableIDList.get(0));
            newElementToBeAdded.setAttribute("DetailKeyFields", detailKeyFields);
            newElementToBeAdded.setAttribute("Size", "AUTO");
            nodeList = headerTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            i11 = 0;
            while (i11 < sortingList.getSize()) {
                if (i11 >= 7) break;
                workElement = (Element)sortingList.getElementAt(i11);
                childElement = this.frame_.getDomDocument().createElement("Field");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString(i11 * 10));
                childElement.setAttribute("DataSource", String.valueOf(headerTableID) + "." + workElement.getAttribute("ID"));
                childElement.setAttribute("FieldOptions", "");
                newElementToBeAdded.appendChild(childElement);
                ++i11;
            }
            int columnCount = 0;
            nodeList = ((Element)detailTableElementList.get(0)).getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            int i12 = 0;
            while (i12 < sortingList.getSize()) {
                if (columnCount >= 5) break;
                workElement = (Element)sortingList.getElementAt(i12);
                if (!headerPKFieldIDList.contains(workElement.getAttribute("ID"))) {
                    childElement = this.frame_.getDomDocument().createElement("Column");
                    childElement.setAttribute("Order", Editor.getFormatted4ByteString(columnCount * 10));
                    childElement.setAttribute("DataSource", String.valueOf((String)detailTableIDList.get(0)) + "." + workElement.getAttribute("ID"));
                    childElement.setAttribute("FieldOptions", "");
                    newElementToBeAdded.appendChild(childElement);
                    ++columnCount;
                }
                ++i12;
            }
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "0");
            childElement.setAttribute("Number", "3");
            childElement.setAttribute("Caption", res.getString("Close"));
            childElement.setAttribute("Action", "EXIT");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "2");
            childElement.setAttribute("Number", "5");
            childElement.setAttribute("Caption", res.getString("Update"));
            childElement.setAttribute("Action", "UPDATE");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "4");
            childElement.setAttribute("Number", "6");
            childElement.setAttribute("Caption", res.getString("AddRow"));
            childElement.setAttribute("Action", "ADD_ROW");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "5");
            childElement.setAttribute("Number", "9");
            childElement.setAttribute("Caption", res.getString("RemoveRow"));
            childElement.setAttribute("Action", "REMOVE_ROW");
            newElementToBeAdded.appendChild(childElement);
            childElement = this.frame_.getDomDocument().createElement("Button");
            childElement.setAttribute("Position", "6");
            childElement.setAttribute("Number", "12");
            childElement.setAttribute("Caption", res.getString("Output"));
            childElement.setAttribute("Action", "OUTPUT");
            newElementToBeAdded.appendChild(childElement);
        }
        if (functionType.equals("XF390")) {
            String headerKeyFields = "";
            headerPKFieldIDList = new ArrayList();
            nodeList = headerTableElement.getElementsByTagName("Key");
            int i13 = 0;
            while (i13 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i13);
                if (workElement.getAttribute("Type").equals("PK")) {
                    headerKeyFields = workElement.getAttribute("Fields");
                    StringTokenizer tokenizer = new StringTokenizer(headerKeyFields, ";");
                    while (tokenizer.hasMoreTokens()) {
                        headerPKFieldIDList.add(tokenizer.nextToken());
                    }
                    break;
                }
                ++i13;
            }
            nodeList = ((Element)detailTableElementList.get(0)).getElementsByTagName("Key");
            i13 = 0;
            while (i13 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i13);
                if (workElement.getAttribute("Type").equals("PK")) {
                    detailKeyFields = workElement.getAttribute("Fields");
                    break;
                }
                ++i13;
            }
            String defaultFontID = "";
            NodeList fontList = this.frame_.getDomDocument().getElementsByTagName("PrintFont");
            sortingList = this.frame_.getSortedListModel(fontList, "FontName");
            Element fontElement = (Element)sortingList.getElementAt(0);
            defaultFontID = fontElement.getAttribute("ID");
            newElementToBeAdded.setAttribute("HeaderTable", headerTableID);
            newElementToBeAdded.setAttribute("HeaderKeyFields", headerKeyFields);
            newElementToBeAdded.setAttribute("PageSize", "A4");
            newElementToBeAdded.setAttribute("Direction", "LANDSCAPE");
            newElementToBeAdded.setAttribute("Margins", "50;50;50;50");
            newElementToBeAdded.setAttribute("WithPageNumber", "T");
            childElement = this.frame_.getDomDocument().createElement("HeaderPhrase");
            childElement.setAttribute("Order", "0000");
            childElement.setAttribute("Block", "HEADER");
            childElement.setAttribute("Value", "&Text(" + modelElement.getAttribute("Name").replace("\u306e\u5370\u5237", "").replace("\u306e\u767a\u884c", "") + ")");
            childElement.setAttribute("Alignment", "CENTER");
            childElement.setAttribute("FontID", defaultFontID);
            childElement.setAttribute("FontSize", "15");
            childElement.setAttribute("FontStyle", "BOLD");
            newElementToBeAdded.appendChild(childElement);
            nodeList = headerTableElement.getElementsByTagName("Field");
            sortingList = this.frame_.getSortedListModel(nodeList, "Order");
            int i14 = 0;
            while (i14 < sortingList.getSize()) {
                if (i14 >= 5) break;
                workElement = (Element)sortingList.getElementAt(i14);
                childElement = this.frame_.getDomDocument().createElement("HeaderPhrase");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString((i14 + 1) * 10));
                childElement.setAttribute("Block", "PARAGRAPH");
                childElement.setAttribute("Value", "&DataSource(" + headerTableID + "." + workElement.getAttribute("ID") + ")");
                childElement.setAttribute("Alignment", "LEFT");
                childElement.setAttribute("AlignmentMargin", "0");
                childElement.setAttribute("FontID", defaultFontID);
                childElement.setAttribute("FontSize", "12");
                childElement.setAttribute("FontStyle", "");
                newElementToBeAdded.appendChild(childElement);
                ++i14;
            }
            int p = 0;
            while (p < detailTableElementList.size()) {
                if (((String)detailTableKeysList.get(p)).equals("")) {
                    nodeList = ((Element)detailTableElementList.get(p)).getElementsByTagName("Key");
                    int i15 = 0;
                    while (i15 < nodeList.getLength()) {
                        workElement = (Element)nodeList.item(i15);
                        if (workElement.getAttribute("Type").equals("PK")) {
                            detailKeyFields = workElement.getAttribute("Fields");
                            break;
                        }
                        ++i15;
                    }
                } else {
                    detailKeyFields = (String)detailTableKeysList.get(p);
                }
                childElement = this.frame_.getDomDocument().createElement("Detail");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString((p + 1) * 10));
                childElement.setAttribute("Table", (String)detailTableIDList.get(p));
                childElement.setAttribute("HeaderKeyFields", (String)headerTableKeysList.get(p));
                childElement.setAttribute("KeyFields", detailKeyFields);
                if (detailTableElementList.size() > 1) {
                    childElement.setAttribute("Caption", ((Element)detailTableElementList.get(p)).getAttribute("Name"));
                } else {
                    childElement.setAttribute("Caption", "");
                }
                childElement.setAttribute("CaptionFontSize", "12");
                childElement.setAttribute("CaptionFontStyle", "");
                childElement.setAttribute("FontID", defaultFontID);
                childElement.setAttribute("FontSize", "10");
                childElement.setAttribute("RowNoWidth", "5");
                newElementToBeAdded.appendChild(childElement);
                int columnCount = 0;
                nodeList = ((Element)detailTableElementList.get(p)).getElementsByTagName("Field");
                sortingList = this.frame_.getSortedListModel(nodeList, "Order");
                int i16 = 0;
                while (i16 < sortingList.getSize()) {
                    if (columnCount >= 5) break;
                    workElement = (Element)sortingList.getElementAt(i16);
                    if (!headerPKFieldIDList.contains(workElement.getAttribute("ID"))) {
                        grandChildElement = this.frame_.getDomDocument().createElement("Column");
                        grandChildElement.setAttribute("Order", Editor.getFormatted4ByteString(columnCount * 10));
                        grandChildElement.setAttribute("DataSource", String.valueOf((String)detailTableIDList.get(p)) + "." + workElement.getAttribute("ID"));
                        grandChildElement.setAttribute("FieldOptions", "");
                        grandChildElement.setAttribute("Width", "19");
                        grandChildElement.setAttribute("Alignment", "LEFT");
                        childElement.appendChild(grandChildElement);
                        ++columnCount;
                    }
                    ++i16;
                }
                ++p;
            }
        }
    }

    private String getAdjustedOrderOfKeyFields(String headerTableID, String headerKeyFields, String detailTableID, String detailKeyFields) {
        Element elementDetailField;
        String wrkStr;
        String returnValue = "";
        boolean isError = false;
        ArrayList<Element> detailKeyFieldElementList = new ArrayList<Element>();
        StringTokenizer tokenizer = new StringTokenizer(detailKeyFields, ";");
        while (tokenizer.hasMoreTokens()) {
            wrkStr = tokenizer.nextToken();
            elementDetailField = this.frame_.getSpecificFieldElement(detailTableID, wrkStr);
            if (elementDetailField == null) {
                isError = true;
                break;
            }
            detailKeyFieldElementList.add(elementDetailField);
        }
        if (!isError) {
            int i;
            tokenizer = new StringTokenizer(headerKeyFields, ";");
            while (tokenizer.hasMoreTokens()) {
                wrkStr = tokenizer.nextToken();
                Element elementHeaderField = this.frame_.getSpecificFieldElement(headerTableID, wrkStr);
                String correspondingFieldID = "";
                i = 0;
                while (i < detailKeyFieldElementList.size()) {
                    elementDetailField = (Element)detailKeyFieldElementList.get(i);
                    if (elementHeaderField.getAttribute("ID").equals(elementDetailField.getAttribute("ID"))) {
                        correspondingFieldID = elementDetailField.getAttribute("ID");
                        detailKeyFieldElementList.remove(i);
                        break;
                    }
                    ++i;
                }
                if (correspondingFieldID.equals("")) {
                    i = 0;
                    while (i < detailKeyFieldElementList.size()) {
                        elementDetailField = (Element)detailKeyFieldElementList.get(i);
                        if (elementHeaderField.getAttribute("Type").equals(elementDetailField.getAttribute("Type"))) {
                            correspondingFieldID = elementDetailField.getAttribute("ID");
                            detailKeyFieldElementList.remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (correspondingFieldID.equals("")) {
                    isError = true;
                    break;
                }
                if (!returnValue.equals("")) {
                    returnValue = String.valueOf(returnValue) + ";";
                }
                returnValue = String.valueOf(returnValue) + correspondingFieldID;
            }
            if (!isError) {
                i = 0;
                while (i < detailKeyFieldElementList.size()) {
                    if (!returnValue.equals("")) {
                        returnValue = String.valueOf(returnValue) + ";";
                    }
                    returnValue = String.valueOf(returnValue) + ((Element)detailKeyFieldElementList.get(i)).getAttribute("ID");
                    ++i;
                }
            }
        }
        if (isError) {
            return detailKeyFields;
        }
        return returnValue;
    }

    private void importToUpdateFunction(Element modelFunctionElement, Element currentFunctionElement) {
        Element workElement;
        currentFunctionElement.setAttribute("Name", modelFunctionElement.getAttribute("Name"));
        currentFunctionElement.setAttribute("SubsystemID", this.subsystemElementFrom.getAttribute("SortKey"));
        String functionType = "";
        int i = 0;
        while (i < this.functionTypeList.getLength()) {
            workElement = (Element)this.functionTypeList.item(i);
            if (workElement.getAttribute("ID").equals(modelFunctionElement.getAttribute("FunctionTypeID"))) {
                functionType = workElement.getAttribute("SortKey").trim();
                break;
            }
            ++i;
        }
        if (functionType.equals("XF000") && currentFunctionElement.getAttribute("Script").equals("")) {
            String comment = "";
            if (!modelFunctionElement.getAttribute("Summary").equals("")) {
                comment = "// " + modelFunctionElement.getAttribute("Summary") + "\n";
            }
            if (!modelFunctionElement.getAttribute("Descriptions").equals("")) {
                comment = String.valueOf(comment) + "// " + modelFunctionElement.getAttribute("Descriptions") + "\n";
            }
            currentFunctionElement.setAttribute("Script", comment);
        }
        if (functionType.equals("XF300") || functionType.equals("XF390")) {
            Editor.SortableDomElementListModel sortingList;
            int j;
            String headerTableID = "";
            Element headerTableElement = null;
            Element childElement = null;
            Element grandChildElement = null;
            String headerTableInternalID = "";
            String detailTableInternalID = "";
            String detailTableExternalID = "";
            String headerKeyFields = "";
            String detailKeyFields = "";
            ArrayList<Element> detailTableElementList = new ArrayList<Element>();
            NodeList nodeList = modelFunctionElement.getElementsByTagName("IOTable");
            int i2 = 0;
            block1: while (i2 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i2);
                if (workElement.getAttribute("Position").equals("HEADER") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("HEADER") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("HeaderTable").toUpperCase())) {
                    headerTableInternalID = workElement.getAttribute("TableID");
                    headerTableID = this.convertTableInternalIDToExternalID(headerTableInternalID);
                    headerTableElement = this.getCurrentTableElementWithID(headerTableID);
                    NodeList nodeList2 = headerTableElement.getElementsByTagName("Key");
                    j = 0;
                    while (j < nodeList2.getLength()) {
                        Element workElement2 = (Element)nodeList2.item(j);
                        if (workElement2.getAttribute("Type").equals("PK")) {
                            headerKeyFields = workElement2.getAttribute("Fields");
                            break block1;
                        }
                        ++j;
                    }
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < nodeList.getLength()) {
                workElement = (Element)nodeList.item(i2);
                if ((workElement.getAttribute("Position").equals("DETAIL") || workElement.getAttribute("NameExtension").toUpperCase().startsWith("DETAIL") || workElement.getAttribute("Descriptions").toUpperCase().startsWith(res.getString("DetailTable").toUpperCase())) && this.isExistingTable(detailTableExternalID = this.convertTableInternalIDToExternalID(detailTableInternalID = workElement.getAttribute("TableID"))) && this.isValidWithKeys(headerTableInternalID, detailTableInternalID)) {
                    NodeList detailTabList = currentFunctionElement.getElementsByTagName("Detail");
                    boolean isFound = false;
                    j = 0;
                    while (j < detailTabList.getLength()) {
                        workElement = (Element)detailTabList.item(j);
                        if (workElement.getAttribute("Table").equals(detailTableExternalID)) {
                            isFound = true;
                            break;
                        }
                        ++j;
                    }
                    if (!isFound) {
                        detailTableElementList.add(this.getCurrentTableElementWithID(detailTableExternalID));
                    }
                }
                ++i2;
            }
            String defaultFontID = "";
            if (functionType.equals("XF390")) {
                NodeList fontList = this.frame_.getDomDocument().getElementsByTagName("PrintFont");
                sortingList = this.frame_.getSortedListModel(fontList, "FontName");
                workElement = (Element)sortingList.getElementAt(0);
                defaultFontID = workElement.getAttribute("ID");
            }
            int p = 0;
            while (p < detailTableElementList.size()) {
                nodeList = ((Element)detailTableElementList.get(p)).getElementsByTagName("Key");
                int i3 = 0;
                while (i3 < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i3);
                    if (workElement.getAttribute("Type").equals("PK")) {
                        detailKeyFields = workElement.getAttribute("Fields");
                        break;
                    }
                    ++i3;
                }
                childElement = this.frame_.getDomDocument().createElement("Detail");
                childElement.setAttribute("Order", Editor.getFormatted4ByteString((p + 1) * 10));
                childElement.setAttribute("Table", ((Element)detailTableElementList.get(p)).getAttribute("ID"));
                childElement.setAttribute("HeaderKeyFields", headerKeyFields);
                childElement.setAttribute("KeyFields", detailKeyFields);
                childElement.setAttribute("Caption", ((Element)detailTableElementList.get(p)).getAttribute("Name"));
                if (functionType.equals("XF390")) {
                    childElement.setAttribute("CaptionFontSize", "12");
                    childElement.setAttribute("CaptionFontStyle", "");
                    childElement.setAttribute("FontID", defaultFontID);
                    childElement.setAttribute("FontSize", "10");
                    childElement.setAttribute("RowNoWidth", "5");
                }
                currentFunctionElement.appendChild(childElement);
                int columnCount = 0;
                nodeList = ((Element)detailTableElementList.get(p)).getElementsByTagName("Field");
                sortingList = this.frame_.getSortedListModel(nodeList, "Order");
                int i4 = 0;
                while (i4 < sortingList.getSize()) {
                    if (columnCount >= 5) break;
                    workElement = (Element)sortingList.getElementAt(i4);
                    if (!headerKeyFields.contains(workElement.getAttribute("ID"))) {
                        grandChildElement = this.frame_.getDomDocument().createElement("Column");
                        grandChildElement.setAttribute("Order", Editor.getFormatted4ByteString(columnCount * 10));
                        grandChildElement.setAttribute("DataSource", String.valueOf(((Element)detailTableElementList.get(p)).getAttribute("ID")) + "." + workElement.getAttribute("ID"));
                        grandChildElement.setAttribute("FieldOptions", "");
                        if (functionType.equals("XF390")) {
                            grandChildElement.setAttribute("Width", "19");
                            grandChildElement.setAttribute("Alignment", "LEFT");
                        }
                        childElement.appendChild(grandChildElement);
                        ++columnCount;
                    }
                    ++i4;
                }
                if (functionType.equals("XF300")) {
                    grandChildElement = this.frame_.getDomDocument().createElement("Button");
                    grandChildElement.setAttribute("Position", "0");
                    grandChildElement.setAttribute("Number", "3");
                    grandChildElement.setAttribute("Caption", res.getString("Close"));
                    grandChildElement.setAttribute("Action", "EXIT");
                    childElement.appendChild(grandChildElement);
                    grandChildElement = this.frame_.getDomDocument().createElement("Button");
                    grandChildElement.setAttribute("Position", "2");
                    grandChildElement.setAttribute("Number", "6");
                    grandChildElement.setAttribute("Caption", res.getString("Add"));
                    grandChildElement.setAttribute("Action", "ADD");
                    childElement.appendChild(grandChildElement);
                    grandChildElement = this.frame_.getDomDocument().createElement("Button");
                    grandChildElement.setAttribute("Position", "4");
                    grandChildElement.setAttribute("Number", "8");
                    grandChildElement.setAttribute("Caption", res.getString("HDRData"));
                    grandChildElement.setAttribute("Action", "HEADER");
                    childElement.appendChild(grandChildElement);
                    grandChildElement = this.frame_.getDomDocument().createElement("Button");
                    grandChildElement.setAttribute("Position", "6");
                    grandChildElement.setAttribute("Number", "12");
                    grandChildElement.setAttribute("Caption", res.getString("Output"));
                    grandChildElement.setAttribute("Action", "OUTPUT");
                    childElement.appendChild(grandChildElement);
                }
                ++p;
            }
        }
    }

    private Element getCurrentTableElementWithID(String externalTableID) {
        Element element = null;
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("Table");
        int i = 0;
        while (i < nodeList.getLength()) {
            element = (Element)nodeList.item(i);
            if (element.getAttribute("ID").equals(externalTableID)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public void jButtonCloseDialog_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private boolean isExistingTable(String tableID) {
        boolean isExisting = false;
        int i = 0;
        while (i < this.currentTableList.getLength()) {
            Element tableElement = (Element)this.currentTableList.item(i);
            if (tableElement.getAttribute("ID").equals(tableID)) {
                isExisting = true;
                break;
            }
            ++i;
        }
        if (this.newlyAddedTableIDList.contains(tableID)) {
            isExisting = true;
        }
        return isExisting;
    }

    private boolean isExistingFunction(String functionID) {
        boolean isExisting = false;
        int i = 0;
        while (i < this.currentFunctionList.getLength()) {
            Element functionElement = (Element)this.currentFunctionList.item(i);
            if (functionElement.getAttribute("ID").equals(functionID)) {
                isExisting = true;
                break;
            }
            ++i;
        }
        if (this.newlyAddedFunctionIDList.contains(functionID)) {
            isExisting = true;
        }
        return isExisting;
    }

    class TableModelReadOnlyList
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelReadOnlyList() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class TableRowNumber {
        private Element element_;
        private int number_;
        private String type_;
        private String message_;
        private DialogImportModel dialog_;

        public TableRowNumber(int num, Element elm, String type, DialogImportModel dialog) {
            this.number_ = num;
            this.element_ = elm;
            this.type_ = type;
            this.dialog_ = dialog;
            this.message_ = "";
        }

        public String toString() {
            String value = Integer.toString(this.number_);
            if (this.isTable() && !this.dialog_.isExistingTable(this.element_.getAttribute("SortKey"))) {
                return "<html><b>" + value;
            }
            if (this.isFunction() && !this.dialog_.isExistingFunction(this.element_.getAttribute("SortKey"))) {
                return "<html><b>" + value;
            }
            return value;
        }

        public Element getElement() {
            return this.element_;
        }

        public boolean isTable() {
            return this.type_.equals("Table");
        }

        public boolean isFunction() {
            return this.type_.equals("Function");
        }

        public void setMessage(String message) {
            this.message_ = message;
        }

        public String getMessage() {
            return this.message_;
        }
    }
}

