/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogListLog_jButtonCloseDialog_actionAdapter;
import xeadEditor.DialogListLog_jButtonGenerateListData_actionAdapter;
import xeadEditor.DialogListLog_jButtonStartScan_actionAdapter;
import xeadEditor.DialogListLog_jTableScanResult_listSelectionAdapter;
import xeadEditor.Editor;
import xeadEditor.Editor_EditableTableField;

public class DialogListLog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private Editor frame_;
    private BorderLayout borderLayoutMain = new BorderLayout();
    private JPanel panelMain = new JPanel();
    private JPanel jPanelNorth = new JPanel();
    private JPanel jPanelSouth = new JPanel();
    private JPanel jPanelNorth1 = new JPanel();
    private JScrollPane jScrollPaneNorth2 = new JScrollPane();
    private JPanel jPanelKeyFields = new JPanel();
    private JPanel jPanelNorth3 = new JPanel();
    private JSplitPane jSplitPane = new JSplitPane();
    private JScrollPane jScrollPaneScanResult = new JScrollPane();
    private JScrollPane jScrollPaneScanDetail = new JScrollPane();
    private JLabel jLabelTableID = new JLabel();
    private JTextField jTextFieldTableID = new JTextField();
    private String tableModuleID = "";
    private JTextField jTextFieldTableName = new JTextField();
    private JLabel jLabelListingOperation = new JLabel();
    private JCheckBox jCheckBoxSelect = new JCheckBox();
    private JCheckBox jCheckBoxInsert = new JCheckBox();
    private JCheckBox jCheckBoxUpdate = new JCheckBox();
    private JCheckBox jCheckBoxDelete = new JCheckBox();
    private TableModelReadOnlyList tableModelScanResult = new TableModelReadOnlyList();
    private JTable jTableScanResult = new JTable(this.tableModelScanResult);
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private TableColumn column4;
    private TableColumn column5;
    private TableColumn column6;
    private DefaultTableCellRenderer rendererTableHeader = null;
    private DefaultTableCellRenderer rendererAlignmentCenter = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentRight = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentLeft = new DefaultTableCellRenderer();
    private JTextArea jTextAreaScanDetail = new JTextArea();
    private JButton jButtonStartScan = new JButton();
    private JProgressBar jProgressBar = new JProgressBar();
    private JButton jButtonCloseDialog = new JButton();
    private JButton jButtonGenerateListData = new JButton();
    private ArrayList<Editor_EditableTableField> keyFieldList = new ArrayList();

    public DialogListLog(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogListLog(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(this.borderLayoutMain);
        this.panelMain.setPreferredSize(new Dimension(1100, 700));
        this.panelMain.setBorder(null);
        this.panelMain.add((Component)this.jPanelNorth, "North");
        this.panelMain.add((Component)this.jPanelSouth, "South");
        this.panelMain.add((Component)this.jSplitPane, "Center");
        this.jPanelNorth.setBorder(null);
        this.jPanelNorth.setPreferredSize(new Dimension(800, 153));
        this.jPanelNorth.setLayout(new BorderLayout());
        this.jPanelNorth1.setPreferredSize(new Dimension(800, 43));
        this.jPanelNorth1.setLayout(null);
        this.jLabelTableID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelTableID.setHorizontalAlignment(4);
        this.jLabelTableID.setHorizontalTextPosition(10);
        this.jLabelTableID.setText(res.getString("IDAndName"));
        this.jLabelTableID.setBounds(new Rectangle(5, 12, 130, 20));
        this.jTextFieldTableID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldTableID.setBounds(new Rectangle(140, 9, 120, 25));
        this.jTextFieldTableID.setEditable(false);
        this.jTextFieldTableName.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldTableName.setBounds(new Rectangle(265, 9, 350, 25));
        this.jTextFieldTableName.setEditable(false);
        this.jButtonStartScan.setBounds(new Rectangle(750, 8, 200, 27));
        this.jButtonStartScan.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonStartScan.setText(res.getString("RetrieveLog"));
        this.jButtonStartScan.addActionListener(new DialogListLog_jButtonStartScan_actionAdapter(this));
        this.jButtonStartScan.setFocusCycleRoot(true);
        this.jProgressBar.setBounds(new Rectangle(750, 8, 200, 27));
        this.jProgressBar.setVisible(false);
        this.jScrollPaneNorth2.setHorizontalScrollBarPolicy(32);
        this.jScrollPaneNorth2.getViewport().add((Component)this.jPanelKeyFields, null);
        this.jPanelNorth3.setPreferredSize(new Dimension(800, 43));
        this.jPanelNorth3.setLayout(null);
        this.jPanelKeyFields.setLayout(null);
        this.jLabelListingOperation.setHorizontalAlignment(4);
        this.jLabelListingOperation.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelListingOperation.setText(res.getString("ListingOperations"));
        this.jLabelListingOperation.setBounds(new Rectangle(5, 12, 130, 20));
        this.jCheckBoxSelect.setBounds(new Rectangle(140, 9, 130, 25));
        this.jCheckBoxSelect.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxSelect.setText("SELECT");
        this.jCheckBoxSelect.setSelected(true);
        this.jCheckBoxInsert.setBounds(new Rectangle(270, 9, 130, 25));
        this.jCheckBoxInsert.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxInsert.setText("INSERT");
        this.jCheckBoxInsert.setSelected(true);
        this.jCheckBoxUpdate.setBounds(new Rectangle(400, 9, 130, 25));
        this.jCheckBoxUpdate.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxUpdate.setText("UPDATE");
        this.jCheckBoxUpdate.setSelected(true);
        this.jCheckBoxDelete.setBounds(new Rectangle(530, 9, 130, 25));
        this.jCheckBoxDelete.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxDelete.setText("DELETE");
        this.jCheckBoxDelete.setSelected(true);
        this.jPanelNorth.add((Component)this.jPanelNorth1, "North");
        this.jPanelNorth.add((Component)this.jScrollPaneNorth2, "Center");
        this.jPanelNorth.add((Component)this.jPanelNorth3, "South");
        this.jPanelNorth1.add(this.jLabelTableID);
        this.jPanelNorth1.add(this.jTextFieldTableID);
        this.jPanelNorth1.add(this.jTextFieldTableName);
        this.jPanelNorth1.add(this.jButtonStartScan);
        this.jPanelNorth1.add(this.jProgressBar);
        this.jPanelNorth3.add(this.jLabelListingOperation);
        this.jPanelNorth3.add(this.jCheckBoxSelect);
        this.jPanelNorth3.add(this.jCheckBoxInsert);
        this.jPanelNorth3.add(this.jCheckBoxUpdate);
        this.jPanelNorth3.add(this.jCheckBoxDelete);
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setDividerLocation(400);
        this.jSplitPane.setPreferredSize(new Dimension(750, 300));
        this.jScrollPaneScanDetail.setBounds(new Rectangle(132, 144, 282, 51));
        this.jSplitPane.add((Component)this.jScrollPaneScanResult, "top");
        this.jSplitPane.add((Component)this.jScrollPaneScanDetail, "bottom");
        this.jTableScanResult.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableScanResult.setBackground(SystemColor.control);
        this.jTableScanResult.setAutoResizeMode(0);
        this.jTableScanResult.setSelectionMode(0);
        this.jTableScanResult.setRowSelectionAllowed(true);
        this.jTableScanResult.getSelectionModel().addListSelectionListener(new DialogListLog_jTableScanResult_listSelectionAdapter(this));
        this.jTableScanResult.setRowHeight(24);
        this.tableModelScanResult.addColumn("No.");
        this.tableModelScanResult.addColumn(res.getString("SessionNo"));
        this.tableModelScanResult.addColumn(res.getString("UserID"));
        this.tableModelScanResult.addColumn(res.getString("LoginTime"));
        this.tableModelScanResult.addColumn(res.getString("FunctionID"));
        this.tableModelScanResult.addColumn(res.getString("Result"));
        this.tableModelScanResult.addColumn(res.getString("TableOperation"));
        this.column0 = this.jTableScanResult.getColumnModel().getColumn(0);
        this.column1 = this.jTableScanResult.getColumnModel().getColumn(1);
        this.column2 = this.jTableScanResult.getColumnModel().getColumn(2);
        this.column3 = this.jTableScanResult.getColumnModel().getColumn(3);
        this.column4 = this.jTableScanResult.getColumnModel().getColumn(4);
        this.column5 = this.jTableScanResult.getColumnModel().getColumn(5);
        this.column6 = this.jTableScanResult.getColumnModel().getColumn(6);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(100);
        this.column2.setPreferredWidth(80);
        this.column3.setPreferredWidth(210);
        this.column4.setPreferredWidth(100);
        this.column5.setPreferredWidth(60);
        this.column6.setPreferredWidth(470);
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentRight.setHorizontalAlignment(4);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentLeft);
        this.column4.setCellRenderer(this.rendererAlignmentLeft);
        this.column5.setCellRenderer(this.rendererAlignmentLeft);
        this.column6.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableScanResult.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableScanResult.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jScrollPaneScanResult.getViewport().add((Component)this.jTableScanResult, null);
        this.jTextAreaScanDetail.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaScanDetail.setLineWrap(true);
        this.jTextAreaScanDetail.setEditable(false);
        this.jTextAreaScanDetail.setEditable(false);
        this.jTextAreaScanDetail.setBackground(SystemColor.control);
        this.jScrollPaneScanDetail.getViewport().add((Component)this.jTextAreaScanDetail, null);
        this.jPanelSouth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSouth.setPreferredSize(new Dimension(100, 43));
        this.jButtonCloseDialog.setBounds(new Rectangle(20, 8, 100, 27));
        this.jButtonCloseDialog.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCloseDialog.setText(res.getString("Close"));
        this.jButtonCloseDialog.addActionListener(new DialogListLog_jButtonCloseDialog_actionAdapter(this));
        this.jButtonGenerateListData.setBounds(new Rectangle(800, 8, 120, 27));
        this.jButtonGenerateListData.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonGenerateListData.setText(res.getString("GenerateList"));
        this.jButtonGenerateListData.setEnabled(false);
        this.jButtonGenerateListData.addActionListener(new DialogListLog_jButtonGenerateListData_actionAdapter(this));
        this.jPanelSouth.setLayout(null);
        this.jPanelSouth.add(this.jButtonGenerateListData);
        this.jPanelSouth.add(this.jButtonCloseDialog);
        this.setResizable(false);
        this.setTitle(res.getString("ListLogTitle"));
        this.getContentPane().add(this.panelMain);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public void request(Element tableElement, HashMap<String, Object> columnMap, boolean isCaptionWithName) {
        JLabel label = new JLabel();
        FontMetrics metrics = label.getFontMetrics(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldTableID.setText(tableElement.getAttribute("ID"));
        this.tableModuleID = tableElement.getAttribute("ModuleID").equals("") ? tableElement.getAttribute("ID") : tableElement.getAttribute("ModuleID");
        this.jTextFieldTableName.setText(tableElement.getAttribute("Name"));
        int posX = 8;
        this.jPanelKeyFields.removeAll();
        this.keyFieldList.clear();
        NodeList nodeList1 = tableElement.getElementsByTagName("Key");
        NodeList nodeList2 = tableElement.getElementsByTagName("Field");
        Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodeList1, "Type");
        int i = 0;
        while (i < sortingList.getSize()) {
            Element element1 = (Element)sortingList.getElementAt(i);
            if (element1.getAttribute("Type").equals("PK") || element1.getAttribute("Type").equals("SK")) {
                StringTokenizer workTokenizer = new StringTokenizer(element1.getAttribute("Fields"), ";");
                while (workTokenizer.hasMoreTokens()) {
                    String fieldID = workTokenizer.nextToken();
                    int j = 0;
                    while (j < nodeList2.getLength()) {
                        Element element2 = (Element)nodeList2.item(j);
                        if (element2.getAttribute("ID").equals(fieldID)) {
                            int digits = element2.getAttribute("Size").equals("") ? 5 : Integer.parseInt(element2.getAttribute("Size"));
                            int columnWidth = this.frame_.getOptionList(element2.getAttribute("TypeOptions")).contains("KANJI") ? digits * 12 + 10 : digits * 6 + 10;
                            if (columnWidth > 200) {
                                columnWidth = 200;
                            }
                            if (columnWidth < metrics.stringWidth(element2.getAttribute("Name")) + 15) {
                                columnWidth = metrics.stringWidth(element2.getAttribute("Name")) + 15;
                            }
                            if (columnWidth < metrics.stringWidth(element2.getAttribute("ID")) + 15) {
                                columnWidth = metrics.stringWidth(element2.getAttribute("ID")) + 15;
                            }
                            Editor_EditableTableField editableField = new Editor_EditableTableField(element2, this.frame_);
                            this.keyFieldList.add(editableField);
                            Dimension dim = editableField.getPreferredSize();
                            editableField.setBounds(posX, 8, dim.width, dim.height);
                            editableField.setEnabled(true);
                            editableField.setEditable(true);
                            if (columnMap != null) {
                                editableField.setValue(columnMap.get(editableField.getFieldID()));
                            }
                            if (!isCaptionWithName) {
                                editableField.setCaption(fieldID);
                            }
                            if (element1.getAttribute("Type").equals("PK")) {
                                editableField.setKey(true);
                            }
                            posX = posX + dim.width + 3;
                            this.jPanelKeyFields.add((Component)editableField, null);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.jButtonGenerateListData.setEnabled(false);
        if (this.tableModelScanResult.getRowCount() > 0) {
            int rowCount = this.tableModelScanResult.getRowCount();
            int i2 = 0;
            while (i2 < rowCount) {
                this.tableModelScanResult.removeRow(0);
                ++i2;
            }
        }
        this.jTextAreaScanDetail.setText(res.getString("ListLogComment"));
        this.jButtonGenerateListData.setEnabled(false);
        this.jButtonStartScan.requestFocusInWindow();
        super.setVisible(true);
    }

    void jButtonStartScan_actionPerformed(ActionEvent e) {
        block11: {
            try {
                try {
                    this.setCursor(new Cursor(3));
                    this.jButtonGenerateListData.setEnabled(false);
                    if (this.tableModelScanResult.getRowCount() > 0) {
                        int rowCount = this.tableModelScanResult.getRowCount();
                        int i = 0;
                        while (i < rowCount) {
                            this.tableModelScanResult.removeRow(0);
                            ++i;
                        }
                    }
                    int count = 0;
                    String tableID = this.frame_.getSystemNode().getElement().getAttribute("SessionTable");
                    Editor.MainTreeNode tableNode = this.frame_.getSpecificXETreeNode("Table", tableID);
                    Connection connection = this.frame_.getDatabaseConnList().get(this.frame_.getDatabaseIDList().indexOf(tableNode.getElement().getAttribute("DB")));
                    Statement statementHeader = connection.createStatement();
                    tableID = this.frame_.getSystemNode().getElement().getAttribute("SessionDetailTable");
                    tableNode = this.frame_.getSpecificXETreeNode("Table", tableID);
                    connection = this.frame_.getDatabaseConnList().get(this.frame_.getDatabaseIDList().indexOf(tableNode.getElement().getAttribute("DB")));
                    Statement statementDetail = connection.createStatement();
                    StringBuffer buf = new StringBuffer();
                    buf.append("select * from ");
                    buf.append(this.frame_.getSystemNode().getElement().getAttribute("SessionTable"));
                    buf.append(" order by NRSESSION ");
                    ResultSet resultHeader = statementHeader.executeQuery(buf.toString());
                    this.jProgressBar.setValue(0);
                    this.jProgressBar.setMaximum(resultHeader.getRow());
                    this.jProgressBar.setVisible(true);
                    this.jButtonStartScan.setVisible(false);
                    while (resultHeader.next()) {
                        this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
                        this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
                        buf = new StringBuffer();
                        buf.append("select * from ");
                        buf.append(this.frame_.getSystemNode().getElement().getAttribute("SessionDetailTable"));
                        buf.append(" where NRSESSION = '");
                        buf.append(resultHeader.getString("NRSESSION"));
                        buf.append("'");
                        ResultSet resultDetail = statementDetail.executeQuery(buf.toString());
                        while (resultDetail.next()) {
                            if (resultDetail.getString("TXERRORLOG") == null) continue;
                            StringTokenizer workTokenizer = new StringTokenizer(resultDetail.getString("TXERRORLOG"), "\n");
                            while (workTokenizer.hasMoreTokens()) {
                                String logString = workTokenizer.nextToken();
                                if (!this.isTargetLog(logString)) continue;
                                Object[] Cell = new Object[]{++count, resultHeader.getString("NRSESSION"), resultHeader.getString("IDUSER"), resultHeader.getString("DTLOGIN"), resultDetail.getString("IDPROGRAM"), resultDetail.getString("KBPROGRAMSTATUS"), logString.substring(2)};
                                this.tableModelScanResult.addRow(Cell);
                            }
                        }
                        resultDetail.close();
                    }
                    resultHeader.close();
                    if (count > 0) {
                        this.jTextAreaScanDetail.setText(String.valueOf(count) + res.getString("ListLogMessage1"));
                        this.jButtonGenerateListData.setEnabled(true);
                        break block11;
                    }
                    this.jTextAreaScanDetail.setText(res.getString("ListLogMessage2"));
                }
                catch (SQLException ex) {
                    this.jTextAreaScanDetail.setText("SQLException :" + ex.getMessage());
                    this.jProgressBar.setVisible(false);
                    this.jButtonStartScan.setVisible(true);
                    this.jButtonStartScan.requestFocusInWindow();
                    this.setCursor(new Cursor(0));
                }
            }
            finally {
                this.jProgressBar.setVisible(false);
                this.jButtonStartScan.setVisible(true);
                this.jButtonStartScan.requestFocusInWindow();
                this.setCursor(new Cursor(0));
            }
        }
    }

    boolean isTargetLog(String logString) {
        boolean isTargetLog = false;
        if (this.jCheckBoxSelect.isSelected() && logString.contains("> select ") && logString.contains(" from " + this.tableModuleID + " ")) {
            isTargetLog = this.isValidatedWithKey(this.getKeyValueMapInLog(logString, "select"));
        }
        if (this.jCheckBoxInsert.isSelected() && logString.contains("> insert into " + this.tableModuleID + " ")) {
            isTargetLog = this.isValidatedWithKey(this.getKeyValueMapInLog(logString, "insert"));
        }
        if (this.jCheckBoxUpdate.isSelected() && logString.contains("> update " + this.tableModuleID + " ")) {
            isTargetLog = this.isValidatedWithKey(this.getKeyValueMapInLog(logString, "update"));
        }
        if (this.jCheckBoxDelete.isSelected() && logString.contains("> delete from " + this.tableModuleID + " ")) {
            isTargetLog = this.isValidatedWithKey(this.getKeyValueMapInLog(logString, "delete"));
        }
        return isTargetLog;
    }

    HashMap<String, Object> getKeyValueMapInLog(String logString, String operation) {
        int pos3;
        String text1;
        int pos2;
        int pos1;
        HashMap<String, Object> keyValueMap = new HashMap<String, Object>();
        if ((operation.equals("select") || operation.equals("update") || operation.equals("delete")) && (pos1 = logString.indexOf(" where ")) > -1) {
            pos2 = logString.indexOf(" order by ");
            text1 = pos2 > pos1 ? logString.substring(pos1 + 7, pos2) : ((pos2 = logString.indexOf("(", pos1)) > -1 ? logString.substring(pos1 + 7, pos2) : logString.substring(pos1 + 7));
            String[] keyAry = text1.split(" and ");
            int i = 0;
            while (i < keyAry.length) {
                String[] valueAry = keyAry[i].split("=");
                if (valueAry.length == 2) {
                    keyValueMap.put(valueAry[0].trim(), valueAry[1].replace("\"", "").trim());
                }
                ++i;
            }
        }
        if (operation.equals("insert") && (pos1 = logString.indexOf("(")) > -1 && (pos2 = logString.indexOf(") values(", pos1 + 1)) > -1 && (pos3 = logString.indexOf(")", pos2 + 9)) > -1) {
            text1 = logString.substring(pos1 + 1, pos2);
            String text2 = logString.substring(pos2 + 9, pos3);
            StringTokenizer workTokenizer1 = new StringTokenizer(text1, ",");
            StringTokenizer workTokenizer2 = new StringTokenizer(text2, ",");
            if (workTokenizer1.countTokens() == workTokenizer2.countTokens()) {
                while (workTokenizer1.hasMoreTokens()) {
                    String wrkStr1 = workTokenizer1.nextToken().trim();
                    String wrkStr2 = workTokenizer2.nextToken().trim().replace("\"", "");
                    keyValueMap.put(wrkStr1, wrkStr2);
                }
            }
        }
        return keyValueMap;
    }

    boolean isValidatedWithKey(HashMap<String, Object> keyValueMapInLog) {
        int countOfFieldIDContained = 0;
        int countOfFieldValueMatched = 0;
        int i = 0;
        while (i < this.keyFieldList.size()) {
            Object keyValueInLog = keyValueMapInLog.get(this.keyFieldList.get(i).getFieldID());
            if (keyValueInLog != null) {
                ++countOfFieldIDContained;
                if (this.keyFieldList.get(i).isNull()) {
                    ++countOfFieldValueMatched;
                } else if (keyValueInLog.equals(this.keyFieldList.get(i).getInternalValue())) {
                    ++countOfFieldValueMatched;
                }
            }
            ++i;
        }
        return countOfFieldIDContained > 0 && countOfFieldIDContained == countOfFieldValueMatched;
    }

    void jTableScanResult_valueChanged(ListSelectionEvent e) {
        if (this.jTableScanResult.getRowCount() > 0) {
            if (this.jTableScanResult.getSelectedRow() > -1) {
                this.setSelectedRowValueToTextPane();
            } else {
                this.jTextAreaScanDetail.setText("");
            }
        }
    }

    void setSelectedRowValueToTextPane() {
        if (this.jTableScanResult.getSelectedRow() > -1) {
            this.jTextAreaScanDetail.setText((String)this.tableModelScanResult.getValueAt(this.jTableScanResult.getSelectedRow(), 6));
            this.jTextAreaScanDetail.setCaretPosition(0);
        }
    }

    void jButtonGenerateListData_actionPerformed(ActionEvent e) {
        try {
            this.frame_.getDesktop().browse(this.getExcellBookURI());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, "IOException :");
            e1.printStackTrace(this.frame_.getExceptionStream());
        }
    }

    URI getExcellBookURI() {
        File xlsFile = null;
        String xlsFileName = "";
        FileOutputStream fileOutputStream = null;
        HSSFWorkbook workBook = new HSSFWorkbook();
        HSSFSheet workSheet = workBook.createSheet(this.jTextFieldTableID.getText());
        workSheet.setDefaultRowHeight((short)300);
        HSSFFooter workSheetFooter = workSheet.getFooter();
        workSheetFooter.setRight(String.valueOf(this.jTextFieldTableID.getText()) + "  Page " + HSSFFooter.page() + " / " + HSSFFooter.numPages());
        HSSFFont fontHeader = workBook.createFont();
        fontHeader = workBook.createFont();
        fontHeader.setFontName(res.getString("XLSFontHDR"));
        fontHeader.setFontHeightInPoints((short)11);
        HSSFFont fontDetail = workBook.createFont();
        fontDetail.setFontName(res.getString("XLSFontDTL"));
        fontDetail.setFontHeightInPoints((short)11);
        HSSFCellStyle styleHeader = workBook.createCellStyle();
        styleHeader.setBorderBottom((short)1);
        styleHeader.setBorderLeft((short)1);
        styleHeader.setBorderRight((short)1);
        styleHeader.setBorderTop((short)1);
        styleHeader.setFillForegroundColor((short)22);
        styleHeader.setFillPattern((short)1);
        styleHeader.setAlignment((short)1);
        styleHeader.setFont(fontHeader);
        HSSFCellStyle styleHeaderNumber = workBook.createCellStyle();
        styleHeaderNumber.setBorderBottom((short)1);
        styleHeaderNumber.setBorderLeft((short)1);
        styleHeaderNumber.setBorderRight((short)1);
        styleHeaderNumber.setBorderTop((short)1);
        styleHeaderNumber.setFillForegroundColor((short)22);
        styleHeaderNumber.setFillPattern((short)1);
        styleHeaderNumber.setAlignment((short)1);
        styleHeaderNumber.setFont(fontHeader);
        HSSFCellStyle styleDataInteger = workBook.createCellStyle();
        styleDataInteger.setBorderBottom((short)1);
        styleDataInteger.setBorderLeft((short)1);
        styleDataInteger.setBorderRight((short)1);
        styleDataInteger.setBorderTop((short)1);
        styleDataInteger.setAlignment((short)3);
        styleDataInteger.setVerticalAlignment((short)0);
        styleDataInteger.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0"));
        HSSFCellStyle styleDataString = workBook.createCellStyle();
        styleDataString.setBorderBottom((short)1);
        styleDataString.setBorderLeft((short)1);
        styleDataString.setBorderRight((short)1);
        styleDataString.setBorderTop((short)1);
        styleDataString.setAlignment((short)1);
        styleDataString.setVerticalAlignment((short)0);
        styleDataString.setWrapText(true);
        styleDataString.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        int currentRowNumber = -1;
        try {
            File outputFolder = null;
            String wrkStr = this.frame_.getSystemNode().getElement().getAttribute("OutputFolder");
            if (wrkStr.equals("")) {
                outputFolder = null;
            } else {
                if (wrkStr.contains("<CURRENT>")) {
                    wrkStr = wrkStr.replace("<CURRENT>", this.frame_.getCurrentFileFolder());
                }
                if (!(outputFolder = new File(wrkStr)).exists()) {
                    outputFolder = null;
                }
            }
            xlsFile = File.createTempFile("XeadEditor_" + this.jTextFieldTableID.getText() + "_AuditLog_", ".xls", outputFolder);
            if (outputFolder == null) {
                xlsFile.deleteOnExit();
            }
            xlsFileName = xlsFile.getPath();
            fileOutputStream = new FileOutputStream(xlsFileName);
            HSSFRow rowCaption = workSheet.createRow(++currentRowNumber);
            int i = 0;
            while (i < this.tableModelScanResult.getColumnCount()) {
                HSSFCell cell = rowCaption.createCell(i);
                cell.setCellStyle(styleHeaderNumber);
                cell.setCellValue((RichTextString)new HSSFRichTextString(this.tableModelScanResult.getColumnName(i)));
                Rectangle rect = this.jTableScanResult.getCellRect(0, i, true);
                if (i == 6) {
                    workSheet.setColumnWidth(i, rect.width * 80);
                } else {
                    workSheet.setColumnWidth(i, rect.width * 40);
                }
                ++i;
            }
            i = 0;
            while (i < this.tableModelScanResult.getRowCount()) {
                HSSFRow rowData = workSheet.createRow(++currentRowNumber);
                HSSFCell cell0 = rowData.createCell(0);
                cell0.setCellType(0);
                cell0.setCellStyle(styleDataInteger);
                cell0.setCellValue((double)(i + 1));
                int j = 1;
                while (j < 7) {
                    HSSFCell cell = rowData.createCell(j);
                    cell.setCellType(1);
                    cell.setCellStyle(styleDataString);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(this.tableModelScanResult.getValueAt(i, j).toString()));
                    ++j;
                }
                ++i;
            }
            workBook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception ex1) {
            JOptionPane.showMessageDialog(null, "Exception :");
            ex1.printStackTrace(this.frame_.getExceptionStream());
            try {
                fileOutputStream.close();
            }
            catch (Exception ex2) {
                ex2.printStackTrace(this.frame_.getExceptionStream());
            }
        }
        return xlsFile.toURI();
    }

    void jButtonCloseDialog_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class TableModelReadOnlyList
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelReadOnlyList() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

