/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogSQL_jButtonClose_actionAdapter;
import xeadEditor.DialogSQL_jButtonCommit_actionAdapter;
import xeadEditor.DialogSQL_jButtonListTables_actionAdapter;
import xeadEditor.Editor;

public class DialogSQL
extends JDialog {
    private static final long serialVersionUID = 1L;
    static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JButton jButtonCommit = new JButton();
    private JButton jButtonListTables = new JButton();
    private JButton jButtonClose = new JButton();
    private JPanel jPanelStatement = new JPanel();
    private JPanel jPanelStatementTop = new JPanel();
    private JPanel jPanelMessage = new JPanel();
    private JLabel jLabelConnection = new JLabel();
    private JComboBox<String> jComboBoxConnection = new JComboBox();
    private ArrayList<String> dbIDList = new ArrayList();
    private JScrollPane jScrollPaneStatement = new JScrollPane();
    private JTextArea jTextAreaStatement = new JTextArea();
    private JLabel jLabelMessage = new JLabel();
    private JScrollPane jScrollPaneMessage = new JScrollPane();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JSplitPane jSplitPane = new JSplitPane();
    private Editor frame_;
    private JPanel jPanelButtons = new JPanel();
    private boolean sqlExecuted;
    private Calendar calendar;
    private SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private Action commitAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogSQL.this.jButtonCommit_actionPerformed(null);
        }
    };

    public DialogSQL(Editor frame) {
        super(frame, "", true);
        this.frame_ = frame;
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.jScrollPaneMessage.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().setLayout(new BorderLayout());
        InputMap inputMap = this.jScrollPaneStatement.getInputMap(1);
        inputMap.clear();
        ActionMap actionMap = this.jScrollPaneStatement.getActionMap();
        actionMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(116, 0), "RUN");
        actionMap.put("RUN", this.commitAction);
        this.jLabelConnection.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelConnection.setHorizontalAlignment(4);
        this.jLabelConnection.setHorizontalTextPosition(10);
        this.jLabelConnection.setText(res.getString("AvailableConnection"));
        this.jLabelConnection.setBounds(new Rectangle(5, 9, 190, 28));
        this.jComboBoxConnection.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jComboBoxConnection.setBounds(new Rectangle(200, 9, 790, 28));
        this.jPanelStatementTop.setLayout(null);
        this.jPanelStatementTop.setPreferredSize(new Dimension(10, 45));
        this.jPanelStatementTop.add(this.jLabelConnection);
        this.jPanelStatementTop.add(this.jComboBoxConnection);
        this.jPanelStatement.setLayout(new BorderLayout());
        this.jPanelStatement.add((Component)this.jPanelStatementTop, "North");
        this.jPanelStatement.add((Component)this.jScrollPaneStatement, "Center");
        this.jTextAreaStatement.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaStatement.setEditable(true);
        this.jTextAreaStatement.setOpaque(true);
        this.jTextAreaStatement.setLineWrap(true);
        this.jTextAreaStatement.setWrapStyleWord(true);
        this.jScrollPaneStatement.getViewport().add(this.jTextAreaStatement);
        this.jLabelMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelMessage.setText(" " + res.getString("Message"));
        this.jLabelMessage.setPreferredSize(new Dimension(100, 28));
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setOpaque(false);
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setTabSize(16);
        this.jTextAreaMessage.setText(res.getString("SqlConsoleComment"));
        this.jScrollPaneMessage.getViewport().add(this.jTextAreaMessage);
        this.jPanelMessage.setLayout(new BorderLayout());
        this.jPanelMessage.add((Component)this.jLabelMessage, "North");
        this.jPanelMessage.add((Component)this.jScrollPaneMessage, "Center");
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setDividerLocation(200);
        this.jSplitPane.add((Component)this.jPanelStatement, "top");
        this.jSplitPane.add((Component)this.jPanelMessage, "bottom");
        this.jButtonClose.setText(res.getString("Close"));
        this.jButtonClose.setBounds(new Rectangle(30, 8, 100, 27));
        this.jButtonClose.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonClose.addActionListener(new DialogSQL_jButtonClose_actionAdapter(this));
        this.jButtonCommit.setText(res.getString("SqlCommitF5"));
        this.jButtonCommit.setBounds(new Rectangle(400, 8, 150, 27));
        this.jButtonCommit.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCommit.addActionListener(new DialogSQL_jButtonCommit_actionAdapter(this));
        this.jButtonListTables.setText(res.getString("SqlListModules"));
        this.jButtonListTables.setBounds(new Rectangle(820, 8, 150, 27));
        this.jButtonListTables.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonListTables.addActionListener(new DialogSQL_jButtonListTables_actionAdapter(this));
        this.jPanelButtons.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 43));
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.add((Component)this.jButtonClose, null);
        this.jPanelButtons.add((Component)this.jButtonCommit, null);
        this.jPanelButtons.add((Component)this.jButtonListTables, null);
        this.setTitle(res.getString("SqlConsole"));
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.setResizable(false);
        this.setPreferredSize(new Dimension(1010, 700));
        this.getContentPane().add((Component)this.jSplitPane, "Center");
    }

    public boolean request(Connection connection) {
        this.sqlExecuted = false;
        int selectedIndex = this.jComboBoxConnection.getSelectedIndex();
        this.jComboBoxConnection.removeAllItems();
        int i = 0;
        while (i < this.frame_.getDatabaseNameList().size()) {
            try {
                if (this.frame_.getDatabaseConnList().get(i) != null && !this.frame_.getDatabaseConnList().get(i).isClosed()) {
                    this.jComboBoxConnection.addItem(this.frame_.getDatabaseNameList().get(i));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++i;
        }
        if (selectedIndex > -1 && selectedIndex < this.jComboBoxConnection.getItemCount()) {
            this.jComboBoxConnection.setSelectedIndex(selectedIndex);
        }
        this.dbIDList = this.frame_.getDatabaseIDList();
        this.jTextAreaStatement.requestFocus();
        this.jPanelButtons.getRootPane().setDefaultButton(this.jButtonClose);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.frame_.getSize();
        Point loc = this.frame_.getLocation();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        super.setVisible(true);
        return this.sqlExecuted;
    }

    void jButtonCommit_actionPerformed(ActionEvent e) {
        StringBuffer bf = new StringBuffer();
        String sql = "";
        try {
            try {
                this.setCursor(new Cursor(3));
                Connection connection = this.frame_.getDatabaseConnList().get(this.jComboBoxConnection.getSelectedIndex());
                Statement statement = connection.createStatement();
                sql = this.jTextAreaStatement.getText().trim().replace("\n", " ");
                if (sql.length() > 1) {
                    if (sql.toUpperCase().startsWith("SELECT ")) {
                        int i;
                        int seq = 0;
                        ResultSet resultSet = statement.executeQuery(sql);
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        bf.append(this.jTextAreaMessage.getText());
                        bf.append("\n> ");
                        bf.append(sql);
                        bf.append("\n");
                        if (seq == 0) {
                            bf.append("No.");
                            i = 1;
                            while (i <= resultSetMetaData.getColumnCount()) {
                                bf.append(",");
                                bf.append(resultSetMetaData.getColumnName(i));
                                ++i;
                            }
                            bf.append("\n");
                        }
                        while (resultSet.next()) {
                            bf.append(++seq);
                            i = 1;
                            while (i <= resultSetMetaData.getColumnCount()) {
                                bf.append(",");
                                if (resultSet.getObject(resultSetMetaData.getColumnName(i)) == null) {
                                    bf.append("<null>");
                                } else {
                                    bf.append(resultSet.getObject(resultSetMetaData.getColumnName(i)).toString().trim());
                                }
                                ++i;
                            }
                            bf.append("\n");
                        }
                        bf.append("(");
                        this.calendar = Calendar.getInstance();
                        bf.append(this.formatter.format(this.calendar.getTime()));
                        bf.append(")\n");
                        resultSet.close();
                        this.jTextAreaMessage.setText(bf.toString());
                    } else {
                        statement.executeUpdate(sql);
                        bf.append(this.jTextAreaMessage.getText());
                        bf.append("\n> ");
                        bf.append(sql);
                        bf.append("\n");
                        bf.append(res.getString("SqlConsoleMessage1"));
                        this.calendar = Calendar.getInstance();
                        bf.append(this.formatter.format(this.calendar.getTime()));
                        bf.append(")\n");
                        this.jTextAreaMessage.setText(bf.toString());
                    }
                    this.sqlExecuted = true;
                }
            }
            catch (SQLException ex1) {
                bf.append(this.jTextAreaMessage.getText());
                bf.append("\n> ");
                bf.append(sql);
                bf.append("\n");
                bf.append(res.getString("SqlConsoleMessage2"));
                bf.append(ex1.getMessage());
                bf.append("\n(");
                this.calendar = Calendar.getInstance();
                bf.append(this.formatter.format(this.calendar.getTime()));
                bf.append(")\n");
                this.jTextAreaMessage.setText(bf.toString());
                this.setCursor(new Cursor(0));
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    void jButtonListTables_actionPerformed(ActionEvent e) {
        StringBuffer bf = new StringBuffer();
        NodeList tableList = this.frame_.getDomDocument().getElementsByTagName("Table");
        try {
            try {
                this.setCursor(new Cursor(3));
                bf.append(this.jTextAreaMessage.getText());
                bf.append("\n<Table Module>\t<X-TEA Defined Name>\t<Rows>\n");
                Connection connection = this.frame_.getDatabaseConnList().get(this.jComboBoxConnection.getSelectedIndex());
                Statement statement = connection.createStatement();
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet1 = metaData.getTables(null, null, "%", new String[]{"TABLE"});
                while (resultSet1.next()) {
                    try {
                        ResultSet resultSet2 = this.jComboBoxConnection.getSelectedItem().toString().contains("postgres") ? statement.executeQuery("SELECT COUNT(*) FROM " + resultSet1.getString(3)) : statement.executeQuery("SELECT COUNT(*) AS COUNT FROM " + resultSet1.getString(3));
                        if (!resultSet2.next()) continue;
                        bf.append(resultSet1.getString(3));
                        bf.append("\t");
                        String wrkStr = resultSet1.getString(3).toUpperCase();
                        String tableName = "N/A";
                        int i = 0;
                        while (i < tableList.getLength()) {
                            String moduleID;
                            Element tableElement = (Element)tableList.item(i);
                            if (tableElement.getAttribute("DB").equals(this.dbIDList.get(this.jComboBoxConnection.getSelectedIndex())) && (moduleID = tableElement.getAttribute("ModuleID").equals("") ? tableElement.getAttribute("ID") : tableElement.getAttribute("ModuleID")).equals(wrkStr)) {
                                tableName = tableElement.getAttribute("Name");
                                break;
                            }
                            ++i;
                        }
                        bf.append(tableName);
                        bf.append("\t");
                        bf.append(resultSet2.getInt("COUNT"));
                        bf.append("\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bf.append("(");
                this.calendar = Calendar.getInstance();
                bf.append(this.formatter.format(this.calendar.getTime()));
                bf.append(")\n");
                this.jTextAreaMessage.setText(bf.toString());
            }
            catch (SQLException ex1) {
                bf.append(this.jTextAreaMessage.getText());
                bf.append("\n> Listing tables failed.\n");
                bf.append(ex1.getMessage());
                bf.append("\n(");
                this.calendar = Calendar.getInstance();
                bf.append(this.formatter.format(this.calendar.getTime()));
                bf.append(")\n");
                this.jTextAreaMessage.setText(bf.toString());
                this.setCursor(new Cursor(0));
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    void jButtonClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

