/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogToListIdLabelMap_jButtonCancel_actionAdapter;
import xeadEditor.DialogToListIdLabelMap_jButtonStart_actionAdapter;
import xeadEditor.Editor;

public class DialogToListIdLabelMap
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JPanel panelMain = new JPanel();
    private JButton jButtonStart = new JButton();
    private JButton jButtonCancel = new JButton();
    private JTextArea jTextArea = new JTextArea();
    private JLabel jLabel1 = new JLabel();
    private JTextField jTextFieldTargetTable = new JTextField();
    private Editor frame_;
    private Element systemElement;

    public DialogToListIdLabelMap(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogToListIdLabelMap(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.setTitle(res.getString("IdLabelMap"));
        this.jLabel1.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(res.getString("IdLabelMapTargetTable"));
        this.jLabel1.setBounds(new Rectangle(5, 12, 120, 20));
        this.jTextFieldTargetTable.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldTargetTable.setBounds(new Rectangle(130, 9, 300, 25));
        this.jTextArea.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextArea.setTabSize(4);
        this.jTextArea.setEditable(false);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setBackground(SystemColor.control);
        this.jTextArea.setBounds(new Rectangle(9, 42, 422, 319));
        this.jTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jButtonStart.setBounds(new Rectangle(200, 370, 200, 30));
        this.jButtonStart.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonStart.setText(res.getString("Start"));
        this.jButtonStart.addActionListener(new DialogToListIdLabelMap_jButtonStart_actionAdapter(this));
        this.jButtonCancel.setBounds(new Rectangle(30, 370, 110, 30));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("Close"));
        this.jButtonCancel.addActionListener(new DialogToListIdLabelMap_jButtonCancel_actionAdapter(this));
        this.panelMain.setLayout(null);
        this.panelMain.setPreferredSize(new Dimension(440, 413));
        this.panelMain.setBorder(BorderFactory.createEtchedBorder());
        this.panelMain.add((Component)this.jLabel1, null);
        this.panelMain.add((Component)this.jTextFieldTargetTable, null);
        this.panelMain.add((Component)this.jTextArea, null);
        this.panelMain.add((Component)this.jButtonStart, null);
        this.panelMain.add((Component)this.jButtonCancel, null);
        this.getContentPane().add((Component)this.panelMain, "South");
        this.getRootPane().setDefaultButton(this.jButtonStart);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public void request() {
        this.jTextFieldTargetTable.setText("*All");
        this.jTextArea.setText(res.getString("IdLabelMapMessage"));
        this.jButtonStart.setEnabled(true);
        this.getRootPane().setDefaultButton(this.jButtonStart);
        super.setVisible(true);
    }

    void jButtonStart_actionPerformed(ActionEvent e) {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        String fileName = "";
        ArrayList<String> tableIdList = new ArrayList<String>();
        try {
            this.setCursor(new Cursor(3));
            this.jButtonStart.setVisible(false);
            NodeList elementList = this.frame_.getDomDocument().getElementsByTagName("System");
            this.systemElement = (Element)elementList.item(0);
            NodeList tableList = this.systemElement.getElementsByTagName("Table");
            try {
                File tempFile = File.createTempFile("IdLabelMap" + this.frame_.getStringValueOfDateTime("withTime"), ".txt");
                fileName = tempFile.getPath();
                fileWriter = new FileWriter(fileName);
                bufferedWriter = new BufferedWriter(fileWriter);
                if (!this.jTextFieldTargetTable.getText().toUpperCase().equals("*ALL")) {
                    if (this.jTextFieldTargetTable.getText().contains(";")) {
                        StringTokenizer workTokenizer = new StringTokenizer(this.jTextFieldTargetTable.getText().toUpperCase(), ";");
                        while (workTokenizer.hasMoreTokens()) {
                            tableIdList.add(workTokenizer.nextToken());
                        }
                    } else {
                        tableIdList.add(this.jTextFieldTargetTable.getText().toUpperCase());
                    }
                }
                int countOfTableProcessed = 0;
                bufferedWriter.write("{\"tables\":[");
                int i = 0;
                while (i < tableList.getLength()) {
                    Element tableElement = (Element)tableList.item(i);
                    String tableID = tableElement.getAttribute("ModuleID").equals("") ? tableElement.getAttribute("ID") : tableElement.getAttribute("ModuleID");
                    if (this.jTextFieldTargetTable.getText().toUpperCase().equals("*ALL") || tableIdList.contains(tableID)) {
                        if (countOfTableProcessed > 0) {
                            bufferedWriter.write(",");
                        }
                        bufferedWriter.write("{\"table\":{\"");
                        bufferedWriter.write(tableElement.getAttribute("Name").toLowerCase().replaceAll(" ", "_"));
                        bufferedWriter.write("\":\"");
                        bufferedWriter.write(tableElement.getAttribute("ID").toLowerCase().replaceAll(" ", "_"));
                        bufferedWriter.write("\"},\"fields\":{");
                        NodeList fieldList = tableElement.getElementsByTagName("Field");
                        int j = 0;
                        while (j < fieldList.getLength()) {
                            Element fieldElement = (Element)fieldList.item(j);
                            if (j > 0) {
                                bufferedWriter.write(",");
                            }
                            bufferedWriter.write("\"");
                            bufferedWriter.write(fieldElement.getAttribute("Name").toLowerCase().replaceAll(" ", "_"));
                            bufferedWriter.write("\":\"");
                            bufferedWriter.write(fieldElement.getAttribute("ID").toLowerCase().replaceAll(" ", "_"));
                            bufferedWriter.write("\"");
                            ++j;
                        }
                        bufferedWriter.write("}");
                        bufferedWriter.write("}");
                        ++countOfTableProcessed;
                    }
                    ++i;
                }
                bufferedWriter.write("]}");
            }
            catch (Exception ex1) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
                File workFile = new File(fileName);
                try {
                    try {
                        this.setCursor(new Cursor(3));
                        this.frame_.desktop.open(workFile);
                    }
                    catch (Exception exception) {
                        this.setCursor(new Cursor(0));
                    }
                }
                finally {
                    this.setCursor(new Cursor(0));
                }
            }
            catch (Exception ex3) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.jButtonStart.setVisible(true);
            this.jButtonStart.setEnabled(false);
            this.setCursor(new Cursor(0));
            this.setVisible(false);
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

