/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import xeadEditor.Editor;

class Editor_DialogStructureNodeIconsEdit
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JButton jButtonOK = new JButton();
    private JButton jButtonCancel = new JButton();
    private Editor frame_;
    private JLabel jLabelDefaultIcon = new JLabel();
    private JLabel jLabelFieldID = new JLabel();
    private JLabel jLabelFieldValues = new JLabel();
    private JLabel jLabelIcons = new JLabel();
    private JTextField jTextFieldDefaultIcon = new JTextField();
    private JTextField jTextFieldFieldID = new JTextField();
    private JTextField jTextFieldFieldValues = new JTextField();
    private JTextField jTextFieldIcons = new JTextField();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JPanel jPanelCenter = new JPanel();
    private JPanel jPanelButtons = new JPanel();
    private Editor.MainTreeNode tableNode = null;
    private String headerTableID_ = "";
    private int returnCode;

    public Editor_DialogStructureNodeIconsEdit(Editor frame) {
        super(frame, "", true);
        this.frame_ = frame;
        try {
            this.init();
        }
        catch (Exception ex) {
            this.frame_.processError(ex);
        }
    }

    private void init() throws Exception {
        this.jPanelButtons.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 43));
        this.jPanelButtons.setLayout(null);
        this.jButtonOK.setBounds(new Rectangle(565, 8, 100, 27));
        this.jButtonOK.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor_DialogStructureNodeIconsEdit.this.valuesValidated()) {
                    Editor_DialogStructureNodeIconsEdit.this.returnCode = 1;
                    Editor_DialogStructureNodeIconsEdit.this.setVisible(false);
                }
            }
        });
        this.jButtonCancel.setBounds(new Rectangle(50, 8, 100, 27));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor_DialogStructureNodeIconsEdit.this.setVisible(false);
            }
        });
        this.jPanelButtons.add((Component)this.jButtonOK, null);
        this.jPanelButtons.add((Component)this.jButtonCancel, null);
        this.jPanelCenter.setBorder(null);
        this.jPanelCenter.setLayout(null);
        this.jLabelDefaultIcon.setText(res.getString("StructureNodeDefaultIcon"));
        this.jLabelDefaultIcon.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelDefaultIcon.setHorizontalAlignment(4);
        this.jLabelDefaultIcon.setHorizontalTextPosition(10);
        this.jLabelDefaultIcon.setBounds(new Rectangle(5, 12, 150, 20));
        this.jTextFieldDefaultIcon.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldDefaultIcon.setBounds(new Rectangle(160, 9, 160, 25));
        this.jLabelFieldID.setText(res.getString("StructureNodeIconsFieldID"));
        this.jLabelFieldID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFieldID.setHorizontalAlignment(4);
        this.jLabelFieldID.setHorizontalTextPosition(10);
        this.jLabelFieldID.setBounds(new Rectangle(5, 43, 150, 20));
        this.jTextFieldFieldID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldFieldID.setBounds(new Rectangle(160, 40, 160, 25));
        this.jLabelFieldValues.setText(res.getString("StructureNodeIconsFieldValues"));
        this.jLabelFieldValues.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFieldValues.setHorizontalAlignment(4);
        this.jLabelFieldValues.setHorizontalTextPosition(10);
        this.jLabelFieldValues.setBounds(new Rectangle(5, 74, 150, 20));
        this.jTextFieldFieldValues.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldFieldValues.setBounds(new Rectangle(160, 71, 550, 25));
        this.jLabelIcons.setText(res.getString("StructureNodeIconsList"));
        this.jLabelIcons.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelIcons.setHorizontalAlignment(4);
        this.jLabelIcons.setHorizontalTextPosition(10);
        this.jLabelIcons.setBounds(new Rectangle(5, 105, 150, 20));
        this.jTextFieldIcons.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldIcons.setBounds(new Rectangle(160, 102, 550, 25));
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setBounds(new Rectangle(7, 133, 704, 53));
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setBorder(BorderFactory.createEtchedBorder());
        this.jTextAreaMessage.setBackground(SystemColor.control);
        this.jPanelCenter.add((Component)this.jLabelDefaultIcon, null);
        this.jPanelCenter.add((Component)this.jTextFieldDefaultIcon, null);
        this.jPanelCenter.add((Component)this.jLabelFieldID, null);
        this.jPanelCenter.add((Component)this.jTextFieldFieldID, null);
        this.jPanelCenter.add((Component)this.jLabelFieldValues, null);
        this.jPanelCenter.add((Component)this.jTextFieldFieldValues, null);
        this.jPanelCenter.add((Component)this.jLabelIcons, null);
        this.jPanelCenter.add((Component)this.jTextFieldIcons, null);
        this.jPanelCenter.add((Component)this.jTextAreaMessage, null);
        this.setTitle(res.getString("StructureNodeIconsTitle"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.getContentPane().add((Component)this.jPanelCenter, "Center");
        this.setResizable(false);
        this.pack();
    }

    public int request(String headerTableID, String defaultIcon, String fieldID, String fieldValues, String icons) {
        this.returnCode = 0;
        this.headerTableID_ = headerTableID;
        this.tableNode = this.frame_.getSpecificXETreeNode("Table", this.headerTableID_);
        if (this.tableNode != null) {
            this.jTextFieldDefaultIcon.setText(defaultIcon);
            this.jTextFieldFieldID.setText(fieldID);
            this.jTextFieldFieldValues.setText(fieldValues);
            this.jTextFieldIcons.setText(icons);
            this.jTextAreaMessage.setText(res.getString("StructureNodeIconsComment"));
            this.setSize(new Dimension(725, 277));
            Dimension dlgSize = this.getSize();
            Dimension frmSize = this.frame_.getSize();
            Point loc = this.frame_.getLocation();
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            this.getRootPane().setDefaultButton(this.jButtonOK);
            super.setVisible(true);
        }
        return this.returnCode;
    }

    public String getDefaultIcon() {
        return this.jTextFieldDefaultIcon.getText();
    }

    public String getFieldID() {
        return this.jTextFieldFieldID.getText();
    }

    public String getFieldValues() {
        return this.jTextFieldFieldValues.getText();
    }

    public String getIcons() {
        return this.jTextFieldIcons.getText();
    }

    boolean valuesValidated() {
        boolean isValid = true;
        ArrayList<String> fieldValueList = new ArrayList<String>();
        ArrayList<String> iconList = new ArrayList<String>();
        if (this.tableNode != null) {
            if (this.jTextFieldFieldID.getText().contains(".")) {
                isValid = false;
                this.jTextAreaMessage.setText(res.getString("ErrorMessage109"));
            } else if (this.jTextFieldFieldID.getText().contains(";")) {
                isValid = false;
                this.jTextAreaMessage.setText(res.getString("ErrorMessage115"));
            } else if (this.jTextFieldFieldID.getText().equals("")) {
                if (!this.jTextFieldFieldValues.getText().equals("") || !this.jTextFieldIcons.getText().equals("")) {
                    isValid = false;
                    this.jTextAreaMessage.setText(res.getString("ErrorMessage115"));
                }
            } else if (this.jTextFieldFieldValues.getText().equals("") || this.jTextFieldIcons.getText().equals("")) {
                isValid = false;
                this.jTextAreaMessage.setText(res.getString("ErrorMessage116"));
            } else {
                Element workElement = this.frame_.getSpecificFieldElement(this.headerTableID_, this.jTextFieldFieldID.getText());
                if (workElement == null) {
                    isValid = false;
                    this.jTextAreaMessage.setText(res.getString("ErrorMessage87"));
                }
                if (isValid) {
                    StringTokenizer workTokenizer = new StringTokenizer(this.jTextFieldFieldValues.getText(), ";");
                    while (workTokenizer.hasMoreTokens()) {
                        fieldValueList.add(workTokenizer.nextToken());
                    }
                    workTokenizer = new StringTokenizer(this.jTextFieldIcons.getText(), ";");
                    while (workTokenizer.hasMoreTokens()) {
                        iconList.add(workTokenizer.nextToken());
                    }
                    if (fieldValueList.size() != iconList.size()) {
                        isValid = false;
                        this.jTextAreaMessage.setText(res.getString("ErrorMessage116"));
                    }
                }
            }
        }
        return isValid;
    }
}

