/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputSubset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import xeadEditor.Editor;
import xeadEditor.Editor_EditableField;

class Editor_TextField
extends JTextField
implements Editor_EditableField {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private String basicType_ = "";
    private int digits_ = 5;
    private int decimal_ = 0;
    private int rows_ = 1;
    private ArrayList<String> dataTypeOptionList;
    Editor editor_;

    public Editor_TextField(String basicType, int digits, int decimal, String dataTypeOptions, Editor editor) {
        int fieldWidth;
        this.basicType_ = basicType;
        this.digits_ = this.basicType_.equals("DATE") ? 10 : (this.basicType_.equals("DATETIME") ? 23 : digits);
        this.decimal_ = decimal;
        this.editor_ = editor;
        this.dataTypeOptionList = this.editor_.getOptionList(dataTypeOptions);
        if (this.basicType_.equals("INTEGER")) {
            this.setHorizontalAlignment(4);
            this.setText("0");
        } else if (this.basicType_.equals("FLOAT")) {
            this.setHorizontalAlignment(4);
            if (this.decimal_ == 0) {
                this.setText("0");
            }
            if (this.decimal_ == 1) {
                this.setText("0.0");
            }
            if (this.decimal_ == 2) {
                this.setText("0.00");
            }
            if (this.decimal_ == 3) {
                this.setText("0.000");
            }
            if (this.decimal_ == 4) {
                this.setText("0.0000");
            }
            if (this.decimal_ == 5) {
                this.setText("0.00000");
            }
            if (this.decimal_ == 6) {
                this.setText("0.000000");
            }
        } else {
            this.setHorizontalAlignment(2);
        }
        this.addFocusListener(new ComponentFocusListener());
        this.setFont(new Font(this.editor_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.setDocument(new LimitedDocument(this));
        if (this.dataTypeOptionList.contains("KANJI") || this.dataTypeOptionList.contains("ZIPADRS")) {
            fieldWidth = this.digits_ * Editor.MAIN_FONT_SIZE + 10;
        } else if (this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT")) {
            int totalLength = this.editor_.getLengthOfEdittedNumericValue(this.digits_, this.decimal_, this.dataTypeOptionList.contains("ACCEPT_MINUS"));
            fieldWidth = totalLength * (Editor.MAIN_FONT_SIZE / 2 + 2) + 15;
        } else {
            fieldWidth = this.digits_ * (Editor.MAIN_FONT_SIZE / 2 + 2) + 10;
        }
        if (fieldWidth > 800) {
            fieldWidth = 800;
        }
        this.setSize(new Dimension(fieldWidth, 27));
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
    }

    public String getStringNumber(String text) {
        String numberString = this.editor_.getStringNumber(text);
        if (numberString.equals("")) {
            if (this.basicType_.equals("INTEGER")) {
                numberString = "0";
            }
            if (this.basicType_.equals("FLOAT")) {
                if (this.decimal_ == 0) {
                    numberString = "0";
                }
                if (this.decimal_ == 1) {
                    numberString = "0.0";
                }
                if (this.decimal_ == 2) {
                    numberString = "0.00";
                }
                if (this.decimal_ == 3) {
                    numberString = "0.000";
                }
                if (this.decimal_ == 4) {
                    numberString = "0.0000";
                }
                if (this.decimal_ == 5) {
                    numberString = "0.00000";
                }
                if (this.decimal_ == 6) {
                    numberString = "0.000000";
                }
            }
        } else if (this.dataTypeOptionList.contains("ZIPNO")) {
            numberString = numberString.replace("-", "");
            int workLength = 7 - numberString.length();
            int i = 0;
            while (i < workLength) {
                numberString = String.valueOf(numberString) + "0";
                ++i;
            }
            numberString = String.valueOf(numberString.substring(0, 3)) + "-" + numberString.substring(3, 7);
        }
        return numberString;
    }

    @Override
    public Object getInternalValue() {
        String text = "";
        text = this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT") || this.dataTypeOptionList.contains("DIAL") || this.dataTypeOptionList.contains("ZIPNO") ? this.getStringNumber(this.getText()) : this.getText();
        return text;
    }

    @Override
    public void setValue(Object obj) {
        String text = "";
        if (obj != null) {
            text = obj.toString();
            if (this.basicType_.equals("INTEGER") || this.basicType_.equals("FLOAT")) {
                if (this.dataTypeOptionList.contains("FYEAR")) {
                    this.setText(text);
                } else {
                    this.setText(this.editor_.getFormattedNumber(text, this.basicType_, this.digits_, this.decimal_, this.dataTypeOptionList));
                }
            }
            if (this.basicType_.equals("DATE")) {
                this.setText(text);
            }
            if (this.basicType_.equals("TIME")) {
                this.setText(text);
            }
            if (this.basicType_.equals("DATETIME")) {
                this.setText(text);
            }
            if (this.basicType_.equals("STRING")) {
                text = text.trim();
                this.setText(text);
            }
        }
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            Editor_TextField.this.getInputContext().setCharacterSubsets(subsets);
            if (Editor_TextField.this.basicType_.equals("INTEGER") || Editor_TextField.this.basicType_.equals("FLOAT")) {
                Editor_TextField.this.setText(Editor_TextField.this.editor_.getFormattedNumber(Editor_TextField.this.getText(), Editor_TextField.this.basicType_, Editor_TextField.this.digits_, Editor_TextField.this.decimal_, Editor_TextField.this.dataTypeOptionList));
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            if (Editor_TextField.this.basicType_.equals("STRING")) {
                String lang = Locale.getDefault().getLanguage();
                if (Editor_TextField.this.dataTypeOptionList.contains("KANJI") || Editor_TextField.this.dataTypeOptionList.contains("ZIPADRS")) {
                    if (lang.equals("ja")) {
                        subsets = new Character.Subset[]{InputSubset.KANJI};
                    }
                    if (lang.equals("ko")) {
                        subsets = new Character.Subset[]{InputSubset.HANJA};
                    }
                    if (lang.equals("zh")) {
                        subsets = new Character.Subset[]{InputSubset.TRADITIONAL_HANZI};
                    }
                } else if (Editor_TextField.this.dataTypeOptionList.contains("KATAKANA") && lang.equals("ja")) {
                    subsets = new Character.Subset[]{InputSubset.HALFWIDTH_KATAKANA};
                }
            }
            Editor_TextField.this.getInputContext().setCharacterSubsets(subsets);
        }
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        Editor_TextField adaptee;

        LimitedDocument(Editor_TextField adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) {
            try {
                int integerSizeOfField = this.adaptee.digits_ - this.adaptee.decimal_;
                if (this.adaptee.decimal_ > 0 && str.length() == 1) {
                    if (this.adaptee.isEditable() && !Editor_TextField.this.dataTypeOptionList.contains("ACCEPT_MINUS") && str.contains("-")) {
                        JOptionPane.showMessageDialog(null, res.getString("MinusRejectMessage"));
                    } else {
                        String wrkStr0 = super.getText(0, super.getLength());
                        wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                        String wrkStr1 = wrkStr0.replace(".", "");
                        wrkStr1 = wrkStr1.replace(",", "");
                        wrkStr1 = wrkStr1.replace("-", "");
                        if ((wrkStr1 = wrkStr1.replace(":", "")).length() > this.adaptee.digits_) {
                            wrkStr1 = String.valueOf(wrkStr1.substring(0, integerSizeOfField)) + "." + wrkStr1.substring(integerSizeOfField, wrkStr1.length() - 1);
                            super.replace(0, super.getLength(), wrkStr1, attr);
                        } else {
                            int posOfDecimal = wrkStr0.indexOf(".");
                            if (posOfDecimal == -1) {
                                if (wrkStr1.length() > integerSizeOfField) {
                                    wrkStr1 = String.valueOf(wrkStr1.substring(0, integerSizeOfField)) + "." + wrkStr1.substring(integerSizeOfField, wrkStr1.length());
                                    super.replace(0, super.getLength(), wrkStr1, attr);
                                } else {
                                    super.insertString(offset, str, attr);
                                }
                            } else {
                                int decimalLengthOfInputData = wrkStr0.length() - posOfDecimal - 1;
                                if (decimalLengthOfInputData <= this.adaptee.decimal_) {
                                    super.insertString(offset, str, attr);
                                }
                            }
                        }
                    }
                } else if (this.adaptee.isEditable() && Editor_TextField.this.dataTypeOptionList.contains("NO_MINUS") && str.contains("-")) {
                    JOptionPane.showMessageDialog(null, res.getString("MinusRejectMessage"));
                } else if (Editor_TextField.this.basicType_.equals("INTEGER")) {
                    if (str.contains(".")) {
                        JOptionPane.showMessageDialog(null, res.getString("NumberFormatError"));
                    } else {
                        String wrkStr0 = super.getText(0, super.getLength());
                        wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                        String wrkStr1 = wrkStr0.replace(".", "");
                        wrkStr1 = wrkStr1.replace(",", "");
                        wrkStr1 = wrkStr1.replace("-", "");
                        if ((wrkStr1 = wrkStr1.replace(":", "")).length() <= this.adaptee.digits_) {
                            super.insertString(offset, str, attr);
                        }
                    }
                } else if (offset < this.adaptee.digits_ && super.getLength() < this.adaptee.digits_) {
                    super.insertString(offset, str, attr);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

