/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class LimitSizeTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    protected Integer max = null;

    LimitSizeTextField() {
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitDocument();
    }

    private boolean canInsertString(String str) {
        if (this.max == null) {
            return true;
        }
        if (this.max < 0) {
            return true;
        }
        return super.getText().length() + str.length() <= this.max;
    }

    public Integer getMaxLength() {
        return this.max;
    }

    public void setMaxLength(Integer max) {
        this.max = max;
    }

    protected class LimitDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        protected LimitDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (a != null) {
                super.insertString(offs, str, a);
                return;
            }
            if (!LimitSizeTextField.this.canInsertString(str)) {
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

