/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.RandomStringUtils;
import org.w3c.dom.Element;
import xeadDriver.DialogAbout;
import xeadDriver.DialogLogin_jButtonAbout_actionAdapter;
import xeadDriver.DialogLogin_jButtonClose_actionAdapter;
import xeadDriver.DialogLogin_jButtonOK_actionAdapter;
import xeadDriver.DialogLogin_jButtonResetPassword_actionAdapter;
import xeadDriver.Session;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

public class DialogLogin
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelMain = new JPanel();
    private JButton jButtonOK = new JButton();
    private JButton jButtonClose = new JButton();
    private JButton jButtonAbout = new JButton();
    private JLabel jLabelUserID = new JLabel();
    private int lengthOfUserID = 0;
    private JLabel jLabelPassword = new JLabel();
    private JTextField jTextFieldUserID = new JTextField();
    private JPasswordField jPasswordField = new JPasswordField();
    private JButton jButtonResetPassword = new JButton();
    private Session session = null;
    private String userID;
    private String userName;
    private String userEmployeeNo;
    private String userEmailAddress;
    private String userMenus = "";
    private boolean validated = false;
    private DialogAbout dialogAbout;

    public DialogLogin(Session session, String loginUser, String loginPassword) {
        super(session, "", true);
        try {
            this.session = session;
            Image imageTitle = Toolkit.getDefaultToolkit().createImage(Session.class.getResource("title.png"));
            this.setIconImage(imageTitle);
            this.setTitle(session.getSystemName());
            this.jPanelMain.setBorder(BorderFactory.createEtchedBorder());
            this.jPanelMain.setPreferredSize(new Dimension(420, 130));
            this.jPanelMain.setLayout(null);
            Element fieldElement = this.session.getFieldElement(session.getTableNameOfUser(), "IDUSER");
            this.lengthOfUserID = Integer.parseInt(fieldElement.getAttribute("Size"));
            this.jLabelUserID.setHorizontalAlignment(4);
            this.jLabelUserID.setBounds(new Rectangle(5, 15, 130, 25));
            this.jLabelUserID.setFont(new Font(session.systemFont, 0, 16));
            this.jLabelUserID.setText(fieldElement.getAttribute("Name"));
            this.jTextFieldUserID.setFont(new Font(session.systemFont, 0, 16));
            this.jTextFieldUserID.setBounds(new Rectangle(140, 15, this.lengthOfUserID * 14, 25));
            this.jTextFieldUserID.setDocument(new LimitedDocument(this.lengthOfUserID));
            this.jTextFieldUserID.setText(loginUser);
            fieldElement = this.session.getFieldElement(session.getTableNameOfUser(), "TXPASSWORD");
            this.jLabelPassword.setHorizontalAlignment(4);
            this.jLabelPassword.setBounds(new Rectangle(5, 50, 130, 25));
            this.jLabelPassword.setFont(new Font(session.systemFont, 0, 16));
            this.jLabelPassword.setText(fieldElement.getAttribute("Name"));
            this.jPasswordField.setFont(new Font(session.systemFont, 0, 16));
            this.jPasswordField.setBounds(new Rectangle(140, 50, 180, 25));
            this.jPasswordField.setDocument(new LimitedDocument(10));
            this.jPasswordField.setText(loginPassword);
            this.jButtonResetPassword.setFont(new Font(session.systemFont, 0, 16));
            this.jButtonResetPassword.setText("?");
            this.jButtonResetPassword.setBounds(new Rectangle(322, 49, 68, 27));
            this.jButtonResetPassword.addActionListener(new DialogLogin_jButtonResetPassword_actionAdapter(this));
            this.jButtonClose.setBounds(new Rectangle(30, 90, 100, 29));
            this.jButtonClose.setFont(new Font(session.systemFont, 0, 16));
            this.jButtonClose.setText(XFUtility.RESOURCE.getString("Close"));
            this.jButtonClose.addActionListener(new DialogLogin_jButtonClose_actionAdapter(this));
            this.jButtonOK.setBounds(new Rectangle(150, 90, 120, 29));
            this.jButtonOK.setFont(new Font(session.systemFont, 0, 16));
            this.jButtonOK.setText(XFUtility.RESOURCE.getString("LogIn"));
            this.jButtonOK.addActionListener(new DialogLogin_jButtonOK_actionAdapter(this));
            this.jButtonAbout.setBounds(new Rectangle(290, 90, 100, 29));
            this.jButtonAbout.setFont(new Font(session.systemFont, 0, 16));
            this.jButtonAbout.setText("About");
            this.jButtonAbout.addActionListener(new DialogLogin_jButtonAbout_actionAdapter(this));
            this.getContentPane().add((Component)this.jPanelMain, "Center");
            this.jPanelMain.add((Component)this.jButtonClose, null);
            this.jPanelMain.add((Component)this.jButtonOK, null);
            this.jPanelMain.add((Component)this.jButtonAbout, null);
            this.jPanelMain.add((Component)this.jLabelUserID, null);
            this.jPanelMain.add((Component)this.jLabelPassword, null);
            this.jPanelMain.add((Component)this.jTextFieldUserID, null);
            this.jPanelMain.add((Component)this.jPasswordField, null);
            this.jPanelMain.add((Component)this.jButtonResetPassword, null);
            this.pack();
            this.dialogAbout = new DialogAbout(this, session.systemFont);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean userIsValidated(boolean isOnlineJob) throws Exception {
        String password = new String(this.jPasswordField.getPassword());
        if (this.jTextFieldUserID.getText().equals("") || password.equals("")) {
            if (isOnlineJob) {
                this.jPanelMain.getRootPane().setDefaultButton(this.jButtonOK);
                Dimension dlgSize = this.getPreferredSize();
                Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
                this.pack();
                super.setVisible(true);
            } else {
                this.validated = false;
            }
        } else {
            this.validated = this.isValidPassword(this.jTextFieldUserID.getText(), password);
        }
        return this.validated;
    }

    void jButtonResetPassword_actionPerformed(ActionEvent e) {
        block11: {
            Object[] bts = new Object[]{XFUtility.RESOURCE.getString("Yes"), XFUtility.RESOURCE.getString("No")};
            int rtn = JOptionPane.showOptionDialog(this, XFUtility.RESOURCE.getString("ResetPasswordMessage1"), XFUtility.RESOURCE.getString("ResetPasswordTitle"), -1, 1, null, bts, bts[0]);
            if (rtn == 0) {
                try {
                    try {
                        this.setCursor(new Cursor(3));
                        StringBuffer statementBuf = new StringBuffer();
                        statementBuf.append("select * from " + this.session.getTableNameOfUser());
                        statementBuf.append(" where IDUSER = '" + this.jTextFieldUserID.getText() + "'");
                        XFTableOperator operator = new XFTableOperator(this.session, null, statementBuf.toString(), true);
                        if (operator.next()) {
                            String emailAddress = operator.getValueOf("TXEMAIL").toString().trim();
                            if (emailAddress.equals("")) {
                                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ResetPasswordMessage6"));
                            } else {
                                String newPassword = RandomStringUtils.random((int)7, (String)"abcdefghijkmnprstuvwxyz23456789");
                                String digestedValue = this.session.getDigestedValueForUser(this.jTextFieldUserID.getText(), newPassword);
                                int updCounter = Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                                statementBuf = new StringBuffer();
                                statementBuf.append("update " + this.session.getTableNameOfUser());
                                statementBuf.append(" set TXPASSWORD = '" + digestedValue + "'");
                                statementBuf.append(", UPDCOUNTER = " + (updCounter + 1));
                                statementBuf.append(" where IDUSER = '" + this.jTextFieldUserID.getText() + "'");
                                statementBuf.append(" and UPDCOUNTER = " + updCounter);
                                operator = new XFTableOperator(this.session, null, statementBuf.toString(), true);
                                int count = operator.execute();
                                if (count == 1) {
                                    String emailMessage = String.valueOf(XFUtility.RESOURCE.getString("ResetPasswordMessage4")) + newPassword;
                                    this.session.sendMail(this.session.getAdminEmail(), emailAddress, "", String.valueOf(this.session.getSystemName()) + XFUtility.RESOURCE.getString("ResetPasswordMessage5"), emailMessage);
                                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ResetPasswordMessage7"));
                                } else {
                                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ResetPasswordMessage3"));
                                }
                            }
                            break block11;
                        }
                        JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ResetPasswordMessage2"));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("ResetPasswordMessage3"));
                        this.setCursor(new Cursor(0));
                    }
                }
                finally {
                    this.setCursor(new Cursor(0));
                }
            }
        }
    }

    void jButtonOK_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.setCursor(new Cursor(3));
            if (this.isValidPassword(this.jTextFieldUserID.getText(), new String(this.jPasswordField.getPassword()))) {
                this.setVisible(false);
            }
        }
        finally {
            this.jPasswordField.setText("");
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            super.processWindowEvent(e);
            this.jButtonClose_actionPerformed(null);
        } else {
            super.processWindowEvent(e);
        }
    }

    void jButtonAbout_actionPerformed(ActionEvent e) {
        this.dialogAbout.request();
    }

    boolean isValidPassword(String originalUserID, String password) throws Exception {
        if (originalUserID.length() == this.lengthOfUserID) {
            String userID = originalUserID.substring(0, this.lengthOfUserID);
            if (userID.equals("") || !userID.matches("[0-9a-zA-Z]+") || password.equals("")) {
                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInComment"));
            } else {
                StringBuffer statementBuf = new StringBuffer();
                statementBuf.append("select * from ");
                statementBuf.append(this.session.getTableNameOfUserVariants());
                statementBuf.append(" where IDUSERKUBUN = 'KBCALENDAR'");
                XFTableOperator operator = new XFTableOperator(this.session, null, statementBuf.toString(), true);
                if (!operator.next()) {
                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError5"));
                    this.validated = false;
                } else if (this.session.getSystemVariantString("LOGIN_PERMITTED").equals("")) {
                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError4"));
                    this.validated = false;
                } else if (this.session.getSystemVariantString("LOGIN_PERMITTED").equals("F")) {
                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError3"));
                } else {
                    String passwordDigested = this.session.getDigestedValueForUser(userID, password);
                    statementBuf = new StringBuffer();
                    statementBuf.append("select * from ");
                    statementBuf.append(this.session.getTableNameOfUser());
                    statementBuf.append(" where IDUSER = '");
                    statementBuf.append(userID);
                    statementBuf.append("' and TXPASSWORD = '");
                    statementBuf.append(passwordDigested);
                    statementBuf.append("'");
                    int retryCount = 0;
                    while (retryCount < 3) {
                        try {
                            ++retryCount;
                            operator = new XFTableOperator(this.session, null, statementBuf.toString(), true);
                            if (operator.next()) {
                                Date resultDateFrom = null;
                                Date resultDateThru = null;
                                Date today = new Date();
                                resultDateFrom = (Date)operator.getValueOf("DTVALID");
                                resultDateThru = (Date)operator.getValueOf("DTEXPIRE");
                                if (today.after(resultDateFrom)) {
                                    if (resultDateThru == null || today.before(resultDateThru)) {
                                        this.userID = this.jTextFieldUserID.getText();
                                        this.userName = operator.getValueOf("TXNAME").toString().trim();
                                        this.userEmployeeNo = operator.getValueOf("NREMPLOYEE").toString().trim();
                                        this.userEmailAddress = operator.getValueOf("TXEMAIL").toString().trim();
                                        this.userMenus = operator.getValueOf("TXMENUS").toString().trim();
                                        this.validated = true;
                                    } else {
                                        JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError1"));
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError1"));
                                }
                            } else {
                                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError2"));
                            }
                            retryCount = 3;
                        }
                        catch (Exception e) {
                            if (retryCount < 3) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            throw e;
                        }
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("LogInError2"));
            this.validated = false;
        }
        return this.validated;
    }

    void jButtonClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    String getUserID() {
        return this.userID;
    }

    String getUserName() {
        return this.userName;
    }

    String getUserEmployeeNo() {
        return this.userEmployeeNo;
    }

    String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    String getUserMenus() {
        return this.userMenus;
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        int limit;

        LimitedDocument(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            if (offset >= this.limit) {
                return;
            }
            try {
                super.insertString(offset, str, a);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

