/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import com.lowagie.text.pdf.BaseFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.xerces.parsers.DOMParser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xeadDriver.Application;
import xeadDriver.DialogCheckRead;
import xeadDriver.DialogLogin;
import xeadDriver.DialogModifyPassword;
import xeadDriver.DigestAdapter;
import xeadDriver.Session_jButton_actionAdapter;
import xeadDriver.Session_jEditorPane_actionAdapter;
import xeadDriver.Session_jLabelSession_mouseAdapter;
import xeadDriver.Session_jTabbedPaneMenu_changeAdapter;
import xeadDriver.Session_keyAdapter;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF000;
import xeadDriver.XF100;
import xeadDriver.XF110;
import xeadDriver.XF200;
import xeadDriver.XF290;
import xeadDriver.XF300;
import xeadDriver.XF310;
import xeadDriver.XF390;
import xeadDriver.XFCalendar;
import xeadDriver.XFCheckListDialog;
import xeadDriver.XFExcelFileOperator;
import xeadDriver.XFExecutable;
import xeadDriver.XFHttpRequest;
import xeadDriver.XFInputDialog;
import xeadDriver.XFLongTextEditor;
import xeadDriver.XFOptionDialog;
import xeadDriver.XFTableOperator;
import xeadDriver.XFTextFileOperator;
import xeadDriver.XFUtility;

public class Session
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String systemName = "";
    private String systemVersion = "";
    private String sessionID = "";
    private String sessionStatus = "";
    private String processorVersion = "";
    private boolean noErrorsOccured = true;
    private boolean skipPreload = false;
    private boolean isClientSession = true;
    private String databaseName = "";
    private String databaseUser = "";
    private String databasePassword = "";
    private String appServerName = "";
    private String fileName = "";
    private String userID = "";
    private String userName = "";
    private String userEmployeeNo = "";
    private String userEmailAddress = "";
    private String digestAlgorithmForUser = "MD5";
    private int countOfExpandForUser = 1;
    private boolean isValueSaltedForUser = false;
    public String userMenus = "";
    private String userTable = "";
    private String userFilterValueTable = "";
    private String variantsTable = "";
    private String userVariantsTable = "";
    private String sessionTable = "";
    private String sessionDetailTable = "";
    private String numberingTable = "";
    private String calendarTable = "";
    public String taxTable = "";
    private String exchangeRateAnnualTable = "";
    private String exchangeRateMonthlyTable = "";
    private String menuIDUsing = "";
    private String imageFileFolder = "";
    private File outputFolder = null;
    private String logFileFolder = "";
    private int loggingSize = 0;
    private String welcomePageURL = "";
    private String dateFormat = "";
    public String systemFont = "";
    private int sqProgram = 0;
    private String currentFolder = "";
    private String loginScript = "";
    private String scriptFunctions = "";
    private String smtpHost = "";
    private String smtpPort = "";
    private String smtpUser = "";
    private String smtpPassword = "";
    private String smtpAdminEmail = "";
    private String proxyIP = "";
    private String proxyPort = "";
    private Image imageTitle;
    private Dimension screenSize = new Dimension(0, 0);
    private Connection connectionManualCommit = null;
    private Connection connectionAutoCommit = null;
    private ArrayList<String> subDBIDList = new ArrayList();
    private ArrayList<String> subDBNameList = new ArrayList();
    private ArrayList<String> subDBUserList = new ArrayList();
    private ArrayList<String> subDBPasswordList = new ArrayList();
    private ArrayList<Connection> subDBConnectionList = new ArrayList();
    private String[] menuIDArray = new String[20];
    private String[] menuCaptionArray = new String[20];
    private String[] helpURLArray = new String[20];
    private MenuOption[][] menuOptionArray = new MenuOption[20][20];
    private JButton[] jButtonMenuOptionArray = new JButton[20];
    private ArrayList<String> loadingFunctionIDList = new ArrayList();
    private XFCalendar xfCalendar = null;
    public JFileChooser jFileChooser = new JFileChooser();
    public FileDialog fileDialog = new FileDialog(this);
    private JLabel jLabelUser = new JLabel();
    private JLabel jLabelSession = new JLabel();
    private GridLayout gridLayoutMenuButtons = new GridLayout();
    private JPanel jPanelTop = new JPanel();
    private JPanel jPanelMenu = new JPanel();
    private JPanel jPanelMenuCenter = new JPanel();
    private JPanel jPanelMenuTopMargin = new JPanel();
    private JPanel jPanelMenuLeftMargin = new JPanel();
    private JPanel jPanelMenuRightMargin = new JPanel();
    private JPanel jPanelMenuBottomMargin = new JPanel();
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JSplitPane jSplitPane2 = new JSplitPane();
    private JScrollPane jScrollPaneNews = new JScrollPane();
    private JScrollPane jScrollPaneMenu = new JScrollPane();
    private JTabbedPane jTabbedPaneMenu = new JTabbedPane();
    private JEditorPane jEditorPaneNews = new JEditorPane();
    public HTMLEditorKit editorKit = new HTMLEditorKit();
    private ImageIcon imageIcon = null;
    private JTextArea jTextAreaMessages = new JTextArea();
    private JScrollPane jScrollPaneMessages = new JScrollPane();
    private Calendar calendar = GregorianCalendar.getInstance();
    private Document domDocument;
    private Desktop desktop = Desktop.getDesktop();
    private DialogLogin loginDialog = null;
    private DialogModifyPassword modifyPasswordDialog = null;
    private DialogCheckRead checkReadDialog = null;
    private FunctionLauncher functionLauncher = null;
    private SortableDomElementListModel sortingList;
    private NodeList functionList = null;
    private NodeList tableList = null;
    private ArrayList<String> offDateList = new ArrayList();
    private HashMap<String, BaseFont> baseFontMap = new HashMap();
    private HashMap<String, String> attributeMap = new HashMap();
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private Bindings globalScriptBindings = null;
    private ScriptEngine scriptEngine = null;
    private static final String ZIP_URL = "http://zip.cgis.biz/xml/zip.php?";
    private DOMParser domParser = new DOMParser();
    private Document responseDoc = null;
    private HttpGet httpGet = new HttpGet();
    private ArrayList<XFExecutable> preloadedFunctionList = new ArrayList();
    private Application application = null;
    private XFInputDialog inputDialog = null;
    private XFCheckListDialog checkListDialog = null;
    private XFLongTextEditor xfLongTextEditor = null;
    private String specificFunctionID = "";
    private ArrayList<JScrollPane> messageComponentList = new ArrayList();

    public Session(String[] args, Application app) {
        String loginUser = "";
        String loginPassword = "";
        this.application = app;
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.7.")) {
            version.startsWith("1.8.");
        }
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("SKIP_PRELOAD")) {
                    this.skipPreload = true;
                } else if (args[i].startsWith("FUNCTION=")) {
                    this.specificFunctionID = args[i].replace("FUNCTION=", "");
                } else if (this.fileName.equals("")) {
                    this.fileName = args[i];
                } else if (loginUser.equals("")) {
                    loginUser = args[i];
                } else if (loginPassword.equals("")) {
                    loginPassword = args[i];
                }
                ++i;
            }
            if (this.fileName.equals("")) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Session.this.application.hideSplash();
                    }
                });
                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError1"));
                System.exit(0);
            } else if (this.parseSystemDefinition(this.fileName)) {
                if (this.setupSessionVariants()) {
                    this.application.setTextOnSplash(XFUtility.RESOURCE.getString("SplashMessage6"));
                    this.loginDialog = new DialogLogin(this, loginUser, loginPassword);
                    if (this.loginDialog.userIsValidated(true)) {
                        this.userID = this.loginDialog.getUserID();
                        this.userName = this.loginDialog.getUserName();
                        this.userEmployeeNo = this.loginDialog.getUserEmployeeNo();
                        this.userEmailAddress = this.loginDialog.getUserEmailAddress();
                        this.userMenus = this.loginDialog.getUserMenus();
                        this.processorVersion = "D1.3.36";
                        this.writeLogAndStartSession();
                        this.setupMenusAndComponents();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Session.this.application.hideSplash();
                            }
                        });
                        if (this.specificFunctionID.equals("")) {
                            this.messageComponentList.add(this.jScrollPaneMessages);
                            this.setVisible(true);
                        } else {
                            this.setVisible(true);
                            this.executeSpecificFunction();
                            this.closeSession(true);
                            System.exit(0);
                        }
                    } else {
                        this.closeSession(false);
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        }
        catch (ScriptException e) {
            JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError0")) + "\n" + e.getMessage());
            this.noErrorsOccured = false;
            this.closeSession(false);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("LogInError3")) + "\n" + e.getMessage());
            this.noErrorsOccured = false;
            this.closeSession(false);
            System.exit(0);
        }
    }

    public void setMessageComponent(JScrollPane component) {
        if (!this.messageComponentList.contains(component)) {
            this.messageComponentList.add(component);
        }
    }

    public JScrollPane getMessageComponent() {
        if (this.messageComponentList.size() == 0) {
            return null;
        }
        return this.messageComponentList.get(this.messageComponentList.size() - 1);
    }

    public void removeMessageComponent(JScrollPane component) {
        if (!this.messageComponentList.contains(component)) {
            this.messageComponentList.remove(component);
        }
    }

    private void executeSpecificFunction() {
        String returnMessage = "";
        this.userMenus = "";
        this.menuIDUsing = "**";
        try {
            Object[] bts;
            int rtn;
            HashMap<String, Object> returnMap = this.functionLauncher.execute(this.specificFunctionID, new HashMap<String, Object>());
            if (returnMap != null && returnMap.get("RETURN_CODE") != null) {
                returnMessage = returnMap.get("RETURN_MESSAGE") == null ? XFUtility.getMessageOfReturnCode(returnMap.get("RETURN_CODE").toString()) : returnMap.get("RETURN_MESSAGE").toString();
            }
            while ((rtn = JOptionPane.showOptionDialog(this, returnMessage, this.systemName, -1, 1, null, bts = new Object[]{XFUtility.RESOURCE.getString("LogOut"), XFUtility.RESOURCE.getString("CheckSession")}, bts[0])) == 1) {
                HashMap<String, Object> parmMap = new HashMap<String, Object>();
                parmMap.put("NRSESSION", this.sessionID);
                this.functionLauncher.execute("ZF051", parmMap);
                returnMessage = XFUtility.RESOURCE.getString("LogOutConfirm");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("LogInError3")) + "\n" + e.getMessage());
            this.noErrorsOccured = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session(String fileName, String user, String password, String xeadServerVersion) throws Exception {
        try {
            this.isClientSession = false;
            if (!this.parseSystemDefinition(fileName)) throw new Exception("Failed to parse the system definition file.");
            if (!this.setupSessionVariants()) throw new Exception("System definition file is invalid to setup session.");
            this.loginDialog = new DialogLogin(this, user, password);
            if (!this.loginDialog.userIsValidated(false)) {
                throw new Exception("User or password is invalid.");
            }
            this.userID = this.loginDialog.getUserID();
            this.userName = this.loginDialog.getUserName();
            this.userEmployeeNo = this.loginDialog.getUserEmployeeNo();
            this.userEmailAddress = this.loginDialog.getUserEmailAddress();
            this.userMenus = "";
            this.menuIDUsing = "**";
            this.processorVersion = "S" + xeadServerVersion;
            this.writeLogAndStartSession();
            return;
        }
        catch (Exception e) {
            this.noErrorsOccured = false;
            this.closeSession(false);
            System.exit(0);
            throw e;
        }
    }

    private boolean parseSystemDefinition(String fileName) throws Exception {
        if (this.application != null) {
            this.application.setTextOnSplash(XFUtility.RESOURCE.getString("SplashMessage1"));
            this.application.setProgressMax(5);
            this.application.setProgressValue(1);
        }
        if (fileName.startsWith("http:") || fileName.startsWith("https:") || fileName.startsWith("file:")) {
            try {
                URL url = new URL(fileName);
                this.currentFolder = url.getPath();
                URLConnection connection = url.openConnection();
                InputStream inputStream = connection.getInputStream();
                this.domParser.parse(new InputSource(inputStream));
                this.domDocument = this.domParser.getDocument();
                return true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, String.valueOf(XFUtility.RESOURCE.getString("SessionError2")) + fileName + XFUtility.RESOURCE.getString("SessionError3") + "\n" + e.getMessage());
                return false;
            }
        }
        File xeafFile = new File(fileName);
        if (xeafFile.exists()) {
            this.currentFolder = xeafFile.getParent();
            try {
                this.domParser.parse(new InputSource(new FileInputStream(fileName)));
                this.domDocument = this.domParser.getDocument();
                return true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, String.valueOf(XFUtility.RESOURCE.getString("SessionError2")) + fileName + XFUtility.RESOURCE.getString("SessionError3") + "\n" + e.getMessage());
                return false;
            }
        }
        JOptionPane.showMessageDialog(this, String.valueOf(XFUtility.RESOURCE.getString("SessionError21")) + fileName + XFUtility.RESOURCE.getString("SessionError22"));
        return false;
    }

    private boolean setupSessionVariants() throws Exception {
        boolean isOkay;
        String wrkStr;
        if (this.application != null) {
            this.application.setProgressValue(2);
        }
        NodeList nodeList = this.domDocument.getElementsByTagName("System");
        Element element = (Element)nodeList.item(0);
        this.systemName = element.getAttribute("Name");
        this.systemVersion = element.getAttribute("Version");
        this.welcomePageURL = element.getAttribute("WelcomePageURL");
        this.dateFormat = element.getAttribute("DateFormat");
        this.systemFont = element.getAttribute("SystemFont");
        if (this.systemFont.equals("")) {
            this.systemFont = "SanSerif";
        }
        this.calendar.setLenient(false);
        String hashFormat = element.getAttribute("HashFormat");
        if (!hashFormat.equals("")) {
            try {
                StringTokenizer workTokenizer = new StringTokenizer(hashFormat, ";");
                this.digestAlgorithmForUser = workTokenizer.nextToken();
                if (!this.digestAlgorithmForUser.equals("MD5")) {
                    new DigestAdapter(this.digestAlgorithmForUser);
                }
                if (workTokenizer.hasMoreTokens()) {
                    this.countOfExpandForUser = Integer.parseInt(workTokenizer.nextToken());
                }
                if (workTokenizer.hasMoreTokens()) {
                    this.isValueSaltedForUser = Boolean.parseBoolean(workTokenizer.nextToken());
                }
            }
            catch (Exception workTokenizer) {
                // empty catch block
            }
        }
        this.inputDialog = new XFInputDialog(this);
        this.checkListDialog = new XFCheckListDialog(this);
        this.xfLongTextEditor = new XFLongTextEditor(this);
        if (this.application != null) {
            this.application.setProgressValue(3);
        }
        this.imageFileFolder = (wrkStr = element.getAttribute("ImageFileFolder")).equals("") ? String.valueOf(this.currentFolder) + File.separator : (wrkStr.contains("<CURRENT>") ? String.valueOf(wrkStr.replace("<CURRENT>", this.currentFolder)) + File.separator : String.valueOf(wrkStr) + File.separator);
        wrkStr = element.getAttribute("OutputFolder");
        if (wrkStr.equals("")) {
            this.outputFolder = null;
        } else {
            if (wrkStr.contains("<CURRENT>")) {
                wrkStr = wrkStr.replace("<CURRENT>", this.currentFolder);
            }
            this.outputFolder = new File(wrkStr);
            if (!this.outputFolder.exists()) {
                this.outputFolder = null;
            }
        }
        wrkStr = element.getAttribute("LogFileFolder");
        if (wrkStr.equals("")) {
            this.logFileFolder = String.valueOf(this.currentFolder) + File.separator + "log" + File.separator;
        } else {
            this.imageFileFolder = wrkStr.contains("<CURRENT>") ? String.valueOf(wrkStr.replace("<CURRENT>", this.currentFolder)) + File.separator : String.valueOf(wrkStr) + File.separator;
        }
        wrkStr = element.getAttribute("LoggingSize");
        if (wrkStr.equals("")) {
            this.loggingSize = 3000;
        } else {
            try {
                this.loggingSize = Integer.parseInt(wrkStr);
            }
            catch (Exception e) {
                this.loggingSize = 3000;
            }
        }
        if (this.application != null) {
            this.application.setProgressValue(4);
        }
        this.userTable = element.getAttribute("UserTable");
        this.userFilterValueTable = element.getAttribute("UserFilterValueTable");
        this.variantsTable = element.getAttribute("VariantsTable");
        this.userVariantsTable = element.getAttribute("UserVariantsTable");
        this.numberingTable = element.getAttribute("NumberingTable");
        this.sessionTable = element.getAttribute("SessionTable");
        this.sessionDetailTable = element.getAttribute("SessionDetailTable");
        this.taxTable = element.getAttribute("TaxTable");
        this.calendarTable = element.getAttribute("CalendarTable");
        this.exchangeRateAnnualTable = element.getAttribute("ExchangeRateAnnualTable");
        this.exchangeRateMonthlyTable = element.getAttribute("ExchangeRateMonthlyTable");
        this.loginScript = XFUtility.substringLinesWithTokenOfEOL(element.getAttribute("LoginScript"), "\n");
        this.scriptFunctions = XFUtility.substringLinesWithTokenOfEOL(element.getAttribute("ScriptFunctions"), "\n");
        this.functionList = this.domDocument.getElementsByTagName("Function");
        this.tableList = this.domDocument.getElementsByTagName("Table");
        this.databaseName = element.getAttribute("DatabaseName");
        this.databaseName = this.databaseName.replace("<CURRENT>", this.currentFolder);
        this.databaseUser = element.getAttribute("DatabaseUser");
        this.databasePassword = element.getAttribute("DatabasePassword");
        NodeList subDBList = this.domDocument.getElementsByTagName("SubDB");
        int i = 0;
        while (i < subDBList.getLength()) {
            Element subDBElement = (Element)subDBList.item(i);
            this.subDBIDList.add(subDBElement.getAttribute("ID"));
            this.subDBUserList.add(subDBElement.getAttribute("User"));
            this.subDBPasswordList.add(subDBElement.getAttribute("Password"));
            wrkStr = subDBElement.getAttribute("Name");
            wrkStr = wrkStr.replace("<CURRENT>", this.currentFolder);
            this.subDBNameList.add(wrkStr);
            ++i;
        }
        if (!element.getAttribute("AppServerName").equals("")) {
            this.appServerName = element.getAttribute("AppServerName");
        }
        if (this.appServerName.equals("") && !(isOkay = this.setupConnectionToDatabase(true))) {
            return false;
        }
        this.smtpHost = element.getAttribute("SmtpHost");
        this.smtpPort = element.getAttribute("SmtpPort");
        this.smtpUser = element.getAttribute("SmtpUser");
        this.smtpPassword = element.getAttribute("SmtpPassword");
        this.smtpAdminEmail = element.getAttribute("SmtpAdminEmail");
        if (this.application != null) {
            this.application.setProgressValue(5);
        }
        this.proxyIP = element.getAttribute("ProxyIP");
        this.proxyPort = element.getAttribute("ProxyPort");
        NodeList printFontList = this.domDocument.getElementsByTagName("PrintFont");
        int i2 = 0;
        while (i2 < printFontList.getLength()) {
            BaseFont baseFont;
            Element fontElement = (Element)printFontList.item(i2);
            wrkStr = fontElement.getAttribute("ID");
            try {
                baseFont = BaseFont.createFont((String)fontElement.getAttribute("PDFFontName"), (String)fontElement.getAttribute("PDFEncoding"), (boolean)false);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError8")) + fontElement.getAttribute("FontName") + XFUtility.RESOURCE.getString("SessionError9"));
                baseFont = BaseFont.createFont((String)"Times-Roman", (String)"Cp1252", (boolean)false);
            }
            this.baseFontMap.put(wrkStr, baseFont);
            ++i2;
        }
        return true;
    }

    public boolean setupConnectionToDatabase(boolean isToStartSession) {
        try {
            XFUtility.loadDriverClass(this.databaseName);
            this.connectionManualCommit = DriverManager.getConnection(this.databaseName, this.databaseUser, this.databasePassword);
            this.connectionManualCommit.setAutoCommit(false);
            this.connectionAutoCommit = DriverManager.getConnection(this.databaseName, this.databaseUser, this.databasePassword);
            this.connectionAutoCommit.setAutoCommit(true);
        }
        catch (Exception e) {
            if (isToStartSession) {
                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("SessionError6"));
            }
            return false;
        }
        int countOfSubDBNotConnected = 0;
        Connection subDBConnection = null;
        this.subDBConnectionList.clear();
        int i = 0;
        while (i < this.subDBIDList.size()) {
            try {
                XFUtility.loadDriverClass(this.subDBNameList.get(i));
                subDBConnection = DriverManager.getConnection(this.subDBNameList.get(i), this.subDBUserList.get(i), this.subDBPasswordList.get(i));
                subDBConnection.setReadOnly(true);
                this.subDBConnectionList.add(subDBConnection);
            }
            catch (Exception e) {
                ++countOfSubDBNotConnected;
            }
            ++i;
        }
        if (isToStartSession) {
            if (countOfSubDBNotConnected == 1) {
                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("SessionError4"));
            }
            if (countOfSubDBNotConnected > 1) {
                JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("SessionError5"));
            }
        }
        return true;
    }

    private void writeLogAndStartSession() throws ScriptException, Exception {
        if (this.application != null) {
            this.application.setTextOnSplash(XFUtility.RESOURCE.getString("SplashMessage5"));
            this.application.setProgressMax(5);
            this.application.setProgressValue(1);
        }
        this.sessionID = this.getNextNumber("NRSESSION");
        this.sessionStatus = "ACT";
        if (this.application != null) {
            this.application.setProgressValue(2);
        }
        String sql = "insert into " + this.sessionTable + " (NRSESSION, IDUSER, DTLOGIN, TXIPADDRESS, VLVERSION, KBSESSIONSTATUS) values (" + "'" + this.sessionID + "'," + "'" + this.userID + "'," + "CURRENT_TIMESTAMP," + "'" + this.getIpAddress() + "','" + this.processorVersion + "','" + this.sessionStatus + "')";
        XFTableOperator operator = new XFTableOperator(this, null, sql, true);
        operator.execute();
        if (this.application != null) {
            this.application.setProgressValue(3);
        }
        operator = new XFTableOperator(this, null, "select * from " + this.calendarTable, true);
        while (operator.next()) {
            this.offDateList.add(String.valueOf(operator.getValueOf("KBCALENDAR").toString()) + ";" + operator.getValueOf("DTOFF").toString());
        }
        if (this.application != null) {
            this.application.setProgressValue(4);
        }
        this.functionLauncher = new FunctionLauncher(this);
        if (this.application != null) {
            this.application.setProgressValue(5);
        }
        this.globalScriptBindings = this.scriptEngineManager.getBindings();
        this.globalScriptBindings.put("session", (Object)this);
        this.scriptEngine = this.scriptEngineManager.getEngineByName("js");
        if (!this.loginScript.equals("")) {
            this.scriptEngine.eval(this.loginScript);
        }
    }

    private void setupMenusAndComponents() throws Exception {
        if (this.application != null) {
            if (this.specificFunctionID.equals("")) {
                this.application.setTextOnSplash(XFUtility.RESOURCE.getString("SplashMessage2"));
            }
            this.application.setProgressMax(5);
            this.application.setProgressValue(0);
        }
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.specificFunctionID.equals("")) {
            this.jTabbedPaneMenu.setFont(new Font(this.systemFont, 0, 20));
            this.jTabbedPaneMenu.setTabLayoutPolicy(1);
            this.jTabbedPaneMenu.addKeyListener(new Session_keyAdapter(this));
            this.jTabbedPaneMenu.requestFocus();
            this.jTabbedPaneMenu.addChangeListener(new Session_jTabbedPaneMenu_changeAdapter(this));
            this.jLabelUser.setFont(new Font(this.systemFont, 0, 18));
            this.jLabelSession.setFont(new Font(this.systemFont, 0, 18));
            this.jEditorPaneNews.setBorder(BorderFactory.createEtchedBorder());
            this.jEditorPaneNews.setFont(new Font(this.systemFont, 0, 18));
            this.jEditorPaneNews.setEditable(false);
            this.jEditorPaneNews.setContentType("text/html");
            this.jEditorPaneNews.addHyperlinkListener(new Session_jEditorPane_actionAdapter(this));
            this.jEditorPaneNews.setFocusable(false);
            this.editorKit.install(this.jEditorPaneNews);
            this.jEditorPaneNews.setEditorKit(this.editorKit);
            this.jScrollPaneNews.getViewport().add(this.jEditorPaneNews);
            boolean isValidURL = false;
            if (!this.welcomePageURL.equals("")) {
                try {
                    URLConnection connection = new URL(this.welcomePageURL).openConnection();
                    connection.connect();
                    isValidURL = true;
                }
                catch (Exception connection) {
                    // empty catch block
                }
            }
            if (isValidURL) {
                this.jEditorPaneNews.setPage(this.welcomePageURL);
            } else {
                String defaultImageFileName = "";
                defaultImageFileName = this.currentFolder.equals("") ? "WelcomePageDefaultImage.jpg" : String.valueOf(this.currentFolder) + File.separator + "WelcomePageDefaultImage.jpg";
                File imageFile = new File(defaultImageFileName);
                if (imageFile.exists()) {
                    BufferedImage image = ImageIO.read(imageFile);
                    if ((long)image.getWidth() > Math.round((double)this.screenSize.width * 0.8)) {
                        this.imageIcon = new ImageIcon(image);
                        JLabel labelImage = new JLabel("", this.imageIcon, 0);
                        this.jScrollPaneNews.getViewport().add(labelImage);
                    } else {
                        BufferedImage normalLightImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                        int y = 0;
                        while (y < image.getHeight()) {
                            int x = 0;
                            while (x < image.getWidth()) {
                                int rgb = image.getRGB(x, y);
                                Color c = new Color(rgb, true);
                                int a = c.getAlpha();
                                int r = (c.getRed() + 255) / 2;
                                int g = (c.getGreen() + 255) / 2;
                                int b = (c.getBlue() + 255) / 2;
                                normalLightImage.setRGB(x, y, new Color(r, g, b, a).getRGB());
                                ++x;
                            }
                            ++y;
                        }
                        int adjustedWidth = Math.round((float)this.screenSize.width * 0.98f);
                        int adjustedHeight = Math.round(image.getHeight() * adjustedWidth / image.getWidth());
                        BufferedImage extendedLightImage = new BufferedImage(adjustedWidth, adjustedHeight, 2);
                        extendedLightImage.getGraphics().drawImage(normalLightImage, 0, 0, adjustedWidth, adjustedHeight, this);
                        extendedLightImage.getGraphics().drawImage(image, (adjustedWidth - image.getWidth()) / 2, 0, image.getWidth(), image.getHeight(), this);
                        this.imageIcon = new ImageIcon(extendedLightImage);
                        JLabel jLabelImage = new JLabel("", this.imageIcon, 0);
                        this.jScrollPaneNews.getViewport().add(jLabelImage);
                    }
                } else if (this.welcomePageURL.equals("")) {
                    this.jEditorPaneNews.setText(XFUtility.RESOURCE.getString("SessionError10"));
                } else {
                    this.jEditorPaneNews.setText(String.valueOf(XFUtility.RESOURCE.getString("SessionError11")) + this.welcomePageURL + XFUtility.RESOURCE.getString("SessionError12"));
                }
            }
        }
        if (this.application != null) {
            this.application.setProgressValue(1);
        }
        if (this.specificFunctionID.equals("")) {
            this.jScrollPaneMenu.getViewport().add((Component)this.jPanelMenu, null);
            this.jPanelMenuTopMargin.setPreferredSize(new Dimension(20, 20));
            this.jPanelMenuTopMargin.setOpaque(false);
            this.jPanelMenuLeftMargin.setPreferredSize(new Dimension(80, 80));
            this.jPanelMenuLeftMargin.setOpaque(false);
            this.jPanelMenuRightMargin.setPreferredSize(new Dimension(80, 80));
            this.jPanelMenuRightMargin.setOpaque(false);
            this.jPanelMenuBottomMargin.setPreferredSize(new Dimension(20, 20));
            this.jPanelMenuBottomMargin.setOpaque(false);
            this.jPanelMenuCenter.setOpaque(false);
            this.jPanelMenu.setLayout(new BorderLayout());
            this.jPanelMenu.add((Component)this.jPanelMenuTopMargin, "North");
            this.jPanelMenu.add((Component)this.jPanelMenuLeftMargin, "West");
            this.jPanelMenu.add((Component)this.jPanelMenuRightMargin, "East");
            this.jPanelMenu.add((Component)this.jPanelMenuBottomMargin, "South");
            this.jPanelMenu.add((Component)this.jPanelMenuCenter, "Center");
            this.jPanelMenuCenter.setLayout(this.gridLayoutMenuButtons);
            this.gridLayoutMenuButtons.setColumns(2);
            this.gridLayoutMenuButtons.setRows(10);
            this.gridLayoutMenuButtons.setHgap(80);
            this.gridLayoutMenuButtons.setVgap(20);
            int i = 0;
            while (i < 20) {
                this.jButtonMenuOptionArray[i] = new JButton();
                this.jButtonMenuOptionArray[i].setFont(new Font(this.systemFont, 0, 20));
                this.jButtonMenuOptionArray[i].addActionListener(new Session_jButton_actionAdapter(this));
                this.jButtonMenuOptionArray[i].addKeyListener(new Session_keyAdapter(this));
                ++i;
            }
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[0]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[10]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[1]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[11]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[2]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[12]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[3]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[13]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[4]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[14]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[5]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[15]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[6]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[16]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[7]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[17]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[8]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[18]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[9]);
            this.jPanelMenuCenter.add(this.jButtonMenuOptionArray[19]);
        }
        if (this.application != null) {
            this.application.setProgressValue(2);
        }
        this.jPanelTop.setPreferredSize(new Dimension(10, 30));
        this.jPanelTop.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanelTop.setLayout(new BorderLayout());
        this.jPanelTop.add((Component)this.jLabelUser, "West");
        this.jPanelTop.add((Component)this.jLabelSession, "East");
        this.jScrollPaneMessages.setPreferredSize(new Dimension(10, 40));
        this.jScrollPaneMessages.getViewport().add((Component)this.jTextAreaMessages, null);
        this.jTextAreaMessages.setEditable(false);
        this.jTextAreaMessages.setBorder(BorderFactory.createEtchedBorder());
        this.jTextAreaMessages.setFont(new Font(this.systemFont, 0, 18));
        this.jTextAreaMessages.setFocusable(false);
        this.jTextAreaMessages.setLineWrap(true);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.add((Component)this.jScrollPaneNews, "top");
        this.jSplitPane2.add((Component)this.jTabbedPaneMenu, "bottom");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.add((Component)this.jSplitPane2, "top");
        this.jSplitPane1.add((Component)this.jScrollPaneMessages, "bottom");
        this.enableEvents(64L);
        this.setTitle(String.valueOf(this.systemName) + " " + this.systemVersion + " - " + this.sessionID);
        this.imageTitle = Toolkit.getDefaultToolkit().createImage(Session.class.getResource("title32.png"));
        this.setIconImage(this.imageTitle);
        int shorterWidth1 = Math.round((float)this.screenSize.width * 0.9f);
        int shorterHeight1 = Math.round(shorterWidth1 / 3 * 2);
        int shorterHeight2 = Math.round((float)this.screenSize.height * 0.9f);
        int shorterWidth2 = Math.round(shorterHeight2 / 2 * 3);
        if (shorterWidth2 <= shorterWidth1) {
            this.setPreferredSize(new Dimension(shorterWidth2, shorterHeight2));
            this.setLocation((this.screenSize.width - shorterWidth2) / 2, (this.screenSize.height - shorterHeight2) / 2);
        } else {
            this.setPreferredSize(new Dimension(shorterWidth1, shorterHeight1));
            this.setLocation((this.screenSize.width - shorterWidth1) / 2, (this.screenSize.height - shorterHeight1) / 2);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Session.this.jSplitPane2.setDividerLocation(Session.this.getHeight() / 5);
                Session.this.jSplitPane1.setDividerLocation(Session.this.getHeight() - Session.this.getHeight() / 7);
            }
        });
        if (this.specificFunctionID.equals("")) {
            this.getContentPane().setFocusable(false);
            this.getContentPane().add((Component)this.jPanelTop, "North");
            this.getContentPane().add((Component)this.jSplitPane1, "Center");
        }
        this.pack();
        this.validate();
        this.setExtendedState(6);
        if (this.application != null) {
            this.application.setProgressValue(3);
        }
        if (this.specificFunctionID.equals("")) {
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < 20) {
                    this.menuOptionArray[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.modifyPasswordDialog = new DialogModifyPassword(this);
        this.checkReadDialog = new DialogCheckRead(this);
        if (this.application != null) {
            this.application.setProgressValue(4);
        }
        if (this.specificFunctionID.equals("")) {
            this.jLabelUser.setText("User " + this.userName);
            if (this.userMenus.equals("ALL")) {
                this.jLabelSession.setText("<html><u><font color='blue'>Session " + this.sessionID);
                this.jLabelSession.addMouseListener(new Session_jLabelSession_mouseAdapter(this));
                this.buildMenuWithID("");
            } else {
                this.jLabelSession.setText("Session " + this.sessionID);
                StringTokenizer workTokenizer = new StringTokenizer(this.userMenus, ",");
                while (workTokenizer.hasMoreTokens()) {
                    this.buildMenuWithID(workTokenizer.nextToken());
                }
            }
            this.setupOptionsOfMenuWithTabNo(0);
        }
        if (this.application != null) {
            this.application.setProgressValue(5);
        }
        this.xfCalendar = new XFCalendar(this);
        int wrkCount = 0;
        Component module = null;
        if (this.loadingFunctionIDList.size() > 0) {
            wrkCount = 0;
            if (this.application != null) {
                this.application.setProgressMax(this.loadingFunctionIDList.size());
                this.application.setProgressValue(wrkCount);
                this.application.setTextOnSplash(XFUtility.RESOURCE.getString("SplashMessage4"));
            }
            int i = 0;
            while (i < this.functionList.getLength()) {
                Element element = (Element)this.functionList.item(i);
                if (this.loadingFunctionIDList.contains(element.getAttribute("ID"))) {
                    String functionType;
                    ++wrkCount;
                    if (this.application != null) {
                        this.application.setProgressValue(wrkCount);
                        this.application.repaintProgress();
                    }
                    if ((functionType = element.getAttribute("Type")).equals("XF000")) {
                        module = new XF000(this, -1);
                    }
                    if (functionType.equals("XF100")) {
                        module = new XF100(this, -1);
                    }
                    if (functionType.equals("XF110")) {
                        module = new XF110(this, -1);
                    }
                    if (functionType.equals("XF200")) {
                        module = new XF200(this, -1);
                    }
                    if (functionType.equals("XF290")) {
                        module = new XF290(this, -1);
                    }
                    if (functionType.equals("XF300")) {
                        module = new XF300(this, -1);
                    }
                    if (functionType.equals("XF310")) {
                        module = new XF310(this, -1);
                    }
                    if (functionType.equals("XF390")) {
                        module = new XF390(this, -1);
                    }
                    module.setFunctionSpecifications(element);
                    this.preloadedFunctionList.add((XFExecutable)((Object)module));
                }
                ++i;
            }
        }
    }

    public void setMessage(String text) {
        this.jTextAreaMessages.setText(text);
        this.jTextAreaMessages.setForeground(Color.blue);
        this.jTextAreaMessages.paintImmediately(0, 0, this.jTextAreaMessages.getWidth(), this.jTextAreaMessages.getHeight());
        this.jTextAreaMessages.setForeground(Color.black);
    }

    private String getIpAddress() {
        String value;
        block18: {
            HttpPost httpPost;
            block16: {
                value = "N/A";
                httpPost = null;
                DefaultHttpClient httpClient = null;
                try {
                    try {
                        InetAddress ip = InetAddress.getLocalHost();
                        value = ip.getHostAddress();
                        if (this.getAppServerName().equals("")) break block16;
                        httpPost = new HttpPost(this.getAppServerName());
                        ArrayList<BasicNameValuePair> objValuePairs = new ArrayList<BasicNameValuePair>(1);
                        objValuePairs.add(new BasicNameValuePair("METHOD", "IP"));
                        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                        try {
                            try {
                                httpClient = new DefaultHttpClient();
                                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                HttpEntity responseEntity = response.getEntity();
                                if (responseEntity != null) {
                                    value = String.valueOf(EntityUtils.toString((HttpEntity)responseEntity)) + " - " + ip.getHostAddress();
                                }
                            }
                            catch (Exception exception) {
                                if (httpClient != null) {
                                    httpClient.getConnectionManager().shutdown();
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (httpClient != null) {
                                httpClient.getConnectionManager().shutdown();
                            }
                            throw throwable;
                        }
                        if (httpClient != null) {
                            httpClient.getConnectionManager().shutdown();
                        }
                    }
                    catch (Exception ip) {
                        if (httpPost != null) {
                            httpPost.abort();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (httpPost != null) {
                        httpPost.abort();
                    }
                    throw throwable;
                }
            }
            if (httpPost != null) {
                httpPost.abort();
            }
        }
        Element ipAddressField = this.getFieldElement(this.sessionTable, "TXIPADDRESS");
        int ipAddressSize = Integer.parseInt(ipAddressField.getAttribute("Size"));
        if (value.length() > ipAddressSize) {
            value = value.substring(0, ipAddressSize);
        }
        return value;
    }

    void jLabelSession_mouseClicked(MouseEvent e) {
        try {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("NRSESSION", this.sessionID);
            this.functionLauncher.execute("ZF051", parmMap);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, "Unable to call the function ZF051.");
        }
    }

    void jLabelSession_mouseEntered(MouseEvent e) {
        this.setCursor(this.editorKit.getLinkCursor());
    }

    void jLabelSession_mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public BaseFont getBaseFontWithID(String id) {
        return this.baseFontMap.get(id);
    }

    public XFExecutable getPreloadedFunction(String id) {
        XFExecutable preloadedFunction = null;
        int i = 0;
        while (i < this.preloadedFunctionList.size()) {
            if (this.preloadedFunctionList.get(i).getFunctionID().equals(id)) {
                preloadedFunction = this.preloadedFunctionList.get(i);
            }
            ++i;
        }
        return preloadedFunction;
    }

    public Date getDateOnCalendar(Date date, String kbCalendar, Point position) {
        return this.xfCalendar.getDateOnCalendar(date, kbCalendar, position);
    }

    private void buildMenuWithID(String id) {
        int optionNo = 0;
        NodeList optionList = null;
        Element menuElement = null;
        Element optionElement = null;
        Element workElement = null;
        NodeList menuList = this.domDocument.getElementsByTagName("Menu");
        this.sortingList = XFUtility.getSortedListModel(menuList, "ID");
        int i = 0;
        while (i < this.sortingList.getSize()) {
            menuElement = (Element)this.sortingList.getElementAt(i);
            if (menuElement.getAttribute("ID").equals(id) || id.equals("")) {
                if (this.jTabbedPaneMenu.getTabCount() == 0) {
                    this.jTabbedPaneMenu.addTab(menuElement.getAttribute("Name"), null, this.jScrollPaneMenu);
                } else {
                    this.jTabbedPaneMenu.addTab(menuElement.getAttribute("Name"), null, null);
                }
                int menuIndex = this.jTabbedPaneMenu.getTabCount() - 1;
                this.menuIDArray[menuIndex] = menuElement.getAttribute("ID");
                this.menuCaptionArray[menuIndex] = menuElement.getAttribute("Name");
                this.helpURLArray[menuIndex] = menuElement.getAttribute("HelpURL");
                if (!this.skipPreload) {
                    StringTokenizer tokenizer = new StringTokenizer(menuElement.getAttribute("FunctionsToBeLoaded"), ";");
                    while (tokenizer.hasMoreTokens()) {
                        String wrkStr = tokenizer.nextToken();
                        if (this.loadingFunctionIDList.contains(wrkStr)) continue;
                        this.loadingFunctionIDList.add(wrkStr);
                    }
                }
                optionList = menuElement.getElementsByTagName("Option");
                int j = 0;
                while (j < optionList.getLength()) {
                    optionElement = (Element)optionList.item(j);
                    optionNo = Integer.parseInt(optionElement.getAttribute("Index"));
                    Element functionElement = null;
                    int k = 0;
                    while (k < this.functionList.getLength()) {
                        workElement = (Element)this.functionList.item(k);
                        if (workElement.getAttribute("ID").equals(optionElement.getAttribute("FunctionID"))) {
                            functionElement = workElement;
                            break;
                        }
                        ++k;
                    }
                    this.menuOptionArray[menuIndex][optionNo] = new MenuOption(functionElement, optionElement.getAttribute("OptionName"));
                    ++j;
                }
                this.menuOptionArray[menuIndex][19] = new MenuOption(null, "LOGOUT");
                if (!id.equals("")) break;
            }
            ++i;
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public String showDialogToChooseFile(String fileExtention) {
        return this.showDialogToChooseFile(fileExtention, "", "");
    }

    public String showDialogToChooseFile(String fileExtention, String defaultDirectory) {
        return this.showDialogToChooseFile(fileExtention, defaultDirectory, "");
    }

    public String showDialogToChooseFile(String fileExtention, String directory, String defaultFile) {
        String name = "";
        if (directory.equals("")) {
            directory = this.currentFolder;
        } else if (directory.contains("<CURRENT>")) {
            directory = directory.replace("<CURRENT>", this.currentFolder);
        }
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac") && !fileExtention.contains(",")) {
            this.fileDialog.setTitle(XFUtility.RESOURCE.getString("SelectFileTitle"));
            name = defaultFile.equals("") ? String.valueOf(directory) + File.separator + "*." + fileExtention : (defaultFile.endsWith("." + fileExtention) ? String.valueOf(directory) + File.separator + defaultFile : String.valueOf(directory) + File.separator + defaultFile + "." + fileExtention);
            this.fileDialog.setFile(name);
            this.fileDialog.setVisible(true);
            String dir = this.fileDialog.getDirectory();
            String fileName = this.fileDialog.getFile();
            name = dir != null && fileName != null ? String.valueOf(dir) + File.separator + fileName : "";
        } else {
            int reply;
            this.jFileChooser.setDialogTitle(XFUtility.RESOURCE.getString("SelectFileTitle"));
            this.jFileChooser.setCurrentDirectory(new File(directory));
            if (!defaultFile.equals("")) {
                this.jFileChooser.setSelectedFile(new File(directory, defaultFile));
            }
            this.jFileChooser.resetChoosableFileFilters();
            ArrayList<String> extentionList = new ArrayList<String>();
            if (!fileExtention.equals("")) {
                StringTokenizer workTokenizer = new StringTokenizer(fileExtention, ",");
                while (workTokenizer.hasMoreTokens()) {
                    String extention = workTokenizer.nextToken();
                    extentionList.add(extention);
                    this.jFileChooser.setFileFilter(new FileNameExtensionFilter(extention, extention));
                }
            }
            if ((reply = this.jFileChooser.showOpenDialog(this)) == 0) {
                File file = new File(this.jFileChooser.getSelectedFile().getPath());
                if (Session.getExtention(file) == null) {
                    int j = 0;
                    while (j < extentionList.size()) {
                        file = new File(String.valueOf(this.jFileChooser.getSelectedFile().getPath()) + "." + (String)extentionList.get(j));
                        if (file.exists()) {
                            name = file.getPath();
                            break;
                        }
                        ++j;
                    }
                    if (name.equals("")) {
                        JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("SelectFileMessage1"));
                    }
                } else {
                    int j = 0;
                    while (j < extentionList.size()) {
                        if (Session.getExtention(file).equals(extentionList.get(j))) {
                            name = file.getPath();
                            break;
                        }
                        ++j;
                    }
                    if (name.equals("")) {
                        JOptionPane.showMessageDialog(this, XFUtility.RESOURCE.getString("SelectFileMessage2"));
                    }
                }
            }
        }
        return name;
    }

    static String getExtention(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        if (i > 0 && i < name.length() - 1) {
            return name.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public XFOptionDialog getOptionDialog() {
        return new XFOptionDialog(this);
    }

    public XFInputDialog getInputDialog() {
        if (this.inputDialog.isVisible()) {
            return new XFInputDialog(this);
        }
        this.inputDialog.clear();
        return this.inputDialog;
    }

    public XFCheckListDialog getCheckListDialog() {
        return this.checkListDialog;
    }

    public XFLongTextEditor getLongTextEditor() {
        return this.xfLongTextEditor;
    }

    public String getCurrentMenuID() {
        return this.menuIDArray[this.jTabbedPaneMenu.getSelectedIndex()];
    }

    /*
     * Loose catch block
     */
    public void browseHelp() {
        if (this.helpURLArray[this.jTabbedPaneMenu.getSelectedIndex()].equals("")) {
            JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError16")) + this.menuCaptionArray[this.jTabbedPaneMenu.getSelectedIndex()] + XFUtility.RESOURCE.getString("SessionError17"));
        } else {
            try {
                try {
                    this.setCursor(new Cursor(3));
                    this.desktop.browse(new URI(this.helpURLArray[this.jTabbedPaneMenu.getSelectedIndex()]));
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError18")) + this.menuCaptionArray[this.jTabbedPaneMenu.getSelectedIndex()] + XFUtility.RESOURCE.getString("SessionError19") + ex.getMessage());
                    this.setCursor(new Cursor(0));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError18")) + this.menuCaptionArray[this.jTabbedPaneMenu.getSelectedIndex()] + XFUtility.RESOURCE.getString("SessionError19") + ex.getMessage());
                    this.setCursor(new Cursor(0));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError18")) + this.menuCaptionArray[this.jTabbedPaneMenu.getSelectedIndex()] + XFUtility.RESOURCE.getString("SessionError19") + ex.getMessage());
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    this.setCursor(new Cursor(0));
                }
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
    }

    void setupOptionsOfMenuWithTabNo(int tabNumber) {
        if (tabNumber > -1) {
            this.menuIDUsing = this.menuIDArray[tabNumber];
            this.jTabbedPaneMenu.requestFocus();
            int i = 0;
            while (i < 20) {
                if (this.menuOptionArray[tabNumber][i] == null) {
                    this.jButtonMenuOptionArray[i].setVisible(false);
                } else {
                    this.jButtonMenuOptionArray[i].setText(this.menuOptionArray[tabNumber][i].getMenuOptionName());
                    this.jButtonMenuOptionArray[i].setVisible(true);
                }
                ++i;
            }
            if (this.helpURLArray[tabNumber] != null) {
                if (this.helpURLArray[tabNumber].equals("")) {
                    this.jTextAreaMessages.setText(XFUtility.RESOURCE.getString("SessionMessage1"));
                } else {
                    this.jTextAreaMessages.setText(XFUtility.RESOURCE.getString("SessionMessage2"));
                }
            }
        }
    }

    public String getTimeStamp() {
        return XFUtility.getUserExpressionOfUtilDate(null, "", true);
    }

    public String getToday() {
        return this.getToday("");
    }

    public String getToday(String dateFormat) {
        return XFUtility.getUserExpressionOfUtilDate(null, dateFormat, false);
    }

    public String getTodayTime(String dateFormat) {
        return XFUtility.getUserExpressionOfUtilDate(null, dateFormat, true);
    }

    public String getThisMonth() {
        SimpleDateFormat dfm = new SimpleDateFormat("yyyyMM");
        Calendar cal = Calendar.getInstance();
        return dfm.format(cal.getTime());
    }

    public String getErrorOfAccountDate(String dateValue) {
        String message = "";
        try {
            int yyyyMSeq = this.getSystemVariantInteger("ALLOWED_FISCAL_MONTH");
            if (yyyyMSeq > 200000 && yyyyMSeq < 210000) {
                int mSeq;
                int yyyy;
                int yyyyMSeqTarget;
                String date = dateValue.replace("/", "");
                if ((date = date.replace("-", "")).length() >= 8 && (yyyyMSeqTarget = (yyyy = this.getFYearOfDate(date = date.substring(0, 8))) * 100 + (mSeq = this.getMSeqOfDate(dateValue))) < yyyyMSeq) {
                    message = XFUtility.RESOURCE.getString("FunctionError49");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return message;
    }

    public String formatTime(int timeFrom) {
        if (timeFrom > 9999) {
            JOptionPane.showMessageDialog(null, "Invalid time value.");
            return null;
        }
        return this.formatTime(Integer.toString(timeFrom));
    }

    public String formatTime(String timeFrom) {
        if (timeFrom.contains(":")) {
            return timeFrom;
        }
        if (timeFrom.length() > 4) {
            JOptionPane.showMessageDialog(null, "Invalid time value.");
            return null;
        }
        String wrkStr = "00:00";
        if (timeFrom.length() == 1) {
            wrkStr = "00:0" + timeFrom;
        }
        if (timeFrom.length() == 2) {
            wrkStr = "00:" + timeFrom;
        }
        if (timeFrom.length() == 3) {
            wrkStr = "0" + timeFrom.substring(0, 1) + ":" + timeFrom.substring(1, 3);
        }
        if (timeFrom.length() == 4) {
            wrkStr = String.valueOf(timeFrom.substring(0, 2)) + ":" + timeFrom.substring(2, 4);
        }
        return wrkStr;
    }

    public String getOffsetTime(int timeFrom, int minutes) {
        if (timeFrom > 9999) {
            JOptionPane.showMessageDialog(null, "Invalid time format.");
            return null;
        }
        String strTimeFrom = Integer.toString(timeFrom);
        if (strTimeFrom.length() == 1) {
            strTimeFrom = "00:0" + strTimeFrom;
        }
        if (strTimeFrom.length() == 2) {
            strTimeFrom = "00:" + strTimeFrom;
        }
        if (strTimeFrom.length() == 3) {
            strTimeFrom = "0" + strTimeFrom.substring(0, 1) + ":" + strTimeFrom.substring(1, 3);
        }
        if (strTimeFrom.length() == 4) {
            strTimeFrom = String.valueOf(strTimeFrom.substring(0, 2)) + ":" + strTimeFrom.substring(2, 4);
        }
        return this.getOffsetTime(strTimeFrom, minutes);
    }

    private String getOffsetTime(String hhmmFrom, int minutes) {
        if (!hhmmFrom.contains(":")) {
            if (hhmmFrom.length() == 1) {
                hhmmFrom = "00:0" + hhmmFrom;
            }
            if (hhmmFrom.length() == 2) {
                hhmmFrom = "00:" + hhmmFrom;
            }
            if (hhmmFrom.length() == 3) {
                hhmmFrom = "0" + hhmmFrom.substring(0, 1) + ":" + hhmmFrom.substring(1, 3);
            }
            if (hhmmFrom.length() == 4) {
                hhmmFrom = String.valueOf(hhmmFrom.substring(0, 2)) + ":" + hhmmFrom.substring(2, 4);
            }
        }
        double days = 0.0;
        double hh = Double.parseDouble(hhmmFrom.substring(0, 2));
        double mm = Double.parseDouble(hhmmFrom.substring(3, 5)) + (double)minutes;
        if (mm >= 60.0) {
            hh += Math.floor(mm / 60.0);
            mm %= 60.0;
        }
        if (mm <= -60.0) {
            hh += Math.ceil(mm / 60.0);
            mm %= 60.0;
        }
        if (mm < 0.0) {
            hh -= 1.0;
            mm += 60.0;
        }
        mm = Math.abs(mm);
        if (hh >= 24.0) {
            days = Math.floor(hh / 24.0);
            hh %= 24.0;
        }
        if (hh <= -24.0) {
            days = Math.ceil(hh / 24.0);
            hh %= 24.0;
        }
        if (hh < 0.0) {
            days -= 1.0;
            hh += 24.0;
        }
        hh = Math.abs(hh);
        String strDays = Double.toString(days).replace(".0", "");
        String strHH = Double.toString(hh).replace(".0", "");
        if (hh < 10.0) {
            strHH = "0" + strHH;
        }
        String strMM = Double.toString(mm).replace(".0", "");
        if (mm < 10.0) {
            strMM = "0" + strMM;
        }
        return String.valueOf(strDays) + ":" + strHH + ":" + strMM;
    }

    public String getOffsetDateTime(String dateFrom, int timeFrom, int minutes) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, 0, "00");
    }

    public String getOffsetDateTime(String dateFrom, int timeFrom, int minutes, int countType) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, countType, "00");
    }

    public String getOffsetDateTime(String dateFrom, int timeFrom, int minutes, int countType, String kbCalendar) {
        if (timeFrom > 9999) {
            JOptionPane.showMessageDialog(null, "Invalid time format.");
            return null;
        }
        String strTimeFrom = Integer.toString(timeFrom);
        if (strTimeFrom.length() == 1) {
            strTimeFrom = "00:0" + strTimeFrom;
        }
        if (strTimeFrom.length() == 2) {
            strTimeFrom = "00:" + strTimeFrom;
        }
        if (strTimeFrom.length() == 3) {
            strTimeFrom = "0" + strTimeFrom.substring(0, 1) + ":" + strTimeFrom.substring(1, 3);
        }
        if (strTimeFrom.length() == 4) {
            strTimeFrom = String.valueOf(strTimeFrom.substring(0, 2)) + ":" + strTimeFrom.substring(2, 4);
        }
        return this.getOffsetDateTime(dateFrom, strTimeFrom, minutes, countType, kbCalendar);
    }

    public String getOffsetDateTime(String dateFrom, String timeFrom, int minutes, int countType) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, countType, "00");
    }

    public String getOffsetDateTime(String dateFrom, String timeFrom, int minutes) {
        return this.getOffsetDateTime(dateFrom, timeFrom, minutes, 0, "00");
    }

    public String getOffsetDateTime(String dateFrom, String timeFrom, int minutes, int countType, String kbCalendar) {
        if (!timeFrom.contains(":")) {
            if (timeFrom.length() == 1) {
                timeFrom = "00:0" + timeFrom;
            }
            if (timeFrom.length() == 2) {
                timeFrom = "00:" + timeFrom;
            }
            if (timeFrom.length() == 3) {
                timeFrom = "0" + timeFrom.substring(0, 1) + ":" + timeFrom.substring(1, 3);
            }
            if (timeFrom.length() == 4) {
                timeFrom = String.valueOf(timeFrom.substring(0, 2)) + ":" + timeFrom.substring(2, 4);
            }
        }
        String dateTime = "";
        String daysHhMm = this.getOffsetTime(timeFrom, minutes);
        StringTokenizer workTokenizer = new StringTokenizer(daysHhMm, ":");
        try {
            int days = Integer.parseInt(workTokenizer.nextToken());
            String date = this.getOffsetDate(dateFrom, days, countType);
            String hh = workTokenizer.nextToken();
            String mm = workTokenizer.nextToken();
            dateTime = String.valueOf(date) + " " + hh + ":" + mm;
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Failed to get offset date-time.\n" + e.getMessage());
        }
        return dateTime;
    }

    public String getOffsetDate(String dateFrom, int days, int countType) {
        return this.getOffsetDate(dateFrom, days, countType, "00");
    }

    public String getOffsetDate(String dateFrom, int days, int countType, String kbCalendar) {
        Date workDate;
        String offsetDate = "";
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        dateFrom = dateFrom.replaceAll("-", "").replaceAll("/", "").trim();
        int y = Integer.parseInt(dateFrom.substring(0, 4));
        int m = Integer.parseInt(dateFrom.substring(4, 6));
        int d = Integer.parseInt(dateFrom.substring(6, 8));
        Calendar cal = Calendar.getInstance();
        cal.set(y, m - 1, d);
        if (countType == 0) {
            cal.add(5, days);
        }
        if (countType == 1) {
            if (days >= 0) {
                int i = 0;
                while (i < days) {
                    cal.add(5, 1);
                    workDate = cal.getTime();
                    if (this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(workDate))) {
                        ++days;
                    }
                    ++i;
                }
            } else {
                days *= -1;
                int i = 0;
                while (i < days) {
                    cal.add(5, -1);
                    workDate = cal.getTime();
                    if (this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(workDate))) {
                        ++days;
                    }
                    ++i;
                }
            }
        }
        workDate = cal.getTime();
        offsetDate = dfm.format(workDate);
        return offsetDate;
    }

    public String getOffsetYearMonth(String yearMonthFrom, int months) {
        String offsetYearMonth = "";
        try {
            int year = Integer.parseInt(yearMonthFrom.substring(0, 4));
            int month = Integer.parseInt(yearMonthFrom.substring(4, 6));
            if (months > 0) {
                int i = 0;
                while (i < months) {
                    if (++month > 12) {
                        month = 1;
                        ++year;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i > months) {
                    if (--month < 1) {
                        month = 12;
                        --year;
                    }
                    --i;
                }
            }
            offsetYearMonth = month >= 10 ? String.valueOf(Integer.toString(year)) + Integer.toString(month) : String.valueOf(Integer.toString(year)) + "0" + Integer.toString(month);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return offsetYearMonth;
    }

    public String getLastDateOfTheYearMonth(String yearMonth) {
        String date = "";
        try {
            String processedYearMonth = yearMonth.replaceAll("-", "").replaceAll("/", "").trim();
            processedYearMonth = processedYearMonth.substring(0, 6);
            int y = Integer.parseInt(processedYearMonth.substring(0, 4));
            int m = Integer.parseInt(processedYearMonth.substring(4, 6));
            SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.set(y, m, 1, 0, 0, 0);
            cal.add(5, -1);
            date = dfm.format(cal.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public int getDaysBetweenDates(String strDateFrom, String strDateThru, int countType) {
        return this.getDaysBetweenDates(strDateFrom, strDateThru, countType, "00");
    }

    public int getDaysBetweenDates(String strDateFrom, String strDateThru, int countType, String kbCalendar) {
        int days = 0;
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        strDateFrom = strDateFrom.replaceAll("-", "").replaceAll("/", "").trim();
        int y = Integer.parseInt(strDateFrom.substring(0, 4));
        int m = Integer.parseInt(strDateFrom.substring(4, 6));
        int d = Integer.parseInt(strDateFrom.substring(6, 8));
        cal.set(y, m - 1, d, 0, 0, 0);
        Date dateFrom = cal.getTime();
        strDateThru = strDateThru.replaceAll("-", "").replaceAll("/", "").trim();
        y = Integer.parseInt(strDateThru.substring(0, 4));
        m = Integer.parseInt(strDateThru.substring(4, 6));
        d = Integer.parseInt(strDateThru.substring(6, 8));
        cal.set(y, m - 1, d, 0, 0, 0);
        Date dateThru = cal.getTime();
        if (countType == 0) {
            long diff = dateThru.getTime() - dateFrom.getTime();
            days = (int)(diff / 86400000L);
        }
        if (countType == 1) {
            if (dateThru.getTime() == dateFrom.getTime()) {
                days = 0;
            }
            if (dateThru.getTime() > dateFrom.getTime()) {
                y = Integer.parseInt(strDateFrom.substring(0, 4));
                m = Integer.parseInt(strDateFrom.substring(4, 6));
                d = Integer.parseInt(strDateFrom.substring(6, 8));
                cal.set(y, m - 1, d, 0, 0, 0);
                long timeThru = dateThru.getTime();
                long timeWork = dateFrom.getTime();
                while (timeThru > timeWork) {
                    cal.add(5, 1);
                    if (!this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(cal.getTime()))) {
                        ++days;
                    }
                    timeWork = cal.getTime().getTime();
                }
            }
            if (dateThru.getTime() < dateFrom.getTime()) {
                y = Integer.parseInt(strDateThru.substring(0, 4));
                m = Integer.parseInt(strDateThru.substring(4, 6));
                d = Integer.parseInt(strDateThru.substring(6, 8));
                cal.set(y, m - 1, d, 0, 0, 0);
                long timeWork = dateThru.getTime();
                long timeFrom = dateFrom.getTime();
                while (timeFrom > timeWork) {
                    cal.add(5, 1);
                    if (!this.offDateList.contains(String.valueOf(kbCalendar) + ";" + dfm.format(cal.getTime()))) {
                        ++days;
                    }
                    timeWork = cal.getTime().getTime();
                }
                days *= -1;
            }
        }
        return days;
    }

    public int getMonthsBetweenYearMonths(String strYearMonthFrom, String strYearMonthThru) {
        int months = 0;
        try {
            int yearFrom = Integer.parseInt(strYearMonthFrom.substring(0, 4));
            int monthFrom = Integer.parseInt(strYearMonthFrom.substring(4, 6));
            int yearThru = Integer.parseInt(strYearMonthThru.substring(0, 4));
            int monthThru = Integer.parseInt(strYearMonthThru.substring(4, 6));
            if (monthFrom > monthThru) {
                --yearFrom;
                monthFrom += 12;
            }
            months = (yearThru - yearFrom) * 12;
            months = months + monthThru - monthFrom;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return months;
    }

    public boolean isValidDate(String date) {
        boolean result = true;
        String argDate = date.replaceAll("[^0-9]", "").trim();
        try {
            int y = Integer.parseInt(argDate.substring(0, 4));
            int m = Integer.parseInt(argDate.substring(4, 6));
            int d = Integer.parseInt(argDate.substring(6, 8));
            this.calendar.set(y, m - 1, d);
            this.calendar.getTime();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean isValidDateFormat(String date, String separator) {
        boolean result = false;
        if (this.isValidDate(date) && date.length() == 10 && date.substring(4, 5).equals(separator) && date.substring(7, 8).equals(separator)) {
            result = true;
        }
        return result;
    }

    public boolean isOffDate(String date) {
        return this.isOffDate(date, "00");
    }

    public boolean isOffDate(String date, String kbCalendar) {
        return this.offDateList.contains(String.valueOf(kbCalendar) + ";" + date);
    }

    public boolean isClientSession() {
        return this.isClientSession;
    }

    public boolean isValidTime(String time, String format) {
        boolean result = false;
        try {
            int min;
            int hour;
            if (format.toUpperCase().equals("HH:MM") && time.length() == 5 && time.substring(2, 3).equals(":")) {
                hour = Integer.parseInt(time.substring(0, 2));
                min = Integer.parseInt(time.substring(3, 5));
                if (hour >= 0 && hour < 24 && min >= 0 && min < 60) {
                    result = true;
                }
            }
            if (format.toUpperCase().equals("HH:MM:SS") && time.length() >= 7 && time.length() <= 12 && time.substring(2, 3).equals(":") && time.substring(5, 6).equals(":")) {
                hour = Integer.parseInt(time.substring(0, 2));
                min = Integer.parseInt(time.substring(3, 5));
                float sec = Float.parseFloat(time.substring(6, time.length()));
                if (hour >= 0 && hour < 24 && min >= 0 && min < 60 && sec >= 0.0f && sec < 60.0f) {
                    result = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Object getMinutesBetweenTimes(int timeFrom, int timeThru) {
        String strTimeThru;
        if (timeFrom > 9999 || timeThru > 9999) {
            JOptionPane.showMessageDialog(null, "Invalid time format.");
            return null;
        }
        String strTimeFrom = Integer.toString(timeFrom);
        if (strTimeFrom.length() == 1) {
            strTimeFrom = "00:0" + strTimeFrom;
        }
        if (strTimeFrom.length() == 2) {
            strTimeFrom = "00:" + strTimeFrom;
        }
        if (strTimeFrom.length() == 3) {
            strTimeFrom = "0" + strTimeFrom.substring(0, 1) + ":" + strTimeFrom.substring(1, 3);
        }
        if (strTimeFrom.length() == 4) {
            strTimeFrom = String.valueOf(strTimeFrom.substring(0, 2)) + ":" + strTimeFrom.substring(2, 4);
        }
        if ((strTimeThru = Integer.toString(timeThru)).length() == 1) {
            strTimeThru = "00:0" + strTimeThru;
        }
        if (strTimeThru.length() == 2) {
            strTimeThru = "00:" + strTimeThru;
        }
        if (strTimeThru.length() == 3) {
            strTimeThru = "0" + strTimeThru.substring(0, 1) + ":" + strTimeThru.substring(1, 3);
        }
        if (strTimeThru.length() == 4) {
            strTimeThru = String.valueOf(strTimeThru.substring(0, 2)) + ":" + strTimeThru.substring(2, 4);
        }
        return this.getMinutesBetweenTimes(strTimeFrom, strTimeThru);
    }

    public Object getMinutesBetweenTimes(String timeFrom, String timeThru) {
        int minDiff;
        block3: {
            minDiff = 0;
            try {
                if (timeFrom.substring(2, 3).equals(":") && timeThru.substring(2, 3).equals(":")) {
                    int hourFrom = Integer.parseInt(timeFrom.substring(0, 2));
                    int minFrom = Integer.parseInt(timeFrom.substring(3, 5));
                    int hourThru = Integer.parseInt(timeThru.substring(0, 2));
                    int minThru = Integer.parseInt(timeThru.substring(3, 5));
                    minDiff = (hourThru - hourFrom) * 60 + (minThru - minFrom);
                    break block3;
                }
                JOptionPane.showMessageDialog(null, "Invalid time format.");
                return null;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Invalid time format.\n" + e.getMessage());
                return null;
            }
        }
        return minDiff;
    }

    public String getNextNumber(String numberID) {
        String nextNumber = "";
        try {
            String sql = "select * from " + this.numberingTable + " where IDNUMBER = '" + numberID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                nextNumber = this.getFormattedNextNumber(Integer.parseInt(operator.getValueOf("NRCURRENT").toString()), Integer.parseInt(operator.getValueOf("NRNUMDIGIT").toString()), operator.getValueOf("TXPREFIX").toString().trim(), operator.getValueOf("FGWITHCD").toString());
                int number = this.countUpNumber(Integer.parseInt(operator.getValueOf("NRCURRENT").toString()), Integer.parseInt(operator.getValueOf("NRNUMDIGIT").toString()));
                sql = "update " + this.numberingTable + " set NRCURRENT = " + number + ", UPDCOUNTER = " + (Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString()) + 1) + " where IDNUMBER = '" + numberID + "'" + " and UPDCOUNTER = " + Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            } else {
                JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError13")) + numberID + XFUtility.RESOURCE.getString("SessionError14"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nextNumber;
    }

    public void setNextNumber(String numberID, int nextNumber) {
        try {
            String sql = "select * from " + this.numberingTable + " where IDNUMBER = '" + numberID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                sql = "update " + this.numberingTable + " set NRCURRENT = " + nextNumber + ", UPDCOUNTER = " + (Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString()) + 1) + " where IDNUMBER = '" + numberID + "'" + " and UPDCOUNTER = " + Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            } else {
                JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError13")) + numberID + XFUtility.RESOURCE.getString("SessionError14"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFormattedNextNumber(int number, int digit, String prefix, String withCD) {
        String nextNumber = "";
        DecimalFormat decimalFormat = new DecimalFormat();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < digit) {
            buf.append("0");
            ++i;
        }
        decimalFormat.applyPattern(buf.toString());
        String outputdata = decimalFormat.format(number);
        if (withCD.equals("T")) {
            int wrkInt;
            int wrkSum = 0;
            int i2 = 0;
            while (i2 < outputdata.length()) {
                String wrkStr = outputdata.substring(i2, i2 + 1);
                wrkInt = Integer.parseInt(wrkStr);
                if (wrkInt % 2 == 1) {
                    wrkInt *= 3;
                }
                wrkSum += wrkInt;
                ++i2;
            }
            wrkInt = wrkSum % 10;
            wrkInt = 10 - wrkInt;
            nextNumber = String.valueOf(prefix) + outputdata + wrkInt;
        } else {
            nextNumber = String.valueOf(prefix) + outputdata;
        }
        return nextNumber;
    }

    private int countUpNumber(int number, int digit) {
        if (digit == 1 && ++number == 10) {
            number = 1;
        }
        if (digit == 2 && number == 100) {
            number = 1;
        }
        if (digit == 3 && number == 1000) {
            number = 1;
        }
        if (digit == 4 && number == 10000) {
            number = 1;
        }
        if (digit == 5 && number == 100000) {
            number = 1;
        }
        if (digit == 6 && number == 1000000) {
            number = 1;
        }
        if (digit == 7 && number == 10000000) {
            number = 1;
        }
        if (digit == 8 && number == 100000000) {
            number = 1;
        }
        if (digit == 9 && number == 1000000000) {
            number = 1;
        }
        return number;
    }

    public String getSystemVariantString(String itemID) {
        String strValue = "";
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next() && (strValue = operator.getValueOf("TXVALUE").toString().trim()).contains("<CURRENT>")) {
                strValue = strValue.replace("<CURRENT>", this.currentFolder);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Accessing to the system variant table failed.\n" + e.getMessage());
        }
        return strValue;
    }

    public int getSystemVariantInteger(String itemID) {
        String strValue = "";
        int intValue = 0;
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                strValue = operator.getValueOf("TXVALUE").toString().trim();
                if (operator.getValueOf("TXTYPE").toString().trim().equals("NUMBER")) {
                    intValue = Integer.parseInt(strValue);
                } else {
                    JOptionPane.showMessageDialog(null, "Value of system Variant with ID '" + itemID + "' is not number.");
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Accessing to the system variant table failed.\n" + e.getMessage());
        }
        return intValue;
    }

    public float getSystemVariantFloat(String itemID) {
        String strValue = "";
        float floatValue = 0.0f;
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                strValue = operator.getValueOf("TXVALUE").toString().trim();
                if (operator.getValueOf("TXTYPE").toString().trim().equals("NUMBER")) {
                    floatValue = Float.parseFloat(strValue);
                } else {
                    JOptionPane.showMessageDialog(null, "Value of system Variant with ID '" + itemID + "' is not number.");
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Accessing to the system variant table failed.\n" + e.getMessage());
        }
        return floatValue;
    }

    public void setSystemVariant(String itemID, String value) {
        try {
            String sql = "select * from " + this.variantsTable + " where IDVARIANT = '" + itemID + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                sql = "update " + this.variantsTable + " set TXVALUE = '" + value + "'" + ", UPDCOUNTER = " + (Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString()) + 1) + " where IDVARIANT = '" + itemID + "'" + " and UPDCOUNTER = " + Integer.parseInt(operator.getValueOf("UPDCOUNTER").toString());
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            } else {
                sql = "insert into " + this.variantsTable + " (IDVARIANT, TXNAME, TXTYPE, TXVALUE) values (" + "'" + itemID + "', '" + itemID.substring(0, 10) + "', 'STRING', '" + value + "')";
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Accessing to the system variant table failed.\n" + e.getMessage());
        }
    }

    public String getUserVariantDescription(String variantID, String value) {
        String strValue = "";
        try {
            String sql = "select * from " + this.userVariantsTable + " where IDUSERKUBUN = '" + variantID + "' and KBUSERKUBUN = '" + value + "'";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            if (operator.next()) {
                strValue = operator.getValueOf("TXUSERKUBUN").toString().trim();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Accessing to the user variant table failed.\n" + e.getMessage());
        }
        return strValue;
    }

    public HashMap getFilterValueMap(String functionID) {
        HashMap<String, String> valueMap = null;
        if (!this.userFilterValueTable.equals("")) {
            try {
                valueMap = new HashMap<String, String>();
                String sql = "select * from " + this.userFilterValueTable + " where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "'";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                while (operator.next()) {
                    valueMap.put(operator.getValueOf("IDFILTER").toString(), operator.getValueOf("TXVALUE").toString());
                }
            }
            catch (Exception e) {
                valueMap = null;
            }
        }
        return valueMap;
    }

    public String getFilterValue(String functionID, String filterID) {
        String value = "";
        if (!this.userFilterValueTable.equals("")) {
            try {
                String sql = "select * from " + this.userFilterValueTable + " where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "' AND IDFILTER = '" + filterID + "'";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                if (operator.next()) {
                    value = operator.getValueOf("TXVALUE").toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public void setFilterValue(String functionID, String filterID, String value) {
        if (!this.userFilterValueTable.equals("")) {
            try {
                String sql = "select * from " + this.userFilterValueTable + " where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "' AND IDFILTER = '" + filterID + "'";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                sql = operator.next() ? "update " + this.userFilterValueTable + " set TXVALUE = '" + value + "' where IDUSER ='" + this.getUserID() + "' AND IDFUNCTION = '" + functionID + "' AND IDFILTER = '" + filterID + "'" : "insert into " + this.userFilterValueTable + " (IDUSER, IDFUNCTION, IDFILTER, TXVALUE) values (" + "'" + this.getUserID() + "', '" + functionID + "', '" + filterID + "', '" + value + "')";
                operator = new XFTableOperator(this, null, sql, true);
                operator.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public float getAnnualExchangeRate(String currencyCode, int fYear, String type) {
        float rateReturn = 0.0f;
        if (currencyCode.equals(this.getSystemVariantString("SYSTEM_CURRENCY"))) {
            rateReturn = 1.0f;
        } else {
            try {
                String sql = "select * from " + this.exchangeRateAnnualTable + " where KBCURRENCY = '" + currencyCode + "' and DTNEND = " + fYear;
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                if (operator.next()) {
                    rateReturn = Float.parseFloat(operator.getValueOf("VLRATEM").toString());
                    if (type.equals("TTB")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATEB").toString());
                    }
                    if (type.equals("TTS")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATES").toString());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Annual exchange rate not found for '" + currencyCode + "'," + fYear + "." + "\nSQL: " + sql);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rateReturn;
    }

    public float getMonthlyExchangeRate(String currencyCode, String date, String type) {
        return this.getMonthlyExchangeRate(currencyCode, this.getFYearOfDate(date), this.getMSeqOfDate(date), type);
    }

    public float getMonthlyExchangeRate(String currencyCode, int fYear, int mSeq, String type) {
        float rateReturn = 0.0f;
        if (currencyCode.equals(this.getSystemVariantString("SYSTEM_CURRENCY"))) {
            rateReturn = 1.0f;
        } else {
            try {
                String sql = "select * from " + this.exchangeRateMonthlyTable + " where KBCURRENCY = '" + currencyCode + "' and DTNEND = " + fYear + " and DTMSEQ = " + mSeq;
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                if (operator.next()) {
                    rateReturn = Float.parseFloat(operator.getValueOf("VLRATEM").toString());
                    if (type.equals("TTB")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATEB").toString());
                    }
                    if (type.equals("TTS")) {
                        rateReturn = Float.parseFloat(operator.getValueOf("VLRATES").toString());
                    }
                }
                if (rateReturn == 0.0f) {
                    rateReturn = this.getAnnualExchangeRate(currencyCode, fYear, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rateReturn;
    }

    public int getTaxAmount(String date, int amount) {
        int fromDate = 0;
        int taxAmount = 0;
        if (date != null && !date.equals("")) {
            int targetDate = Integer.parseInt(date.replaceAll("-", "").replaceAll("/", ""));
            float rate = 0.0f;
            try {
                String sql = "select * from " + this.taxTable + " order by DTSTART DESC";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                while (operator.next()) {
                    fromDate = Integer.parseInt(operator.getValueOf("DTSTART").toString().replaceAll("-", ""));
                    if (targetDate < fromDate) continue;
                    rate = Float.parseFloat(operator.getValueOf("VLTAXRATE").toString());
                    break;
                }
                taxAmount = amount >= 0 ? (int)Math.floor((float)amount * rate) : (int)Math.ceil((float)amount * rate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return taxAmount;
    }

    public int getTaxAmount(String date, int amount, String kbKazei) {
        int fromDate = 0;
        int taxAmount = 0;
        if (date != null && !date.equals("")) {
            int targetDate = Integer.parseInt(date.replaceAll("-", "").replaceAll("/", ""));
            float rate = 0.0f;
            try {
                String sql = "select * from " + this.taxTable + " where KBKAZEI = '" + kbKazei + "' order by DTSTART DESC";
                XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                while (operator.next()) {
                    fromDate = Integer.parseInt(operator.getValueOf("DTSTART").toString().replaceAll("-", ""));
                    if (targetDate < fromDate) continue;
                    rate = Float.parseFloat(operator.getValueOf("VLTAXRATE").toString());
                    break;
                }
                taxAmount = amount >= 0 ? (int)Math.floor((float)amount * rate) : (int)Math.ceil((float)amount * rate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return taxAmount;
    }

    public int getMSeqOfDate(String parmDate) {
        int mSeq = 0;
        if (!parmDate.equals("")) {
            int value2;
            parmDate = parmDate.replaceAll("-", "").replaceAll("/", "").trim();
            parmDate = parmDate.replaceAll("/", "");
            int month = Integer.parseInt(parmDate.substring(4, 6));
            int date = Integer.parseInt(parmDate.substring(6, 8));
            boolean isWithinMonth = false;
            int startMonth = 1;
            int lastDay = 31;
            int value1 = this.getSystemVariantInteger("FIRST_MONTH");
            if (value1 != 0) {
                startMonth = value1;
            }
            if ((value2 = this.getSystemVariantInteger("LAST_DAY")) != 0) {
                lastDay = value2;
            }
            if (lastDay >= 31 && (month == 1 && date <= 31 || month == 2 && date <= 29 || month == 3 && date <= 31 || month == 4 && date <= 30 || month == 5 && date <= 31 || month == 6 && date <= 30 || month == 7 && date <= 31 || month == 8 && date <= 31 || month == 9 && date <= 30 || month == 10 && date <= 31 || month == 11 && date <= 30 || month == 12 && date <= 31)) {
                isWithinMonth = true;
            }
            if (lastDay == 30 && (month == 1 && date <= 30 || month == 2 && date <= 29 || month == 3 && date <= 30 || month == 4 && date <= 30 || month == 5 && date <= 30 || month == 6 && date <= 30 || month == 7 && date <= 30 || month == 8 && date <= 30 || month == 9 && date <= 30 || month == 10 && date <= 30 || month == 11 && date <= 30 || month == 12 && date <= 30)) {
                isWithinMonth = true;
            }
            if (lastDay <= 29 && date <= lastDay) {
                isWithinMonth = true;
            }
            if ((mSeq = isWithinMonth ? month - startMonth + 1 : month - startMonth + 2) <= 0) {
                mSeq += 12;
            }
        }
        return mSeq;
    }

    public int getFYearOfDate(String parmDate) {
        int fYear = 0;
        int mSeq = 0;
        if (!parmDate.equals("") && parmDate != null) {
            int value2;
            parmDate = parmDate.replaceAll("-", "").replaceAll("/", "").trim();
            fYear = Integer.parseInt(parmDate.substring(0, 4));
            int month = Integer.parseInt(parmDate.substring(4, 6));
            int date = Integer.parseInt(parmDate.substring(6, 8));
            boolean isWithinMonth = false;
            int startMonth = 1;
            int lastDay = 31;
            int value1 = this.getSystemVariantInteger("FIRST_MONTH");
            if (value1 != 0) {
                startMonth = value1;
            }
            if ((value2 = this.getSystemVariantInteger("LAST_DAY")) != 0) {
                lastDay = value2;
            }
            if (lastDay >= 31 && (month == 1 && date <= 31 || month == 2 && date <= 29 || month == 3 && date <= 31 || month == 4 && date <= 30 || month == 5 && date <= 31 || month == 6 && date <= 30 || month == 7 && date <= 31 || month == 8 && date <= 31 || month == 9 && date <= 30 || month == 10 && date <= 31 || month == 11 && date <= 30 || month == 12 && date <= 31)) {
                isWithinMonth = true;
            }
            if (lastDay == 30 && (month == 1 && date <= 30 || month == 2 && date <= 29 || month == 3 && date <= 30 || month == 4 && date <= 30 || month == 5 && date <= 30 || month == 6 && date <= 30 || month == 7 && date <= 30 || month == 8 && date <= 30 || month == 9 && date <= 30 || month == 10 && date <= 30 || month == 11 && date <= 30 || month == 12 && date <= 30)) {
                isWithinMonth = true;
            }
            if (lastDay <= 29 && date <= lastDay) {
                isWithinMonth = true;
            }
            if ((mSeq = isWithinMonth ? month - startMonth + 1 : month - startMonth + 2) <= 0) {
                --fYear;
            }
        }
        return fYear;
    }

    public String getYearMonthOfFYearMSeq(String fYearMSeq) {
        String resultYear = "";
        String resultMonth = "";
        int startMonth = this.getSystemVariantInteger("FIRST_MONTH");
        int fYear = Integer.parseInt(fYearMSeq.substring(0, 4));
        int mSeq = Integer.parseInt(fYearMSeq.substring(4, 6));
        int workInt = startMonth + mSeq - 1;
        if (workInt > 12) {
            resultMonth = Integer.toString(workInt -= 12);
            workInt = fYear + 1;
            resultYear = Integer.toString(workInt);
        } else {
            resultMonth = Integer.toString(workInt);
            workInt = fYear;
            resultYear = Integer.toString(workInt);
        }
        return String.valueOf(resultYear) + resultMonth;
    }

    public void closeSession(boolean isToWriteLogAndClose) {
        block10: {
            if (isToWriteLogAndClose) {
                this.sessionStatus = this.noErrorsOccured ? "END" : "ERR";
                try {
                    String sql = "update " + this.sessionTable + " set DTLOGOUT=CURRENT_TIMESTAMP, KBSESSIONSTATUS='" + this.sessionStatus + "' where " + "NRSESSION='" + this.sessionID + "'";
                    XFTableOperator operator = new XFTableOperator(this, null, sql, true);
                    operator.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.commit(true, null);
            if (this.scriptEngine != null && !this.loginScript.equals("")) {
                try {
                    this.scriptEngine.eval(this.loginScript);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
            if (this.appServerName.equals("")) {
                try {
                    this.connectionManualCommit.close();
                    this.connectionAutoCommit.close();
                    if (this.databaseName.contains("jdbc:derby")) {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                }
                catch (SQLException e) {
                    if (!this.databaseName.contains("jdbc:derby") || e.getSQLState() == null || e.getSQLState().equals("XJ015")) break block10;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.logout(e);
        } else {
            super.processWindowEvent(e);
        }
    }

    void logout(WindowEvent e) {
        Object[] bts = new Object[]{XFUtility.RESOURCE.getString("Yes"), XFUtility.RESOURCE.getString("No")};
        int rtn = JOptionPane.showOptionDialog(this, XFUtility.RESOURCE.getString("FunctionMessage55"), this.systemName, -1, 1, null, bts, bts[0]);
        if (rtn == 0) {
            if (e != null) {
                super.processWindowEvent(e);
            }
            this.closeSession(true);
            this.setVisible(false);
            System.exit(0);
        }
    }

    void jEditorPane_hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                try {
                    this.setCursor(new Cursor(3));
                    this.desktop.browse(e.getURL().toURI());
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                    this.setCursor(new Cursor(0));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.setCursor(new Cursor(0));
                }
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
    }

    void jButtonMenu_actionPerformed(ActionEvent e) {
        try {
            this.setCursor(new Cursor(3));
            Component com = (Component)e.getSource();
            int i = 0;
            while (i < 20) {
                if (com.equals(this.jButtonMenuOptionArray[i])) {
                    if (this.menuOptionArray[this.jTabbedPaneMenu.getSelectedIndex()][i].isLogoutOption) {
                        this.logout(null);
                    } else {
                        HashMap<String, Object> returnMap = this.menuOptionArray[this.jTabbedPaneMenu.getSelectedIndex()][i].call();
                        if (returnMap != null && returnMap.get("RETURN_CODE") != null) {
                            if (returnMap.get("RETURN_MESSAGE") == null) {
                                this.jTextAreaMessages.setText(XFUtility.getMessageOfReturnCode(returnMap.get("RETURN_CODE").toString()));
                            } else {
                                this.jTextAreaMessages.setText(returnMap.get("RETURN_MESSAGE").toString());
                            }
                        }
                        if (returnMap != null && returnMap.get("RETURN_TO") != null && returnMap.get("RETURN_TO").equals("MENU")) {
                            this.jTextAreaMessages.setText(XFUtility.RESOURCE.getString("SessionMessage3"));
                        }
                    }
                    break;
                }
                ++i;
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    public String getLogFileFolder() {
        File logFileDir = new File(this.logFileFolder);
        return logFileDir.getPath();
    }

    public int writeLogOfFunctionStarted(String functionID, String functionName) {
        ++this.sqProgram;
        try {
            if (functionName.length() > 30) {
                functionName = String.valueOf(functionName.substring(0, 27)) + "...";
            }
            String sql = "insert into " + this.sessionDetailTable + " (NRSESSION, SQPROGRAM, IDMENU, IDPROGRAM, TXPROGRAM, DTSTART, KBPROGRAMSTATUS) values (" + "'" + this.getSessionID() + "'," + this.sqProgram + "," + "'" + this.getMenuID() + "'," + "'" + functionID + "'," + "'" + functionName + "'," + "CURRENT_TIMESTAMP,'')";
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            operator.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.sqProgram;
    }

    public void writeLogOfFunctionClosed(int sqProgramOfFunction, String programStatus, String tableOperationLog, String errorLog) {
        String logString = "";
        StringBuffer bf = new StringBuffer();
        bf.append(tableOperationLog);
        if (!errorLog.equals("")) {
            bf.append("\n<ERROR LOG>\n");
            bf.append(errorLog);
        }
        if ((logString = bf.toString()).length() > this.loggingSize) {
            String logFileName = "";
            try {
                File logFileDir = new File(this.logFileFolder);
                if (!logFileDir.exists()) {
                    logFileDir.mkdir();
                }
                logFileName = String.valueOf(logFileDir.getPath()) + File.separator + "Log" + this.getSessionID() + "_" + sqProgramOfFunction + ".txt";
                FileOutputStream fileOutputStream = new FileOutputStream(logFileName);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                BufferedWriter writer = new BufferedWriter(outputStreamWriter);
                writer.write(logString);
                ((Writer)writer).close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "It failed to process log file " + logFileName + "\n" + ex.getMessage());
            }
            logString = "Ref Log" + this.getSessionID() + "_" + sqProgramOfFunction + ".txt";
        }
        logString = logString.replaceAll("'", "\"");
        if (this.databaseName.contains("ucanaccess:") && logString.contains("#")) {
            logString = logString.replaceAll("#", "\"");
        }
        if (programStatus.equals("99")) {
            this.noErrorsOccured = false;
        }
        try {
            String sql = "update " + this.sessionDetailTable + " set DTEND=CURRENT_TIMESTAMP, KBPROGRAMSTATUS='" + programStatus + "', TXERRORLOG='" + logString + "' where " + "NRSESSION='" + this.getSessionID() + "' and " + "SQPROGRAM=" + sqProgramOfFunction;
            XFTableOperator operator = new XFTableOperator(this, null, sql, true);
            operator.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void menu_keyPressed(KeyEvent e) {
        int i;
        boolean modified;
        if (e.getKeyCode() == 112) {
            this.browseHelp();
        }
        if (e.getKeyCode() == 27) {
            this.closeSession(true);
            this.setVisible(false);
            System.exit(0);
        }
        if ((e.getModifiersEx() & 0x80) != 0 && e.getKeyCode() == 84) {
            this.jTabbedPaneMenu.requestFocus();
        }
        if (e.getKeyCode() == 123 && (modified = this.modifyPasswordDialog.passwordModified())) {
            this.jTextAreaMessages.setText(XFUtility.RESOURCE.getString("PasswordModified"));
        }
        if (e.getKeyCode() == 39) {
            Component com = this.getFocusOwner();
            i = 0;
            while (i < 20) {
                if (com.equals(this.jButtonMenuOptionArray[i])) {
                    this.setFocusOnNextVisibleButton(i, "RIGHT");
                    break;
                }
                ++i;
            }
        }
        if (e.getKeyCode() == 37) {
            Component com = this.getFocusOwner();
            i = 0;
            while (i < 20) {
                if (com.equals(this.jButtonMenuOptionArray[i])) {
                    this.setFocusOnNextVisibleButton(i, "LEFT");
                    break;
                }
                ++i;
            }
        }
        if (e.getKeyCode() == 40) {
            Component com = this.getFocusOwner();
            if (com.equals(this.jTabbedPaneMenu)) {
                i = 0;
                while (i < 20) {
                    if (this.jButtonMenuOptionArray[i].isVisible()) {
                        this.jButtonMenuOptionArray[i].requestFocus();
                        break;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < 20) {
                    if (com.equals(this.jButtonMenuOptionArray[i])) {
                        this.setFocusOnNextVisibleButton(i, "DOWN");
                        break;
                    }
                    ++i;
                }
            }
        }
        if (e.getKeyCode() == 38) {
            Component com = this.getFocusOwner();
            if (com.equals(this.jButtonMenuOptionArray[10])) {
                this.jTabbedPaneMenu.requestFocus();
            } else {
                i = 0;
                while (i < 20) {
                    if (com.equals(this.jButtonMenuOptionArray[i])) {
                        this.setFocusOnNextVisibleButton(i, "UP");
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void setFocusOnNextVisibleButton(int index, String direction) {
        block13: {
            block12: {
                i = index;
                anyFound = false;
                if (!direction.equals("RIGHT") || i < 0 || i > 9) break block12;
                if (!this.jButtonMenuOptionArray[i += 10].isVisible()) ** GOTO lbl11
                this.jButtonMenuOptionArray[i].requestFocus();
                break block12;
lbl-1000:
                // 1 sources

                {
                    if (!this.jButtonMenuOptionArray[++i].isVisible()) continue;
                    this.jButtonMenuOptionArray[i].requestFocus();
                    anyFound = true;
                    break;
lbl11:
                    // 2 sources

                    ** while (i != 19)
                }
lbl12:
                // 2 sources

                if (!anyFound) {
                    i = index + 10;
                    while (i >= 9) {
                        if (!this.jButtonMenuOptionArray[--i].isVisible()) continue;
                        this.jButtonMenuOptionArray[i].requestFocus();
                        break;
                    }
                }
            }
            if (!direction.equals("LEFT") || i < 10 || i > 19) break block13;
            if (!this.jButtonMenuOptionArray[i -= 10].isVisible()) ** GOTO lbl27
            this.jButtonMenuOptionArray[i].requestFocus();
            break block13;
lbl-1000:
            // 1 sources

            {
                if (!this.jButtonMenuOptionArray[--i].isVisible()) continue;
                this.jButtonMenuOptionArray[i].requestFocus();
                anyFound = true;
                break;
lbl27:
                // 2 sources

                ** while (i != 0)
            }
lbl28:
            // 2 sources

            if (!anyFound) {
                i = index - 10;
                while (i <= 9) {
                    if (!this.jButtonMenuOptionArray[++i].isVisible()) continue;
                    this.jButtonMenuOptionArray[i].requestFocus();
                    break;
                }
            }
        }
        if (direction.equals("DOWN")) {
            while (i != 9 && i != 19) {
                if (!this.jButtonMenuOptionArray[++i].isVisible()) continue;
                this.jButtonMenuOptionArray[i].requestFocus();
                break;
            }
        }
        if (direction.equals("UP")) {
            while (i != 0 && i != 10) {
                if (this.jButtonMenuOptionArray[--i].isVisible()) {
                    this.jButtonMenuOptionArray[i].requestFocus();
                    anyFound = true;
                    break;
                }
                if (index <= 10 || i != 10 || !this.jButtonMenuOptionArray[--i].isVisible()) continue;
                this.jButtonMenuOptionArray[i].requestFocus();
                anyFound = true;
                break;
            }
            if (!anyFound) {
                this.jTabbedPaneMenu.requestFocus();
            }
        }
    }

    void jTabbedPaneMenu_stateChanged(ChangeEvent e) {
        this.setupOptionsOfMenuWithTabNo(this.jTabbedPaneMenu.getSelectedIndex());
    }

    public void startProgress(String text, int max) {
        this.functionLauncher.startProgress(text, max);
    }

    public void incrementProgress() {
        this.functionLauncher.incrementProgress();
    }

    public void endProgress() {
        this.functionLauncher.endProgress();
    }

    public String getAppServerName() {
        return this.appServerName;
    }

    public String getSubDBName(String id) {
        return this.subDBNameList.get(this.subDBIDList.indexOf(id));
    }

    public int getSubDBListSize() {
        return this.subDBNameList.size();
    }

    public String getSubDBName(int index) {
        return this.subDBNameList.get(index);
    }

    public String getSubDBUser(int index) {
        return this.subDBUserList.get(index);
    }

    public String getSubDBPassword(int index) {
        return this.subDBPasswordList.get(index);
    }

    public Connection getConnectionManualCommit() {
        return this.connectionManualCommit;
    }

    public Connection getConnectionAutoCommit() {
        return this.connectionAutoCommit;
    }

    public Connection getConnectionReadOnly(String id) {
        return this.subDBConnectionList.get(this.subDBIDList.indexOf(id));
    }

    public void rollback() {
        this.commit(false, null);
    }

    public void commit() {
        this.commit(true, null);
    }

    public void commit(boolean isCommit, StringBuffer logBuf) {
        block19: {
            if (this.appServerName.equals("")) {
                try {
                    if (isCommit) {
                        this.connectionManualCommit.commit();
                        if (logBuf != null) {
                            XFUtility.appendLog("Local-commit succeeded.", logBuf);
                        }
                    } else {
                        this.connectionManualCommit.rollback();
                        if (logBuf != null) {
                            XFUtility.appendLog("Local-rollback succeeded.", logBuf);
                        }
                    }
                    break block19;
                }
                catch (SQLException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage());
                    if (logBuf != null) {
                        XFUtility.appendLog(e.getMessage(), logBuf);
                    }
                    break block19;
                }
            }
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost httpPost = null;
            try {
                try {
                    httpPost = new HttpPost(this.appServerName);
                    ArrayList<BasicNameValuePair> objValuePairs = new ArrayList<BasicNameValuePair>(2);
                    objValuePairs.add(new BasicNameValuePair("SESSION", this.sessionID));
                    if (isCommit) {
                        objValuePairs.add(new BasicNameValuePair("METHOD", "COMMIT"));
                    } else {
                        objValuePairs.add(new BasicNameValuePair("METHOD", "ROLLBACK"));
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                    HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity responseEntity = response.getEntity();
                    if (logBuf == null) break block19;
                    if (responseEntity == null) {
                        XFUtility.appendLog("Response is NULL.", logBuf);
                        break block19;
                    }
                    XFUtility.appendLog(EntityUtils.toString((HttpEntity)responseEntity), logBuf);
                }
                catch (Exception e) {
                    String msg = "";
                    msg = isCommit ? "Connection failed to commit with the servlet '" + this.appServerName + "'" : "Connection failed to rollback with the servlet '" + this.appServerName + "'";
                    JOptionPane.showMessageDialog(null, msg);
                    if (logBuf != null) {
                        XFUtility.appendLog(e.getMessage(), logBuf);
                    }
                    httpClient.getConnectionManager().shutdown();
                    if (httpPost != null) {
                        httpPost.abort();
                    }
                }
            }
            finally {
                httpClient.getConnectionManager().shutdown();
                if (httpPost != null) {
                    httpPost.abort();
                }
            }
        }
    }

    public Object requestWebService(String uri) {
        return this.requestWebService(uri, "UTF-8");
    }

    public Object requestWebService(String uri, String encoding) {
        String response = null;
        HttpResponse httpResponse = null;
        InputStream inputStream = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            try {
                this.httpGet.setURI(new URI(uri));
                httpResponse = httpClient.execute((HttpUriRequest)this.httpGet);
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)encoding);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, String.valueOf(uri) + "\n" + XFUtility.RESOURCE.getString("FunctionMessage53"));
                httpClient.getConnectionManager().shutdown();
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return response;
    }

    public XFHttpRequest createWebServiceRequest(String uri) {
        return new XFHttpRequest(uri, "UTF-8");
    }

    public XFHttpRequest createWebServiceRequest(String uri, String encoding) {
        return new XFHttpRequest(uri, encoding);
    }

    public Document parseStringToGetXmlDocument(String data) {
        Document doc = null;
        try {
            this.domParser.parse(new InputSource(new ByteArrayInputStream(data.getBytes("UTF-8"))));
            doc = this.domParser.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public Document parseStringToGetXmlDocument(String data, String encoding) {
        Document doc = null;
        try {
            this.domParser.parse(new InputSource(new ByteArrayInputStream(data.getBytes(encoding))));
            doc = this.domParser.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public String parseXmlDocumentToGetString(Document document) throws Exception {
        StringWriter sw = new StringWriter();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(sw));
        return sw.toString();
    }

    public Document createXmlDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    public Document createXmlDocument(String name) throws Exception {
        Document document = this.createXmlDocument();
        Element element = document.createElement(name);
        document.appendChild(element);
        return document;
    }

    public Element createXmlNode(Document document, String name) throws Exception {
        return document.createElement(name);
    }

    public Element getXmlNode(Document document, String name) throws Exception {
        NodeList elementList = document.getElementsByTagName(name);
        return (Element)elementList.item(0);
    }

    public Element getXmlNode(Element element, String name) throws Exception {
        NodeList elementList = element.getElementsByTagName(name);
        return (Element)elementList.item(0);
    }

    public ArrayList<Element> getXmlNodeList(Document document, String name) throws Exception {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList nodeList = document.getElementsByTagName(name);
        int i = 0;
        while (i < nodeList.getLength()) {
            elementList.add((Element)nodeList.item(i));
            ++i;
        }
        return elementList;
    }

    public ArrayList<Element> getXmlNodeList(Element element, String name) throws Exception {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName(name);
        int i = 0;
        while (i < nodeList.getLength()) {
            elementList.add((Element)nodeList.item(i));
            ++i;
        }
        return elementList;
    }

    public String getXmlNodeContent(Element element, String name) throws Exception {
        Element workElement = this.getXmlNode(element, name);
        return workElement.getTextContent();
    }

    public JSONObject createJsonObject(String text) {
        JSONObject obj = null;
        try {
            obj = new JSONObject(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public JSONObject createJsonObject() throws Exception {
        return new JSONObject();
    }

    public JSONArray createJsonArray(String text) {
        JSONArray array = null;
        try {
            array = new JSONArray(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    public JSONArray createJsonArray() throws Exception {
        return new JSONArray();
    }

    public JSONObject getJsonObject(JSONObject object, String name) throws Exception {
        return object.getJSONObject(name);
    }

    public JSONArray getJsonArray(JSONObject object, String name) throws Exception {
        return object.getJSONArray(name);
    }

    public JSONObject getJsonObject(JSONArray array, int index) throws Exception {
        return array.getJSONObject(index);
    }

    public byte[] decodeBase64StringToByteArray(Object value) {
        if (value instanceof String) {
            return Base64.decodeBase64((String)((String)value));
        }
        return null;
    }

    public String encodeByteArrayToBase64String(Object value) {
        if (value instanceof byte[]) {
            return Base64.encodeBase64String((byte[])((byte[])value));
        }
        return "";
    }

    public String getDigestedValueForUser(String user, String value) {
        if (this.isValueSaltedForUser) {
            return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, user);
        }
        return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, "");
    }

    public String getDigestedValueForUser(String value) {
        if (this.isValueSaltedForUser) {
            return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, this.userID);
        }
        return this.getDigestedValue(value, this.digestAlgorithmForUser, this.countOfExpandForUser, "");
    }

    public String getDigestedValue(String value) {
        return this.getDigestedValueForUser(value);
    }

    public String getDigestedValue(String value, String algorithm) {
        return this.getDigestedValue(value, algorithm, 1, "");
    }

    public String getDigestedValue(String value, String algorithm, int expand, String salt) {
        String digestedValue = "";
        int count = expand - 1;
        try {
            DigestAdapter adapter = new DigestAdapter(algorithm);
            digestedValue = adapter.digest(String.valueOf(value) + salt);
            int i = 0;
            while (i < count) {
                digestedValue = adapter.digest(String.valueOf(digestedValue) + salt);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            return digestedValue;
        }
        return digestedValue;
    }

    public String getRandomString(int length, String characters) {
        return RandomStringUtils.random((int)length, (String)characters);
    }

    public String getAddressFromZipNo(String zipNo) {
        String value;
        block20: {
            value = "";
            String zipNo_ = zipNo.replace("-", "");
            HttpResponse response = null;
            InputStream inputStream = null;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            try {
                try {
                    String company;
                    if (!this.proxyIP.equals("")) {
                        httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(this.proxyIP, Integer.parseInt(this.proxyPort)));
                    }
                    this.httpGet.setURI(new URI("http://zip.cgis.biz/xml/zip.php?zn=" + zipNo_));
                    response = httpClient.execute((HttpUriRequest)this.httpGet);
                    if (response.getStatusLine().getStatusCode() >= 400) break block20;
                    inputStream = response.getEntity().getContent();
                    this.domParser.parse(new InputSource(inputStream));
                    this.responseDoc = this.domParser.getDocument();
                    Element rootNode = (Element)this.responseDoc.getElementsByTagName("ZIP_result").item(0);
                    if (rootNode.getElementsByTagName("value").getLength() == 0) {
                        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionMessage54")) + "\n" + zipNo);
                        break block20;
                    }
                    Element stateNode = (Element)rootNode.getElementsByTagName("value").item(4);
                    Element cityNode = (Element)rootNode.getElementsByTagName("value").item(5);
                    Element addressNode = (Element)rootNode.getElementsByTagName("value").item(6);
                    Element companyNode = (Element)rootNode.getElementsByTagName("value").item(7);
                    String state = stateNode.getAttribute("state");
                    String city = cityNode.getAttribute("city");
                    String address = addressNode.getAttribute("address");
                    if (address.equals("none")) {
                        address = "";
                    }
                    if ((company = companyNode.getAttribute("company")).equals("none")) {
                        company = "";
                    }
                    value = String.valueOf(state) + city + address + company;
                }
                catch (Exception ex) {
                    if (!this.proxyIP.equals("")) {
                        JOptionPane.showMessageDialog(null, "http://zip.cgis.biz/xml/zip.php? " + XFUtility.RESOURCE.getString("FunctionMessage53"));
                    } else {
                        int reply = JOptionPane.showConfirmDialog(null, XFUtility.RESOURCE.getString("FunctionMessage65"));
                        if (reply == 0) {
                            this.proxyIP = "";
                            this.proxyPort = "";
                        }
                    }
                    httpClient.getConnectionManager().shutdown();
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                httpClient.getConnectionManager().shutdown();
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return value;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String formatDate(String value) {
        return this.formatDate(value, this.dateFormat);
    }

    public String formatDate(String value, String format) {
        if (value.equals("")) {
            return "";
        }
        try {
            return XFUtility.getUserExpressionOfUtilDate(XFUtility.convertDateFromStringToUtil(value), format, false);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String executeProgram(String pgmName) {
        String message = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(pgmName);
            if (p != null) {
                int count = 0;
                String result = "";
                StringBuffer buf = new StringBuffer();
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                while ((result = br.readLine()) != null) {
                    if (count > 0) {
                        buf.append("\n");
                    }
                    buf.append(result);
                    ++count;
                }
                message = buf.toString();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
        return message;
    }

    public void browseFile(String fileName) {
        if (fileName.equals("")) {
            JOptionPane.showMessageDialog(null, "File name not specified.");
        } else {
            File file = new File(fileName);
            this.browseFile(file.toURI());
        }
    }

    public void browseFile(URI uri) {
        try {
            this.desktop.browse(uri);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    public void editFile(String fileName) {
        try {
            if (fileName.equals("")) {
                JOptionPane.showMessageDialog(null, "File name not specified.");
            } else {
                File file = new File(fileName);
                this.desktop.edit(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    public String getImageFileFolder() {
        return this.imageFileFolder;
    }

    public File createTempFile(String functionID, String extension) throws IOException {
        String header = "XeadDriver_";
        if (extension.equals(".pdf")) {
            header = "PDF_" + header;
        }
        if (extension.equals(".xls")) {
            header = "XLS_" + header;
        }
        if (extension.equals(".log")) {
            header = "LOG_" + header;
        }
        File tempFile = File.createTempFile(String.valueOf(header) + functionID + "_", extension, this.outputFolder);
        if (this.outputFolder == null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    public boolean existsFile(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public boolean deleteFile(String fileName) {
        File file = new File(fileName);
        return file.delete();
    }

    public boolean renameFile(String currentName, String newName) {
        File currentFile = new File(currentName);
        File newFile = new File(newName);
        return currentFile.renameTo(newFile);
    }

    public boolean copyFile(String originalName, String newName) {
        boolean result = false;
        try {
            File originalFile;
            if (originalName.contains("<CURRENT>")) {
                originalName = originalName.replace("<CURRENT>", this.currentFolder);
            }
            if (newName.contains("<CURRENT>")) {
                newName = newName.replace("<CURRENT>", this.currentFolder);
            }
            if (!(originalFile = new File(originalName)).exists()) {
                return result;
            }
            File newFile = new File(newName);
            if (!newFile.exists()) {
                newFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(originalFile);
            FileOutputStream fos = new FileOutputStream(newFile);
            try {
                try {
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                    result = true;
                }
                catch (Exception exception) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public XFExcelFileOperator createExcelFileOperator(String fileName) {
        return new XFExcelFileOperator(fileName);
    }

    public XFTextFileOperator createTextFileOperator(String operation, String fileName, String separator) {
        return this.createTextFileOperator(operation, fileName, separator, "");
    }

    public XFTextFileOperator createTextFileOperator(String operation, String fileName, String separator, String charset) {
        File file = new File(fileName);
        if (operation.equals("Read") && !file.exists()) {
            JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("SessionError21")) + fileName + XFUtility.RESOURCE.getString("SessionError22"));
            return null;
        }
        return new XFTextFileOperator(operation, fileName, separator, charset);
    }

    public XFTableOperator createTableOperator(String oparation, String tableID) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this, null, oparation, tableID, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    public XFTableOperator createTableOperator(String sqlText) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this, null, sqlText, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    public int copyTableRecords(String fromTable, String toTable, String type) {
        return this.copyTableRecords(fromTable, toTable, type, 0, true);
    }

    public int copyTableRecords(String fromTable, String toTable, String type, int recordCount) {
        return this.copyTableRecords(fromTable, toTable, type, recordCount, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int copyTableRecords(String fromTable, String toTable, String type, int recordCount, boolean isToCommitEachTime) {
        int totalCount;
        block39: {
            totalCount = 0;
            int index = 0;
            try {
                int count;
                XFTableOperator insertToTable;
                ArrayList<String> dataTypeOptionList;
                String dataTypeOptions;
                Element workElement;
                if (!(type.equals("REPLACE") || type.equals("ADD") || type.equals("MERGE"))) {
                    return -1;
                }
                Element tableElementFrom = this.getTableElement(fromTable);
                NodeList fieldListFrom = tableElementFrom.getElementsByTagName("Field");
                XFTableOperator selectFromTable = this.createTableOperator("SELECT", fromTable);
                Element tableElementTo = this.getTableElement(toTable);
                if (!tableElementTo.getAttribute("DB").equals("")) {
                    if (this.isClientSession) {
                        JOptionPane.showMessageDialog(this, "You can not update read-only table.");
                    }
                    return -1;
                }
                NodeList fieldListTo = tableElementTo.getElementsByTagName("Field");
                NodeList keyListTo = tableElementTo.getElementsByTagName("Key");
                ArrayList<String> fieldIDListFrom = new ArrayList<String>();
                ArrayList<String> fieldTypeListFrom = new ArrayList<String>();
                ArrayList<Integer> fieldLengthListFrom = new ArrayList<Integer>();
                int i = 0;
                while (i < fieldListFrom.getLength()) {
                    workElement = (Element)fieldListFrom.item(i);
                    dataTypeOptions = workElement.getAttribute("TypeOptions");
                    dataTypeOptionList = XFUtility.getOptionList(dataTypeOptions);
                    if (!dataTypeOptionList.contains("VIRTUAL")) {
                        fieldIDListFrom.add(workElement.getAttribute("ID"));
                        fieldTypeListFrom.add(workElement.getAttribute("Type"));
                        fieldLengthListFrom.add(Integer.parseInt(workElement.getAttribute("Size")));
                    }
                    ++i;
                }
                ArrayList<String> keyFieldIDListTo = new ArrayList<String>();
                int i2 = 0;
                while (i2 < keyListTo.getLength()) {
                    workElement = (Element)keyListTo.item(i2);
                    if (workElement.getAttribute("Type").equals("PK")) {
                        StringTokenizer workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                        while (workTokenizer.hasMoreTokens()) {
                            keyFieldIDListTo.add(workTokenizer.nextToken());
                        }
                        break;
                    }
                    ++i2;
                }
                ArrayList<String> fieldIDListTo = new ArrayList<String>();
                ArrayList<String> fieldTypeListTo = new ArrayList<String>();
                ArrayList<Integer> fieldLengthListTo = new ArrayList<Integer>();
                ArrayList<String> fieldNullableListTo = new ArrayList<String>();
                int i3 = 0;
                while (i3 < fieldListTo.getLength()) {
                    workElement = (Element)fieldListTo.item(i3);
                    dataTypeOptions = workElement.getAttribute("TypeOptions");
                    dataTypeOptionList = XFUtility.getOptionList(dataTypeOptions);
                    if (!dataTypeOptionList.contains("VIRTUAL")) {
                        fieldIDListTo.add(workElement.getAttribute("ID"));
                        fieldTypeListTo.add(workElement.getAttribute("Type"));
                        fieldLengthListTo.add(Integer.parseInt(workElement.getAttribute("Size")));
                        fieldNullableListTo.add(workElement.getAttribute("Nullable"));
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < fieldIDListTo.size()) {
                    index = fieldIDListFrom.indexOf(fieldIDListTo.get(i3));
                    if (index == -1) {
                        if (((String)fieldNullableListTo.get(i3)).equals("F")) {
                            return -1;
                        }
                    } else if (((String)fieldTypeListFrom.get(index)).equals(fieldTypeListTo.get(i3))) {
                        if ((((String)fieldTypeListFrom.get(index)).equals("CHAR") || ((String)fieldTypeListFrom.get(index)).equals("TEXT")) && (Integer)fieldLengthListFrom.get(index) > (Integer)fieldLengthListTo.get(i3)) {
                            return -1;
                        }
                    } else {
                        return -1;
                    }
                    ++i3;
                }
                if (type.equals("REPLACE") || type.equals("ADD")) {
                    if (type.equals("REPLACE")) {
                        XFTableOperator deleteToTable = this.createTableOperator("DELETE", toTable);
                        deleteToTable.execute();
                        if (isToCommitEachTime) {
                            this.commit();
                        }
                    }
                    while (selectFromTable.next()) {
                        insertToTable = this.createTableOperator("INSERT", toTable);
                        i3 = 0;
                        while (i3 < fieldIDListFrom.size()) {
                            if (fieldIDListTo.contains(fieldIDListFrom.get(i3))) {
                                insertToTable.addValue((String)fieldIDListFrom.get(i3), selectFromTable.getValueOf((String)fieldIDListFrom.get(i3)));
                            }
                            ++i3;
                        }
                        count = insertToTable.execute();
                        if (count == 1) {
                            if (isToCommitEachTime) {
                                this.commit();
                            }
                            if (recordCount <= 0 || ++totalCount != recordCount) continue;
                            break;
                        }
                        this.commit(false, null);
                        return -1;
                    }
                }
                if (!type.equals("MERGE")) break block39;
                while (selectFromTable.next()) {
                    XFTableOperator selectToTable = this.createTableOperator("SELECT", toTable);
                    i3 = 0;
                    while (i3 < keyFieldIDListTo.size()) {
                        selectToTable.addKeyValue((String)keyFieldIDListTo.get(i3), selectFromTable.getValueOf((String)keyFieldIDListTo.get(i3)));
                        ++i3;
                    }
                    if (selectToTable.next()) {
                        XFTableOperator updateToTable = this.createTableOperator("UPDATE", toTable);
                        i3 = 0;
                        while (i3 < fieldIDListFrom.size()) {
                            if (fieldIDListTo.contains(fieldIDListFrom.get(i3))) {
                                updateToTable.addValue((String)fieldIDListFrom.get(i3), selectFromTable.getValueOf((String)fieldIDListFrom.get(i3)));
                            }
                            ++i3;
                        }
                        i3 = 0;
                        while (i3 < keyFieldIDListTo.size()) {
                            updateToTable.addKeyValue((String)keyFieldIDListTo.get(i3), selectFromTable.getValueOf((String)keyFieldIDListTo.get(i3)));
                            ++i3;
                        }
                        count = updateToTable.execute();
                        if (count == 1) {
                            if (isToCommitEachTime) {
                                this.commit();
                            }
                            if (recordCount <= 0 || ++totalCount != recordCount) continue;
                            break;
                        }
                        this.commit(false, null);
                        return -1;
                    }
                    insertToTable = this.createTableOperator("INSERT", toTable);
                    i3 = 0;
                    while (i3 < fieldIDListFrom.size()) {
                        if (fieldIDListTo.contains(fieldIDListFrom.get(i3))) {
                            insertToTable.addValue((String)fieldIDListFrom.get(i3), selectFromTable.getValueOf((String)fieldIDListFrom.get(i3)));
                        }
                        ++i3;
                    }
                    count = insertToTable.execute();
                    if (count == 1) {
                        if (isToCommitEachTime) {
                            this.commit();
                        }
                        if (recordCount <= 0 || ++totalCount != recordCount) continue;
                        break;
                    }
                    this.commit(false, null);
                    return -1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.commit(false, null);
                return -1;
            }
        }
        return totalCount;
    }

    Document getDomDocument() {
        return this.domDocument;
    }

    public void sendMail(String addressFrom, String addressTo, String addressCc, String subject, String message) {
        this.sendMail(addressFrom, addressTo, addressCc, subject, message, "", "", "");
    }

    public void sendMail(String addressFrom, String addressTo, String addressCc, String subject, String message, String fileName, String attachedName, String charset) {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.smtpHost);
            props.put("mail.host", this.smtpHost);
            props.put("mail.from", addressFrom);
            if (!this.smtpPassword.equals("")) {
                props.setProperty("mail.smtp.auth", "true");
            }
            if (!this.smtpPort.equals("")) {
                props.put("mail.smtp.port", this.smtpPort);
            }
            javax.mail.Session mailSession = javax.mail.Session.getDefaultInstance((Properties)props, null);
            MimeMessage mailObj = new MimeMessage(mailSession);
            mailObj.setFrom((Address)new InternetAddress(addressFrom));
            mailObj.setSentDate(new Date());
            StringTokenizer workTokenizer = new StringTokenizer(addressTo.replaceAll(" ", ""), ",");
            InternetAddress[] toList = new InternetAddress[workTokenizer.countTokens()];
            int i = 0;
            while (workTokenizer.hasMoreTokens()) {
                toList[i] = new InternetAddress(workTokenizer.nextToken());
                ++i;
            }
            mailObj.setRecipients(Message.RecipientType.TO, (Address[])toList);
            if (!addressCc.equals("")) {
                workTokenizer = new StringTokenizer(addressCc.replaceAll(" ", ""), ",");
                InternetAddress[] ccList = new InternetAddress[workTokenizer.countTokens()];
                i = 0;
                while (workTokenizer.hasMoreTokens()) {
                    ccList[i] = new InternetAddress(workTokenizer.nextToken());
                    ++i;
                }
                mailObj.setRecipients(Message.RecipientType.CC, (Address[])ccList);
            }
            if (charset.equals("")) {
                mailObj.setSubject(subject);
            } else {
                mailObj.setSubject(subject, charset);
            }
            MimeBodyPart bodyMessage = new MimeBodyPart();
            MimeBodyPart bodyAttachedFile = new MimeBodyPart();
            if (charset.equals("")) {
                bodyMessage.setText(message);
            } else {
                bodyMessage.setText(message, charset);
            }
            if (!fileName.equals("")) {
                FileDataSource fds = new FileDataSource(fileName);
                bodyAttachedFile.setDataHandler(new DataHandler((DataSource)fds));
                if (!attachedName.equals("")) {
                    if (charset.equals("")) {
                        bodyAttachedFile.setFileName(MimeUtility.encodeWord((String)attachedName));
                    } else {
                        bodyAttachedFile.setFileName(MimeUtility.encodeWord((String)attachedName, (String)charset, (String)"B"));
                    }
                }
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bodyMessage);
            if (!fileName.equals("")) {
                multipart.addBodyPart((BodyPart)bodyAttachedFile);
            }
            mailObj.setContent((Multipart)multipart);
            if (this.smtpPassword.equals("")) {
                Transport.send((Message)mailObj);
            } else {
                Transport tp = mailSession.getTransport("smtp");
                tp.connect(this.smtpHost, this.smtpUser, this.smtpPassword);
                tp.sendMessage((Message)mailObj, (Address[])toList);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Sending mail with subject '" + subject + "' failed.\n\n" + e.getMessage());
        }
    }

    public HashMap<String, Object> executeFunction(String functionID, HashMap<String, Object> parmMap) throws Exception {
        return this.functionLauncher.execute(functionID, parmMap);
    }

    Desktop getDesktop() {
        return this.desktop;
    }

    public DialogCheckRead getDialogCheckRead() {
        return this.checkReadDialog;
    }

    String getSystemName() {
        return this.systemName;
    }

    String getVersion() {
        return this.systemVersion;
    }

    public String getAdminEmail() {
        return this.smtpAdminEmail;
    }

    String getTableNameOfUser() {
        return this.userTable;
    }

    String getTableNameOfUserFilterValue() {
        return this.userFilterValueTable;
    }

    String getTableNameOfVariants() {
        return this.variantsTable;
    }

    String getTableNameOfUserVariants() {
        return this.userVariantsTable;
    }

    String getTableNameOfNumbering() {
        return this.numberingTable;
    }

    String getTableNameOfCalendar() {
        return this.calendarTable;
    }

    String getMenuID() {
        return this.menuIDUsing;
    }

    Rectangle getMenuRectangle() {
        if (this.isVisible()) {
            int h;
            int w;
            int y;
            int x = this.getX();
            if (x < 0) {
                x = 0;
            }
            if ((y = this.getY()) < 0) {
                y = 0;
            }
            if ((w = this.getWidth()) > this.screenSize.width) {
                w = this.screenSize.width;
            }
            if ((h = this.getHeight()) > this.screenSize.height) {
                h = this.screenSize.height;
            }
            return new Rectangle(x, y, w, h);
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(0, 0, dim.width, dim.height);
    }

    int getNextSQPROGRAM() {
        ++this.sqProgram;
        return this.sqProgram;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void compressTable(String tableID) throws Exception {
        Statement statement = null;
        HttpPost httpPost = null;
        String msg = "";
        boolean isTarget = false;
        if (this.databaseName.contains("jdbc:derby:")) {
            try {
                try {
                    if (this.appServerName.equals("")) {
                        statement = this.connectionManualCommit.createStatement();
                    }
                    int i = 0;
                    while (i < this.tableList.getLength()) {
                        Element element = (Element)this.tableList.item(i);
                        isTarget = false;
                        if (element.getAttribute("ID").equals(tableID) || tableID.equals("")) {
                            isTarget = true;
                        } else if (tableID.endsWith("*") && element.getAttribute("ID").startsWith(tableID.replace("*", ""))) {
                            isTarget = true;
                        }
                        if (isTarget) {
                            StringBuffer statementBuf = new StringBuffer();
                            statementBuf.append("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE('");
                            statementBuf.append(this.databaseUser);
                            statementBuf.append("', '");
                            statementBuf.append(element.getAttribute("ID"));
                            statementBuf.append("', 1)");
                            if (this.appServerName.equals("")) {
                                statement.executeUpdate(statementBuf.toString());
                            } else {
                                DefaultHttpClient httpClient = new DefaultHttpClient();
                                try {
                                    httpPost = new HttpPost(this.appServerName);
                                    ArrayList<BasicNameValuePair> objValuePairs = new ArrayList<BasicNameValuePair>(1);
                                    objValuePairs.add(new BasicNameValuePair("METHOD", statementBuf.toString()));
                                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(objValuePairs, "UTF-8"));
                                    HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                    HttpEntity responseEntity = response.getEntity();
                                    if (responseEntity == null) {
                                        msg = "Compressing table " + element.getAttribute("ID") + " failed.";
                                        JOptionPane.showMessageDialog(null, msg);
                                        throw new Exception(msg);
                                    }
                                }
                                finally {
                                    httpClient.getConnectionManager().shutdown();
                                    if (httpPost != null) {
                                        httpPost.abort();
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    JOptionPane.showMessageDialog(null, "Compressing table " + tableID + " failed.\n" + e.getMessage());
                    throw new Exception(e.getMessage());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Compressing table " + tableID + " failed.\n" + e.getMessage());
                    throw new Exception(e.getMessage());
                }
            }
            finally {
                if (this.appServerName.equals("")) {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getStatus() {
        return this.sessionStatus;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileFolder() {
        return this.currentFolder;
    }

    public String getOutputFolder() {
        if (this.outputFolder == null) {
            return "";
        }
        return this.outputFolder.getPath();
    }

    public String getUserID() {
        return this.userID;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmployeeNo() {
        return this.userEmployeeNo;
    }

    public String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    public String getAttribute(String id) {
        return this.attributeMap.get(id);
    }

    public String getSystemProperty(String id) {
        return System.getProperty(id);
    }

    public void setAttribute(String id, String value) {
        this.attributeMap.put(id.trim(), value.trim());
    }

    public NodeList getFunctionList() {
        return this.functionList;
    }

    public String getScriptFunctions() {
        return this.scriptFunctions;
    }

    public String getFunctionName(String functionID) {
        String functionName = "";
        int k = 0;
        while (k < this.functionList.getLength()) {
            Element workElement = (Element)this.functionList.item(k);
            if (workElement.getAttribute("ID").equals(functionID)) {
                functionName = workElement.getAttribute("Name");
                break;
            }
            ++k;
        }
        return functionName;
    }

    Element getTablePKElement(String tableID) {
        Element element3 = null;
        int i = 0;
        block0: while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                NodeList nodeList = element1.getElementsByTagName("Key");
                int j = 0;
                while (j < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(j);
                    if (element2.getAttribute("Type").equals("PK")) {
                        element3 = element2;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return element3;
    }

    Element getTableElement(String tableID) {
        Element element2 = null;
        int i = 0;
        while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                element2 = element1;
                break;
            }
            ++i;
        }
        return element2;
    }

    public String getTableName(String tableID) {
        String tableName = "";
        Element element2 = null;
        int i = 0;
        while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                element2 = element1;
                tableName = element2.getAttribute("Name");
                break;
            }
            ++i;
        }
        return tableName;
    }

    public NodeList getTableNodeList() {
        return this.tableList;
    }

    public Element getFieldElement(String tableID, String fieldID) {
        Element element3 = null;
        int i = 0;
        block0: while (i < this.tableList.getLength()) {
            Element element1 = (Element)this.tableList.item(i);
            if (element1.getAttribute("ID").equals(tableID)) {
                NodeList nodeList = element1.getElementsByTagName("Field");
                int j = 0;
                while (j < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(j);
                    if (element2.getAttribute("ID").equals(fieldID)) {
                        element3 = element2;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return element3;
    }

    public String getFieldName(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Name");
        }
        return name;
    }

    public String getFieldType(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Type");
        }
        return name;
    }

    public String getFieldSize(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Size");
        }
        return name;
    }

    public String getFieldDecimal(String tableID, String fieldID) {
        String name = "";
        Element element = this.getFieldElement(tableID, fieldID);
        if (element != null) {
            name = element.getAttribute("Decimal");
        }
        return name;
    }

    class FunctionLauncher {
        private XF000[] xF000 = new XF000[10];
        private XF100[] xF100 = new XF100[10];
        private XF110[] xF110 = new XF110[10];
        private XF200[] xF200 = new XF200[10];
        private XF290[] xF290 = new XF290[10];
        private XF300[] xF300 = new XF300[10];
        private XF310[] xF310 = new XF310[10];
        private XF390[] xF390 = new XF390[10];
        private Session session_ = null;
        private XFExecutable lastPanelFunction = null;

        public FunctionLauncher(Session session2) {
            this.session_ = session2;
            this.xF000[0] = new XF000(session2, 0);
            if (this.session_.isClientSession) {
                this.xF100[0] = new XF100(session2, 0);
                this.xF110[0] = new XF110(session2, 0);
                this.xF200[0] = new XF200(session2, 0);
                this.xF290[0] = new XF290(session2, 0);
                this.xF300[0] = new XF300(session2, 0);
                this.xF310[0] = new XF310(session2, 0);
                this.xF390[0] = new XF390(session2, 0);
            }
        }

        public HashMap<String, Object> execute(String functionID, HashMap<String, Object> parmMap) throws Exception {
            HashMap<String, Object> returnMap = new HashMap();
            boolean isInvalidFunctionID = true;
            XFExecutable workFunction = this.lastPanelFunction;
            XFExecutable preloadedFunction = this.session_.getPreloadedFunction(functionID);
            if (preloadedFunction == null) {
                Element functionElement = null;
                int i = 0;
                while (i < Session.this.functionList.getLength()) {
                    functionElement = (Element)Session.this.functionList.item(i);
                    if (functionElement.getAttribute("ID").equals(functionID)) {
                        returnMap = this.execute(functionElement, parmMap);
                        isInvalidFunctionID = false;
                        break;
                    }
                    ++i;
                }
                if (isInvalidFunctionID) {
                    if (functionID.equals("")) {
                        throw new Exception("Calling canceled as the function for the action is not specified.");
                    }
                    throw new Exception("Calling canceled as its function id '" + functionID + "' is invalid.");
                }
            } else {
                this.lastPanelFunction = preloadedFunction;
                returnMap = preloadedFunction.execute(parmMap);
            }
            this.lastPanelFunction = workFunction;
            return returnMap;
        }

        public HashMap<String, Object> execute(Element functionElement, HashMap<String, Object> parmMap) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            int countOfRuccursiveCalls = 0;
            if (functionElement == null) {
                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError15"));
            } else {
                String functionID = functionElement.getAttribute("ID");
                int i = 0;
                while (i < 10) {
                    if (functionElement.getAttribute("Type").equals("XF000")) {
                        if (this.xF000[i] == null) {
                            this.xF000[i] = new XF000(this.session_, i);
                            if (!functionElement.getAttribute("TimerOption").equals("")) {
                                this.lastPanelFunction = this.xF000[i];
                            }
                            returnMap = this.xF000[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF000[i].isAvailable()) {
                            if (!functionElement.getAttribute("TimerOption").equals("")) {
                                this.lastPanelFunction = this.xF000[i];
                            }
                            returnMap = this.xF000[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF000[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF100")) {
                        if (this.xF100[i] == null) {
                            this.xF100[i] = new XF100(this.session_, i);
                            this.lastPanelFunction = this.xF100[i];
                            returnMap = this.xF100[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF100[i].isAvailable()) {
                            this.lastPanelFunction = this.xF100[i];
                            returnMap = this.xF100[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF100[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF110")) {
                        if (this.xF110[i] == null) {
                            this.xF110[i] = new XF110(this.session_, i);
                            this.lastPanelFunction = this.xF110[i];
                            returnMap = this.xF110[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF110[i].isAvailable()) {
                            this.lastPanelFunction = this.xF110[i];
                            returnMap = this.xF110[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF110[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF200")) {
                        if (this.xF200[i] == null) {
                            this.xF200[i] = new XF200(this.session_, i);
                            this.lastPanelFunction = this.xF200[i];
                            returnMap = this.xF200[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF200[i].isAvailable()) {
                            this.lastPanelFunction = this.xF200[i];
                            returnMap = this.xF200[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF200[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF290")) {
                        if (this.xF290[i] == null) {
                            this.xF290[i] = new XF290(this.session_, i);
                            returnMap = this.xF290[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF290[i].isAvailable()) {
                            returnMap = this.xF290[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF290[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF300")) {
                        if (this.xF300[i] == null) {
                            this.xF300[i] = new XF300(this.session_, i);
                            this.lastPanelFunction = this.xF300[i];
                            returnMap = this.xF300[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF300[i].isAvailable()) {
                            this.lastPanelFunction = this.xF300[i];
                            returnMap = this.xF300[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF300[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF310")) {
                        if (this.xF310[i] == null) {
                            this.xF310[i] = new XF310(this.session_, i);
                            this.lastPanelFunction = this.xF310[i];
                            returnMap = this.xF310[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF310[i].isAvailable()) {
                            this.lastPanelFunction = this.xF310[i];
                            returnMap = this.xF310[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF310[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    if (functionElement.getAttribute("Type").equals("XF390")) {
                        if (this.xF390[i] == null) {
                            this.xF390[i] = new XF390(this.session_, i);
                            returnMap = this.xF390[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF390[i].isAvailable()) {
                            returnMap = this.xF390[i].execute(functionElement, parmMap);
                            break;
                        }
                        if (this.xF390[i].getFunctionID().equals(functionID)) {
                            if (countOfRuccursiveCalls >= 1) {
                                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("SessionError20"));
                                returnMap.put("RETURN_CODE", "01");
                                break;
                            }
                            ++countOfRuccursiveCalls;
                        }
                    }
                    ++i;
                }
            }
            return returnMap;
        }

        public void startProgress(String text, int max) {
            if (this.lastPanelFunction != null) {
                this.lastPanelFunction.startProgress(text, max);
            }
        }

        public void incrementProgress() {
            if (this.lastPanelFunction != null) {
                this.lastPanelFunction.incrementProgress();
            }
        }

        public void endProgress() {
            if (this.lastPanelFunction != null) {
                this.lastPanelFunction.endProgress();
            }
        }
    }

    class MenuOption {
        private Element functionElement_ = null;
        private String optionName_;
        private boolean isLogoutOption = false;

        public MenuOption(Element functionElement, String optionName) {
            this.functionElement_ = functionElement;
            if (optionName.equals("")) {
                if (this.functionElement_ != null) {
                    this.optionName_ = this.functionElement_.getAttribute("Name");
                }
            } else if (optionName.equals("LOGOUT")) {
                this.optionName_ = XFUtility.RESOURCE.getString("LogOut");
                this.isLogoutOption = true;
            } else {
                this.optionName_ = optionName;
            }
        }

        public String getMenuOptionName() {
            return this.optionName_;
        }

        public boolean isLogoutOption() {
            return this.isLogoutOption;
        }

        public HashMap<String, Object> call() {
            if (this.isLogoutOption) {
                return null;
            }
            try {
                return Session.this.functionLauncher.execute(this.functionElement_.getAttribute("ID"), new HashMap<String, Object>());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
                return null;
            }
        }
    }
}

