/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import xeadDriver.XF100;
import xeadDriver.XF100_Column;
import xeadDriver.XFUtility;

class XF100_ReferTable {
    private Element referElement_ = null;
    private Element tableElement = null;
    private String tableID = "";
    private String tableAlias = "";
    private ArrayList<String> fieldIDList = new ArrayList();
    private ArrayList<String> toKeyFieldIDList = new ArrayList();
    private ArrayList<String> withKeyFieldIDList = new ArrayList();
    private XF100 dialog_;
    private boolean isToBeExecuted = false;
    private String dbName = "";

    public XF100_ReferTable(Element referElement, XF100 dialog) {
        this.referElement_ = referElement;
        this.tableID = this.referElement_.getAttribute("ToTable");
        this.tableAlias = this.referElement_.getAttribute("TableAlias");
        if (this.tableAlias.equals("")) {
            this.tableAlias = this.tableID;
        }
        this.dialog_ = dialog;
        this.tableElement = this.dialog_.getSession().getTableElement(this.tableID);
        String dbID = this.tableElement.getAttribute("DB");
        this.dbName = dbID.equals("") ? this.dialog_.getSession().getDatabaseName() : this.dialog_.getSession().getSubDBName(dbID);
        StringTokenizer workTokenizer = new StringTokenizer(this.referElement_.getAttribute("Fields"), ";");
        while (workTokenizer.hasMoreTokens()) {
            this.fieldIDList.add(workTokenizer.nextToken());
        }
        if (this.referElement_.getAttribute("ToKeyFields").equals("")) {
            Element workElement = this.dialog_.getSession().getTablePKElement(this.tableID);
            workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
            while (workTokenizer.hasMoreTokens()) {
                this.toKeyFieldIDList.add(workTokenizer.nextToken());
            }
        } else {
            workTokenizer = new StringTokenizer(this.referElement_.getAttribute("ToKeyFields"), ";");
            while (workTokenizer.hasMoreTokens()) {
                this.toKeyFieldIDList.add(workTokenizer.nextToken());
            }
        }
        workTokenizer = new StringTokenizer(this.referElement_.getAttribute("WithKeyFields"), ";");
        while (workTokenizer.hasMoreTokens()) {
            this.withKeyFieldIDList.add(workTokenizer.nextToken());
        }
    }

    public String getSelectSQL() {
        StringBuffer buf = new StringBuffer();
        boolean validWhereKeys = false;
        buf.append("select ");
        int count = 0;
        int i = 0;
        while (i < this.fieldIDList.size()) {
            Element workElement = this.dialog_.getSession().getFieldElement(this.tableID, this.fieldIDList.get(i));
            if (!XFUtility.getOptionList(workElement.getAttribute("TypeOptions")).contains("VIRTUAL")) {
                if (count > 0) {
                    buf.append(",");
                }
                ++count;
                buf.append(this.fieldIDList.get(i));
            }
            ++i;
        }
        if (count == 0) {
            i = 0;
            while (i < this.toKeyFieldIDList.size()) {
                if (count > 0) {
                    buf.append(",");
                }
                ++count;
                buf.append(this.toKeyFieldIDList.get(i));
                ++i;
            }
        }
        buf.append(" from ");
        buf.append(this.tableID);
        buf.append(" where ");
        count = 0;
        int i2 = 0;
        while (i2 < this.toKeyFieldIDList.size()) {
            if (count > 0) {
                buf.append(" and ");
            }
            buf.append(this.toKeyFieldIDList.get(i2));
            buf.append("=");
            StringTokenizer workTokenizer = new StringTokenizer(this.withKeyFieldIDList.get(i2), ".");
            String workTableAlias = workTokenizer.nextToken();
            String workFieldID = workTokenizer.nextToken();
            XF100_Column column = this.dialog_.getColumnObjectByID("", workTableAlias, workFieldID);
            if (column == null) {
                JOptionPane.showMessageDialog(null, String.valueOf(this.withKeyFieldIDList.get(i2)) + XFUtility.RESOURCE.getString("FunctionError11"));
            }
            buf.append(XFUtility.getTableOperationValue(column.getBasicType(), column.getInternalValue(), this.dbName));
            if (!column.getInternalValue().equals("")) {
                validWhereKeys = true;
            }
            ++count;
            ++i2;
        }
        if (validWhereKeys) {
            return buf.toString();
        }
        return "";
    }

    public String getTableID() {
        return this.tableID;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public ArrayList<String> getWithKeyFieldIDList() {
        return this.withKeyFieldIDList;
    }

    public ArrayList<String> getFieldIDList() {
        return this.fieldIDList;
    }

    public void setToBeExecuted(boolean executed) {
        this.isToBeExecuted = executed;
    }

    public boolean isToBeExecuted() {
        return this.isToBeExecuted;
    }
}

