/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF110_SubList;
import xeadDriver.XF110_SubListBatchReferTable;
import xeadDriver.XF110_SubListDetailReferTable;
import xeadDriver.XF110_SubListDetailRowNumber;
import xeadDriver.XFHashMap;
import xeadDriver.XFScript;
import xeadDriver.XFUtility;

class XF110_SubListBatchTable {
    private Element tableElement = null;
    private String tableID = "";
    private ArrayList<String> keyFieldIDList = new ArrayList();
    private ArrayList<XFScript> scriptList = new ArrayList();
    private ArrayList<XFHashMap> keyMapList = new ArrayList();
    private ArrayList<String> uniqueKeyList = new ArrayList();
    private XF110_SubList dialog_;
    private StringTokenizer workTokenizer;
    private String dbName = "";

    public XF110_SubListBatchTable(Element functionElement, XF110_SubList dialog) {
        this.dialog_ = dialog;
        this.tableID = functionElement.getAttribute("BatchTable");
        this.tableElement = this.dialog_.getSession().getTableElement(this.tableID);
        String dbID = this.tableElement.getAttribute("DB");
        this.dbName = dbID.equals("") ? this.dialog_.getSession().getDatabaseName() : this.dialog_.getSession().getSubDBName(dbID);
        NodeList nodeList = this.tableElement.getElementsByTagName("Key");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element workElement = (Element)nodeList.item(i);
            if (workElement.getAttribute("Type").equals("PK")) {
                this.workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                while (this.workTokenizer.hasMoreTokens()) {
                    String workString = this.workTokenizer.nextToken();
                    this.keyFieldIDList.add(workString);
                }
            }
            if (workElement.getAttribute("Type").equals("SK")) {
                this.uniqueKeyList.add(workElement.getAttribute("Fields"));
            }
            ++i;
        }
        NodeList workList = this.tableElement.getElementsByTagName("Script");
        SortableDomElementListModel sortList = XFUtility.getSortedListModel(workList, "Order");
        int i2 = 0;
        while (i2 < sortList.size()) {
            Element element = (Element)sortList.getElementAt(i2);
            this.scriptList.add(new XFScript(this.tableID, element, this.dialog_.getSession().getTableNodeList()));
            ++i2;
        }
    }

    public String getSQLToInsert(XF110_SubListDetailRowNumber rowNumber) {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("insert into ");
        statementBuf.append(this.tableID);
        statementBuf.append(" (");
        int i = 0;
        while (i < this.dialog_.getBatchFieldList().size()) {
            if (this.dialog_.getBatchFieldList().get(i).isFieldOnBatchTable()) {
                if (this.dialog_.getBatchFieldList().get(i).isAutoNumberField()) {
                    this.dialog_.getBatchFieldList().get(i).setValue(this.dialog_.getBatchFieldList().get(i).getAutoNumber());
                } else {
                    int index = this.dialog_.getBatchKeyList().indexOf(this.dialog_.getBatchFieldList().get(i).getFieldID());
                    if (index > -1) {
                        this.dialog_.getBatchFieldList().get(i).setValue(rowNumber.getColumnValueMap().get(this.dialog_.getBatchWithKeyList().get(index)));
                    }
                }
            }
            ++i;
        }
        boolean firstField = true;
        int i2 = 0;
        while (i2 < this.dialog_.getBatchFieldList().size()) {
            if (this.dialog_.getBatchFieldList().get(i2).isFieldOnBatchTable() && !this.dialog_.getBatchFieldList().get(i2).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(", ");
                }
                statementBuf.append(this.dialog_.getBatchFieldList().get(i2).getFieldID());
                firstField = false;
            }
            ++i2;
        }
        statementBuf.append(") values(");
        XFHashMap keyMap = new XFHashMap();
        firstField = true;
        int i3 = 0;
        while (i3 < this.dialog_.getBatchFieldList().size()) {
            if (this.dialog_.getBatchFieldList().get(i3).isFieldOnBatchTable() && !this.dialog_.getBatchFieldList().get(i3).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(", ");
                }
                statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getBatchFieldList().get(i3).getBasicType(), this.dialog_.getBatchFieldList().get(i3).getInternalValue(), this.dbName));
                if (this.dialog_.getBatchFieldList().get(i3).isKey()) {
                    keyMap.addValue(this.dialog_.getBatchFieldList().get(i3).getFieldID(), this.dialog_.getBatchFieldList().get(i3).getInternalValue());
                }
                firstField = false;
            }
            ++i3;
        }
        this.keyMapList.add(keyMap);
        statementBuf.append(")");
        return statementBuf.toString();
    }

    public ArrayList<String> getUniqueKeyList() {
        return this.uniqueKeyList;
    }

    public String getSQLToCheckSKDuplication(ArrayList<String> keyFieldList) {
        StringBuffer statementBuf = new StringBuffer();
        statementBuf.append("select ");
        boolean firstField = true;
        int i = 0;
        while (i < this.dialog_.getBatchFieldList().size()) {
            if (this.dialog_.getBatchFieldList().get(i).isFieldOnBatchTable() && !this.dialog_.getBatchFieldList().get(i).isVirtualField()) {
                if (!firstField) {
                    statementBuf.append(",");
                }
                statementBuf.append(this.dialog_.getBatchFieldList().get(i).getFieldID());
                firstField = false;
            }
            ++i;
        }
        statementBuf.append(" from ");
        statementBuf.append(this.tableID);
        statementBuf.append(" where ");
        firstField = true;
        int j = 0;
        while (j < this.dialog_.getBatchFieldList().size()) {
            if (this.dialog_.getBatchFieldList().get(j).isFieldOnBatchTable()) {
                int p = 0;
                while (p < keyFieldList.size()) {
                    if (this.dialog_.getBatchFieldList().get(j).getFieldID().equals(keyFieldList.get(p))) {
                        if (!firstField) {
                            statementBuf.append(" and ");
                        }
                        statementBuf.append(this.dialog_.getBatchFieldList().get(j).getFieldID());
                        statementBuf.append("=");
                        statementBuf.append(XFUtility.getTableOperationValue(this.dialog_.getBatchFieldList().get(j).getBasicType(), this.dialog_.getBatchFieldList().get(j).getInternalValue(), this.dbName));
                        firstField = false;
                    }
                    ++p;
                }
            }
            ++j;
        }
        return statementBuf.toString();
    }

    public String getTableID() {
        return this.tableID;
    }

    public Element getTableElement() {
        return this.tableElement;
    }

    public ArrayList<String> getKeyFieldIDList() {
        return this.keyFieldIDList;
    }

    public ArrayList<XFHashMap> getKeyMapList() {
        return this.keyMapList;
    }

    public ArrayList<XFScript> getScriptList() {
        return this.scriptList;
    }

    public boolean isValidDataSource(String tableID, String tableAlias, String fieldID) {
        boolean isValid;
        block15: {
            int j;
            block16: {
                isValid = false;
                if (!this.getTableID().equals(tableID) || !this.getTableID().equals(tableAlias)) break block16;
                NodeList nodeList = this.tableElement.getElementsByTagName("Field");
                int i = 0;
                while (i < nodeList.getLength()) {
                    Element workElement = (Element)nodeList.item(i);
                    if (workElement.getAttribute("ID").equals(fieldID)) {
                        isValid = true;
                        break block15;
                    }
                    ++i;
                }
                break block15;
            }
            int i = 0;
            while (i < this.dialog_.getBatchReferTableList().size()) {
                XF110_SubListBatchReferTable referTable1 = this.dialog_.getBatchReferTableList().get(i);
                if (referTable1.getTableID().equals(tableID) && referTable1.getTableAlias().equals(tableAlias)) {
                    j = 0;
                    while (j < referTable1.getFieldIDList().size()) {
                        if (referTable1.getFieldIDList().get(j).equals(fieldID)) {
                            isValid = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (isValid) break;
                ++i;
            }
            if (isValid) break block15;
            if (this.dialog_.getDetailTable().getTableID().equals(tableID) && this.dialog_.getDetailTable().getTableID().equals(tableAlias)) {
                NodeList nodeList = this.dialog_.getDetailTable().getTableElement().getElementsByTagName("Field");
                int i2 = 0;
                while (i2 < nodeList.getLength()) {
                    Element workElement = (Element)nodeList.item(i2);
                    if (workElement.getAttribute("ID").equals(fieldID)) {
                        isValid = true;
                        break;
                    }
                    ++i2;
                }
            } else {
                i = 0;
                while (i < this.dialog_.getDetailReferTableList().size()) {
                    XF110_SubListDetailReferTable referTable2 = this.dialog_.getDetailReferTableList().get(i);
                    if (referTable2.getTableID().equals(tableID) && referTable2.getTableAlias().equals(tableAlias)) {
                        j = 0;
                        while (j < referTable2.getFieldIDList().size()) {
                            if (referTable2.getFieldIDList().get(j).equals(fieldID)) {
                                isValid = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!isValid) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        return isValid;
    }

    public int runScript(String event1, String event2) throws ScriptException {
        int countOfErrors = 0;
        ArrayList<XFScript> validScriptList = new ArrayList<XFScript>();
        int i = 0;
        while (i < this.scriptList.size()) {
            XFScript script = this.scriptList.get(i);
            if (script.isToBeRunAtEvent(event1, event2)) {
                validScriptList.add(script);
            }
            ++i;
        }
        if (validScriptList.size() > 0) {
            i = 0;
            while (i < validScriptList.size()) {
                this.dialog_.evalScript(((XFScript)validScriptList.get(i)).getName(), ((XFScript)validScriptList.get(i)).getScriptText());
                ++i;
            }
            i = 0;
            while (i < this.dialog_.getBatchFieldList().size()) {
                if (this.dialog_.getBatchFieldList().get(i).isError()) {
                    ++countOfErrors;
                }
                ++i;
            }
        }
        return countOfErrors;
    }
}

