/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import xeadDriver.XF110_SubList;
import xeadDriver.XFTableColumnEditor;
import xeadDriver.XFUtility;

class XF110_SubListCellEditorWithYMonthBox
extends JPanel
implements XFTableColumnEditor {
    private static final long serialVersionUID = 1L;
    private JTextField jTextFieldYear = new JTextField();
    private JComboBox<String> jComboBoxMonth = new JComboBox();
    private ArrayList<String> listMonth = new ArrayList();
    private JLabel jLabel = new JLabel();
    private boolean isEditable_ = true;
    private XF110_SubList dialog_ = null;

    public XF110_SubListCellEditorWithYMonthBox(XF110_SubList dialog) {
        this.dialog_ = dialog;
        this.jTextFieldYear.setEditable(true);
        this.jTextFieldYear.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jTextFieldYear.setDocument(new LimitedDocument());
        this.jComboBoxMonth.setEditable(false);
        this.jComboBoxMonth.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jComboBoxMonth.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                XF110_SubListCellEditorWithYMonthBox.this.dialog_.getCellsEditor().updateRowObject();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            }
        });
        this.listMonth.add("");
        this.listMonth.add("01");
        this.listMonth.add("02");
        this.listMonth.add("03");
        this.listMonth.add("04");
        this.listMonth.add("05");
        this.listMonth.add("06");
        this.listMonth.add("07");
        this.listMonth.add("08");
        this.listMonth.add("09");
        this.listMonth.add("10");
        this.listMonth.add("11");
        this.listMonth.add("12");
        String language = this.dialog_.getSession().getDateFormat().substring(0, 2);
        if (language.equals("en")) {
            this.jComboBoxMonth.setBounds(new Rectangle(0, 0, 65, 29));
            this.jTextFieldYear.setBounds(new Rectangle(66, 0, 54, 29));
            this.jComboBoxMonth.addItem("");
            this.jComboBoxMonth.addItem("Jan");
            this.jComboBoxMonth.addItem("Feb");
            this.jComboBoxMonth.addItem("Mar");
            this.jComboBoxMonth.addItem("Apr");
            this.jComboBoxMonth.addItem("May");
            this.jComboBoxMonth.addItem("Jun");
            this.jComboBoxMonth.addItem("Jul");
            this.jComboBoxMonth.addItem("Aug");
            this.jComboBoxMonth.addItem("Sep");
            this.jComboBoxMonth.addItem("Oct");
            this.jComboBoxMonth.addItem("Nov");
            this.jComboBoxMonth.addItem("Dec");
        }
        if (language.equals("jp")) {
            this.jTextFieldYear.setBounds(new Rectangle(0, 0, 54, 29));
            this.jComboBoxMonth.setBounds(new Rectangle(55, 0, 65, 29));
            this.jComboBoxMonth.addItem("");
            this.jComboBoxMonth.addItem("01");
            this.jComboBoxMonth.addItem("02");
            this.jComboBoxMonth.addItem("03");
            this.jComboBoxMonth.addItem("04");
            this.jComboBoxMonth.addItem("05");
            this.jComboBoxMonth.addItem("06");
            this.jComboBoxMonth.addItem("07");
            this.jComboBoxMonth.addItem("08");
            this.jComboBoxMonth.addItem("09");
            this.jComboBoxMonth.addItem("10");
            this.jComboBoxMonth.addItem("11");
            this.jComboBoxMonth.addItem("12");
        }
        this.jLabel.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
        this.jLabel.setBackground(SystemColor.control);
        this.jLabel.setBounds(new Rectangle(0, 0, 120, 29));
        this.setSize(new Dimension(120, 29));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                XF110_SubListCellEditorWithYMonthBox.this.dialog_.getCellsEditor().updateActiveColumnIndex();
                XF110_SubListCellEditorWithYMonthBox.this.jTextFieldYear.setBackground(Color.cyan);
                XF110_SubListCellEditorWithYMonthBox.this.jComboBoxMonth.setBackground(Color.cyan);
            }

            @Override
            public void focusLost(FocusEvent e) {
                XF110_SubListCellEditorWithYMonthBox.this.jTextFieldYear.setBackground(SystemColor.text);
                XF110_SubListCellEditorWithYMonthBox.this.jComboBoxMonth.setBackground(SystemColor.text);
            }
        });
        this.setLayout(null);
        this.add(this.jTextFieldYear);
        this.add(this.jComboBoxMonth);
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        this.jLabel.setHorizontalAlignment(alignment);
    }

    @Override
    public void setEditable(boolean isEditable) {
        this.isEditable_ = isEditable;
        this.removeAll();
        if (isEditable) {
            this.add(this.jTextFieldYear);
            this.add(this.jComboBoxMonth);
        } else {
            this.add(this.jLabel);
        }
    }

    @Override
    public boolean isEditable() {
        return this.isEditable_;
    }

    @Override
    public Object getInternalValue() {
        String value = "";
        try {
            if (!this.jTextFieldYear.getText().equals("") && this.jComboBoxMonth.getSelectedIndex() > 0) {
                int workInt = Integer.parseInt(this.jTextFieldYear.getText());
                value = String.valueOf(Integer.toString(workInt)) + this.listMonth.get(this.jComboBoxMonth.getSelectedIndex());
                value = "000" + value;
                value = value.substring(value.length() - 6, value.length());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public Object getExternalValue() {
        return this.getInternalValue();
    }

    @Override
    public void setValue(Object obj) {
        this.jTextFieldYear.setText("");
        this.jComboBoxMonth.setSelectedIndex(0);
        this.jLabel.setText("");
        String value = (String)obj;
        if (value != null) {
            value = value.trim();
        }
        if (value != null && !value.equals("") && value.length() == 6) {
            String yearValue = value.substring(0, 4);
            String monthValue = value.substring(4, 6);
            this.jTextFieldYear.setText(yearValue);
            int index = this.listMonth.indexOf(monthValue);
            if (index == -1) {
                this.jComboBoxMonth.setSelectedIndex(0);
            } else {
                this.jComboBoxMonth.setSelectedIndex(index);
            }
            this.jLabel.setText(XFUtility.getUserExpressionOfYearMonth(value, this.dialog_.getSession().getDateFormat()));
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.jTextFieldYear != null && this.jComboBoxMonth != null) {
            this.jTextFieldYear.setBackground(color);
            this.jComboBoxMonth.setBackground(color);
        }
    }

    @Override
    public void setColorOfError() {
        this.jTextFieldYear.setBackground(XFUtility.ERROR_COLOR);
        this.jComboBoxMonth.setBackground(XFUtility.ERROR_COLOR);
    }

    @Override
    public void setColorOfNormal(int row) {
        if (this.isEditable()) {
            if (row % 2 == 0) {
                this.jTextFieldYear.setBackground(SystemColor.text);
                this.jComboBoxMonth.setBackground(SystemColor.text);
            } else {
                this.jTextFieldYear.setBackground(XFUtility.ODD_ROW_COLOR);
                this.jComboBoxMonth.setBackground(XFUtility.ODD_ROW_COLOR);
            }
        } else {
            this.jTextFieldYear.setBackground(SystemColor.control);
            this.jComboBoxMonth.setBackground(SystemColor.control);
        }
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        LimitedDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) {
            try {
                String preStr = XF110_SubListCellEditorWithYMonthBox.this.jTextFieldYear.getText();
                int workInt = Integer.parseInt(String.valueOf(preStr) + str);
                if (workInt >= 0 && workInt <= 9999) {
                    super.insertString(offset, str, attr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

