/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import org.w3c.dom.NodeList;
import xeadDriver.Session;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF290_Field;
import xeadDriver.XF290_Phrase;
import xeadDriver.XF290_PrimaryTable;
import xeadDriver.XF290_ReferTable;
import xeadDriver.XFExecutable;
import xeadDriver.XFScriptable;
import xeadDriver.XFTableEvaluator;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

public class XF290
extends Component
implements XFExecutable,
XFScriptable {
    private static final long serialVersionUID = 1L;
    private org.w3c.dom.Element functionElement_ = null;
    private HashMap<String, Object> parmMap_ = null;
    private HashMap<String, Object> returnMap_ = new HashMap();
    private XF290_PrimaryTable primaryTable_ = null;
    private Session session_ = null;
    private boolean instanceIsAvailable_ = true;
    private boolean isClosing = false;
    private int programSequence;
    private StringBuffer processLog = new StringBuffer();
    private ArrayList<XF290_Phrase> headerPhraseList = new ArrayList();
    private ArrayList<XF290_Phrase> paragraphList = new ArrayList();
    private ArrayList<XF290_ReferTable> referTableList = new ArrayList();
    private ArrayList<XF290_Field> fieldList = new ArrayList();
    private ScriptEngine scriptEngine;
    private Bindings scriptBindings;
    private String scriptNameRunning = "";
    private ByteArrayOutputStream exceptionLog;
    private PrintStream exceptionStream;
    private String exceptionHeader = "";
    private HashMap<String, Object> variantMap = new HashMap();

    public XF290(Session session, int instanceArrayIndex) {
        this.session_ = session;
    }

    @Override
    public boolean isAvailable() {
        return this.instanceIsAvailable_;
    }

    @Override
    public HashMap<String, Object> execute(HashMap<String, Object> parmMap) {
        if (this.functionElement_ == null) {
            JOptionPane.showMessageDialog(null, "Calling function without specifications.");
            return parmMap;
        }
        return this.execute(null, parmMap);
    }

    @Override
    public HashMap<String, Object> execute(org.w3c.dom.Element functionElement, HashMap<String, Object> parmMap) {
        block8: {
            try {
                try {
                    this.setCursor(new Cursor(3));
                    this.parmMap_ = parmMap;
                    if (this.parmMap_ == null) {
                        this.parmMap_ = new HashMap();
                    }
                    this.returnMap_.clear();
                    this.returnMap_.putAll(this.parmMap_);
                    this.returnMap_.put("RETURN_CODE", "00");
                    this.instanceIsAvailable_ = false;
                    this.isClosing = false;
                    this.exceptionLog = new ByteArrayOutputStream();
                    this.exceptionStream = new PrintStream(this.exceptionLog);
                    this.exceptionHeader = "";
                    this.processLog.delete(0, this.processLog.length());
                    this.variantMap.clear();
                    if (!(functionElement == null || this.functionElement_ != null && this.functionElement_.getAttribute("ID").equals(functionElement.getAttribute("ID")))) {
                        this.setFunctionSpecifications(functionElement);
                    }
                    this.fetchTableRecord();
                    if (!this.isClosing) {
                        this.session_.browseFile(this.createPDFFileAndGetURI());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("FunctionError5"));
                    e.printStackTrace(this.exceptionStream);
                    this.setErrorAndCloseFunction();
                    this.setCursor(new Cursor(0));
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.setCursor(new Cursor(0));
                throw throwable;
            }
            this.setCursor(new Cursor(0));
        }
        this.closeFunction();
        return this.returnMap_;
    }

    @Override
    public void setFunctionSpecifications(org.w3c.dom.Element functionElement) throws Exception {
        String workFieldID;
        String workTableID;
        String workAlias;
        StringTokenizer workTokenizer;
        int j;
        this.functionElement_ = functionElement;
        this.programSequence = this.session_.writeLogOfFunctionStarted(this.functionElement_.getAttribute("ID"), this.functionElement_.getAttribute("Name"));
        this.primaryTable_ = new XF290_PrimaryTable(this.functionElement_, this);
        this.referTableList.clear();
        NodeList referNodeList = this.primaryTable_.getTableElement().getElementsByTagName("Refer");
        SortableDomElementListModel sortedList = XFUtility.getSortedListModel(referNodeList, "Order");
        int i = 0;
        while (i < sortedList.getSize()) {
            org.w3c.dom.Element element = (org.w3c.dom.Element)sortedList.getElementAt(i);
            this.referTableList.add(new XF290_ReferTable(element, this));
            ++i;
        }
        this.headerPhraseList.clear();
        this.fieldList.clear();
        this.paragraphList.clear();
        NodeList nodeList = this.functionElement_.getElementsByTagName("Phrase");
        SortableDomElementListModel sortableList = XFUtility.getSortedListModel(nodeList, "Order");
        int i2 = 0;
        while (i2 < sortableList.getSize()) {
            XF290_Phrase phrase = new XF290_Phrase((org.w3c.dom.Element)sortableList.getElementAt(i2));
            if (phrase.getBlock().equals("HEADER")) {
                this.headerPhraseList.add(phrase);
            }
            if (phrase.getBlock().equals("PARAGRAPH")) {
                this.paragraphList.add(phrase);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.headerPhraseList.size()) {
            j = 0;
            while (j < this.headerPhraseList.get(i2).getDataSourceNameList().size()) {
                if (!this.existsInFieldList(this.headerPhraseList.get(i2).getDataSourceNameList().get(j))) {
                    this.fieldList.add(new XF290_Field(this.headerPhraseList.get(i2).getDataSourceNameList().get(j), this));
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.paragraphList.size()) {
            j = 0;
            while (j < this.paragraphList.get(i2).getDataSourceNameList().size()) {
                if (!this.existsInFieldList(this.paragraphList.get(i2).getDataSourceNameList().get(j))) {
                    this.fieldList.add(new XF290_Field(this.paragraphList.get(i2).getDataSourceNameList().get(j), this));
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.primaryTable_.getKeyFieldList().size()) {
            if (!this.existsInFieldList(this.primaryTable_.getTableID(), "", this.primaryTable_.getKeyFieldList().get(i2))) {
                this.fieldList.add(new XF290_Field(this.primaryTable_.getTableID(), "", this.primaryTable_.getKeyFieldList().get(i2), this));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.primaryTable_.getScriptList().size()) {
            if (this.primaryTable_.getScriptList().get(i2).isToBeRunAtEvent("BR", "") || this.primaryTable_.getScriptList().get(i2).isToBeRunAtEvent("AR", "")) {
                j = 0;
                while (j < this.primaryTable_.getScriptList().get(i2).getFieldList().size()) {
                    workTokenizer = new StringTokenizer(this.primaryTable_.getScriptList().get(i2).getFieldList().get(j), ".");
                    workAlias = workTokenizer.nextToken();
                    workTableID = this.getTableIDOfTableAlias(workAlias);
                    if (!this.existsInFieldList(workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                        org.w3c.dom.Element workElement = this.session_.getFieldElement(workTableID, workFieldID);
                        if (workElement == null) {
                            String msg = String.valueOf(XFUtility.RESOURCE.getString("FunctionError1")) + this.primaryTable_.getTableID() + XFUtility.RESOURCE.getString("FunctionError2") + this.primaryTable_.getScriptList().get(i2).getName() + XFUtility.RESOURCE.getString("FunctionError3") + workAlias + "_" + workFieldID + XFUtility.RESOURCE.getString("FunctionError4");
                            JOptionPane.showMessageDialog(null, msg);
                            throw new Exception(msg);
                        }
                        if (this.primaryTable_.isValidDataSource(workTableID, workAlias, workFieldID)) {
                            this.fieldList.add(new XF290_Field(workTableID, workAlias, workFieldID, this));
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.fieldList.size()) {
            if (this.fieldList.get(i2).getBasicType().equals("BYTEA") && !this.fieldList.get(i2).getByteaTypeFieldID().equals("") && !this.existsInFieldList(this.primaryTable_.getTableID(), "", this.fieldList.get(i2).getByteaTypeFieldID())) {
                this.fieldList.add(new XF290_Field(this.primaryTable_.getTableID(), "", this.fieldList.get(i2).getByteaTypeFieldID(), this));
            }
            ++i2;
        }
        i2 = this.referTableList.size() - 1;
        while (i2 > -1) {
            j = 0;
            while (j < this.referTableList.get(i2).getFieldIDList().size()) {
                if (this.existsInFieldList(this.referTableList.get(i2).getTableID(), this.referTableList.get(i2).getTableAlias(), this.referTableList.get(i2).getFieldIDList().get(j))) {
                    this.referTableList.get(i2).setToBeExecuted(true);
                    break;
                }
                ++j;
            }
            if (this.referTableList.get(i2).isToBeExecuted()) {
                j = 0;
                while (j < this.referTableList.get(i2).getFieldIDList().size()) {
                    if (!this.existsInFieldList(this.referTableList.get(i2).getTableID(), this.referTableList.get(i2).getTableAlias(), this.referTableList.get(i2).getFieldIDList().get(j))) {
                        this.fieldList.add(new XF290_Field(this.referTableList.get(i2).getTableID(), this.referTableList.get(i2).getTableAlias(), this.referTableList.get(i2).getFieldIDList().get(j), this));
                    }
                    ++j;
                }
                j = 0;
                while (j < this.referTableList.get(i2).getWithKeyFieldIDList().size()) {
                    workTokenizer = new StringTokenizer(this.referTableList.get(i2).getWithKeyFieldIDList().get(j), ".");
                    workAlias = workTokenizer.nextToken();
                    workTableID = this.getTableIDOfTableAlias(workAlias);
                    if (!this.existsInFieldList(workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                        this.fieldList.add(new XF290_Field(workTableID, workAlias, workFieldID, this));
                    }
                    ++j;
                }
            }
            --i2;
        }
        this.scriptEngine = this.session_.getScriptEngineManager().getEngineByName("js");
        this.scriptBindings = this.scriptEngine.createBindings();
        this.scriptBindings.put("instance", (Object)this);
        i2 = 0;
        while (i2 < this.fieldList.size()) {
            this.scriptBindings.put(this.fieldList.get(i2).getDataSourceID(), (Object)this.fieldList.get(i2));
            ++i2;
        }
    }

    @Override
    public void setErrorAndCloseFunction() {
        this.returnMap_.put("RETURN_CODE", "99");
        this.rollback();
        this.closeFunction();
    }

    void closeFunction() {
        if (!this.returnMap_.get("RETURN_CODE").equals("99")) {
            this.commit();
        }
        this.instanceIsAvailable_ = true;
        String errorLog = "";
        if (this.exceptionLog.size() > 0 || !this.exceptionHeader.equals("")) {
            errorLog = String.valueOf(this.exceptionHeader) + this.exceptionLog.toString();
        }
        this.session_.writeLogOfFunctionClosed(this.programSequence, this.returnMap_.get("RETURN_CODE").toString(), this.processLog.toString(), errorLog);
    }

    @Override
    public void cancelWithMessage(String message) {
        if (!message.equals("")) {
            JOptionPane.showMessageDialog(null, message);
        }
        this.returnMap_.put("RETURN_CODE", "01");
        this.isClosing = true;
    }

    @Override
    public void cancelWithScriptException(ScriptException e, String scriptName) {
        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError7")) + scriptName + XFUtility.RESOURCE.getString("FunctionError8"));
        this.exceptionHeader = "'" + scriptName + "' Script error\n";
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.setErrorAndCloseFunction();
    }

    @Override
    public void cancelWithException(Exception e) {
        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError5")) + "\n" + e.getMessage());
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.setErrorAndCloseFunction();
    }

    @Override
    public void callFunction(String functionID) {
        try {
            this.returnMap_ = this.session_.executeFunction(functionID, this.parmMap_);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            this.exceptionHeader = e.getMessage();
            this.setErrorAndCloseFunction();
        }
    }

    @Override
    public void setStatusMessage(String message) {
        this.setStatusMessage(message, false);
    }

    @Override
    public void setStatusMessage(String message, boolean isToReplaceLastLine) {
    }

    @Override
    public void startProgress(String text, int maxValue) {
    }

    @Override
    public void incrementProgress() {
    }

    @Override
    public void endProgress() {
    }

    @Override
    public void commit() {
        this.session_.commit(true, this.processLog);
    }

    @Override
    public void rollback() {
        this.session_.commit(false, this.processLog);
    }

    /*
     * Loose catch block
     */
    private URI createPDFFileAndGetURI() {
        File pdfFile;
        block18: {
            pdfFile = null;
            String pdfFileName = "";
            FileOutputStream fileOutputStream = null;
            float leftMargin = 50.0f;
            float rightMargin = 50.0f;
            float topMargin = 50.0f;
            float bottomMargin = 50.0f;
            StringTokenizer workTokenizer = new StringTokenizer(this.functionElement_.getAttribute("Margins"), ";");
            try {
                leftMargin = Float.parseFloat(workTokenizer.nextToken());
                rightMargin = Float.parseFloat(workTokenizer.nextToken());
                topMargin = Float.parseFloat(workTokenizer.nextToken());
                bottomMargin = Float.parseFloat(workTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Rectangle pageSize = XFUtility.getPageSize(this.functionElement_.getAttribute("PageSize"), this.functionElement_.getAttribute("Direction"));
            Document pdfDoc = new Document(pageSize, leftMargin, rightMargin, topMargin, bottomMargin);
            try {
                pdfFile = this.session_.createTempFile(this.functionElement_.getAttribute("ID"), ".pdf");
                pdfFileName = pdfFile.getPath();
                this.returnMap_.put("FILE_NAME", pdfFileName);
                fileOutputStream = new FileOutputStream(pdfFileName);
                PdfWriter writer = PdfWriter.getInstance((Document)pdfDoc, (OutputStream)fileOutputStream);
                pdfDoc.addTitle(this.functionElement_.getAttribute("Name"));
                pdfDoc.addAuthor(this.session_.getUserName());
                pdfDoc.addCreator("XEAD Driver");
                this.addHeaderToDocument(pdfDoc);
                if (this.functionElement_.getAttribute("WithPageNumber").equals("T")) {
                    HeaderFooter footer = new HeaderFooter(new Phrase("--"), new Phrase("--"));
                    footer.setAlignment(1);
                    footer.setBorder(0);
                    pdfDoc.setFooter(footer);
                }
                pdfDoc.open();
                PdfContentByte cb = writer.getDirectContent();
                Paragraph paragraph = null;
                String keyword = "";
                int i = 0;
                while (i < this.paragraphList.size()) {
                    if (this.paragraphList.get(i).getBlock().equals("PARAGRAPH")) {
                        paragraph = new Paragraph(new Phrase(""));
                        paragraph.setAlignment(this.paragraphList.get(i).getAlignment());
                        paragraph.setIndentationRight(this.paragraphList.get(i).getMarginRight());
                        paragraph.setIndentationLeft(this.paragraphList.get(i).getMarginLeft());
                        paragraph.setSpacingAfter(this.paragraphList.get(i).getSpacingAfter());
                        Font font = new Font(this.session_.getBaseFontWithID(this.paragraphList.get(i).getFontID()), (float)this.paragraphList.get(i).getFontSize(), this.paragraphList.get(i).getFontStyle());
                        Phrase phrase = new Phrase("", font);
                        int j = 0;
                        while (j < this.paragraphList.get(i).getValueKeywordList().size()) {
                            keyword = this.paragraphList.get(i).getValueKeywordList().get(j);
                            if ((keyword.contains("&Line(") || keyword.contains("&Rect(")) && cb != null) {
                                XFUtility.drawLineOrRect(keyword, cb);
                            } else {
                                Font chunkFont = new Font(this.session_.getBaseFontWithID(this.paragraphList.get(i).getFontID()), (float)this.paragraphList.get(i).getFontSize(), this.paragraphList.get(i).getFontStyle());
                                Chunk chunk = this.getChunkForKeyword(keyword, cb, chunkFont);
                                if (chunk != null) {
                                    phrase.add((Object)chunk);
                                }
                            }
                            ++j;
                        }
                        paragraph.add((Object)phrase);
                        pdfDoc.add((Element)paragraph);
                    }
                    ++i;
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
                pdfDoc.close();
                break block18;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block18;
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                pdfDoc.close();
                break block18;
            }
            {
                finally {
                    pdfDoc.close();
                }
            }
            pdfDoc.close();
        }
        return pdfFile.toURI();
    }

    private void addHeaderToDocument(Document pdfDoc) {
        Chunk chunk;
        Font chunkFont;
        Phrase phrase;
        Font font;
        if (this.headerPhraseList.size() == 1) {
            font = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(0).getFontID()), (float)this.headerPhraseList.get(0).getFontSize(), this.headerPhraseList.get(0).getFontStyle());
            phrase = new Phrase("", font);
            int i = 0;
            while (i < this.headerPhraseList.get(0).getValueKeywordList().size()) {
                chunkFont = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(0).getFontID()), (float)this.headerPhraseList.get(0).getFontSize(), this.headerPhraseList.get(0).getFontStyle());
                chunk = this.getChunkForKeyword(this.headerPhraseList.get(0).getValueKeywordList().get(i), null, chunkFont);
                if (chunk != null) {
                    phrase.add((Object)chunk);
                }
                ++i;
            }
            HeaderFooter header = new HeaderFooter(phrase, false);
            header.setAlignment(this.headerPhraseList.get(0).getAlignment());
            pdfDoc.setHeader(header);
        }
        if (this.headerPhraseList.size() > 1) {
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setBorder(0);
            int i = 0;
            while (i < this.headerPhraseList.size()) {
                font = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(i).getFontID()), (float)this.headerPhraseList.get(i).getFontSize(), this.headerPhraseList.get(i).getFontStyle());
                phrase = new Phrase("", font);
                int j = 0;
                while (j < this.headerPhraseList.get(i).getValueKeywordList().size()) {
                    chunkFont = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(i).getFontID()), (float)this.headerPhraseList.get(i).getFontSize(), this.headerPhraseList.get(i).getFontStyle());
                    chunk = this.getChunkForKeyword(this.headerPhraseList.get(i).getValueKeywordList().get(j), null, chunkFont);
                    if (chunk != null) {
                        phrase.add((Object)chunk);
                    }
                    ++j;
                }
                PdfPCell cell = new PdfPCell(table.getDefaultCell());
                cell.setHorizontalAlignment(this.headerPhraseList.get(i).getAlignment());
                cell.setPhrase(phrase);
                table.addCell(cell);
                ++i;
            }
            if (this.headerPhraseList.size() % 2 != 0) {
                phrase = new Phrase("");
                PdfPCell cell = new PdfPCell(table.getDefaultCell());
                cell.setPhrase(phrase);
                table.addCell(cell);
            }
            Paragraph paragraph = new Paragraph();
            paragraph.add((Object)table);
            HeaderFooter header = new HeaderFooter((Phrase)paragraph, false);
            header.setBorder(0);
            pdfDoc.setHeader(header);
        }
    }

    private Chunk getChunkForKeyword(String keyword, PdfContentByte cb, Font chunkFont) {
        Chunk chunk;
        block15: {
            String wrkStr = "";
            chunk = null;
            try {
                Image image;
                StringTokenizer workTokenizer;
                int h;
                int w;
                int y;
                int x;
                int pos;
                if (keyword.contains("&Text(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(keyword.substring(6, pos));
                }
                if (keyword.contains("&DataSource(")) {
                    pos = keyword.lastIndexOf(")");
                    wrkStr = this.getExternalStringValueOfFieldByName(keyword.substring(12, pos));
                    if (wrkStr.equals("")) {
                        wrkStr = " ";
                    }
                    chunkFont.setColor(this.getColorOfDataSource(keyword.substring(12, pos)));
                    chunk = new Chunk(wrkStr, chunkFont);
                }
                if (keyword.contains("&DataSourceImage(")) {
                    x = 0;
                    y = 0;
                    w = 0;
                    h = 0;
                    try {
                        pos = keyword.lastIndexOf(")");
                        workTokenizer = new StringTokenizer(keyword.substring(17, pos), ";");
                        wrkStr = workTokenizer.nextToken().trim();
                        x = Integer.parseInt(workTokenizer.nextToken().trim());
                        y = Integer.parseInt(workTokenizer.nextToken().trim());
                        w = Integer.parseInt(workTokenizer.nextToken().trim());
                        h = Integer.parseInt(workTokenizer.nextToken().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    image = XFUtility.getImageForPDF(String.valueOf(this.session_.getImageFileFolder()) + this.getExternalStringValueOfFieldByName(wrkStr), w, h);
                    chunk = new Chunk(image, (float)x, (float)y, true);
                }
                if (keyword.contains("&Barcode(") && cb != null) {
                    pos = keyword.lastIndexOf(")");
                    workTokenizer = new StringTokenizer(keyword.substring(9, pos), ";");
                    wrkStr = workTokenizer.nextToken().trim();
                    String type = "NW7";
                    if (workTokenizer.hasMoreTokens()) {
                        type = workTokenizer.nextToken().trim();
                    }
                    chunk = XFUtility.getBarcodeChunkOfValue(this.getExternalStringValueOfFieldByName(wrkStr), type, cb);
                }
                if (keyword.contains("&SystemVariant(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(this.session_.getSystemVariantString(keyword.substring(15, pos)));
                }
                if (keyword.contains("&DateTime(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(this.session_.getTodayTime(keyword.substring(10, pos)));
                }
                if (keyword.contains("&Date(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(this.session_.getToday(keyword.substring(6, pos)));
                }
                if (!keyword.contains("&Image(")) break block15;
                x = 0;
                y = 0;
                w = 0;
                h = 0;
                try {
                    pos = keyword.lastIndexOf(")");
                    workTokenizer = new StringTokenizer(keyword.substring(7, pos), ";");
                    wrkStr = workTokenizer.nextToken().trim();
                    x = Integer.parseInt(workTokenizer.nextToken().trim());
                    y = Integer.parseInt(workTokenizer.nextToken().trim());
                    w = Integer.parseInt(workTokenizer.nextToken().trim());
                    h = Integer.parseInt(workTokenizer.nextToken().trim());
                }
                catch (Exception type) {
                    // empty catch block
                }
                image = XFUtility.getImageForPDF(String.valueOf(this.session_.getImageFileFolder()) + wrkStr, w, h);
                chunk = new Chunk(image, (float)x, (float)y, true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError39")) + keyword + XFUtility.RESOURCE.getString("FunctionError40") + e.toString());
            }
        }
        return chunk;
    }

    void fetchTableRecord() {
        try {
            int i = 0;
            while (i < this.fieldList.size()) {
                if (this.parmMap_.containsKey(this.fieldList.get(i).getDataSourceName())) {
                    this.fieldList.get(i).setValue(this.parmMap_.get(this.fieldList.get(i).getDataSourceName()));
                } else if (this.parmMap_.containsKey(this.fieldList.get(i).getFieldID())) {
                    this.fieldList.get(i).setValue(this.parmMap_.get(this.fieldList.get(i).getFieldID()));
                }
                ++i;
            }
            this.primaryTable_.runScript("BR", "");
            XFTableOperator operator = this.createTableOperator(this.primaryTable_.getSQLToSelect());
            if (operator.next()) {
                int i2 = 0;
                while (i2 < this.fieldList.size()) {
                    if (this.fieldList.get(i2).getTableAlias().equals(this.primaryTable_.getTableID())) {
                        this.fieldList.get(i2).setValueOfResultSet(operator);
                    }
                    ++i2;
                }
                this.fetchReferTableRecords("AR", "");
                i2 = 0;
                while (i2 < this.fieldList.size()) {
                    if (this.fieldList.get(i2).getBasicType().equals("BYTEA")) {
                        this.fieldList.get(i2).setupByteaTypeField(this.fieldList);
                    }
                    ++i2;
                }
            } else {
                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("FunctionError30"));
                this.returnMap_.put("RETURN_CODE", "01");
                this.isClosing = true;
            }
        }
        catch (ScriptException e) {
            this.cancelWithScriptException(e, this.getScriptNameRunning());
        }
        catch (Exception e) {
            this.cancelWithException(e);
        }
    }

    protected void fetchReferTableRecords(String event, String specificReferTable) {
        try {
            this.primaryTable_.runScript(event, "BR()");
            int i = 0;
            while (i < this.referTableList.size()) {
                if ((specificReferTable.equals("") || specificReferTable.equals(this.referTableList.get(i).getTableAlias())) && this.referTableList.get(i).isToBeExecuted()) {
                    XFTableOperator operator;
                    this.primaryTable_.runScript(event, "BR(" + this.referTableList.get(i).getTableAlias() + ")");
                    int j = 0;
                    while (j < this.fieldList.size()) {
                        if (this.fieldList.get(j).getTableAlias().equals(this.referTableList.get(i).getTableAlias())) {
                            this.fieldList.get(j).setValue(null);
                        }
                        ++j;
                    }
                    if (!(this.referTableList.get(i).isKeyNullable() && this.referTableList.get(i).isKeyNull() || !(operator = this.createTableOperator(this.referTableList.get(i).getSelectSQL(false))).next())) {
                        j = 0;
                        while (j < this.fieldList.size()) {
                            if (this.fieldList.get(j).getTableAlias().equals(this.referTableList.get(i).getTableAlias())) {
                                this.fieldList.get(j).setValueOfResultSet(operator);
                            }
                            ++j;
                        }
                        this.primaryTable_.runScript(event, "AR(" + this.referTableList.get(i).getTableAlias() + ")");
                    }
                }
                ++i;
            }
            this.primaryTable_.runScript(event, "AR()");
        }
        catch (ScriptException e) {
            this.cancelWithScriptException(e, this.getScriptNameRunning());
        }
        catch (Exception e) {
            this.cancelWithException(e);
        }
    }

    @Override
    public String getFunctionID() {
        return this.functionElement_.getAttribute("ID");
    }

    @Override
    public HashMap<String, Object> getParmMap() {
        return this.parmMap_;
    }

    @Override
    public String getUserValueOf(String dataSourceName) {
        return this.session_.getFilterValue(this.getFunctionID(), dataSourceName);
    }

    @Override
    public void setUserValueOf(String dataSourceName, Object value) {
        this.session_.setFilterValue(this.getFunctionID(), dataSourceName, value.toString());
    }

    @Override
    public void setProcessLog(String text) {
        XFUtility.appendLog(text, this.processLog);
    }

    @Override
    public StringBuffer getProcessLog() {
        return this.processLog;
    }

    @Override
    public Object getVariant(String variantID) {
        if (this.variantMap.containsKey(variantID)) {
            return this.variantMap.get(variantID);
        }
        return "";
    }

    @Override
    public void setVariant(String variantID, Object value) {
        this.variantMap.put(variantID, value);
    }

    @Override
    public XFTableOperator createTableOperator(String oparation, String tableID) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, oparation, tableID);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.setErrorAndCloseFunction();
        }
        return operator;
    }

    @Override
    public XFTableOperator createTableOperator(String sqlText) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, sqlText);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.setErrorAndCloseFunction();
        }
        return operator;
    }

    @Override
    public XFTableEvaluator createTableEvaluator(String tableID) {
        return new XFTableEvaluator(this, tableID);
    }

    @Override
    public HashMap<String, Object> getReturnMap() {
        return this.returnMap_;
    }

    public String getScriptNameRunning() {
        return this.scriptNameRunning;
    }

    @Override
    public Session getSession() {
        return this.session_;
    }

    @Override
    public PrintStream getExceptionStream() {
        return this.exceptionStream;
    }

    @Override
    public Object getFieldObjectByID(String tableID, String fieldID) {
        String id = String.valueOf(tableID) + "_" + fieldID;
        if (this.scriptBindings.containsKey(id)) {
            return this.scriptBindings.get(id);
        }
        JOptionPane.showMessageDialog(null, "Field object " + id + " is not found.");
        return null;
    }

    public void evalScript(String scriptName, String scriptText) throws ScriptException {
        if (!scriptText.equals("")) {
            this.scriptNameRunning = scriptName;
            StringBuffer bf = new StringBuffer();
            bf.append(scriptText);
            bf.append(this.session_.getScriptFunctions());
            this.scriptEngine.eval(bf.toString(), this.scriptBindings);
        }
    }

    @Override
    public void executeScript(String scriptText) {
        try {
            this.evalScript("Internal Script", scriptText);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XF290_PrimaryTable getPrimaryTable() {
        return this.primaryTable_;
    }

    public ArrayList<XF290_Field> getFieldList() {
        return this.fieldList;
    }

    public ArrayList<String> getKeyFieldList() {
        return this.primaryTable_.getKeyFieldList();
    }

    public ArrayList<XF290_ReferTable> getReferTableList() {
        return this.referTableList;
    }

    public boolean existsInFieldList(String tableID, String tableAlias, String fieldID) {
        boolean result = false;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (tableID.equals("") && this.fieldList.get(i).getTableAlias().equals(tableAlias) && this.fieldList.get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            if (tableAlias.equals("") && this.fieldList.get(i).getTableID().equals(tableID) && this.fieldList.get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            if (!tableID.equals("") && !tableAlias.equals("") && this.fieldList.get(i).getTableID().equals(tableID) && this.fieldList.get(i).getTableAlias().equals(tableAlias) && this.fieldList.get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean existsInFieldList(String dataSourceName) {
        boolean result = false;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceName().equals(dataSourceName)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public String getTableIDOfTableAlias(String tableAlias) {
        String tableID = tableAlias;
        int j = 0;
        while (j < this.referTableList.size()) {
            XF290_ReferTable referTable = this.referTableList.get(j);
            referTable.getTableAlias();
            if (referTable.getTableAlias().equals(tableAlias)) {
                tableID = referTable.getTableID();
                break;
            }
            ++j;
        }
        return tableID;
    }

    public Object getInternalValueOfFieldByName(String dataSourceName) {
        Object obj = null;
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceName().equals(dataSourceName)) {
                obj = this.fieldList.get(i).getInternalValue();
                break;
            }
            ++i;
        }
        return obj;
    }

    public String getExternalStringValueOfFieldByName(String dataSourceName) {
        String value = "";
        String fmt = "";
        StringTokenizer workTokenizer = new StringTokenizer(dataSourceName, ";");
        String wrkStr = workTokenizer.nextToken().trim();
        if (workTokenizer.hasMoreTokens()) {
            fmt = workTokenizer.nextToken().trim();
        }
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceName().equals(wrkStr)) {
                if (this.fieldList.get(i).isKubunField() || this.fieldList.get(i).getBasicType().equals("BYTEA")) {
                    value = this.fieldList.get(i).getExternalValue().toString();
                    break;
                }
                value = this.fieldList.get(i).getInternalValue().toString();
                String basicType = this.fieldList.get(i).getBasicType();
                if (basicType.equals("DATE")) {
                    if (fmt.equals("")) {
                        fmt = this.session_.getDateFormat();
                    }
                    wrkStr = value.toString().substring(0, 10);
                    value = XFUtility.getUserExpressionOfUtilDate(XFUtility.convertDateFromSqlToUtil(Date.valueOf(wrkStr)), fmt, false);
                }
                if (basicType.equals("INTEGER")) {
                    value = this.fieldList.get(i).getDataTypeOptionList().contains("NO_EDIT") || this.fieldList.get(i).getDataTypeOptionList().contains("ZERO_SUPPRESS") ? XFUtility.getFormattedIntegerValue(value.toString(), this.fieldList.get(i).getDataTypeOptionList(), this.fieldList.get(i).getDataSize()) : XFUtility.getEditValueOfLong(Long.parseLong(value), fmt, this.fieldList.get(i).getDataSize());
                }
                if (basicType.equals("FLOAT")) {
                    value = XFUtility.getEditValueOfDouble(Double.parseDouble(value), fmt, this.fieldList.get(i).getDecimalSize());
                }
                if (this.fieldList.get(i).getDataTypeOptionList().contains("YMONTH") || this.fieldList.get(i).getDataTypeOptionList().contains("FYEAR")) {
                    if (fmt.equals("")) {
                        fmt = this.session_.getDateFormat();
                    }
                    value = XFUtility.getUserExpressionOfYearMonth(value.toString(), fmt);
                }
                if (!this.fieldList.get(i).getDataTypeOptionList().contains("MSEQ") || (wrkStr = value.toString()).equals("")) break;
                value = XFUtility.getUserExpressionOfMSeq(Integer.parseInt(wrkStr), this.session_);
                break;
            }
            ++i;
        }
        return value;
    }

    public Color getColorOfDataSource(String dataSourceName) {
        Color color = Color.black;
        StringTokenizer workTokenizer = new StringTokenizer(dataSourceName, ";");
        String wrkStr = workTokenizer.nextToken().trim();
        int i = 0;
        while (i < this.fieldList.size()) {
            if (this.fieldList.get(i).getDataSourceName().equals(wrkStr)) {
                color = this.fieldList.get(i).getForeground();
                break;
            }
            ++i;
        }
        return color;
    }
}

