/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.w3c.dom.Element;
import xeadDriver.XF300;
import xeadDriver.XF300_DetailColumn;
import xeadDriver.XF300_DetailReferTable;
import xeadDriver.XF300_PromptCallField;
import xeadDriver.XF300_keyAdapter;
import xeadDriver.XFCheckBox;
import xeadDriver.XFDateField;
import xeadDriver.XFFYearBox;
import xeadDriver.XFInputAssistField;
import xeadDriver.XFMSeqBox;
import xeadDriver.XFTableOperator;
import xeadDriver.XFTextField;
import xeadDriver.XFUtility;
import xeadDriver.XFYMonthBox;

class XF300_Filter
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Element fieldElement_ = null;
    private XF300 dialog_ = null;
    private String dataType = "";
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private String basicType = "";
    private String tableID = "";
    private String tableAlias = "";
    private String fieldID = "";
    private String fieldName = "";
    private String fieldRemarks = "";
    private String fieldCaption = "";
    private String fieldOptions = "";
    private ArrayList<String> fieldOptionList;
    private String componentType = "";
    private String operandType = "";
    private String operand = "";
    private int dataSize = 5;
    private int decimalSize = 0;
    private JPanel jPanelField = new JPanel();
    private JPanel jPanelCaption = new JPanel();
    private JLabel jLabelField = new JLabel();
    private JButton jButtonOperand = new JButton();
    private JPopupMenu jPopupMenu = new JPopupMenu();
    private XFTextField xFTextField = null;
    private XFInputAssistField xFInputAssistField = null;
    private XFCheckBox xFCheckBox = null;
    private XFDateField xFDateField = null;
    private XFYMonthBox xFYMonthBox = null;
    private XFMSeqBox xFMSeqBox = null;
    private XFFYearBox xFFYearBox = null;
    private JComboBox<String> jComboBox = null;
    private XF300_PromptCallField xFPromptCall = null;
    private ArrayList<String> keyValueList = new ArrayList();
    private JComponent component = null;
    private boolean isVertical = false;
    private int verticalMargin = 5;
    private int horizontalMargin = 50;
    private boolean isReflect = false;
    private boolean isEditable_ = true;
    private boolean isHidden = false;
    private boolean isNative = false;
    private int index_ = 0;
    private String filterGroupID = "";
    private JRadioButtonMenuItem itemEQ = new JRadioButtonMenuItem(" = ");
    private JRadioButtonMenuItem itemNE = new JRadioButtonMenuItem(" != ");
    private JRadioButtonMenuItem itemGE = new JRadioButtonMenuItem(" >= ");
    private JRadioButtonMenuItem itemGT = new JRadioButtonMenuItem(" > ");
    private JRadioButtonMenuItem itemLE = new JRadioButtonMenuItem(" <= ");
    private JRadioButtonMenuItem itemLT = new JRadioButtonMenuItem(" < ");
    private JRadioButtonMenuItem itemGeneric = new JRadioButtonMenuItem(" ?* ");
    private JRadioButtonMenuItem itemScan = new JRadioButtonMenuItem(" *?* ");
    private ButtonGroup itemGroup = new ButtonGroup();
    private ImageIcon buttonIcon = null;

    public XF300_Filter(Element fieldElement, XF300 dialog, int index) {
        String wrkStr;
        this.fieldElement_ = fieldElement;
        this.dialog_ = dialog;
        this.index_ = index;
        this.fieldOptions = this.fieldElement_.getAttribute("FieldOptions");
        this.fieldOptionList = XFUtility.getOptionList(this.fieldOptions);
        StringTokenizer workTokenizer1 = new StringTokenizer(this.fieldElement_.getAttribute("DataSource"), ".");
        this.tableAlias = workTokenizer1.nextToken();
        this.tableID = this.dialog_.getTableIDOfTableAlias(this.tableAlias, index);
        this.fieldID = workTokenizer1.nextToken();
        Element workElement = this.dialog_.getSession().getFieldElement(this.tableID, this.fieldID);
        if (workElement == null) {
            JOptionPane.showMessageDialog(this, String.valueOf(this.tableID) + "." + this.fieldID + XFUtility.RESOURCE.getString("FunctionError11"));
        }
        this.fieldName = workElement.getAttribute("Name");
        this.fieldRemarks = XFUtility.getLayoutedString(workElement.getAttribute("Remarks"), "<br>", this.dialog_.getSession().systemFont);
        this.dataType = workElement.getAttribute("Type");
        this.dataTypeOptions = workElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = XFUtility.getOptionList(this.dataTypeOptions);
        this.fieldCaption = workElement.getAttribute("Name").equals("") ? workElement.getAttribute("ID") : this.fieldName;
        this.dataSize = Integer.parseInt(workElement.getAttribute("Size"));
        if (this.dataSize > 50) {
            this.dataSize = 50;
        }
        if (!workElement.getAttribute("Decimal").equals("")) {
            this.decimalSize = Integer.parseInt(workElement.getAttribute("Decimal"));
        }
        if (!this.dataTypeOptionList.contains("VIRTUAL") && this.tableID.equals(this.dialog_.getDetailTable(index).getTableID())) {
            this.isNative = true;
        }
        if (this.fieldOptionList.contains("VERTICAL")) {
            this.isVertical = true;
        }
        if (!(wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "VERTICAL")).equals("")) {
            this.isVertical = true;
            this.verticalMargin = Integer.parseInt(wrkStr);
        }
        if (!(wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "HORIZONTAL")).equals("")) {
            this.horizontalMargin = Integer.parseInt(wrkStr) + 5;
        }
        if (this.fieldOptionList.contains("REFLECT")) {
            this.operandType = "REFLECT";
            this.operand = "";
            this.isReflect = true;
            this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterReflect.png"));
            this.jButtonOperand.setIcon(this.buttonIcon);
        } else {
            if (this.fieldOptionList.contains("PROMPT_LIST1") || this.fieldOptionList.contains("PROMPT_LIST2")) {
                this.jPopupMenu.add(this.itemEQ);
                this.jPopupMenu.add(this.itemNE);
                this.itemGroup.add(this.itemEQ);
                this.itemGroup.add(this.itemNE);
            } else {
                this.basicType = XFUtility.getBasicTypeOf(this.dataType);
                if (this.basicType.equals("INTEGER") || this.basicType.equals("FLOAT")) {
                    this.jPopupMenu.add(this.itemEQ);
                    this.jPopupMenu.add(this.itemNE);
                    this.jPopupMenu.add(this.itemGE);
                    this.jPopupMenu.add(this.itemGT);
                    this.jPopupMenu.add(this.itemLE);
                    this.jPopupMenu.add(this.itemLT);
                    this.itemGroup.add(this.itemEQ);
                    this.itemGroup.add(this.itemNE);
                    this.itemGroup.add(this.itemGE);
                    this.itemGroup.add(this.itemGT);
                    this.itemGroup.add(this.itemLE);
                    this.itemGroup.add(this.itemLT);
                }
                if (this.basicType.equals("STRING") || this.basicType.equals("CLOB")) {
                    this.jPopupMenu.add(this.itemEQ);
                    this.jPopupMenu.add(this.itemNE);
                    this.jPopupMenu.add(this.itemScan);
                    this.jPopupMenu.add(this.itemGeneric);
                    this.itemGroup.add(this.itemEQ);
                    this.itemGroup.add(this.itemNE);
                    this.itemGroup.add(this.itemScan);
                    this.itemGroup.add(this.itemGeneric);
                }
                if (this.basicType.equals("BINARY") || this.basicType.equals("BYTEA")) {
                    this.jPopupMenu.add(this.itemEQ);
                    this.jPopupMenu.add(this.itemNE);
                    this.itemGroup.add(this.itemEQ);
                    this.itemGroup.add(this.itemNE);
                }
                if (this.basicType.equals("DATE")) {
                    this.jPopupMenu.add(this.itemEQ);
                    this.jPopupMenu.add(this.itemNE);
                    this.jPopupMenu.add(this.itemGE);
                    this.jPopupMenu.add(this.itemGT);
                    this.jPopupMenu.add(this.itemLE);
                    this.jPopupMenu.add(this.itemLT);
                    this.itemGroup.add(this.itemEQ);
                    this.itemGroup.add(this.itemNE);
                    this.itemGroup.add(this.itemGE);
                    this.itemGroup.add(this.itemGT);
                    this.itemGroup.add(this.itemLE);
                    this.itemGroup.add(this.itemLT);
                }
                if (this.basicType.equals("TIME") || this.basicType.equals("DATETIME")) {
                    this.jPopupMenu.add(this.itemEQ);
                    this.jPopupMenu.add(this.itemNE);
                    this.jPopupMenu.add(this.itemGE);
                    this.jPopupMenu.add(this.itemGT);
                    this.jPopupMenu.add(this.itemLE);
                    this.jPopupMenu.add(this.itemLT);
                    this.jPopupMenu.add(this.itemGeneric);
                    this.itemGroup.add(this.itemEQ);
                    this.itemGroup.add(this.itemNE);
                    this.itemGroup.add(this.itemGE);
                    this.itemGroup.add(this.itemGT);
                    this.itemGroup.add(this.itemLE);
                    this.itemGroup.add(this.itemLT);
                    this.itemGroup.add(this.itemGeneric);
                }
            }
            this.itemEQ.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "EQ";
                    XF300_Filter.this.operand = " = ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterEQ.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemNE.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "NE";
                    XF300_Filter.this.operand = " != ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterNE.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemGE.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "GE";
                    XF300_Filter.this.operand = " >= ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterGE.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemGT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "GT";
                    XF300_Filter.this.operand = " > ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterGT.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemLE.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "LE";
                    XF300_Filter.this.operand = " <= ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterLE.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemLT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "LT";
                    XF300_Filter.this.operand = " < ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterLT.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemScan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "SCAN";
                    XF300_Filter.this.operand = " LIKE ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterScan.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemGeneric.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XF300_Filter.this.operandType = "GENERIC";
                    XF300_Filter.this.operand = " LIKE ";
                    XF300_Filter.this.buttonIcon = new ImageIcon(XFUtility.class.getResource("filterGeneric.png"));
                    XF300_Filter.this.jButtonOperand.setIcon(XF300_Filter.this.buttonIcon);
                }
            });
            this.itemEQ.setSelected(true);
            this.itemEQ.doClick();
            if (this.fieldOptionList.contains("GE")) {
                this.itemGE.setSelected(true);
                this.itemGE.doClick();
            }
            if (this.fieldOptionList.contains("GT")) {
                this.itemGT.setSelected(true);
                this.itemGT.doClick();
            }
            if (this.fieldOptionList.contains("LE")) {
                this.itemLE.setSelected(true);
                this.itemLE.doClick();
            }
            if (this.fieldOptionList.contains("LT")) {
                this.itemLT.setSelected(true);
                this.itemLT.doClick();
            }
            if (this.fieldOptionList.contains("SCAN")) {
                this.itemScan.setSelected(true);
                this.itemScan.doClick();
            }
            if (this.fieldOptionList.contains("GENERIC")) {
                this.itemGeneric.setSelected(true);
                this.itemGeneric.doClick();
            }
        }
        this.filterGroupID = String.valueOf(this.tableAlias) + "." + this.fieldID + ":" + this.operandType;
        wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "CAPTION");
        if (!wrkStr.equals("")) {
            this.fieldCaption = XFUtility.getCaptionValue(wrkStr, this.dialog_.getSession());
            this.fieldCaption = this.fieldCaption.replace("SCAN", "");
            this.fieldCaption = this.fieldCaption.replace("\u2267", "");
            this.fieldCaption = this.fieldCaption.replace("\u4e0a\u4f4d\u6841", "");
        }
        this.jLabelField = new JLabel(this.fieldCaption);
        this.jLabelField.setHorizontalAlignment(4);
        this.jLabelField.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
        int width = XFUtility.adjustFontSizeToGetPreferredWidthOfLabel(this.jLabelField, 130);
        if (this.isVertical || this.dialog_.getFilterList(this.index_).size() == 0) {
            this.jPanelCaption.setPreferredSize(new Dimension(150, 25));
        } else {
            this.jPanelCaption.setPreferredSize(new Dimension(width + this.horizontalMargin, 25));
        }
        this.jButtonOperand.setPreferredSize(new Dimension(20, 25));
        this.jButtonOperand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component com = (Component)e.getSource();
                XF300_Filter.this.jPopupMenu.show(com, 10, 10);
            }
        });
        this.jButtonOperand.setFocusable(false);
        this.jPanelCaption.setLayout(new BorderLayout());
        this.jPanelCaption.add((Component)this.jLabelField, "Center");
        this.jPanelCaption.add((Component)this.jButtonOperand, "East");
        this.jPanelField.setLayout(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanelCaption, "West");
        this.add((Component)this.jPanelField, "Center");
        if (!XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "BOOLEAN").equals("")) {
            this.componentType = "BOOLEAN";
            this.xFCheckBox = new XFCheckBox(this.dataTypeOptions);
            this.xFCheckBox.addKeyListener(new XF300_keyAdapter(dialog));
            this.xFCheckBox.setLocation(0, 0);
            this.xFCheckBox.setEditable(true);
            this.component = this.xFCheckBox;
        } else if (this.fieldOptionList.contains("PROMPT_LIST0")) {
            this.componentType = "ASSISTFIELD";
            this.xFInputAssistField = new XFInputAssistField(this.tableID, this.fieldID, this.dataSize, this.dataTypeOptions, this.dialog_.getSession());
            this.xFInputAssistField.addKeyListener(new XF300_keyAdapter(dialog));
            this.xFInputAssistField.setLocation(0, 0);
            this.component = this.xFInputAssistField;
        } else if (this.fieldOptionList.contains("PROMPT_LIST1") || this.fieldOptionList.contains("PROMPT_LIST2")) {
            FontMetrics metrics2 = this.jLabelField.getFontMetrics(new Font(this.dialog_.getSession().systemFont, 0, 18));
            wrkStr = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "KUBUN");
            if (!wrkStr.equals("")) {
                this.componentType = "KUBUN_LIST";
                this.jComboBox = new JComboBox();
                this.jComboBox.addKeyListener(new XF300_keyAdapter(dialog));
                this.component = this.jComboBox;
                int fieldWidth = 20;
                if (this.fieldOptionList.contains("PROMPT_LIST1")) {
                    this.keyValueList.add("");
                    this.jComboBox.addItem("");
                }
                try {
                    XFTableOperator operator = this.dialog_.createTableOperator("Select", this.dialog_.getSession().getTableNameOfUserVariants());
                    operator.addKeyValue("IDUSERKUBUN", wrkStr);
                    operator.setOrderBy("SQLIST");
                    while (operator.next()) {
                        String wrkKey = operator.getValueOf("KBUSERKUBUN").toString().trim();
                        this.keyValueList.add(wrkKey);
                        String wrkText = operator.getValueOf("TXUSERKUBUN").toString().trim();
                        this.jComboBox.addItem(wrkText);
                        if (metrics2.stringWidth(wrkText) <= fieldWidth) continue;
                        fieldWidth = metrics2.stringWidth(wrkText);
                    }
                    this.jComboBox.setBounds(new Rectangle(0, 0, fieldWidth + 30, 24));
                    this.jComboBox.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
                    this.jComboBox.setSelectedIndex(0);
                }
                catch (Exception e) {
                    e.printStackTrace(this.dialog_.getExceptionStream());
                    this.dialog_.setErrorAndCloseFunction();
                }
            } else {
                wrkStr = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "VALUES");
                if (!wrkStr.equals("")) {
                    this.componentType = "VALUES_LIST";
                    this.jComboBox = new JComboBox();
                    this.jComboBox.addKeyListener(new XF300_keyAdapter(dialog));
                    this.component = this.jComboBox;
                    int fieldWidth = 20;
                    if (this.fieldOptionList.contains("PROMPT_LIST1")) {
                        this.jComboBox.addItem("");
                    }
                    StringTokenizer workTokenizer = new StringTokenizer(wrkStr, ";");
                    while (workTokenizer.hasMoreTokens()) {
                        String wrkKey = workTokenizer.nextToken();
                        this.jComboBox.addItem(wrkKey);
                        if (metrics2.stringWidth(wrkKey) <= fieldWidth) continue;
                        fieldWidth = metrics2.stringWidth(wrkKey);
                    }
                    this.jComboBox.setBounds(new Rectangle(0, 0, fieldWidth + 30, 24));
                    this.jComboBox.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
                    this.jComboBox.setSelectedIndex(0);
                } else {
                    this.componentType = "RECORDS_LIST";
                    this.jComboBox = new JComboBox();
                    this.jComboBox.addKeyListener(new XF300_keyAdapter(dialog));
                    this.component = this.jComboBox;
                    int fieldWidth = 20;
                    ArrayList<XF300_DetailReferTable> referTableList = this.dialog_.getDetailReferTableList(index);
                    int i = 0;
                    while (i < referTableList.size()) {
                        if (referTableList.get(i).getTableID().equals(this.tableID) && (referTableList.get(i).getTableAlias().equals("") || referTableList.get(i).getTableAlias().equals(this.tableAlias))) {
                            if (this.fieldOptionList.contains("PROMPT_LIST1")) {
                                this.jComboBox.addItem("");
                            }
                            try {
                                XFTableOperator operator = this.dialog_.createTableOperator("Select", this.tableID);
                                operator.setSelectFields(this.fieldID);
                                operator.setOrderBy(this.fieldID);
                                while (operator.next()) {
                                    String wrkKey = operator.getValueOf(this.fieldID).toString().trim();
                                    this.jComboBox.addItem(wrkKey);
                                    if (metrics2.stringWidth(wrkKey) <= fieldWidth) continue;
                                    fieldWidth = metrics2.stringWidth(wrkKey);
                                }
                                this.jComboBox.setBounds(new Rectangle(0, 0, fieldWidth + 30, 24));
                                this.jComboBox.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
                                this.jComboBox.setSelectedIndex(0);
                            }
                            catch (Exception e) {
                                e.printStackTrace(this.dialog_.getExceptionStream());
                                this.dialog_.setErrorAndCloseFunction();
                            }
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else {
            wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "PROMPT_CALL");
            if (!wrkStr.equals("")) {
                this.componentType = "PROMPT_CALL";
                this.xFPromptCall = new XF300_PromptCallField(fieldElement, wrkStr, this.dialog_, this.index_);
                this.xFPromptCall.addKeyListener(new XF300_keyAdapter(dialog));
                this.xFPromptCall.setLocation(0, 0);
                this.component = this.xFPromptCall;
                if (this.component.getBounds().width < 70) {
                    this.component.setBounds(new Rectangle(this.component.getBounds().x, this.component.getBounds().y, 70, this.component.getBounds().height));
                }
            } else if (this.dataType.equals("DATE")) {
                this.componentType = "DATE";
                this.xFDateField = new XFDateField(this.dialog_.getSession());
                this.xFDateField.addKeyListener(new XF300_keyAdapter(dialog));
                this.xFDateField.setLocation(0, 0);
                this.xFDateField.setEditable(true);
                this.component = this.xFDateField;
            } else if (this.dataTypeOptionList.contains("YMONTH")) {
                this.componentType = "YMONTH";
                this.xFYMonthBox = new XFYMonthBox(this.dialog_.getSession());
                this.xFYMonthBox.addKeyListener(new XF300_keyAdapter(dialog));
                this.xFYMonthBox.setLocation(0, 0);
                this.xFYMonthBox.setEditable(true);
                this.component = this.xFYMonthBox;
            } else if (this.dataTypeOptionList.contains("MSEQ")) {
                this.componentType = "MSEQ";
                this.xFMSeqBox = new XFMSeqBox(this.dialog_.getSession());
                this.xFMSeqBox.addKeyListener(new XF300_keyAdapter(dialog));
                this.xFMSeqBox.setLocation(0, 0);
                this.xFMSeqBox.setEditable(true);
                this.component = this.xFMSeqBox;
            } else if (this.dataTypeOptionList.contains("FYEAR")) {
                this.componentType = "FYEAR";
                this.xFFYearBox = new XFFYearBox(this.dialog_.getSession());
                this.xFFYearBox.addKeyListener(new XF300_keyAdapter(dialog));
                this.xFFYearBox.setLocation(0, 0);
                this.xFFYearBox.setEditable(true);
                this.component = this.xFFYearBox;
            } else {
                this.componentType = "TEXTFIELD";
                this.xFTextField = new XFTextField(this.getBasicType(), this.dataSize, this.decimalSize, this.dataTypeOptions, this.fieldOptions, this.dialog_.getSession().systemFont, true);
                this.xFTextField.addKeyListener(new XF300_keyAdapter(dialog));
                this.xFTextField.setLocation(0, 0);
                this.component = this.xFTextField;
            }
        }
        if (this.fieldOptionList.contains("NON_EDITABLE")) {
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        if (this.fieldOptionList.contains("HIDDEN")) {
            this.isHidden = true;
        }
        wrkStr = this.decimalSize > 0 ? "<html>" + this.fieldName + " " + this.tableAlias + "." + this.fieldID + " (" + this.dataSize + "," + this.decimalSize + ")<br>" + this.fieldRemarks : "<html>" + this.fieldName + " " + this.tableAlias + "." + this.fieldID + " (" + this.dataSize + ")<br>" + this.fieldRemarks;
        this.setToolTipText(wrkStr);
        this.component.setToolTipText(wrkStr);
        this.jPanelField.add(this.component);
        wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "WIDTH");
        if (wrkStr.equals("")) {
            if (this.component.getBounds().width > 250) {
                this.component.setBounds(new Rectangle(this.component.getBounds().x, this.component.getBounds().y, 250, this.component.getBounds().height));
            }
        } else {
            this.component.setBounds(new Rectangle(this.component.getBounds().x, this.component.getBounds().y, Integer.parseInt(wrkStr), this.component.getBounds().height));
        }
        this.setPreferredSize(new Dimension(this.jPanelCaption.getPreferredSize().width + this.component.getBounds().width, this.component.getBounds().height));
    }

    Object getDefaultValue() {
        String value = "";
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions, "VALUE");
        if (wrkStr.equals("")) {
            if (this.componentType.equals("BOOLEAN")) {
                value = this.xFCheckBox.getFalseValue();
            }
        } else {
            value = XFUtility.getDefaultValueOfFilterField(wrkStr, this.dialog_.getSession());
            if (value == null) {
                JOptionPane.showMessageDialog(this, String.valueOf(this.tableID) + "." + this.fieldID + XFUtility.RESOURCE.getString("FunctionError46") + "\n" + wrkStr);
            }
        }
        return value;
    }

    public String getBasicType() {
        return XFUtility.getBasicTypeOf(this.dataType);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isVerticalPosition() {
        return this.isVertical;
    }

    public int getVerticalMargin() {
        return this.verticalMargin;
    }

    public String getCaption() {
        return this.fieldCaption;
    }

    public String getCaptionAndValue() {
        String value = String.valueOf(this.fieldCaption) + this.operand;
        String wrk = "";
        if (this.componentType.equals("TEXTFIELD")) {
            wrk = (String)this.xFTextField.getExternalValue();
        }
        if (this.componentType.equals("ASSISTFIELD")) {
            wrk = (String)this.xFInputAssistField.getExternalValue();
        }
        if (this.componentType.equals("KUBUN_LIST") || this.componentType.equals("VALUES_LIST") || this.componentType.equals("RECORDS_LIST")) {
            wrk = this.jComboBox.getSelectedItem().toString();
        }
        if (this.componentType.equals("BOOLEAN")) {
            wrk = (String)this.xFCheckBox.getExternalValue();
        }
        if (this.componentType.equals("YMONTH")) {
            wrk = (String)this.xFYMonthBox.getExternalValue();
        }
        if (this.componentType.equals("MSEQ")) {
            wrk = (String)this.xFMSeqBox.getExternalValue();
        }
        if (this.componentType.equals("FYEAR")) {
            wrk = (String)this.xFFYearBox.getExternalValue();
        }
        if (this.componentType.equals("DATE")) {
            wrk = (String)this.xFDateField.getExternalValue();
        }
        if (this.componentType.equals("PROMPT_CALL")) {
            wrk = (String)this.xFPromptCall.getExternalValue();
        }
        value = wrk.equals("") ? String.valueOf(value) + "* " : String.valueOf(value) + wrk + " ";
        return value;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.component.requestFocus();
    }

    public String getFieldID() {
        return this.fieldID;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableID() {
        return this.tableID;
    }

    public String getDataSourceName() {
        return String.valueOf(this.tableAlias) + "." + this.fieldID;
    }

    public void setParmMapValue(HashMap<String, Object> parmMap) {
        String mapKey = String.valueOf(this.getTableID()) + "." + this.getFieldID();
        if (parmMap != null && parmMap.containsKey(mapKey)) {
            Object mapValue = parmMap.get(mapKey);
            if (this.componentType.equals("TEXTFIELD")) {
                this.xFTextField.setText(mapValue.toString().trim());
            }
            if (this.componentType.equals("ASSISTFIELD")) {
                this.xFInputAssistField.setValue(mapValue.toString().trim());
            }
            if (this.componentType.equals("DATE")) {
                this.xFDateField.setValue(mapValue.toString());
                this.xFDateField.setEditable(false);
            }
            if (this.componentType.equals("YMONTH")) {
                this.xFYMonthBox.setValue(mapValue.toString());
            }
            if (this.componentType.equals("MSEQ")) {
                this.xFMSeqBox.setValue(mapValue.toString());
            }
            if (this.componentType.equals("FYEAR")) {
                this.xFFYearBox.setValue(mapValue.toString());
            }
            if (this.componentType.equals("KUBUN_LIST")) {
                this.jComboBox.setSelectedIndex(this.keyValueList.indexOf(mapValue.toString()));
            }
            if (this.componentType.equals("VALUES_LIST") || this.componentType.equals("RECORDS_LIST")) {
                int i = 0;
                while (i < this.jComboBox.getItemCount()) {
                    if (this.jComboBox.getItemAt(i).equals(mapValue.toString())) {
                        this.jComboBox.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            if (this.componentType.equals("PROMPT_CALL")) {
                this.xFPromptCall.setValue(mapValue.toString());
            }
        }
    }

    public boolean isValidatedWithParmMapValue(HashMap<String, Object> parmMap) {
        boolean isValidated = true;
        String mapKey = String.valueOf(this.getTableID()) + "." + this.getFieldID();
        if (parmMap != null && parmMap.containsKey(mapKey)) {
            Object mapValue = parmMap.get(mapKey);
            if (this.componentType.equals("TEXTFIELD")) {
                this.xFTextField.setText(mapValue.toString().trim());
            }
            if (this.componentType.equals("ASSISTFIELD")) {
                this.xFInputAssistField.setValue(mapValue.toString().trim());
            }
            if (this.componentType.equals("DATE")) {
                this.xFDateField.setValue(mapValue.toString());
            }
            if (this.componentType.equals("YMONTH")) {
                this.xFYMonthBox.setValue(mapValue.toString());
            }
            if (this.componentType.equals("MSEQ")) {
                this.xFMSeqBox.setValue(mapValue.toString());
            }
            if (this.componentType.equals("FYEAR")) {
                this.xFFYearBox.setValue(mapValue.toString());
            }
            if (this.componentType.equals("KUBUN_LIST")) {
                this.jComboBox.setSelectedIndex(this.keyValueList.indexOf(mapValue.toString()));
            }
            if (this.componentType.equals("VALUES_LIST") || this.componentType.equals("RECORDS_LIST")) {
                int i = 0;
                while (i < this.jComboBox.getItemCount()) {
                    if (this.jComboBox.getItemAt(i).equals(mapValue.toString())) {
                        this.jComboBox.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            if (this.componentType.equals("BOOLEAN")) {
                this.xFCheckBox.setValue(this.keyValueList.indexOf(mapValue.toString()));
            }
            if (this.componentType.equals("PROMPT_CALL")) {
                this.xFPromptCall.setValue(mapValue.toString());
            }
            if (!this.isEditable_ && mapValue.toString().equals("")) {
                isValidated = false;
            }
        } else if (!this.isEditable_ && !this.isValueSpecified()) {
            isValidated = false;
        }
        return isValidated;
    }

    public boolean isValueSpecified() {
        boolean result = false;
        String wrkStr = "";
        if (this.componentType.equals("TEXTFIELD") || this.componentType.equals("ASSISTFIELD")) {
            if (this.componentType.equals("TEXTFIELD")) {
                wrkStr = (String)this.xFTextField.getInternalValue();
            }
            if (this.componentType.equals("ASSISTFIELD")) {
                wrkStr = (String)this.xFInputAssistField.getInternalValue();
            }
            if (!wrkStr.equals("")) {
                result = true;
            }
        }
        if (this.componentType.equals("KUBUN_LIST") && this.jComboBox.getSelectedIndex() >= 0 && !(wrkStr = this.keyValueList.get(this.jComboBox.getSelectedIndex())).equals("")) {
            result = true;
        }
        if ((this.componentType.equals("VALUES_LIST") || this.componentType.equals("RECORDS_LIST")) && this.jComboBox.getSelectedIndex() >= 0 && !(wrkStr = (String)this.jComboBox.getSelectedItem()).equals("")) {
            result = true;
        }
        if (this.componentType.equals("PROMPT_CALL") && !(wrkStr = (String)this.xFPromptCall.getInternalValue()).equals("")) {
            result = true;
        }
        if (this.componentType.equals("BOOLEAN") && !(wrkStr = (String)this.xFCheckBox.getInternalValue()).equals("")) {
            result = true;
        }
        if (this.componentType.equals("DATE") && (wrkStr = (String)this.xFDateField.getInternalValue()) != null && !wrkStr.equals("")) {
            result = true;
        }
        if (this.componentType.equals("YMONTH") && !(wrkStr = (String)this.xFYMonthBox.getInternalValue()).equals("")) {
            result = true;
        }
        if (this.componentType.equals("MSEQ") && !(wrkStr = (String)this.xFMSeqBox.getInternalValue()).equals("0")) {
            result = true;
        }
        if (this.componentType.equals("FYEAR") && !(wrkStr = (String)this.xFFYearBox.getInternalValue()).equals("")) {
            result = true;
        }
        return result;
    }

    public void setValue(Object value) {
        if (this.componentType.equals("TEXTFIELD")) {
            this.xFTextField.setText(value.toString().trim());
        }
        if (this.componentType.equals("ASSISTFIELD")) {
            this.xFInputAssistField.setValue(value.toString().trim());
        }
        if (this.componentType.equals("BOOLEAN")) {
            this.xFCheckBox.setValue(value.toString().trim());
        }
        if (this.componentType.equals("DATE")) {
            this.xFDateField.setValue(value.toString());
        }
        if (this.componentType.equals("YMONTH")) {
            this.xFYMonthBox.setValue(value.toString());
        }
        if (this.componentType.equals("MSEQ")) {
            this.xFMSeqBox.setValue(value.toString());
        }
        if (this.componentType.equals("FYEAR")) {
            this.xFFYearBox.setValue(value.toString());
        }
        if (this.componentType.equals("KUBUN_LIST")) {
            this.jComboBox.setSelectedIndex(this.keyValueList.indexOf(value.toString()));
        }
        if (this.componentType.equals("VALUES_LIST") || this.componentType.equals("RECORDS_LIST")) {
            int i = 0;
            while (i < this.jComboBox.getItemCount()) {
                if (this.jComboBox.getItemAt(i).equals(value.toString())) {
                    this.jComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (this.componentType.equals("PROMPT_CALL")) {
            this.xFPromptCall.setValue(value.toString());
        }
    }

    public Object getValue() {
        String value = "";
        String wrkStr = "";
        if (this.componentType.equals("TEXTFIELD") || this.componentType.equals("ASSISTFIELD")) {
            if (this.componentType.equals("TEXTFIELD")) {
                wrkStr = (String)this.xFTextField.getInternalValue();
            }
            if (this.componentType.equals("ASSISTFIELD")) {
                wrkStr = (String)this.xFInputAssistField.getInternalValue();
            }
            if (!wrkStr.equals("")) {
                if (this.getBasicType().equals("INTEGER") || this.getBasicType().equals("FLOAT")) {
                    value = wrkStr;
                } else if (this.getBasicType().equals("DATE") || this.getBasicType().equals("TIME") || this.getBasicType().equals("DATETIME")) {
                    wrkStr = wrkStr.replace("-", "");
                    value = wrkStr = wrkStr.replace("/", "");
                } else {
                    value = wrkStr;
                }
            }
        }
        if (this.componentType.equals("KUBUN_LIST")) {
            value = this.keyValueList.get(this.jComboBox.getSelectedIndex());
        }
        if (this.componentType.equals("VALUES_LIST")) {
            value = (String)this.jComboBox.getSelectedItem();
        }
        if (this.componentType.equals("PROMPT_CALL") && !(wrkStr = (String)this.xFPromptCall.getInternalValue()).equals("")) {
            value = this.getBasicType().equals("INTEGER") || this.getBasicType().equals("FLOAT") ? wrkStr : wrkStr;
        }
        if (this.componentType.equals("BOOLEAN")) {
            value = (String)this.xFCheckBox.getInternalValue();
        }
        if (this.componentType.equals("DATE") && (wrkStr = (String)this.xFDateField.getInternalValue()) != null && !wrkStr.equals("")) {
            value = wrkStr;
        }
        if (this.componentType.equals("YMONTH")) {
            value = (String)this.xFYMonthBox.getInternalValue();
        }
        if (this.componentType.equals("MSEQ") && !(wrkStr = (String)this.xFMSeqBox.getInternalValue()).equals("0")) {
            value = wrkStr;
        }
        if (this.componentType.equals("FYEAR")) {
            value = (String)this.xFFYearBox.getInternalValue();
        }
        return value;
    }

    public String getSQLWhereValue() {
        String value = "";
        String wrkStr = "";
        if (!this.operandType.equals("")) {
            if (this.componentType.equals("TEXTFIELD") || this.componentType.equals("ASSISTFIELD")) {
                if (this.componentType.equals("TEXTFIELD")) {
                    wrkStr = (String)this.xFTextField.getInternalValue();
                }
                if (this.componentType.equals("ASSISTFIELD")) {
                    wrkStr = (String)this.xFInputAssistField.getInternalValue();
                }
                if (!wrkStr.equals("")) {
                    if (this.getBasicType().equals("INTEGER") || this.getBasicType().equals("FLOAT")) {
                        value = String.valueOf(this.fieldID) + this.operand + wrkStr;
                    } else if (this.getBasicType().equals("DATE") || this.getBasicType().equals("TIME")) {
                        wrkStr = wrkStr.replace("-", "");
                        wrkStr = wrkStr.replace("/", "");
                        value = String.valueOf(this.fieldID) + this.operand + wrkStr;
                    } else if (this.getBasicType().equals("DATETIME")) {
                        String whereValue = XFUtility.getWhereValueOfDateTimeSegment(this.operandType, wrkStr);
                        if (whereValue.equals("")) {
                            JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionMessage62")) + wrkStr + XFUtility.RESOURCE.getString("FunctionMessage63"));
                        } else {
                            value = String.valueOf(this.fieldID) + whereValue;
                        }
                    } else {
                        if (wrkStr.equals("''") || wrkStr.equals("\"\"") || wrkStr.equals("'") || wrkStr.equals("\"") || wrkStr.equals("\u2019\u2019") || wrkStr.equals("\u201d\u201d") || wrkStr.equals("\u2019") || wrkStr.equals("\u201d")) {
                            wrkStr = "";
                        }
                        if (this.operandType.equals("SCAN")) {
                            value = "UPPER(" + this.fieldID + ") LIKE UPPER('%" + wrkStr + "%')";
                        } else if (this.operandType.equals("GENERIC")) {
                            value = "UPPER(" + this.fieldID + ") LIKE UPPER('" + wrkStr + "%')";
                        } else {
                            value = String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'";
                            if (wrkStr.equals("") && this.operandType.equals("EQ")) {
                                value = String.valueOf(this.fieldID) + " = '' or " + this.fieldID + " is null";
                            }
                        }
                    }
                }
            }
            if (this.componentType.equals("KUBUN_LIST") && !(wrkStr = this.keyValueList.get(this.jComboBox.getSelectedIndex())).equals("")) {
                value = String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'";
            }
            if (this.componentType.equals("VALUES_LIST") && !(wrkStr = (String)this.jComboBox.getSelectedItem()).equals("")) {
                value = String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'";
            }
            if (this.componentType.equals("PROMPT_CALL") && !(wrkStr = (String)this.xFPromptCall.getInternalValue()).equals("")) {
                if (wrkStr.contains(";")) {
                    StringBuffer bf = new StringBuffer();
                    StringTokenizer workTokenizer = new StringTokenizer(wrkStr, ";");
                    while (workTokenizer.hasMoreTokens()) {
                        if (!bf.toString().equals("")) {
                            bf.append(" or ");
                        }
                        bf.append(String.valueOf(this.fieldID) + this.operand + "'" + workTokenizer.nextToken() + "'");
                    }
                    value = bf.toString();
                } else {
                    value = this.getBasicType().equals("INTEGER") || this.getBasicType().equals("FLOAT") ? String.valueOf(this.fieldID) + this.operand + wrkStr : (this.operand.equals(" LIKE ") ? String.valueOf(this.fieldID) + this.operand + "'%" + wrkStr + "%'" : String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'");
                }
            }
            if (this.componentType.equals("BOOLEAN") && !(wrkStr = (String)this.xFCheckBox.getInternalValue()).equals("")) {
                value = String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'";
            }
            if (this.componentType.equals("DATE") && (wrkStr = (String)this.xFDateField.getInternalValue()) != null && !wrkStr.equals("")) {
                value = String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'";
            }
            if (this.componentType.equals("YMONTH") && !(wrkStr = (String)this.xFYMonthBox.getInternalValue()).equals("")) {
                value = String.valueOf(this.fieldID) + this.operand + "'" + wrkStr + "'";
            }
            if (this.componentType.equals("MSEQ") && !(wrkStr = (String)this.xFMSeqBox.getInternalValue()).equals("0")) {
                value = String.valueOf(this.fieldID) + this.operand + wrkStr;
            }
            if (this.componentType.equals("FYEAR") && !(wrkStr = (String)this.xFFYearBox.getInternalValue()).equals("")) {
                value = String.valueOf(this.fieldID) + this.operand + wrkStr;
            }
        }
        return value;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable_ = isEditable;
        this.jButtonOperand.setEnabled(this.isEditable_);
        if (this.componentType.equals("TEXTFIELD")) {
            this.xFTextField.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("ASSISTFIELD")) {
            this.xFInputAssistField.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("BOOLEAN")) {
            this.xFCheckBox.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("DATE")) {
            this.xFDateField.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("YMONTH")) {
            this.xFYMonthBox.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("MSEQ")) {
            this.xFMSeqBox.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("FYEAR")) {
            this.xFFYearBox.setEditable(this.isEditable_);
        }
        if (this.componentType.equals("KUBUN_LIST") || this.componentType.equals("VALUES_LIST") || this.componentType.equals("RECORDS_LIST")) {
            this.jComboBox.setEnabled(this.isEditable_);
        }
        if (this.componentType.equals("PROMPT_CALL")) {
            this.xFPromptCall.setEditable(this.isEditable_);
        }
    }

    public boolean isEditable() {
        return this.isEditable_;
    }

    public String getFilterGroupID() {
        return this.filterGroupID;
    }

    public boolean isReflect() {
        return this.isReflect;
    }

    public boolean isValidated() {
        boolean validated = false;
        XF300_DetailColumn columnField = this.dialog_.getDetailColumnObjectByID(this.index_, this.getTableID(), this.getTableAlias(), this.getFieldID());
        if (this.isReflect) {
            if (this.componentType.equals("TEXTFIELD")) {
                columnField.setValue((String)this.xFTextField.getInternalValue());
            }
            if (this.componentType.equals("ASSISTFIELD")) {
                columnField.setValue((String)this.xFInputAssistField.getInternalValue());
            }
            if (this.componentType.equals("KUBUN_LIST")) {
                columnField.setValue(this.keyValueList.get(this.jComboBox.getSelectedIndex()));
            }
            if (this.componentType.equals("RECORDS_LIST") || this.componentType.equals("VALUES_LIST")) {
                columnField.setValue((String)this.jComboBox.getSelectedItem());
            }
            if (this.componentType.equals("BOOLEAN")) {
                columnField.setValue((String)this.xFCheckBox.getInternalValue());
            }
            if (this.componentType.equals("DATE")) {
                columnField.setValue(this.xFDateField.getInternalValue());
            }
            if (this.componentType.equals("YMONTH")) {
                columnField.setValue(this.xFYMonthBox.getInternalValue());
            }
            if (this.componentType.equals("MSEQ")) {
                columnField.setValue(this.xFMSeqBox.getInternalValue());
            }
            if (this.componentType.equals("FYEAR")) {
                columnField.setValue(this.xFFYearBox.getInternalValue());
            }
            if (this.componentType.equals("PROMPT_CALL")) {
                columnField.setValue(this.xFPromptCall.getInternalValue());
            }
            validated = true;
        } else {
            String stringResultValue = "";
            String stringFilterValue = "";
            double doubleResultValue = 0.0;
            double doubleFilterValue = 0.0;
            if (columnField.isReadyToValidate()) {
                String fieldValue;
                String wrk;
                if (this.componentType.equals("TEXTFIELD") || this.componentType.equals("ASSISTFIELD")) {
                    int lengthFieldValue;
                    if (columnField.getInternalValue() != null) {
                        stringResultValue = columnField.getInternalValue().toString().trim();
                    }
                    if (this.componentType.equals("TEXTFIELD")) {
                        stringFilterValue = (String)this.xFTextField.getInternalValue();
                    }
                    if (this.componentType.equals("ASSISTFIELD")) {
                        stringFilterValue = (String)this.xFInputAssistField.getInternalValue();
                    }
                    if (this.getBasicType().equals("INTEGER") || this.getBasicType().equals("FLOAT")) {
                        if (stringFilterValue.equals("")) {
                            validated = true;
                        } else {
                            doubleResultValue = Double.parseDouble(stringResultValue);
                            String wrk2 = XFUtility.getStringNumber(stringFilterValue);
                            if (!wrk2.equals("")) {
                                doubleFilterValue = Double.parseDouble(wrk2);
                            }
                            if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GE") && doubleResultValue >= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                                validated = true;
                            }
                        }
                    } else if (this.getBasicType().equals("DATE") || this.getBasicType().equals("TIME") || this.getBasicType().equals("DATETIME")) {
                        if (stringFilterValue.equals("")) {
                            validated = true;
                        } else {
                            int lengthResultValue;
                            stringResultValue = XFUtility.getStringNumber(stringResultValue).replace("-", "");
                            doubleResultValue = Double.parseDouble(stringResultValue);
                            if (!(stringFilterValue = XFUtility.getStringNumber(stringFilterValue).replace("-", "")).equals("")) {
                                doubleFilterValue = Double.parseDouble(stringFilterValue);
                            }
                            if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GE") && !this.operandType.equals("GENERIC") && doubleResultValue >= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GENERIC") && (lengthResultValue = stringResultValue.length()) >= (lengthFieldValue = stringFilterValue.length()) && (wrk = stringResultValue.substring(0, lengthFieldValue)).equals(stringFilterValue)) {
                                validated = true;
                            }
                        }
                    } else if (stringFilterValue.equals("")) {
                        validated = true;
                    } else {
                        int lengthResultValue;
                        if (this.operandType.equals("EQ")) {
                            if (stringFilterValue.equals("''") || stringFilterValue.equals("\"\"") || stringFilterValue.equals("'") || stringFilterValue.equals("\"")) {
                                stringFilterValue = "";
                            }
                            if (stringResultValue.toUpperCase().equals(stringFilterValue.toUpperCase())) {
                                validated = true;
                            }
                        }
                        if (this.operandType.equals("NE")) {
                            if (stringFilterValue.equals("''") || stringFilterValue.equals("\"\"") || stringFilterValue.equals("'") || stringFilterValue.equals("\"")) {
                                stringFilterValue = "";
                            }
                            if (!stringResultValue.toUpperCase().equals(stringFilterValue.toUpperCase())) {
                                validated = true;
                            }
                        }
                        if (this.operandType.equals("SCAN")) {
                            if (stringFilterValue.equals("''") || stringFilterValue.equals("\"\"") || stringFilterValue.equals("'") || stringFilterValue.equals("\"")) {
                                stringFilterValue = "";
                            }
                            if (stringResultValue.toUpperCase().contains(stringFilterValue.toUpperCase())) {
                                validated = true;
                            }
                        }
                        if (this.operandType.equals("GENERIC") && (lengthResultValue = stringResultValue.length()) >= (lengthFieldValue = stringFilterValue.length()) && (wrk = stringResultValue.substring(0, lengthFieldValue)).toUpperCase().equals(stringFilterValue.toUpperCase())) {
                            validated = true;
                        }
                    }
                }
                if (this.componentType.equals("KUBUN_LIST")) {
                    fieldValue = this.keyValueList.get(this.jComboBox.getSelectedIndex());
                    if (fieldValue.equals("")) {
                        validated = true;
                    } else {
                        String resultValue = (String)columnField.getInternalValue();
                        if (resultValue.equals(fieldValue)) {
                            validated = true;
                        }
                    }
                }
                if (this.componentType.equals("RECORDS_LIST")) {
                    fieldValue = (String)this.jComboBox.getSelectedItem();
                    if (fieldValue.equals("")) {
                        validated = true;
                    } else {
                        String resultValue = (String)columnField.getExternalValue();
                        if (resultValue.equals(fieldValue)) {
                            validated = true;
                        } else {
                            if (fieldValue.equals("NULL") && resultValue.equals("")) {
                                validated = true;
                            }
                            if (fieldValue.equals("!NULL") && !resultValue.equals("")) {
                                validated = true;
                            }
                        }
                    }
                }
                if (this.componentType.equals("VALUES_LIST")) {
                    fieldValue = (String)this.jComboBox.getSelectedItem();
                    if (fieldValue.equals("")) {
                        validated = true;
                    } else {
                        String resultValue = (String)columnField.getInternalValue();
                        if (resultValue.equals(fieldValue)) {
                            validated = true;
                        }
                    }
                }
                if (this.componentType.equals("BOOLEAN")) {
                    fieldValue = (String)this.xFCheckBox.getInternalValue();
                    String resultValue = (String)columnField.getInternalValue();
                    if (resultValue.equals(fieldValue)) {
                        validated = true;
                    }
                }
                if (this.componentType.equals("DATE")) {
                    stringFilterValue = (String)this.xFDateField.getInternalValue();
                    if (stringFilterValue == null) {
                        validated = true;
                    } else {
                        if (columnField.getInternalValue() != null) {
                            stringResultValue = columnField.getInternalValue().toString().trim();
                            stringResultValue = XFUtility.getStringNumber(stringResultValue).replace("-", "");
                        }
                        if (!stringResultValue.equals("")) {
                            doubleResultValue = Double.parseDouble(stringResultValue);
                            if (!(stringFilterValue = XFUtility.getStringNumber(stringFilterValue).replace("-", "")).equals("")) {
                                doubleFilterValue = Double.parseDouble(stringFilterValue);
                            }
                            if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GE") && doubleResultValue >= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                                validated = true;
                            }
                        }
                    }
                }
                if (this.componentType.equals("YMONTH")) {
                    stringFilterValue = (String)this.xFYMonthBox.getInternalValue();
                    if (stringFilterValue.equals("")) {
                        validated = true;
                    } else {
                        int lengthFieldValue;
                        int lengthResultValue;
                        if (columnField.getInternalValue() != null) {
                            stringResultValue = columnField.getInternalValue().toString().trim();
                            stringResultValue = XFUtility.getStringNumber(stringResultValue).replace("/", "");
                        }
                        doubleResultValue = Double.parseDouble(stringResultValue);
                        if (!stringFilterValue.equals("")) {
                            doubleFilterValue = Double.parseDouble(stringFilterValue);
                        }
                        if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GE") && !this.operandType.equals("GENERIC") && doubleResultValue >= doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GENERIC") && (lengthResultValue = stringResultValue.length()) >= (lengthFieldValue = stringFilterValue.length()) && (wrk = stringResultValue.substring(0, lengthFieldValue)).equals(stringFilterValue)) {
                            validated = true;
                        }
                    }
                }
                if (this.componentType.equals("MSEQ")) {
                    stringFilterValue = (String)this.xFMSeqBox.getInternalValue();
                    if (stringFilterValue.equals("0")) {
                        validated = true;
                    } else {
                        int lengthFieldValue;
                        int lengthResultValue;
                        if (columnField.getInternalValue() != null) {
                            stringResultValue = columnField.getInternalValue().toString().trim();
                            stringResultValue = XFUtility.getStringNumber(stringResultValue).replace("/", "");
                        }
                        doubleResultValue = Double.parseDouble(stringResultValue);
                        if (!stringFilterValue.equals("")) {
                            doubleFilterValue = Double.parseDouble(stringFilterValue);
                        }
                        if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GE") && !this.operandType.equals("GENERIC") && doubleResultValue >= doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GENERIC") && (lengthResultValue = stringResultValue.length()) >= (lengthFieldValue = stringFilterValue.length()) && (wrk = stringResultValue.substring(0, lengthFieldValue)).equals(stringFilterValue)) {
                            validated = true;
                        }
                    }
                }
                if (this.componentType.equals("FYEAR")) {
                    stringFilterValue = (String)this.xFFYearBox.getInternalValue();
                    if (stringFilterValue.equals("")) {
                        validated = true;
                    } else {
                        int lengthFieldValue;
                        int lengthResultValue;
                        if (columnField.getInternalValue() != null) {
                            stringResultValue = columnField.getInternalValue().toString().trim();
                            stringResultValue = XFUtility.getStringNumber(stringResultValue).replace("/", "");
                        }
                        doubleResultValue = Double.parseDouble(stringResultValue);
                        if (!stringFilterValue.equals("")) {
                            doubleFilterValue = Double.parseDouble(stringFilterValue);
                        }
                        if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GE") && !this.operandType.equals("GENERIC") && doubleResultValue >= doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                            validated = true;
                        }
                        if (this.operandType.equals("GENERIC") && (lengthResultValue = stringResultValue.length()) >= (lengthFieldValue = stringFilterValue.length()) && (wrk = stringResultValue.substring(0, lengthFieldValue)).equals(stringFilterValue)) {
                            validated = true;
                        }
                    }
                }
                if (this.componentType.equals("PROMPT_CALL")) {
                    if (columnField.getInternalValue() != null) {
                        stringResultValue = columnField.getInternalValue().toString().trim();
                    }
                    stringFilterValue = (String)this.xFPromptCall.getInternalValue();
                    if (this.getBasicType().equals("INTEGER") || this.getBasicType().equals("FLOAT")) {
                        if (stringFilterValue.equals("")) {
                            validated = true;
                        } else {
                            doubleResultValue = Double.parseDouble(stringResultValue);
                            String wrk3 = XFUtility.getStringNumber(stringFilterValue);
                            if (!wrk3.equals("")) {
                                doubleFilterValue = Double.parseDouble(wrk3);
                            }
                            if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GE") && doubleResultValue >= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                                validated = true;
                            }
                        }
                    } else if (this.getBasicType().equals("DATE") || this.getBasicType().equals("TIME") || this.getBasicType().equals("DATETIME")) {
                        if (stringFilterValue.equals("")) {
                            validated = true;
                        } else {
                            int lengthFieldValue;
                            int lengthResultValue;
                            stringResultValue = XFUtility.getStringNumber(stringResultValue).replace("-", "");
                            doubleResultValue = Double.parseDouble(stringResultValue);
                            if (!(stringFilterValue = XFUtility.getStringNumber(stringFilterValue).replace("-", "")).equals("")) {
                                doubleFilterValue = Double.parseDouble(stringFilterValue);
                            }
                            if (this.operandType.equals("EQ") && doubleResultValue == doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GE") && !this.operandType.equals("GENERIC") && doubleResultValue >= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GT") && doubleResultValue > doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LE") && doubleResultValue <= doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("LT") && doubleResultValue < doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("NE") && doubleResultValue != doubleFilterValue) {
                                validated = true;
                            }
                            if (this.operandType.equals("GENERIC") && (lengthResultValue = stringResultValue.length()) >= (lengthFieldValue = stringFilterValue.length()) && (wrk = stringResultValue.substring(0, lengthFieldValue)).equals(stringFilterValue)) {
                                validated = true;
                            }
                        }
                    } else if (stringFilterValue.equals("")) {
                        validated = true;
                    } else {
                        StringTokenizer workTokenizer = new StringTokenizer(stringFilterValue, ";");
                        while (workTokenizer.hasMoreTokens()) {
                            String wrk4;
                            int lengthFieldValue;
                            if (this.operandType.equals("EQ") && stringResultValue.equals(workTokenizer.nextToken())) {
                                validated = true;
                            }
                            if (this.operandType.equals("NE") && !stringResultValue.equals(workTokenizer.nextToken())) {
                                validated = true;
                            }
                            if (this.operandType.equals("SCAN") && stringResultValue.contains(workTokenizer.nextToken())) {
                                validated = true;
                            }
                            if (!this.operandType.equals("GENERIC")) continue;
                            String wrkStr = workTokenizer.nextToken();
                            int lengthResultValue = stringResultValue.length();
                            if (lengthResultValue < (lengthFieldValue = wrkStr.length()) || !(wrk4 = stringResultValue.substring(0, lengthFieldValue)).equals(wrkStr)) continue;
                            validated = true;
                        }
                    }
                }
            } else {
                validated = true;
            }
        }
        return validated;
    }

    public String getStringValue() {
        String value = "";
        if (this.componentType.equals("TEXTFIELD") || this.componentType.equals("ASSISTFIELD")) {
            if (this.componentType.equals("TEXTFIELD")) {
                value = this.xFTextField.getInternalValue().toString().trim();
            }
            if (this.componentType.equals("ASSISTFIELD")) {
                value = this.xFInputAssistField.getInternalValue().toString().trim();
            }
        }
        if (this.componentType.equals("BOOLEAN")) {
            value = (String)this.xFCheckBox.getInternalValue();
        }
        if (this.componentType.equals("DATE")) {
            value = this.xFDateField.getInternalValue() == null ? "" : this.xFDateField.getInternalValue().toString();
        }
        if (this.componentType.equals("YMONTH")) {
            value = this.xFYMonthBox.getInternalValue() == null ? "" : this.xFYMonthBox.getInternalValue().toString();
        }
        if (this.componentType.equals("MSEQ")) {
            value = this.xFMSeqBox.getInternalValue() == null ? "" : this.xFMSeqBox.getInternalValue().toString();
        }
        if (this.componentType.equals("FYEAR")) {
            value = this.xFFYearBox.getInternalValue() == null ? "" : this.xFFYearBox.getInternalValue().toString();
        }
        if (this.componentType.equals("KUBUN_LIST")) {
            value = this.keyValueList.get(this.jComboBox.getSelectedIndex());
        }
        if (this.componentType.equals("RECORDS_LIST") || this.componentType.equals("VALUES_LIST")) {
            value = (String)this.jComboBox.getSelectedItem();
        }
        if (this.componentType.equals("PROMPT_CALL")) {
            value = this.xFPromptCall.getInternalValue().toString();
        }
        return value;
    }
}

