/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Element;
import xeadDriver.XF310;
import xeadDriver.XF310_HeaderReferTable;
import xeadDriver.XFEditableField;
import xeadDriver.XFHashMap;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

class XF310_HeaderComboBox
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private String dataTypeOptions_ = "";
    private String tableID = "";
    private String tableAlias = "";
    private String fieldID = "";
    private int rows_ = 1;
    private String listType = "";
    private ArrayList<String> kubunKeyValueList = new ArrayList();
    private ArrayList<XFHashMap> tableKeyValuesList = new ArrayList();
    private JTextField jTextField = new JTextField();
    private JComboBox<String> jComboBox = new JComboBox();
    private boolean isEditable = true;
    private ArrayList<String> keyFieldList = new ArrayList();
    private XF310_HeaderReferTable referTable_ = null;
    private XF310 dialog_;
    private String oldValue = "";
    private int indexOfField = -1;

    public XF310_HeaderComboBox(String dataSourceName, String dataTypeOptions, XF310 dialog, XF310_HeaderReferTable chainTable, boolean isNullable) {
        int fieldWidth = 0;
        String wrk = "";
        this.dataTypeOptions_ = dataTypeOptions;
        StringTokenizer workTokenizer = new StringTokenizer(dataSourceName, ".");
        this.tableID = this.tableAlias = workTokenizer.nextToken();
        this.referTable_ = chainTable;
        if (this.referTable_ != null && this.referTable_.getTableAlias().equals(this.tableAlias)) {
            this.tableID = this.referTable_.getTableID();
        }
        this.fieldID = workTokenizer.nextToken();
        this.dialog_ = dialog;
        this.indexOfField = this.dialog_.getHeaderFieldList().size();
        this.jTextField.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
        this.jTextField.setEditable(false);
        this.jTextField.setFocusable(false);
        this.jTextField.setBorder(null);
        FontMetrics metrics = this.jTextField.getFontMetrics(this.jTextField.getFont());
        this.jComboBox.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
        this.jComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x40) != 0 && e.getKeyCode() == 10) {
                    XF310_HeaderComboBox.this.jComboBox.showPopup();
                }
                if (e.getKeyCode() == 10 && !XF310_HeaderComboBox.this.jComboBox.isPopupVisible()) {
                    XF310_HeaderComboBox.this.requestFocus();
                    XF310_HeaderComboBox.this.dispatchEvent(e);
                }
            }
        });
        this.jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (XF310_HeaderComboBox.this.referTable_ != null && XF310_HeaderComboBox.this.isEditable && XF310_HeaderComboBox.this.jComboBox.getSelectedIndex() > -1) {
                    XF310_HeaderComboBox.this.referTable_.setKeyFieldValues((XFHashMap)XF310_HeaderComboBox.this.tableKeyValuesList.get(XF310_HeaderComboBox.this.jComboBox.getSelectedIndex()));
                }
            }
        });
        this.jComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                if (XF310_HeaderComboBox.this.referTable_ != null && XF310_HeaderComboBox.this.isEditable && XF310_HeaderComboBox.this.jComboBox.getSelectedIndex() >= 0) {
                    XF310_HeaderComboBox.this.referTable_.setKeyFieldValues((XFHashMap)XF310_HeaderComboBox.this.tableKeyValuesList.get(XF310_HeaderComboBox.this.jComboBox.getSelectedIndex()));
                    int i = 0;
                    while (i < XF310_HeaderComboBox.this.dialog_.getHeaderFieldList().size()) {
                        if (i > XF310_HeaderComboBox.this.indexOfField && XF310_HeaderComboBox.this.dialog_.getHeaderFieldList().get(i).getComponent() instanceof XF310_HeaderComboBox) {
                            XF310_HeaderComboBox comboBoxField = (XF310_HeaderComboBox)XF310_HeaderComboBox.this.dialog_.getHeaderFieldList().get(i).getComponent();
                            comboBoxField.setupRecordList();
                        }
                        ++i;
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                XF310_HeaderComboBox.this.setupRecordList();
            }
        });
        this.jComboBox.setBorder(null);
        String strWrk = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions_, "VALUES");
        if (!strWrk.equals("")) {
            this.listType = "VALUES_LIST";
            if (isNullable) {
                this.jComboBox.addItem("");
            }
            workTokenizer = new StringTokenizer(strWrk, ";");
            while (workTokenizer.hasMoreTokens()) {
                wrk = workTokenizer.nextToken();
                this.jComboBox.addItem(wrk);
                if (metrics.stringWidth(wrk) <= fieldWidth) continue;
                fieldWidth = metrics.stringWidth(wrk);
            }
            fieldWidth += 30;
        } else {
            strWrk = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions_, "KUBUN");
            if (!strWrk.equals("")) {
                this.listType = "KUBUN_LIST";
                if (isNullable) {
                    this.kubunKeyValueList.add("");
                    this.jComboBox.addItem("");
                }
                try {
                    XFTableOperator operator = this.dialog_.createTableOperator("Select", this.dialog_.getSession().getTableNameOfUserVariants());
                    operator.addKeyValue("IDUSERKUBUN", strWrk);
                    operator.setOrderBy("SQLIST");
                    while (operator.next()) {
                        this.kubunKeyValueList.add(operator.getValueOf("KBUSERKUBUN").toString().trim());
                        wrk = operator.getValueOf("TXUSERKUBUN").toString().trim();
                        this.jComboBox.addItem(wrk);
                        if (metrics.stringWidth(wrk) <= fieldWidth) continue;
                        fieldWidth = metrics.stringWidth(wrk);
                    }
                    fieldWidth += 30;
                    if (this.jComboBox.getItemCount() == 0) {
                        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError24")) + dataSourceName + XFUtility.RESOURCE.getString("FunctionError25"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(this.dialog_.getExceptionStream());
                    this.dialog_.setErrorAndCloseFunction();
                }
            } else if (this.referTable_ != null) {
                this.listType = "RECORDS_LIST";
                this.keyFieldList = this.referTable_.getKeyFieldIDList();
                Element workElement = this.dialog_.getSession().getFieldElement(this.tableID, this.fieldID);
                ArrayList<String> workDataTypeOptionList = XFUtility.getOptionList(workElement.getAttribute("TypeOptions"));
                int dataSize = Integer.parseInt(workElement.getAttribute("Size"));
                fieldWidth = workDataTypeOptionList.contains("KANJI") ? dataSize * 18 + 20 : dataSize * 11 + 30;
                if (fieldWidth > 800) {
                    fieldWidth = 800;
                }
            }
        }
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setSize(new Dimension(fieldWidth, 25));
        this.setLayout(new BorderLayout());
        this.add(this.jComboBox, "Center");
    }

    public void setupRecordList() {
        if (this.referTable_ != null && this.listType.equals("RECORDS_LIST")) {
            String selectedItemValue = "";
            int selectedIndex = this.jComboBox.getSelectedIndex();
            if (selectedIndex >= 0) {
                selectedItemValue = this.jComboBox.getItemAt(this.jComboBox.getSelectedIndex()).toString();
            }
            this.tableKeyValuesList.clear();
            this.jComboBox.removeAllItems();
            XFHashMap blankKeyValues = new XFHashMap();
            int i = 0;
            while (i < this.referTable_.getWithKeyFieldIDList().size()) {
                int j = 0;
                while (j < this.dialog_.getHeaderFieldList().size()) {
                    if (this.referTable_.getWithKeyFieldIDList().get(i).equals(String.valueOf(this.dialog_.getHeaderFieldList().get(j).getTableAlias()) + "." + this.dialog_.getHeaderFieldList().get(j).getFieldID())) {
                        if (this.dialog_.getHeaderFieldList().get(j).isNullable()) {
                            if (this.dialog_.getHeaderFieldList().get(j).isVisibleOnPanel() || this.dialog_.getHeaderFieldList().get(j).isControledByFieldOtherThan(this)) {
                                blankKeyValues.addValue(this.referTable_.getWithKeyFieldIDList().get(i), this.dialog_.getHeaderFieldList().get(j).getValue());
                            } else {
                                blankKeyValues.addValue(this.referTable_.getWithKeyFieldIDList().get(i), this.dialog_.getHeaderFieldList().get(j).getNullValue());
                            }
                        } else {
                            blankKeyValues.addValue(this.referTable_.getWithKeyFieldIDList().get(i), this.dialog_.getHeaderFieldList().get(j).getValue());
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this.tableKeyValuesList.add(blankKeyValues);
            this.jComboBox.addItem("");
            try {
                XFTableOperator operator = this.dialog_.createTableOperator(this.referTable_.getSelectSQL(true));
                while (operator.next()) {
                    XFHashMap keyValues = new XFHashMap();
                    int i2 = 0;
                    while (i2 < this.keyFieldList.size()) {
                        keyValues.addValue(this.referTable_.getWithKeyFieldIDList().get(i2), operator.getValueOf(this.keyFieldList.get(i2)));
                        ++i2;
                    }
                    this.tableKeyValuesList.add(keyValues);
                    this.jComboBox.addItem(operator.getValueOf(this.fieldID).toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.dialog_.getExceptionStream());
                this.dialog_.setErrorAndCloseFunction();
            }
            if (selectedIndex >= 0) {
                this.jComboBox.setSelectedItem(selectedItemValue);
            }
        }
    }

    public ArrayList<String> getKeyFieldList() {
        return this.keyFieldList;
    }

    public void setFollowingField(XFEditableField field) {
    }

    @Override
    public void setEditable(boolean editable) {
        this.removeAll();
        if (editable) {
            this.add(this.jComboBox, "Center");
        } else {
            this.add((Component)this.jTextField, "Center");
        }
        this.isEditable = editable;
    }

    @Override
    public void setToolTipText(String text) {
        this.jComboBox.setToolTipText(text);
        this.jTextField.setToolTipText(text);
    }

    @Override
    public Object getInternalValue() {
        String value = "";
        if (this.jComboBox.getSelectedIndex() >= 0) {
            if (this.listType.equals("VALUES_LIST")) {
                value = this.jComboBox.getItemAt(this.jComboBox.getSelectedIndex()).toString();
            }
            if (this.listType.equals("KUBUN_LIST")) {
                value = this.kubunKeyValueList.get(this.jComboBox.getSelectedIndex());
            }
            if (this.listType.equals("RECORDS_LIST")) {
                value = this.jComboBox.getItemAt(this.jComboBox.getSelectedIndex()).toString();
            }
        }
        return value;
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = (String)obj;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    @Override
    public Object getExternalValue() {
        return this.jComboBox.getItemAt(this.jComboBox.getSelectedIndex()).toString();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isComponentFocusable() {
        return this.jComboBox.isFocusable();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setValue(Object obj) {
        int i;
        String value = obj.toString();
        value = value.trim();
        if (this.listType.equals("VALUES_LIST")) {
            i = 0;
            while (i < this.jComboBox.getItemCount()) {
                if (this.jComboBox.getItemAt(i).toString().equals(value)) {
                    this.jComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (this.listType.equals("KUBUN_LIST")) {
            i = 0;
            while (i < this.kubunKeyValueList.size()) {
                if (this.kubunKeyValueList.get(i).equals(value)) {
                    this.jComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (this.listType.equals("RECORDS_LIST")) {
            this.setupRecordList();
            if (this.jComboBox.getItemCount() > 0 && value != null && !value.equals("")) {
                i = 0;
                while (i < this.jComboBox.getItemCount()) {
                    if (this.jComboBox.getItemAt(i).toString().equals(value)) {
                        if (i == this.jComboBox.getSelectedIndex()) break;
                        this.jComboBox.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.jComboBox.getSelectedIndex() >= 0) {
            this.jTextField.setText(this.jComboBox.getItemAt(this.jComboBox.getSelectedIndex()).toString());
        }
    }

    @Override
    public void setWidth(int width) {
        this.setSize(new Dimension(width, 25));
    }

    @Override
    public void setBackground(Color color) {
        if (this.jComboBox != null) {
            this.jComboBox.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.jTextField != null) {
            this.jTextField.setForeground(color);
        }
        if (this.jComboBox != null) {
            this.jComboBox.setForeground(color);
        }
    }

    @Override
    public int getRows() {
        return this.rows_;
    }
}

