/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import org.w3c.dom.NodeList;
import xeadDriver.Session;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XF390_DetailColumn;
import xeadDriver.XF390_DetailReferTable;
import xeadDriver.XF390_DetailTable;
import xeadDriver.XF390_HeaderField;
import xeadDriver.XF390_HeaderReferTable;
import xeadDriver.XF390_HeaderTable;
import xeadDriver.XF390_Phrase;
import xeadDriver.XFExecutable;
import xeadDriver.XFScriptable;
import xeadDriver.XFTableEvaluator;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

public class XF390
extends Component
implements XFExecutable,
XFScriptable {
    private static final long serialVersionUID = 1L;
    private org.w3c.dom.Element functionElement_ = null;
    private HashMap<String, Object> parmMap_ = null;
    private HashMap<String, Object> returnMap_ = new HashMap();
    private XF390_HeaderTable headerTable_ = null;
    private String[] captionArray = new String[10];
    private int[] captionFontSizeArray = new int[10];
    private String[] captionFontStyleArray = new String[10];
    private String[] tableFontIDArray = new String[10];
    private int[] tableFontSizeArray = new int[10];
    private int[] tableRowNoWidthArray = new int[10];
    private Session session_ = null;
    private boolean instanceIsAvailable_ = true;
    private boolean isClosing = false;
    private int programSequence;
    private StringBuffer processLog = new StringBuffer();
    private ArrayList<XF390_Phrase> headerPhraseList = new ArrayList();
    private ArrayList<XF390_Phrase> paragraphList = new ArrayList();
    private ArrayList<XF390_HeaderReferTable> headerReferTableList = new ArrayList();
    private ArrayList<XF390_DetailReferTable>[] detailReferTableListArray = new ArrayList[10];
    private NodeList[] detailReferElementListArray = new NodeList[10];
    private ArrayList<XF390_HeaderField> headerFieldList = new ArrayList();
    private XF390_DetailTable[] detailTableArray = new XF390_DetailTable[10];
    private ArrayList<XF390_DetailColumn>[] detailColumnListArray = new ArrayList[10];
    private HashMap<String, CompiledScript>[] compiledScriptMapArray = new HashMap[10];
    private ScriptEngine scriptEngine;
    private Bindings headerScriptBindings;
    private Bindings[] detailScriptBindingsArray = new Bindings[10];
    private String scriptNameRunning = "";
    private ByteArrayOutputStream exceptionLog;
    private PrintStream exceptionStream;
    private String exceptionHeader = "";
    private SortableDomElementListModel sortingList1;
    private SortableDomElementListModel sortingList2;
    private ArrayList<WorkingRow> workingRowList = new ArrayList();
    private HashMap<String, Object> variantMap = new HashMap();
    private SortableDomElementListModel detailSortingList;
    private int evaluatingScriptTabIndex = -1;

    public XF390(Session session, int instanceArrayIndex) {
        this.session_ = session;
    }

    @Override
    public boolean isAvailable() {
        return this.instanceIsAvailable_;
    }

    @Override
    public HashMap<String, Object> execute(HashMap<String, Object> parmMap) {
        if (this.functionElement_ == null) {
            JOptionPane.showMessageDialog(null, "Calling function without specifications.");
            return parmMap;
        }
        return this.execute(null, parmMap);
    }

    @Override
    public HashMap<String, Object> execute(org.w3c.dom.Element functionElement, HashMap<String, Object> parmMap) {
        block11: {
            try {
                try {
                    this.setCursor(new Cursor(3));
                    this.parmMap_ = parmMap;
                    if (this.parmMap_ == null) {
                        this.parmMap_ = new HashMap();
                    }
                    this.returnMap_.clear();
                    this.returnMap_.putAll(this.parmMap_);
                    this.returnMap_.put("RETURN_CODE", "00");
                    this.instanceIsAvailable_ = false;
                    this.isClosing = false;
                    this.exceptionLog = new ByteArrayOutputStream();
                    this.exceptionStream = new PrintStream(this.exceptionLog);
                    this.exceptionHeader = "";
                    this.processLog.delete(0, this.processLog.length());
                    this.variantMap.clear();
                    if (!(functionElement == null || this.functionElement_ != null && this.functionElement_.getAttribute("ID").equals(functionElement.getAttribute("ID")))) {
                        this.setFunctionSpecifications(functionElement);
                    }
                    this.scriptEngine = this.session_.getScriptEngineManager().getEngineByName("js");
                    this.headerScriptBindings = this.scriptEngine.createBindings();
                    this.headerScriptBindings.put("instance", (Object)this);
                    int i = 0;
                    while (i < this.headerFieldList.size()) {
                        this.headerScriptBindings.put(this.headerFieldList.get(i).getDataSourceID(), (Object)this.headerFieldList.get(i));
                        ++i;
                    }
                    i = 0;
                    while (i < this.detailSortingList.getSize()) {
                        this.detailScriptBindingsArray[i] = this.scriptEngine.createBindings();
                        this.detailScriptBindingsArray[i].putAll(this.headerScriptBindings);
                        int j = 0;
                        while (j < this.detailColumnListArray[i].size()) {
                            this.detailScriptBindingsArray[i].put(this.detailColumnListArray[i].get(j).getDataSourceID(), (Object)this.detailColumnListArray[i].get(j));
                            ++j;
                        }
                        ++i;
                    }
                    this.fetchHeaderTableRecord();
                    if (!this.isClosing) {
                        this.session_.browseFile(this.createPDFFileAndGetURI());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("FunctionError5"));
                    e.printStackTrace(this.exceptionStream);
                    this.setErrorAndCloseFunction();
                    this.setCursor(new Cursor(0));
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.setCursor(new Cursor(0));
                throw throwable;
            }
            this.setCursor(new Cursor(0));
        }
        this.closeFunction();
        return this.returnMap_;
    }

    @Override
    public void setFunctionSpecifications(org.w3c.dom.Element functionElement) throws Exception {
        org.w3c.dom.Element workElement;
        String workFieldID;
        String workTableID;
        String workAlias;
        StringTokenizer workTokenizer;
        int j;
        this.functionElement_ = functionElement;
        this.programSequence = this.session_.writeLogOfFunctionStarted(this.functionElement_.getAttribute("ID"), this.functionElement_.getAttribute("Name"));
        this.headerTable_ = new XF390_HeaderTable(this.functionElement_, this);
        this.headerReferTableList.clear();
        NodeList referNodeList = this.headerTable_.getTableElement().getElementsByTagName("Refer");
        SortableDomElementListModel sortedList = XFUtility.getSortedListModel(referNodeList, "Order");
        int i = 0;
        while (i < sortedList.getSize()) {
            org.w3c.dom.Element element = (org.w3c.dom.Element)sortedList.getElementAt(i);
            this.headerReferTableList.add(new XF390_HeaderReferTable(element, this));
            ++i;
        }
        this.headerPhraseList.clear();
        this.headerFieldList.clear();
        this.paragraphList.clear();
        NodeList nodeList = this.functionElement_.getElementsByTagName("HeaderPhrase");
        SortableDomElementListModel sortableList = XFUtility.getSortedListModel(nodeList, "Order");
        int i2 = 0;
        while (i2 < sortableList.getSize()) {
            XF390_Phrase phrase = new XF390_Phrase((org.w3c.dom.Element)sortableList.getElementAt(i2));
            if (phrase.getBlock().equals("HEADER")) {
                this.headerPhraseList.add(phrase);
            } else {
                this.paragraphList.add(phrase);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.headerPhraseList.size()) {
            j = 0;
            while (j < this.headerPhraseList.get(i2).getDataSourceNameList().size()) {
                if (!this.existsInFieldList(this.headerPhraseList.get(i2).getDataSourceNameList().get(j))) {
                    this.headerFieldList.add(new XF390_HeaderField(this.headerPhraseList.get(i2).getDataSourceNameList().get(j), this));
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.paragraphList.size()) {
            j = 0;
            while (j < this.paragraphList.get(i2).getDataSourceNameList().size()) {
                if (!this.existsInFieldList(this.paragraphList.get(i2).getDataSourceNameList().get(j))) {
                    this.headerFieldList.add(new XF390_HeaderField(this.paragraphList.get(i2).getDataSourceNameList().get(j), this));
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.headerTable_.getKeyFieldList().size()) {
            if (!this.existsInFieldList(this.headerTable_.getTableID(), "", this.headerTable_.getKeyFieldList().get(i2))) {
                this.headerFieldList.add(new XF390_HeaderField(this.headerTable_.getTableID(), "", this.headerTable_.getKeyFieldList().get(i2), this));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.headerTable_.getScriptList().size()) {
            if (this.headerTable_.getScriptList().get(i2).isToBeRunAtEvent("BR", "") || this.headerTable_.getScriptList().get(i2).isToBeRunAtEvent("AR", "")) {
                j = 0;
                while (j < this.headerTable_.getScriptList().get(i2).getFieldList().size()) {
                    workTokenizer = new StringTokenizer(this.headerTable_.getScriptList().get(i2).getFieldList().get(j), ".");
                    workAlias = workTokenizer.nextToken();
                    workTableID = this.getTableIDOfTableAlias(workAlias, -1);
                    if (!this.existsInFieldList(workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                        workElement = this.session_.getFieldElement(workTableID, workFieldID);
                        if (workElement == null) {
                            String msg = String.valueOf(XFUtility.RESOURCE.getString("FunctionError1")) + this.headerTable_.getTableID() + XFUtility.RESOURCE.getString("FunctionError2") + this.headerTable_.getScriptList().get(i2).getName() + XFUtility.RESOURCE.getString("FunctionError3") + workAlias + "_" + workFieldID + XFUtility.RESOURCE.getString("FunctionError4");
                            JOptionPane.showMessageDialog(null, msg);
                            throw new Exception(msg);
                        }
                        if (this.headerTable_.isValidDataSource(workTableID, workAlias, workFieldID)) {
                            this.headerFieldList.add(new XF390_HeaderField(workTableID, workAlias, workFieldID, this));
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.headerFieldList.size()) {
            if (this.headerFieldList.get(i2).getBasicType().equals("BYTEA") && !this.headerFieldList.get(i2).getByteaTypeFieldID().equals("") && !this.existsInFieldList(this.headerTable_.getTableID(), "", this.headerFieldList.get(i2).getByteaTypeFieldID())) {
                this.headerFieldList.add(new XF390_HeaderField(this.headerTable_.getTableID(), "", this.headerFieldList.get(i2).getByteaTypeFieldID(), this));
            }
            ++i2;
        }
        i2 = this.headerReferTableList.size() - 1;
        while (i2 > -1) {
            j = 0;
            while (j < this.headerReferTableList.get(i2).getFieldIDList().size()) {
                if (this.existsInFieldList(this.headerReferTableList.get(i2).getTableID(), this.headerReferTableList.get(i2).getTableAlias(), this.headerReferTableList.get(i2).getFieldIDList().get(j))) {
                    this.headerReferTableList.get(i2).setToBeExecuted(true);
                    break;
                }
                ++j;
            }
            if (this.headerReferTableList.get(i2).isToBeExecuted()) {
                j = 0;
                while (j < this.headerReferTableList.get(i2).getFieldIDList().size()) {
                    if (!this.existsInFieldList(this.headerReferTableList.get(i2).getTableID(), this.headerReferTableList.get(i2).getTableAlias(), this.headerReferTableList.get(i2).getFieldIDList().get(j))) {
                        this.headerFieldList.add(new XF390_HeaderField(this.headerReferTableList.get(i2).getTableID(), this.headerReferTableList.get(i2).getTableAlias(), this.headerReferTableList.get(i2).getFieldIDList().get(j), this));
                    }
                    ++j;
                }
                j = 0;
                while (j < this.headerReferTableList.get(i2).getWithKeyFieldIDList().size()) {
                    workTokenizer = new StringTokenizer(this.headerReferTableList.get(i2).getWithKeyFieldIDList().get(j), ".");
                    workAlias = workTokenizer.nextToken();
                    workTableID = this.getTableIDOfTableAlias(workAlias, -1);
                    if (!this.existsInFieldList(workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                        this.headerFieldList.add(new XF390_HeaderField(workTableID, workAlias, workFieldID, this));
                    }
                    ++j;
                }
            }
            --i2;
        }
        NodeList detailElementList = this.functionElement_.getElementsByTagName("Detail");
        this.detailSortingList = XFUtility.getSortedListModel(detailElementList, "Order");
        if (this.detailSortingList.getSize() == 0) {
            workElement = (org.w3c.dom.Element)this.functionElement_.cloneNode(true);
            workElement.setAttribute("Caption", "");
            workElement.setAttribute("CaptionFontSize", "");
            workElement.setAttribute("CaptionFontStyle", "");
            workElement.setAttribute("Table", workElement.getAttribute("DetailTable"));
            workElement.setAttribute("TableKey", workElement.getAttribute("DetailTableKey"));
            workElement.setAttribute("FontID", workElement.getAttribute("TableFontID"));
            workElement.setAttribute("FontSize", workElement.getAttribute("TableFontSize"));
            this.detailSortingList.addElement(workElement);
        }
        int i3 = 0;
        while (i3 < this.detailSortingList.getSize()) {
            int k;
            workElement = (org.w3c.dom.Element)this.detailSortingList.getElementAt(i3);
            this.captionArray[i3] = workElement.getAttribute("Caption");
            this.captionFontSizeArray[i3] = workElement.getAttribute("CaptionFontSize").equals("") ? 12 : Integer.parseInt(workElement.getAttribute("CaptionFontSize"));
            this.captionFontStyleArray[i3] = workElement.getAttribute("CaptionFontStyle");
            this.tableFontIDArray[i3] = workElement.getAttribute("FontID");
            this.tableFontSizeArray[i3] = Integer.parseInt(workElement.getAttribute("FontSize"));
            try {
                this.tableRowNoWidthArray[i3] = Integer.parseInt(workElement.getAttribute("RowNoWidth"));
            }
            catch (Exception e) {
                this.tableRowNoWidthArray[i3] = 0;
            }
            this.detailTableArray[i3] = new XF390_DetailTable(workElement, i3, this);
            this.detailReferTableListArray[i3] = new ArrayList();
            this.detailReferElementListArray[i3] = this.detailTableArray[i3].getTableElement().getElementsByTagName("Refer");
            this.sortingList2 = XFUtility.getSortedListModel(this.detailReferElementListArray[i3], "Order");
            int j2 = 0;
            while (j2 < this.sortingList2.getSize()) {
                this.detailReferTableListArray[i3].add(new XF390_DetailReferTable((org.w3c.dom.Element)this.sortingList2.getElementAt(j2), i3, this));
                ++j2;
            }
            this.compiledScriptMapArray[i3] = new HashMap();
            this.detailColumnListArray[i3] = new ArrayList();
            NodeList columnFieldList = workElement.getElementsByTagName("Column");
            this.sortingList1 = XFUtility.getSortedListModel(columnFieldList, "Order");
            int j3 = 0;
            while (j3 < this.sortingList1.getSize()) {
                this.detailColumnListArray[i3].add(new XF390_DetailColumn((org.w3c.dom.Element)this.sortingList1.getElementAt(j3), i3, this));
                ++j3;
            }
            j3 = 0;
            while (j3 < this.detailTableArray[i3].getKeyFieldIDList().size()) {
                if (!this.containsDetailField(i3, this.detailTableArray[i3].getTableID(), "", this.detailTableArray[i3].getKeyFieldIDList().get(j3))) {
                    this.detailColumnListArray[i3].add(new XF390_DetailColumn(this.detailTableArray[i3].getTableID(), "", this.detailTableArray[i3].getKeyFieldIDList().get(j3), i3, this));
                }
                ++j3;
            }
            j3 = 0;
            while (j3 < this.detailTableArray[i3].getOrderByFieldIDList().size()) {
                String workStr = this.detailTableArray[i3].getOrderByFieldIDList().get(j3).replace("(D)", "");
                workTokenizer = new StringTokenizer(workStr = workStr.replace("(A)", ""), ".");
                workAlias = workTokenizer.nextToken();
                workTableID = this.getTableIDOfTableAlias(workAlias, i3);
                if (!this.containsDetailField(i3, workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                    this.detailColumnListArray[i3].add(new XF390_DetailColumn(workTableID, workAlias, workFieldID, i3, this));
                }
                ++j3;
            }
            j3 = 0;
            while (j3 < this.detailTableArray[i3].getScriptList().size()) {
                if (this.detailTableArray[i3].getScriptList().get(j3).isToBeRunAtEvent("BR", "") || this.detailTableArray[i3].getScriptList().get(j3).isToBeRunAtEvent("AR", "")) {
                    k = 0;
                    while (k < this.detailTableArray[i3].getScriptList().get(j3).getFieldList().size()) {
                        workTokenizer = new StringTokenizer(this.detailTableArray[i3].getScriptList().get(j3).getFieldList().get(k), ".");
                        workAlias = workTokenizer.nextToken();
                        workTableID = this.getTableIDOfTableAlias(workAlias, i3);
                        if (!this.containsDetailField(i3, workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                            workElement = this.session_.getFieldElement(workTableID, workFieldID);
                            if (workElement == null) {
                                String msg = String.valueOf(XFUtility.RESOURCE.getString("FunctionError1")) + this.detailTableArray[i3].getTableID() + XFUtility.RESOURCE.getString("FunctionError2") + this.detailTableArray[i3].getScriptList().get(j3).getName() + XFUtility.RESOURCE.getString("FunctionError3") + workAlias + "_" + workFieldID + XFUtility.RESOURCE.getString("FunctionError4");
                                JOptionPane.showMessageDialog(null, msg);
                                throw new Exception(msg);
                            }
                            if (this.detailTableArray[i3].isValidDataSource(workTableID, workAlias, workFieldID)) {
                                this.detailColumnListArray[i3].add(new XF390_DetailColumn(workTableID, workAlias, workFieldID, i3, this));
                            }
                        }
                        ++k;
                    }
                }
                ++j3;
            }
            j3 = 0;
            while (j3 < this.detailColumnListArray[i3].size()) {
                if (this.detailColumnListArray[i3].get(j3).getBasicType().equals("BYTEA") && !this.detailColumnListArray[i3].get(j3).getByteaTypeFieldID().equals("") && !this.containsDetailField(i3, this.detailTableArray[i3].getTableID(), "", this.detailColumnListArray[i3].get(j3).getByteaTypeFieldID())) {
                    this.detailColumnListArray[i3].add(new XF390_DetailColumn(this.detailTableArray[i3].getTableID(), "", this.detailColumnListArray[i3].get(j3).getByteaTypeFieldID(), i3, this));
                }
                ++j3;
            }
            j3 = this.detailReferTableListArray[i3].size() - 1;
            while (j3 > -1) {
                k = 0;
                while (k < this.detailReferTableListArray[i3].get(j3).getFieldIDList().size()) {
                    if (this.containsDetailField(i3, this.detailReferTableListArray[i3].get(j3).getTableID(), this.detailReferTableListArray[i3].get(j3).getTableAlias(), this.detailReferTableListArray[i3].get(j3).getFieldIDList().get(k))) {
                        this.detailReferTableListArray[i3].get(j3).setToBeExecuted(true);
                        break;
                    }
                    ++k;
                }
                if (this.detailReferTableListArray[i3].get(j3).isToBeExecuted()) {
                    k = 0;
                    while (k < this.detailReferTableListArray[i3].get(j3).getFieldIDList().size()) {
                        if (!this.containsDetailField(i3, this.detailReferTableListArray[i3].get(j3).getTableID(), this.detailReferTableListArray[i3].get(j3).getTableAlias(), this.detailReferTableListArray[i3].get(j3).getFieldIDList().get(k))) {
                            this.detailColumnListArray[i3].add(new XF390_DetailColumn(this.detailReferTableListArray[i3].get(j3).getTableID(), this.detailReferTableListArray[i3].get(j3).getTableAlias(), this.detailReferTableListArray[i3].get(j3).getFieldIDList().get(k), i3, this));
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < this.detailReferTableListArray[i3].get(j3).getWithKeyFieldIDList().size()) {
                        workTokenizer = new StringTokenizer(this.detailReferTableListArray[i3].get(j3).getWithKeyFieldIDList().get(k), ".");
                        workAlias = workTokenizer.nextToken();
                        workTableID = this.getTableIDOfTableAlias(workAlias, i3);
                        if (!this.containsDetailField(i3, workTableID, workAlias, workFieldID = workTokenizer.nextToken())) {
                            this.detailColumnListArray[i3].add(new XF390_DetailColumn(workTableID, workAlias, workFieldID, i3, this));
                        }
                        ++k;
                    }
                }
                --j3;
            }
            ++i3;
        }
    }

    @Override
    public void setErrorAndCloseFunction() {
        this.returnMap_.put("RETURN_CODE", "99");
        this.rollback();
        this.closeFunction();
    }

    void closeFunction() {
        if (!this.returnMap_.get("RETURN_CODE").equals("99")) {
            this.commit();
        }
        this.instanceIsAvailable_ = true;
        String errorLog = "";
        if (this.exceptionLog.size() > 0 || !this.exceptionHeader.equals("")) {
            errorLog = String.valueOf(this.exceptionHeader) + this.exceptionLog.toString();
        }
        this.session_.writeLogOfFunctionClosed(this.programSequence, this.returnMap_.get("RETURN_CODE").toString(), this.processLog.toString(), errorLog);
    }

    @Override
    public void cancelWithMessage(String message) {
        if (!message.equals("")) {
            JOptionPane.showMessageDialog(null, message);
        }
        this.returnMap_.put("RETURN_CODE", "01");
        this.isClosing = true;
    }

    @Override
    public void cancelWithScriptException(ScriptException e, String scriptName) {
        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError7")) + scriptName + XFUtility.RESOURCE.getString("FunctionError8"));
        this.exceptionHeader = "'" + scriptName + "' Script error\n";
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.setErrorAndCloseFunction();
    }

    @Override
    public void cancelWithException(Exception e) {
        JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError5")) + "\n" + e.getMessage());
        e.printStackTrace(this.exceptionStream);
        this.rollback();
        this.setErrorAndCloseFunction();
    }

    @Override
    public void callFunction(String functionID) {
        try {
            this.returnMap_ = this.session_.executeFunction(functionID, this.parmMap_);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            this.exceptionHeader = e.getMessage();
            this.setErrorAndCloseFunction();
        }
    }

    @Override
    public void setStatusMessage(String message) {
        this.setStatusMessage(message, false);
    }

    @Override
    public void setStatusMessage(String message, boolean isToReplaceLastLine) {
    }

    @Override
    public void startProgress(String text, int maxValue) {
    }

    @Override
    public void incrementProgress() {
    }

    @Override
    public void endProgress() {
    }

    @Override
    public void commit() {
        this.session_.commit(true, this.processLog);
    }

    @Override
    public void rollback() {
        this.session_.commit(false, this.processLog);
    }

    /*
     * Loose catch block
     */
    private URI createPDFFileAndGetURI() {
        File pdfFile;
        block12: {
            pdfFile = null;
            String pdfFileName = "";
            FileOutputStream fileOutputStream = null;
            float leftMargin = 50.0f;
            float rightMargin = 50.0f;
            float topMargin = 50.0f;
            float bottomMargin = 50.0f;
            StringTokenizer workTokenizer = new StringTokenizer(this.functionElement_.getAttribute("Margins"), ";");
            try {
                leftMargin = Float.parseFloat(workTokenizer.nextToken());
                rightMargin = Float.parseFloat(workTokenizer.nextToken());
                topMargin = Float.parseFloat(workTokenizer.nextToken());
                bottomMargin = Float.parseFloat(workTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Rectangle pageSize = XFUtility.getPageSize(this.functionElement_.getAttribute("PageSize"), this.functionElement_.getAttribute("Direction"));
            Document pdfDoc = new Document(pageSize, leftMargin, rightMargin, topMargin, bottomMargin);
            try {
                pdfFile = this.session_.createTempFile(this.functionElement_.getAttribute("ID"), ".pdf");
                pdfFileName = pdfFile.getPath();
                this.returnMap_.put("FILE_NAME", pdfFileName);
                fileOutputStream = new FileOutputStream(pdfFileName);
                PdfWriter writer = PdfWriter.getInstance((Document)pdfDoc, (OutputStream)fileOutputStream);
                writer.setStrictImageSequence(true);
                pdfDoc.addTitle(this.functionElement_.getAttribute("Name"));
                pdfDoc.addAuthor(this.session_.getUserName());
                pdfDoc.addCreator("XEAD Driver");
                this.addHeaderToDocument(pdfDoc);
                if (this.functionElement_.getAttribute("WithPageNumber").equals("T")) {
                    HeaderFooter footer = new HeaderFooter(new Phrase("--"), new Phrase("--"));
                    footer.setAlignment(1);
                    footer.setBorder(0);
                    pdfDoc.setFooter(footer);
                }
                pdfDoc.open();
                PdfContentByte cb = writer.getDirectContent();
                this.addParagraphsToDocument(pdfDoc, "PARAGRAPH", cb);
                this.addTablesToDocument(pdfDoc, cb);
                this.addParagraphsToDocument(pdfDoc, "FOOTER", cb);
            }
            catch (DocumentException e) {
                e.printStackTrace();
                pdfDoc.close();
                break block12;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block12;
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                pdfDoc.close();
                break block12;
            }
            {
                finally {
                    pdfDoc.close();
                }
            }
            pdfDoc.close();
        }
        return pdfFile.toURI();
    }

    private void addHeaderToDocument(Document pdfDoc) {
        Chunk chunk;
        Font chunkFont;
        Phrase phrase;
        Font font;
        if (this.headerPhraseList.size() == 1) {
            font = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(0).getFontID()), (float)this.headerPhraseList.get(0).getFontSize(), this.headerPhraseList.get(0).getFontStyle());
            phrase = new Phrase("", font);
            int i = 0;
            while (i < this.headerPhraseList.get(0).getValueKeywordList().size()) {
                chunkFont = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(0).getFontID()), (float)this.headerPhraseList.get(0).getFontSize(), this.headerPhraseList.get(0).getFontStyle());
                chunk = this.getChunkForKeyword(this.headerPhraseList.get(0).getValueKeywordList().get(i), null, chunkFont);
                if (chunk != null) {
                    phrase.add((Object)chunk);
                }
                ++i;
            }
            HeaderFooter header = new HeaderFooter(phrase, false);
            header.setAlignment(this.headerPhraseList.get(0).getAlignment());
            pdfDoc.setHeader(header);
        }
        if (this.headerPhraseList.size() > 1) {
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setBorder(0);
            int i = 0;
            while (i < this.headerPhraseList.size()) {
                font = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(i).getFontID()), (float)this.headerPhraseList.get(i).getFontSize(), this.headerPhraseList.get(i).getFontStyle());
                phrase = new Phrase("", font);
                int j = 0;
                while (j < this.headerPhraseList.get(i).getValueKeywordList().size()) {
                    chunkFont = new Font(this.session_.getBaseFontWithID(this.headerPhraseList.get(i).getFontID()), (float)this.headerPhraseList.get(i).getFontSize(), this.headerPhraseList.get(i).getFontStyle());
                    chunk = this.getChunkForKeyword(this.headerPhraseList.get(i).getValueKeywordList().get(j), null, chunkFont);
                    if (chunk != null) {
                        phrase.add((Object)chunk);
                    }
                    ++j;
                }
                PdfPCell cell = new PdfPCell(table.getDefaultCell());
                cell.setHorizontalAlignment(this.headerPhraseList.get(i).getAlignment());
                cell.setPhrase(phrase);
                table.addCell(cell);
                ++i;
            }
            if (this.headerPhraseList.size() % 2 != 0) {
                phrase = new Phrase("");
                PdfPCell cell = new PdfPCell(table.getDefaultCell());
                cell.setPhrase(phrase);
                table.addCell(cell);
            }
            Paragraph paragraph = new Paragraph();
            paragraph.add((Object)table);
            HeaderFooter header = new HeaderFooter((Phrase)paragraph, false);
            header.setBorder(0);
            pdfDoc.setHeader(header);
        }
    }

    private void addParagraphsToDocument(Document pdfDoc, String blockType, PdfContentByte cb) throws IOException, DocumentException {
        Paragraph paragraph = null;
        String keyword = "";
        int i = 0;
        while (i < this.paragraphList.size()) {
            if (this.paragraphList.get(i).getBlock().equals(blockType)) {
                paragraph = new Paragraph(new Phrase(""));
                paragraph.setAlignment(this.paragraphList.get(i).getAlignment());
                paragraph.setIndentationRight(this.paragraphList.get(i).getMarginRight());
                paragraph.setIndentationLeft(this.paragraphList.get(i).getMarginLeft());
                paragraph.setSpacingAfter(this.paragraphList.get(i).getSpacingAfter());
                Font font = new Font(this.session_.getBaseFontWithID(this.paragraphList.get(i).getFontID()), (float)this.paragraphList.get(i).getFontSize(), this.paragraphList.get(i).getFontStyle());
                Phrase phrase = new Phrase("", font);
                int j = 0;
                while (j < this.paragraphList.get(i).getValueKeywordList().size()) {
                    keyword = this.paragraphList.get(i).getValueKeywordList().get(j);
                    if ((keyword.contains("&Line(") || keyword.contains("&Rect(")) && cb != null) {
                        XFUtility.drawLineOrRect(keyword, cb);
                    } else {
                        Font chunkFont = new Font(this.session_.getBaseFontWithID(this.paragraphList.get(i).getFontID()), (float)this.paragraphList.get(i).getFontSize(), this.paragraphList.get(i).getFontStyle());
                        Chunk chunk = this.getChunkForKeyword(keyword, cb, chunkFont);
                        if (chunk != null) {
                            phrase.add((Object)chunk);
                        }
                    }
                    ++j;
                }
                paragraph.add((Object)phrase);
                pdfDoc.add((Element)paragraph);
            }
            ++i;
        }
    }

    private void addTablesToDocument(Document pdfDoc, PdfContentByte cb) throws IOException, DocumentException {
        int i = 0;
        while (i < this.detailSortingList.getSize()) {
            this.addTableToDocument(pdfDoc, cb, i);
            ++i;
        }
    }

    private void addTableToDocument(Document pdfDoc, PdfContentByte cb, int index) throws IOException, DocumentException {
        String imageFileName = "";
        try {
            Chunk chunk;
            Font fontTableCellData;
            Phrase phrase;
            if (!this.captionArray[index].equals("")) {
                Paragraph paragraph = new Paragraph(new Phrase(""));
                paragraph.setAlignment(this.paragraphList.get(0).getAlignment());
                paragraph.setSpacingBefore(5.0f);
                paragraph.setSpacingAfter(-14.0f);
                Font captionFont = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.captionFontSizeArray[index], this.getFontStyle(this.captionFontStyleArray[index]));
                phrase = new Phrase("", captionFont);
                phrase.add((Object)this.getChunkForKeyword("&Text(" + this.captionArray[index] + ")", cb, captionFont));
                paragraph.add((Object)phrase);
                pdfDoc.add((Element)paragraph);
            }
            Font fontTableCell = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.tableFontSizeArray[index], 1);
            int totalWidth = 0;
            int[] width = null;
            int columnCount = 0;
            int i = 0;
            while (i < this.detailColumnListArray[index].size()) {
                if (this.detailColumnListArray[index].get(i).isVisibleColumn()) {
                    ++columnCount;
                }
                ++i;
            }
            Table table = new Table(columnCount + 1);
            if (this.tableRowNoWidthArray[index] == 0) {
                table = new Table(columnCount);
                width = new int[columnCount];
            } else {
                width = new int[columnCount + 1];
                totalWidth = this.tableRowNoWidthArray[index];
                width[0] = this.tableRowNoWidthArray[index];
                Cell cell = new Cell((Element)new Phrase("No", fontTableCell));
                cell.setBackgroundColor(Color.lightGray);
                cell.setHorizontalAlignment(1);
                table.addCell(cell);
            }
            table.setAlignment(0);
            int wrkInt = -1;
            int i2 = 0;
            while (i2 < this.detailColumnListArray[index].size()) {
                if (this.detailColumnListArray[index].get(i2).isVisibleColumn()) {
                    ++wrkInt;
                    if (this.tableRowNoWidthArray[index] == 0) {
                        width[wrkInt] = this.detailColumnListArray[index].get(i2).getWidth();
                    } else {
                        width[wrkInt + 1] = this.detailColumnListArray[index].get(i2).getWidth();
                    }
                    totalWidth += this.detailColumnListArray[index].get(i2).getWidth();
                    Cell cell = new Cell((Element)new Phrase(this.detailColumnListArray[index].get(i2).getCaption(), fontTableCell));
                    cell.setBackgroundColor(Color.lightGray);
                    cell.setHorizontalAlignment(this.detailColumnListArray[index].get(i2).getAlignment());
                    table.addCell(cell);
                }
                if (this.detailColumnListArray[index].get(i2).isWithTotal()) {
                    this.detailColumnListArray[index].get(i2).clearSummary();
                }
                ++i2;
            }
            table.setWidths(width);
            table.setWidth((float)totalWidth);
            table.setBorderWidth(1.0f);
            table.setBorderColor(new Color(0, 0, 0));
            table.setPadding(2.0f);
            table.setSpacing(0.0f);
            this.workingRowList.clear();
            int countOfRows = 0;
            int rowNo = 0;
            XFTableOperator operatorDetail = this.createTableOperator(this.detailTableArray[index].getSQLToSelect());
            while (operatorDetail.next()) {
                int j;
                int i3 = 0;
                while (i3 < this.detailColumnListArray[index].size()) {
                    this.detailColumnListArray[index].get(i3).initialize();
                    ++i3;
                }
                this.detailTableArray[index].runScript("BR", "");
                i3 = 0;
                while (i3 < this.detailColumnListArray[index].size()) {
                    if (this.detailColumnListArray[index].get(i3).getTableAlias().equals(this.detailTableArray[index].getTableID())) {
                        this.detailColumnListArray[index].get(i3).setValueOfResultSet(operatorDetail);
                    }
                    ++i3;
                }
                this.detailTableArray[index].runScript("AR", "BR()");
                i3 = 0;
                while (i3 < this.detailReferTableListArray[index].size()) {
                    if (this.detailReferTableListArray[index].get(i3).isToBeExecuted()) {
                        this.detailTableArray[index].runScript("AR", "BR(" + this.detailReferTableListArray[index].get(i3).getTableAlias() + ")");
                        XFTableOperator operatorRefer = this.createTableOperator(this.detailReferTableListArray[index].get(i3).getSelectSQL());
                        if (operatorRefer.next()) {
                            j = 0;
                            while (j < this.detailColumnListArray[index].size()) {
                                if (this.detailColumnListArray[index].get(j).getTableAlias().equals(this.detailReferTableListArray[index].get(i3).getTableAlias())) {
                                    this.detailColumnListArray[index].get(j).setValueOfResultSet(operatorRefer);
                                }
                                ++j;
                            }
                            this.detailTableArray[index].runScript("AR", "AR(" + this.detailReferTableListArray[index].get(i3).getTableAlias() + ")");
                        }
                    }
                    ++i3;
                }
                this.detailTableArray[index].runScript("AR", "AR()");
                i3 = 0;
                while (i3 < this.detailColumnListArray[index].size()) {
                    if (this.detailColumnListArray[index].get(i3).getBasicType().equals("BYTEA")) {
                        this.detailColumnListArray[index].get(i3).setByteaType(this.detailColumnListArray[index]);
                    }
                    ++i3;
                }
                HashMap<String, Object> keyMap = new HashMap<String, Object>();
                i3 = 0;
                while (i3 < this.detailTableArray[index].getKeyFieldIDList().size()) {
                    keyMap.put(this.detailTableArray[index].getKeyFieldIDList().get(i3), operatorDetail.getValueOf(this.detailTableArray[index].getKeyFieldIDList().get(i3)));
                    ++i3;
                }
                if (this.detailTableArray[index].hasOrderByAsItsOwnPhysicalFields()) {
                    if (this.tableRowNoWidthArray[index] > 0) {
                        fontTableCellData = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.tableFontSizeArray[index], 0);
                        Cell cell = new Cell((Element)new Phrase("" + ++rowNo, fontTableCellData));
                        cell.setHorizontalAlignment(1);
                        if (countOfRows % 2 != 0) {
                            cell.setBackgroundColor(XFUtility.ODD_ROW_COLOR);
                        }
                        table.addCell(cell);
                    }
                    i3 = 0;
                    while (i3 < this.detailColumnListArray[index].size()) {
                        if (this.detailColumnListArray[index].get(i3).isVisibleColumn()) {
                            Cell cell;
                            fontTableCellData = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.tableFontSizeArray[index], 0);
                            if (this.detailColumnListArray[index].get(i3).getBarcodeType().equals("")) {
                                if (this.detailColumnListArray[index].get(i3).isImage()) {
                                    imageFileName = String.valueOf(this.session_.getImageFileFolder()) + this.detailColumnListArray[index].get(i3).getExternalValue().toString();
                                    if (imageFileName.startsWith("http://")) {
                                        imageFileName = imageFileName.replace("\\", "/");
                                    }
                                    try {
                                        cell = new Cell((Element)Image.getInstance((String)imageFileName));
                                    }
                                    catch (Exception e) {
                                        cell = new Cell(this.detailColumnListArray[index].get(i3).getExternalValue().toString());
                                    }
                                } else {
                                    fontTableCellData.setColor(this.detailColumnListArray[index].get(i3).getForeground());
                                    cell = new Cell((Element)new Phrase(this.detailColumnListArray[index].get(i3).getExternalValue().toString(), fontTableCellData));
                                }
                                cell.setHorizontalAlignment(this.detailColumnListArray[index].get(i3).getAlignment());
                                if (countOfRows % 2 != 0) {
                                    cell.setBackgroundColor(XFUtility.ODD_ROW_COLOR);
                                }
                                table.addCell(cell);
                            } else {
                                chunk = XFUtility.getBarcodeChunkOfValue(this.detailColumnListArray[index].get(i3).getExternalValue().toString(), this.detailColumnListArray[index].get(i3).getBarcodeType(), cb);
                                phrase = new Phrase("", fontTableCellData);
                                phrase.add((Object)chunk);
                                cell = new Cell((Element)phrase);
                                cell.setHorizontalAlignment(this.detailColumnListArray[index].get(i3).getAlignment());
                                table.addCell(cell);
                            }
                            if (this.detailColumnListArray[index].get(i3).isWithTotal()) {
                                this.detailColumnListArray[index].get(i3).summarize();
                            }
                        }
                        ++i3;
                    }
                } else {
                    ArrayList<String> columnValueList = new ArrayList<String>();
                    i3 = 0;
                    while (i3 < this.detailColumnListArray[index].size()) {
                        if (this.detailColumnListArray[index].get(i3).isVisibleColumn()) {
                            columnValueList.add(this.detailColumnListArray[index].get(i3).getInternalValue().toString());
                        }
                        ++i3;
                    }
                    ArrayList<String> orderByValueList = new ArrayList<String>();
                    ArrayList<String> orderByDirectionList = new ArrayList<String>();
                    i3 = 0;
                    while (i3 < this.detailTableArray[index].getOrderByFieldIDList().size()) {
                        String wrkStr = this.detailTableArray[index].getOrderByFieldIDList().get(i3).replace("(D)", "");
                        wrkStr = wrkStr.replace("(A)", "");
                        j = 0;
                        while (j < this.detailColumnListArray[index].size()) {
                            if (this.detailColumnListArray[index].get(j).getDataSourceName().equals(wrkStr)) {
                                orderByValueList.add(this.detailColumnListArray[index].get(j).getExternalValue().toString());
                                break;
                            }
                            ++j;
                        }
                        if (this.detailTableArray[index].getOrderByFieldIDList().get(i3).contains("(D)")) {
                            orderByDirectionList.add("D");
                        } else {
                            orderByDirectionList.add("");
                        }
                        ++i3;
                    }
                    this.workingRowList.add(new WorkingRow(columnValueList, keyMap, orderByValueList, orderByDirectionList));
                }
                ++countOfRows;
            }
            if (!this.detailTableArray[index].hasOrderByAsItsOwnPhysicalFields()) {
                Object[] workingRowArray = this.workingRowList.toArray(new WorkingRow[0]);
                Arrays.sort(workingRowArray);
                int i4 = 0;
                while (i4 < workingRowArray.length) {
                    if (this.tableRowNoWidthArray[index] > 0) {
                        rowNo = i4 + 1;
                        fontTableCellData = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.tableFontSizeArray[index], 0);
                        Cell cell = new Cell((Element)new Phrase("" + rowNo, fontTableCellData));
                        cell.setHorizontalAlignment(1);
                        if (i4 % 2 != 0) {
                            cell.setBackgroundColor(XFUtility.ODD_ROW_COLOR);
                        }
                        table.addCell(cell);
                    }
                    int j = 0;
                    while (j < this.detailColumnListArray[index].size()) {
                        if (this.detailColumnListArray[index].get(j).isVisibleColumn()) {
                            Cell cell;
                            this.detailColumnListArray[index].get(j).setValue(((WorkingRow)workingRowArray[i4]).getColumnValueList().get(j));
                            fontTableCellData = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.tableFontSizeArray[index], 0);
                            if (this.detailColumnListArray[index].get(j).getBarcodeType().equals("")) {
                                if (this.detailColumnListArray[index].get(j).isImage()) {
                                    imageFileName = String.valueOf(this.session_.getImageFileFolder()) + this.detailColumnListArray[index].get(j).getExternalValue().toString();
                                    if (imageFileName.startsWith("http://")) {
                                        imageFileName = imageFileName.replace("\\", "/");
                                    }
                                    try {
                                        cell = new Cell((Element)Image.getInstance((String)imageFileName));
                                    }
                                    catch (Exception e) {
                                        cell = new Cell(this.detailColumnListArray[index].get(j).getExternalValue().toString());
                                    }
                                } else {
                                    fontTableCellData.setColor(this.detailColumnListArray[index].get(j).getForeground());
                                    cell = new Cell((Element)new Phrase(this.detailColumnListArray[index].get(j).getExternalValue().toString(), fontTableCellData));
                                }
                                cell.setHorizontalAlignment(this.detailColumnListArray[index].get(j).getAlignment());
                                if (i4 % 2 != 0) {
                                    cell.setBackgroundColor(XFUtility.ODD_ROW_COLOR);
                                }
                                table.addCell(cell);
                            } else {
                                chunk = XFUtility.getBarcodeChunkOfValue(((WorkingRow)workingRowArray[i4]).getColumnValueList().get(j), this.detailColumnListArray[index].get(j).getBarcodeType(), cb);
                                phrase = new Phrase("", fontTableCellData);
                                phrase.add((Object)chunk);
                                cell = new Cell((Element)phrase);
                                cell.setHorizontalAlignment(this.detailColumnListArray[index].get(j).getAlignment());
                                table.addCell(cell);
                            }
                            if (this.detailColumnListArray[index].get(j).isWithTotal()) {
                                this.detailColumnListArray[index].get(j).summarize();
                            }
                        }
                        ++j;
                    }
                    ++i4;
                }
            }
            boolean isWithTotalHeading = false;
            wrkInt = 0;
            int i5 = 0;
            while (i5 < this.detailColumnListArray[index].size()) {
                if (this.detailColumnListArray[index].get(i5).isVisibleColumn()) {
                    fontTableCellData = new Font(this.session_.getBaseFontWithID(this.tableFontIDArray[index]), (float)this.tableFontSizeArray[index], 0);
                    ++wrkInt;
                    if (this.detailColumnListArray[index].get(i5).isWithTotal()) {
                        if (!isWithTotalHeading) {
                            Cell cell = new Cell((Element)new Phrase(XFUtility.RESOURCE.getString("Total"), fontTableCell));
                            if (this.tableRowNoWidthArray[index] == 0) {
                                cell.setColspan(wrkInt - 1);
                            } else {
                                cell.setColspan(wrkInt);
                            }
                            cell.setHorizontalAlignment(2);
                            table.addCell(cell);
                            isWithTotalHeading = true;
                        }
                        Cell cell = new Cell((Element)new Phrase(this.detailColumnListArray[index].get(i5).getSummary().toString(), fontTableCellData));
                        cell.setHorizontalAlignment(this.detailColumnListArray[index].get(i5).getAlignment());
                        table.addCell(cell);
                    } else if (isWithTotalHeading) {
                        Cell cell = new Cell((Element)new Phrase(" ", fontTableCellData));
                        table.addCell(cell);
                    }
                }
                ++i5;
            }
            pdfDoc.add((Element)table);
        }
        catch (ScriptException e) {
            this.cancelWithScriptException(e, this.getScriptNameRunning());
        }
        catch (Exception e) {
            this.cancelWithException(e);
        }
    }

    private Chunk getChunkForKeyword(String keyword, PdfContentByte cb, Font chunkFont) {
        Chunk chunk;
        block16: {
            String wrkStr = "";
            chunk = null;
            try {
                Image image;
                StringTokenizer workTokenizer;
                int h;
                int w;
                int y;
                int x;
                int pos;
                if (keyword.contains("&Text(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(keyword.substring(6, pos));
                }
                if (keyword.contains("&DataSource(")) {
                    pos = keyword.lastIndexOf(")");
                    wrkStr = this.getExternalStringValueOfFieldByName(keyword.substring(12, pos));
                    if (wrkStr.equals("")) {
                        wrkStr = " ";
                    }
                    chunkFont.setColor(this.getColorOfDataSource(keyword.substring(12, pos)));
                    chunk = new Chunk(wrkStr, chunkFont);
                }
                if (keyword.contains("&DataSourceImage(")) {
                    x = 0;
                    y = 0;
                    w = 0;
                    h = 0;
                    try {
                        pos = keyword.lastIndexOf(")");
                        workTokenizer = new StringTokenizer(keyword.substring(17, pos), ";");
                        wrkStr = workTokenizer.nextToken().trim();
                        x = Integer.parseInt(workTokenizer.nextToken().trim());
                        y = Integer.parseInt(workTokenizer.nextToken().trim());
                        w = Integer.parseInt(workTokenizer.nextToken().trim());
                        h = Integer.parseInt(workTokenizer.nextToken().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    image = XFUtility.getImageForPDF(String.valueOf(this.session_.getImageFileFolder()) + this.getExternalStringValueOfFieldByName(wrkStr), w, h);
                    if (image != null) {
                        chunk = new Chunk(image, (float)x, (float)y, true);
                    }
                }
                if (keyword.contains("&Barcode(") && cb != null) {
                    pos = keyword.lastIndexOf(")");
                    workTokenizer = new StringTokenizer(keyword.substring(9, pos), ";");
                    wrkStr = workTokenizer.nextToken().trim();
                    String type = "NW7";
                    if (workTokenizer.hasMoreTokens()) {
                        type = workTokenizer.nextToken().trim();
                    }
                    chunk = XFUtility.getBarcodeChunkOfValue(this.getExternalStringValueOfFieldByName(wrkStr), type, cb);
                }
                if (keyword.contains("&SystemVariant(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(this.session_.getSystemVariantString(keyword.substring(15, pos)));
                }
                if (keyword.contains("&DateTime(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(this.session_.getTodayTime(keyword.substring(10, pos)));
                }
                if (keyword.contains("&Date(")) {
                    pos = keyword.lastIndexOf(")");
                    chunk = new Chunk(this.session_.getToday(keyword.substring(6, pos)));
                }
                if (!keyword.contains("&Image(")) break block16;
                x = 0;
                y = 0;
                w = 0;
                h = 0;
                try {
                    pos = keyword.lastIndexOf(")");
                    workTokenizer = new StringTokenizer(keyword.substring(7, pos), ";");
                    wrkStr = workTokenizer.nextToken().trim();
                    x = Integer.parseInt(workTokenizer.nextToken().trim());
                    y = Integer.parseInt(workTokenizer.nextToken().trim());
                    w = Integer.parseInt(workTokenizer.nextToken().trim());
                    h = Integer.parseInt(workTokenizer.nextToken().trim());
                }
                catch (Exception type) {
                    // empty catch block
                }
                image = XFUtility.getImageForPDF(String.valueOf(this.session_.getImageFileFolder()) + wrkStr, w, h);
                chunk = new Chunk(image, (float)x, (float)y, true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, String.valueOf(XFUtility.RESOURCE.getString("FunctionError39")) + keyword + XFUtility.RESOURCE.getString("FunctionError40") + e.toString());
            }
        }
        return chunk;
    }

    void fetchHeaderTableRecord() {
        try {
            int i = 0;
            while (i < this.headerFieldList.size()) {
                if (this.parmMap_.containsKey(this.headerFieldList.get(i).getDataSourceName())) {
                    this.headerFieldList.get(i).setValue(this.parmMap_.get(this.headerFieldList.get(i).getDataSourceName()));
                } else if (this.parmMap_.containsKey(this.headerFieldList.get(i).getFieldID())) {
                    this.headerFieldList.get(i).setValue(this.parmMap_.get(this.headerFieldList.get(i).getFieldID()));
                } else {
                    this.headerFieldList.get(i).setValue(this.headerFieldList.get(i).getNullValue());
                }
                ++i;
            }
            this.headerTable_.runScript("BR", "");
            XFTableOperator operatorHeader = this.createTableOperator(this.headerTable_.getSQLToSelect());
            if (operatorHeader.next()) {
                int i2 = 0;
                while (i2 < this.headerFieldList.size()) {
                    if (this.headerFieldList.get(i2).getTableAlias().equals(this.headerTable_.getTableID())) {
                        this.headerFieldList.get(i2).setValueOfResultSet(operatorHeader);
                    }
                    ++i2;
                }
                this.fetchReferTableRecords("AR", "");
                i2 = 0;
                while (i2 < this.headerFieldList.size()) {
                    if (this.headerFieldList.get(i2).getBasicType().equals("BYTEA")) {
                        this.headerFieldList.get(i2).setupByteaTypeField(this.headerFieldList);
                    }
                    ++i2;
                }
            } else {
                JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("FunctionError30"));
                this.returnMap_.put("RETURN_CODE", "01");
                this.isClosing = true;
            }
        }
        catch (ScriptException e) {
            this.cancelWithScriptException(e, this.getScriptNameRunning());
        }
        catch (Exception e) {
            this.cancelWithException(e);
        }
    }

    protected void fetchReferTableRecords(String event, String specificReferTable) {
        try {
            this.headerTable_.runScript(event, "BR()");
            int i = 0;
            while (i < this.headerReferTableList.size()) {
                if ((specificReferTable.equals("") || specificReferTable.equals(this.headerReferTableList.get(i).getTableAlias())) && this.headerReferTableList.get(i).isToBeExecuted()) {
                    XFTableOperator operator;
                    this.headerTable_.runScript(event, "BR(" + this.headerReferTableList.get(i).getTableAlias() + ")");
                    if (!(this.headerReferTableList.get(i).isKeyNullable() && this.headerReferTableList.get(i).isKeyNull() || !(operator = this.createTableOperator(this.headerReferTableList.get(i).getSelectSQL())).next())) {
                        int j = 0;
                        while (j < this.headerFieldList.size()) {
                            if (this.headerFieldList.get(j).getTableAlias().equals(this.headerReferTableList.get(i).getTableAlias())) {
                                this.headerFieldList.get(j).setValueOfResultSet(operator);
                            }
                            ++j;
                        }
                        this.headerTable_.runScript(event, "AR(" + this.headerReferTableList.get(i).getTableAlias() + ")");
                    }
                }
                ++i;
            }
            this.headerTable_.runScript(event, "AR()");
        }
        catch (ScriptException e) {
            this.cancelWithScriptException(e, this.getScriptNameRunning());
        }
        catch (Exception e) {
            this.cancelWithException(e);
        }
    }

    @Override
    public String getFunctionID() {
        return this.functionElement_.getAttribute("ID");
    }

    public String getScriptNameRunning() {
        return this.scriptNameRunning;
    }

    @Override
    public Session getSession() {
        return this.session_;
    }

    @Override
    public PrintStream getExceptionStream() {
        return this.exceptionStream;
    }

    @Override
    public Object getFieldObjectByID(String tableID, String fieldID) {
        String id = String.valueOf(tableID) + "_" + fieldID;
        if (this.evaluatingScriptTabIndex < 0) {
            if (this.headerScriptBindings.containsKey(id)) {
                return this.headerScriptBindings.get(id);
            }
            JOptionPane.showMessageDialog(null, "Field object " + id + " is not found.");
            return null;
        }
        if (this.detailScriptBindingsArray[this.evaluatingScriptTabIndex].containsKey(id)) {
            return this.detailScriptBindingsArray[this.evaluatingScriptTabIndex].get(id);
        }
        JOptionPane.showMessageDialog(null, "Field object " + id + " is not found.");
        return null;
    }

    public void evalHeaderScript(String scriptName, String scriptText) throws ScriptException {
        if (!scriptText.equals("")) {
            this.scriptNameRunning = scriptName;
            StringBuffer bf = new StringBuffer();
            bf.append(scriptText);
            bf.append(this.session_.getScriptFunctions());
            this.scriptEngine.eval(bf.toString(), this.headerScriptBindings);
        }
    }

    public void evalDetailTableScript(String scriptName, String scriptText, int index) throws ScriptException {
        if (!scriptText.equals("")) {
            this.scriptNameRunning = scriptName;
            if (this.compiledScriptMapArray[index].containsKey(this.scriptNameRunning)) {
                this.compiledScriptMapArray[index].get(this.scriptNameRunning).eval(this.detailScriptBindingsArray[index]);
            } else {
                StringBuffer bf = new StringBuffer();
                bf.append(scriptText);
                bf.append(this.session_.getScriptFunctions());
                Compilable compiler = (Compilable)((Object)this.session_.getScriptEngineManager().getEngineByName("js"));
                CompiledScript script = compiler.compile(bf.toString());
                script.eval(this.detailScriptBindingsArray[index]);
                this.compiledScriptMapArray[index].put(this.scriptNameRunning, script);
            }
        }
    }

    @Override
    public void executeScript(String scriptText) {
        try {
            if (this.evaluatingScriptTabIndex < 0) {
                this.evalHeaderScript("Internal Script", scriptText);
            } else {
                this.evalDetailTableScript("Internal Script", scriptText, this.evaluatingScriptTabIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XF390_HeaderTable getHeaderTable() {
        return this.headerTable_;
    }

    public int getFontStyle(String style) {
        int result = 0;
        if (style.equals("BOLD")) {
            result = 1;
        }
        if (style.equals("ITALIC")) {
            result = 2;
        }
        if (style.contains("BOLDITALIC")) {
            result = 3;
        }
        if (style.equals("UNDERLINE")) {
            result = 4;
        }
        return result;
    }

    public void setEvaluatingScriptTabIndex(int index) {
        this.evaluatingScriptTabIndex = index;
    }

    @Override
    public HashMap<String, Object> getParmMap() {
        return this.parmMap_;
    }

    @Override
    public String getUserValueOf(String dataSourceName) {
        return this.session_.getFilterValue(this.getFunctionID(), dataSourceName);
    }

    @Override
    public void setUserValueOf(String dataSourceName, Object value) {
        this.session_.setFilterValue(this.getFunctionID(), dataSourceName, value.toString());
    }

    @Override
    public void setProcessLog(String text) {
        XFUtility.appendLog(text, this.processLog);
    }

    @Override
    public StringBuffer getProcessLog() {
        return this.processLog;
    }

    @Override
    public Object getVariant(String variantID) {
        if (this.variantMap.containsKey(variantID)) {
            return this.variantMap.get(variantID);
        }
        return "";
    }

    @Override
    public void setVariant(String variantID, Object value) {
        this.variantMap.put(variantID, value);
    }

    @Override
    public XFTableOperator createTableOperator(String oparation, String tableID) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, oparation, tableID);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.setErrorAndCloseFunction();
        }
        return operator;
    }

    @Override
    public XFTableOperator createTableOperator(String sqlText) {
        XFTableOperator operator = null;
        try {
            operator = new XFTableOperator(this.session_, this.processLog, sqlText);
        }
        catch (Exception e) {
            e.printStackTrace(this.exceptionStream);
            this.setErrorAndCloseFunction();
        }
        return operator;
    }

    @Override
    public XFTableEvaluator createTableEvaluator(String tableID) {
        return new XFTableEvaluator(this, tableID);
    }

    @Override
    public HashMap<String, Object> getReturnMap() {
        return this.returnMap_;
    }

    public XF390_DetailTable getDetailTable(int index) {
        return this.detailTableArray[index];
    }

    public ArrayList<XF390_DetailColumn> getDetailColumnList(int index) {
        return this.detailColumnListArray[index];
    }

    public XF390_DetailColumn getDetailColumnObjectByID(int index, String tableID, String tableAlias, String fieldID) {
        XF390_DetailColumn detailColumnField = null;
        int i = 0;
        while (i < this.detailColumnListArray[index].size()) {
            if (tableID.equals("") && this.detailColumnListArray[index].get(i).getTableAlias().equals(tableAlias) && this.detailColumnListArray[index].get(i).getFieldID().equals(fieldID)) {
                detailColumnField = this.detailColumnListArray[index].get(i);
                break;
            }
            if (tableAlias.equals("") && this.detailColumnListArray[index].get(i).getTableID().equals(tableID) && this.detailColumnListArray[index].get(i).getFieldID().equals(fieldID)) {
                detailColumnField = this.detailColumnListArray[index].get(i);
                break;
            }
            if (!tableID.equals("") && !tableAlias.equals("") && this.detailColumnListArray[index].get(i).getTableID().equals(tableID) && this.detailColumnListArray[index].get(i).getTableAlias().equals(tableAlias) && this.detailColumnListArray[index].get(i).getFieldID().equals(fieldID)) {
                detailColumnField = this.detailColumnListArray[index].get(i);
                break;
            }
            ++i;
        }
        return detailColumnField;
    }

    public ArrayList<XF390_DetailReferTable> getDetailReferTableList(int index) {
        return this.detailReferTableListArray[index];
    }

    public ArrayList<XF390_HeaderField> getFieldList() {
        return this.headerFieldList;
    }

    public XF390_HeaderField getFieldObjectByID(String tableID, String tableAlias, String fieldID) {
        XF390_HeaderField field = null;
        int i = 0;
        while (i < this.headerFieldList.size()) {
            if (tableID.equals("") && this.headerFieldList.get(i).getTableAlias().equals(tableAlias) && this.headerFieldList.get(i).getFieldID().equals(fieldID)) {
                field = this.headerFieldList.get(i);
                break;
            }
            if (tableAlias.equals("") && this.headerFieldList.get(i).getTableID().equals(tableID) && this.headerFieldList.get(i).getFieldID().equals(fieldID)) {
                field = this.headerFieldList.get(i);
                break;
            }
            if (!tableID.equals("") && !tableAlias.equals("") && this.headerFieldList.get(i).getTableID().equals(tableID) && this.headerFieldList.get(i).getTableAlias().equals(tableAlias) && this.headerFieldList.get(i).getFieldID().equals(fieldID)) {
                field = this.headerFieldList.get(i);
                break;
            }
            ++i;
        }
        return field;
    }

    public ArrayList<String> getKeyFieldList() {
        return this.headerTable_.getKeyFieldList();
    }

    public ArrayList<XF390_HeaderReferTable> getHeaderReferTableList() {
        return this.headerReferTableList;
    }

    public boolean existsInFieldList(String tableID, String tableAlias, String fieldID) {
        boolean result = false;
        int i = 0;
        while (i < this.headerFieldList.size()) {
            if (tableID.equals("") && this.headerFieldList.get(i).getTableAlias().equals(tableAlias) && this.headerFieldList.get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            if (tableAlias.equals("") && this.headerFieldList.get(i).getTableID().equals(tableID) && this.headerFieldList.get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            if (!tableID.equals("") && !tableAlias.equals("") && this.headerFieldList.get(i).getTableID().equals(tableID) && this.headerFieldList.get(i).getTableAlias().equals(tableAlias) && this.headerFieldList.get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean containsDetailField(int index, String tableID, String tableAlias, String fieldID) {
        boolean result = false;
        int i = 0;
        while (i < this.detailColumnListArray[index].size()) {
            if (tableID.equals("") && this.detailColumnListArray[index].get(i).getTableAlias().equals(tableAlias) && this.detailColumnListArray[index].get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            if (tableAlias.equals("") && this.detailColumnListArray[index].get(i).getTableID().equals(tableID) && this.detailColumnListArray[index].get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            if (!tableID.equals("") && !tableAlias.equals("") && this.detailColumnListArray[index].get(i).getTableID().equals(tableID) && this.detailColumnListArray[index].get(i).getTableAlias().equals(tableAlias) && this.detailColumnListArray[index].get(i).getFieldID().equals(fieldID)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean existsInFieldList(String dataSourceName) {
        boolean result = false;
        int i = 0;
        while (i < this.headerFieldList.size()) {
            if (this.headerFieldList.get(i).getDataSourceName().equals(dataSourceName)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public String getTableIDOfTableAlias(String tableAlias, int index) {
        String tableID = tableAlias;
        int j = 0;
        while (j < this.headerReferTableList.size()) {
            XF390_HeaderReferTable referTable = this.headerReferTableList.get(j);
            referTable.getTableAlias();
            if (referTable.getTableAlias().equals(tableAlias)) {
                tableID = referTable.getTableID();
                break;
            }
            ++j;
        }
        if (index > -1 && this.detailReferElementListArray[index] != null) {
            j = 0;
            while (j < this.detailReferElementListArray[index].getLength()) {
                org.w3c.dom.Element workElement = (org.w3c.dom.Element)this.detailReferElementListArray[index].item(j);
                if (workElement.getAttribute("TableAlias").equals(tableAlias)) {
                    tableID = workElement.getAttribute("ToTable");
                    break;
                }
                ++j;
            }
        }
        return tableID;
    }

    public Object getInternalValueOfFieldByName(String dataSourceName) {
        Object obj = null;
        int i = 0;
        while (i < this.headerFieldList.size()) {
            if (this.headerFieldList.get(i).getDataSourceName().equals(dataSourceName)) {
                obj = this.headerFieldList.get(i).getInternalValue();
                break;
            }
            ++i;
        }
        return obj;
    }

    public String getExternalStringValueOfFieldByName(String dataSourceName) {
        String value = "";
        String fmt = "";
        StringTokenizer workTokenizer = new StringTokenizer(dataSourceName, ";");
        String wrkStr = workTokenizer.nextToken().trim();
        if (workTokenizer.hasMoreTokens()) {
            fmt = workTokenizer.nextToken().trim();
        }
        int i = 0;
        while (i < this.headerFieldList.size()) {
            if (this.headerFieldList.get(i).getDataSourceName().equals(wrkStr)) {
                if (this.headerFieldList.get(i).isKubunField() || this.headerFieldList.get(i).getBasicType().equals("BYTEA")) {
                    value = this.headerFieldList.get(i).getExternalValue().toString();
                    break;
                }
                value = this.headerFieldList.get(i).getInternalValue().toString();
                String basicType = this.headerFieldList.get(i).getBasicType();
                if (basicType.equals("DATE")) {
                    if (fmt.equals("")) {
                        fmt = this.session_.getDateFormat();
                    }
                    wrkStr = value.toString().substring(0, 10);
                    value = XFUtility.getUserExpressionOfUtilDate(XFUtility.convertDateFromSqlToUtil(Date.valueOf(wrkStr)), fmt, false);
                }
                if (basicType.equals("INTEGER")) {
                    value = this.headerFieldList.get(i).getDataTypeOptionList().contains("NO_EDIT") || this.headerFieldList.get(i).getDataTypeOptionList().contains("ZERO_SUPPRESS") ? XFUtility.getFormattedIntegerValue(value, this.headerFieldList.get(i).getDataTypeOptionList(), this.headerFieldList.get(i).getDataSize()) : XFUtility.getEditValueOfLong(Long.parseLong(value), fmt, this.headerFieldList.get(i).getDataSize());
                }
                if (basicType.equals("FLOAT")) {
                    value = XFUtility.getEditValueOfDouble(Double.parseDouble(value), fmt, this.headerFieldList.get(i).getDecimalSize());
                }
                if (this.headerFieldList.get(i).getDataTypeOptionList().contains("YMONTH") || this.headerFieldList.get(i).getDataTypeOptionList().contains("FYEAR")) {
                    if (fmt.equals("")) {
                        fmt = this.session_.getDateFormat();
                    }
                    value = XFUtility.getUserExpressionOfYearMonth(value.toString(), fmt);
                }
                if (!this.headerFieldList.get(i).getDataTypeOptionList().contains("MSEQ") || (wrkStr = value.toString()).equals("")) break;
                value = XFUtility.getUserExpressionOfMSeq(Integer.parseInt(wrkStr), this.session_);
                break;
            }
            ++i;
        }
        return value;
    }

    public Color getColorOfDataSource(String dataSourceName) {
        Color color = Color.black;
        StringTokenizer workTokenizer = new StringTokenizer(dataSourceName, ";");
        String wrkStr = workTokenizer.nextToken().trim();
        int i = 0;
        while (i < this.headerFieldList.size()) {
            if (this.headerFieldList.get(i).getDataSourceName().equals(wrkStr)) {
                color = this.headerFieldList.get(i).getForeground();
                break;
            }
            ++i;
        }
        return color;
    }

    class WorkingRow
    implements Comparable {
        private ArrayList<String> columnValueList_ = new ArrayList();
        private ArrayList<String> orderByValueList_ = new ArrayList();
        private ArrayList<String> orderByDirectionList_ = new ArrayList();
        private HashMap<String, Object> keyMap_ = new HashMap();

        public WorkingRow(ArrayList<String> columnValueList, HashMap<String, Object> keyMap, ArrayList<String> orderByValueList, ArrayList<String> orderByDirectionList) {
            this.columnValueList_ = columnValueList;
            this.keyMap_ = keyMap;
            this.orderByValueList_ = orderByValueList;
            this.orderByDirectionList_ = orderByDirectionList;
        }

        public HashMap<String, Object> getKeyMap() {
            return this.keyMap_;
        }

        public ArrayList<String> getColumnValueList() {
            return this.columnValueList_;
        }

        public ArrayList<String> getOrderByValueList() {
            return this.orderByValueList_;
        }

        public ArrayList<String> getOrderByDirectionList() {
            return this.orderByDirectionList_;
        }

        public int compareTo(Object other) {
            WorkingRow otherRow = (WorkingRow)other;
            int compareResult = 0;
            int i = 0;
            while (i < this.getOrderByValueList().size()) {
                compareResult = this.getOrderByValueList().get(i).toString().compareTo(otherRow.getOrderByValueList().get(i).toString());
                if (this.getOrderByValueList().get(i).equals("D")) {
                    compareResult *= -1;
                }
                if (compareResult != 0) break;
                ++i;
            }
            return compareResult;
        }
    }
}

