/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import xeadDriver.XF390;
import xeadDriver.XFEditableField;
import xeadDriver.XFFieldScriptable;
import xeadDriver.XFTableOperator;
import xeadDriver.XFTextField;
import xeadDriver.XFUtility;
import xeadDriver.XFYMonthBox;

class XF390_HeaderField
implements XFFieldScriptable {
    Element tableElement = null;
    private String dataSourceName_ = "";
    private String tableID_ = "";
    private String tableAlias_ = "";
    private String fieldID_ = "";
    private String fieldName = "";
    private String dataType = "";
    private int dataSize = 5;
    private int decimalSize = 0;
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private XFEditableField component = null;
    private String byteaTypeFieldID = "";
    private boolean isKubunField = false;
    private boolean isNullable = true;
    private boolean isKey = false;
    private boolean isFieldOnPrimaryTable = false;
    private boolean isVirtualField = false;
    private boolean isImage = false;
    private XF390 dialog_;
    private ArrayList<String> kubunValueList = new ArrayList();
    private ArrayList<String> kubunTextList = new ArrayList();
    private Color foreground = Color.black;

    public XF390_HeaderField(String dataSourceName, XF390 dialog) {
        this.dataSourceName_ = dataSourceName;
        this.dialog_ = dialog;
        StringTokenizer workTokenizer = new StringTokenizer(this.dataSourceName_, ";");
        this.dataSourceName_ = workTokenizer.nextToken().trim();
        workTokenizer = new StringTokenizer(this.dataSourceName_, ".");
        this.tableAlias_ = workTokenizer.nextToken();
        this.tableID_ = this.dialog_.getTableIDOfTableAlias(this.tableAlias_, -1);
        this.fieldID_ = workTokenizer.nextToken();
        this.setupVariants();
    }

    public XF390_HeaderField(String tableID, String tableAlias, String fieldID, XF390 dialog) {
        this.tableID_ = tableID;
        this.fieldID_ = fieldID;
        this.dialog_ = dialog;
        this.tableAlias_ = tableAlias.equals("") ? tableID : tableAlias;
        this.dataSourceName_ = String.valueOf(this.tableAlias_) + "." + this.fieldID_;
        this.setupVariants();
    }

    public void setupVariants() {
        Element workElement;
        if (this.tableID_.equals(this.dialog_.getHeaderTable().getTableID()) && this.tableAlias_.equals(this.tableID_)) {
            this.isFieldOnPrimaryTable = true;
            ArrayList<String> keyNameList = this.dialog_.getKeyFieldList();
            int i = 0;
            while (i < keyNameList.size()) {
                if (keyNameList.get(i).equals(this.fieldID_)) {
                    this.isKey = true;
                    break;
                }
                ++i;
            }
        }
        if ((workElement = this.dialog_.getSession().getFieldElement(this.tableID_, this.fieldID_)) == null) {
            JOptionPane.showMessageDialog(null, String.valueOf(this.tableID_) + "." + this.fieldID_ + XFUtility.RESOURCE.getString("FunctionError11"));
        }
        this.fieldName = workElement.getAttribute("Name");
        this.dataType = workElement.getAttribute("Type");
        this.dataTypeOptions = workElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = XFUtility.getOptionList(this.dataTypeOptions);
        this.dataSize = Integer.parseInt(workElement.getAttribute("Size"));
        if (!workElement.getAttribute("Decimal").equals("")) {
            this.decimalSize = Integer.parseInt(workElement.getAttribute("Decimal"));
        }
        if (workElement.getAttribute("Nullable").equals("F")) {
            this.isNullable = false;
        }
        if (this.dataTypeOptionList.contains("VIRTUAL")) {
            this.isVirtualField = true;
        }
        this.byteaTypeFieldID = workElement.getAttribute("ByteaTypeField");
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.dataTypeOptions, "KUBUN");
        if (!wrkStr.equals("")) {
            try {
                this.isKubunField = true;
                XFTableOperator operator = this.dialog_.createTableOperator("Select", this.dialog_.getSession().getTableNameOfUserVariants());
                operator.addKeyValue("IDUSERKUBUN", wrkStr);
                operator.setOrderBy("SQLIST");
                while (operator.next()) {
                    this.kubunValueList.add(operator.getValueOf("KBUSERKUBUN").toString().trim());
                    this.kubunTextList.add(operator.getValueOf("TXUSERKUBUN").toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.dialog_.getExceptionStream());
                this.dialog_.setErrorAndCloseFunction();
            }
        }
        this.tableElement = (Element)workElement.getParentNode();
        this.component = this.dataTypeOptionList.contains("YMONTH") ? new XFYMonthBox(this.dialog_.getSession()) : new XFTextField(this.getBasicType(), this.dataSize, this.decimalSize, this.dataTypeOptions, "", this.dialog_.getSession().systemFont);
        this.component.setLocation(5, 0);
    }

    public String getByteaTypeFieldID() {
        return this.byteaTypeFieldID;
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    @Override
    public String getFieldID() {
        return this.fieldID_;
    }

    public String getTableAlias() {
        return this.tableAlias_;
    }

    @Override
    public String getTableID() {
        return this.tableID_;
    }

    @Override
    public String getDataSourceID() {
        return String.valueOf(this.tableAlias_) + "_" + this.fieldID_;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setValueList(String[] valueList) {
    }

    @Override
    public String[] getValueList() {
        return new String[0];
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getDecimalSize() {
        return this.decimalSize;
    }

    public ArrayList<String> getDataTypeOptionList() {
        return this.dataTypeOptionList;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isNull() {
        return XFUtility.isNullValue(this.getBasicType(), this.component.getInternalValue());
    }

    public boolean isVirtualField() {
        return this.isVirtualField;
    }

    public Element getTableElement() {
        return this.tableElement;
    }

    public boolean isImage() {
        return this.isImage;
    }

    public String getBasicType() {
        return XFUtility.getBasicTypeOf(this.dataType);
    }

    public boolean isFieldOnPrimaryTable() {
        return this.isFieldOnPrimaryTable;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isKubunField() {
        return this.isKubunField;
    }

    public void setValueOfResultSet(XFTableOperator operator) {
        try {
            if (!this.isVirtualField) {
                Object value;
                String basicType = this.getBasicType();
                if (basicType.equals("INTEGER")) {
                    value = operator.getValueOf(this.getFieldID()).toString();
                    if (value == null || ((String)value).equals("")) {
                        this.component.setValue("");
                    } else {
                        int pos = ((String)value).indexOf(".");
                        if (pos >= 0) {
                            value = ((String)value).substring(0, pos);
                        }
                        this.component.setValue(Long.parseLong((String)value));
                    }
                }
                if (basicType.equals("FLOAT")) {
                    value = operator.getValueOf(this.getFieldID()).toString();
                    if (value == null || ((String)value).equals("")) {
                        this.component.setValue("");
                    } else {
                        this.component.setValue(Double.parseDouble((String)value));
                    }
                }
                if (basicType.equals("STRING") || basicType.equals("TIME") || basicType.equals("DATETIME")) {
                    value = operator.getValueOf(this.getFieldID());
                    if (value == null) {
                        this.component.setValue("");
                    } else {
                        this.component.setValue(value.toString().trim());
                    }
                }
                if (basicType.equals("DATE")) {
                    this.component.setValue(operator.getValueOf(this.getFieldID()));
                }
                if (basicType.equals("BYTEA")) {
                    this.component.setValue("<null>");
                }
                this.component.setOldValue(this.component.getInternalValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.dialog_.getExceptionStream());
            this.dialog_.setErrorAndCloseFunction();
        }
    }

    public void setupByteaTypeField(ArrayList<XF390_HeaderField> fieldList) {
        int i = 0;
        while (i < fieldList.size()) {
            if (fieldList.get(i).getFieldID().equals(this.byteaTypeFieldID)) {
                this.setValue("<" + fieldList.get(i).getValue() + ">");
                break;
            }
            ++i;
        }
    }

    @Override
    public void setValue(Object object) {
        XFUtility.setValueToEditableField(this.getBasicType(), object, this.component);
    }

    public Object getNullValue() {
        return XFUtility.getNullValueOfBasicType(this.getBasicType());
    }

    public Object getInternalValue() {
        String returnObj = null;
        String basicType = this.getBasicType();
        if (basicType.equals("INTEGER") || basicType.equals("FLOAT") || basicType.equals("STRING") || basicType.equals("BYTEA")) {
            String value = (String)this.component.getInternalValue();
            if (value == null) {
                value = "";
            }
            returnObj = value;
        }
        if (basicType.equals("DATE")) {
            returnObj = (String)this.component.getInternalValue();
        }
        if (basicType.equals("DATETIME")) {
            returnObj = (String)this.component.getInternalValue();
        }
        return returnObj;
    }

    public Object getExternalValue() {
        Object returnObj = this.getInternalValue();
        if (this.isKubunField) {
            if (returnObj == null) {
                returnObj = "";
            } else {
                String wrkStr = returnObj.toString().trim();
                int i = 0;
                while (i < this.kubunValueList.size()) {
                    if (this.kubunValueList.get(i).equals(wrkStr)) {
                        returnObj = this.kubunTextList.get(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return returnObj;
    }

    @Override
    public Object getValue() {
        Object returnObj = null;
        returnObj = this.getBasicType().equals("INTEGER") ? Long.valueOf(Long.parseLong((String)this.component.getInternalValue())) : (this.getBasicType().equals("FLOAT") ? Double.valueOf(Double.parseDouble((String)this.component.getInternalValue())) : (this.component.getInternalValue() == null ? "" : (String)this.component.getInternalValue()));
        return returnObj;
    }

    @Override
    public void setOldValue(Object object) {
    }

    @Override
    public Object getOldValue() {
        return this.getValue();
    }

    @Override
    public boolean isValueChanged() {
        return !this.getValue().equals(this.getOldValue());
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setEditable(boolean isEditable) {
    }

    @Override
    public void setPrompter(String prompterSpec) {
    }

    @Override
    public void setError(String message) {
    }

    @Override
    public String getError() {
        return "";
    }

    @Override
    public void setWarning(String message) {
    }

    @Override
    public String getWarning() {
        return "";
    }

    @Override
    public void setColor(String color) {
        this.foreground = XFUtility.convertStringToColor(color);
    }

    @Override
    public String getColor() {
        return XFUtility.convertColorToString(this.foreground);
    }

    public Color getForeground() {
        return this.foreground;
    }
}

