/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Blob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import xeadDriver.XFEditableField;
import xeadDriver.XFUtility;

class XFBlobField
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private JButton jButton = new JButton();
    private Desktop desktop = Desktop.getDesktop();
    private int rows_ = 1;
    private Blob value_ = null;
    private Blob oldValue_ = null;
    private boolean isEditable;
    private String fileType = "png";
    private File tempFile = null;

    public XFBlobField(String fieldOptions) {
        ImageIcon imageIcon = new ImageIcon(XFUtility.class.getResource("prompt.png"));
        this.jButton.setIcon(imageIcon);
        this.jButton.addActionListener(new jButton_actionAdapter(this));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jButton, "Center");
        this.setSize(80, 25);
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void exitFromComponent() {
        this.jButton.transferFocus();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public boolean isComponentFocusable() {
        return true;
    }

    @Override
    public void setBackground(Color color) {
        if (this.jButton != null) {
            this.jButton.setBackground(color);
        }
    }

    @Override
    public void requestFocus() {
        if (this.jButton != null) {
            this.jButton.requestFocus();
        }
    }

    @Override
    public void setValue(Object value) {
        try {
            this.value_ = (Blob)value;
        }
        catch (Exception e) {
            this.value_ = null;
        }
    }

    @Override
    public Object getInternalValue() {
        if (this.isEditable && this.tempFile != null) {
            try {
                FileInputStream fis = new FileInputStream(this.tempFile);
                OutputStream os = this.value_.setBinaryStream(1L);
                byte[] buffer = new byte[4096];
                int length = -1;
                while ((length = fis.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                fis.close();
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.value_;
    }

    @Override
    public Object getExternalValue() {
        return "";
    }

    @Override
    public void setOldValue(Object value) {
        try {
            this.oldValue_ = (Blob)value;
        }
        catch (Exception e) {
            this.oldValue_ = null;
        }
    }

    @Override
    public Object getOldValue() {
        return this.oldValue_;
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (this.jButton != null) {
            this.jButton.setFocusable(this.isEditable);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.jButton.setToolTipText(text);
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    class jButton_actionAdapter
    implements ActionListener {
        XFBlobField adaptee;

        jButton_actionAdapter(XFBlobField adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (XFBlobField.this.tempFile == null) {
                    XFBlobField.this.tempFile = File.createTempFile("XTEADriver", "." + XFBlobField.this.fileType);
                    XFBlobField.this.tempFile.deleteOnExit();
                }
                if (XFBlobField.this.value_ != null) {
                    FileOutputStream fos = new FileOutputStream(XFBlobField.this.tempFile);
                    InputStream is = XFBlobField.this.value_.getBinaryStream();
                    if (is != null) {
                        byte[] buffer = new byte[4096];
                        int length = -1;
                        while ((length = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, length);
                        }
                    }
                    is.close();
                    fos.close();
                }
                if (XFBlobField.this.isEditable) {
                    this.adaptee.desktop.edit(XFBlobField.this.tempFile);
                } else if (XFBlobField.this.value_ == null) {
                    JOptionPane.showMessageDialog(null, "NULL!");
                } else {
                    this.adaptee.desktop.browse(new URI("file:" + XFBlobField.this.tempFile.getPath()));
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Failed to process BLOB data.\n" + ex.getMessage());
            }
        }
    }
}

