/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import xeadDriver.Session;
import xeadDriver.XFEditableField;
import xeadDriver.XFUtility;

class XFDateField
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private int rows_ = 1;
    private DateTextField dateTextField = new DateTextField();
    private JButton jButton = new JButton();
    private boolean isEditable = false;
    private java.util.Date date;
    private Session session_;
    private Object oldValue = null;

    public XFDateField(Session session) {
        this.session_ = session;
        this.dateTextField.setFont(new Font(this.session_.systemFont, 0, 18));
        this.dateTextField.setBorder(null);
        this.dateTextField.setEditable(false);
        this.dateTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                if (XFDateField.this.dateTextField.getText().equals("")) {
                    XFDateField.this.jButton.requestFocus();
                } else if (XFDateField.this.isEditable) {
                    XFDateField.this.dateTextField.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent event) {
                XFDateField.this.dateTextField.select(0, 0);
            }
        });
        this.dateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (XFDateField.this.isEditable && event.getKeyCode() == 127) {
                    XFDateField.this.setUtilDateValue(null);
                    XFDateField.this.jButton.requestFocus();
                }
                if (XFDateField.this.isEditable && event.getKeyCode() == 10) {
                    XFDateField.this.jButton.requestFocus();
                }
            }
        });
        ImageIcon imageIcon = new ImageIcon(XFUtility.class.getResource("prompt.png"));
        this.jButton.setIcon(imageIcon);
        this.jButton.setPreferredSize(new Dimension(26, 25));
        this.jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                java.util.Date selectedValue = XFDateField.this.getDateOnCalendar(XFDateField.this.date);
                XFDateField.this.setUtilDateValue(selectedValue);
            }
        });
        this.jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x40) != 0 && e.getKeyCode() == 10) {
                    XFDateField.this.jButton.doClick();
                }
            }
        });
        this.setSize(new Dimension(XFUtility.getWidthOfDateValue(session.getDateFormat(), this.session_.systemFont, 18) + 26, 25));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add((Component)this.dateTextField, "Center");
        this.add((Component)this.jButton, "East");
    }

    public void setInternalBorder(Border border) {
        this.dateTextField.setBorder(border);
    }

    public void addActionListener(ActionListener listener) {
        this.jButton.addActionListener(listener);
    }

    public void addKeyListener(KeyAdapter adapter) {
        this.jButton.addKeyListener(adapter);
        this.dateTextField.addKeyListener(adapter);
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            this.add((Component)this.jButton, "East");
            this.dateTextField.setFont(new Font(this.session_.systemFont, 0, 16));
            this.dateTextField.setBackground(SystemColor.text);
            this.dateTextField.setFocusable(true);
        } else {
            this.remove(this.jButton);
            this.dateTextField.setFont(new Font(this.session_.systemFont, 0, 18));
            this.dateTextField.setBackground(SystemColor.control);
            this.dateTextField.setFocusable(false);
        }
        this.isEditable = editable;
    }

    @Override
    public void setToolTipText(String text) {
        this.dateTextField.setToolTipText(text);
    }

    @Override
    public void setFont(Font font) {
        if (this.dateTextField != null) {
            this.dateTextField.setFont(font);
        }
    }

    @Override
    public void requestFocus() {
        this.jButton.requestFocus();
    }

    @Override
    public Object getInternalValue() {
        if (this.dateTextField.getText().equals("")) {
            return null;
        }
        return XFUtility.convertDateFromUtilToString(this.date);
    }

    @Override
    public Object getExternalValue() {
        return this.dateTextField.getText();
    }

    public java.util.Date getDate() {
        return this.date;
    }

    @Override
    public void setValue(Object obj) {
        this.dateTextField.setText("");
        if (obj == null) {
            this.date = null;
        } else {
            if (obj.getClass().getName().equals("java.sql.Date")) {
                this.date = XFUtility.convertDateFromSqlToUtil((Date)obj);
                this.dateTextField.setText(XFUtility.getUserExpressionOfUtilDate(this.date, this.session_.getDateFormat(), false));
            }
            if (obj.getClass().getName().equals("java.sql.Timestamp")) {
                this.date = XFUtility.convertDateFromStringToUtil(obj.toString().substring(0, 10));
                this.dateTextField.setText(XFUtility.getUserExpressionOfUtilDate(this.date, this.session_.getDateFormat(), false));
            }
            if (obj.getClass().getName().equals("java.util.Date")) {
                this.date = (java.util.Date)obj;
                this.dateTextField.setText(XFUtility.getUserExpressionOfUtilDate(this.date, this.session_.getDateFormat(), false));
            }
            if (obj.getClass().getName().equals("java.lang.String")) {
                if (obj.equals("")) {
                    this.date = null;
                } else {
                    this.date = XFUtility.convertDateFromStringToUtil((String)obj);
                    this.dateTextField.setText(XFUtility.getUserExpressionOfUtilDate(this.date, this.session_.getDateFormat(), false));
                }
            }
        }
        this.jButton.setToolTipText(this.dateTextField.getText());
    }

    @Override
    public void setWidth(int width) {
    }

    public void setNarrower(int width) {
        if (this.getWidth() > width) {
            int fontSize = 18;
            while (fontSize >= 9) {
                int workWidth = XFUtility.getWidthOfDateValue(this.session_.getDateFormat(), this.session_.systemFont, fontSize) + 26;
                if (workWidth <= width || fontSize == 9) {
                    this.dateTextField.setFont(new Font(this.session_.systemFont, 0, fontSize));
                    break;
                }
                --fontSize;
            }
            this.setSize(new Dimension(width, 25));
        }
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = obj;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    public void setUtilDateValue(java.util.Date utilDate) {
        this.date = utilDate;
        if (this.date == null) {
            this.dateTextField.setText("");
        } else {
            this.dateTextField.setText(XFUtility.getUserExpressionOfUtilDate(utilDate, this.session_.getDateFormat(), false));
        }
        this.jButton.setToolTipText(this.dateTextField.getText());
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isComponentFocusable() {
        return this.isEditable;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setForeground(Color color) {
        if (this.dateTextField != null) {
            this.dateTextField.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.dateTextField != null) {
            this.dateTextField.setBackground(color);
        }
    }

    public java.util.Date getDateOnCalendar(java.util.Date date) {
        Point position = this.jButton.getLocationOnScreen();
        position.x += Math.round(this.jButton.getWidth() / 2);
        position.y += Math.round(this.jButton.getHeight() / 2);
        return this.session_.getDateOnCalendar(date, "", position);
    }

    class DateTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;

        DateTextField() {
        }

        @Override
        public boolean isFocusable() {
            return !this.getText().equals("");
        }
    }
}

