/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XFExcelFileOperator {
    private File file_ = null;
    private Workbook workbook_ = null;
    private boolean isError = false;

    public XFExcelFileOperator(String fileName) {
        this.file_ = new File(fileName);
        if (this.file_.exists()) {
            try {
                FileInputStream is = new FileInputStream(this.file_);
                this.workbook_ = WorkbookFactory.create((InputStream)is);
                ((InputStream)is).close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to process the file:\n" + e.getMessage() + "\n" + this.file_.getAbsolutePath());
                this.isError = true;
            }
        } else {
            JOptionPane.showMessageDialog(null, "Specified file does not exists:" + this.file_.getAbsolutePath());
        }
    }

    public boolean commit() {
        try {
            FileOutputStream os = new FileOutputStream(this.file_);
            this.workbook_.write(os);
        }
        catch (Exception e) {
            this.isError = true;
        }
        return this.isError;
    }

    public int getLastRowIndex(int indexOfSheet) {
        int num = 0;
        try {
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            num = sheet.getLastRowNum();
        }
        catch (Exception e) {
            num = -1;
        }
        return num;
    }

    public Object getValueAt(int indexOfSheet, int indexOfRow, int indexOfColumn) {
        Object value = "";
        try {
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            Row row = sheet.getRow(indexOfRow);
            Cell cell = row.getCell(indexOfColumn);
            if (cell.getCellType() == 1) {
                value = cell.getStringCellValue();
            }
            if (cell.getCellType() == 0) {
                if (DateUtil.isCellDateFormatted(cell)) {
                    Date date = cell.getDateCellValue();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    String yearStr = Integer.toString(cal.get(1));
                    int month = cal.get(2) + 1;
                    String monthStr = Integer.toString(month);
                    if (month < 9) {
                        monthStr = "0" + monthStr;
                    }
                    int day = cal.get(5);
                    String dayStr = Integer.toString(day);
                    if (day < 9) {
                        dayStr = "0" + dayStr;
                    }
                    value = String.valueOf(yearStr) + "-" + monthStr + "-" + dayStr;
                } else {
                    value = cell.getNumericCellValue();
                }
            }
            if (cell.getCellType() == 4) {
                value = cell.getBooleanCellValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public boolean setValueAt(int indexOfSheet, int indexOfRow, int indexOfColumn, String value) {
        boolean isOkay = true;
        try {
            int type;
            Cell cell;
            Row row;
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            if (sheet == null) {
                sheet = this.workbook_.createSheet();
            }
            if ((row = sheet.getRow(indexOfRow)) == null) {
                row = sheet.createRow(indexOfRow);
            }
            if ((cell = row.getCell(indexOfColumn)) == null) {
                cell = row.createCell(indexOfColumn);
            }
            if ((type = cell.getCellType()) == 0) {
                if (DateUtil.isCellDateFormatted(cell)) {
                    String date = value.replaceAll("/", "");
                    date = value.replaceAll("-", "").trim();
                    int year = Integer.parseInt(date.substring(0, 4));
                    int month = Integer.parseInt(date.substring(4, 6));
                    int day = Integer.parseInt(date.substring(6, 8));
                    Calendar cal = Calendar.getInstance();
                    cal.set(year, month - 1, day);
                    cell.setCellValue(cal);
                } else {
                    Double doubleValue = Double.parseDouble(value);
                    cell.setCellValue(doubleValue);
                }
            } else {
                cell.setCellValue(value);
            }
            cell.setCellType(type);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Failed to process the value:" + value + "\n" + e.getMessage());
            isOkay = false;
        }
        return isOkay;
    }

    public boolean removeRowAt(int indexOfSheet, int indexFrom) {
        return this.removeRowsBetween(indexOfSheet, indexFrom, indexFrom);
    }

    public boolean removeRowsBetween(int indexOfSheet, int indexFrom, int indexThru) {
        boolean isOkay = true;
        try {
            Sheet sheet = this.workbook_.getSheetAt(indexOfSheet);
            if (sheet != null) {
                int i = indexFrom;
                while (i <= indexThru) {
                    Row row = sheet.getRow(i);
                    sheet.removeRow(row);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            isOkay = false;
        }
        return isOkay;
    }

    public boolean setSheetNameAt(int indexOfSheet, String value) {
        boolean isOkay = true;
        try {
            this.workbook_.setSheetName(indexOfSheet, value);
        }
        catch (Exception e) {
            isOkay = false;
        }
        return isOkay;
    }

    public boolean cloneSheet(int indexOfSheet) {
        boolean isOkay = true;
        try {
            this.workbook_.cloneSheet(indexOfSheet);
        }
        catch (Exception e) {
            isOkay = false;
        }
        return isOkay;
    }
}

