/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import xeadDriver.XFEditableField;
import xeadDriver.XFImageField_jButton_actionAdapter;
import xeadDriver.XFImageField_jButton_keyAdapter;
import xeadDriver.XFUtility;

class XFImageField
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private int size_ = 10;
    private int rows_;
    private JTextField jTextField = new JTextField();
    private JScrollPane jScrollPane = new JScrollPane();
    private JPanel jPanelBottom = new JPanel();
    private JLabel jLabelImage;
    private ImageIcon imageIcon = null;
    private JButton jButton = new JButton();
    private boolean isEditable = false;
    private String fieldOptions_ = "";
    private String imageFileFolder_ = "";
    private Color normalModeColor = null;
    private static int DEFAULT_ROWS = 11;
    private static int DEFAULT_WIDTH = 400;
    private final int FIELD_VERTICAL_MARGIN = 5;
    private int fieldHeight = 0;
    private int fieldWidth = 0;
    private String oldValue = "";
    private String fontName_ = "";
    private Desktop desktop = Desktop.getDesktop();

    public XFImageField(String fieldOptions, int size, String imageFileFolder, String fontName) {
        this.fieldOptions_ = fieldOptions;
        this.size_ = size;
        this.imageFileFolder_ = imageFileFolder;
        this.fontName_ = fontName;
        this.jTextField.setEditable(false);
        Border workBorder = this.jTextField.getBorder();
        this.normalModeColor = this.jTextField.getBackground();
        this.jTextField.setBorder(BorderFactory.createLineBorder(this.normalModeColor));
        this.jTextField.setBackground(Color.white);
        this.jTextField.setEditable(true);
        this.jTextField.setFont(new Font(this.fontName_, 0, 18));
        this.jTextField.setDocument(new LimitDocument());
        this.jButton.setFont(new Font(this.fontName_, 0, 18));
        this.jButton.setPreferredSize(new Dimension(35, 25));
        this.jButton.setIcon(XFUtility.ICON_REFRESH);
        this.jButton.addActionListener(new XFImageField_jButton_actionAdapter(this));
        this.jButton.addKeyListener(new XFImageField_jButton_keyAdapter(this));
        this.jPanelBottom.setPreferredSize(new Dimension(200, 25));
        this.jScrollPane.setBorder(null);
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.add((Component)this.jTextField, "Center");
        this.jPanelBottom.add((Component)this.jButton, "East");
        this.setBorder(workBorder);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanelBottom, "South");
        this.add((Component)this.jScrollPane, "Center");
        this.rows_ = DEFAULT_ROWS;
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "ROWS");
        if (!wrkStr.equals("")) {
            this.rows_ = Integer.parseInt(wrkStr);
        }
        this.fieldHeight = this.rows_ * 30 - 5;
        this.fieldWidth = DEFAULT_WIDTH;
        wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "WIDTH");
        if (!wrkStr.equals("")) {
            this.fieldWidth = Integer.parseInt(wrkStr);
        }
        this.setSize(this.fieldWidth, this.fieldHeight);
        this.setEditable(false);
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            this.add((Component)this.jPanelBottom, "South");
        } else {
            this.remove(this.jPanelBottom);
            this.setFocusable(false);
        }
        this.isEditable = editable;
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public void setToolTipText(String text) {
        this.jTextField.setToolTipText(text);
    }

    @Override
    public Object getInternalValue() {
        return this.jTextField.getText();
    }

    @Override
    public void setOldValue(Object value) {
        this.oldValue = value.toString();
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    @Override
    public Object getExternalValue() {
        return String.valueOf(this.imageFileFolder_) + this.jTextField.getText();
    }

    @Override
    public void setValue(Object obj) {
        if (obj == null) {
            this.setupImage("");
        } else {
            this.setupImage(obj.toString().trim());
        }
    }

    void setupImage(String imageFileName) {
        this.jTextField.setText(imageFileName);
        this.imageIcon = null;
        boolean isExistingFile = true;
        String fullName = String.valueOf(this.imageFileFolder_) + imageFileName;
        if (imageFileName.equals("")) {
            this.jLabelImage = new JLabel();
            this.jLabelImage.setHorizontalAlignment(0);
            isExistingFile = false;
        } else {
            if (fullName.startsWith("http://")) {
                try {
                    this.imageIcon = XFUtility.createSmallIcon(fullName, this.fieldWidth - 15, this.fieldHeight - 30);
                }
                catch (Exception exception) {}
            } else {
                File imageFile = new File(fullName);
                if (imageFile.exists()) {
                    this.imageIcon = XFUtility.createSmallIcon(fullName, this.fieldWidth - 15, this.fieldHeight - 30);
                } else {
                    isExistingFile = false;
                }
            }
            this.jLabelImage = new JLabel("", this.imageIcon, 0);
        }
        this.jLabelImage.setFont(new Font(this.fontName_, 0, 18));
        this.jLabelImage.setOpaque(true);
        if (isExistingFile) {
            if (imageFileName.toUpperCase().contains(".GIF") || imageFileName.toUpperCase().contains(".BMP") || imageFileName.toUpperCase().contains(".JPG") || imageFileName.toUpperCase().contains(".JPE") || imageFileName.toUpperCase().contains(".JPEG") || imageFileName.toUpperCase().contains(".PNG")) {
                this.jLabelImage.setText("");
                int wrkWidth = this.getWidth() - 50;
                int wrkHeight = this.getHeight() - 50;
                if (this.imageIcon.getIconWidth() > wrkWidth) {
                    wrkWidth = this.imageIcon.getIconWidth();
                }
                if (this.imageIcon.getIconHeight() > wrkHeight) {
                    wrkHeight = this.imageIcon.getIconHeight();
                }
                this.jLabelImage.setToolTipText("<html>" + imageFileName + "<br>" + XFUtility.RESOURCE.getString("ImageFileShown"));
                this.jLabelImage.setPreferredSize(new Dimension(wrkWidth, wrkHeight));
            } else {
                this.jLabelImage.setText("<html>" + imageFileName + XFUtility.RESOURCE.getString("Colon") + XFUtility.RESOURCE.getString("ImageFileMessage1"));
                this.jLabelImage.setPreferredSize(new Dimension(this.getWidth() - 50, this.getHeight() - 50));
            }
            this.jLabelImage.addMouseListener(new jLabel_mouseAdapter(this));
        } else if (imageFileName.equals("")) {
            this.jLabelImage.setText(XFUtility.RESOURCE.getString("ImageFileNotSpecified"));
        } else {
            this.jLabelImage.setText(String.valueOf(XFUtility.RESOURCE.getString("ImageFileNotFound1")) + fullName + XFUtility.RESOURCE.getString("ImageFileNotFound2"));
        }
        this.jScrollPane.getViewport().add((Component)this.jLabelImage, null);
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isComponentFocusable() {
        return this.isEditable;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setBackground(Color color) {
        if (this.jTextField != null) {
            this.jTextField.setBackground(color);
        }
    }

    void jButton_actionPerformed(ActionEvent e) {
        this.setupImage(this.jTextField.getText());
    }

    void jButton_keyPressed(KeyEvent e) {
        if ((e.getModifiersEx() & 0x40) != 0 && e.getKeyCode() == 10) {
            this.jButton.doClick();
        }
    }

    private boolean canInsertString(String str) {
        return this.jTextField.getText().length() + str.length() <= this.size_;
    }

    protected class LimitDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        protected LimitDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (a != null) {
                super.insertString(offs, str, a);
                return;
            }
            if (!XFImageField.this.canInsertString(str)) {
                return;
            }
            super.insertString(offs, str, a);
        }
    }

    class jLabel_mouseAdapter
    extends MouseAdapter {
        XFImageField adaptee;

        jLabel_mouseAdapter(XFImageField adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                try {
                    XFImageField.this.setCursor(new Cursor(3));
                    String fullName = String.valueOf(XFImageField.this.imageFileFolder_) + XFImageField.this.jTextField.getText();
                    if (fullName.startsWith("http://")) {
                        XFImageField.this.desktop.browse(new URI(fullName));
                    } else if (!fullName.equals("")) {
                        File file = new File(fullName);
                        XFImageField.this.desktop.browse(file.toURI());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to browse the file.\n" + ex.getMessage());
                    XFImageField.this.setCursor(new Cursor(0));
                }
            }
            finally {
                XFImageField.this.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            XFImageField.this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            XFImageField.this.setCursor(new Cursor(0));
        }
    }
}

