/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxUI;
import xeadDriver.Session;
import xeadDriver.XFEditableField;
import xeadDriver.XFTableOperator;
import xeadDriver.XFUtility;

class XFInputAssistField
extends JComboBox
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private String tableID_ = "";
    private String fieldID_ = "";
    private ArrayList<String> dataTypeOptionList;
    private Vector<String> valueList = new Vector();
    private int rows_ = 1;
    private Session session_;
    private String oldValue = "";

    public XFInputAssistField(String tableID, String fieldID, int digits, String dataTypeOptions, Session session) {
        this.dataTypeOptionList = XFUtility.getOptionList(dataTypeOptions);
        this.tableID_ = tableID;
        this.fieldID_ = fieldID;
        this.session_ = session;
        int fieldWidth = 100;
        this.setFont(new Font(this.session_.systemFont, 0, 18));
        fieldWidth = this.dataTypeOptionList.contains("KANJI") || this.dataTypeOptionList.contains("ZIPADRS") ? digits * 18 + 10 : digits * 11 + 10;
        if (fieldWidth > 800) {
            fieldWidth = 800;
        }
        this.updateList();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.valueList);
        this.setModel(model);
        this.setSize(new Dimension(fieldWidth, 25));
        this.setEditable(true);
        this.setSelectedIndex(-1);
        JTextField field = (JTextField)this.getEditor().getEditorComponent();
        field.setText("");
        field.addKeyListener(new ComboKeyHandler(this));
    }

    public void updateList() {
        this.valueList.removeAllElements();
        String sql = "select distinct " + this.fieldID_ + " from " + this.tableID_ + " order by " + this.fieldID_;
        try {
            XFTableOperator operator = new XFTableOperator(this.session_, null, sql, true);
            while (operator.next()) {
                String wrkStr = operator.getValueOf(this.fieldID_).toString().trim();
                this.valueList.add(wrkStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                JButton button = new JButton(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public int getWidth() {
                        return 0;
                    }
                };
                button.setBorder(BorderFactory.createEmptyBorder());
                button.setVisible(false);
                return button;
            }

            @Override
            public void configureArrowButton() {
            }
        });
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener ml = mouseListenerArray[n2];
            this.removeMouseListener(ml);
            ++n2;
        }
    }

    @Override
    public Object getInternalValue() {
        Object value = this.getItemAt(this.getSelectedIndex());
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public Object getExternalValue() {
        return this.getInternalValue();
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = (String)obj;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    public String getValueClass() {
        return "String";
    }

    @Override
    public void setValue(Object obj) {
        JTextField field = (JTextField)this.getEditor().getEditorComponent();
        field.setText(obj.toString());
    }

    @Override
    public void setWidth(int width) {
        this.setWidth(width);
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    @Override
    public boolean isComponentFocusable() {
        return this.isFocusable();
    }

    class ComboKeyHandler
    extends KeyAdapter {
        private final JComboBox<String> comboBox;
        private final Vector<String> list = new Vector();
        private boolean shouldHide = false;

        public ComboKeyHandler(JComboBox combo) {
            this.comboBox = combo;
            int i = 0;
            while (i < this.comboBox.getModel().getSize()) {
                this.list.addElement(this.comboBox.getItemAt(i));
                ++i;
            }
        }

        @Override
        public void keyTyped(final KeyEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String text = ((JTextField)e.getSource()).getText();
                    if (text.length() == 0) {
                        ComboKeyHandler.this.setSuggestionModel(ComboKeyHandler.this.comboBox, new DefaultComboBoxModel(ComboKeyHandler.this.list), "");
                        ComboKeyHandler.this.comboBox.hidePopup();
                    } else {
                        ComboBoxModel m = ComboKeyHandler.this.getSuggestedModel(ComboKeyHandler.this.list, text);
                        if (m.getSize() == 0 || ComboKeyHandler.this.shouldHide) {
                            ComboKeyHandler.this.comboBox.hidePopup();
                        } else {
                            ComboKeyHandler.this.setSuggestionModel(ComboKeyHandler.this.comboBox, m, text);
                            ComboKeyHandler.this.comboBox.showPopup();
                        }
                    }
                }
            });
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTextField textField = (JTextField)e.getSource();
            String text = textField.getText();
            this.shouldHide = false;
            switch (e.getKeyCode()) {
                case 39: {
                    for (String s : this.list) {
                        if (!s.startsWith(text)) continue;
                        textField.setText(s);
                        return;
                    }
                    break;
                }
                case 10: {
                    if (!this.list.contains(text)) {
                        this.list.addElement(text);
                        Collections.sort(this.list);
                        this.setSuggestionModel(this.comboBox, this.getSuggestedModel(this.list, text), text);
                    }
                    this.shouldHide = true;
                    break;
                }
                case 27: {
                    this.shouldHide = true;
                }
            }
        }

        private void setSuggestionModel(JComboBox comboBox, ComboBoxModel mdl, String str) {
            comboBox.setModel(mdl);
            comboBox.setSelectedIndex(-1);
            ((JTextField)comboBox.getEditor().getEditorComponent()).setText(str);
        }

        private ComboBoxModel getSuggestedModel(Vector<String> list, String text) {
            DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
            for (String s : list) {
                if (!s.startsWith(text)) continue;
                m.addElement(s);
            }
            return m;
        }
    }
}

