/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputSubset;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import xeadDriver.XFDateField;
import xeadDriver.XFInputDialog;
import xeadDriver.XFUtility;

public class XFInputDialogField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int size_ = 10;
    private int height_ = 25;
    private int decimal_ = 0;
    private String parmID_ = "";
    private String inputType_ = "";
    private JLabel jLabelField = new JLabel();
    private JButton jButton = null;
    private Component component = null;
    private JLabel jLabelComment = new JLabel();
    private JPanel jPanelEast = new JPanel();
    private FontMetrics metrics;
    private ArrayList<Object> valueList = new ArrayList();
    private boolean isEditable_ = true;
    private boolean isAutoSizing = true;
    private XFInputDialog dialog_ = null;
    private String functionID_ = "";
    private JFileChooser jFileChooser = null;
    private ArrayList<String> fieldsToPutList_ = new ArrayList();
    private ArrayList<String> fieldsToPutToList_ = new ArrayList();
    private ArrayList<String> fieldsToGetList_ = new ArrayList();
    private ArrayList<String> fieldsToGetToList_ = new ArrayList();

    public XFInputDialogField(String fieldCaption, String inputType, String parmID, XFInputDialog dialog) {
        JComponent field;
        this.parmID_ = parmID;
        if (!(inputType.equals("ALPHA") || inputType.equals("ZEROFILL") || inputType.equals("KANJI") || inputType.equals("NUMERIC") || inputType.equals("DATE") || inputType.equals("LISTBOX") || inputType.equals("CHECKBOX") || inputType.equals("TEXTAREA") || inputType.equals("PASSWORD"))) {
            this.inputType_ = "ALPHA";
        }
        this.inputType_ = inputType;
        this.dialog_ = dialog;
        this.jLabelField.setText(String.valueOf(fieldCaption) + " ");
        this.jLabelField.setFocusable(false);
        this.jLabelField.setHorizontalAlignment(4);
        this.jLabelField.setVerticalAlignment(1);
        this.jLabelField.setFont(new Font(this.dialog_.getSession().systemFont, 0, 18));
        this.jLabelField.setPreferredSize(new Dimension(150, 25));
        XFUtility.adjustFontSizeToGetPreferredWidthOfLabel(this.jLabelField, 150);
        this.metrics = this.jLabelField.getFontMetrics(this.jLabelField.getFont());
        if (this.inputType_.equals("ALPHA") || this.inputType_.equals("ZEROFILL") || this.inputType_.equals("KANJI") || this.inputType_.equals("NUMERIC")) {
            field = new JTextField();
            field.addFocusListener(new ComponentFocusListener());
            ((JTextField)field).setDocument(new LimitedDocument(this));
            if (this.inputType_.equals("NUMERIC")) {
                ((JTextField)field).setHorizontalAlignment(4);
            }
            this.component = field;
        }
        if (this.inputType_.equals("DATE")) {
            field = new XFDateField(this.dialog_.getSession());
            this.component = field;
        }
        if (this.inputType_.equals("LISTBOX")) {
            field = new JComboBox();
            this.component = field;
        }
        if (this.inputType_.equals("CHECKBOX")) {
            field = new JCheckBox();
            this.component = field;
        }
        if (this.inputType_.equals("TEXTAREA")) {
            field = new JTextArea();
            ((JTextArea)field).setWrapStyleWord(true);
            ((JTextArea)field).setLineWrap(true);
            this.component = field;
        }
        if (this.inputType_.equals("PASSWORD")) {
            field = new JPasswordField();
            this.component = field;
        }
        this.component.setFont(new Font(this.dialog_.getSession().systemFont, 0, 17));
        this.jLabelComment.setFont(new Font(this.dialog_.getSession().systemFont, 0, 16));
        this.jPanelEast.setLayout(new BorderLayout());
        this.jPanelEast.setSize(0, 25);
        this.setOpaque(false);
        if (this.inputType_.equals("DATE")) {
            int fieldWidth = XFUtility.getWidthOfDateValue(this.dialog_.getSession().getDateFormat(), this.dialog_.getSession().systemFont, 18);
            this.setBounds(this.getBounds().x, this.getBounds().y, 200 + fieldWidth, 25);
        } else if (this.inputType_.equals("TEXTAREA")) {
            this.height_ = 75;
            this.setBounds(this.getBounds().x, this.getBounds().y, 1000, this.height_);
        } else if (this.inputType_.equals("CHECKBOX")) {
            this.setBounds(this.getBounds().x, this.getBounds().y, 175, this.height_);
        } else {
            this.setBounds(this.getBounds().x, this.getBounds().y, 250, this.height_);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.jLabelField, "West");
        if (this.inputType_.equals("TEXTAREA")) {
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(this.component);
            this.add((Component)jScrollPane, "Center");
        } else {
            this.add(this.component, "Center");
        }
        this.add((Component)this.jPanelEast, "East");
    }

    public void setEditable(boolean isEditable) {
        this.isEditable_ = isEditable;
        if (this.inputType_.equals("ALPHA") || this.inputType_.equals("TEXTAREA") || this.inputType_.equals("KANJI") || this.inputType_.equals("NUMERIC") || this.inputType_.equals("PASSWORD")) {
            ((JTextField)this.component).setEditable(this.isEditable_);
            ((JTextField)this.component).setFocusable(this.isEditable_);
        }
        if (this.inputType_.equals("DATE")) {
            ((XFDateField)this.component).setEditable(this.isEditable_);
            ((XFDateField)this.component).setFocusable(this.isEditable_);
            int fieldWidth = XFUtility.getWidthOfDateValue(this.dialog_.getSession().getDateFormat(), this.dialog_.getSession().systemFont, 18);
            FontMetrics commentMetrics = this.jLabelComment.getFontMetrics(this.jLabelComment.getFont());
            int commentWidth = commentMetrics.stringWidth(this.jLabelComment.getText());
            if (this.isEditable_) {
                this.setBounds(this.getBounds().x, this.getBounds().y, 200 + fieldWidth + commentWidth, 25);
            } else {
                this.setBounds(this.getBounds().x, this.getBounds().y, 174 + fieldWidth + commentWidth, 25);
            }
        }
        if (this.inputType_.equals("LISTBOX")) {
            ((JComboBox)this.component).setEnabled(this.isEditable_);
            ((JComboBox)this.component).setFocusable(this.isEditable_);
        }
        if (this.inputType_.equals("CHECKBOX")) {
            ((JCheckBox)this.component).setEnabled(this.isEditable_);
            ((JCheckBox)this.component).setFocusable(this.isEditable_);
        }
        if (this.inputType_.equals("TEXTAREA")) {
            ((JTextArea)this.component).setEnabled(this.isEditable_);
            ((JTextArea)this.component).setFocusable(this.isEditable_);
        }
    }

    public boolean isEditable() {
        return this.isEditable_;
    }

    public void setComment(String comment) {
        FontMetrics commentMetrics = this.jLabelComment.getFontMetrics(this.jLabelComment.getFont());
        int oldCommentWidth = commentMetrics.stringWidth(this.jLabelComment.getText());
        int newCommentWidth = commentMetrics.stringWidth(" " + comment);
        this.jLabelComment.setText(" " + comment);
        this.jPanelEast.add((Component)this.jLabelComment, "East");
        this.jPanelEast.setSize(this.jPanelEast.getWidth() - oldCommentWidth + newCommentWidth, 25);
        this.setBounds(this.getBounds().x, this.getBounds().y, this.getWidth() - oldCommentWidth + newCommentWidth, this.height_);
    }

    public void setSize(int size) {
        this.size_ = size;
        this.setFieldWidth();
    }

    public void setDecimal(int decimal) {
        this.decimal_ = decimal;
        this.setFieldWidth();
    }

    private void setFieldWidth() {
        int width = 0;
        int charWidth = 11;
        int length = this.size_;
        if (this.inputType_.equals("KANJI")) {
            charWidth = 18;
        }
        if (this.inputType_.equals("NUMERIC")) {
            int i = this.size_ - 1;
            while (i > 0) {
                if (i % 3 == 0) {
                    ++length;
                }
                --i;
            }
        }
        if ((width = this.decimal_ > 0 ? charWidth * (length + this.decimal_ + 2 + 1) : charWidth * (length + 1)) < 50) {
            width = 50;
        }
        if (width > 800 || this.inputType_.equals("TEXTAREA")) {
            width = 800;
        }
        FontMetrics commentMetrics = this.jLabelComment.getFontMetrics(this.jLabelComment.getFont());
        int commentWidth = commentMetrics.stringWidth(this.jLabelComment.getText());
        if (this.jButton == null) {
            this.setBounds(this.getBounds().x, this.getBounds().y, width + 150 + commentWidth, this.getBounds().height);
        } else {
            this.setBounds(this.getBounds().x, this.getBounds().y, width + 150 + 26 + commentWidth, this.getBounds().height);
        }
        this.isAutoSizing = false;
    }

    public void setValue(Object value) {
        if (value == null) {
            value = "";
        }
        if (this.inputType_.equals("ALPHA") || this.inputType_.equals("TEXTAREA") || this.inputType_.equals("ZEROFILL") || this.inputType_.equals("KANJI") || this.inputType_.equals("NUMERIC") || this.inputType_.equals("PASSWORD")) {
            String strValue;
            if (this.inputType_.equals("ALPHA") || this.inputType_.equals("KANJI") || this.inputType_.equals("PASSWORD")) {
                strValue = value.toString();
                if (strValue.length() > this.size_) {
                    strValue = strValue.substring(0, this.size_);
                }
                ((JTextField)this.component).setText(strValue);
            }
            if (this.inputType_.equals("TEXTAREA")) {
                strValue = value.toString();
                if (strValue.length() > this.size_) {
                    strValue = strValue.substring(0, this.size_);
                }
                ((JTextArea)this.component).setText(strValue);
            }
            if (this.inputType_.equals("NUMERIC")) {
                String stringValue = "";
                stringValue = this.decimal_ == 0 ? XFUtility.getFormattedIntegerValue(this.getStringNumber(value.toString()), new ArrayList<String>(), this.size_) : XFUtility.getFormattedFloatValue(this.getStringNumber(value.toString()), this.decimal_);
                ((JTextField)this.component).setText(stringValue);
            }
            if (this.isAutoSizing) {
                int width = this.getBounds().width - 180;
                if (this.metrics.stringWidth(value.toString()) > width) {
                    this.setBounds(this.getBounds().x, this.getBounds().y, this.metrics.stringWidth(value.toString()) + 180, this.getBounds().height);
                }
            }
        }
        if (this.inputType_.equals("DATE")) {
            ((XFDateField)this.component).setValue(value.toString());
        }
        if (this.inputType_.equals("LISTBOX")) {
            int i = 0;
            while (i < this.valueList.size()) {
                if (value == this.valueList.get(i) || value.toString().equals(this.valueList.get(i).toString())) {
                    ((JComboBox)this.component).setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (this.inputType_.equals("CHECKBOX")) {
            if (value == Boolean.TRUE || value.toString().equals("true")) {
                ((JCheckBox)this.component).setSelected(true);
            } else {
                ((JCheckBox)this.component).setSelected(false);
            }
        }
    }

    public String getStringNumber(String text) {
        String numberString = XFUtility.getStringNumber(text);
        if (numberString.equals("")) {
            if (this.decimal_ == 0) {
                numberString = "0";
            }
            if (this.decimal_ == 1) {
                numberString = "0.0";
            }
            if (this.decimal_ == 2) {
                numberString = "0.00";
            }
            if (this.decimal_ == 3) {
                numberString = "0.000";
            }
            if (this.decimal_ == 4) {
                numberString = "0.0000";
            }
            if (this.decimal_ == 5) {
                numberString = "0.00000";
            }
            if (this.decimal_ == 6) {
                numberString = "0.000000";
            }
        }
        return numberString;
    }

    public Object getValue() {
        if (this.inputType_.equals("ALPHA") || this.inputType_.equals("KANJI")) {
            return ((JTextField)this.component).getText();
        }
        if (this.inputType_.equals("TEXTAREA")) {
            return ((JTextArea)this.component).getText();
        }
        if (this.inputType_.equals("ZEROFILL")) {
            String wrkStr = ((JTextField)this.component).getText();
            int fillZeroLength = this.size_ - wrkStr.length();
            int i = 0;
            while (i < fillZeroLength) {
                wrkStr = "0" + wrkStr;
                ++i;
            }
            return wrkStr;
        }
        if (this.inputType_.equals("NUMERIC")) {
            if (this.decimal_ == 0) {
                return Integer.parseInt(this.getStringNumber(((JTextField)this.component).getText()));
            }
            return Float.valueOf(Float.parseFloat(this.getStringNumber(((JTextField)this.component).getText())));
        }
        if (this.inputType_.equals("DATE")) {
            return ((XFDateField)this.component).getInternalValue();
        }
        if (this.inputType_.equals("LISTBOX")) {
            return this.valueList.get(((JComboBox)this.component).getSelectedIndex());
        }
        if (this.inputType_.equals("CHECKBOX")) {
            return ((JCheckBox)this.component).isSelected();
        }
        return null;
    }

    public void addItem(String text, Object value) {
        if (this.inputType_.equals("LISTBOX")) {
            ((JComboBox)this.component).addItem(text);
            int width = this.getBounds().width - 180;
            if (this.metrics.stringWidth(text) > width) {
                this.setBounds(this.getBounds().x, this.getBounds().y, this.metrics.stringWidth(text) + 180, this.getBounds().height);
            }
            this.valueList.add(value);
        }
    }

    public Object getItem() {
        if (this.inputType_.equals("LISTBOX")) {
            return ((JComboBox)this.component).getItemAt(((JComboBox)this.component).getSelectedIndex());
        }
        return null;
    }

    public int getItemCount() {
        if (this.inputType_.equals("LISTBOX")) {
            return ((JComboBox)this.component).getItemCount();
        }
        return 0;
    }

    public void setPrompter(String functionID, String sendFrom, String sendTo, String receiveFrom, String receiveTo) {
        if (this.inputType_.equals("ALPHA") || this.inputType_.equals("ZEROFILL") || this.inputType_.equals("NUMERIC")) {
            StringTokenizer workTokenizer;
            this.functionID_ = functionID;
            if (!sendFrom.equals("")) {
                workTokenizer = new StringTokenizer(sendFrom, ";");
                while (workTokenizer.hasMoreTokens()) {
                    this.fieldsToPutList_.add(workTokenizer.nextToken());
                }
            }
            if (!sendTo.equals("")) {
                workTokenizer = new StringTokenizer(sendTo, ";");
                while (workTokenizer.hasMoreTokens()) {
                    this.fieldsToPutToList_.add(workTokenizer.nextToken());
                }
            }
            if (!receiveFrom.equals("")) {
                workTokenizer = new StringTokenizer(receiveFrom, ";");
                while (workTokenizer.hasMoreTokens()) {
                    this.fieldsToGetList_.add(workTokenizer.nextToken());
                }
            }
            if (!receiveTo.equals("")) {
                workTokenizer = new StringTokenizer(receiveTo, ";");
                while (workTokenizer.hasMoreTokens()) {
                    this.fieldsToGetToList_.add(workTokenizer.nextToken());
                }
            }
            this.jButton = new JButton();
            ImageIcon imageIcon = new ImageIcon(XFInputDialogField.class.getResource("prompt.png"));
            this.jButton.setIcon(imageIcon);
            this.jButton.setPreferredSize(new Dimension(26, 25));
            this.jPanelEast.add((Component)this.jButton, "Center");
            this.jPanelEast.setSize(this.jPanelEast.getWidth() + 26, 25);
            this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width + 26, this.getBounds().height);
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        try {
                            Object value;
                            XFInputDialogField.this.setCursor(new Cursor(3));
                            HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>();
                            int i = 0;
                            while (i < XFInputDialogField.this.fieldsToPutList_.size()) {
                                value = XFInputDialogField.this.dialog_.getValueOfFieldByParmID((String)XFInputDialogField.this.fieldsToPutList_.get(i));
                                if (value != null) {
                                    fieldValuesMap.put((String)XFInputDialogField.this.fieldsToPutToList_.get(i), value);
                                }
                                ++i;
                            }
                            fieldValuesMap.put("RETURN_TO", XFInputDialogField.this.functionID_);
                            HashMap<String, Object> returnMap = XFInputDialogField.this.dialog_.getSession().executeFunction(XFInputDialogField.this.functionID_, fieldValuesMap);
                            if (returnMap.get("RETURN_TO") != null) {
                                XFInputDialogField.this.dialog_.returnTo(returnMap.get("RETURN_TO").toString());
                            }
                            if (!returnMap.get("RETURN_CODE").equals("99")) {
                                HashMap<String, Object> fieldsToGetMap = new HashMap<String, Object>();
                                int i2 = 0;
                                while (i2 < XFInputDialogField.this.fieldsToGetList_.size()) {
                                    value = returnMap.get(XFInputDialogField.this.fieldsToGetList_.get(i2));
                                    if (value != null) {
                                        fieldsToGetMap.put((String)XFInputDialogField.this.fieldsToGetToList_.get(i2), value);
                                    }
                                    ++i2;
                                }
                                i2 = 0;
                                while (i2 < XFInputDialogField.this.dialog_.getFieldList().size()) {
                                    value = fieldsToGetMap.get(XFInputDialogField.this.dialog_.getFieldList().get(i2).getParmID());
                                    if (value != null) {
                                        XFInputDialogField.this.dialog_.getFieldList().get(i2).setValue(value);
                                    }
                                    ++i2;
                                }
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage());
                            XFInputDialogField.this.setCursor(new Cursor(0));
                        }
                    }
                    finally {
                        XFInputDialogField.this.setCursor(new Cursor(0));
                    }
                }
            });
        }
    }

    public void setFileChooser(String title, String extentions) {
        if (this.inputType_.equals("ALPHA")) {
            this.setFileChooser(title, extentions, ((JTextField)this.component).getText());
        }
    }

    public void setFileChooser(String title, String extentions, String currentFolder) {
        if (this.inputType_.equals("ALPHA")) {
            this.jFileChooser = new JFileChooser();
            this.jFileChooser.setDialogTitle(title);
            if (!extentions.equals("")) {
                StringTokenizer workTokenizer = new StringTokenizer(extentions, ";");
                while (workTokenizer.hasMoreTokens()) {
                    String extention = workTokenizer.nextToken();
                    this.jFileChooser.setFileFilter(new FileNameExtensionFilter(extention, extention));
                }
            }
            if (!currentFolder.equals("")) {
                try {
                    File folder = new File(currentFolder);
                    this.jFileChooser.setCurrentDirectory(folder);
                }
                catch (Exception folder) {
                    // empty catch block
                }
            }
            this.jButton = new JButton();
            ImageIcon imageIcon = new ImageIcon(XFInputDialogField.class.getResource("prompt.png"));
            this.jButton.setIcon(imageIcon);
            this.jButton.setPreferredSize(new Dimension(26, 25));
            this.jPanelEast.add((Component)this.jButton, "Center");
            this.jPanelEast.setSize(this.jPanelEast.getWidth() + 26, 25);
            this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width + 26, this.getBounds().height);
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XFInputDialogField.this.jFileChooser_actionPerformed(e);
                }
            });
        }
    }

    public void setDirectoryChooser(String title) {
        if (this.inputType_.equals("ALPHA")) {
            this.setDirectoryChooser(title, ((JTextField)this.component).getText());
        }
    }

    public void setDirectoryChooser(String title, String currentFolder) {
        if (this.inputType_.equals("ALPHA")) {
            this.jFileChooser = new JFileChooser();
            this.jFileChooser.setDialogTitle(title);
            this.jFileChooser.setFileSelectionMode(1);
            if (!currentFolder.equals("")) {
                try {
                    File folder = new File(currentFolder);
                    this.jFileChooser.setCurrentDirectory(folder);
                }
                catch (Exception folder) {
                    // empty catch block
                }
            }
            this.jButton = new JButton();
            ImageIcon imageIcon = new ImageIcon(XFInputDialogField.class.getResource("prompt.png"));
            this.jButton.setIcon(imageIcon);
            this.jButton.setPreferredSize(new Dimension(26, 25));
            this.jPanelEast.add((Component)this.jButton, "Center");
            this.jPanelEast.setSize(this.jPanelEast.getWidth() + 26, 25);
            this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width + 26, this.getBounds().height);
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XFInputDialogField.this.jFileChooser_actionPerformed(e);
                }
            });
        }
    }

    public void jFileChooser_actionPerformed(ActionEvent e) {
        int reply = this.jFileChooser.showDialog(this.dialog_, XFUtility.RESOURCE.getString("ApproveButtonText"));
        if (reply == 0) {
            this.setValue(this.jFileChooser.getSelectedFile().getPath());
        }
    }

    public String getParmID() {
        return this.parmID_;
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            XFInputDialogField.this.getInputContext().setCompositionEnabled(false);
        }

        @Override
        public void focusGained(FocusEvent event) {
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            String lang = Locale.getDefault().getLanguage();
            if (XFInputDialogField.this.inputType_.equals("KANJI")) {
                if (lang.equals("ja")) {
                    subsets = new Character.Subset[]{InputSubset.KANJI};
                }
                if (lang.equals("ko")) {
                    subsets = new Character.Subset[]{InputSubset.HANJA};
                }
                if (lang.equals("zh")) {
                    subsets = new Character.Subset[]{InputSubset.TRADITIONAL_HANZI};
                }
                XFInputDialogField.this.getInputContext().setCharacterSubsets(subsets);
                XFInputDialogField.this.getInputContext().setCompositionEnabled(true);
            } else {
                XFInputDialogField.this.getInputContext().setCharacterSubsets(subsets);
                XFInputDialogField.this.getInputContext().setCompositionEnabled(false);
            }
        }
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        XFInputDialogField adaptee;

        LimitedDocument(XFInputDialogField adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) {
            try {
                int integerSizeOfField = this.adaptee.size_ - this.adaptee.decimal_;
                if (this.adaptee.decimal_ > 0 && str.length() == 1) {
                    String wrkStr0 = super.getText(0, super.getLength());
                    wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                    String wrkStr1 = wrkStr0.replace(".", "");
                    wrkStr1 = wrkStr1.replace(",", "");
                    if ((wrkStr1 = wrkStr1.replace("-", "")).length() > this.adaptee.size_) {
                        wrkStr1 = String.valueOf(wrkStr1.substring(0, integerSizeOfField)) + "." + wrkStr1.substring(integerSizeOfField, wrkStr1.length() - 1);
                        super.replace(0, super.getLength(), wrkStr1, attr);
                    } else {
                        int posOfDecimal = wrkStr0.indexOf(".");
                        if (posOfDecimal == -1) {
                            if (wrkStr1.length() > integerSizeOfField) {
                                wrkStr1 = String.valueOf(wrkStr1.substring(0, integerSizeOfField)) + "." + wrkStr1.substring(integerSizeOfField, wrkStr1.length());
                                super.replace(0, super.getLength(), wrkStr1, attr);
                            } else {
                                super.insertString(offset, str, attr);
                            }
                        } else {
                            int decimalLengthOfInputData = wrkStr0.length() - posOfDecimal - 1;
                            if (decimalLengthOfInputData <= this.adaptee.decimal_) {
                                super.insertString(offset, str, attr);
                            }
                        }
                    }
                } else if (str.contains(".") && XFInputDialogField.this.inputType_.equals("NUMERIC")) {
                    JOptionPane.showMessageDialog(null, XFUtility.RESOURCE.getString("NumberFormatError"));
                } else {
                    String wrkStr0 = super.getText(0, super.getLength());
                    wrkStr0 = String.valueOf(wrkStr0.substring(0, offset)) + str + wrkStr0.substring(offset, wrkStr0.length());
                    String wrkStr1 = wrkStr0.replace(".", "");
                    wrkStr1 = wrkStr1.replace(",", "");
                    if ((wrkStr1 = wrkStr1.replace("-", "")).length() <= this.adaptee.size_) {
                        super.insertString(offset, str, attr);
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

