/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputSubset;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;
import xeadDriver.Session;

public class XFLongTextEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 300;
    private JScrollPane jScrollPane = new JScrollPane();
    private JTextArea jTextArea = new JTextArea();
    private ArrayList<String> dataTypeOptionList_ = null;
    private Action undoAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            XFLongTextEditor.this.undo();
        }
    };
    private Action redoAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            XFLongTextEditor.this.redo();
        }
    };
    private UndoManager undoManager = new UndoManager();
    private Session session_;

    public XFLongTextEditor(Session session) {
        super(session, "", true);
        this.session_ = session;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.jTextArea.addFocusListener(new ComponentFocusListener());
        this.jTextArea.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jTextArea.getDocument().addUndoableEditListener(this.undoManager);
        this.jScrollPane.getViewport().setView(this.jTextArea);
        InputMap inputMap = this.jScrollPane.getInputMap(1);
        inputMap.clear();
        ActionMap actionMap = this.jScrollPane.getActionMap();
        actionMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "UNDO");
        actionMap.put("UNDO", this.undoAction);
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "REDO");
        actionMap.put("REDO", this.redoAction);
        this.setResizable(true);
        this.setPreferredSize(new Dimension(600, 300));
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((scrSize.width - 600) / 2, (scrSize.height - 300) / 2);
        this.pack();
    }

    public String request(String functionTitle, String fieldCaption, ArrayList<String> dataTypeOptionList, String text, boolean isEditable) {
        this.setTitle(String.valueOf(functionTitle) + " - " + fieldCaption);
        this.dataTypeOptionList_ = dataTypeOptionList;
        this.jTextArea.setText(text);
        this.jTextArea.setCaretPosition(0);
        this.jTextArea.setEditable(isEditable);
        this.undoManager.discardAllEdits();
        super.setVisible(true);
        return this.jTextArea.getText();
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (XFLongTextEditor.this.getInputContext() != null) {
                XFLongTextEditor.this.getInputContext().setCompositionEnabled(false);
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            String lang = Locale.getDefault().getLanguage();
            if (XFLongTextEditor.this.dataTypeOptionList_.contains("KANJI") || XFLongTextEditor.this.dataTypeOptionList_.contains("ZIPADRS")) {
                if (lang.equals("ja")) {
                    subsets = new Character.Subset[]{InputSubset.KANJI};
                }
                if (lang.equals("ko")) {
                    subsets = new Character.Subset[]{InputSubset.HANJA};
                }
                if (lang.equals("zh")) {
                    subsets = new Character.Subset[]{InputSubset.TRADITIONAL_HANZI};
                }
                XFLongTextEditor.this.getInputContext().setCharacterSubsets(subsets);
                XFLongTextEditor.this.getInputContext().setCompositionEnabled(true);
            } else if (XFLongTextEditor.this.dataTypeOptionList_.contains("KATAKANA") && lang.equals("ja")) {
                subsets = new Character.Subset[]{InputSubset.HALFWIDTH_KATAKANA};
                XFLongTextEditor.this.getInputContext().setCharacterSubsets(subsets);
                XFLongTextEditor.this.getInputContext().setCompositionEnabled(true);
            } else {
                XFLongTextEditor.this.getInputContext().setCharacterSubsets(subsets);
                XFLongTextEditor.this.getInputContext().setCompositionEnabled(false);
            }
        }
    }
}

