/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import xeadDriver.Session;

public class XFOptionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelMain = new JPanel();
    private JList<Object> jList = null;
    private Session session_;
    private Dimension scrSize;
    private Dimension dlgSize;
    private int maxCellWidth = 0;
    private int explicitWidth = 0;
    private ArrayList<String> optionList = new ArrayList();
    private int selectedIndex = -1;
    private XFOptionDialog_keyAdapter keyListener = new XFOptionDialog_keyAdapter();
    private XFOptionDialog_mouseAdapter mouseListener = new XFOptionDialog_mouseAdapter();
    private JLabel jLabel = new JLabel();
    private FontMetrics metrics;

    public XFOptionDialog(Session session) {
        this.session_ = session;
        this.setModal(true);
        this.scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.jPanelMain.setLayout(new BorderLayout());
        this.metrics = this.jLabel.getFontMetrics(new Font(this.session_.systemFont, 0, 18));
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.setResizable(false);
    }

    public void addOption(String option) {
        this.optionList.add(option);
        int width = this.metrics.stringWidth(option);
        if (width > this.maxCellWidth) {
            this.maxCellWidth = width;
        }
    }

    public String getOptionAt(int index) {
        if (this.optionList.size() > 0 && this.optionList.size() >= index + 1 && index >= 0) {
            return this.optionList.get(index);
        }
        return "";
    }

    public int getRowCount() {
        return this.optionList.size();
    }

    public void setWidth(int width) {
        this.explicitWidth = width;
    }

    public int request(String title) {
        this.selectedIndex = -1;
        int width = this.maxCellWidth + 10;
        int height = this.optionList.size() * 25;
        int dialogWidth = width + 20;
        if (this.explicitWidth == 0) {
            this.explicitWidth = dialogWidth;
        }
        this.setTitle(title);
        this.jPanelMain.removeAll();
        this.jList = new JList<Object>(this.optionList.toArray());
        this.jList.setFont(new Font(this.session_.systemFont, 0, 18));
        this.jList.setSelectedIndex(0);
        this.jList.setSelectionMode(0);
        this.jList.setFixedCellHeight(25);
        this.jList.addKeyListener(this.keyListener);
        this.jList.addMouseListener(this.mouseListener);
        this.jList.setBorder(null);
        this.jPanelMain.add(this.jList, "Center");
        this.dlgSize = new Dimension(this.explicitWidth, height + 10);
        this.jPanelMain.setPreferredSize(this.dlgSize);
        this.setLocation((this.scrSize.width - this.dlgSize.width) / 2, (this.scrSize.height - this.dlgSize.height) / 2);
        this.pack();
        this.setVisible(true);
        return this.selectedIndex;
    }

    class XFOptionDialog_keyAdapter
    extends KeyAdapter {
        XFOptionDialog_keyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                XFOptionDialog.this.selectedIndex = XFOptionDialog.this.jList.getSelectedIndex();
                XFOptionDialog.this.setVisible(false);
            }
        }
    }

    class XFOptionDialog_mouseAdapter
    extends MouseAdapter {
        XFOptionDialog_mouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (XFOptionDialog.this.optionList.size() > 0) {
                XFOptionDialog.this.selectedIndex = XFOptionDialog.this.jList.getSelectedIndex();
                XFOptionDialog.this.setVisible(false);
            }
        }
    }
}

