/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.XFUtility;

class XFScript {
    private ArrayList<String> fieldList = new ArrayList();
    private String tableID = "";
    private String scriptName = "";
    private String scriptText = "";
    private String eventP = "";
    private String eventR = "";
    private boolean isSuspended = false;

    public XFScript(String tableID, Element scriptElement, NodeList tableNodeList) {
        this.tableID = tableID;
        this.eventP = scriptElement.getAttribute("EventP");
        this.eventR = scriptElement.getAttribute("EventR");
        this.scriptName = scriptElement.getAttribute("Name");
        this.scriptText = XFUtility.substringLinesWithTokenOfEOL(scriptElement.getAttribute("Text"), "\n");
        this.fieldList = XFUtility.getDSNameListInScriptText(XFUtility.removeCommentsFromScriptText(this.scriptText), tableNodeList);
        if (scriptElement.getAttribute("Hold").equals("T")) {
            this.isSuspended = true;
        }
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public boolean isToBeRunAtEvent(String event1, String event2) {
        boolean result = false;
        if (!this.isSuspended) {
            ArrayList<String> event1List = new ArrayList<String>();
            StringTokenizer workTokenizer = new StringTokenizer(event1, ",");
            while (workTokenizer.hasMoreTokens()) {
                event1List.add(workTokenizer.nextToken());
            }
            int i = 0;
            while (i < event1List.size()) {
                if (this.eventP.contains((CharSequence)event1List.get(i))) {
                    if (event2.equals("")) {
                        result = true;
                        break;
                    }
                    if (event2.equals(this.eventR)) {
                        result = true;
                        break;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public ArrayList<String> getFieldList() {
        return this.fieldList;
    }

    public String getName() {
        return String.valueOf(this.tableID) + " " + this.scriptName;
    }
}

