/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputSubset;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import xeadDriver.XFEditableField;
import xeadDriver.XFUtility;

class XFTextArea
extends JScrollPane
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private String fieldOptions_ = "";
    private ArrayList<String> dataTypeOptionList;
    private JTextArea jTextArea = new JTextArea();
    private int rows_ = 2;
    private int digits_ = 5;
    private String oldValue = "";

    public XFTextArea(int digits, String dataTypeOptions, String fieldOptions, String fontName) {
        this.digits_ = digits;
        if (this.digits_ == 0) {
            this.digits_ = Integer.MAX_VALUE;
        }
        this.dataTypeOptionList = XFUtility.getOptionList(dataTypeOptions);
        this.fieldOptions_ = fieldOptions;
        InputMap inputMap = this.jTextArea.getInputMap(0);
        ActionMap actionMap = this.jTextArea.getActionMap();
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke altEnter = KeyStroke.getKeyStroke(10, 8);
        inputMap.put(altEnter, inputMap.get(enter));
        inputMap.put(enter, "none");
        inputMap.put(tab, "Exit");
        inputMap.put(shiftTab, "Backward");
        AbstractAction transferFocusAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XFTextArea.this.jTextArea.transferFocus();
            }
        };
        actionMap.put("Exit", transferFocusAction);
        AbstractAction transferFocusBackwardAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XFTextArea.this.jTextArea.transferFocusBackward();
            }
        };
        actionMap.put("Backward", transferFocusBackwardAction);
        this.jTextArea.addFocusListener(new ComponentFocusListener());
        this.jTextArea.setFont(new Font(fontName, 0, 18));
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(false);
        this.jTextArea.setDocument(new LimitedDocument(this));
        this.getViewport().add((Component)this.jTextArea, null);
        String wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "ROWS");
        if (!wrkStr.equals("")) {
            this.rows_ = Integer.parseInt(wrkStr);
        }
        int fieldWidth = 800;
        wrkStr = XFUtility.getOptionValueWithKeyword(this.fieldOptions_, "WIDTH");
        if (!wrkStr.equals("")) {
            fieldWidth = Integer.parseInt(wrkStr);
        }
        int fieldHeight = this.rows_ * 25 + (this.rows_ - 1) * 5;
        if (this.rows_ == 1) {
            fieldHeight = 25;
        }
        this.setSize(fieldWidth, fieldHeight);
        this.addFocusListener(new ScrollPaneFocusListener());
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public boolean isEditable() {
        return this.jTextArea.isEditable();
    }

    @Override
    public boolean isComponentFocusable() {
        return this.jTextArea.isFocusable();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setForeground(Color color) {
        if (this.jTextArea != null) {
            this.jTextArea.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.jTextArea != null) {
            this.jTextArea.setBackground(color);
        }
    }

    @Override
    public void setValue(Object text) {
        this.jTextArea.setText((String)text);
        this.jTextArea.setCaretPosition(0);
    }

    @Override
    public Object getInternalValue() {
        return this.jTextArea.getText();
    }

    @Override
    public Object getExternalValue() {
        return this.getInternalValue();
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = (String)obj;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    @Override
    public void setToolTipText(String text) {
        this.jTextArea.setToolTipText(text);
    }

    @Override
    public void setEditable(boolean editable) {
        this.jTextArea.setEditable(editable);
        if (editable) {
            this.jTextArea.setBackground(XFUtility.ACTIVE_COLOR);
        } else {
            this.jTextArea.setBackground(XFUtility.INACTIVE_COLOR);
        }
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (XFTextArea.this.getInputContext() != null) {
                XFTextArea.this.getInputContext().setCompositionEnabled(false);
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (XFTextArea.this.jTextArea.isEditable()) {
                XFTextArea.this.jTextArea.selectAll();
            }
            Character.Subset[] subsets = new Character.Subset[]{InputSubset.LATIN_DIGITS};
            String lang = Locale.getDefault().getLanguage();
            if (XFTextArea.this.dataTypeOptionList.contains("KANJI") || XFTextArea.this.dataTypeOptionList.contains("ZIPADRS")) {
                if (lang.equals("ja")) {
                    subsets = new Character.Subset[]{InputSubset.KANJI};
                }
                if (lang.equals("ko")) {
                    subsets = new Character.Subset[]{InputSubset.HANJA};
                }
                if (lang.equals("zh")) {
                    subsets = new Character.Subset[]{InputSubset.TRADITIONAL_HANZI};
                }
                XFTextArea.this.getInputContext().setCharacterSubsets(subsets);
                XFTextArea.this.getInputContext().setCompositionEnabled(true);
            } else if (XFTextArea.this.dataTypeOptionList.contains("KATAKANA") && lang.equals("ja")) {
                subsets = new Character.Subset[]{InputSubset.HALFWIDTH_KATAKANA};
                XFTextArea.this.getInputContext().setCharacterSubsets(subsets);
                XFTextArea.this.getInputContext().setCompositionEnabled(true);
            } else {
                XFTextArea.this.getInputContext().setCharacterSubsets(subsets);
                XFTextArea.this.getInputContext().setCompositionEnabled(false);
            }
        }
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        XFTextArea adaptee;

        LimitedDocument(XFTextArea adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            try {
                if (offset + str.length() <= this.adaptee.digits_ && super.getLength() + str.length() <= this.adaptee.digits_) {
                    super.insertString(offset, str, a);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    class ScrollPaneFocusListener
    implements FocusListener {
        ScrollPaneFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
        }

        @Override
        public void focusGained(FocusEvent event) {
            XFTextArea.this.jTextArea.requestFocus();
        }
    }
}

