/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import xeadDriver.XFEditableField;
import xeadDriver.XFUtility;

class XFUrlField
extends JPanel
implements XFEditableField {
    private static final long serialVersionUID = 1L;
    private JTextField jTextField = new JTextField();
    private JLabel jLabel = new JLabel();
    private Desktop desktop = Desktop.getDesktop();
    private int rows_ = 1;
    private String oldValue = "";

    public XFUrlField(int digits, String fieldOptions, String fontName) {
        this.jTextField.setFont(new Font(fontName, 0, 18));
        this.jTextField.setDocument(new LimitedDocument(digits));
        this.jTextField.setEditable(false);
        Font labelFont = new Font(fontName, 0, 18);
        this.jLabel.setFont(labelFont);
        this.jLabel.setForeground(Color.blue);
        this.jLabel.setHorizontalAlignment(2);
        this.jLabel.addMouseListener(new jLabel_mouseAdapter(this));
        this.jLabel.setBorder(this.jTextField.getBorder());
        this.jLabel.setFocusable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jLabel, "Center");
        String wrkStr = XFUtility.getOptionValueWithKeyword(fieldOptions, "WIDTH");
        int fieldWidth = !wrkStr.equals("") ? Integer.parseInt(wrkStr) : digits * 9 + 10;
        if (fieldWidth > 800) {
            fieldWidth = 800;
        }
        int fieldHeight = 25;
        this.setSize(fieldWidth, fieldHeight);
    }

    @Override
    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void exitFromComponent() {
        this.jTextField.transferFocus();
    }

    @Override
    public boolean isEditable() {
        return this.jTextField.isEditable();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isComponentFocusable() {
        return this.jTextField.isFocusable();
    }

    @Override
    public void setForeground(Color color) {
        if (this.jTextField != null) {
            this.jTextField.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.jTextField != null) {
            this.jTextField.setBackground(color);
        }
    }

    @Override
    public void setValue(Object obj) {
        String text = (String)obj;
        text = text.trim();
        this.jLabel.setText("<html><u>" + text);
        this.jTextField.setText(text);
    }

    @Override
    public String getInternalValue() {
        return this.jTextField.getText();
    }

    @Override
    public Object getExternalValue() {
        return this.getInternalValue();
    }

    @Override
    public void setOldValue(Object obj) {
        this.oldValue = (String)obj;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    @Override
    public void requestFocus() {
        this.jTextField.requestFocus();
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)this.jTextField, "Center");
        }
        this.jTextField.setEditable(editable);
    }

    @Override
    public void setToolTipText(String text) {
        this.jTextField.setToolTipText(text);
    }

    @Override
    public int getRows() {
        return this.rows_;
    }

    class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        int limit;

        LimitedDocument(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            if (offset >= this.limit) {
                return;
            }
            try {
                super.insertString(offset, str, a);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class jLabel_mouseAdapter
    extends MouseAdapter {
        XFUrlField adaptee;

        jLabel_mouseAdapter(XFUrlField adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            String fileName = XFUrlField.this.jTextField.getText();
            try {
                if (!fileName.equals("")) {
                    if (fileName.contains("@")) {
                        this.adaptee.desktop.browse(new URI("mailto:" + fileName));
                    } else if (fileName.contains("http://") || fileName.contains("https://")) {
                        this.adaptee.desktop.browse(new URI(fileName));
                    } else {
                        fileName = fileName.replaceAll(" ", "%20");
                        fileName = fileName.replaceAll("\\\\", "/");
                        fileName = fileName.replace("file://", "");
                        this.adaptee.desktop.browse(new URI("file://" + fileName));
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Failed to browse the file called '" + XFUrlField.this.jTextField.getText() + "'.");
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!XFUrlField.this.jTextField.getText().equals("")) {
                XFUrlField.this.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            XFUrlField.this.setCursor(new Cursor(0));
        }
    }
}

