/*
 * Decompiled with CFR 0.152.
 */
package xeadDriver;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BarcodeCodabar;
import com.lowagie.text.pdf.BarcodeEAN;
import com.lowagie.text.pdf.BarcodePDF417;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadDriver.Session;
import xeadDriver.SortableDomElementListModel;
import xeadDriver.XFByteArray;
import xeadDriver.XFEditableField;
import xeadDriver.XFTableOperator;

public class XFUtility {
    public static final ResourceBundle RESOURCE = ResourceBundle.getBundle("xeadDriver.Res");
    public static final int FIELD_UNIT_HEIGHT = 25;
    public static final int FIELD_HORIZONTAL_MARGIN = 1;
    public static final int FIELD_VERTICAL_MARGIN = 5;
    public static final int DEFAULT_LABEL_WIDTH = 150;
    public static final int ROW_UNIT_HEIGHT = 25;
    public static final int ROW_UNIT_HEIGHT_EDITABLE = 29;
    public static final int SEQUENCE_WIDTH = 45;
    public static final int FONT_SIZE = 18;
    public static final String DEFAULT_UPDATE_COUNTER = "UPDCOUNTER";
    public static final Color ERROR_COLOR = new Color(238, 187, 203);
    public static final Color ACTIVE_COLOR = SystemColor.white;
    public static final Color INACTIVE_COLOR = SystemColor.control;
    public static final Color ODD_ROW_COLOR = new Color(231, 231, 255);
    public static final Color SELECTED_ACTIVE_COLOR = new Color(49, 106, 197);
    public static final ImageIcon ICON_CHECK_0A = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iCheck0A.PNG")));
    public static final ImageIcon ICON_CHECK_1A = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iCheck1A.PNG")));
    public static final ImageIcon ICON_CHECK_0D = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iCheck0D.PNG")));
    public static final ImageIcon ICON_CHECK_1D = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iCheck1D.PNG")));
    public static final ImageIcon ICON_CHECK_0R = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iCheck0R.PNG")));
    public static final ImageIcon ICON_CHECK_1R = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iCheck1R.PNG")));
    public static final ImageIcon ICON_NOT_AVAILABLE = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("iNotAvailable.PNG")));
    public static final ImageIcon ICON_REFRESH = new ImageIcon(Toolkit.getDefaultToolkit().createImage(XFUtility.class.getResource("refresh.PNG")));
    public static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final DecimalFormat INTEGER_FORMAT = new DecimalFormat("#,##0");
    public static final DecimalFormat FLOAT_FORMAT0 = new DecimalFormat("#,##0");
    public static final DecimalFormat FLOAT_FORMAT1 = new DecimalFormat("#,##0.0");
    public static final DecimalFormat FLOAT_FORMAT2 = new DecimalFormat("#,##0.00");
    public static final DecimalFormat FLOAT_FORMAT3 = new DecimalFormat("#,##0.000");
    public static final DecimalFormat FLOAT_FORMAT4 = new DecimalFormat("#,##0.0000");
    public static final DecimalFormat FLOAT_FORMAT5 = new DecimalFormat("#,##0.00000");
    public static final DecimalFormat FLOAT_FORMAT6 = new DecimalFormat("#,##0.000000");
    public static final DecimalFormat FLOAT_FORMAT7 = new DecimalFormat("#,##0.0000000");
    public static final DecimalFormat FLOAT_FORMAT8 = new DecimalFormat("#,##0.00000000");
    public static final DecimalFormat FLOAT_FORMAT9 = new DecimalFormat("#,##0.000000000");
    private static final String DRIVER_DERBY = "org.apache.derby.jdbc.ClientDriver";
    private static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    private static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    private static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    private static final String DRIVER_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DRIVER_H2 = "org.h2.Driver";
    private static final String DRIVER_ACCESS = "net.ucanaccess.jdbc.UcanaccessDriver";

    static String getStringNumber(String text) {
        char[] numberDigit = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'};
        boolean charValidated = false;
        String numberString = "";
        if (text != null) {
            if (text.contains("E")) {
                try {
                    double doubleValue = Double.parseDouble(text);
                    numberString = new DecimalFormat("####0.0#############################").format(doubleValue);
                }
                catch (NumberFormatException e) {
                    numberString = "0";
                }
            } else {
                int i = 0;
                while (i < text.length()) {
                    charValidated = false;
                    int j = 0;
                    while (j < numberDigit.length) {
                        if (text.charAt(i) == numberDigit[j]) {
                            charValidated = true;
                            break;
                        }
                        ++j;
                    }
                    if (charValidated) {
                        numberString = String.valueOf(numberString) + text.charAt(i);
                    }
                    ++i;
                }
            }
        }
        return numberString;
    }

    static String getFormattedIntegerValue(String value, ArrayList<String> dataTypeOptionList, int size) {
        String returnValue = "";
        int pos = value.indexOf(".");
        String wrkValue = pos >= 0 ? value.substring(0, pos) : value;
        wrkValue = wrkValue.replace("-", "").replace("%", "");
        if (dataTypeOptionList.contains("NO_EDIT")) {
            StringBuffer bf = new StringBuffer();
            int intValue = Integer.parseInt(wrkValue);
            if (intValue == 0) {
                int i = 0;
                while (i < size) {
                    bf.append("0");
                    ++i;
                }
                returnValue = bf.toString();
            } else {
                if (value.startsWith("-")) {
                    bf.append("-");
                }
                int extra = size - wrkValue.length();
                int i = 0;
                while (i < extra) {
                    bf.append("0");
                    ++i;
                }
                bf.append(wrkValue);
                if (value.endsWith("-")) {
                    bf.append("-");
                }
                returnValue = bf.toString();
            }
        } else if (dataTypeOptionList.contains("ZERO_SUPPRESS")) {
            StringBuffer bf = new StringBuffer();
            if (value.startsWith("-")) {
                bf.append("-");
            }
            bf.append(wrkValue);
            if (value.endsWith("-")) {
                bf.append("-");
            }
            returnValue = bf.toString();
        } else if (dataTypeOptionList.contains("HH_MM")) {
            String hourStr = "00";
            String minuiteStr = "00";
            int wrkInt = Integer.parseInt(wrkValue);
            int hour = wrkInt / 100;
            hourStr = hour > 9 ? Integer.toString(hour) : "0" + Integer.toString(hour);
            if (wrkValue.length() == 1) {
                minuiteStr = "0" + wrkValue;
            }
            if (wrkValue.length() == 2) {
                minuiteStr = wrkValue;
            }
            if (wrkValue.length() >= 3) {
                minuiteStr = wrkValue.substring(wrkValue.length() - 2, wrkValue.length());
            }
            returnValue = String.valueOf(hourStr) + ":" + minuiteStr;
        } else {
            StringBuffer bf = new StringBuffer();
            if (value.startsWith("-")) {
                bf.append("-");
            }
            if (!wrkValue.equals("")) {
                bf.append(INTEGER_FORMAT.format(Long.parseLong(wrkValue)));
            }
            if (value.endsWith("-")) {
                bf.append("-");
            }
            returnValue = dataTypeOptionList.contains("PERCENT") ? String.valueOf(bf.toString()) + "%" : bf.toString();
        }
        return returnValue;
    }

    static String getFormattedFloatValue(String value, int decimalSize) {
        double doubleWrk;
        String returnValue = "";
        try {
            String wrkStr = value.toString();
            wrkStr = wrkStr.replace("-", "");
            doubleWrk = Double.parseDouble(wrkStr);
        }
        catch (NumberFormatException e) {
            doubleWrk = 0.0;
        }
        StringBuffer bf = new StringBuffer();
        if (value.startsWith("-")) {
            bf.append("-");
        }
        if (decimalSize == 0) {
            bf.append(FLOAT_FORMAT0.format(doubleWrk));
        }
        if (decimalSize == 1) {
            bf.append(FLOAT_FORMAT1.format(doubleWrk));
        }
        if (decimalSize == 2) {
            bf.append(FLOAT_FORMAT2.format(doubleWrk));
        }
        if (decimalSize == 3) {
            bf.append(FLOAT_FORMAT3.format(doubleWrk));
        }
        if (decimalSize == 4) {
            bf.append(FLOAT_FORMAT4.format(doubleWrk));
        }
        if (decimalSize == 5) {
            bf.append(FLOAT_FORMAT5.format(doubleWrk));
        }
        if (decimalSize == 6) {
            bf.append(FLOAT_FORMAT6.format(doubleWrk));
        }
        if (decimalSize == 7) {
            bf.append(FLOAT_FORMAT7.format(doubleWrk));
        }
        if (decimalSize == 8) {
            bf.append(FLOAT_FORMAT8.format(doubleWrk));
        }
        if (decimalSize == 9) {
            bf.append(FLOAT_FORMAT9.format(doubleWrk));
        }
        if (value.endsWith("-")) {
            bf.append("-");
        }
        returnValue = bf.toString();
        return returnValue;
    }

    public static Object getNullValueOfBasicType(String basicType) {
        Object value = null;
        if (basicType.equals("INTEGER") || basicType.equals("FLOAT")) {
            value = 0;
        }
        if (basicType.equals("STRING") || basicType.equals("DATETIME") || basicType.equals("TIME") || basicType.equals("DATE")) {
            value = "";
        }
        return value;
    }

    public static boolean isNullValue(String basicType, Object value) {
        String strValue;
        boolean isNull = false;
        if ((basicType.equals("INTEGER") || basicType.equals("FLOAT")) && ((strValue = value.toString()) == null || strValue.equals("") || strValue.equals("0") || strValue.equals("0.0"))) {
            isNull = true;
        }
        if ((basicType.equals("STRING") || basicType.equals("DATETIME") || basicType.equals("TIME")) && ((strValue = value.toString()) == null || strValue.equals(""))) {
            isNull = true;
        }
        if (basicType.equals("DATE")) {
            if (value == null) {
                isNull = true;
            } else {
                strValue = value.toString();
                if (strValue.equals("")) {
                    isNull = true;
                }
            }
        }
        if (basicType.equals("BYTEA")) {
            isNull = value == null ? true : !(value instanceof byte[]);
        }
        return isNull;
    }

    static boolean isStaticRefer(String tableID, Element referElement) {
        boolean reply = true;
        StringTokenizer workTokenizer1 = new StringTokenizer(referElement.getAttribute("WithKeyFields"), ";");
        while (workTokenizer1.hasMoreTokens()) {
            String wrkStr = workTokenizer1.nextToken();
            StringTokenizer workTokenizer2 = new StringTokenizer(wrkStr, ".");
            if (workTokenizer2.nextToken().equals(tableID)) continue;
            reply = false;
            break;
        }
        return reply;
    }

    public static ArrayList<String> getDSNameListInScriptText(String scriptText, NodeList tableList) {
        ArrayList<String> fieldList = new ArrayList<String>();
        String[] sectionDigit = new String[]{"(", ")", "{", "}", "+", "-", "/", "*", "=", "<", ">", ";", "|", "&", "\n", "\t", ",", " ", "!"};
        String[] fieldProperty = new String[]{"value", "oldValue", "color", "enabled", "editable", "error", "valueChanged"};
        int i = 0;
        while (i < fieldProperty.length) {
            int pos = 0;
            while (pos < scriptText.length()) {
                int posWrk = scriptText.indexOf("." + fieldProperty[i], pos);
                if (posWrk == -1) {
                    pos = scriptText.length();
                }
                if (posWrk == -1) continue;
                int wrkInt = posWrk - 1;
                while (wrkInt > -1) {
                    int posWrk2;
                    int j;
                    String wrkStr1;
                    boolean isFirstDigitOfField = false;
                    if (--wrkInt > -1) {
                        wrkStr1 = scriptText.substring(wrkInt, wrkInt + 1);
                        j = 0;
                        while (j < sectionDigit.length) {
                            if (wrkStr1.equals(sectionDigit[j])) {
                                isFirstDigitOfField = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (wrkInt != -1 && !isFirstDigitOfField) continue;
                    String dataSource = "";
                    String variantExpression = scriptText.substring(wrkInt + 1, posWrk);
                    if (XFUtility.countStringInText(variantExpression, "_") > 1) {
                        String wrkStr2 = "";
                        j = 0;
                        while (j < tableList.getLength()) {
                            Element element = (Element)tableList.item(j);
                            wrkStr1 = String.valueOf(element.getAttribute("ID")) + "_";
                            if (variantExpression.startsWith(wrkStr1) && wrkStr1.length() > wrkStr2.length() + 1) {
                                wrkStr2 = element.getAttribute("ID");
                            }
                            ++j;
                        }
                        if (!wrkStr2.equals("") && !fieldList.contains(dataSource = variantExpression.replaceFirst(String.valueOf(wrkStr2) + "_", String.valueOf(wrkStr2) + "."))) {
                            fieldList.add(dataSource);
                        }
                    }
                    if (dataSource.equals("") && (posWrk2 = variantExpression.indexOf("_")) > -1 && !fieldList.contains(dataSource = String.valueOf(variantExpression.substring(0, posWrk2)) + "." + variantExpression.substring(posWrk2 + 1, variantExpression.length()))) {
                        fieldList.add(dataSource);
                    }
                    wrkInt = -1;
                    pos = posWrk + 6;
                }
            }
            ++i;
        }
        return fieldList;
    }

    public static int countStringInText(String text, String searchString) {
        return (text.length() - text.replaceAll(searchString, "").length()) / searchString.length();
    }

    public static int countNumberOfDisplayedFilters(NodeList filterFieldList) {
        int count = 0;
        String fieldOptions = "";
        int i = 0;
        while (i < filterFieldList.getLength()) {
            Element element = (Element)filterFieldList.item(i);
            fieldOptions = element.getAttribute("FieldOptions");
            ArrayList<String> fieldOptionList = XFUtility.getOptionList(fieldOptions);
            if (!fieldOptionList.contains("HIDDEN")) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    static ImageIcon createSmallIcon(String fileName, int iconWidth, int iconHeight) {
        ImageIcon icon = new ImageIcon();
        BufferedImage image = null;
        try {
            File imageFile;
            if (fileName.startsWith("http://")) {
                fileName = fileName.replace("\\", "/");
                URL url = new URL(fileName);
                image = ImageIO.read(url);
            } else if ((fileName.toUpperCase().contains(".GIF") || fileName.toUpperCase().contains(".BMP") || fileName.toUpperCase().contains(".JPEG") || fileName.toUpperCase().contains(".JPG") || fileName.toUpperCase().contains(".JPE") || fileName.toUpperCase().contains(".PNG")) && (imageFile = new File(fileName)).exists()) {
                image = ImageIO.read(imageFile);
            }
            if (image == null) {
                icon = ICON_NOT_AVAILABLE;
            } else {
                float rateHeight;
                float rate = 0.0f;
                float rateWidth = (float)iconWidth / (float)image.getWidth();
                rate = rateWidth > (rateHeight = (float)iconHeight / (float)image.getHeight()) ? rateHeight : rateWidth;
                int width = Math.round((float)image.getWidth() * rate);
                int height = Math.round((float)image.getHeight() * rate);
                BufferedImage shrinkImage = new BufferedImage(width, height, 1);
                Graphics2D g2d = shrinkImage.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2d.drawImage(image, 0, 0, width, height, null);
                icon.setImage(shrinkImage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public static String removeCommentsFromScriptText(String scriptText) {
        StringBuffer buf = new StringBuffer();
        int posCommentEnd = 0;
        int pos = 0;
        while (pos < scriptText.length()) {
            int posCommentStart = scriptText.indexOf("//", pos);
            if (posCommentStart == -1) {
                posCommentStart = scriptText.indexOf("/*", pos);
                if (posCommentStart == -1) {
                    posCommentStart = scriptText.length();
                    posCommentEnd = scriptText.length();
                } else {
                    posCommentEnd = scriptText.indexOf("*/", posCommentStart);
                    posCommentEnd = posCommentEnd == -1 ? scriptText.length() : (posCommentEnd += 2);
                }
            } else {
                posCommentEnd = scriptText.indexOf("\n", posCommentStart);
                if (posCommentEnd == -1) {
                    posCommentEnd = scriptText.length();
                }
            }
            buf.append(scriptText.substring(pos, posCommentStart));
            pos = ++posCommentEnd;
        }
        return buf.toString();
    }

    static Object parseObjectAccordingToType(Object value, String basicType) {
        Object returnValue = "";
        if (basicType.equals("INTEGER")) {
            returnValue = value != null && !value.toString().equals("") ? (value.equals("*Auto") ? value : Long.valueOf(Long.parseLong(value.toString()))) : Integer.valueOf(0);
        } else if (basicType.equals("FLOAT")) {
            returnValue = value != null && !value.toString().equals("") ? (Number)Double.parseDouble(value.toString()) : (Number)Float.valueOf(0.0f);
        } else if (value != null) {
            if (basicType.equals("STRING")) {
                value = value.toString().trim();
            }
            returnValue = value;
        }
        return returnValue;
    }

    public static void loadDriverClass(String dbName) throws ClassNotFoundException {
        if (dbName.contains("derby:")) {
            Class.forName(DRIVER_DERBY);
            return;
        }
        if (dbName.contains("mysql:")) {
            Class.forName(DRIVER_MYSQL);
            return;
        }
        if (dbName.contains("postgresql:")) {
            Class.forName(DRIVER_POSTGRESQL);
            return;
        }
        if (dbName.contains("oracle:")) {
            Class.forName(DRIVER_ORACLE);
            return;
        }
        if (dbName.contains("sqlserver:")) {
            Class.forName(DRIVER_SQLSERVER);
            return;
        }
        if (dbName.contains("h2:")) {
            Class.forName(DRIVER_H2);
            return;
        }
        if (dbName.contains("ucanaccess:")) {
            Class.forName(DRIVER_ACCESS);
            return;
        }
    }

    public static ArrayList<String> getOptionList(String options) {
        int index2;
        ArrayList<String> typeOptionList = new ArrayList<String>();
        int index = options.indexOf("VALUES(");
        if (index > -1 && (index2 = options.indexOf(")", index)) > -1) {
            String wrkStr = options.substring(index, index2 + 1);
            typeOptionList.add(wrkStr);
            options.replace(String.valueOf(wrkStr) + ",", "").replace(wrkStr, "");
        }
        StringTokenizer workTokenizer = new StringTokenizer(options, ",");
        while (workTokenizer.hasMoreTokens()) {
            typeOptionList.add(workTokenizer.nextToken());
        }
        return typeOptionList;
    }

    public static String getOptionValueWithKeyword(String options, String keyword) {
        String value = "";
        if (!keyword.equals("")) {
            int lengthOfKeyword = keyword.length() + 1;
            ArrayList<String> typeOptionList = XFUtility.getOptionList(options);
            int i = 0;
            while (i < typeOptionList.size()) {
                int pos1 = typeOptionList.get(i).indexOf(String.valueOf(keyword) + "(");
                if (pos1 == 0) {
                    int pos2 = typeOptionList.get(i).length() - 1;
                    value = typeOptionList.get(i).substring(pos1 + lengthOfKeyword, pos2);
                    break;
                }
                ++i;
            }
        }
        return value;
    }

    static String getDefaultValueOfFilterField(String keywordValue, Session session) {
        String defaultValue = null;
        StringTokenizer workTokenizer = new StringTokenizer(keywordValue, ":");
        if (workTokenizer.countTokens() == 1) {
            defaultValue = workTokenizer.nextToken().trim();
        }
        if (workTokenizer.countTokens() == 2) {
            String keyword = workTokenizer.nextToken();
            String value = workTokenizer.nextToken().trim();
            if (keyword.equals("VALUE")) {
                defaultValue = value;
            }
            if (keyword.equals("USER_ATTRIBUTE")) {
                if (value.equals("ID")) {
                    defaultValue = session.getUserID();
                }
                if (value.equals("Name")) {
                    defaultValue = session.getUserName();
                }
                if (value.equals("EmployeeNo")) {
                    defaultValue = session.getUserEmployeeNo();
                }
            }
            if (keyword.equals("SESSION_ATTRIBUTE")) {
                defaultValue = session.getAttribute(value);
            }
        }
        return defaultValue;
    }

    static String getCaptionValue(String keywordValue, Session session) {
        String captionValue = keywordValue;
        StringTokenizer workTokenizer = new StringTokenizer(keywordValue, ":");
        if (workTokenizer.countTokens() == 2) {
            String keyword = workTokenizer.nextToken();
            String value = workTokenizer.nextToken().trim();
            if (keyword.equals("SESSION_ATTRIBUTE")) {
                captionValue = session.getAttribute(value);
            }
        }
        return captionValue;
    }

    static String getFixedWhereValue(String keywordValue, Session session) {
        String value;
        String id;
        StringTokenizer workTokenizer;
        String wrkStr;
        int pos2;
        int pos1;
        int i;
        String fixedWhereValue = keywordValue.replace("\"", "'");
        if (keywordValue.contains("SESSION_ATTRIBUTE:")) {
            i = 0;
            while (i < keywordValue.length()) {
                pos1 = keywordValue.indexOf("SESSION_ATTRIBUTE:", i);
                if (pos1 == -1) {
                    i = keywordValue.length();
                } else {
                    pos2 = keywordValue.indexOf(" ", pos1);
                    if (pos2 == -1) {
                        pos2 = keywordValue.length();
                        i = keywordValue.length();
                    }
                    wrkStr = keywordValue.substring(pos1, pos2);
                    wrkStr = wrkStr.replace("'", "");
                    workTokenizer = new StringTokenizer(wrkStr = wrkStr.replace("\"", ""), ":");
                    if (workTokenizer.countTokens() == 2) {
                        workTokenizer.nextToken();
                        id = workTokenizer.nextToken().trim();
                        value = session.getAttribute(id);
                        if (value == null) {
                            JOptionPane.showMessageDialog(null, "Session attribute not found with id of '" + id + "'.");
                        } else {
                            fixedWhereValue = fixedWhereValue.replace(wrkStr, value);
                        }
                    }
                    i = pos1 + 1;
                }
                ++i;
            }
        }
        if (keywordValue.contains("USER_ATTRIBUTE:")) {
            i = 0;
            while (i < keywordValue.length()) {
                pos1 = keywordValue.indexOf("USER_ATTRIBUTE:", i);
                if (pos1 == -1) {
                    i = keywordValue.length();
                } else {
                    pos2 = keywordValue.indexOf(" ", pos1);
                    if (pos2 == -1) {
                        pos2 = keywordValue.length();
                        i = keywordValue.length();
                    }
                    wrkStr = keywordValue.substring(pos1, pos2);
                    wrkStr = wrkStr.replace("'", "");
                    workTokenizer = new StringTokenizer(wrkStr = wrkStr.replace("\"", ""), ":");
                    if (workTokenizer.countTokens() == 2) {
                        workTokenizer.nextToken();
                        id = workTokenizer.nextToken().trim();
                        value = session.getAttribute(id);
                        if (value == null) {
                            JOptionPane.showMessageDialog(null, "User attribute not found with type of '" + id + "'.");
                        } else {
                            fixedWhereValue = fixedWhereValue.replace(wrkStr, value);
                        }
                    }
                    i = pos1 + 1;
                }
                ++i;
            }
        }
        return fixedWhereValue;
    }

    public static String getBasicTypeOf(String dataType) {
        String basicType = "STRING";
        if (dataType.equals("INTEGER") || dataType.equals("SMALLINT") || dataType.equals("BIGINT")) {
            basicType = "INTEGER";
        }
        if (dataType.equals("DOUBLE") || dataType.equals("DECIMAL") || dataType.equals("FLOAT") || dataType.equals("DOUBLE PRECISION") || dataType.equals("NUMERIC") || dataType.equals("REAL")) {
            basicType = "FLOAT";
        }
        if (dataType.equals("CHAR") || dataType.equals("TEXT") || dataType.equals("VARCHAR") || dataType.equals("LONG VARCHAR")) {
            basicType = "STRING";
        }
        if (dataType.equals("BINARY") || dataType.equals("VARBINARY") || dataType.equals("BLOB")) {
            basicType = "BINARY";
        }
        if (dataType.equals("CLOB")) {
            basicType = "CLOB";
        }
        if (dataType.equals("BYTEA")) {
            basicType = "BYTEA";
        }
        if (dataType.equals("DATE")) {
            basicType = "DATE";
        }
        if (dataType.startsWith("TIME")) {
            basicType = "TIME";
        }
        if (dataType.startsWith("TIMESTAMP")) {
            basicType = "DATETIME";
        }
        if (dataType.equals("DATETIME")) {
            basicType = "DATETIME";
        }
        return basicType;
    }

    public static boolean isLiteralRequiredBasicType(String basicType) {
        return basicType.equals("STRING") || basicType.equals("DATE") || basicType.equals("TIME") || basicType.equals("DATETIME") || basicType.equals("BYTEA");
    }

    public static Object getTableOperationValue(String basicType, Object value, String dbName) {
        Object returnValue = null;
        if (basicType.equals("INTEGER")) {
            String strInt;
            if (value == null || value.toString().equals("")) {
                value = 0;
            }
            if ((strInt = value.toString()).endsWith(".0")) {
                strInt = strInt.replace(".0", "");
            }
            if (strInt.contains("E")) {
                double doubleValue = new Double(strInt);
                strInt = Integer.toString((int)Math.floor(doubleValue));
            }
            returnValue = Long.parseLong(strInt);
        }
        if (basicType.equals("FLOAT")) {
            if (value == null || value.toString().equals("")) {
                value = 0.0;
            }
            returnValue = Double.parseDouble(value.toString());
        }
        if (basicType.equals("STRING")) {
            if (value.toString().contains("''")) {
                returnValue = "'" + value.toString() + "'";
            } else {
                String strValue = value.toString().replaceAll("'", "''");
                returnValue = "'" + strValue + "'";
            }
        }
        if (basicType.equals("DATE")) {
            String strDate;
            returnValue = value == null ? "NULL" : ((strDate = value.toString()) == null || strDate.equals("") ? "NULL" : (dbName.contains("ucanaccess:") ? "#" + strDate + "#" : "'" + strDate + "'"));
        }
        if (basicType.equals("DATETIME")) {
            String timeDate = value.toString();
            if (timeDate == null || timeDate.equals("")) {
                returnValue = "NULL";
            } else if (timeDate.equals("CURRENT_TIMESTAMP")) {
                returnValue = timeDate;
            } else {
                timeDate = timeDate.replace("/", "-");
                returnValue = dbName.contains("ucanaccess:") ? "#" + timeDate + "#" : "'" + timeDate + "'";
            }
        }
        if (basicType.equals("BYTEA")) {
            if (value == null) {
                returnValue = "''";
            } else {
                XFByteArray xfByteArray = (XFByteArray)value;
                byte[] byteArray = (byte[])xfByteArray.getInternalValue();
                String stringByteArray = new String(byteArray);
                returnValue = "'" + stringByteArray + "'";
            }
        }
        return returnValue;
    }

    static String getTableIDOfTableAlias(String tableAlias, NodeList referList1, NodeList referList2) {
        Element workElement;
        String tableID = tableAlias;
        int j = 0;
        while (j < referList1.getLength()) {
            workElement = (Element)referList1.item(j);
            if (workElement.getAttribute("TableAlias").equals(tableAlias) || workElement.getAttribute("ToTable").equals(tableAlias) && workElement.getAttribute("TableAlias").equals("")) {
                tableID = workElement.getAttribute("ToTable");
                break;
            }
            ++j;
        }
        if (referList2 != null) {
            j = 0;
            while (j < referList2.getLength()) {
                workElement = (Element)referList2.item(j);
                if (workElement.getAttribute("TableAlias").equals(tableAlias) || workElement.getAttribute("ToTable").equals(tableAlias) && workElement.getAttribute("TableAlias").equals("")) {
                    tableID = workElement.getAttribute("ToTable");
                    break;
                }
                ++j;
            }
        }
        return tableID;
    }

    static Object getValueAccordingToBasicType(String basicType, Object value) {
        Object valueReturn = null;
        if (XFUtility.isLiteralRequiredBasicType(basicType)) {
            valueReturn = basicType.equals("BYTEA") ? new XFByteArray(value) : (value == null ? (basicType.equals("DATE") ? "" : null) : value.toString().trim());
        } else if (basicType.equals("INTEGER")) {
            if (value == null || value.equals("")) {
                valueReturn = "";
            } else {
                String wrkStr = value.toString();
                wrkStr = XFUtility.getStringNumber(wrkStr);
                valueReturn = (wrkStr = wrkStr.replace(".0", "")).equals("") ? "" : Long.valueOf(Long.parseLong(wrkStr));
            }
        } else {
            String wrkStr;
            valueReturn = basicType.equals("FLOAT") ? (value == null || value.equals("") ? "" : ((wrkStr = XFUtility.getStringNumber(value.toString())).equals("") ? "" : Double.valueOf(Double.parseDouble(wrkStr)))) : value;
        }
        return valueReturn;
    }

    static void setValueToEditableField(String basicType, Object valueObject, XFEditableField editableField) {
        String wrkStr;
        if (basicType.equals("INTEGER")) {
            if (valueObject == null || valueObject.equals("")) {
                editableField.setValue("");
            } else if (valueObject.equals("*AUTO")) {
                editableField.setValue(valueObject);
            } else {
                wrkStr = valueObject.toString();
                wrkStr = XFUtility.getStringNumber(wrkStr);
                if ((wrkStr = wrkStr.replace(".0", "")).equals("")) {
                    editableField.setValue("");
                } else {
                    editableField.setValue(Long.parseLong(wrkStr));
                }
            }
        }
        if (basicType.equals("FLOAT")) {
            if (valueObject == null || valueObject.equals("")) {
                editableField.setValue("");
            } else {
                wrkStr = XFUtility.getStringNumber(valueObject.toString());
                if (wrkStr.equals("")) {
                    editableField.setValue("");
                } else {
                    editableField.setValue(Double.parseDouble(wrkStr));
                }
            }
        }
        if (basicType.equals("STRING")) {
            if (valueObject == null) {
                editableField.setValue("");
            } else {
                String value = valueObject.toString();
                if (value == null) {
                    editableField.setValue("");
                } else {
                    editableField.setValue(value);
                }
            }
        }
        if (basicType.equals("DATE") || basicType.equals("BYTEA") || basicType.equals("BINARY")) {
            editableField.setValue(valueObject);
        }
        if (basicType.equals("DATETIME") || basicType.equals("TIME")) {
            if (valueObject == null) {
                editableField.setValue("");
            } else {
                editableField.setValue(valueObject.toString());
            }
        }
    }

    static void setOldValueToEditableField(String basicType, Object valueObject, XFEditableField editableField) {
        String wrkStr;
        if (basicType.equals("INTEGER")) {
            if (valueObject == null || valueObject.equals("")) {
                editableField.setOldValue("");
            } else {
                wrkStr = valueObject.toString();
                wrkStr = XFUtility.getStringNumber(wrkStr);
                if ((wrkStr = wrkStr.replace(".0", "")).equals("")) {
                    editableField.setOldValue("");
                } else {
                    editableField.setOldValue(Long.parseLong(wrkStr));
                }
            }
        }
        if (basicType.equals("FLOAT")) {
            if (valueObject == null || valueObject.equals("")) {
                editableField.setOldValue("");
            } else {
                wrkStr = XFUtility.getStringNumber(valueObject.toString());
                if (wrkStr.equals("")) {
                    editableField.setOldValue("");
                } else {
                    editableField.setOldValue(Double.parseDouble(wrkStr));
                }
            }
        }
        if (basicType.equals("STRING")) {
            if (valueObject == null) {
                editableField.setOldValue("");
            } else {
                String value = valueObject.toString();
                if (value == null) {
                    editableField.setOldValue("");
                } else {
                    editableField.setOldValue(value);
                }
            }
        }
        if (basicType.equals("DATE") || basicType.equals("BINARY")) {
            if (valueObject == null) {
                editableField.setOldValue(null);
            } else {
                editableField.setOldValue(valueObject);
            }
        }
        if (basicType.equals("DATETIME") || basicType.equals("TIME")) {
            if (valueObject == null) {
                editableField.setOldValue("");
            } else {
                editableField.setOldValue(valueObject.toString());
            }
        }
    }

    static short getFloatFormat(XSSFWorkbook workbook, int decimalSize) {
        XSSFDataFormat format = workbook.createDataFormat();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i <= decimalSize) {
            if (i == 0) {
                buf.append("#,##0");
            } else {
                if (i == 1) {
                    buf.append(".");
                }
                buf.append("0");
            }
            ++i;
        }
        return format.getFormat(buf.toString());
    }

    static Object calculateExpireValue(Element tableElement, XFTableOperator operator, Session session, StringBuffer logBuf) throws Exception {
        StringTokenizer workTokenizer;
        Object object = null;
        StringBuffer buf = new StringBuffer();
        ArrayList<String> keyFieldIDList = new ArrayList<String>();
        ArrayList<Boolean> keyFieldIsLiteralRequiredList = new ArrayList<Boolean>();
        String tableID = tableElement.getAttribute("ID");
        String activeWhere = tableElement.getAttribute("ActiveWhere");
        NodeList nodeList = tableElement.getElementsByTagName("Key");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element workElement = (Element)nodeList.item(i);
            if (workElement.getAttribute("Type").equals("PK")) {
                workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                while (workTokenizer.hasMoreTokens()) {
                    String wrkStr = workTokenizer.nextToken();
                    keyFieldIDList.add(wrkStr);
                    workElement = session.getFieldElement(tableID, wrkStr);
                    wrkStr = workElement.getAttribute("Type");
                    if (wrkStr.equals("CHAR") || wrkStr.equals("VARCHAR") || wrkStr.equals("LONG VARCHAR") || wrkStr.equals("DATE") || wrkStr.equals("DATETIME") || wrkStr.startsWith("TIME") || wrkStr.startsWith("TIMESTAMP")) {
                        keyFieldIsLiteralRequiredList.add(true);
                        continue;
                    }
                    keyFieldIsLiteralRequiredList.add(false);
                }
                break;
            }
            ++i;
        }
        workTokenizer = new StringTokenizer(tableElement.getAttribute("RangeKey"), ";");
        String rangeKeyFieldValid = workTokenizer.nextToken();
        buf.append("select ");
        buf.append(rangeKeyFieldValid);
        buf.append(" from ");
        buf.append(tableID);
        buf.append(" where ");
        int count = -1;
        i = 0;
        while (i < keyFieldIDList.size()) {
            if (++count > 0) {
                buf.append(" and ");
            }
            buf.append((String)keyFieldIDList.get(i));
            if (((String)keyFieldIDList.get(i)).equals(rangeKeyFieldValid)) {
                buf.append(">");
            } else {
                buf.append("=");
            }
            if (((Boolean)keyFieldIsLiteralRequiredList.get(i)).booleanValue()) {
                buf.append("'");
                buf.append(operator.getValueOf((String)keyFieldIDList.get(i)).toString());
                buf.append("'");
            } else {
                buf.append(operator.getValueOf((String)keyFieldIDList.get(i)).toString());
            }
            ++i;
        }
        if (!activeWhere.equals("")) {
            buf.append(" and ");
            buf.append(activeWhere);
        }
        buf.append(" order by ");
        buf.append(rangeKeyFieldValid);
        XFTableOperator operatorExpire = new XFTableOperator(session, logBuf, buf.toString());
        if (operatorExpire.next()) {
            object = operatorExpire.getValueOf(rangeKeyFieldValid);
        }
        return object;
    }

    static int adjustFontSizeToGetPreferredWidthOfLabel(JLabel jLabel, int initialWidth) {
        int width = initialWidth;
        int initialFontSize = jLabel.getFont().getSize();
        FontMetrics metrics = jLabel.getFontMetrics(jLabel.getFont());
        if (metrics.stringWidth(jLabel.getText()) > width) {
            int i = initialFontSize;
            while (i > 10) {
                jLabel.setFont(new Font(jLabel.getFont().getFontName(), 0, jLabel.getFont().getSize() - 1));
                metrics = jLabel.getFontMetrics(jLabel.getFont());
                if (metrics.stringWidth(jLabel.getText()) <= width) break;
                --i;
            }
        }
        return metrics.stringWidth(jLabel.getText());
    }

    public static String substringLinesWithTokenOfEOL(String originalString, String stringToBeInserted) {
        StringBuffer processedString = new StringBuffer();
        int lastEnd = 0;
        int i = 0;
        while (i <= originalString.length()) {
            if (i + 5 <= originalString.length()) {
                if (originalString.substring(i, i + 5).equals("#EOL#")) {
                    processedString.append(originalString.substring(lastEnd, i));
                    processedString.append(stringToBeInserted);
                    lastEnd = i + 5;
                }
            } else if (i == originalString.length()) {
                processedString.append(originalString.substring(lastEnd, i));
            }
            ++i;
        }
        return processedString.toString();
    }

    public static String getLayoutedString(String originalString, String stringToBeInserted, String fontName) {
        StringBuffer processedString = new StringBuffer();
        int lastEnd = 0;
        int maxRowLength = 0;
        int pixcelLengthOfFirstRow = 0;
        JLabel label = new JLabel();
        FontMetrics metrics = label.getFontMetrics(new Font(fontName, 0, 18));
        maxRowLength = originalString.getBytes().length == originalString.length() ? 40 : 30;
        String adjustedString = originalString.replaceAll("#EOL#", "");
        if (adjustedString.length() > maxRowLength) {
            String wrkStr = adjustedString.substring(0, maxRowLength);
            pixcelLengthOfFirstRow = metrics.stringWidth(wrkStr);
            adjustedString = originalString.replaceAll("#EOL#", "\n");
            int i = 0;
            while (i < adjustedString.length()) {
                wrkStr = adjustedString.substring(lastEnd, i + 1);
                if (metrics.stringWidth(wrkStr) < pixcelLengthOfFirstRow) {
                    if (i == adjustedString.length() - 1) {
                        wrkStr = adjustedString.substring(lastEnd, i + 1);
                        processedString.append(adjustedString.substring(lastEnd, i + 1));
                        lastEnd = i;
                    } else if (adjustedString.substring(i, i + 1).equals("\n")) {
                        wrkStr = adjustedString.substring(lastEnd, i);
                        processedString.append(String.valueOf(wrkStr) + stringToBeInserted);
                        lastEnd = i + 1;
                    }
                } else {
                    wrkStr = adjustedString.substring(lastEnd, i);
                    processedString.append(String.valueOf(wrkStr) + stringToBeInserted);
                    lastEnd = i;
                }
                ++i;
            }
        } else {
            processedString.append(adjustedString.replaceAll("\n", stringToBeInserted));
        }
        return processedString.toString();
    }

    static String getEditValueOfLong(long value, String editCode, int size) {
        DecimalFormat integerFormat = new DecimalFormat("#,##0;#,##0-");
        if (editCode.equals("a0")) {
            integerFormat = new DecimalFormat("#,##0;#,##0-");
        }
        if (editCode.equals("a1")) {
            integerFormat = new DecimalFormat("#,##0;-#,##0");
        }
        if (editCode.equals("g0")) {
            integerFormat = new DecimalFormat("#.##0;#.##0-");
        }
        if (editCode.equals("g1")) {
            integerFormat = new DecimalFormat("#.##0;-#.##0");
        }
        if (editCode.equals("j0")) {
            integerFormat = new DecimalFormat("#,##0;#,##0\u25b2");
        }
        if (editCode.equals("j1")) {
            integerFormat = new DecimalFormat("#,##0;\u25b2#,##0");
        }
        return integerFormat.format(value);
    }

    static String getEditValueOfDouble(double value, String editCode, int decimal) {
        DecimalFormat floatFormat = new DecimalFormat("#,##0.0;#,##0.0-");
        if (editCode.equals("a0")) {
            if (decimal == 1) {
                floatFormat = new DecimalFormat("#,##0.0;#,##0.0-");
            }
            if (decimal == 2) {
                floatFormat = new DecimalFormat("#,##0.00;#,##0.00-");
            }
            if (decimal == 3) {
                floatFormat = new DecimalFormat("#,##0.000;#,##0.000-");
            }
            if (decimal == 4) {
                floatFormat = new DecimalFormat("#,##0.0000;#,##0.0000-");
            }
            if (decimal >= 5) {
                floatFormat = new DecimalFormat("#,##0.00000;#,##0.00000-");
            }
        }
        if (editCode.equals("a1")) {
            if (decimal == 1) {
                floatFormat = new DecimalFormat("#,##0.0;-#,##0.0");
            }
            if (decimal == 2) {
                floatFormat = new DecimalFormat("#,##0.00;-#,##0.00");
            }
            if (decimal == 3) {
                floatFormat = new DecimalFormat("#,##0.000;-#,##0.000");
            }
            if (decimal == 4) {
                floatFormat = new DecimalFormat("#,##0.0000;-#,##0.0000");
            }
            if (decimal >= 5) {
                floatFormat = new DecimalFormat("#,##0.00000;#,-##0.00000");
            }
        }
        if (editCode.equals("g0")) {
            if (decimal == 1) {
                floatFormat = new DecimalFormat("#.##0,0;#.##0,0-");
            }
            if (decimal == 2) {
                floatFormat = new DecimalFormat("#.##0,00;#.##0,00-");
            }
            if (decimal == 3) {
                floatFormat = new DecimalFormat("#.##0,000;#.##0,000-");
            }
            if (decimal == 4) {
                floatFormat = new DecimalFormat("#.##0,0000;#.##0,0000-");
            }
            if (decimal >= 5) {
                floatFormat = new DecimalFormat("#.##0,00000;#.##0,00000-");
            }
        }
        if (editCode.equals("g1")) {
            if (decimal == 1) {
                floatFormat = new DecimalFormat("#.##0,0;-#.##0,0");
            }
            if (decimal == 2) {
                floatFormat = new DecimalFormat("#.##0,00;-#.##0,00");
            }
            if (decimal == 3) {
                floatFormat = new DecimalFormat("#.##0,000;-#.##0,000");
            }
            if (decimal == 4) {
                floatFormat = new DecimalFormat("#.##0,0000;-#.##0,0000");
            }
            if (decimal >= 5) {
                floatFormat = new DecimalFormat("#.##0,00000;-#.##0,00000");
            }
        }
        if (editCode.equals("j0")) {
            if (decimal == 1) {
                floatFormat = new DecimalFormat("#,##0.0;#,##0.0\u25b2");
            }
            if (decimal == 2) {
                floatFormat = new DecimalFormat("#,##0.00;#,##0.00\u25b2");
            }
            if (decimal == 3) {
                floatFormat = new DecimalFormat("#,##0.000;#,##0.000\u25b2");
            }
            if (decimal == 4) {
                floatFormat = new DecimalFormat("#,##0.0000;#,##0.0000\u25b2");
            }
            if (decimal >= 5) {
                floatFormat = new DecimalFormat("#,##0.00000;#,##0.00000\u25b2");
            }
        }
        if (editCode.equals("j1")) {
            if (decimal == 1) {
                floatFormat = new DecimalFormat("#,##0.0;\u25b2#,##0.0");
            }
            if (decimal == 2) {
                floatFormat = new DecimalFormat("#,##0.00;\u25b2#,##0.00");
            }
            if (decimal == 3) {
                floatFormat = new DecimalFormat("#,##0.000;\u25b2#,##0.000");
            }
            if (decimal == 4) {
                floatFormat = new DecimalFormat("#,##0.0000;\u25b2#,##0.0000");
            }
            if (decimal >= 5) {
                floatFormat = new DecimalFormat("#,##0.00000;#,\u25b2##0.00000");
            }
        }
        return floatFormat.format(value);
    }

    public static String getUserExpressionOfUtilDate(java.util.Date date, String dateFormat, boolean isWithTime) {
        SimpleDateFormat formatter;
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        StringBuffer buf = new StringBuffer();
        if (dateFormat.equals("")) {
            formatter = isWithTime ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", new Locale("en", "US", "US")) : new SimpleDateFormat("yyyy-MM-dd", new Locale("en", "US", "US"));
            buf.append(formatter.format(cal.getTime()));
        }
        if (dateFormat.equals("en00") || dateFormat.equals("en01")) {
            if (dateFormat.equals("en01")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
            formatter = isWithTime ? new SimpleDateFormat("MM/dd/yy HH:mm", new Locale("en", "US", "US")) : new SimpleDateFormat("MM/dd/yy", new Locale("en", "US", "US"));
            buf.append(formatter.format(cal.getTime()));
        }
        if (dateFormat.equals("en10") || dateFormat.equals("en11")) {
            if (dateFormat.equals("en11")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
            formatter = isWithTime ? new SimpleDateFormat("MMMdd,yyyy HH:mm", new Locale("en", "US", "US")) : new SimpleDateFormat("MMMdd,yyyy", new Locale("en", "US", "US"));
            buf.append(formatter.format(cal.getTime()));
        }
        if (dateFormat.equals("jp00") || dateFormat.equals("jp01")) {
            formatter = isWithTime ? new SimpleDateFormat("yy/MM/dd HH:mm") : new SimpleDateFormat("yy/MM/dd");
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp01")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp10") || dateFormat.equals("jp11")) {
            formatter = isWithTime ? new SimpleDateFormat("yyyy/MM/dd HH:mm") : new SimpleDateFormat("yyyy/MM/dd");
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp11")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
            formatter = isWithTime ? new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm") : new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp21")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp30") || dateFormat.equals("jp31")) {
            formatter = isWithTime ? new SimpleDateFormat("Gyy/MM/dd HH:mm", new Locale("ja", "JP", "JP")) : new SimpleDateFormat("Gyy/MM/dd", new Locale("ja", "JP", "JP"));
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp31")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp40") || dateFormat.equals("jp41")) {
            formatter = isWithTime ? new SimpleDateFormat("Gyy\u5e74MM\u6708dd\u65e5 HH:mm", new Locale("ja", "JP", "JP")) : new SimpleDateFormat("Gyy\u5e74MM\u6708dd\u65e5", new Locale("ja", "JP", "JP"));
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp41")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
            formatter = isWithTime ? new SimpleDateFormat("GGGGyy\u5e74MM\u6708dd\u65e5 HH:mm", new Locale("ja", "JP", "JP")) : new SimpleDateFormat("GGGGyy\u5e74MM\u6708dd\u65e5", new Locale("ja", "JP", "JP"));
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp51")) {
                buf.append(XFUtility.getDayOfWeek(cal, dateFormat));
            }
        }
        return buf.toString();
    }

    static String getCaptionForCell(String caption) {
        String value = caption;
        if (value.toUpperCase().contains("<HTML>")) {
            value = value.replace("<HTML>", "");
            value = value.replace("<html>", "");
            value = value.replace("<BR>", "\n");
            value = value.replace("<br>", "\n");
            value = value.replace("</HTML>", "");
            value = value.replace("</html>", "");
        }
        return value;
    }

    static Image getImageForPDF(String fileName, float newWidth, float newHeight) {
        Image image = null;
        try {
            float percentWidth = 100.0f;
            float percentHeight = 100.0f;
            BufferedImage bi = null;
            if (fileName.startsWith("http://")) {
                fileName = fileName.replace("\\", "/");
                URL url = new URL(fileName);
                bi = ImageIO.read(url);
            } else {
                File imageFile = new File(fileName);
                if (imageFile.exists()) {
                    bi = ImageIO.read(imageFile);
                }
            }
            if (bi != null) {
                image = Image.getInstance((java.awt.Image)bi, null);
                if (newWidth > 0.0f && newHeight > 0.0f) {
                    image.scaleToFit(newWidth, newHeight);
                } else {
                    if (newWidth > 0.0f) {
                        percentWidth = newWidth / image.getWidth() * 100.0f;
                    }
                    if (newHeight > 0.0f) {
                        percentHeight = newHeight / image.getHeight() * 100.0f;
                    }
                    if (percentWidth < percentHeight) {
                        image.scalePercent(percentWidth);
                    } else {
                        image.scalePercent(percentHeight);
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(e.getMessage()) + "\n" + fileName);
        }
        return image;
    }

    static void setupImageCell(XSSFWorkbook workBook, XSSFSheet workSheet, int rowIndexFrom, int rowIndexThru, int columnIndexFrom, int columnIndexThru, String fileName) {
        int imageTypeIndex = -1;
        String fileNameCapital = fileName.toUpperCase();
        if (fileNameCapital.contains(".PNG")) {
            imageTypeIndex = 6;
        }
        if (fileNameCapital.contains(".JPG") || fileNameCapital.contains(".JPE") || fileNameCapital.contains(".JPEG")) {
            imageTypeIndex = 5;
        }
        if (fileNameCapital.contains(".GIF")) {
            imageTypeIndex = 8;
        }
        if (fileNameCapital.contains(".BMP")) {
            imageTypeIndex = 11;
        }
        if (imageTypeIndex != -1) {
            try {
                FileInputStream inputStream = new FileInputStream(fileName);
                byte[] bytes = IOUtils.toByteArray(inputStream);
                int pictureIndex = workBook.addPicture(bytes, imageTypeIndex);
                ((InputStream)inputStream).close();
                XSSFCreationHelper helper = workBook.getCreationHelper();
                XSSFDrawing drawing = workSheet.createDrawingPatriarch();
                ClientAnchor anchor = helper.createClientAnchor();
                anchor.setCol1(columnIndexFrom);
                anchor.setRow1(rowIndexFrom);
                anchor.setCol2(columnIndexThru);
                anchor.setRow2(rowIndexThru);
                anchor.setDx1(20);
                anchor.setDy1(20);
                anchor.setDx2(0);
                anchor.setDy2(0);
                drawing.createPicture(anchor, pictureIndex);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Rectangle getPageSize(String size, String direction) {
        Rectangle rec = PageSize.A4;
        if (direction.equals("LANDSCAPE")) {
            if (size.equals("A2")) {
                rec = PageSize.A2.rotate();
            }
            if (size.equals("A3")) {
                rec = PageSize.A3.rotate();
            }
            if (size.equals("A4")) {
                rec = PageSize.A4.rotate();
            }
            if (size.equals("A5")) {
                rec = PageSize.A5.rotate();
            }
            if (size.equals("A6")) {
                rec = PageSize.A6.rotate();
            }
            if (size.equals("B2")) {
                rec = PageSize.B2.rotate();
            }
            if (size.equals("B3")) {
                rec = PageSize.B3.rotate();
            }
            if (size.equals("B4")) {
                rec = PageSize.B4.rotate();
            }
            if (size.equals("B5")) {
                rec = PageSize.B5.rotate();
            }
            if (size.equals("B6")) {
                rec = PageSize.B6.rotate();
            }
        } else {
            if (size.equals("A2")) {
                rec = PageSize.A2;
            }
            if (size.equals("A3")) {
                rec = PageSize.A3;
            }
            if (size.equals("A4")) {
                rec = PageSize.A4;
            }
            if (size.equals("A5")) {
                rec = PageSize.A5;
            }
            if (size.equals("A6")) {
                rec = PageSize.A6;
            }
            if (size.equals("B2")) {
                rec = PageSize.B2;
            }
            if (size.equals("B3")) {
                rec = PageSize.B3;
            }
            if (size.equals("B4")) {
                rec = PageSize.B4;
            }
            if (size.equals("B5")) {
                rec = PageSize.B5;
            }
            if (size.equals("B6")) {
                rec = PageSize.B6;
            }
        }
        return rec;
    }

    static void drawLineOrRect(String keyword, PdfContentByte cb) {
        try {
            float y2;
            float x2;
            float y1;
            float x1;
            int pos;
            StringTokenizer workTokenizer;
            if (keyword.contains("&Line(") && (workTokenizer = new StringTokenizer(keyword.substring(6, pos = keyword.lastIndexOf(")")), ";")).countTokens() >= 4) {
                x1 = Float.parseFloat(workTokenizer.nextToken().trim());
                y1 = Float.parseFloat(workTokenizer.nextToken().trim());
                x2 = Float.parseFloat(workTokenizer.nextToken().trim());
                y2 = Float.parseFloat(workTokenizer.nextToken().trim());
                cb.moveTo(x1, y1);
                cb.lineTo(x2, y2);
                cb.stroke();
            }
            if (keyword.contains("&Rect(") && (workTokenizer = new StringTokenizer(keyword.substring(6, pos = keyword.lastIndexOf(")")), ";")).countTokens() == 4) {
                x1 = Float.parseFloat(workTokenizer.nextToken().trim());
                y1 = Float.parseFloat(workTokenizer.nextToken().trim());
                x2 = Float.parseFloat(workTokenizer.nextToken().trim());
                y2 = Float.parseFloat(workTokenizer.nextToken().trim());
                cb.moveTo(x1, y1);
                cb.lineTo(x2, y1);
                cb.lineTo(x2, y2);
                cb.lineTo(x1, y2);
                cb.closePathStroke();
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, String.valueOf(RESOURCE.getString("FunctionError39")) + keyword + RESOURCE.getString("FunctionError40") + e.toString());
        }
    }

    static Chunk getBarcodeChunkOfValue(String value, String type, PdfContentByte cb) throws BadElementException {
        Image image;
        BarcodeEAN barcode;
        Chunk chunk = null;
        if (type.equals("EAN8")) {
            barcode = new BarcodeEAN();
            barcode.setCodeType(2);
            barcode.setCode(value);
            image = barcode.createImageWithBarcode(cb, null, null);
            chunk = new Chunk(image, 0.0f, 0.0f);
        }
        if (type.equals("EAN13")) {
            barcode = new BarcodeEAN();
            barcode.setCodeType(1);
            barcode.setCode(value);
            image = barcode.createImageWithBarcode(cb, null, null);
            chunk = new Chunk(image, 0.0f, 0.0f);
        }
        if (type.equals("39")) {
            barcode = new Barcode39();
            barcode.setCode(value);
            image = barcode.createImageWithBarcode(cb, null, null);
            chunk = new Chunk(image, 0.0f, 0.0f);
        }
        if (type.equals("128")) {
            barcode = new Barcode128();
            barcode.setCode(value);
            image = barcode.createImageWithBarcode(cb, null, null);
            chunk = new Chunk(image, 0.0f, 0.0f);
        }
        if (type.equals("NW7")) {
            barcode = new BarcodeCodabar();
            barcode.setCode(value);
            image = barcode.createImageWithBarcode(cb, null, null);
            chunk = new Chunk(image, 0.0f, 0.0f);
        }
        if (type.equals("PDF417")) {
            barcode = new BarcodePDF417();
            barcode.setText(value);
            image = barcode.getImage();
            chunk = new Chunk(image, 0.0f, 0.0f);
        }
        return chunk;
    }

    static int getLengthOfEdittedNumericValue(int dataSize, int decimalSize, ArrayList<String> dataTypeOptionList) {
        int length = dataSize;
        if (decimalSize > 0) {
            ++length;
        }
        if (dataTypeOptionList.contains("ACCEPT_MINUS") || dataTypeOptionList.contains("HH_MM")) {
            ++length;
        }
        if (!(dataTypeOptionList.contains("NO_EDIT") || dataTypeOptionList.contains("ZERO_SUPPRESS") || dataTypeOptionList.contains("HH_MM"))) {
            int intSize = dataSize - decimalSize;
            while (intSize > 3) {
                ++length;
                intSize -= 3;
            }
        }
        return length;
    }

    static int getWidthOfDateValue(String dateFormat, String fontName, int fontSize) {
        int width = 133;
        JTextField textField = new JTextField();
        FontMetrics metrics = textField.getFontMetrics(new Font(fontName, 0, fontSize));
        if (dateFormat.equals("en00")) {
            width = metrics.stringWidth("06/17/10");
        }
        if (dateFormat.equals("en01")) {
            width = metrics.stringWidth("Thur,06/17/01");
        }
        if (dateFormat.equals("en10")) {
            width = metrics.stringWidth("Jun17,2010");
        }
        if (dateFormat.equals("en11")) {
            width = metrics.stringWidth("Thur,Jun17,2001");
        }
        if (dateFormat.equals("jp00")) {
            width = metrics.stringWidth("10/06/17");
        }
        if (dateFormat.equals("jp01")) {
            width = metrics.stringWidth("10/06/17(\u6728)");
        }
        if (dateFormat.equals("jp10")) {
            width = metrics.stringWidth("2010/06/17");
        }
        if (dateFormat.equals("jp11")) {
            width = metrics.stringWidth("2010/06/17(\u6728)");
        }
        if (dateFormat.equals("jp20")) {
            width = metrics.stringWidth("2010\u5e746\u670817\u65e5");
        }
        if (dateFormat.equals("jp21")) {
            width = metrics.stringWidth("2010\u5e746\u670817\u65e5(\u6728)");
        }
        if (dateFormat.equals("jp30")) {
            width = metrics.stringWidth("H22/06/17");
        }
        if (dateFormat.equals("jp31")) {
            width = metrics.stringWidth("H22/06/17(\u6728)");
        }
        if (dateFormat.equals("jp40")) {
            width = metrics.stringWidth("H22\u5e7406\u670817\u65e5");
        }
        if (dateFormat.equals("jp41")) {
            width = metrics.stringWidth("H22\u5e7406\u670817\u65e5(\u6728)");
        }
        if (dateFormat.equals("jp50")) {
            width = metrics.stringWidth("\u5e73\u621022\u5e7406\u670817\u65e5");
        }
        if (dateFormat.equals("jp51")) {
            width = metrics.stringWidth("\u5e73\u621022\u5e7406\u670817\u65e5(\u6728)");
        }
        return width + 10;
    }

    static String getUserExpressionOfYearMonth(String yearMonth, String dateFormat) {
        SimpleDateFormat formatter;
        Calendar cal;
        int month;
        int year;
        String result = "";
        if (yearMonth.length() == 6) {
            year = Integer.parseInt(yearMonth.substring(0, 4));
            month = Integer.parseInt(yearMonth.substring(4, 6)) - 1;
            cal = Calendar.getInstance();
            cal.set(year, month, 1);
            if (dateFormat.equals("en00") || dateFormat.equals("en01") || dateFormat.equals("en10") || dateFormat.equals("en11")) {
                formatter = new SimpleDateFormat("MMM,yyyy", new Locale("en", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp00") || dateFormat.equals("jp01") || dateFormat.equals("jp10") || dateFormat.equals("jp11") || dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
                formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708", new Locale("ja", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp30") || dateFormat.equals("jp31") || dateFormat.equals("jp40") || dateFormat.equals("jp41") || dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
                formatter = new SimpleDateFormat("Gyy\u5e74MM\u6708", new Locale("ja", "JP", "JP"));
                result = formatter.format(cal.getTime());
            }
        }
        if (yearMonth.length() == 4) {
            year = Integer.parseInt(yearMonth.substring(0, 4));
            month = 0;
            cal = Calendar.getInstance();
            cal.set(year, month, 1);
            if (dateFormat.equals("en00") || dateFormat.equals("en01") || dateFormat.equals("en10") || dateFormat.equals("en11")) {
                formatter = new SimpleDateFormat("fiscal yyyy", new Locale("en", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp00") || dateFormat.equals("jp01") || dateFormat.equals("jp10") || dateFormat.equals("jp11") || dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
                formatter = new SimpleDateFormat("yyyy\u5e74\u5ea6", new Locale("ja", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp30") || dateFormat.equals("jp31") || dateFormat.equals("jp40") || dateFormat.equals("jp41") || dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
                formatter = new SimpleDateFormat("Gyy\u5e74\u5ea6", new Locale("ja", "JP", "JP"));
                result = formatter.format(cal.getTime());
            }
        }
        return result;
    }

    static String getUserExpressionOfMSeq(int mSeq, Session session) {
        String language = "";
        String dateFormat = session.getDateFormat();
        if (dateFormat != null && dateFormat.length() > 1) {
            language = dateFormat.substring(0, 2);
        }
        String[] monthArrayEn = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov"};
        String[] monthArrayJp = new String[]{"\uff11\u6708\u5ea6", "\uff12\u6708\u5ea6", "\uff13\u6708\u5ea6", "\uff14\u6708\u5ea6", "\uff15\u6708\u5ea6", "\uff16\u6708\u5ea6", "\uff17\u6708\u5ea6", "\uff18\u6708\u5ea6", "\uff19\u6708\u5ea6", "10\u6708\u5ea6", "11\u6708\u5ea6", "12\u6708\u5ea6", "\uff11\u6708\u5ea6", "\uff12\u6708\u5ea6", "\uff13\u6708\u5ea6", "\uff14\u6708\u5ea6", "\uff15\u6708\u5ea6", "\uff16\u6708\u5ea6", "\uff17\u6708\u5ea6", "\uff18\u6708\u5ea6", "\uff19\u6708\u5ea6", "10\u6708\u5ea6", "11\u6708\u5ea6"};
        String result = "";
        int startMonth = 1;
        startMonth = session.getSystemVariantInteger("FIRST_MONTH");
        if (mSeq >= 1 && mSeq <= 12) {
            if (language.equals("en")) {
                result = monthArrayEn[mSeq + startMonth - 2];
            }
            if (language.equals("jp")) {
                result = monthArrayJp[mSeq + startMonth - 2];
            }
        }
        return result;
    }

    static String getWhereValueOfDateTimeSegment(String operandType, String originalSegment) {
        String month;
        String lastChar;
        String segment = originalSegment.replace("/", "-");
        String valueMin = "";
        String valueMax = "";
        StringBuffer bf = new StringBuffer();
        if (segment.length() == 0) {
            valueMin = "0000-01-01 00:00:00.0";
            valueMax = "9999-12-31 23:59:59.999";
        }
        if (segment.length() == 1) {
            valueMin = String.valueOf(segment) + "000-01-01 00:00:00.0";
            valueMax = String.valueOf(segment) + "999-12-31 23:59:59.999";
        }
        if (segment.length() == 2) {
            valueMin = String.valueOf(segment) + "00-01-01 00:00:00.0";
            valueMax = String.valueOf(segment) + "99-12-31 23:59:59.999";
        }
        if (segment.length() == 3) {
            valueMin = String.valueOf(segment) + "0-01-01 00:00:00.0";
            valueMax = String.valueOf(segment) + "9-12-31 23:59:59.999";
        }
        if (segment.length() == 4) {
            valueMin = String.valueOf(segment) + "-01-01 00:00:00.0";
            valueMax = String.valueOf(segment) + "-12-31 23:59:59.999";
        }
        if (segment.length() == 5) {
            valueMin = String.valueOf(segment) + "01-01 00:00:00.0";
            valueMax = String.valueOf(segment) + "12-31 23:59:59.999";
        }
        if (segment.length() == 6) {
            lastChar = segment.substring(segment.length() - 1, segment.length());
            if (lastChar.equals("0")) {
                valueMin = String.valueOf(segment) + "1-01 00:00:00.0";
                valueMax = String.valueOf(segment) + "9-30 23:59:59.999";
            } else {
                valueMin = String.valueOf(segment) + "0-01 00:00:00.0";
                valueMax = String.valueOf(segment) + "2-31 23:59:59.999";
            }
        }
        if (segment.length() == 7) {
            month = segment.substring(segment.length() - 2, segment.length());
            valueMin = String.valueOf(segment) + "-01 00:00:00.0";
            if (month.equals("04") || month.equals("06") || month.equals("09") || month.equals("11")) {
                valueMax = String.valueOf(segment) + "-30 23:59:59.999";
            }
            if (month.equals("01") || month.equals("03") || month.equals("05") || month.equals("07") || month.equals("08") || month.equals("10") || month.equals("12")) {
                valueMax = String.valueOf(segment) + "-31 23:59:59.999";
            }
            if (month.equals("02")) {
                valueMax = String.valueOf(segment) + "-" + XFUtility.getLastDateOfFebruary(segment.substring(0, 4)) + " 23:59:59.999";
            }
        }
        if (segment.length() == 8) {
            month = segment.substring(segment.length() - 3, segment.length() - 1);
            valueMin = String.valueOf(segment) + "01 00:00:00.0";
            if (month.equals("04") || month.equals("06") || month.equals("09") || month.equals("11")) {
                valueMax = String.valueOf(segment) + "30 23:59:59.999";
            }
            if (month.equals("01") || month.equals("03") || month.equals("05") || month.equals("07") || month.equals("08") || month.equals("10") || month.equals("12")) {
                valueMax = String.valueOf(segment) + "31 23:59:59.999";
            }
            if (month.equals("02")) {
                valueMax = String.valueOf(segment) + XFUtility.getLastDateOfFebruary(segment.substring(0, 4)) + " 23:59:59.999";
            }
        }
        if (segment.length() == 9) {
            month = segment.substring(segment.length() - 4, segment.length() - 2);
            String lastChar2 = segment.substring(segment.length() - 1, segment.length());
            if (lastChar2.equals("0")) {
                valueMin = String.valueOf(segment) + "1 00:00:00.0";
                valueMax = String.valueOf(segment) + "9 23:59:59.999";
            }
            if (lastChar2.equals("1")) {
                valueMin = String.valueOf(segment) + "0 00:00:00.0";
                valueMax = String.valueOf(segment) + "9 23:59:59.999";
            }
            if (lastChar2.equals("2")) {
                valueMin = String.valueOf(segment) + "0 00:00:00.0";
                if (month.equals("02")) {
                    String date = XFUtility.getLastDateOfFebruary(segment.substring(0, 4));
                    valueMax = String.valueOf(segment) + date.substring(1, 2) + " 23:59:59.999";
                } else {
                    valueMax = String.valueOf(segment) + "9 23:59:59.999";
                }
            }
            if (lastChar2.equals("3")) {
                valueMin = String.valueOf(segment) + "0 00:00:00.0";
                if (month.equals("04") || month.equals("06") || month.equals("09") || month.equals("11")) {
                    valueMax = String.valueOf(segment) + "0 23:59:59.999";
                }
                if (month.equals("01") || month.equals("03") || month.equals("05") || month.equals("07") || month.equals("08") || month.equals("10") || month.equals("12")) {
                    valueMax = String.valueOf(segment) + "1 23:59:59.999";
                }
            }
        }
        if (segment.length() == 10) {
            valueMin = String.valueOf(segment) + " 00:00:00.0";
            valueMax = String.valueOf(segment) + " 23:59:59.999";
        }
        if (segment.length() == 11) {
            valueMin = String.valueOf(segment) + "00:00:00.0";
            valueMax = String.valueOf(segment) + "23:59:59.999";
        }
        if (segment.length() == 12) {
            lastChar = segment.substring(segment.length() - 1, segment.length());
            if (lastChar.equals("0") || lastChar.equals("1")) {
                valueMin = String.valueOf(segment) + "0:00:00.0";
                valueMax = String.valueOf(segment) + "9:59:59.999";
            }
            if (lastChar.equals("2")) {
                valueMin = String.valueOf(segment) + "0:00:00.0";
                valueMax = String.valueOf(segment) + "3:59:59.999";
            }
        }
        if (segment.length() == 13) {
            valueMin = String.valueOf(segment) + ":00:00.0";
            valueMax = String.valueOf(segment) + ":59:59.999";
        }
        if (segment.length() == 14) {
            valueMin = String.valueOf(segment) + "00:00.0";
            valueMax = String.valueOf(segment) + "59:59.999";
        }
        if (segment.length() == 15) {
            valueMin = String.valueOf(segment) + "0:00.0";
            valueMax = String.valueOf(segment) + "9:59.999";
        }
        if (segment.length() == 16) {
            valueMin = String.valueOf(segment) + ":00.0";
            valueMax = String.valueOf(segment) + ":59.999";
        }
        if (segment.length() == 17) {
            valueMin = String.valueOf(segment) + "00.0";
            valueMax = String.valueOf(segment) + "59.999";
        }
        if (segment.length() == 18) {
            valueMin = String.valueOf(segment) + "0.0";
            valueMax = String.valueOf(segment) + "9.999";
        }
        if (segment.length() == 19) {
            valueMin = String.valueOf(segment) + ".0";
            valueMax = String.valueOf(segment) + ".999";
        }
        if (segment.length() == 20) {
            valueMin = String.valueOf(segment) + "0";
            valueMax = String.valueOf(segment) + "999";
        }
        if (segment.length() == 21) {
            valueMin = segment;
            valueMax = String.valueOf(segment) + "99";
        }
        if (segment.length() == 22) {
            valueMin = segment;
            valueMax = String.valueOf(segment) + "9";
        }
        if (segment.length() == 23) {
            valueMin = segment;
            valueMax = segment;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        format.setLenient(false);
        try {
            format.parse(valueMin);
            format.parse(valueMax);
            if (operandType.equals("GENERIC")) {
                bf.append(" BETWEEN '");
                bf.append(valueMin);
                bf.append("' AND '");
                bf.append(valueMax);
                bf.append("'");
            }
            if (operandType.equals("GE")) {
                bf.append(" >= '");
                bf.append(valueMin);
                bf.append("'");
            }
            if (operandType.equals("GT")) {
                bf.append(" > '");
                bf.append(valueMax);
                bf.append("'");
            }
            if (operandType.equals("LE")) {
                bf.append(" <= '");
                bf.append(valueMax);
                bf.append("'");
            }
            if (operandType.equals("LT")) {
                bf.append(" < '");
                bf.append(valueMin);
                bf.append("'");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return bf.toString();
    }

    static String getLastDateOfFebruary(String year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(year));
        cal.set(2, 1);
        cal.set(5, 1);
        int date = cal.getActualMaximum(5);
        return Integer.toString(date);
    }

    public static String getStringValueOfDateTime() {
        String monthStr = "";
        String dayStr = "";
        String underbar = "";
        String hourStr = "";
        String minStr = "";
        String secStr = "";
        String returnValue = "";
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        monthStr = month < 10 ? "0" + Integer.toString(month) : Integer.toString(month);
        int day = calendar.get(5);
        dayStr = day < 10 ? "0" + Integer.toString(day) : Integer.toString(day);
        int hour = calendar.get(11);
        hourStr = hour < 10 ? "0" + Integer.toString(hour) : Integer.toString(hour);
        int minute = calendar.get(12);
        minStr = minute < 10 ? "0" + Integer.toString(minute) : Integer.toString(minute);
        int second = calendar.get(13);
        secStr = second < 10 ? "0" + Integer.toString(second) : Integer.toString(second);
        returnValue = String.valueOf(Integer.toString(year)) + monthStr + dayStr + underbar + hourStr + minStr + secStr;
        return returnValue;
    }

    static String getDayOfWeek(Calendar cal, String dateFormat) {
        String result = "";
        String language = dateFormat.substring(0, 2);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            if (language.equals("jp")) {
                result = "(\u65e5)";
            }
            if (language.equals("en")) {
                result = "Sun,";
            }
        }
        if (dayOfWeek == 2) {
            if (language.equals("jp")) {
                result = "(\u6708)";
            }
            if (language.equals("en")) {
                result = "Mon,";
            }
        }
        if (dayOfWeek == 3) {
            if (language.equals("jp")) {
                result = "(\u706b)";
            }
            if (language.equals("en")) {
                result = "Tue,";
            }
        }
        if (dayOfWeek == 4) {
            if (language.equals("jp")) {
                result = "(\u6c34)";
            }
            if (language.equals("en")) {
                result = "Wed,";
            }
        }
        if (dayOfWeek == 5) {
            if (language.equals("jp")) {
                result = "(\u6728)";
            }
            if (language.equals("en")) {
                result = "Thur,";
            }
        }
        if (dayOfWeek == 6) {
            if (language.equals("jp")) {
                result = "(\u91d1)";
            }
            if (language.equals("en")) {
                result = "Fri,";
            }
        }
        if (dayOfWeek == 7) {
            if (language.equals("jp")) {
                result = "(\u571f)";
            }
            if (language.equals("en")) {
                result = "Sat,";
            }
        }
        return result;
    }

    static java.util.Date convertDateFromStringToUtil(String strDate) {
        java.util.Date utilDate = null;
        int year = 0;
        int month = -1;
        int date = 0;
        Calendar cal = Calendar.getInstance();
        if (strDate != null) {
            try {
                int pos1 = strDate.indexOf("-");
                if (pos1 > 0) {
                    year = Integer.parseInt(strDate.substring(0, pos1));
                    int pos2 = strDate.indexOf("-", pos1 + 1);
                    if (pos2 >= 0) {
                        month = Integer.parseInt(strDate.substring(pos1 + 1, pos2)) - 1;
                        date = Integer.parseInt(strDate.substring(pos2 + 1, pos2 + 3));
                    }
                } else {
                    pos1 = strDate.indexOf("/");
                    if (pos1 > 0) {
                        year = Integer.parseInt(strDate.substring(0, pos1));
                        int pos2 = strDate.indexOf("/", pos1 + 1);
                        if (pos2 >= 0) {
                            month = Integer.parseInt(strDate.substring(pos1 + 1, pos2)) - 1;
                            date = Integer.parseInt(strDate.substring(pos2 + 1, pos2 + 3));
                            cal.set(year, month, date);
                            utilDate = cal.getTime();
                        }
                    } else if (strDate.length() == 8) {
                        year = Integer.parseInt(strDate.substring(0, 4));
                        month = Integer.parseInt(strDate.substring(4, 6)) - 1;
                        date = Integer.parseInt(strDate.substring(6, 8));
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (year > 0 && month > -1 && date > 0) {
                cal.set(year, month, date);
                utilDate = cal.getTime();
            }
        }
        return utilDate;
    }

    static java.util.Date convertDateFromSqlToUtil(Date sqlDate) {
        java.util.Date utilDate = null;
        if (sqlDate != null) {
            utilDate = new java.util.Date();
            long longTime = sqlDate.getTime();
            utilDate.setTime(longTime);
        }
        return utilDate;
    }

    static Date convertDateFromUtilToSql(java.util.Date utilDate) {
        Date sqlDate = null;
        if (utilDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(utilDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            sqlDate = new Date(cal.getTimeInMillis());
        }
        return sqlDate;
    }

    static String convertDateFromUtilToString(java.util.Date utilDate) {
        String strDate = "";
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
        if (utilDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(utilDate);
            strDate = yyyyMMdd.format(cal.getTime());
        }
        return strDate;
    }

    public static Color convertStringToColor(String color) {
        Color colorConverted = Color.black;
        if (color.equals("black")) {
            colorConverted = Color.black;
        }
        if (color.equals("red")) {
            colorConverted = Color.red;
        }
        if (color.equals("blue")) {
            colorConverted = Color.blue;
        }
        if (color.equals("green")) {
            colorConverted = Color.green.darker();
        }
        if (color.equals("orange")) {
            colorConverted = Color.orange.darker();
        }
        if (color.equals("magenta")) {
            colorConverted = Color.magenta;
        }
        return colorConverted;
    }

    public static String convertColorToString(Color color) {
        String colorConverted = "black";
        if (color.equals(Color.black)) {
            colorConverted = "black";
        }
        if (color.equals(Color.red)) {
            colorConverted = "red";
        }
        if (color.equals(Color.blue)) {
            colorConverted = "blue";
        }
        if (color.equals(Color.green.darker())) {
            colorConverted = "green";
        }
        if (color.equals(Color.orange.darker())) {
            colorConverted = "orange";
        }
        if (color.equals(Color.magenta)) {
            colorConverted = "magenta";
        }
        return colorConverted;
    }

    public static SortableDomElementListModel getSortedListModel(NodeList list, String attName) {
        SortableDomElementListModel sortableDomElementListModel = new SortableDomElementListModel(attName);
        int i = 0;
        while (i < list.getLength()) {
            sortableDomElementListModel.addElement(list.item(i));
            ++i;
        }
        sortableDomElementListModel.sortElements();
        return sortableDomElementListModel;
    }

    static void setCaptionToButton(JButton button, Element element, String buttonText, int buttonWidth, Session session) {
        int pos1;
        StringBuffer bf = new StringBuffer();
        bf.append("F");
        bf.append(element.getAttribute("Number"));
        bf.append(" ");
        if (buttonText.equals("")) {
            bf.append(element.getAttribute("Caption"));
        } else {
            bf.append(buttonText);
        }
        button.setText(bf.toString());
        button.setToolTipText(bf.toString());
        if (element.getAttribute("Action").contains("CALL") && (pos1 = element.getAttribute("Action").indexOf("CALL(")) >= 0) {
            String functionName;
            int pos2 = element.getAttribute("Action").indexOf(")", pos1);
            String callAction = element.getAttribute("Action").substring(pos1 + 5, pos2);
            StringTokenizer workTokenizer1 = new StringTokenizer(callAction, ",");
            String functionID = "";
            if (workTokenizer1.countTokens() >= 1) {
                functionID = workTokenizer1.nextToken();
            }
            if ((functionName = session.getFunctionName(functionID)).equals("")) {
                button.setToolTipText(String.valueOf(functionID) + " N/A");
            } else {
                button.setToolTipText(String.valueOf(functionID) + " " + functionName);
            }
        }
        int i = 18;
        while (i > 8) {
            JButton dummy = new JButton(bf.toString());
            dummy.setFont(new Font(button.getFont().getFontName(), 0, i));
            if (dummy.getPreferredSize().width <= buttonWidth - 2) {
                button.setFont(new Font(button.getFont().getFontName(), 0, i));
                break;
            }
            --i;
        }
    }

    public static void appendLog(String text, StringBuffer logBuf) {
        if (logBuf != null) {
            String wrkStr = logBuf.toString();
            if (!text.startsWith("select") || !wrkStr.contains(text)) {
                StringBuffer buf = new StringBuffer();
                buf.append("> ");
                buf.append(text);
                buf.append("  (");
                buf.append(TIME_FORMATTER.format(Calendar.getInstance().getTime()));
                buf.append(")\n");
                logBuf.append(buf.toString());
            }
        }
    }

    static KeyStroke getKeyStroke(String functionNumber) {
        KeyStroke keyStroke = null;
        if (functionNumber.equals("2")) {
            keyStroke = KeyStroke.getKeyStroke(113, 0);
        }
        if (functionNumber.equals("3")) {
            keyStroke = KeyStroke.getKeyStroke(114, 0);
        }
        if (functionNumber.equals("4")) {
            keyStroke = KeyStroke.getKeyStroke(115, 0);
        }
        if (functionNumber.equals("5")) {
            keyStroke = KeyStroke.getKeyStroke(116, 0);
        }
        if (functionNumber.equals("6")) {
            keyStroke = KeyStroke.getKeyStroke(117, 0);
        }
        if (functionNumber.equals("7")) {
            keyStroke = KeyStroke.getKeyStroke(118, 0);
        }
        if (functionNumber.equals("8")) {
            keyStroke = KeyStroke.getKeyStroke(119, 0);
        }
        if (functionNumber.equals("9")) {
            keyStroke = KeyStroke.getKeyStroke(120, 0);
        }
        if (functionNumber.equals("10")) {
            keyStroke = KeyStroke.getKeyStroke(121, 0);
        }
        if (functionNumber.equals("11")) {
            keyStroke = KeyStroke.getKeyStroke(122, 0);
        }
        if (functionNumber.equals("12")) {
            keyStroke = KeyStroke.getKeyStroke(123, 0);
        }
        return keyStroke;
    }

    static String getMessageOfReturnCode(String code) {
        String message = "";
        if (code.equals("00")) {
            message = RESOURCE.getString("ReturnMessage00");
        }
        if (code.equals("01")) {
            message = RESOURCE.getString("ReturnMessage01");
        }
        if (code.equals("10")) {
            message = RESOURCE.getString("ReturnMessage10");
        }
        if (code.equals("11")) {
            message = RESOURCE.getString("ReturnMessage11");
        }
        if (code.equals("20")) {
            message = RESOURCE.getString("ReturnMessage20");
        }
        if (code.equals("21")) {
            message = RESOURCE.getString("ReturnMessage21");
        }
        if (code.equals("30")) {
            message = RESOURCE.getString("ReturnMessage30");
        }
        if (code.equals("99")) {
            message = RESOURCE.getString("ReturnMessage99");
        }
        return message;
    }
}

