/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.ucanaccess.commands.AbstractCursorCommand;
import net.ucanaccess.commands.CompositeCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.UcanaccessConnection;

public class AutoNumberAction
implements IFeedbackAction {
    private HashMap<String, Object> newAutoValues = new HashMap();
    private HashMap<String, Object> oldAutoValues = new HashMap();
    private Table table;

    public AutoNumberAction(Table table, Object[] memento, Object[] byAccess) throws SQLException {
        this.table = table;
        int i = 0;
        Statement ps = null;
        for (Column cl : table.getColumns()) {
            if (cl.isAutoNumber()) {
                UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
                Connection connHsqldb = conn.getHSQLDBConnection();
                String cn = SQLConverter.escapeIdentifier(cl.getName(), connHsqldb);
                Object cnOld = memento[i];
                Object cnNew = byAccess[i];
                if (cnNew instanceof String) {
                    cnNew = ((String)cnNew).toUpperCase();
                }
                this.oldAutoValues.put(cl.getName(), cnOld);
                this.newAutoValues.put(cl.getName(), cnNew);
                try {
                    conn.setFeedbackState(true);
                    String stmt = "UPDATE " + SQLConverter.escapeIdentifier(table.getName(), connHsqldb) + " SET " + cn + "=? WHERE " + cn + "=?";
                    ps = connHsqldb.prepareStatement(stmt);
                    ps.setObject(1, cnNew);
                    ps.setObject(2, cnOld);
                    ps.executeUpdate();
                    conn.setGeneratedKey(cnNew);
                    conn.setFeedbackState(false);
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void doAction(ICommand toChange) throws SQLException {
        if (!this.table.getName().equalsIgnoreCase(toChange.getTableName())) {
            return;
        }
        switch (toChange.getType()) {
            case DELETE: 
            case UPDATE: {
                AbstractCursorCommand acm = (AbstractCursorCommand)toChange;
                Map<String, Object> old = acm.getRowPattern();
                for (Map.Entry<String, Object> entry : this.oldAutoValues.entrySet()) {
                    if (!old.containsKey(entry.getKey()) || !old.get(entry.getKey()).equals(entry.getValue())) continue;
                    old.put(entry.getKey(), this.newAutoValues.get(entry.getKey()));
                }
                break;
            }
            case COMPOSITE: {
                CompositeCommand cc = (CompositeCommand)toChange;
                for (ICommand iCommand : cc.getComposite()) {
                    this.doAction(iCommand);
                }
                break;
            }
        }
    }
}

