/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Metadata {
    private Connection conn;
    private static final String SCHEMA = "CREATE SCHEMA UCA_METADATA AUTHORIZATION DBA";
    private static final String TABLES = "CREATE  TABLE UCA_METADATA.TABLES(TABLE_ID INTEGER IDENTITY, TABLE_NAME LONGVARCHAR,ESCAPED_TABLE_NAME LONGVARCHAR, TYPE VARCHAR(5),UNIQUE(TABLE_NAME)) ";
    private static final String COLUMNS = "CREATE MEMORY TABLE    \t\t\t\tUCA_METADATA.COLUMNS(COLUMN_ID INTEGER IDENTITY, COLUMN_NAME LONGVARCHAR,ESCAPED_COLUMN_NAME LONGVARCHAR, \t\t\t\tORIGINAL_TYPE VARCHAR(20),COLUMN_DEF  LONGVARCHAR,IS_GENERATEDCOLUMN VARCHAR(3),TABLE_ID INTEGER, UNIQUE(TABLE_ID,COLUMN_NAME) )";
    private static final String PROP = "CREATE MEMORY TABLE   UCA_METADATA.PROP(NAME LONGVARCHAR PRIMARY KEY, MAX_LEN INTEGER,DEFAULT_VALUE VARCHAR(20),DESCRIPTION LONGVARCHAR) ";
    public static final String SYSTEM_SUBQUERY = "SYSTEM_SUBQUERY";
    private static final Object[][] PROP_DATA;
    private static final String COLUMNS_VIEW = "CREATE VIEW   UCA_METADATA.COLUMNS_VIEW as SELECT t.TABLE_NAME, c.COLUMN_NAME,t.ESCAPED_TABLE_NAME, c.ESCAPED_COLUMN_NAME,c.COLUMN_DEF,c.IS_GENERATEDCOLUMN,CASE WHEN(c.ORIGINAL_TYPE \tIN ('COUNTER' ,'GUID')) THEN 'YES' ELSE 'NO' END as IS_AUTOINCREMENT,c.ORIGINAL_TYPE FROM UCA_METADATA.COLUMNS c INNER JOIN UCA_METADATA.TABLES t ON (t.TABLE_ID=c.TABLE_ID)";
    private static final String FK = "ALTER TABLE UCA_METADATA.COLUMNS   ADD CONSTRAINT UCA_METADATA_FK FOREIGN KEY (TABLE_ID) REFERENCES UCA_METADATA.TABLES (TABLE_ID) ON DELETE CASCADE";
    private static final String TABLE_RECORD = "INSERT INTO UCA_METADATA.TABLES( TABLE_NAME,ESCAPED_TABLE_NAME, TYPE) VALUES(?,?,?)";
    private static final String COLUMN_RECORD = "INSERT INTO UCA_METADATA.COLUMNS(COLUMN_NAME,ESCAPED_COLUMN_NAME,ORIGINAL_TYPE, IS_GENERATEDCOLUMN,TABLE_ID) VALUES(?,?,?,'NO',?)";
    private static final String SELECT_COLUMN = "SELECT DISTINCT c.COLUMN_NAME,c.ORIGINAL_TYPE IN('COUNTER','GUID') as IS_AUTOINCREMENT, c.ORIGINAL_TYPE='MONEY' as IS_CURRENCY  \t\t\t\tFROM UCA_METADATA.COLUMNS  c INNER JOIN UCA_METADATA.TABLES  t \t\t\t\tON(t.TABLE_ID=c.TABLE_ID ) WHERE t.ESCAPED_TABLE_NAME=nvl(?,t.ESCAPED_TABLE_NAME) AND c.ESCAPED_COLUMN_NAME=? ";
    private static final String SELECT_COLUMN_ESCAPED = "SELECT c.ESCAPED_COLUMN_NAME\t\t\t\tFROM UCA_METADATA.COLUMNS  c INNER JOIN UCA_METADATA.TABLES  t \t\t\t\tON(t.TABLE_ID=c.TABLE_ID ) WHERE t.TABLE_NAME=nvl(?,t.TABLE_NAME) AND c.COLUMN_NAME=? ";
    private static final String SELECT_TABLE_METADATA = "SELECT TABLE_ID, TABLE_NAME FROM UCA_METADATA.TABLES WHERE ESCAPED_TABLE_NAME=? ";
    private static final String DROP_TABLE = "DELETE FROM UCA_METADATA.TABLES WHERE TABLE_NAME=?";
    private static final String UPDATE_COLUMN_DEF = "UPDATE UCA_METADATA.COLUMNS c SET c.COLUMN_DEF=? WHERE COLUMN_NAME=?  AND EXISTS(SELECT * FROM UCA_METADATA.TABLES t WHERE t.TABLE_NAME=? AND t.TABLE_ID=c.TABLE_ID) ";
    private static final String UPDATE_IS_GENERATEDCOLUMN = "UPDATE UCA_METADATA.COLUMNS c SET c.IS_GENERATEDCOLUMN='YES' WHERE COLUMN_NAME=?  AND EXISTS(SELECT * FROM UCA_METADATA.TABLES t WHERE t.TABLE_NAME=? AND t.TABLE_ID=c.TABLE_ID) ";
    private static final String SELECT_COLUMNS = "SELECT DISTINCT c.COLUMN_NAME,c.ORIGINAL_TYPE IN('COUNTER','GUID') as IS_AUTOINCREMENT, c.ORIGINAL_TYPE='MONEY' as IS_CURRENCY  \t\t\t\tFROM UCA_METADATA.COLUMNS  c INNER JOIN UCA_METADATA.TABLES  t \t\t\t\tON(t.TABLE_ID=c.TABLE_ID ) WHERE t.ESCAPED_TABLE_NAME=nvl(?,t.ESCAPED_TABLE_NAME) ";

    static {
        Object[][] objectArrayArray = new Object[20][];
        Object[] objectArray = new Object[4];
        objectArray[0] = "newdatabaseversion";
        objectArray[1] = 8;
        objectArray[3] = "see ucanaccess website";
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = "jackcessopener";
        objectArray2[1] = 500;
        objectArray2[3] = "see ucanaccess web site";
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[4];
        objectArray3[0] = "password";
        objectArray3[1] = 500;
        objectArray3[3] = "see ucanaccess web site";
        objectArrayArray[2] = objectArray3;
        objectArrayArray[3] = new Object[]{"memory", 10, "true", "see ucanaccess web site"};
        objectArrayArray[4] = new Object[]{"lobscale", 2, "2", "see ucanaccess web site"};
        objectArrayArray[5] = new Object[]{"keepmirror", 500, "2", "see ucanaccess web site"};
        objectArrayArray[6] = new Object[]{"showschema", 10, "false", "see ucanaccess web site"};
        objectArrayArray[7] = new Object[]{"inactivitytimeout", 10, "2", "see ucanaccess web site"};
        objectArrayArray[8] = new Object[]{"singleconnection", 10, "false", "see ucanaccess web site"};
        objectArrayArray[9] = new Object[]{"immediatelyreleaseresources", 10, "false", "see ucanaccess web site"};
        objectArrayArray[10] = new Object[]{"lockmdb", 10, "false", "see ucanaccess web site"};
        objectArrayArray[11] = new Object[]{"openexclusive", 500, "false", "see ucanaccess web site"};
        Object[] objectArray4 = new Object[4];
        objectArray4[0] = "remap";
        objectArray4[1] = 500;
        objectArray4[3] = "see ucanaccess web site";
        objectArrayArray[12] = objectArray4;
        objectArrayArray[13] = new Object[]{"columnorder", 10, "data", "see ucanaccess web site"};
        Object[] objectArray5 = new Object[4];
        objectArray5[0] = "mirrorfolder";
        objectArray5[1] = 500;
        objectArray5[3] = "see ucanaccess web site";
        objectArrayArray[14] = objectArray5;
        objectArrayArray[15] = new Object[]{"ignorecase", 10, "true", "see ucanaccess web site"};
        objectArrayArray[16] = new Object[]{"sysschema", 10, "false", "see ucanaccess web site"};
        objectArrayArray[17] = new Object[]{"skipindexes", 10, "false", "see ucanaccess web site"};
        objectArrayArray[18] = new Object[]{"preventreloading", 10, "false", "see ucanaccess web site"};
        objectArrayArray[19] = new Object[]{"concatnulls", 10, "false", "see ucanaccess web site"};
        PROP_DATA = objectArrayArray;
    }

    public Metadata(Connection conn) throws SQLException {
        this.conn = conn;
    }

    public void createMetadata() throws SQLException {
        Statement st = null;
        try {
            st = this.conn.createStatement();
            st.execute(SCHEMA);
            st.execute(PROP);
            st.execute(TABLES);
            st.execute(COLUMNS);
            st.execute(FK);
            st.execute(COLUMNS_VIEW);
            this.loadProp();
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void loadProp() throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("INSERT INTO UCA_METADATA.PROP( NAME , MAX_LEN , DEFAULT_VALUE , DESCRIPTION) VALUES(?,?,?,?)");
            Object[][] objectArray = PROP_DATA;
            int n = PROP_DATA.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] ob = objectArray[n2];
                ps.setObject(1, ob[0]);
                ps.setObject(2, ob[1]);
                ps.setObject(3, ob[2]);
                ps.setObject(4, ob[3]);
                ps.execute();
                ++n2;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public Integer newTable(String name, String escaped, Types type) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(TABLE_RECORD, 1);
            ps.setString(1, name);
            ps.setString(2, escaped);
            ps.setString(3, type.name());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            Integer n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            Integer n = this.getTableId(escaped);
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void newColumn(String name, String escaped, String originalType, Integer idTable) throws SQLException {
        if (idTable < 0) {
            return;
        }
        PreparedStatement ps = null;
        try {
            try {
                ps = this.conn.prepareStatement(COLUMN_RECORD);
                ps.setString(1, name);
                ps.setString(2, escaped);
                ps.setString(3, originalType);
                ps.setInt(4, idTable);
                ps.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public ArrayList<String> getColumnNames(String tableName) throws SQLException {
        Statement ps = null;
        try {
            boolean camb = SYSTEM_SUBQUERY.equals(tableName);
            tableName = camb ? null : tableName;
            ps = this.conn.prepareStatement(SELECT_COLUMNS);
            ps.setString(1, tableName);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
            if (!camb) {
                ArrayList<String> arrayList = result;
                return arrayList;
            }
            return null;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String getColumnName(String tableName, String columnName) throws SQLException {
        Statement ps = null;
        try {
            boolean camb = SYSTEM_SUBQUERY.equals(tableName);
            tableName = camb ? null : tableName;
            ps = this.conn.prepareStatement(SELECT_COLUMN);
            ps.setString(1, tableName);
            ps.setString(2, columnName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String res = rs.getString("COLUMN_NAME");
                if (!camb || !rs.next()) {
                    String string = res;
                    return string;
                }
            }
            return null;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String getEscapedColumnName(String tableName, String columnName) throws SQLException {
        Statement ps = null;
        try {
            tableName = SYSTEM_SUBQUERY.equals(tableName) ? null : tableName;
            ps = this.conn.prepareStatement(SELECT_COLUMN_ESCAPED);
            ps.setString(1, tableName);
            ps.setString(2, columnName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("ESCAPED_COLUMN_NAME");
                return string;
            }
            return null;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean isAutoIncrement(String tableName, String columnName) throws SQLException {
        PreparedStatement ps = null;
        tableName = SYSTEM_SUBQUERY.equals(tableName) ? null : tableName;
        try {
            ps = this.conn.prepareStatement(SELECT_COLUMN);
            ps.setString(1, tableName);
            ps.setString(2, columnName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getBoolean("IS_AUTOINCREMENT");
                return bl;
            }
            return false;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean isCurrency(String tableName, String columnName) throws SQLException {
        PreparedStatement ps = null;
        tableName = SYSTEM_SUBQUERY.equals(tableName) ? null : tableName;
        try {
            ps = this.conn.prepareStatement(SELECT_COLUMN);
            ps.setString(1, tableName);
            ps.setString(2, columnName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getBoolean("IS_CURRENCY");
                return bl;
            }
            return false;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public Integer getTableId(String escapedName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(SELECT_TABLE_METADATA);
            ps.setString(1, escapedName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Integer n = rs.getInt("TABLE_ID");
                return n;
            }
            Integer n = -1;
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String getTableName(String escapedName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(SELECT_TABLE_METADATA);
            ps.setString(1, escapedName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("TABLE_NAME");
                return string;
            }
            return null;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void dropTable(String tableName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(DROP_TABLE);
            ps.setString(1, tableName);
            ps.execute();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void columnDef(String tableName, String columnName, String def) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(UPDATE_COLUMN_DEF);
            ps.setString(1, def);
            ps.setString(2, columnName);
            ps.setString(3, tableName);
            ps.execute();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void calculatedField(String tableName, String columnName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(UPDATE_IS_GENERATEDCOLUMN);
            ps.setString(1, columnName);
            ps.setString(2, tableName);
            ps.execute();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static enum Types {
        VIEW,
        TABLE;

    }
}

