/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.impl.query.AppendQueryImpl;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.ucanaccess.converters.AppendQueryTemp;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;

public class ParametricQuery {
    private Connection hsqldb;
    private QueryImpl qi;
    private boolean loaded;
    private PreparedStatement ps;
    private String parameters;
    private String defaultParameterValues;
    private boolean conversionOk;
    private boolean issueWithParameterName;
    private HashMap<String, String> aposMap;
    private List<String> parameterList;
    private Exception e;
    private boolean isProcedure;
    private String sqlContent;
    private String signature;
    private StringBuffer originalParameters = new StringBuffer();

    public ParametricQuery(Connection hsqldb, QueryImpl qi) throws SQLException {
        this.hsqldb = hsqldb;
        this.qi = qi.getType() == Query.Type.APPEND ? new AppendQueryTemp((AppendQueryImpl)qi) : qi;
    }

    public boolean isIssueWithParameterName() {
        return this.issueWithParameterName;
    }

    public void setIssueWithParameterName(boolean issueWithParameterName) {
        this.issueWithParameterName = issueWithParameterName;
    }

    private List<String> queryParameters() {
        List l = this.qi.getParameters();
        if (this.aposMap != null) {
            return this.parameterList;
        }
        this.aposMap = new HashMap();
        int i = 0;
        this.parameterList = new ArrayList<String>();
        this.parameterList.addAll(l);
        for (String par : this.parameterList) {
            if (par.indexOf("'") >= 0 || par.indexOf("\"") >= 0) {
                int index = Math.max(Math.max(par.lastIndexOf(32), par.lastIndexOf(10)), par.lastIndexOf(13));
                String decl = par.substring(0, index).trim();
                if (decl.startsWith("[")) {
                    decl = decl.substring(1, decl.length() - 1);
                }
                String h = this.treatApos(decl);
                this.aposMap.put(h, decl);
                this.parameterList.set(i, this.treatApos(par));
            }
            ++i;
        }
        return this.parameterList;
    }

    public void createProcedure() throws SQLException {
        this.isProcedure = true;
        String sql = null;
        try {
            String procedureName;
            String procedure;
            List<String> l = this.queryParameters();
            sql = this.getSQL();
            if (l == null || l.size() == 0) {
                this.parametersEmpiric();
            } else {
                sql = SQLConverter.removeParameters(sql);
                this.parametersDeclared();
                if (!this.conversionOk) {
                    this.parametersEmpiric(true);
                }
            }
            if (!this.conversionOk) {
                return;
            }
            this.e = null;
            String inside = this.convertSQL(this.convertApos(sql)).trim();
            if (!inside.endsWith(";")) {
                inside = String.valueOf(inside) + ";";
            }
            if (this.exec(procedure = "CREATE PROCEDURE " + (procedureName = SQLConverter.escapeIdentifier(this.qi.getName(), this.hsqldb)) + "(" + this.parameters + ") MODIFIES SQL DATA \n" + " BEGIN ATOMIC " + inside + "\n END")) {
                this.signature = String.valueOf(this.qi.getName()) + "(" + this.originalParameters + ")";
                this.loaded = true;
            }
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    public void createSelect() throws SQLException {
        String qnn = null;
        String sql = null;
        try {
            String funName;
            String function;
            List<String> l = this.queryParameters();
            qnn = SQLConverter.escapeIdentifier(this.qi.getName(), this.hsqldb);
            sql = this.getSQL();
            if (l == null || l.size() == 0) {
                this.parametersEmpiric();
            } else {
                sql = SQLConverter.removeParameters(sql);
                this.parametersDeclared();
                if (!this.conversionOk) {
                    this.parametersEmpiric();
                }
            }
            if (!this.conversionOk) {
                return;
            }
            this.e = null;
            String inside = this.convertSQL(this.convertApos(sql)).trim();
            if (inside.endsWith(";")) {
                inside = inside.substring(0, inside.length() - 1);
            }
            if (!this.exec(function = "CREATE FUNCTION " + (funName = qnn) + "(" + this.parameters + ") RETURNS " + "TABLE (" + this.getTableDefinition() + ") READS SQL DATA \n" + " RETURN (TABLE(" + inside + "));")) {
                return;
            }
            String createView = "CREATE VIEW " + qnn + " AS SELECT * FROM TABLE(" + funName + "(" + this.defaultParameterValues + "))";
            if (!this.exec(createView)) {
                return;
            }
            this.loaded = true;
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private String convertApos(String sql) {
        if (this.aposMap != null) {
            for (Map.Entry<String, String> me : this.aposMap.entrySet()) {
                sql = sql.replaceAll("(?i)" + Pattern.quote("[" + me.getValue() + "]"), "[" + me.getKey() + "]");
            }
        }
        return sql;
    }

    private String getTableDefinition() throws SQLException {
        ResultSet rs = this.ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        StringBuffer sb = new StringBuffer();
        String comma = "";
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            String type = this.completeTypeName(rsmd.getColumnTypeName(i), rsmd.getPrecision(i), rsmd.getScale(i), false);
            sb.append(comma).append(SQLConverter.escapeIdentifier(rsmd.getColumnLabel(i), this.hsqldb)).append(" ").append(type);
            comma = ",";
            ++i;
        }
        return sb.toString();
    }

    private String completeTypeName(String type, int i, int j, boolean useDefault) {
        if ("VARCHAR".equals(type)) {
            type = String.valueOf(type) + "(" + i + ")";
        }
        if ("NUMERIC".equals(type)) {
            type = useDefault ? String.valueOf(type) + "(100,10)" : String.valueOf(type) + "(" + i + "," + j + ")";
        }
        return type;
    }

    private String treatApos(String s) {
        s = s.replaceAll("'", "").replaceAll("\"", "").toUpperCase();
        return s;
    }

    private boolean exec(String expression) throws SQLException {
        Statement st = null;
        try {
            st = this.hsqldb.createStatement();
            st.execute(expression);
            return true;
        }
        catch (SQLException e) {
            this.e = e;
            return false;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private String getSQL() {
        if (this.sqlContent == null) {
            this.sqlContent = ParametricQuery.transalteFormFields(this.qi.toSQLString());
        }
        return this.sqlContent;
    }

    private static String transalteFormFields(String sqlString) {
        return sqlString.replaceAll("\\[([^\\]]*)\\]\\!\\[([^\\]]*)\\]\\!\\[([^\\]]*)\\]", "[$1_$2_$3]").replaceAll("\\[(\\w*)\\]\\!\\[(\\w*)\\]\\!\\[(\\w*)\\]", "[$1_$2_$3]").replaceAll("((?i)FORMS)\\.(\\w*)\\.(\\w*)", "[$1_$2_$3]");
    }

    private void parametersEmpiric() {
        this.parametersEmpiric(false);
    }

    private void parametersEmpiric(boolean partialParDecl) {
        this.aposMap = new HashMap();
        LinkedHashMap<String, Integer> hm = new LinkedHashMap<String, Integer>();
        String s = this.getSQL();
        if (partialParDecl) {
            s = SQLConverter.removeParameters(s);
        }
        List<String> parameters = SQLConverter.getParameters(s);
        this.getParametersEmpiric(hm, parameters, s, true);
    }

    public Exception getException() {
        return this.e;
    }

    private void parametersDeclared() {
        List<String> ls = this.queryParameters();
        StringBuffer args = new StringBuffer();
        String comma = "";
        ArrayList<String> ar = new ArrayList<String>();
        for (String par : ls) {
            par = par.trim();
            int index = Math.max(Math.max(par.lastIndexOf(32), par.lastIndexOf(10)), par.lastIndexOf(13));
            String decl = par.substring(0, index).trim();
            String type = par.substring(index).trim();
            if (!decl.startsWith("[")) {
                decl = "[" + decl + "]";
            }
            ar.add(decl);
            String type0 = type.indexOf("(") > 0 ? type.substring(0, type.indexOf("(")) : type;
            String typeS = type.indexOf("(") > 0 ? type.substring(type.indexOf("(")) : "";
            HashMap<String, String> hm = TypesMap.getAccess2HsqlTypesMap();
            type = String.valueOf(hm.get(type0.toUpperCase())) + typeS;
            if (type.equalsIgnoreCase("VARCHAR")) {
                type = String.valueOf(type) + "(255)";
            }
            args.append(comma).append(decl).append(" ").append(type);
            comma = ",";
        }
        String sql = this.getSQL();
        sql = this.convertApos(SQLConverter.removeParameters(sql));
        for (String var : ar) {
            sql = sql.replaceAll("(?i)" + Pattern.quote(var), "?");
        }
        try {
            this.ps = this.hsqldb.prepareStatement(this.convertSQL(sql));
            if (!this.isProcedure) {
                ParameterMetaData pmd = this.ps.getParameterMetaData();
                StringBuffer defPar = new StringBuffer();
                comma = "";
                int i = 1;
                while (i <= pmd.getParameterCount()) {
                    if (!this.isProcedure) {
                        this.ps.setNull(i, pmd.getParameterType(i));
                    }
                    defPar.append(comma).append("NULL");
                    comma = ",";
                    ++i;
                }
                this.defaultParameterValues = defPar.toString();
            }
            this.originalParameters = args;
            this.parameters = SQLConverter.convertSQL(args.toString()).getSql();
            this.conversionOk = true;
        }
        catch (SQLException e) {
            this.e = e;
        }
    }

    private ArrayList<Integer> parIndexes(String s) {
        ArrayList<Integer> ar = new ArrayList<Integer>();
        char character = '?';
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == character) {
                ar.add(i);
            }
            ++i;
        }
        return ar;
    }

    private String convertSQL(String sql) {
        String h = SQLConverter.convertSQL(sql, true).getSql();
        return h;
    }

    private String convertSQL(String sql, List<String> parameters2) {
        for (String s : parameters2) {
            if (s.indexOf("'") <= 0 && s.indexOf("\"") <= 0) continue;
            String src = Pattern.quote(s);
            String target = this.treatApos(s);
            sql = sql.replaceAll(src, target);
            this.aposMap.put(target.substring(1, target.length() - 1), s.substring(1, s.length() - 1));
        }
        return this.convertSQL(sql);
    }

    /*
     * Unable to fully structure code
     */
    private void getParametersEmpiric(LinkedHashMap<String, Integer> m, List<String> parameters, String sql, boolean init) {
        block10: {
            psTxt = null;
            try {
                psTxt = this.convertSQL(sql, parameters);
                l = SQLConverter.getParameters(psTxt);
                for (String s : l) {
                    h = this.treatApos(s);
                    for (String modf : parameters) {
                        if (!this.convertSQL(modf).equals(s) || this.aposMap.containsKey(h = this.treatApos(modf))) continue;
                        parameters.set(parameters.indexOf(modf), h);
                        psTxt = psTxt.replaceAll("(?i)" + Pattern.quote(s), this.convertSQL(h));
                        sql = sql.replaceAll("(?i)" + Pattern.quote(modf), h);
                        h = h.substring(1, h.length() - 1);
                        this.aposMap.put(h, modf.substring(1, modf.length() - 1));
                    }
                }
                this.ps = this.hsqldb.prepareStatement(psTxt);
                pmd = this.ps.getParameterMetaData();
                ar = new ArrayList<String>();
                ar.addAll(m.keySet());
                pI = this.parIndexes(sql);
                parS = new StringBuffer();
                defPar = new StringBuffer();
                j = 0;
                comma = "";
                i = 1;
                while (i <= pmd.getParameterCount()) {
                    if (!this.isProcedure) {
                        this.ps.setNull(i, pmd.getParameterType(i));
                    }
                    if (j <= ar.size() - 1 && (index = m.get(key = (String)ar.get(j)).intValue()) == pI.get(i - 1)) {
                        defPar.append(comma).append("NULL");
                        type = this.completeTypeName(pmd.getParameterTypeName(i), pmd.getPrecision(i), pmd.getScale(i), true);
                        parS.append(comma).append(SQLConverter.escapeIdentifier(key, this.hsqldb)).append(" ").append(type);
                        comma = ",";
                        ++j;
                    }
                    ++i;
                }
                this.parameters = parS.toString();
                this.defaultParameterValues = defPar.toString();
                this.conversionOk = true;
                break block10;
            }
            catch (SQLException e) {
                ** for (par : parameters)
            }
lbl-1000:
            // 1 sources

            {
                par1 = SQLConverter.preEscapingIdentifier(par.substring(1, par.length() - 1));
                index = sql.toUpperCase().indexOf(par.toUpperCase());
                if (index >= 0 && e.getMessage() != null && e.getMessage().toUpperCase().endsWith(": " + par1)) {
                    sql = sql.replaceAll("(?i)" + Pattern.quote(par), "?");
                    m.put(par1, index);
                    parname = this.originalParameters.length() == 0 ? par : "," + par;
                    this.originalParameters.append(parname);
                    this.getParametersEmpiric(m, parameters, sql, false);
                    continue;
                }
                this.e = e;
                continue;
            }
lbl61:
            // 1 sources

            if (this.e == null) {
                this.e = e;
            }
        }
    }

    public boolean loaded() {
        return this.loaded;
    }

    public String getSignature() {
        return this.signature;
    }
}

