/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import xeadEditor.Editor;

public class Application {
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    boolean packFrame = false;
    private JWindow splashScreen = new JWindow();
    private JLabel splashIcon = new JLabel();
    private JLabel splashText = new JLabel();
    private JProgressBar splashProgressBar = new JProgressBar();

    public Application(String[] args) {
        ImageIcon image = new ImageIcon(Application.class.getResource("splash.png"));
        this.splashIcon.setIcon(image);
        this.splashIcon.setLayout(null);
        this.splashProgressBar.setBounds(0, 291, 500, 9);
        this.splashScreen.add(this.splashProgressBar);
        this.splashText.setFont(new Font("Dialog", 0, 16));
        this.splashText.setOpaque(false);
        this.splashText.setBounds(280, 205, 220, 20);
        this.splashText.setText(res.getString("SplashMessage0"));
        this.splashScreen.add(this.splashText);
        this.splashScreen.getContentPane().add(this.splashIcon);
        this.splashScreen.pack();
        this.splashScreen.setLocationRelativeTo(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.showSplash();
            }
        });
        Editor frame = new Editor(args, this);
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setExtendedState(6);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Application(args);
    }

    public void showSplash() {
        this.splashScreen.setVisible(true);
    }

    public void setTextOnSplash(String text) {
        this.splashText.setText(text);
    }

    public void setProgressMax(int value) {
        this.splashProgressBar.setMaximum(value);
    }

    public void setProgressValue(int value) {
        this.splashProgressBar.setValue(value);
    }

    public void repaintProgress() {
        this.splashProgressBar.paintImmediately(0, 0, this.splashProgressBar.getWidth(), this.splashProgressBar.getHeight());
    }

    public boolean isSplashValid() {
        return this.splashScreen != null;
    }

    public void hideSplash() {
        if (this.splashScreen != null) {
            this.splashScreen.setVisible(false);
            this.splashScreen = null;
            this.splashText = null;
            this.splashIcon = null;
            this.splashProgressBar = null;
        }
    }
}

