/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogAddFieldToFunction_CheckBox;
import xeadEditor.DialogAddFieldToFunction_jButtonCancel_actionAdapter;
import xeadEditor.DialogAddFieldToFunction_jButtonOK_actionAdapter;
import xeadEditor.DialogAddFieldToFunction_jButtonSelectAll_actionAdapter;
import xeadEditor.DialogAddFieldToFunction_jListDataSource_mouseAdapter;
import xeadEditor.Editor;
import xeadEditor.Editor_CheckBoxListRenderer;

public class DialogAddFieldToFunction
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JPanel jPanelMain = new JPanel();
    private JButton jButtonOK = new JButton();
    private JButton jButtonSelectAll = new JButton();
    private JButton jButtonCancel = new JButton();
    private Editor frame_;
    private DefaultListModel<JCheckBox> listModelDataSource = new DefaultListModel();
    private JList<JCheckBox> jListDataSource = new JList<JCheckBox>(this.listModelDataSource);
    private JScrollPane jScrollPaneDataSourceList = new JScrollPane();
    private JPanel jPanelButtons = new JPanel();
    private Element objectElement_ = null;
    private String tableType_ = "";
    private Editor.SortableDomElementListModel sortingList;
    private ArrayList<String> tableIDList = new ArrayList();
    private ArrayList<String> tableAliasList = new ArrayList();
    private ArrayList<String> fieldIDList = new ArrayList();
    private ArrayList<String> fieldNameList = new ArrayList();
    private ArrayList<Boolean> isNumericList = new ArrayList();
    private ArrayList<Boolean> isKubunList = new ArrayList();
    private ArrayList<String> functionDataSourceList = new ArrayList();
    private int order = 0;
    private int result = 0;

    public DialogAddFieldToFunction(Editor frame) {
        super(frame, "", true);
        this.frame_ = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanelMain.setLayout(new BorderLayout());
        this.jListDataSource.setBorder(null);
        Editor_CheckBoxListRenderer renderer = new Editor_CheckBoxListRenderer(this.frame_);
        this.jListDataSource.setCellRenderer(renderer);
        this.jListDataSource.setBackground(this.jPanelMain.getBackground());
        this.jListDataSource.addMouseListener(new DialogAddFieldToFunction_jListDataSource_mouseAdapter(this));
        this.jScrollPaneDataSourceList.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPaneDataSourceList.getViewport().add(this.jListDataSource, null);
        this.jPanelMain.add((Component)this.jScrollPaneDataSourceList, "Center");
        this.jPanelButtons.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelButtons.setPreferredSize(new Dimension(350, 45));
        this.jButtonCancel.setBounds(new Rectangle(18, 10, 100, 27));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("Cancel"));
        this.jButtonCancel.addActionListener(new DialogAddFieldToFunction_jButtonCancel_actionAdapter(this));
        this.jButtonSelectAll.setBounds(new Rectangle(128, 10, 100, 27));
        this.jButtonSelectAll.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonSelectAll.setText(res.getString("SelectAll"));
        this.jButtonSelectAll.addActionListener(new DialogAddFieldToFunction_jButtonSelectAll_actionAdapter(this));
        this.jButtonOK.setBounds(new Rectangle(238, 10, 100, 27));
        this.jButtonOK.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonOK.setText(res.getString("Add"));
        this.jButtonOK.addActionListener(new DialogAddFieldToFunction_jButtonOK_actionAdapter(this));
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.add(this.jButtonCancel);
        this.jPanelButtons.add(this.jButtonSelectAll);
        this.jPanelButtons.add(this.jButtonOK);
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.setResizable(false);
        this.setPreferredSize(new Dimension(360, 450));
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelButtons.getRootPane().setDefaultButton(this.jButtonOK);
        this.pack();
    }

    public int request(Element objectElement, String tableType) {
        String dataType;
        Element wrkElement;
        NodeList functionFieldNodeList = null;
        NodeList functionFieldNodeList2 = null;
        String tableID = "";
        Element tableElement = null;
        this.objectElement_ = objectElement;
        this.tableType_ = tableType;
        this.result = 0;
        this.setTitle(res.getString("AddFields"));
        if (this.tableType_.equals("Function010FieldList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function100ColumnList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function100FilterList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function110ColumnList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function110FilterList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function110BatchFieldList")) {
            tableID = objectElement.getAttribute("BatchTable");
        }
        if (this.tableType_.equals("Function200FieldList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function200TabFieldList")) {
            wrkElement = (Element)objectElement.getParentNode();
            tableID = wrkElement.getAttribute("PrimaryTable");
            functionFieldNodeList2 = ((Element)objectElement.getParentNode()).getElementsByTagName("Field");
        }
        if (this.tableType_.equals("Function210FieldList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function290PhraseList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function300HeaderFieldList")) {
            tableID = objectElement.getAttribute("HeaderTable");
        }
        if (this.tableType_.equals("Function300DetailFieldList")) {
            tableID = objectElement.getAttribute("Table");
        }
        if (this.tableType_.equals("Function300DetailFilterList")) {
            tableID = objectElement.getAttribute("Table");
        }
        if (this.tableType_.equals("Function310HeaderFieldList")) {
            tableID = objectElement.getAttribute("HeaderTable");
        }
        if (this.tableType_.equals("Function310DetailFieldList")) {
            tableID = objectElement.getAttribute("DetailTable");
        }
        if (this.tableType_.equals("Function290PhraseList")) {
            tableID = objectElement.getAttribute("PrimaryTable");
        }
        if (this.tableType_.equals("Function390HeaderPhraseList")) {
            tableID = objectElement.getAttribute("HeaderTable");
        }
        if (this.tableType_.equals("Function390DetailFieldList")) {
            tableID = objectElement.getAttribute("Table");
        }
        functionFieldNodeList = this.tableType_.equals("Function200TabFieldList") ? ((Element)objectElement.getParentNode()).getElementsByTagName(this.frame_.getFieldTagNameAccordingComponentType(this.tableType_)) : objectElement.getElementsByTagName(this.frame_.getFieldTagNameAccordingComponentType(this.tableType_));
        this.tableIDList.clear();
        this.tableAliasList.clear();
        this.fieldIDList.clear();
        this.fieldNameList.clear();
        this.isNumericList.clear();
        this.isKubunList.clear();
        tableElement = this.frame_.getSpecificXETreeNode("Table", tableID).getElement();
        NodeList nodeList = tableElement.getElementsByTagName("Field");
        this.sortingList = this.frame_.getSortedListModel(nodeList, "Order");
        int i = 0;
        while (i < this.sortingList.getSize()) {
            wrkElement = (Element)this.sortingList.getElementAt(i);
            this.tableIDList.add(tableID);
            this.tableAliasList.add(tableID);
            this.fieldIDList.add(wrkElement.getAttribute("ID"));
            this.fieldNameList.add(wrkElement.getAttribute("Name"));
            dataType = this.frame_.getBasicTypeOf(wrkElement.getAttribute("Type"));
            if (dataType.equals("INTEGER") || dataType.equals("FLOAT")) {
                this.isNumericList.add(true);
            } else {
                this.isNumericList.add(false);
            }
            if (wrkElement.getAttribute("TypeOptions").contains("KUBUN(")) {
                this.isKubunList.add(true);
            } else {
                this.isKubunList.add(false);
            }
            ++i;
        }
        nodeList = tableElement.getElementsByTagName("Refer");
        this.sortingList = this.frame_.getSortedListModel(nodeList, "Order");
        i = 0;
        while (i < this.sortingList.getSize()) {
            wrkElement = (Element)this.sortingList.getElementAt(i);
            StringTokenizer workTokenizer = new StringTokenizer(wrkElement.getAttribute("Fields"), ";");
            while (workTokenizer.hasMoreTokens()) {
                String wrkStr = workTokenizer.nextToken();
                this.tableIDList.add(wrkElement.getAttribute("ToTable"));
                if (wrkElement.getAttribute("TableAlias").equals("")) {
                    this.tableAliasList.add(wrkElement.getAttribute("ToTable"));
                } else {
                    this.tableAliasList.add(wrkElement.getAttribute("TableAlias"));
                }
                this.fieldIDList.add(wrkStr);
                this.fieldNameList.add(this.frame_.getFieldNames(wrkElement.getAttribute("ToTable"), wrkStr, "", false));
                Element fieldElement = this.frame_.getSpecificFieldElement(wrkElement.getAttribute("ToTable"), wrkStr);
                dataType = this.frame_.getBasicTypeOf(fieldElement.getAttribute("Type"));
                if (dataType.equals("INTEGER") || dataType.equals("FLOAT")) {
                    this.isNumericList.add(true);
                } else {
                    this.isNumericList.add(false);
                }
                if (fieldElement.getAttribute("TypeOptions").contains("KUBUN(")) {
                    this.isKubunList.add(true);
                    continue;
                }
                this.isKubunList.add(false);
            }
            ++i;
        }
        this.functionDataSourceList.clear();
        if (this.tableType_.equals("Function010FieldList")) {
            this.sortingList = this.frame_.getSortedListModel(functionFieldNodeList, "DataSource");
            i = 0;
            while (i < this.sortingList.getSize()) {
                wrkElement = (Element)this.sortingList.getElementAt(i);
                this.functionDataSourceList.add(wrkElement.getAttribute("DataSource"));
                ++i;
            }
        } else if (this.tableType_.equals("Function200TabFieldList")) {
            this.sortingList = this.frame_.getSortedListModel(functionFieldNodeList, "DataSource");
            i = 0;
            while (i < this.sortingList.getSize()) {
                wrkElement = (Element)this.sortingList.getElementAt(i);
                this.functionDataSourceList.add(wrkElement.getAttribute("DataSource"));
                ++i;
            }
            this.sortingList = this.frame_.getSortedListModel(functionFieldNodeList2, "DataSource");
            i = 0;
            while (i < this.sortingList.getSize()) {
                wrkElement = (Element)this.sortingList.getElementAt(i);
                this.functionDataSourceList.add(wrkElement.getAttribute("DataSource"));
                ++i;
            }
        } else if (!(this.tableType_.equals("Function100FilterList") || this.tableType_.equals("Function110FilterList") || this.tableType_.equals("Function300DetailFilterList"))) {
            this.sortingList = this.frame_.getSortedListModel(functionFieldNodeList, "Order");
            i = 0;
            while (i < this.sortingList.getSize()) {
                wrkElement = (Element)this.sortingList.getElementAt(i);
                this.functionDataSourceList.add(wrkElement.getAttribute("DataSource"));
                ++i;
            }
        }
        this.listModelDataSource.clear();
        i = 0;
        while (i < this.fieldIDList.size()) {
            if (!this.functionDataSourceList.contains(String.valueOf(this.tableAliasList.get(i)) + "." + this.fieldIDList.get(i)) || !this.tableAliasList.get(i).equals(tableID)) {
                DialogAddFieldToFunction_CheckBox checkBox = new DialogAddFieldToFunction_CheckBox();
                checkBox.setFont(new Font("SansSerif", 0, 12));
                checkBox.setText(String.valueOf(this.tableAliasList.get(i)) + "." + this.fieldNameList.get(i));
                checkBox.setDataSourceName(String.valueOf(this.tableAliasList.get(i)) + "." + this.fieldIDList.get(i));
                checkBox.setNumeric(this.isNumericList.get(i));
                checkBox.setKubun(this.isKubunList.get(i));
                this.listModelDataSource.addElement(checkBox);
            }
            ++i;
        }
        if (this.listModelDataSource.getSize() > 0) {
            this.jButtonOK.setEnabled(false);
            Dimension dlgSize = this.getPreferredSize();
            Dimension frmSize = this.frame_.getSize();
            Point loc = this.frame_.getLocation();
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            super.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(null, res.getString("NoFieldsLeftToBeAdded"));
        }
        return this.result;
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        Element newElement = null;
        this.order = this.frame_.getOrderOfCurrentSelectedRow() + 1;
        boolean anySelected = false;
        int i = 0;
        while (i < this.listModelDataSource.getSize()) {
            DialogAddFieldToFunction_CheckBox checkBox = (DialogAddFieldToFunction_CheckBox)this.listModelDataSource.getElementAt(i);
            if (checkBox.isSelected()) {
                anySelected = true;
                newElement = this.frame_.getDomDocument().createElement(this.frame_.getFieldTagNameAccordingComponentType(this.tableType_));
                if (newElement != null) {
                    this.result = 1;
                    newElement.setAttribute("Order", Editor.getFormatted4ByteString(this.order));
                    ++this.order;
                    if (this.tableType_.equals("Function290PhraseList") || this.tableType_.equals("Function390HeaderPhraseList")) {
                        newElement.setAttribute("Block", "PARAGRAPH");
                        newElement.setAttribute("Alignment", "LEFT");
                        newElement.setAttribute("AlignmentMargin", "0");
                        newElement.setAttribute("Value", "&DataSource(" + checkBox.getDataSourceName() + ")");
                        newElement.setAttribute("FontID", this.frame_.getDefaultPrintFontID());
                        newElement.setAttribute("FontSize", "12");
                        newElement.setAttribute("FontStyle", "");
                    } else {
                        newElement.setAttribute("DataSource", checkBox.getDataSourceName());
                        newElement.setAttribute("FieldOptions", "");
                        if (this.tableType_.equals("Function100FilterList") || this.tableType_.equals("Function110FilterList") || this.tableType_.equals("Function300DetailFilterList")) {
                            if (checkBox.isNumeric()) {
                                newElement.setAttribute("FieldOptions", "IGNORE_IF_ZERO");
                            } else if (checkBox.isKubun()) {
                                newElement.setAttribute("FieldOptions", "PROMPT_LIST1");
                            }
                        }
                        if (this.tableType_.equals("Function390DetailFieldList")) {
                            newElement.setAttribute("Width", "10");
                            if (checkBox.isNumeric()) {
                                newElement.setAttribute("Alignment", "RIGHT");
                            } else {
                                newElement.setAttribute("Alignment", "LEFT");
                            }
                        }
                    }
                    this.objectElement_.appendChild(newElement);
                    this.frame_.informationOnThisPageChanged = true;
                }
            }
            ++i;
        }
        if (anySelected) {
            this.frame_.updateOrderOfFieldRows();
        }
        this.setVisible(false);
    }

    int checkEmulatingDataSourceName(String name, NodeList emulatableFieldList) {
        int reply = 0;
        if (emulatableFieldList != null) {
            int j = 0;
            while (j < emulatableFieldList.getLength()) {
                Element wrkElement = (Element)emulatableFieldList.item(j);
                if (wrkElement.getAttribute("DataSource").equals(name)) {
                    reply = 1;
                    break;
                }
                ++j;
            }
        }
        return reply;
    }

    boolean hasDuplicatedReferField(String tableID, String dataSourceName) {
        boolean isDuplicated = false;
        Element wrkElement = this.frame_.getSpecificXETreeNode("Table", tableID).getElement();
        NodeList nodeList = wrkElement.getElementsByTagName("Refer");
        int k = 0;
        while (k < nodeList.getLength()) {
            wrkElement = (Element)nodeList.item(k);
            StringTokenizer wrkTokenizer = new StringTokenizer(wrkElement.getAttribute("Fields"), ";");
            while (wrkTokenizer.hasMoreTokens()) {
                String wrkStr = wrkTokenizer.nextToken();
                wrkStr = wrkElement.getAttribute("TableAlias").equals("") ? String.valueOf(wrkElement.getAttribute("ToTable")) + "." + wrkStr : String.valueOf(wrkElement.getAttribute("TableAlias")) + "." + wrkStr;
                if (!wrkStr.equals(dataSourceName)) continue;
                isDuplicated = true;
                break;
            }
            if (isDuplicated) break;
            ++k;
        }
        return isDuplicated;
    }

    void jButtonSelectAll_actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.listModelDataSource.getSize()) {
            DialogAddFieldToFunction_CheckBox checkBox = (DialogAddFieldToFunction_CheckBox)this.listModelDataSource.getElementAt(i);
            checkBox.setSelected(true);
            ++i;
        }
        this.jListDataSource.updateUI();
        if (this.listModelDataSource.getSize() > 0) {
            this.jButtonOK.setEnabled(true);
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jListDataSource_mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        int index = this.jListDataSource.locationToIndex(p);
        if (index > -1) {
            JCheckBox checkBox = this.listModelDataSource.getElementAt(index);
            if (checkBox.isSelected()) {
                checkBox.setSelected(false);
            } else {
                checkBox.setSelected(true);
            }
            this.jListDataSource.repaint();
        }
        this.jButtonOK.setEnabled(false);
        int i = 0;
        while (i < this.listModelDataSource.getSize()) {
            JCheckBox checkBox = this.listModelDataSource.getElementAt(i);
            if (checkBox.isSelected()) {
                this.jButtonOK.setEnabled(true);
                break;
            }
            ++i;
        }
    }
}

