/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogAssistList_keyAdapter;
import xeadEditor.Editor;

public class DialogAssistList
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JScrollPane scrollPaneToBeAssisted;
    private JTextArea textAreaToBeAssisted;
    private JList jListAssistList;
    private ArrayList<String> instanceAssistListArray;
    private ArrayList<String> sessionAssistListArray;
    private JScrollPane jScrollPaneAssistList = null;
    private Point scrollPos;
    private int caretPos;
    private int stringPosInTextFrom;
    private String assistMode = "";
    private String idSelected = "";
    private Editor frame_;

    public DialogAssistList(Editor frame) {
        this.frame_ = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogAssistList(Editor frame, JDialog dialog) {
        super((Dialog)dialog, false);
        this.frame_ = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogAssistList(Editor frame, JDialog dialog, boolean isMordal) {
        super((Dialog)dialog, isMordal);
        this.frame_ = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jScrollPaneAssistList = new JScrollPane();
        this.jListAssistList = new JList();
        this.jListAssistList.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE + 2));
        DefaultListModel model = new DefaultListModel();
        this.jListAssistList.setModel(model);
        this.jListAssistList.setSelectionMode(0);
        this.jListAssistList.addKeyListener(new DialogAssistList_keyAdapter(this));
        this.jScrollPaneAssistList.getViewport().add((Component)this.jListAssistList, null);
        this.jScrollPaneAssistList.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.jScrollPaneAssistList, null);
        this.setPreferredSize(new Dimension(400, 300));
        this.setUndecorated(true);
        this.instanceAssistListArray = new ArrayList();
        this.instanceAssistListArray.add("cancelWithMessage(message)");
        this.instanceAssistListArray.add("callFunction(functionID)");
        this.instanceAssistListArray.add("commit()");
        this.instanceAssistListArray.add("rollback()");
        this.instanceAssistListArray.add("getFunctionID()");
        this.instanceAssistListArray.add("getParmMap()");
        this.instanceAssistListArray.add("getReturnMap()");
        this.instanceAssistListArray.add("setProcessLog(text)");
        this.instanceAssistListArray.add("createTableOperator(oparation, tableID)");
        this.instanceAssistListArray.add("createTableOperator(sql)");
        this.instanceAssistListArray.add("createTableEvaluator(tableID)");
        this.instanceAssistListArray.add("getFieldObjectByID(tableID, fieldID)");
        this.instanceAssistListArray.add("getUserValueOf(dataSourceName)");
        this.instanceAssistListArray.add("setUserValueOf(dataSourceName, value)");
        this.instanceAssistListArray.add("getVariant(variantID)");
        this.instanceAssistListArray.add("setVariant(variantID, value)");
        this.instanceAssistListArray.add("setStatusMessage(message)");
        this.instanceAssistListArray.add("executeScript(text)");
        Collections.sort(this.instanceAssistListArray);
        this.sessionAssistListArray = new ArrayList();
        this.sessionAssistListArray.add("getDatabaseName()");
        this.sessionAssistListArray.add("getDatabaseUser()");
        this.sessionAssistListArray.add("getDatabasePassword()");
        this.sessionAssistListArray.add("getFileFolder()");
        this.sessionAssistListArray.add("getFileName()");
        this.sessionAssistListArray.add("getImageFileFolder()");
        this.sessionAssistListArray.add("getOutputFolder()");
        this.sessionAssistListArray.add("getAdminEmail()");
        this.sessionAssistListArray.add("getSessionID()");
        this.sessionAssistListArray.add("getUserEmployeeNo()");
        this.sessionAssistListArray.add("getUserEmailAddress()");
        this.sessionAssistListArray.add("getUserID()");
        this.sessionAssistListArray.add("getUserName()");
        this.sessionAssistListArray.add("getAttribute(attributeID)");
        this.sessionAssistListArray.add("setAttribute(attributeID, value)");
        this.sessionAssistListArray.add("getFunctionName(functionID)");
        this.sessionAssistListArray.add("getSubDBListSize()");
        this.sessionAssistListArray.add("getSubDBName(index)");
        this.sessionAssistListArray.add("getSubDBUser(index)");
        this.sessionAssistListArray.add("getSubDBPassword(index)");
        this.sessionAssistListArray.add("getSystemProperty(propertyID)");
        this.sessionAssistListArray.add("compressTable(tableID)");
        this.sessionAssistListArray.add("createTableOperator(sql)");
        this.sessionAssistListArray.add("createTableOperator(operation, tableID)");
        this.sessionAssistListArray.add("commit()");
        this.sessionAssistListArray.add("rollback()");
        this.sessionAssistListArray.add("decodeBase64StringToByteArray(value)");
        this.sessionAssistListArray.add("encodeByteArrayToBase64String(byteArray)");
        this.sessionAssistListArray.add("getTableName(tableID)");
        this.sessionAssistListArray.add("getFieldName(tableID, fieldID)");
        this.sessionAssistListArray.add("getFieldType(tableID, fieldID)");
        this.sessionAssistListArray.add("getFieldSize(tableID, fieldID)");
        this.sessionAssistListArray.add("getFieldDecimal(tableID, fieldID)");
        this.sessionAssistListArray.add("copyFile(originalName, newName)");
        this.sessionAssistListArray.add("existsFile(fileName)");
        this.sessionAssistListArray.add("deleteFile(fileName)");
        this.sessionAssistListArray.add("renameFile(currentName, newName)");
        this.sessionAssistListArray.add("createExcelFileOperator(fileName)");
        this.sessionAssistListArray.add("createTextFileOperator(operation, fileName, separator, charset)");
        this.sessionAssistListArray.add("getAnnualExchangeRate(currency, fYear, type)");
        this.sessionAssistListArray.add("getMonthlyExchangeRate(currency, fYear, mSeq, type)");
        this.sessionAssistListArray.add("getMonthlyExchangeRate(currency, date, type)");
        this.sessionAssistListArray.add("getNextNumber(numberID)");
        this.sessionAssistListArray.add("setNextNumber(numberID, value)");
        this.sessionAssistListArray.add("getSystemVariantFloat(variantID)");
        this.sessionAssistListArray.add("getSystemVariantInteger(variantID)");
        this.sessionAssistListArray.add("getSystemVariantString(variantID)");
        this.sessionAssistListArray.add("setSystemVariant(variantID, value)");
        this.sessionAssistListArray.add("getTaxAmount(date, amount)");
        this.sessionAssistListArray.add("getTaxAmount(date, amount, kbKazei)");
        this.sessionAssistListArray.add("getUserVariantDescription(variantID, value)");
        this.sessionAssistListArray.add("getDaysBetweenDates(dateFrom, dateThru, countType, kbCalendar)");
        this.sessionAssistListArray.add("getMinutesBetweenTimes(timeFrom, timeThru)");
        this.sessionAssistListArray.add("getOffsetDate(date, days, countType, kbCalendar)");
        this.sessionAssistListArray.add("getOffsetDateTime(date, time, minutes countType, kbCalendar)");
        this.sessionAssistListArray.add("formatDate(date, formatType)");
        this.sessionAssistListArray.add("formatTime(time)");
        this.sessionAssistListArray.add("getOffsetYearMonth(yearMonth, months)");
        this.sessionAssistListArray.add("getTimeStamp()");
        this.sessionAssistListArray.add("getThisMonth()");
        this.sessionAssistListArray.add("getToday()");
        this.sessionAssistListArray.add("isOffDate(date, kbCalendar)");
        this.sessionAssistListArray.add("isValidDate(date)");
        this.sessionAssistListArray.add("isValidDateFormat(date, separator)");
        this.sessionAssistListArray.add("isValidTime(time, format)");
        this.sessionAssistListArray.add("getFYearOfDate(date)");
        this.sessionAssistListArray.add("getMSeqOfDate(date)");
        this.sessionAssistListArray.add("getErrorOfAccountDate(date)");
        this.sessionAssistListArray.add("getYearMonthOfFYearMSeq(fYearMSeq)");
        this.sessionAssistListArray.add("executeProgram(programName)");
        this.sessionAssistListArray.add("browseFile(fileName)");
        this.sessionAssistListArray.add("editFile(fileName)");
        this.sessionAssistListArray.add("sendMail(addressFrom, addressTo, addressCc, subject, message, fileName, attachedName, charset)");
        this.sessionAssistListArray.add("startProgress(text, max)");
        this.sessionAssistListArray.add("incrementProgress()");
        this.sessionAssistListArray.add("endProgress()");
        this.sessionAssistListArray.add("getOptionDialog()");
        this.sessionAssistListArray.add("getInputDialog()");
        this.sessionAssistListArray.add("getCheckListDialog()");
        this.sessionAssistListArray.add("getDigestedValue(value, algorithm, expand, salt)");
        this.sessionAssistListArray.add("getRandomString(length, characters)");
        this.sessionAssistListArray.add("requestWebService(uri, encoding)");
        this.sessionAssistListArray.add("createWebServiceRequest(uri, encoding)");
        this.sessionAssistListArray.add("parseStringToGetXmlDocument(data, encoding)");
        this.sessionAssistListArray.add("parseXmlDocumentToGetString(document)");
        this.sessionAssistListArray.add("createXmlDocument(name)");
        this.sessionAssistListArray.add("createXmlNode(document, name)");
        this.sessionAssistListArray.add("getXmlNode(node, name)");
        this.sessionAssistListArray.add("getXmlNodeList(node, name)");
        this.sessionAssistListArray.add("getXmlNodeContent(node, name)");
        this.sessionAssistListArray.add("createJsonObject(text)");
        this.sessionAssistListArray.add("createJsonArray(text)");
        this.sessionAssistListArray.add("getJsonObject(object, key)");
        this.sessionAssistListArray.add("getJsonObject(array, index)");
        this.sessionAssistListArray.add("showDialogToChooseFile(fileExtention, directory, defaultFile)");
        this.sessionAssistListArray.add("copyTableRecords(fromFile, toFile, processType, count, isToCommitEachTime)");
        this.sessionAssistListArray.add("getLastDateOfTheYearMonth(String yearMonth)");
        this.sessionAssistListArray.add("getMonthsBetweenYearMonths(String yearMonthFrom, String yearMonthThru)");
        Collections.sort(this.sessionAssistListArray);
    }

    public String listIDs(String text, ArrayList<String> idList, ArrayList<String> nameList, JTextField nameField) {
        this.assistMode = "IDS";
        this.idSelected = "";
        DefaultListModel model = (DefaultListModel)this.jListAssistList.getModel();
        model.removeAllElements();
        model.addElement("(" + res.getString("Close") + ")");
        int i = 0;
        while (i < idList.size()) {
            String wrkStr = idList.get(i).toUpperCase();
            if (wrkStr.startsWith(text.toUpperCase())) {
                model.addElement(String.valueOf(idList.get(i)) + " - " + nameList.get(i));
            }
            ++i;
        }
        if (this.jListAssistList.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(null, res.getString("AssistListMessage"));
        } else if (this.jListAssistList.getModel().getSize() <= 2) {
            this.idSelected = this.jListAssistList.getModel().getElementAt(1).toString();
        } else {
            this.jListAssistList.setSelectedIndex(0);
            this.jScrollPaneAssistList.getViewport().setViewPosition(new Point(0, 0));
            this.setLocation(this.getParent().getLocation().x + nameField.getBounds().x, this.getParent().getLocation().y + nameField.getBounds().y);
            this.setVisible(true);
        }
        return this.idSelected;
    }

    public void listMethods(JScrollPane scrollPane) {
        this.assistMode = "METHODS";
        this.scrollPaneToBeAssisted = scrollPane;
        this.textAreaToBeAssisted = (JTextArea)this.scrollPaneToBeAssisted.getViewport().getView();
        this.scrollPos = this.scrollPaneToBeAssisted.getViewport().getViewPosition();
        this.caretPos = this.textAreaToBeAssisted.getCaretPosition();
        Point caretPoint = this.textAreaToBeAssisted.getCaret().getMagicCaretPosition();
        Point areaPoint = this.textAreaToBeAssisted.getLocationOnScreen();
        int pos = this.caretPos - 1;
        String stringToBeAssisted = this.textAreaToBeAssisted.getText().substring(0, this.caretPos);
        if (!stringToBeAssisted.equals("session.") && !stringToBeAssisted.equals("instance.")) {
            stringToBeAssisted = "";
            while (pos >= 0) {
                String wrkStr = this.textAreaToBeAssisted.getText().substring(pos, pos + 1);
                if (wrkStr.equals("\n") || wrkStr.equals("\t") || wrkStr.equals(",") || wrkStr.equals(" ") || wrkStr.equals(";") || wrkStr.equals("(") || wrkStr.equals("{") || wrkStr.equals("}")) {
                    this.stringPosInTextFrom = pos + 1;
                    if (this.stringPosInTextFrom >= this.caretPos) break;
                    stringToBeAssisted = this.textAreaToBeAssisted.getText().substring(this.stringPosInTextFrom, this.caretPos);
                    break;
                }
                --pos;
            }
        }
        this.setupAssistList(stringToBeAssisted);
        if (this.jListAssistList.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(null, res.getString("AssistListMessage"));
        } else if (this.jListAssistList.getModel().getSize() == 1) {
            this.updateTextWithAssistCode(String.valueOf(this.jListAssistList.getModel().getElementAt(0).toString()) + ";");
        } else {
            int posY;
            int bottomPosY;
            this.jListAssistList.setSelectedIndex(0);
            this.jScrollPaneAssistList.getViewport().setViewPosition(new Point(0, 0));
            int posX = areaPoint.x + caretPoint.x;
            int rightPosX = posX + this.getBounds().width;
            if (rightPosX > this.frame_.screenWidth) {
                posX -= rightPosX - this.frame_.screenWidth;
            }
            if ((bottomPosY = (posY = areaPoint.y + caretPoint.y) + this.getBounds().height) > this.frame_.screenHeight - 30) {
                posY -= bottomPosY - this.frame_.screenHeight + 30;
            }
            this.setLocation(posX, posY);
            this.setVisible(true);
        }
    }

    public void setupAssistList(String string) {
        String wrkStr;
        DefaultListModel model = (DefaultListModel)this.jListAssistList.getModel();
        model.removeAllElements();
        if (string.equals("")) {
            model.addElement("Comments of table definition");
            model.addElement("Statement of select-table");
            model.addElement("Statement of insert-table");
            model.addElement("Statement of update-table");
            model.addElement("Statement of delete-table");
        }
        ArrayList<String> functionList = this.frame_.getScriptFunctionList();
        int i = 0;
        while (i < functionList.size()) {
            wrkStr = functionList.get(i).toUpperCase();
            if (functionList.get(i).toUpperCase().startsWith(string.toUpperCase())) {
                model.addElement(functionList.get(i));
            }
            ++i;
        }
        if (string.equals("") || string.startsWith("instance.")) {
            i = 0;
            while (i < this.instanceAssistListArray.size()) {
                wrkStr = "INSTANCE." + this.instanceAssistListArray.get(i).toUpperCase();
                if (wrkStr.startsWith(string.toUpperCase())) {
                    if (string.equals("")) {
                        model.addElement("instance." + this.instanceAssistListArray.get(i));
                    } else {
                        model.addElement(this.instanceAssistListArray.get(i));
                    }
                }
                ++i;
            }
        }
        if (string.equals("") || string.startsWith("session.")) {
            i = 0;
            while (i < this.sessionAssistListArray.size()) {
                wrkStr = "SESSION." + this.sessionAssistListArray.get(i).toUpperCase();
                if (wrkStr.startsWith(string.toUpperCase())) {
                    if (string.equals("")) {
                        model.addElement("session." + this.sessionAssistListArray.get(i));
                    } else {
                        model.addElement(this.sessionAssistListArray.get(i));
                    }
                }
                ++i;
            }
        }
    }

    void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.assistMode.equals("METHODS") && this.jListAssistList.getSelectedIndex() > -1) {
                if (this.jListAssistList.getSelectedValue().toString().equals("Comments of table definition")) {
                    String tableID = JOptionPane.showInputDialog(null, (Object)res.getString("SpecifyTableID"));
                    if (tableID != null && !tableID.equals("")) {
                        this.updateTextWithAssistCode(this.getTableDefinition(tableID));
                    }
                } else {
                    String operation = this.jListAssistList.getSelectedValue().toString();
                    if (operation.equals("Statement of select-table") || operation.equals("Statement of insert-table") || operation.equals("Statement of update-table") || operation.equals("Statement of delete-table")) {
                        String tableID = JOptionPane.showInputDialog(null, (Object)res.getString("SpecifyTableID"));
                        if (tableID != null && !tableID.equals("")) {
                            this.updateTextWithAssistCode(this.getInsertStatement(tableID, operation));
                        }
                    } else {
                        this.updateTextWithAssistCode(String.valueOf(this.jListAssistList.getSelectedValue().toString()) + ";");
                    }
                }
            }
            if (this.assistMode.equals("IDS") && this.jListAssistList.getSelectedIndex() > -1) {
                this.idSelected = this.jListAssistList.getSelectedValue().toString();
            }
            this.setVisible(false);
        }
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    String getTableDefinition(String tableID) {
        ArrayList<Object> optionList = new ArrayList();
        ArrayList<String> pkFieldList = new ArrayList<String>();
        StringBuffer moduleBuf = new StringBuffer();
        Element tableElement = this.frame_.getSpecificTableElement(tableID = tableID.toUpperCase());
        if (tableElement == null) {
            JOptionPane.showMessageDialog(null, "ID is invalid.");
        } else {
            Element element;
            String databaseName = this.frame_.getDatabaseName(tableElement.getAttribute("DB"));
            moduleBuf.append("// " + tableID + " " + tableElement.getAttribute("Name") + "\n");
            NodeList keyList = tableElement.getElementsByTagName("Key");
            int i = 0;
            while (i < keyList.getLength()) {
                element = (Element)keyList.item(i);
                if (element.getAttribute("Type").equals("PK")) {
                    String moduleKeyFields = element.getAttribute("Fields");
                    StringTokenizer workTokenizer = new StringTokenizer(moduleKeyFields, ";");
                    while (workTokenizer.hasMoreTokens()) {
                        String wrkStr = workTokenizer.nextToken();
                        pkFieldList.add(wrkStr);
                    }
                }
                ++i;
            }
            NodeList fieldList = tableElement.getElementsByTagName("Field");
            Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(fieldList, "Order");
            int i2 = 0;
            while (i2 < sortingList.getSize()) {
                element = (Element)sortingList.getElementAt(i2);
                optionList = this.frame_.getOptionList(element.getAttribute("TypeOptions"));
                if (!optionList.contains("VIRTUAL")) {
                    if (pkFieldList.contains(element.getAttribute("ID"))) {
                        moduleBuf.append("// * ");
                    } else {
                        moduleBuf.append("// ");
                    }
                    moduleBuf.append(String.valueOf(element.getAttribute("ID")) + " " + element.getAttribute("Name") + " ");
                    if ((databaseName.contains("jdbc:sqlserver") || databaseName.contains("jdbc:oracle")) && element.getAttribute("Type").equals("CHAR") && optionList.contains("KANJI")) {
                        moduleBuf.append("NCHAR");
                        moduleBuf.append("(");
                        moduleBuf.append(element.getAttribute("Size"));
                        moduleBuf.append(")");
                    } else {
                        if (databaseName.contains("jdbc:sqlserver") && element.getAttribute("Type").equals("DOUBLE")) {
                            moduleBuf.append("FLOAT");
                        } else {
                            moduleBuf.append(element.getAttribute("Type"));
                        }
                        if (this.frame_.getBasicTypeOf(element.getAttribute("Type")).equals("INTEGER")) {
                            moduleBuf.append(" Default 0");
                        } else if (this.frame_.getBasicTypeOf(element.getAttribute("Type")).equals("FLOAT")) {
                            if (element.getAttribute("Type").equals("DECIMAL") || element.getAttribute("Type").equals("NUMERIC")) {
                                moduleBuf.append("(");
                                moduleBuf.append(element.getAttribute("Size"));
                                moduleBuf.append(",");
                                moduleBuf.append(element.getAttribute("Decimal"));
                                moduleBuf.append(")");
                            }
                            moduleBuf.append(" Default 0.0");
                        } else {
                            if (element.getAttribute("Type").equals("CHAR")) {
                                moduleBuf.append("(");
                                moduleBuf.append(element.getAttribute("Size"));
                                moduleBuf.append(")");
                            }
                            if (element.getAttribute("Type").contains("VARCHAR") && !element.getAttribute("Size").equals("0")) {
                                moduleBuf.append("(");
                                moduleBuf.append(element.getAttribute("Size"));
                                moduleBuf.append(")");
                            }
                        }
                    }
                    if (!element.getAttribute("Nullable").equals("T")) {
                        moduleBuf.append(" Not null");
                    }
                    moduleBuf.append("\n");
                }
                ++i2;
            }
        }
        return moduleBuf.toString();
    }

    String getInsertStatement(String tableID, String operation) {
        ArrayList<Object> optionList = new ArrayList();
        ArrayList<String> pkFieldList = new ArrayList<String>();
        StringBuffer moduleBuf = new StringBuffer();
        Element tableElement = this.frame_.getSpecificTableElement(tableID = tableID.toUpperCase());
        if (tableElement == null) {
            JOptionPane.showMessageDialog(null, "ID is invalid.");
        } else {
            Element element;
            String operator = "";
            if (operation.equals("Statement of select-table")) {
                operator = "r" + tableID;
                moduleBuf.append(String.valueOf(operator) + " = instance.createTableOperator('Select', '" + tableID + "');\n");
            }
            if (operation.equals("Statement of insert-table")) {
                operator = "c" + tableID;
                moduleBuf.append(String.valueOf(operator) + " = instance.createTableOperator('Insert', '" + tableID + "');\n");
            }
            if (operation.equals("Statement of update-table")) {
                operator = "u" + tableID;
                moduleBuf.append(String.valueOf(operator) + " = instance.createTableOperator('Update', '" + tableID + "');\n");
            }
            if (operation.equals("Statement of delete-table")) {
                operator = "d" + tableID;
                moduleBuf.append(String.valueOf(operator) + " = instance.createTableOperator('Delete', '" + tableID + "');\n");
            }
            NodeList keyList = tableElement.getElementsByTagName("Key");
            int i = 0;
            while (i < keyList.getLength()) {
                element = (Element)keyList.item(i);
                if (element.getAttribute("Type").equals("PK")) {
                    String moduleKeyFields = element.getAttribute("Fields");
                    StringTokenizer workTokenizer = new StringTokenizer(moduleKeyFields, ";");
                    while (workTokenizer.hasMoreTokens()) {
                        String wrkStr = workTokenizer.nextToken();
                        pkFieldList.add(wrkStr);
                    }
                }
                ++i;
            }
            NodeList fieldList = tableElement.getElementsByTagName("Field");
            Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(fieldList, "Order");
            int i2 = 0;
            while (i2 < sortingList.getSize()) {
                element = (Element)sortingList.getElementAt(i2);
                optionList = this.frame_.getOptionList(element.getAttribute("TypeOptions"));
                if (!optionList.contains("VIRTUAL")) {
                    if (operation.equals("Statement of select-table") && pkFieldList.contains(element.getAttribute("ID"))) {
                        moduleBuf.append(String.valueOf(operator) + ".addKeyValue('" + element.getAttribute("ID") + "',\txxxxx.getValueOf('" + element.getAttribute("ID") + "'));\n");
                    }
                    if (operation.equals("Statement of insert-table")) {
                        if (pkFieldList.contains(element.getAttribute("ID"))) {
                            moduleBuf.append(String.valueOf(operator) + ".setValueOf('" + element.getAttribute("ID") + "',\txxxxx.getValueOf('" + element.getAttribute("ID") + "')); //Key\n");
                        } else {
                            moduleBuf.append(String.valueOf(operator) + ".setValueOf('" + element.getAttribute("ID") + "',\txxxxx.getValueOf('" + element.getAttribute("ID") + "'));\n");
                        }
                    }
                    if (operation.equals("Statement of update-table")) {
                        if (pkFieldList.contains(element.getAttribute("ID"))) {
                            moduleBuf.append(String.valueOf(operator) + ".addKeyValue('" + element.getAttribute("ID") + "',\txxxxx.getValueOf('" + element.getAttribute("ID") + "'));\n");
                        } else {
                            moduleBuf.append(String.valueOf(operator) + ".setValueOf('" + element.getAttribute("ID") + "',\txxxxx.getValueOf('" + element.getAttribute("ID") + "'));\n");
                        }
                    }
                    if (operation.equals("Statement of delete-table") && pkFieldList.contains(element.getAttribute("ID"))) {
                        moduleBuf.append(String.valueOf(operator) + ".addKeyValue('" + element.getAttribute("ID") + "',\txxxxx.getValueOf('" + element.getAttribute("ID") + "')); //Key\n");
                    }
                }
                ++i2;
            }
            if (operation.equals("Statement of select-table")) {
                moduleBuf.append("if (" + operator + ".next()) {\n\n");
                moduleBuf.append("}\n\n");
            } else {
                moduleBuf.append("count = " + operator + ".execute();\n\n");
            }
        }
        return moduleBuf.toString();
    }

    void updateTextWithAssistCode(String codeToBeInserted) {
        String text = this.textAreaToBeAssisted.getText();
        int slicedThru = this.caretPos;
        String stringToBeReplaced = text.substring(this.stringPosInTextFrom, this.caretPos);
        if (stringToBeReplaced.startsWith("instance.") || stringToBeReplaced.startsWith("session.")) {
            String strWrk = stringToBeReplaced.replace("instance.", "").replace("session.", "");
            if (codeToBeInserted.startsWith(strWrk)) {
                slicedThru = text.indexOf(".", this.stringPosInTextFrom) + 1;
            }
        } else if (codeToBeInserted.startsWith(stringToBeReplaced)) {
            slicedThru = this.stringPosInTextFrom;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(text.substring(0, slicedThru));
        buf.append(codeToBeInserted);
        buf.append(text.substring(this.caretPos, text.length()));
        this.textAreaToBeAssisted.setText(buf.toString());
        this.textAreaToBeAssisted.updateUI();
        this.scrollPaneToBeAssisted.getViewport().setViewPosition(this.scrollPos);
        this.textAreaToBeAssisted.setCaretPosition(slicedThru + codeToBeInserted.length());
        this.frame_.jTextAreaFunction000Script.add(this.frame_.jPanelFunction000ScriptEditTool);
    }
}

