/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogCheckFunctionsCalled_jButtonCloseDialog_actionAdapter;
import xeadEditor.DialogCheckFunctionsCalled_jButtonGenerateListData_actionAdapter;
import xeadEditor.Editor;

public class DialogCheckFunctionsCalled
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private Editor frame_;
    private BorderLayout borderLayoutMain = new BorderLayout();
    private JPanel panelMain = new JPanel();
    private JPanel jPanelSouth = new JPanel();
    private JScrollPane jScrollPaneCheckResult = new JScrollPane();
    private TableModelReadOnlyList tableModelCheckResult = new TableModelReadOnlyList();
    private JTable jTableCheckResult = new JTable(this.tableModelCheckResult);
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private DefaultTableCellRenderer rendererTableHeader = null;
    private DefaultTableCellRenderer rendererAlignmentCenter = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentRight = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentLeft = new DefaultTableCellRenderer();
    private JButton jButtonCloseDialog = new JButton();
    private JButton jButtonGenerateListData = new JButton();
    private Editor.SortableDomElementListModel functionNodeList1;
    private Editor.SortableDomElementListModel functionNodeList2;
    private Editor.SortableDomElementListModel menuNodeList;
    private Editor.SortableDomElementListModel tableNodeList;

    public DialogCheckFunctionsCalled(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogCheckFunctionsCalled(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(this.borderLayoutMain);
        this.panelMain.setBorder(null);
        this.panelMain.add((Component)this.jPanelSouth, "South");
        this.panelMain.add((Component)this.jScrollPaneCheckResult, "Center");
        this.jTableCheckResult.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableCheckResult.setBackground(SystemColor.control);
        this.jTableCheckResult.setAutoResizeMode(0);
        this.jTableCheckResult.setSelectionMode(0);
        this.jTableCheckResult.setRowHeight(24);
        this.tableModelCheckResult.addColumn("No.");
        this.tableModelCheckResult.addColumn(res.getString("ElementType"));
        this.tableModelCheckResult.addColumn(res.getString("ElementName"));
        this.tableModelCheckResult.addColumn(res.getString("Status"));
        this.column0 = this.jTableCheckResult.getColumnModel().getColumn(0);
        this.column1 = this.jTableCheckResult.getColumnModel().getColumn(1);
        this.column2 = this.jTableCheckResult.getColumnModel().getColumn(2);
        this.column3 = this.jTableCheckResult.getColumnModel().getColumn(3);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(150);
        this.column2.setPreferredWidth(250);
        this.column3.setPreferredWidth(550);
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentRight.setHorizontalAlignment(4);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableCheckResult.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableCheckResult.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jScrollPaneCheckResult.getViewport().add((Component)this.jTableCheckResult, null);
        this.jPanelSouth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSouth.setPreferredSize(new Dimension(100, 43));
        this.jButtonCloseDialog.setBounds(new Rectangle(50, 8, 100, 27));
        this.jButtonCloseDialog.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCloseDialog.setText(res.getString("Close"));
        this.jButtonCloseDialog.addActionListener(new DialogCheckFunctionsCalled_jButtonCloseDialog_actionAdapter(this));
        this.jButtonGenerateListData.setBounds(new Rectangle(800, 8, 150, 27));
        this.jButtonGenerateListData.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonGenerateListData.setText(res.getString("GenerateList"));
        this.jButtonGenerateListData.addActionListener(new DialogCheckFunctionsCalled_jButtonGenerateListData_actionAdapter(this));
        this.jPanelSouth.setLayout(null);
        this.jPanelSouth.add(this.jButtonGenerateListData);
        this.jPanelSouth.add(this.jButtonCloseDialog);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(1024, 400));
        this.setTitle(res.getString("CheckFunctionsCalled"));
        this.getContentPane().add(this.panelMain);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public void request() {
        super.setVisible(true);
    }

    public int numberOfInvalidCalls() {
        Editor.MainTreeNode node;
        int pos2;
        int pos1;
        String wrkStr;
        Element element2;
        Element element1;
        int numberOfInvalidCalls = 0;
        if (this.tableModelCheckResult.getRowCount() > 0) {
            int rowCount = this.tableModelCheckResult.getRowCount();
            int i = 0;
            while (i < rowCount) {
                this.tableModelCheckResult.removeRow(0);
                ++i;
            }
        }
        NodeList nodeList1 = this.frame_.getDomDocument().getElementsByTagName("Function");
        this.functionNodeList1 = this.frame_.getSortedListModel(nodeList1, "ID");
        this.functionNodeList2 = this.frame_.getSortedListModel(nodeList1, "ID");
        nodeList1 = this.frame_.getDomDocument().getElementsByTagName("Menu");
        this.menuNodeList = this.frame_.getSortedListModel(nodeList1, "ID");
        nodeList1 = this.frame_.getDomDocument().getElementsByTagName("Table");
        this.tableNodeList = this.frame_.getSortedListModel(nodeList1, "ID");
        int i = 0;
        while (i < this.tableNodeList.getSize()) {
            element1 = (Element)this.tableNodeList.getElementAt(i);
            nodeList1 = element1.getElementsByTagName("Script");
            int j = 0;
            while (j < nodeList1.getLength()) {
                Object[] Cell;
                element2 = (Element)nodeList1.item(j);
                wrkStr = this.frame_.substringLinesWithTokenOfEOL(element2.getAttribute("Text"), "\n");
                wrkStr = this.frame_.removeCommentsFromScriptText(wrkStr).replace(" ", "");
                pos1 = -1;
                while (pos1 < wrkStr.length()) {
                    if ((pos1 = wrkStr.indexOf("instance.callFunction('", pos1 + 1)) == -1 || (pos2 = wrkStr.indexOf("')", pos1 + 1)) == -1) break;
                    node = this.frame_.getSpecificXETreeNode("Function", wrkStr.substring(pos1 + 23, pos2).trim());
                    if (node != null) continue;
                    Cell = new Object[]{++numberOfInvalidCalls, res.getString("TableDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage7")) + element2.getAttribute("Name") + res.getString("CheckFunctionsCalledMessage8") + wrkStr.substring(pos1 + 23, pos2) + res.getString("CheckFunctionsCalledMessage9")};
                    this.tableModelCheckResult.addRow(Cell);
                }
                pos1 = -1;
                while (pos1 < wrkStr.length()) {
                    if ((pos1 = wrkStr.indexOf("instance.functionID=='", pos1 + 1)) == -1 || (pos2 = wrkStr.indexOf("'", pos1 + 22)) == -1) break;
                    node = this.frame_.getSpecificXETreeNode("Function", wrkStr.substring(pos1 + 22, pos2));
                    if (node != null) continue;
                    Cell = new Object[]{++numberOfInvalidCalls, res.getString("TableDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage7")) + element2.getAttribute("Name") + res.getString("CheckFunctionsCalledMessage8") + wrkStr.substring(pos1 + 22, pos2) + res.getString("CheckFunctionsCalledMessage9")};
                    this.tableModelCheckResult.addRow(Cell);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.menuNodeList.getSize()) {
            boolean isNotExisting;
            element1 = (Element)this.menuNodeList.getElementAt(i);
            StringTokenizer tokenizer = new StringTokenizer(element1.getAttribute("CrossCheckersToBeLoaded"), ";");
            while (tokenizer.hasMoreTokens()) {
                wrkStr = tokenizer.nextToken();
                isNotExisting = true;
                int j = 0;
                while (j < this.tableNodeList.getSize()) {
                    element2 = (Element)this.tableNodeList.getElementAt(j);
                    if (element2.getAttribute("ID").equals(wrkStr)) {
                        isNotExisting = false;
                        break;
                    }
                    ++j;
                }
                if (!isNotExisting) continue;
                Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("MenuDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage12")) + " " + wrkStr};
                this.tableModelCheckResult.addRow(Cell);
            }
            tokenizer = new StringTokenizer(element1.getAttribute("FunctionsToBeLoaded"), ";");
            while (tokenizer.hasMoreTokens()) {
                wrkStr = tokenizer.nextToken();
                isNotExisting = true;
                int j = 0;
                while (j < this.functionNodeList1.getSize()) {
                    element2 = (Element)this.functionNodeList1.getElementAt(j);
                    if (element2.getAttribute("ID").equals(wrkStr)) {
                        isNotExisting = false;
                        break;
                    }
                    ++j;
                }
                if (!isNotExisting) continue;
                Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("MenuDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage13")) + " " + wrkStr};
                this.tableModelCheckResult.addRow(Cell);
            }
            ++i;
        }
        i = 0;
        while (i < this.functionNodeList1.getSize()) {
            Element element3;
            element1 = (Element)this.functionNodeList1.getElementAt(i);
            boolean isNotCalledByAnyElement = true;
            int j = 0;
            while (j < this.menuNodeList.getSize()) {
                element2 = (Element)this.menuNodeList.getElementAt(j);
                nodeList1 = element2.getElementsByTagName("Option");
                int k = 0;
                while (k < nodeList1.getLength()) {
                    element3 = (Element)nodeList1.item(k);
                    if (element3.getAttribute("FunctionID").equals(element1.getAttribute("ID"))) {
                        isNotCalledByAnyElement = false;
                        break;
                    }
                    ++k;
                }
                if (!isNotCalledByAnyElement) break;
                ++j;
            }
            if (isNotCalledByAnyElement) {
                j = 0;
                while (j < this.functionNodeList2.getSize()) {
                    element2 = (Element)this.functionNodeList2.getElementAt(j);
                    if (!this.frame_.getFunctionUsageInFunction(element2, element1.getAttribute("ID")).equals("")) {
                        isNotCalledByAnyElement = false;
                        break;
                    }
                    ++j;
                }
            }
            if (isNotCalledByAnyElement) {
                j = 0;
                while (j < this.tableNodeList.getSize()) {
                    element2 = (Element)this.tableNodeList.getElementAt(j);
                    nodeList1 = element2.getElementsByTagName("Script");
                    int k = 0;
                    while (k < nodeList1.getLength()) {
                        element3 = (Element)nodeList1.item(k);
                        if (this.frame_.isTableScriptUsingFunction(element3, element1.getAttribute("ID"))) {
                            isNotCalledByAnyElement = false;
                            break;
                        }
                        ++k;
                    }
                    if (!isNotCalledByAnyElement) break;
                    ++j;
                }
            }
            if (isNotCalledByAnyElement) {
                Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), res.getString("CheckFunctionsCalledMessage2")};
                this.tableModelCheckResult.addRow(Cell);
            }
            if (element1.getAttribute("Type").equals("XF000")) {
                wrkStr = this.frame_.substringLinesWithTokenOfEOL(element1.getAttribute("Script"), "\n");
                wrkStr = this.frame_.removeCommentsFromScriptText(wrkStr).replace(" ", "");
                pos1 = -1;
                while (pos1 < wrkStr.length()) {
                    if ((pos1 = wrkStr.indexOf("instance.callFunction('", pos1 + 1)) == -1 || (pos2 = wrkStr.indexOf("')", pos1 + 1)) == -1) break;
                    node = this.frame_.getSpecificXETreeNode("Function", wrkStr.substring(pos1 + 23, pos2).trim());
                    if (node != null) continue;
                    Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage3")) + wrkStr.substring(pos1 + 23, pos2).trim() + res.getString("CheckFunctionsCalledMessage4")};
                    this.tableModelCheckResult.addRow(Cell);
                }
            }
            if (element1.getAttribute("Type").equals("XF100") || element1.getAttribute("Type").equals("XF110")) {
                if (!element1.getAttribute("DetailFunction").equals("") && (node = this.frame_.getSpecificXETreeNode("Function", element1.getAttribute("DetailFunction"))) == null) {
                    Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element1.getAttribute("DetailFunction") + res.getString("CheckFunctionsCalledMessage6")};
                    this.tableModelCheckResult.addRow(Cell);
                }
                nodeList1 = element1.getElementsByTagName("Button");
                j = 0;
                while (j < nodeList1.getLength()) {
                    element2 = (Element)nodeList1.item(j);
                    pos1 = element2.getAttribute("Action").indexOf("CALL(");
                    if (pos1 >= 0) {
                        pos2 = element2.getAttribute("Action").indexOf(")");
                        wrkStr = element2.getAttribute("Action").substring(pos1 + 5, pos2);
                        if (wrkStr.contains(",")) {
                            wrkStr = wrkStr.substring(0, wrkStr.indexOf(","));
                        }
                        if ((node = this.frame_.getSpecificXETreeNode("Function", wrkStr)) == null) {
                            Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element2.getAttribute("Action").substring(pos1 + 5, pos2) + res.getString("CheckFunctionsCalledMessage6")};
                            this.tableModelCheckResult.addRow(Cell);
                        }
                    }
                    if (element2.getAttribute("Action").equals("ADD") && element1.getAttribute("DetailFunction").equals("")) {
                        Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), res.getString("CheckFunctionsCalledMessage10")};
                        this.tableModelCheckResult.addRow(Cell);
                    }
                    ++j;
                }
            }
            if (element1.getAttribute("Type").equals("XF200")) {
                nodeList1 = element1.getElementsByTagName("Button");
                j = 0;
                while (j < nodeList1.getLength()) {
                    element2 = (Element)nodeList1.item(j);
                    pos1 = element2.getAttribute("Action").indexOf("CALL(");
                    if (pos1 >= 0) {
                        pos2 = element2.getAttribute("Action").indexOf(")");
                        wrkStr = element2.getAttribute("Action").substring(pos1 + 5, pos2);
                        if (wrkStr.contains(",")) {
                            wrkStr = wrkStr.substring(0, wrkStr.indexOf(","));
                        }
                        if ((node = this.frame_.getSpecificXETreeNode("Function", wrkStr)) == null) {
                            Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element2.getAttribute("Action").substring(pos1 + 5, pos2) + res.getString("CheckFunctionsCalledMessage6")};
                            this.tableModelCheckResult.addRow(Cell);
                        }
                    }
                    ++j;
                }
                if (!element1.getAttribute("FunctionAfterInsert").equals("") && (node = this.frame_.getSpecificXETreeNode("Function", element1.getAttribute("FunctionAfterInsert"))) == null) {
                    Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element1.getAttribute("FunctionAfterInsert") + res.getString("CheckFunctionsCalledMessage6")};
                    this.tableModelCheckResult.addRow(Cell);
                }
            }
            if (element1.getAttribute("Type").equals("XF300")) {
                if (!element1.getAttribute("HeaderFunction").equals("") && (node = this.frame_.getSpecificXETreeNode("Function", element1.getAttribute("HeaderFunction"))) == null) {
                    Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element1.getAttribute("HeaderFunction") + res.getString("CheckFunctionsCalledMessage6")};
                    this.tableModelCheckResult.addRow(Cell);
                }
                nodeList1 = element1.getElementsByTagName("Detail");
                j = 0;
                while (j < nodeList1.getLength()) {
                    element2 = (Element)nodeList1.item(j);
                    if (!element2.getAttribute("DetailFunction").equals("") && !element2.getAttribute("DetailFunction").equals("NONE") && (node = this.frame_.getSpecificXETreeNode("Function", element2.getAttribute("DetailFunction"))) == null) {
                        Object[] Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element2.getAttribute("DetailFunction") + res.getString("CheckFunctionsCalledMessage6")};
                        this.tableModelCheckResult.addRow(Cell);
                    }
                    NodeList nodeList2 = element2.getElementsByTagName("Button");
                    int k = 0;
                    while (k < nodeList2.getLength()) {
                        Object[] Cell;
                        element3 = (Element)nodeList2.item(k);
                        pos1 = element3.getAttribute("Action").indexOf("CALL(");
                        if (pos1 >= 0) {
                            pos2 = element3.getAttribute("Action").indexOf(")");
                            wrkStr = element3.getAttribute("Action").substring(pos1 + 5, pos2);
                            if (wrkStr.contains(",")) {
                                wrkStr = wrkStr.substring(0, wrkStr.indexOf(","));
                            }
                            if ((node = this.frame_.getSpecificXETreeNode("Function", wrkStr)) == null) {
                                Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), String.valueOf(res.getString("CheckFunctionsCalledMessage5")) + element3.getAttribute("Action").substring(pos1 + 5, pos2) + res.getString("CheckFunctionsCalledMessage6")};
                                this.tableModelCheckResult.addRow(Cell);
                            }
                        }
                        if (element3.getAttribute("Action").equals("ADD") && element2.getAttribute("DetailFunction").equals("")) {
                            Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), res.getString("CheckFunctionsCalledMessage10")};
                            this.tableModelCheckResult.addRow(Cell);
                        }
                        if (element3.getAttribute("Action").equals("HEADER") && element1.getAttribute("HeaderFunction").equals("")) {
                            Cell = new Object[]{++numberOfInvalidCalls, res.getString("FunctionDefinition"), String.valueOf(element1.getAttribute("ID")) + " " + element1.getAttribute("Name"), res.getString("CheckFunctionsCalledMessage11")};
                            this.tableModelCheckResult.addRow(Cell);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return numberOfInvalidCalls;
    }

    void jButtonGenerateListData_actionPerformed(ActionEvent e) {
        try {
            this.frame_.getDesktop().browse(this.getExcellBookURI());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, "IOException : " + e1.getMessage());
            e1.printStackTrace(this.frame_.getExceptionStream());
        }
    }

    URI getExcellBookURI() {
        File xlsFile = null;
        String xlsFileName = "";
        FileOutputStream fileOutputStream = null;
        HSSFWorkbook workBook = new HSSFWorkbook();
        HSSFSheet workSheet = workBook.createSheet(this.getTitle());
        workSheet.setDefaultRowHeight((short)300);
        HSSFFooter workSheetFooter = workSheet.getFooter();
        workSheetFooter.setRight(String.valueOf(this.getTitle()) + "  Page " + HSSFFooter.page() + " / " + HSSFFooter.numPages());
        HSSFCellStyle styleHeader = workBook.createCellStyle();
        styleHeader.setAlignment((short)1);
        HSSFCellStyle styleHeaderNumber = workBook.createCellStyle();
        styleHeaderNumber.setAlignment((short)1);
        HSSFCellStyle styleDataInteger = workBook.createCellStyle();
        styleDataInteger.setAlignment((short)3);
        styleDataInteger.setVerticalAlignment((short)0);
        styleDataInteger.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0"));
        HSSFCellStyle styleDataString = workBook.createCellStyle();
        styleDataString.setAlignment((short)1);
        styleDataString.setVerticalAlignment((short)0);
        styleDataString.setWrapText(true);
        styleDataString.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        int currentRowNumber = -1;
        try {
            File outputFolder = null;
            String wrkStr = this.frame_.getSystemNode().getElement().getAttribute("OutputFolder");
            if (wrkStr.equals("")) {
                outputFolder = null;
            } else {
                if (wrkStr.contains("<CURRENT>")) {
                    wrkStr = wrkStr.replace("<CURRENT>", this.frame_.getCurrentFileFolder());
                }
                if (!(outputFolder = new File(wrkStr)).exists()) {
                    outputFolder = null;
                }
            }
            xlsFile = File.createTempFile("XeadEditor_CheckFunctionsCalled_", ".xls", outputFolder);
            if (outputFolder == null) {
                xlsFile.deleteOnExit();
            }
            xlsFileName = xlsFile.getPath();
            fileOutputStream = new FileOutputStream(xlsFileName);
            HSSFRow rowCaption = workSheet.createRow(++currentRowNumber);
            int i = 0;
            while (i < this.tableModelCheckResult.getColumnCount()) {
                HSSFCell cell = rowCaption.createCell(i);
                cell.setCellStyle(styleHeaderNumber);
                cell.setCellValue((RichTextString)new HSSFRichTextString(this.tableModelCheckResult.getColumnName(i)));
                Rectangle rect = this.jTableCheckResult.getCellRect(0, i, true);
                workSheet.setColumnWidth(i, rect.width * 40);
                ++i;
            }
            i = 0;
            while (i < this.tableModelCheckResult.getRowCount()) {
                HSSFRow rowData = workSheet.createRow(++currentRowNumber);
                HSSFCell cell0 = rowData.createCell(0);
                cell0.setCellType(0);
                cell0.setCellStyle(styleDataInteger);
                cell0.setCellValue((double)(i + 1));
                int j = 1;
                while (j < 4) {
                    HSSFCell cell = rowData.createCell(j);
                    cell.setCellType(1);
                    cell.setCellStyle(styleDataString);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(this.tableModelCheckResult.getValueAt(i, j).toString()));
                    ++j;
                }
                ++i;
            }
            workBook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception ex1) {
            JOptionPane.showMessageDialog(null, "Exception : " + ex1.getMessage());
            ex1.printStackTrace(this.frame_.getExceptionStream());
            try {
                fileOutputStream.close();
            }
            catch (Exception ex2) {
                ex2.printStackTrace(this.frame_.getExceptionStream());
            }
        }
        return xlsFile.toURI();
    }

    void jButtonCloseDialog_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class TableModelReadOnlyList
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelReadOnlyList() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

