/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import xeadEditor.DialogCheckHashFormat_jButtonHash_actionAdapter;
import xeadEditor.DigestAdapter;
import xeadEditor.Editor;

public class DialogCheckHashFormat
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JPanel panelMain = new JPanel();
    private Editor frame_;
    private JLabel jLabelHashFormat = new JLabel();
    private JLabel jLabelValue = new JLabel();
    private JLabel jLabelSalt = new JLabel();
    private JTextField jTextFieldHashFormat = new JTextField();
    private JTextField jTextFieldValue = new JTextField();
    private JTextField jTextFieldSalt = new JTextField();
    private JButton jButtonHash = new JButton();
    private JScrollPane jScrollPaneMessage = new JScrollPane();
    private JTextArea jTextAreaMessage = new JTextArea();
    private String digestAlgorithm = "MD5";
    private int countOfExpand = 1;
    private boolean isValueSalted = false;
    private DigestAdapter digestAdapter = null;

    public DialogCheckHashFormat(Editor frame) {
        super(frame, "", true);
        this.frame_ = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.jLabelHashFormat.setText(res.getString("HashFormat"));
        this.jLabelHashFormat.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelHashFormat.setHorizontalAlignment(4);
        this.jLabelHashFormat.setHorizontalTextPosition(10);
        this.jLabelHashFormat.setBounds(new Rectangle(5, 12, 130, 20));
        this.jTextFieldHashFormat.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldHashFormat.setBounds(new Rectangle(140, 9, 300, 25));
        this.jTextFieldHashFormat.setEditable(false);
        this.jLabelValue.setText(res.getString("HashFormatValue"));
        this.jLabelValue.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelValue.setHorizontalAlignment(4);
        this.jLabelValue.setHorizontalTextPosition(10);
        this.jLabelValue.setBounds(new Rectangle(5, 43, 130, 20));
        this.jTextFieldValue.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldValue.setBounds(new Rectangle(140, 40, 300, 25));
        this.jLabelSalt.setText(res.getString("HashFormatSalt"));
        this.jLabelSalt.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSalt.setHorizontalAlignment(4);
        this.jLabelSalt.setHorizontalTextPosition(10);
        this.jLabelSalt.setBounds(new Rectangle(5, 74, 130, 20));
        this.jTextFieldSalt.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldSalt.setBounds(new Rectangle(140, 71, 300, 25));
        this.jButtonHash.setBounds(new Rectangle(440, 70, 100, 27));
        this.jButtonHash.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonHash.setText("Hash");
        this.jButtonHash.addActionListener(new DialogCheckHashFormat_jButtonHash_actionAdapter(this));
        this.jScrollPaneMessage.setBounds(new Rectangle(10, 102, 530, 70));
        this.jScrollPaneMessage.getViewport().add(this.jTextAreaMessage);
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setWrapStyleWord(true);
        this.jTextAreaMessage.setOpaque(false);
        this.jTextAreaMessage.setEditable(false);
        this.panelMain.setBorder(null);
        this.panelMain.setLayout(null);
        this.panelMain.add(this.jLabelHashFormat);
        this.panelMain.add(this.jTextFieldHashFormat);
        this.panelMain.add(this.jLabelValue);
        this.panelMain.add(this.jTextFieldValue);
        this.panelMain.add(this.jLabelSalt);
        this.panelMain.add(this.jTextFieldSalt);
        this.panelMain.add(this.jButtonHash);
        this.panelMain.add(this.jScrollPaneMessage);
        this.setTitle(res.getString("HashFormatTitle"));
        this.setResizable(false);
        this.setPreferredSize(new Dimension(555, 220));
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.pack();
    }

    public void request(String hashFormat) {
        this.digestAlgorithm = "MD5";
        this.countOfExpand = 1;
        this.isValueSalted = false;
        this.digestAdapter = null;
        this.jTextFieldValue.setEditable(true);
        this.jTextFieldValue.setEnabled(true);
        this.jTextFieldSalt.setEditable(true);
        this.jTextFieldSalt.setEnabled(true);
        this.jButtonHash.setEnabled(true);
        this.jTextAreaMessage.setText(res.getString("HashFormatMessage1"));
        try {
            if (hashFormat.equals("") || hashFormat.toUpperCase().equals("*DEFAULT")) {
                this.jTextFieldHashFormat.setText("*Default(MD5;1;false)");
            } else {
                StringTokenizer workTokenizer = new StringTokenizer(hashFormat, ";");
                this.digestAlgorithm = workTokenizer.nextToken();
                if (workTokenizer.hasMoreTokens()) {
                    this.countOfExpand = Integer.parseInt(workTokenizer.nextToken());
                }
                if (workTokenizer.hasMoreTokens()) {
                    this.isValueSalted = Boolean.parseBoolean(workTokenizer.nextToken());
                }
                this.jTextFieldHashFormat.setText(String.valueOf(this.digestAlgorithm) + ";" + this.countOfExpand + ";" + this.isValueSalted);
            }
            this.digestAdapter = new DigestAdapter(this.digestAlgorithm);
        }
        catch (Exception e) {
            this.jTextFieldHashFormat.setText(hashFormat);
            this.jTextFieldValue.setEditable(false);
            this.jTextFieldValue.setEnabled(false);
            this.jTextFieldSalt.setEditable(false);
            this.jTextFieldSalt.setEnabled(false);
            this.jButtonHash.setEnabled(false);
            this.jTextAreaMessage.setText(res.getString("HashFormatMessage2"));
        }
        if (!this.isValueSalted) {
            this.jTextFieldSalt.setText("");
            this.jTextFieldSalt.setEditable(false);
            this.jTextFieldSalt.setEnabled(false);
        }
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.frame_.getSize();
        Point loc = this.frame_.getLocation();
        this.getRootPane().setDefaultButton(this.jButtonHash);
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.setVisible(true);
    }

    void jButtonHash_actionPerformed(ActionEvent e) {
        if (this.digestAdapter != null) {
            String digestedValue = "";
            int count = this.countOfExpand - 1;
            digestedValue = this.digestAdapter.digest(String.valueOf(this.jTextFieldValue.getText()) + this.jTextFieldSalt.getText());
            int i = 0;
            while (i < count) {
                digestedValue = this.digestAdapter.digest(String.valueOf(digestedValue) + this.jTextFieldSalt.getText());
                ++i;
            }
            this.jTextAreaMessage.setText(digestedValue);
        }
    }
}

