/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogCheckLayoutColumn;
import xeadEditor.DialogCheckLayoutDetailTable;
import xeadEditor.DialogCheckLayoutField;
import xeadEditor.DialogCheckLayoutFilter;
import xeadEditor.DialogCheckLayoutPrimaryTable;
import xeadEditor.DialogCheckLayoutReferTable;
import xeadEditor.Editor;

public class DialogCheckLayout
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    public static final int FIELD_UNIT_HEIGHT = 25;
    public static final int FIELD_HORIZONTAL_MARGIN = 1;
    public static final int FIELD_VERTICAL_MARGIN = 5;
    public static final int DEFAULT_LABEL_WIDTH = 150;
    public static final int ROW_UNIT_HEIGHT = 25;
    public static final int SEQUENCE_WIDTH = 45;
    public static final int FONT_SIZE = 18;
    private static ImageIcon ICON_CHECK_0A = new ImageIcon(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("iCheck0A.PNG")));
    private static ImageIcon ICON_CHECK_1A = new ImageIcon(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("iCheck1A.PNG")));
    private static ImageIcon ICON_CHECK_0D = new ImageIcon(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("iCheck0D.PNG")));
    private static ImageIcon ICON_CHECK_1D = new ImageIcon(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("iCheck1D.PNG")));
    private static ImageIcon ICON_CHECK_0R = new ImageIcon(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("iCheck0R.PNG")));
    private static ImageIcon ICON_CHECK_1R = new ImageIcon(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("iCheck1R.PNG")));
    private JPanel jPanelMain = new JPanel();
    private JTable jTableMain = new JTable();
    private JScrollPane jScrollPane = new JScrollPane();
    private Editor editor;
    private Element functionElement;
    private StringTokenizer workTokenizer;
    private Editor.SortableDomElementListModel sortableList;
    private DialogCheckLayoutPrimaryTable primaryTable;
    private DialogCheckLayoutDetailTable detailTable;
    private ArrayList<DialogCheckLayoutReferTable> referTableList1 = new ArrayList();
    private ArrayList<DialogCheckLayoutReferTable> referTableList2 = new ArrayList();
    private Rectangle screenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    private String panelType_ = "";
    private int extForXF110_ = 0;
    private ArrayList<DialogCheckLayoutColumn> columnList = null;
    private ArrayList<DialogCheckLayoutFilter> filterList = null;
    public String driverFontName_;

    public DialogCheckLayout(Editor parent) {
        super(parent, "", true);
        this.enableEvents(64L);
        try {
            this.editor = parent;
            this.jbInit(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(Editor parent) throws Exception {
        this.jPanelMain.setLayout(null);
        this.jTableMain.setAutoResizeMode(0);
        this.jTableMain.setRowHeight(25);
        this.setResizable(false);
        this.setTitle(res.getString("CheckLayoutTitle"));
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(Editor.class.getResource("title.png")));
        this.setPreferredSize(new Dimension(233, 167));
        this.getContentPane().add((Component)this.jScrollPane, "Center");
    }

    public void request(Editor.MainTreeNode node, String panelType, int tabIndex, int extForXF110, String driverFontName) {
        Element element;
        NodeList detailTableList;
        this.driverFontName_ = driverFontName;
        this.jTableMain.setFont(new Font(this.driverFontName_, 0, 18));
        this.jTableMain.getTableHeader().setFont(new Font(this.driverFontName_, 0, 18));
        this.jTableMain.getTableHeader().setResizingAllowed(false);
        this.jTableMain.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer rendererTableHeader = (DefaultTableCellRenderer)this.jTableMain.getTableHeader().getDefaultRenderer();
        rendererTableHeader.setHorizontalAlignment(2);
        this.functionElement = node.getElement();
        this.panelType_ = panelType;
        this.extForXF110_ = extForXF110;
        this.referTableList1.clear();
        this.referTableList2.clear();
        this.detailTable = null;
        if (this.panelType_.equals("Function100ColumnList")) {
            this.showLayoutOfTableColumns(this.functionElement.getElementsByTagName("Column"));
        }
        if (this.panelType_.equals("Function100FilterList")) {
            this.showLayoutOfTableFilters(this.functionElement.getElementsByTagName("Filter"));
        }
        if (this.panelType_.equals("Function110ColumnList")) {
            this.showLayoutOfTableColumns(this.functionElement.getElementsByTagName("Column"));
        }
        if (this.panelType_.equals("Function110FilterList")) {
            this.showLayoutOfTableFilters(this.functionElement.getElementsByTagName("Filter"));
        }
        if (this.panelType_.equals("Function110BatchFieldList")) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("BatchField"), true, true);
        }
        if (this.panelType_.equals("Function200FieldList")) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("Field"), true, false);
        }
        if (this.panelType_.equals("Function200TabFieldList")) {
            this.showLayoutOfPanelFields(this.editor.getFunction200TabFieldList(), true, false);
        }
        if (this.panelType_.equals("Function300HeaderFieldList")) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("Field"), false, false);
        }
        if (this.panelType_.equals("Function300DetailFieldList") && tabIndex >= 0) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("Field"), false, false);
            detailTableList = this.functionElement.getElementsByTagName("Detail");
            this.sortableList = this.editor.getSortedListModel(detailTableList, "Order");
            element = (Element)this.sortableList.getElementAt(tabIndex);
            this.detailTable = new DialogCheckLayoutDetailTable(element.getAttribute("Table"), element.getAttribute("KeyFields"), this);
            this.showLayoutOfTableColumns(element.getElementsByTagName("Column"));
        }
        if (this.panelType_.equals("Function300DetailFilterList") && tabIndex >= 0) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("Field"), false, false);
            detailTableList = this.functionElement.getElementsByTagName("Detail");
            this.sortableList = this.editor.getSortedListModel(detailTableList, "Order");
            element = (Element)this.sortableList.getElementAt(tabIndex);
            this.detailTable = new DialogCheckLayoutDetailTable(element.getAttribute("Table"), element.getAttribute("KeyFields"), this);
            this.showLayoutOfTableFilters(element.getElementsByTagName("Filter"));
        }
        if (this.panelType_.equals("Function310HeaderFieldList")) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("Field"), true, false);
        }
        if (this.panelType_.equals("Function310DetailFieldList")) {
            this.showLayoutOfPanelFields(this.functionElement.getElementsByTagName("Field"), true, false);
            this.detailTable = new DialogCheckLayoutDetailTable(this.functionElement.getAttribute("DetailTable"), this.functionElement.getAttribute("DetailKeyFields"), this);
            this.showLayoutOfTableColumns(this.functionElement.getElementsByTagName("Column"));
        }
    }

    public int getExtForXF110() {
        return this.extForXF110_;
    }

    private void showLayoutOfTableColumns(NodeList functionColumnList) {
        if (!this.functionElement.getAttribute("Size").equals("") && !this.functionElement.getAttribute("Size").equals("AUTO")) {
            this.workTokenizer = new StringTokenizer(this.functionElement.getAttribute("Size"), ";");
            int width = Integer.parseInt(this.workTokenizer.nextToken());
            int height = Integer.parseInt(this.workTokenizer.nextToken());
            this.setPreferredSize(new Dimension(width, height));
            int posX = (this.screenRect.width - width) / 2 + this.screenRect.x;
            int posY = (this.screenRect.height - height) / 2 + this.screenRect.y;
            this.setLocation(posX, posY);
            this.pack();
        }
        this.primaryTable = new DialogCheckLayoutPrimaryTable(this.functionElement, this, false);
        NodeList referNodeList = this.primaryTable.getTableElement().getElementsByTagName("Refer");
        this.sortableList = this.editor.getSortedListModel(referNodeList, "Order");
        int i = 0;
        while (i < this.sortableList.getSize()) {
            Element element = (Element)this.sortableList.getElementAt(i);
            this.referTableList1.add(new DialogCheckLayoutReferTable(element));
            ++i;
        }
        if (this.panelType_.equals("Function300DetailFieldList") || this.panelType_.equals("Function310DetailFieldList")) {
            referNodeList = this.detailTable.getTableElement().getElementsByTagName("Refer");
            this.sortableList = this.editor.getSortedListModel(referNodeList, "Order");
            i = 0;
            while (i < this.sortableList.getSize()) {
                Element element = (Element)this.sortableList.getElementAt(i);
                this.referTableList2.add(new DialogCheckLayoutReferTable(element));
                ++i;
            }
        }
        this.columnList = new ArrayList();
        this.sortableList = this.editor.getSortedListModel(functionColumnList, "Order");
        int i2 = 0;
        while (i2 < this.sortableList.getSize()) {
            ArrayList<String> optionList = this.editor.getOptionList(((Element)this.sortableList.getElementAt(i2)).getAttribute("FieldOptions"));
            if (!optionList.contains("HIDDEN")) {
                DialogCheckLayoutColumn field = new DialogCheckLayoutColumn((Element)this.sortableList.getElementAt(i2), this);
                this.columnList.add(field);
            }
            ++i2;
        }
        Editor.TableModelReadOnlyList tableModel = new Editor.TableModelReadOnlyList(this.editor);
        this.jTableMain.setModel(tableModel);
        this.jScrollPane.getViewport().add((Component)this.jTableMain, null);
        tableModel.addColumn("");
        TableColumn column = this.jTableMain.getColumnModel().getColumn(0);
        HeadersRenderer headersRenderer = this.extForXF110_ == 1 ? new HeadersRenderer(true) : new HeadersRenderer(false);
        CellsRenderer cellsRenderer = new CellsRenderer(headersRenderer);
        column.setHeaderRenderer(headersRenderer);
        column.setCellRenderer(cellsRenderer);
        column.setPreferredWidth(headersRenderer.getWidth());
        int biggestWidth = headersRenderer.getWidth();
        int r = 0;
        while (r < 4) {
            Object[] cell = new Object[]{Integer.toString(r + 1)};
            tableModel.addRow(cell);
            ++r;
        }
        this.jTableMain.setRowHeight(headersRenderer.getHeight());
        int workHeight = headersRenderer.getHeight() * 6 + 30;
        this.jTableMain.setRowSelectionInterval(0, 0);
        if (this.panelType_.equals("Function300DetailFieldList") || this.panelType_.equals("Function310DetailFieldList")) {
            int posY = (this.screenRect.height - workHeight) / 2 + this.screenRect.y;
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, workHeight));
            this.setLocation(this.getLocation().x, posY);
        } else {
            int posX;
            int workWidth = biggestWidth + 50;
            if (this.functionElement.getAttribute("Size").equals("")) {
                workWidth = this.screenRect.width;
                posX = this.screenRect.x;
            } else if (this.functionElement.getAttribute("Size").equals("AUTO")) {
                if (workWidth > this.screenRect.width) {
                    workWidth = this.screenRect.width;
                    posX = this.screenRect.x;
                } else {
                    posX = (this.screenRect.width - workWidth) / 2 + this.screenRect.x;
                }
                if (workHeight > this.screenRect.height) {
                    workHeight = this.screenRect.height;
                }
            } else {
                workWidth = this.getPreferredSize().width;
                posX = this.getLocation().x;
            }
            int posY = (this.screenRect.height - workHeight) / 2 + this.screenRect.y;
            this.setPreferredSize(new Dimension(workWidth, workHeight));
            this.setLocation(posX, posY);
        }
        this.pack();
        super.setVisible(true);
    }

    private void showLayoutOfTableFilters(NodeList functionFilterList) {
        this.primaryTable = new DialogCheckLayoutPrimaryTable(this.functionElement, this, false);
        NodeList referNodeList = this.primaryTable.getTableElement().getElementsByTagName("Refer");
        this.sortableList = this.editor.getSortedListModel(referNodeList, "Order");
        int i = 0;
        while (i < this.sortableList.getSize()) {
            Element element = (Element)this.sortableList.getElementAt(i);
            this.referTableList1.add(new DialogCheckLayoutReferTable(element));
            ++i;
        }
        int maxWidth = 0;
        int maxHeight = 0;
        int posX = 0;
        int posY = 8;
        int wrkInt = 0;
        Dimension dimOfPriviousField = new Dimension(0, 0);
        this.filterList = new ArrayList();
        this.jPanelMain.removeAll();
        this.jScrollPane.getViewport().add((Component)this.jPanelMain, null);
        this.sortableList = this.editor.getSortedListModel(functionFilterList, "Order");
        int i2 = 0;
        while (i2 < this.sortableList.getSize()) {
            DialogCheckLayoutFilter filter = new DialogCheckLayoutFilter((Element)this.sortableList.getElementAt(i2), this);
            this.filterList.add(filter);
            if (!filter.isHidden()) {
                if (wrkInt > 0) {
                    if (filter.isVerticalPosition()) {
                        posX = 0;
                        posY = posY + dimOfPriviousField.height + filter.getVerticalMargin();
                    } else {
                        posX += dimOfPriviousField.width;
                    }
                }
                Dimension dim = filter.getPreferredSize();
                dimOfPriviousField = new Dimension(dim.width, dim.height);
                filter.setBounds(posX, posY, dim.width, dim.height);
                this.jPanelMain.add(filter);
                if (posX + dim.width > maxWidth) {
                    maxWidth = posX + dim.width;
                }
                if (posY + dim.height > maxHeight) {
                    maxHeight = posY + dim.height;
                }
                ++wrkInt;
            }
            ++i2;
        }
        this.jPanelMain.setPreferredSize(new Dimension(maxWidth, maxHeight));
        if (this.panelType_.equals("Function300DetailFilterList")) {
            int workHeight = maxHeight + 60;
            if (workHeight > this.screenRect.height) {
                workHeight = this.screenRect.height;
                posY = this.screenRect.y;
            } else {
                posY = (this.screenRect.height - workHeight) / 2 + this.screenRect.y;
            }
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, workHeight));
            this.setLocation(this.getLocation().x, posY);
        } else {
            int workWidth = maxWidth + 50;
            if (this.functionElement.getAttribute("Size").equals("")) {
                workWidth = this.screenRect.width;
                posX = this.screenRect.x;
            } else if (this.functionElement.getAttribute("Size").equals("AUTO")) {
                if (workWidth < 800) {
                    workWidth = 800;
                }
                if (workWidth > this.screenRect.width) {
                    workWidth = this.screenRect.width;
                    posX = this.screenRect.x;
                } else {
                    posX = (this.screenRect.width - workWidth) / 2 + this.screenRect.x;
                }
            } else {
                workWidth = this.getPreferredSize().width;
                posX = this.getLocation().x;
            }
            int workHeight = maxHeight + 60;
            if (workHeight > this.screenRect.height) {
                workHeight = this.screenRect.height;
                posY = this.screenRect.y;
            } else {
                posY = (this.screenRect.height - workHeight) / 2 + this.screenRect.y;
            }
            this.setPreferredSize(new Dimension(workWidth, workHeight));
            this.setLocation(posX, posY);
        }
        this.pack();
        super.setVisible(true);
    }

    private void showLayoutOfPanelFields(NodeList functionFieldList, boolean isOnEditablePanel, boolean isForBatchTable) {
        if (!this.functionElement.getAttribute("Size").equals("") && !this.functionElement.getAttribute("Size").equals("AUTO")) {
            this.workTokenizer = new StringTokenizer(this.functionElement.getAttribute("Size"), ";");
            int width = Integer.parseInt(this.workTokenizer.nextToken());
            int height = Integer.parseInt(this.workTokenizer.nextToken());
            this.setPreferredSize(new Dimension(width, height));
            int posX = (this.screenRect.width - width) / 2 + this.screenRect.x;
            int posY = (this.screenRect.height - height) / 2 + this.screenRect.y;
            this.setLocation(posX, posY);
            this.pack();
        }
        this.primaryTable = new DialogCheckLayoutPrimaryTable(this.functionElement, this, isForBatchTable);
        NodeList referNodeList = this.primaryTable.getTableElement().getElementsByTagName("Refer");
        this.sortableList = this.editor.getSortedListModel(referNodeList, "Order");
        int i = 0;
        while (i < this.sortableList.getSize()) {
            Element element = (Element)this.sortableList.getElementAt(i);
            this.referTableList1.add(new DialogCheckLayoutReferTable(element));
            ++i;
        }
        this.jPanelMain.removeAll();
        this.jScrollPane.getViewport().add((Component)this.jPanelMain, null);
        Dimension dimOfPriviousField = new Dimension(0, 0);
        Dimension dim = new Dimension(0, 0);
        int posX = 0;
        int posY = 0;
        int biggestWidth = 300;
        int biggestHeight = 50;
        boolean firstVisibleField = true;
        this.sortableList = this.editor.getSortedListModel(functionFieldList, "Order");
        int i2 = 0;
        while (i2 < this.sortableList.getSize()) {
            DialogCheckLayoutField field = new DialogCheckLayoutField((Element)this.sortableList.getElementAt(i2), isOnEditablePanel, this);
            if (firstVisibleField) {
                posX = 0;
                posY = 8;
                firstVisibleField = false;
            } else if (field.isHorizontal()) {
                posX = posX + dimOfPriviousField.width + field.getPositionMargin() + 1;
            } else {
                posX = 0;
                posY = posY + dimOfPriviousField.height + field.getPositionMargin() + 5;
            }
            dim = field.getPreferredSize();
            field.setBounds(posX, posY, dim.width, dim.height);
            if (posX + dim.width > biggestWidth) {
                biggestWidth = posX + dim.width;
            }
            if (posY + dim.height > biggestHeight) {
                biggestHeight = posY + dim.height;
            }
            dimOfPriviousField = field.isHorizontal() ? new Dimension(dim.width, 25) : new Dimension(dim.width, dim.height);
            this.jPanelMain.add(field);
            ++i2;
        }
        this.jPanelMain.setPreferredSize(new Dimension(biggestWidth, biggestHeight));
        int workWidth = biggestWidth + 50;
        if (this.functionElement.getAttribute("Size").equals("")) {
            workWidth = this.screenRect.width;
            posX = this.screenRect.x;
        } else if (this.functionElement.getAttribute("Size").equals("AUTO")) {
            if (workWidth < 800) {
                workWidth = 800;
            }
            if (workWidth > this.screenRect.width) {
                workWidth = this.screenRect.width;
                posX = this.screenRect.x;
            } else {
                posX = (this.screenRect.width - workWidth) / 2 + this.screenRect.x;
            }
        } else {
            workWidth = this.getPreferredSize().width;
            posX = this.getLocation().x;
        }
        int workHeight = biggestHeight + 60;
        if (workHeight > this.screenRect.height) {
            workHeight = this.screenRect.height;
            posY = this.screenRect.y;
        } else {
            posY = (this.screenRect.height - workHeight) / 2 + this.screenRect.y;
        }
        this.setPreferredSize(new Dimension(workWidth, workHeight));
        this.setLocation(posX, posY);
        if (!(this.panelType_.equals("Function300DetailFieldList") || this.panelType_.equals("Function300DetailFilterList") || this.panelType_.equals("Function310DetailFieldList"))) {
            this.pack();
            super.setVisible(true);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    public Element getFunctionElement() {
        return this.functionElement;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public DialogCheckLayoutPrimaryTable getPrimaryTable() {
        return this.primaryTable;
    }

    public ArrayList<DialogCheckLayoutReferTable> getReferTableList() {
        return this.referTableList1;
    }

    public ArrayList<DialogCheckLayoutFilter> getFilterList() {
        return this.filterList;
    }

    public String getTableIDOfTableAlias(String tableAlias) {
        DialogCheckLayoutReferTable referTable;
        String tableID = tableAlias;
        int j = 0;
        while (j < this.referTableList1.size()) {
            referTable = this.referTableList1.get(j);
            if (referTable.getTableAlias().equals(tableAlias)) {
                tableID = referTable.getTableID();
                break;
            }
            ++j;
        }
        j = 0;
        while (j < this.referTableList2.size()) {
            referTable = this.referTableList2.get(j);
            if (referTable.getTableAlias().equals(tableAlias)) {
                tableID = referTable.getTableID();
                break;
            }
            ++j;
        }
        return tableID;
    }

    public int getFieldUnitHeight() {
        return 25;
    }

    public int getFieldVerticalMargin() {
        return 5;
    }

    static int adjustFontSizeToGetPreferredWidthOfLabel(JLabel jLabel, int initialWidth) {
        int width = initialWidth;
        int initialFontSize = jLabel.getFont().getSize();
        FontMetrics metrics = jLabel.getFontMetrics(jLabel.getFont());
        if (metrics.stringWidth(jLabel.getText()) > width) {
            int i = initialFontSize;
            while (i > 10) {
                jLabel.setFont(new Font(jLabel.getFont().getFontName(), 0, jLabel.getFont().getSize() - 1));
                metrics = jLabel.getFontMetrics(jLabel.getFont());
                if (metrics.stringWidth(jLabel.getText()) <= width) break;
                --i;
            }
        }
        return metrics.stringWidth(jLabel.getText());
    }

    public String getStringData(String type, int dataSize, int decimal, ArrayList<String> dataTypeOptionList) {
        int i;
        String value = "";
        StringBuffer bf = new StringBuffer();
        if (type.equals("KANJI")) {
            i = 0;
            while (i < dataSize) {
                bf.append("\uff38");
                ++i;
            }
            value = bf.toString();
        }
        if (type.equals("STRING")) {
            i = 0;
            while (i < dataSize) {
                bf.append("X");
                ++i;
            }
            value = bf.toString();
        }
        if (type.equals("NUMBER")) {
            if (decimal > 0) {
                i = 0;
                while (i < decimal) {
                    bf.append("9");
                    ++i;
                }
                bf.append(".");
            }
            int intSize = dataSize - decimal;
            if (dataTypeOptionList != null && dataTypeOptionList.contains("HH_MM")) {
                bf.append("99:99");
            } else {
                int i2 = 1;
                while (i2 <= intSize) {
                    bf.append("9");
                    if (dataTypeOptionList != null && !dataTypeOptionList.contains("NO_EDIT") && !dataTypeOptionList.contains("ZERO_SUPPRESS") && i2 % 3 == 0 && i2 < intSize) {
                        bf.append(",");
                    }
                    ++i2;
                }
            }
            if (dataTypeOptionList != null && dataTypeOptionList.contains("ACCEPT_MINUS")) {
                bf.append("-");
            }
            value = bf.reverse().toString();
        }
        return value;
    }

    public ImageIcon getCheckBoxIcon(String type) {
        ImageIcon image = null;
        if (type.equals("0A")) {
            image = ICON_CHECK_0A;
        }
        if (type.equals("1A")) {
            image = ICON_CHECK_1A;
        }
        if (type.equals("0D")) {
            image = ICON_CHECK_0D;
        }
        if (type.equals("1D")) {
            image = ICON_CHECK_1D;
        }
        if (type.equals("0R")) {
            image = ICON_CHECK_0R;
        }
        if (type.equals("1R")) {
            image = ICON_CHECK_1R;
        }
        return image;
    }

    public String getDateValue(String dateFormat) {
        SimpleDateFormat formatter;
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        StringBuffer buf = new StringBuffer();
        if (dateFormat.equals("")) {
            formatter = new SimpleDateFormat("yyyy-MM-dd", new Locale("en", "US", "US"));
            buf.append(formatter.format(cal.getTime()));
        }
        if (dateFormat.equals("en00") || dateFormat.equals("en01")) {
            if (dateFormat.equals("en01")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
            formatter = new SimpleDateFormat("MM/dd/yy", new Locale("en", "US", "US"));
            buf.append(formatter.format(cal.getTime()));
        }
        if (dateFormat.equals("en10") || dateFormat.equals("en11")) {
            if (dateFormat.equals("en11")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
            formatter = new SimpleDateFormat("MMMdd,yyyy", new Locale("en", "US", "US"));
            buf.append(formatter.format(cal.getTime()));
        }
        if (dateFormat.equals("jp00") || dateFormat.equals("jp01")) {
            formatter = new SimpleDateFormat("yy/MM/dd");
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp01")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp10") || dateFormat.equals("jp11")) {
            formatter = new SimpleDateFormat("yyyy/MM/dd");
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp11")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
            formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp21")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp30") || dateFormat.equals("jp31")) {
            formatter = new SimpleDateFormat("Gyy/MM/dd", new Locale("ja", "JP", "JP"));
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp31")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp40") || dateFormat.equals("jp41")) {
            formatter = new SimpleDateFormat("Gyy\u5e74MM\u6708dd\u65e5", new Locale("ja", "JP", "JP"));
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp41")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
        }
        if (dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
            formatter = new SimpleDateFormat("GGGGyy\u5e74MM\u6708dd\u65e5", new Locale("ja", "JP", "JP"));
            buf.append(formatter.format(cal.getTime()));
            if (dateFormat.equals("jp51")) {
                buf.append(DialogCheckLayout.getDayOfWeek(cal, dateFormat));
            }
        }
        return buf.toString();
    }

    static String getDayOfWeek(Calendar cal, String dateFormat) {
        String result = "";
        String language = dateFormat.substring(0, 2);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            if (language.equals("jp")) {
                result = "(\u65e5)";
            }
            if (language.equals("en")) {
                result = "Sun,";
            }
        }
        if (dayOfWeek == 2) {
            if (language.equals("jp")) {
                result = "(\u6708)";
            }
            if (language.equals("en")) {
                result = "Mon,";
            }
        }
        if (dayOfWeek == 3) {
            if (language.equals("jp")) {
                result = "(\u706b)";
            }
            if (language.equals("en")) {
                result = "Tue,";
            }
        }
        if (dayOfWeek == 4) {
            if (language.equals("jp")) {
                result = "(\u6c34)";
            }
            if (language.equals("en")) {
                result = "Wed,";
            }
        }
        if (dayOfWeek == 5) {
            if (language.equals("jp")) {
                result = "(\u6728)";
            }
            if (language.equals("en")) {
                result = "Thur,";
            }
        }
        if (dayOfWeek == 6) {
            if (language.equals("jp")) {
                result = "(\u91d1)";
            }
            if (language.equals("en")) {
                result = "Fri,";
            }
        }
        if (dayOfWeek == 7) {
            if (language.equals("jp")) {
                result = "(\u571f)";
            }
            if (language.equals("en")) {
                result = "Sat,";
            }
        }
        return result;
    }

    public String getUserExpressionOfYearMonth(String yearMonth, String dateFormat) {
        SimpleDateFormat formatter;
        Calendar cal;
        int month;
        int year;
        String result = "";
        if (yearMonth.length() == 6) {
            year = Integer.parseInt(yearMonth.substring(0, 4));
            month = Integer.parseInt(yearMonth.substring(4, 6)) - 1;
            cal = Calendar.getInstance();
            cal.set(year, month, 1);
            if (dateFormat.equals("en00") || dateFormat.equals("en01") || dateFormat.equals("en10") || dateFormat.equals("en11")) {
                formatter = new SimpleDateFormat("MMM,yyyy", new Locale("en", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp00") || dateFormat.equals("jp01") || dateFormat.equals("jp10") || dateFormat.equals("jp11") || dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
                formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708", new Locale("ja", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp30") || dateFormat.equals("jp31") || dateFormat.equals("jp40") || dateFormat.equals("jp41") || dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
                formatter = new SimpleDateFormat("Gyy\u5e74MM\u6708", new Locale("ja", "JP", "JP"));
                result = formatter.format(cal.getTime());
            }
        }
        if (yearMonth.length() == 4) {
            year = Integer.parseInt(yearMonth.substring(0, 4));
            month = 0;
            cal = Calendar.getInstance();
            cal.set(year, month, 1);
            if (dateFormat.equals("en00") || dateFormat.equals("en01") || dateFormat.equals("en10") || dateFormat.equals("en11")) {
                formatter = new SimpleDateFormat("fiscal yyyy", new Locale("en", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp00") || dateFormat.equals("jp01") || dateFormat.equals("jp10") || dateFormat.equals("jp11") || dateFormat.equals("jp20") || dateFormat.equals("jp21")) {
                formatter = new SimpleDateFormat("yyyy\u5e74\u5ea6", new Locale("ja", "US", "US"));
                result = formatter.format(cal.getTime());
            }
            if (dateFormat.equals("jp30") || dateFormat.equals("jp31") || dateFormat.equals("jp40") || dateFormat.equals("jp41") || dateFormat.equals("jp50") || dateFormat.equals("jp51")) {
                formatter = new SimpleDateFormat("Gyy\u5e74\u5ea6", new Locale("ja", "JP", "JP"));
                result = formatter.format(cal.getTime());
            }
        }
        return result;
    }

    class CellBorder
    implements Border {
        CellBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.gray);
            g.drawLine(x + width - 1, y + height + 1, x + width - 1, y);
        }
    }

    public class CellsRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JPanel westPanel = new JPanel();
        private JLabel numberCell = new JLabel("");
        private JPanel checkBoxPanel = new JPanel();
        private JCheckBox checkBox = new JCheckBox();
        private JPanel centerPanel = new JPanel();
        private ArrayList<JLabel> cellList = new ArrayList();
        private HeadersRenderer headersRenderer_;

        public CellsRenderer(HeadersRenderer headersRenderer) {
            int widthOfCenterPanel;
            this.headersRenderer_ = headersRenderer;
            this.numberCell.setFont(new Font(DialogCheckLayout.this.driverFontName_, 0, 18));
            this.numberCell.setBorder(new CellBorder());
            this.numberCell.setHorizontalAlignment(0);
            this.numberCell.setOpaque(true);
            this.setLayout(new BorderLayout());
            if (this.headersRenderer_.isWithCheckBox_) {
                GridLayout layout = new GridLayout();
                layout.setColumns(2);
                layout.setRows(1);
                this.westPanel.setLayout(layout);
                this.checkBox.setHorizontalAlignment(0);
                this.checkBoxPanel.setBorder(new CellBorder());
                this.checkBoxPanel.setLayout(new BorderLayout());
                this.checkBoxPanel.add((Component)this.checkBox, "Center");
                this.westPanel.add(this.numberCell);
                this.westPanel.add(this.checkBoxPanel);
            }
            this.centerPanel.setLayout(null);
            this.centerPanel.setOpaque(false);
            this.cellList.clear();
            this.centerPanel.removeAll();
            int i = 0;
            while (i < this.headersRenderer_.getColumnHeaderList().size()) {
                JLabel cell = new JLabel();
                cell.setFont(new Font(DialogCheckLayout.this.driverFontName_, 0, 18));
                cell.setHorizontalAlignment(this.headersRenderer_.getColumnHeaderList().get(i).getHorizontalAlignment());
                Rectangle rec = this.headersRenderer_.getColumnHeaderList().get(i).getBounds();
                cell.setBounds(rec.x, rec.y, rec.width, rec.height);
                cell.setBorder(new HeaderBorder());
                this.cellList.add(cell);
                this.centerPanel.add(cell);
                ++i;
            }
            if (this.headersRenderer_.isWithCheckBox()) {
                widthOfCenterPanel = this.headersRenderer_.getWidth() - this.headersRenderer_.getSequenceWidth() * 2;
                this.centerPanel.setPreferredSize(new Dimension(widthOfCenterPanel, this.headersRenderer_.getHeight()));
                this.westPanel.setPreferredSize(new Dimension(this.headersRenderer_.getSequenceWidth() * 2, this.headersRenderer_.getHeight()));
                this.add((Component)this.westPanel, "West");
            } else {
                widthOfCenterPanel = this.headersRenderer_.getWidth() - this.headersRenderer_.getSequenceWidth();
                this.centerPanel.setPreferredSize(new Dimension(widthOfCenterPanel, this.headersRenderer_.getHeight()));
                this.numberCell.setPreferredSize(new Dimension(this.headersRenderer_.getSequenceWidth(), this.headersRenderer_.getHeight()));
                this.add((Component)this.numberCell, "West");
            }
            this.add((Component)this.centerPanel, "Center");
            this.setPreferredSize(new Dimension(this.headersRenderer_.getWidth(), this.headersRenderer_.getHeight()));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.numberCell.setBackground(table.getSelectionBackground());
                this.checkBox.setBackground(table.getSelectionBackground());
                this.numberCell.setForeground(table.getSelectionForeground());
            } else {
                if (row % 2 == 0) {
                    this.setBackground(table.getBackground());
                    this.numberCell.setBackground(table.getBackground());
                    this.checkBox.setBackground(table.getBackground());
                } else {
                    Color bg = new Color(240, 240, 255);
                    this.setBackground(bg);
                    this.numberCell.setBackground(bg);
                    this.checkBox.setBackground(bg);
                }
                this.numberCell.setForeground(table.getForeground());
            }
            this.setFocusable(false);
            String rowNumber = (String)value;
            this.numberCell.setText(rowNumber);
            int i = 0;
            while (i < this.cellList.size()) {
                this.cellList.get(i).setText(((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getValue().toString());
                if (isSelected) {
                    this.cellList.get(i).setForeground(table.getSelectionForeground());
                } else {
                    this.cellList.get(i).setForeground(table.getForeground());
                }
                ++i;
            }
            return this;
        }
    }

    class HeaderBorder
    implements Border {
        HeaderBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.white);
            g.drawLine(x, y, x + width, y);
            g.drawLine(x, y, x, y + height);
            g.setColor(Color.gray);
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
            g.drawLine(x + width - 1, y + height, x + width - 1, y);
        }
    }

    class HeadersRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JPanel westPanel = new JPanel();
        private JLabel numberLabel = new JLabel("No.");
        private JPanel checkBoxPanel = new JPanel();
        private JCheckBox checkBox = new JCheckBox();
        private JPanel centerPanel = new JPanel();
        private ArrayList<JLabel> headerList = new ArrayList();
        private int totalWidthOfCenterPanel = 0;
        private int totalHeight = 0;
        private boolean isWithCheckBox_;

        public HeadersRenderer(boolean isWithCheckBox) {
            int workWidth;
            this.isWithCheckBox_ = isWithCheckBox;
            this.setupColumnBoundsAndHeaderHeight();
            this.setLayout(new BorderLayout());
            if (this.isWithCheckBox_) {
                GridLayout layout = new GridLayout();
                layout.setColumns(2);
                layout.setRows(1);
                this.westPanel.setLayout(layout);
                this.westPanel.setPreferredSize(new Dimension(90, 10));
                this.numberLabel.setFont(new Font(DialogCheckLayout.this.driverFontName_, 0, 18));
                this.numberLabel.setBorder(new HeaderBorder());
                this.numberLabel.setHorizontalAlignment(0);
                this.checkBox.setHorizontalAlignment(0);
                this.checkBoxPanel.setBorder(new HeaderBorder());
                this.checkBoxPanel.setLayout(new BorderLayout());
                this.checkBoxPanel.add((Component)this.checkBox, "Center");
                this.westPanel.add(this.numberLabel);
                this.westPanel.add(this.checkBoxPanel);
                workWidth = 90;
                this.westPanel.setPreferredSize(new Dimension(workWidth, this.totalHeight));
                this.add((Component)this.westPanel, "West");
            } else {
                this.centerPanel.setLayout(null);
                this.numberLabel.setFont(new Font(DialogCheckLayout.this.driverFontName_, 0, 18));
                this.numberLabel.setBorder(new HeaderBorder());
                this.numberLabel.setHorizontalAlignment(0);
                workWidth = 45;
                this.numberLabel.setPreferredSize(new Dimension(workWidth, this.totalHeight));
                this.add((Component)this.numberLabel, "West");
            }
            this.centerPanel.setLayout(null);
            this.setPreferredSize(new Dimension(this.totalWidthOfCenterPanel + workWidth, this.totalHeight));
            this.add((Component)this.centerPanel, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }

        @Override
        public int getWidth() {
            return this.getPreferredSize().width;
        }

        public int getSequenceWidth() {
            return 45;
        }

        public String getSequenceLabel() {
            return this.numberLabel.getText();
        }

        public boolean isWithCheckBox() {
            return this.isWithCheckBox_;
        }

        @Override
        public int getHeight() {
            return this.getPreferredSize().height;
        }

        public ArrayList<JLabel> getColumnHeaderList() {
            return this.headerList;
        }

        public void setupColumnBoundsAndHeaderHeight() {
            int fromX = 0;
            int fromY = 0;
            this.totalWidthOfCenterPanel = 0;
            this.centerPanel.removeAll();
            this.headerList.clear();
            int i = 0;
            while (i < DialogCheckLayout.this.columnList.size()) {
                JLabel header = new JLabel();
                header.setFont(new Font(DialogCheckLayout.this.driverFontName_, 0, 18));
                if (((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getValueType().equals("IMAGE") || ((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getValueType().equals("FLAG")) {
                    header.setHorizontalAlignment(0);
                    header.setText(((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getCaption());
                } else if (((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getBasicType().equals("INTEGER") || ((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getBasicType().equals("FLOAT")) {
                    header.setHorizontalAlignment(4);
                    header.setText(String.valueOf(((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getCaption()) + " ");
                } else {
                    header.setHorizontalAlignment(2);
                    header.setText(((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getCaption());
                }
                header.setOpaque(true);
                int width = ((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getWidth();
                int height = 25 * ((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getRows();
                if (i > 0) {
                    int wrkInt1;
                    fromX = this.headerList.get((int)(i - 1)).getBounds().x + this.headerList.get((int)(i - 1)).getBounds().width;
                    fromY = this.headerList.get((int)(i - 1)).getBounds().y + this.headerList.get((int)(i - 1)).getBounds().height;
                    int j = i - 1;
                    while (j >= 0) {
                        if (((DialogCheckLayoutColumn)DialogCheckLayout.this.columnList.get(i)).getLayout().equals("VERTICAL")) {
                            wrkInt1 = this.headerList.get((int)j).getBounds().y + this.headerList.get((int)j).getBounds().height;
                            if (wrkInt1 > fromY) break;
                            fromX = this.headerList.get((int)j).getBounds().x;
                        } else {
                            wrkInt1 = this.headerList.get((int)j).getBounds().x + this.headerList.get((int)j).getBounds().width;
                            if (wrkInt1 > fromX) break;
                            fromY = this.headerList.get((int)j).getBounds().y;
                        }
                        --j;
                    }
                    j = i - 1;
                    while (j >= 0) {
                        int wrkInt2 = fromX + width;
                        wrkInt1 = this.headerList.get((int)j).getBounds().x + this.headerList.get((int)j).getBounds().width;
                        if (wrkInt2 < wrkInt1 && wrkInt2 + 2 > wrkInt1) {
                            width = wrkInt1 - fromX;
                        }
                        --j;
                    }
                }
                header.setBounds(new Rectangle(fromX, fromY, width, height));
                header.setBorder(new HeaderBorder());
                this.headerList.add(header);
                this.centerPanel.add(header);
                if (fromX + width > this.totalWidthOfCenterPanel) {
                    this.totalWidthOfCenterPanel = fromX + width;
                }
                if (fromY + height > this.totalHeight) {
                    this.totalHeight = fromY + height;
                }
                ++i;
            }
        }
    }
}

