/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import xeadEditor.DialogCheckLayout;
import xeadEditor.DialogCheckLayoutCheckBox;
import xeadEditor.DialogCheckLayoutComboBox;
import xeadEditor.DialogCheckLayoutDateField;
import xeadEditor.DialogCheckLayoutFYearBox;
import xeadEditor.DialogCheckLayoutMSeqBox;
import xeadEditor.DialogCheckLayoutPromptCallField;
import xeadEditor.DialogCheckLayoutReferTable;
import xeadEditor.DialogCheckLayoutTextField;
import xeadEditor.DialogCheckLayoutYMonthBox;

class DialogCheckLayoutFilter
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Element fieldElement_ = null;
    private DialogCheckLayout dialog_ = null;
    private String dataType = "";
    private String dataTypeOptions = "";
    private ArrayList<String> dataTypeOptionList;
    private String tableID = "";
    private String tableAlias = "";
    private String fieldID = "";
    private String fieldName = "";
    private String fieldCaption = "";
    private String fieldOptions = "";
    private ArrayList<String> fieldOptionList;
    private int dataSize = 5;
    private int decimalSize = 0;
    private JPanel jPanelField = new JPanel();
    private JLabel jLabelField = new JLabel();
    private JComponent component = null;
    private boolean isVertical = false;
    private int verticalMargin = 5;
    private int horizontalMargin = 30;
    private boolean isEditable_ = true;
    private boolean isHidden = false;

    public DialogCheckLayoutFilter(Element fieldElement, DialogCheckLayout dialog) {
        String wrkStr;
        this.fieldElement_ = fieldElement;
        this.dialog_ = dialog;
        this.fieldOptions = this.fieldElement_.getAttribute("FieldOptions");
        this.fieldOptionList = this.dialog_.getEditor().getOptionList(this.fieldOptions);
        StringTokenizer workTokenizer1 = new StringTokenizer(this.fieldElement_.getAttribute("DataSource"), ".");
        this.tableAlias = workTokenizer1.nextToken();
        this.tableID = this.dialog_.getTableIDOfTableAlias(this.tableAlias);
        this.fieldID = workTokenizer1.nextToken();
        Element workElement = this.dialog_.getEditor().getSpecificFieldElement(this.tableID, this.fieldID);
        this.fieldName = workElement.getAttribute("Name");
        this.dataType = workElement.getAttribute("Type");
        this.dataTypeOptions = workElement.getAttribute("TypeOptions");
        this.dataTypeOptionList = this.dialog_.getEditor().getOptionList(this.dataTypeOptions);
        this.fieldCaption = workElement.getAttribute("Name").equals("") ? workElement.getAttribute("ID") : this.fieldName;
        this.dataSize = Integer.parseInt(workElement.getAttribute("Size"));
        if (this.dataSize > 50) {
            this.dataSize = 50;
        }
        if (!workElement.getAttribute("Decimal").equals("")) {
            this.decimalSize = Integer.parseInt(workElement.getAttribute("Decimal"));
        }
        if (this.fieldOptionList.contains("VERTICAL")) {
            this.isVertical = true;
        }
        if (!(wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "VERTICAL")).equals("")) {
            this.isVertical = true;
            this.verticalMargin = Integer.parseInt(wrkStr);
        }
        if (!(wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "HORIZONTAL")).equals("")) {
            this.horizontalMargin = Integer.parseInt(wrkStr) + 5;
        }
        if (!(wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "CAPTION")).equals("")) {
            this.fieldCaption = wrkStr;
            this.fieldCaption = this.fieldCaption.replace("SCAN", "");
            this.fieldCaption = this.fieldCaption.replace("\u2267", "");
            this.fieldCaption = this.fieldCaption.replace("\u4e0a\u4f4d\u6841", "");
        }
        this.jLabelField = new JLabel(this.fieldCaption);
        this.jLabelField.setHorizontalAlignment(4);
        this.jLabelField.setFont(new Font(this.dialog_.driverFontName_, 0, 18));
        int width = DialogCheckLayout.adjustFontSizeToGetPreferredWidthOfLabel(this.jLabelField, 150);
        if (this.isVertical || this.dialog_.getFilterList().size() == 0) {
            this.jLabelField.setPreferredSize(new Dimension(150, 25));
        } else {
            this.jLabelField.setPreferredSize(new Dimension(width + this.horizontalMargin, 25));
        }
        this.isEditable_ = !this.fieldOptionList.contains("NON_EDITABLE");
        this.jPanelField.setLayout(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jLabelField, "West");
        this.add((Component)this.jPanelField, "Center");
        if (!this.dialog_.getEditor().getOptionValueWithKeyword(this.dataTypeOptions, "BOOLEAN").equals("")) {
            this.component = new DialogCheckLayoutCheckBox(this.isEditable_, this.dialog_);
        } else if (this.fieldOptionList.contains("PROMPT_LIST1") || this.fieldOptionList.contains("PROMPT_LIST2")) {
            DialogCheckLayoutReferTable referTable = null;
            ArrayList<DialogCheckLayoutReferTable> referTableList = this.dialog_.getReferTableList();
            int i = 0;
            while (i < referTableList.size()) {
                if (referTableList.get(i).getTableID().equals(this.tableID) && (referTableList.get(i).getTableAlias().equals("") || referTableList.get(i).getTableAlias().equals(this.tableAlias))) {
                    referTable = referTableList.get(i);
                    break;
                }
                ++i;
            }
            this.component = new DialogCheckLayoutComboBox(fieldElement, this.dataTypeOptions, referTable, this.dialog_);
        } else {
            wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "PROMPT_CALL");
            if (!wrkStr.equals("")) {
                this.component = new DialogCheckLayoutPromptCallField(fieldElement, this.isEditable_, this.dialog_);
                if (this.component.getPreferredSize().width < 70) {
                    this.component.setPreferredSize(new Dimension(70, this.component.getPreferredSize().height));
                }
            } else {
                this.component = this.dataType.equals("DATE") ? new DialogCheckLayoutDateField(this.isEditable_, this.dialog_) : (this.dataTypeOptionList.contains("YMONTH") ? new DialogCheckLayoutYMonthBox(this.isEditable_, this.dialog_) : (this.dataTypeOptionList.contains("MSEQ") ? new DialogCheckLayoutMSeqBox(this.isEditable_, this.dialog_) : (this.dataTypeOptionList.contains("FYEAR") ? new DialogCheckLayoutFYearBox(this.isEditable_, this.dialog_) : new DialogCheckLayoutTextField(this.getBasicType(), this.dataSize, this.decimalSize, this.dataTypeOptions, this.fieldOptions, this.isEditable_, this.dialog_))));
            }
        }
        if (this.fieldOptionList.contains("HIDDEN")) {
            this.isHidden = true;
        }
        wrkStr = this.decimalSize > 0 ? "<html>" + this.fieldName + " " + this.tableAlias + "." + this.fieldID + " (" + this.dataSize + "," + this.decimalSize + ")<br>" : "<html>" + this.fieldName + " " + this.tableAlias + "." + this.fieldID + " (" + this.dataSize + ")<br>";
        this.setToolTipText(wrkStr);
        this.component.setToolTipText(wrkStr);
        this.component.setBounds(new Rectangle(5, 0, this.component.getPreferredSize().width, this.component.getPreferredSize().height));
        this.jPanelField.add(this.component);
        wrkStr = this.dialog_.getEditor().getOptionValueWithKeyword(this.fieldOptions, "WIDTH");
        if (wrkStr.equals("")) {
            if (this.component.getBounds().width > 250) {
                this.component.setBounds(new Rectangle(this.component.getBounds().x, this.component.getBounds().y, 250, this.component.getBounds().height));
            }
        } else {
            this.component.setBounds(new Rectangle(this.component.getBounds().x, this.component.getBounds().y, Integer.parseInt(wrkStr), 24));
        }
        this.setPreferredSize(new Dimension(this.jLabelField.getPreferredSize().width + this.component.getBounds().width + 20, this.component.getBounds().height));
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isVerticalPosition() {
        return this.isVertical;
    }

    public int getVerticalMargin() {
        return this.verticalMargin;
    }

    public String getBasicType() {
        return this.dialog_.getEditor().getBasicTypeOf(this.dataType);
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getFieldID() {
        return this.fieldID;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableID() {
        return this.tableID;
    }

    public String getDataSourceName() {
        return String.valueOf(this.tableAlias) + "." + this.fieldID;
    }

    public boolean isEditable() {
        return this.isEditable_;
    }
}

