/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import xeadEditor.DialogCheckLayout;

class DialogCheckLayoutTextArea
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private String fieldOptions_ = "";
    private JTextArea jTextArea = new JTextArea();
    private int rows_ = 2;
    private static Color ACTIVE_COLOR = SystemColor.white;
    private static Color INACTIVE_COLOR = SystemColor.control;

    public DialogCheckLayoutTextArea(int digits, String dataTypeOptions, String fieldOptions, boolean isEditable, DialogCheckLayout dialog) {
        this.fieldOptions_ = fieldOptions;
        this.jTextArea.setFont(new Font(dialog.driverFontName_, 0, 18));
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setFocusable(false);
        this.jTextArea.setEditable(false);
        if (isEditable) {
            this.jTextArea.setBackground(ACTIVE_COLOR);
        } else {
            this.jTextArea.setBackground(INACTIVE_COLOR);
        }
        this.getViewport().add((Component)this.jTextArea, null);
        String wrkStr = dialog.getEditor().getOptionValueWithKeyword(this.fieldOptions_, "ROWS");
        if (!wrkStr.equals("")) {
            this.rows_ = Integer.parseInt(wrkStr);
        }
        int fieldWidth = 800;
        wrkStr = dialog.getEditor().getOptionValueWithKeyword(this.fieldOptions_, "WIDTH");
        if (!wrkStr.equals("")) {
            fieldWidth = Integer.parseInt(wrkStr);
        }
        int fieldHeight = this.rows_ * dialog.getFieldUnitHeight() + (this.rows_ - 1) * dialog.getFieldVerticalMargin();
        this.setPreferredSize(new Dimension(fieldWidth, fieldHeight));
    }

    public int getRows() {
        return this.rows_;
    }
}

