/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xeadEditor.DialogImport_jButtonCloseDialog_actionAdapter;
import xeadEditor.DialogImport_jButtonImport_actionAdapter;
import xeadEditor.DialogImport_jComboBoxSubsystemFrom_actionAdapter;
import xeadEditor.DialogImport_jComboBoxSubsystemInto_actionAdapter;
import xeadEditor.Editor;

public class DialogImport
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private Editor frame_;
    private JPanel panelMain = new JPanel();
    private JPanel jPanelNorth = new JPanel();
    private JPanel jPanelCenter = new JPanel();
    private JPanel jPanelCenterTop = new JPanel();
    private JPanel jPanelCenterTableList = new JPanel();
    private JPanel jPanelCenterFunctionList = new JPanel();
    private JPanel jPanelSouth = new JPanel();
    private JSplitPane jSplitPane = new JSplitPane();
    private JScrollPane jScrollPaneTableListFrom = new JScrollPane();
    private JScrollPane jScrollPaneFunctionListFrom = new JScrollPane();
    private JScrollPane jScrollPaneTableListInto = new JScrollPane();
    private JScrollPane jScrollPaneFunctionListInto = new JScrollPane();
    private TableModelTableListFrom tableModelTableListFrom = new TableModelTableListFrom();
    private JTable jTableTableListFrom = new JTable(this.tableModelTableListFrom);
    private TableModelFunctionListFrom tableModelFunctionListFrom = new TableModelFunctionListFrom();
    private JTable jTableFunctionListFrom = new JTable(this.tableModelFunctionListFrom);
    private TableModelReadOnlyList tableModelTableListInto = new TableModelReadOnlyList();
    private JTable jTableTableListInto = new JTable(this.tableModelTableListInto);
    private TableModelReadOnlyList tableModelFunctionListInto = new TableModelReadOnlyList();
    private JTable jTableFunctionListInto = new JTable(this.tableModelFunctionListInto);
    private JPanel jPanelImportFromTop = new JPanel();
    private JPanel jPanelImportIntoTop = new JPanel();
    private JLabel jLabelSubsystemFrom = new JLabel();
    private JComboBox<String> jComboBoxSubsystemFrom = new JComboBox();
    private JLabel jLabelSubsystemInto = new JLabel();
    private JComboBox<String> jComboBoxSubsystemInto = new JComboBox();
    private JScrollPane jScrollPaneMessage = new JScrollPane();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JLabel jLabelFileNameFrom = new JLabel();
    private JTextField jTextFieldFileNameFrom = new JTextField();
    private JLabel jLabelSystemNameFrom = new JLabel();
    private JTextField jTextFieldSystemNameFrom = new JTextField();
    private JLabel jLabelSystemVersionFrom = new JLabel();
    private JTextField jTextFieldSystemVersionFrom = new JTextField();
    private ArrayList<Element> subsystemNodeListFrom = null;
    private ArrayList<Element> subsystemNodeListInto = null;
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private TableColumn column4;
    private DefaultTableCellRenderer rendererTableHeader = null;
    private CheckBoxHeaderRenderer checkBoxHeaderRendererTableListFrom = null;
    private CheckBoxHeaderRenderer checkBoxHeaderRendererFunctionListFrom = null;
    private DefaultTableCellRenderer rendererAlignmentCenter = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentRight = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentLeft = new DefaultTableCellRenderer();
    private JButton jButtonCloseDialog = new JButton();
    private JButton jButtonImport = new JButton();
    private JCheckBox jCheckBoxImportData = new JCheckBox();
    private Document domDocumentImportingFrom = null;
    private Calendar calendar;
    private SimpleDateFormat formatter = new SimpleDateFormat("dd-HH:mm:ss");
    private boolean anyElementsImported = false;
    private ArrayList<String> databaseIDList = new ArrayList();
    private ArrayList<String> databaseNameList = new ArrayList();
    private ArrayList<Connection> databaseConnList = new ArrayList();

    public DialogImport(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogImport(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(new BorderLayout());
        this.panelMain.setPreferredSize(new Dimension(1115, 800));
        this.panelMain.setBorder(BorderFactory.createEtchedBorder());
        this.panelMain.add((Component)this.jPanelNorth, "North");
        this.panelMain.add((Component)this.jPanelCenter, "Center");
        this.panelMain.add((Component)this.jPanelSouth, "South");
        this.jPanelNorth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelNorth.setPreferredSize(new Dimension(100, 74));
        this.jLabelFileNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFileNameFrom.setHorizontalAlignment(4);
        this.jLabelFileNameFrom.setHorizontalTextPosition(10);
        this.jLabelFileNameFrom.setText(res.getString("FileNameImporting"));
        this.jLabelFileNameFrom.setBounds(new Rectangle(5, 12, 180, 23));
        this.jTextFieldFileNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldFileNameFrom.setBounds(new Rectangle(190, 9, 675, 28));
        this.jTextFieldFileNameFrom.setEditable(false);
        this.jLabelSystemNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSystemNameFrom.setHorizontalAlignment(4);
        this.jLabelSystemNameFrom.setHorizontalTextPosition(10);
        this.jLabelSystemNameFrom.setText(res.getString("SystemNameImporting"));
        this.jLabelSystemNameFrom.setBounds(new Rectangle(5, 43, 180, 23));
        this.jTextFieldSystemNameFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldSystemNameFrom.setBounds(new Rectangle(190, 40, 430, 28));
        this.jTextFieldSystemNameFrom.setEditable(false);
        this.jLabelSystemVersionFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSystemVersionFrom.setHorizontalAlignment(4);
        this.jLabelSystemVersionFrom.setHorizontalTextPosition(10);
        this.jLabelSystemVersionFrom.setText(res.getString("SystemVersion"));
        this.jLabelSystemVersionFrom.setBounds(new Rectangle(630, 43, 130, 23));
        this.jTextFieldSystemVersionFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldSystemVersionFrom.setBounds(new Rectangle(765, 40, 100, 28));
        this.jTextFieldSystemVersionFrom.setEditable(false);
        this.jPanelNorth.setLayout(null);
        this.jPanelNorth.add(this.jLabelFileNameFrom);
        this.jPanelNorth.add(this.jTextFieldFileNameFrom);
        this.jPanelNorth.add(this.jLabelSystemNameFrom);
        this.jPanelNorth.add(this.jTextFieldSystemNameFrom);
        this.jPanelNorth.add(this.jLabelSystemVersionFrom);
        this.jPanelNorth.add(this.jTextFieldSystemVersionFrom);
        this.jLabelSubsystemFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSubsystemFrom.setHorizontalAlignment(4);
        this.jLabelSubsystemFrom.setHorizontalTextPosition(10);
        this.jLabelSubsystemFrom.setText(res.getString("SubsystemImportingFrom"));
        this.jLabelSubsystemFrom.setBounds(new Rectangle(5, 12, 180, 20));
        this.jComboBoxSubsystemFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jComboBoxSubsystemFrom.setBounds(new Rectangle(190, 9, 330, 25));
        this.jComboBoxSubsystemFrom.addActionListener(new DialogImport_jComboBoxSubsystemFrom_actionAdapter(this));
        this.jLabelSubsystemInto.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelSubsystemInto.setHorizontalAlignment(4);
        this.jLabelSubsystemInto.setHorizontalTextPosition(10);
        this.jLabelSubsystemInto.setText(res.getString("SubsystemImportingInto"));
        this.jLabelSubsystemInto.setBounds(new Rectangle(5, 12, 130, 20));
        this.jComboBoxSubsystemInto.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jComboBoxSubsystemInto.setBounds(new Rectangle(140, 9, 290, 25));
        this.jComboBoxSubsystemInto.addActionListener(new DialogImport_jComboBoxSubsystemInto_actionAdapter(this));
        this.jPanelImportFromTop.setPreferredSize(new Dimension(570, 43));
        this.jPanelImportFromTop.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelImportFromTop.setLayout(null);
        this.jPanelImportFromTop.add(this.jLabelSubsystemFrom);
        this.jPanelImportFromTop.add(this.jComboBoxSubsystemFrom);
        this.jPanelImportIntoTop.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelImportIntoTop.setLayout(null);
        this.jPanelImportIntoTop.add(this.jLabelSubsystemInto);
        this.jPanelImportIntoTop.add(this.jComboBoxSubsystemInto);
        this.jPanelCenterTop.setPreferredSize(new Dimension(100, 43));
        this.jPanelCenterTop.setLayout(new BorderLayout());
        this.jPanelCenterTop.add((Component)this.jPanelImportFromTop, "West");
        this.jPanelCenterTop.add((Component)this.jPanelImportIntoTop, "Center");
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setDividerLocation(120);
        this.jSplitPane.setPreferredSize(new Dimension(750, 400));
        this.jSplitPane.add((Component)this.jPanelCenterTableList, "top");
        this.jSplitPane.add((Component)this.jPanelCenterFunctionList, "bottom");
        this.jScrollPaneTableListFrom.setPreferredSize(new Dimension(570, 200));
        this.jScrollPaneTableListFrom.getViewport().add((Component)this.jTableTableListFrom, null);
        this.jScrollPaneTableListInto.getViewport().add((Component)this.jTableTableListInto, null);
        this.jPanelCenterTableList.setLayout(new BorderLayout());
        this.jPanelCenterTableList.add((Component)this.jScrollPaneTableListFrom, "West");
        this.jPanelCenterTableList.add((Component)this.jScrollPaneTableListInto, "Center");
        this.jScrollPaneFunctionListFrom.setPreferredSize(new Dimension(570, 200));
        this.jScrollPaneFunctionListFrom.getViewport().add((Component)this.jTableFunctionListFrom, null);
        this.jScrollPaneFunctionListInto.getViewport().add((Component)this.jTableFunctionListInto, null);
        this.jPanelCenterFunctionList.setLayout(new BorderLayout());
        this.jPanelCenterFunctionList.add((Component)this.jScrollPaneFunctionListFrom, "West");
        this.jPanelCenterFunctionList.add((Component)this.jScrollPaneFunctionListInto, "Center");
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setWrapStyleWord(true);
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setBackground(SystemColor.control);
        this.jScrollPaneMessage.setPreferredSize(new Dimension(800, 140));
        this.jScrollPaneMessage.getViewport().add((Component)this.jTextAreaMessage, null);
        this.jPanelCenter.setLayout(new BorderLayout());
        this.jPanelCenter.add((Component)this.jPanelCenterTop, "North");
        this.jPanelCenter.add((Component)this.jSplitPane, "Center");
        this.jPanelCenter.add((Component)this.jScrollPaneMessage, "South");
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentRight.setHorizontalAlignment(4);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.jTableTableListFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableTableListFrom.setBackground(SystemColor.control);
        this.jTableTableListFrom.setAutoResizeMode(0);
        this.jTableTableListFrom.setSelectionMode(0);
        this.jTableTableListFrom.setRowSelectionAllowed(true);
        this.jTableTableListFrom.setRowHeight(24);
        this.tableModelTableListFrom.addColumn("No.");
        this.tableModelTableListFrom.addColumn("");
        this.tableModelTableListFrom.addColumn(res.getString("TableID"));
        this.tableModelTableListFrom.addColumn(res.getString("TableName"));
        this.tableModelTableListFrom.addColumn(res.getString("ProcessType"));
        this.column0 = this.jTableTableListFrom.getColumnModel().getColumn(0);
        this.column1 = this.jTableTableListFrom.getColumnModel().getColumn(1);
        this.column2 = this.jTableTableListFrom.getColumnModel().getColumn(2);
        this.column3 = this.jTableTableListFrom.getColumnModel().getColumn(3);
        this.column4 = this.jTableTableListFrom.getColumnModel().getColumn(4);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(30);
        this.column2.setPreferredWidth(120);
        this.column3.setPreferredWidth(230);
        this.column4.setPreferredWidth(120);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
        this.column1.setCellRenderer(checkBoxRenderer);
        DefaultCellEditor editorWithCheckBox = new DefaultCellEditor(new JCheckBox());
        this.column1.setCellEditor(editorWithCheckBox);
        this.checkBoxHeaderRendererTableListFrom = new CheckBoxHeaderRenderer(new CheckBoxHeaderListener(this.jTableTableListFrom));
        this.column1.setHeaderRenderer(this.checkBoxHeaderRendererTableListFrom);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentLeft);
        this.column4.setCellRenderer(this.rendererAlignmentCenter);
        this.jTableTableListFrom.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableTableListFrom.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jTableFunctionListFrom.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableFunctionListFrom.setBackground(SystemColor.control);
        this.jTableFunctionListFrom.setAutoResizeMode(0);
        this.jTableFunctionListFrom.setSelectionMode(0);
        this.jTableFunctionListFrom.setRowSelectionAllowed(true);
        this.jTableFunctionListFrom.setRowHeight(24);
        this.tableModelFunctionListFrom.addColumn("No.");
        this.tableModelFunctionListFrom.addColumn("");
        this.tableModelFunctionListFrom.addColumn(res.getString("FunctionID"));
        this.tableModelFunctionListFrom.addColumn(res.getString("FunctionName"));
        this.tableModelFunctionListFrom.addColumn(res.getString("ProcessType"));
        this.column0 = this.jTableFunctionListFrom.getColumnModel().getColumn(0);
        this.column1 = this.jTableFunctionListFrom.getColumnModel().getColumn(1);
        this.column2 = this.jTableFunctionListFrom.getColumnModel().getColumn(2);
        this.column3 = this.jTableFunctionListFrom.getColumnModel().getColumn(3);
        this.column4 = this.jTableFunctionListFrom.getColumnModel().getColumn(4);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(30);
        this.column2.setPreferredWidth(120);
        this.column3.setPreferredWidth(250);
        this.column4.setPreferredWidth(100);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(checkBoxRenderer);
        this.column1.setCellEditor(editorWithCheckBox);
        this.checkBoxHeaderRendererFunctionListFrom = new CheckBoxHeaderRenderer(new CheckBoxHeaderListener(this.jTableFunctionListFrom));
        this.column1.setHeaderRenderer(this.checkBoxHeaderRendererFunctionListFrom);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentLeft);
        this.column4.setCellRenderer(this.rendererAlignmentCenter);
        this.jTableFunctionListFrom.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableFunctionListFrom.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jTableTableListInto.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableTableListInto.setBackground(SystemColor.control);
        this.jTableTableListInto.setAutoResizeMode(0);
        this.jTableTableListInto.setSelectionMode(0);
        this.jTableTableListInto.setRowSelectionAllowed(true);
        this.jTableTableListInto.setRowHeight(24);
        this.tableModelTableListInto.addColumn("No.");
        this.tableModelTableListInto.addColumn(res.getString("TableID"));
        this.tableModelTableListInto.addColumn(res.getString("TableName"));
        this.column0 = this.jTableTableListInto.getColumnModel().getColumn(0);
        this.column1 = this.jTableTableListInto.getColumnModel().getColumn(1);
        this.column2 = this.jTableTableListInto.getColumnModel().getColumn(2);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(120);
        this.column2.setPreferredWidth(250);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableTableListInto.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableTableListInto.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jTableFunctionListInto.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableFunctionListInto.setBackground(SystemColor.control);
        this.jTableFunctionListInto.setAutoResizeMode(0);
        this.jTableFunctionListInto.setSelectionMode(0);
        this.jTableFunctionListInto.setRowSelectionAllowed(true);
        this.jTableFunctionListInto.setRowHeight(24);
        this.tableModelFunctionListInto.addColumn("No.");
        this.tableModelFunctionListInto.addColumn(res.getString("FunctionID"));
        this.tableModelFunctionListInto.addColumn(res.getString("FunctionName"));
        this.column0 = this.jTableFunctionListInto.getColumnModel().getColumn(0);
        this.column1 = this.jTableFunctionListInto.getColumnModel().getColumn(1);
        this.column2 = this.jTableFunctionListInto.getColumnModel().getColumn(2);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(120);
        this.column2.setPreferredWidth(250);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableFunctionListInto.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableFunctionListInto.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jPanelSouth.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSouth.setPreferredSize(new Dimension(100, 43));
        this.jButtonCloseDialog.setBounds(new Rectangle(20, 8, 100, 27));
        this.jButtonCloseDialog.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCloseDialog.setText(res.getString("Close"));
        this.jButtonCloseDialog.addActionListener(new DialogImport_jButtonCloseDialog_actionAdapter(this));
        this.jButtonImport.setBounds(new Rectangle(500, 8, 150, 27));
        this.jButtonImport.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonImport.setText(res.getString("Import"));
        this.jButtonImport.addActionListener(new DialogImport_jButtonImport_actionAdapter(this));
        this.jButtonImport.setEnabled(false);
        this.jButtonImport.setFocusCycleRoot(true);
        this.jCheckBoxImportData.setBounds(new Rectangle(660, 8, 150, 27));
        this.jCheckBoxImportData.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jCheckBoxImportData.setText(res.getString("ImportDataFromTable"));
        this.jCheckBoxImportData.setEnabled(false);
        this.jCheckBoxImportData.setFocusCycleRoot(true);
        this.jPanelSouth.setLayout(null);
        this.jPanelSouth.add(this.jButtonCloseDialog);
        this.jPanelSouth.add(this.jButtonImport);
        this.jPanelSouth.add(this.jCheckBoxImportData);
        this.setTitle(res.getString("ImportDialogTitle"));
        this.setResizable(false);
        this.setPreferredSize(new Dimension(1024, 768));
        this.getContentPane().add(this.panelMain);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public boolean request(String fileName) {
        this.anyElementsImported = false;
        try {
            this.databaseIDList.clear();
            this.databaseNameList.clear();
            this.databaseConnList.clear();
            this.jTextFieldFileNameFrom.setText(fileName);
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(fileName)));
            this.domDocumentImportingFrom = parser.getDocument();
            NodeList nodeList = this.domDocumentImportingFrom.getElementsByTagName("System");
            Element systemElementImportFrom = (Element)nodeList.item(0);
            float importFileFormat = Float.parseFloat(systemElementImportFrom.getAttribute("FormatVersion"));
            float appliFormat = Float.parseFloat("1.2");
            if (importFileFormat > appliFormat) {
                JOptionPane.showMessageDialog(this, String.valueOf(res.getString("FormatVersionError1")) + systemElementImportFrom.getAttribute("FormatVersion") + res.getString("FormatVersionError2") + "1.2" + res.getString("FormatVersionError3"));
            } else {
                int i;
                int rowCount;
                this.jTextFieldSystemNameFrom.setText(systemElementImportFrom.getAttribute("Name"));
                this.jTextFieldSystemVersionFrom.setText(systemElementImportFrom.getAttribute("Version"));
                this.jComboBoxSubsystemFrom.removeAllItems();
                this.jComboBoxSubsystemFrom.addItem(res.getString("SelectFromList"));
                this.subsystemNodeListFrom = new ArrayList();
                this.subsystemNodeListFrom.add(null);
                NodeList nodelist = this.domDocumentImportingFrom.getElementsByTagName("Subsystem");
                Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodelist, "ID");
                int i2 = 0;
                while (i2 < sortingList.getSize()) {
                    Element element = (Element)sortingList.getElementAt(i2);
                    this.jComboBoxSubsystemFrom.addItem(String.valueOf(element.getAttribute("ID")) + " " + element.getAttribute("Name"));
                    this.subsystemNodeListFrom.add(element);
                    ++i2;
                }
                this.jComboBoxSubsystemInto.removeAllItems();
                this.jComboBoxSubsystemInto.addItem(res.getString("SelectFromList"));
                this.subsystemNodeListInto = new ArrayList();
                this.subsystemNodeListInto.add(null);
                Editor.MainTreeNode subsystemListInto = this.frame_.getSubsystemListNode();
                int i3 = 0;
                while (i3 < subsystemListInto.getChildCount()) {
                    Editor.MainTreeNode node = (Editor.MainTreeNode)subsystemListInto.getChildAt(i3);
                    this.jComboBoxSubsystemInto.addItem(String.valueOf(node.getElement().getAttribute("ID")) + " " + node.getElement().getAttribute("Name"));
                    this.subsystemNodeListInto.add(node.getElement());
                    ++i3;
                }
                this.checkBoxHeaderRendererTableListFrom.setSelected(false);
                if (this.tableModelTableListFrom.getRowCount() > 0) {
                    rowCount = this.tableModelTableListFrom.getRowCount();
                    i = 0;
                    while (i < rowCount) {
                        this.tableModelTableListFrom.removeRow(0);
                        ++i;
                    }
                }
                if (this.tableModelTableListInto.getRowCount() > 0) {
                    rowCount = this.tableModelTableListInto.getRowCount();
                    i = 0;
                    while (i < rowCount) {
                        this.tableModelTableListInto.removeRow(0);
                        ++i;
                    }
                }
                this.checkBoxHeaderRendererFunctionListFrom.setSelected(false);
                if (this.tableModelFunctionListFrom.getRowCount() > 0) {
                    rowCount = this.tableModelFunctionListFrom.getRowCount();
                    i = 0;
                    while (i < rowCount) {
                        this.tableModelFunctionListFrom.removeRow(0);
                        ++i;
                    }
                }
                if (this.tableModelFunctionListInto.getRowCount() > 0) {
                    rowCount = this.tableModelFunctionListInto.getRowCount();
                    i = 0;
                    while (i < rowCount) {
                        this.tableModelFunctionListInto.removeRow(0);
                        ++i;
                    }
                }
                if (this.jTextAreaMessage.getText().equals("")) {
                    this.jTextAreaMessage.setText(String.valueOf(res.getString("ImportMessage1")) + "\n");
                } else {
                    this.jTextAreaMessage.setText(String.valueOf(this.jTextAreaMessage.getText()) + "\n");
                }
                this.jButtonImport.setEnabled(false);
                this.jCheckBoxImportData.setSelected(false);
                this.jCheckBoxImportData.setEnabled(false);
                super.setVisible(true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, String.valueOf(res.getString("FailedToParse")) + "\n\n" + e.getMessage());
        }
        return this.anyElementsImported;
    }

    void jButtonImport_actionPerformed(ActionEvent e) {
        try {
            String message;
            TableRowNumber tableRowNumber;
            this.setCursor(new Cursor(3));
            int i = 0;
            while (i < this.tableModelTableListFrom.getRowCount()) {
                if (this.tableModelTableListFrom.getValueAt(i, 1).equals(Boolean.TRUE)) {
                    tableRowNumber = (TableRowNumber)this.tableModelTableListFrom.getValueAt(i, 0);
                    message = this.tableModelTableListFrom.getValueAt(i, 4).equals("MERGE") && this.jCheckBoxImportData.isSelected() ? this.importTableData(tableRowNumber.getElement()) : this.importTableElement(tableRowNumber.getElement());
                    this.jTextAreaMessage.setText(this.getNewMessage(message, ""));
                    this.jScrollPaneMessage.validate();
                    this.jScrollPaneMessage.paintImmediately(0, 0, this.jScrollPaneMessage.getWidth(), this.jScrollPaneMessage.getHeight());
                }
                ++i;
            }
            i = 0;
            while (i < this.tableModelFunctionListFrom.getRowCount()) {
                if (this.tableModelFunctionListFrom.getValueAt(i, 1).equals(Boolean.TRUE)) {
                    tableRowNumber = (TableRowNumber)this.tableModelFunctionListFrom.getValueAt(i, 0);
                    message = this.importFunctionElement(tableRowNumber.getElement());
                    this.jTextAreaMessage.setText(this.getNewMessage(message, ""));
                    this.jScrollPaneMessage.validate();
                    this.jScrollPaneMessage.paintImmediately(0, 0, this.jScrollPaneMessage.getWidth(), this.jScrollPaneMessage.getHeight());
                }
                ++i;
            }
            this.jComboBoxSubsystemFrom_actionPerformed(null);
            this.jComboBoxSubsystemInto_actionPerformed(null);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private String importTableElement(Element importingElement) {
        String error;
        String message = "";
        String tableID = importingElement.getAttribute("ID");
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("System");
        Element systemElementImportInto = (Element)nodeList.item(0);
        Element subsystemElementImportInto = this.subsystemNodeListInto.get(this.jComboBoxSubsystemInto.getSelectedIndex());
        String subsystemIDImportInto = subsystemElementImportInto.getAttribute("ID");
        Element newElement = (Element)this.frame_.getDomDocument().importNode(importingElement, true);
        newElement.setAttribute("SubsystemID", subsystemIDImportInto);
        NodeList currentElementList = this.frame_.getDomDocument().getElementsByTagName("Table");
        int i = 0;
        while (i < currentElementList.getLength()) {
            Element currentElement = (Element)currentElementList.item(i);
            if (currentElement.getAttribute("ID").equals(tableID)) {
                if (currentElement.getAttribute("SubsystemID").equals(subsystemIDImportInto)) {
                    error = this.getErrorWithTable(newElement, currentElement);
                    if (error.equals("")) {
                        this.mergeTableElement(newElement, currentElement);
                        message = "Table " + tableID + " " + res.getString("ImportMessage2");
                        this.anyElementsImported = true;
                        break;
                    }
                    message = "Table " + tableID + " " + res.getString("ImportMessage5") + error;
                    break;
                }
                message = "Table " + tableID + " " + res.getString("ImportMessage6");
                break;
            }
            ++i;
        }
        if (message.equals("")) {
            error = this.getErrorWithTable(newElement, null);
            if (error.equals("")) {
                systemElementImportInto.appendChild(newElement);
                message = "Table " + tableID + " " + res.getString("ImportMessage4");
                this.anyElementsImported = true;
            } else {
                message = "Table " + tableID + " " + res.getString("ImportMessage5") + error;
            }
        }
        return message;
    }

    private String importTableData(Element tableElementFrom) {
        String message = "";
        boolean firstField = true;
        String tableID = tableElementFrom.getAttribute("ID");
        Connection connectionFrom = null;
        Connection connectionInto = null;
        int countInsertSucceeded = 0;
        int countInsertFailed = 0;
        if (this.databaseIDList.size() == 0) {
            this.setupDBConnection();
        }
        if (this.databaseIDList.size() > 0 && this.databaseIDList.size() == this.databaseConnList.size()) {
            NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("System");
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            NodeList tableElementIntoList = this.frame_.getDomDocument().getElementsByTagName("Table");
            int i = 0;
            while (i < tableElementIntoList.getLength()) {
                Element tableElementInto = (Element)tableElementIntoList.item(i);
                if (tableElementInto.getAttribute("ID").equals(tableID)) {
                    try {
                        connectionFrom = this.databaseConnList.get(this.databaseIDList.indexOf(tableElementFrom.getAttribute("DB")));
                        Statement statement = connectionFrom.createStatement();
                        StringBuffer statementBuf = new StringBuffer();
                        statementBuf.append("select * from ");
                        statementBuf.append(tableID);
                        ResultSet result = statement.executeQuery(statementBuf.toString());
                        while (result.next()) {
                            Element workElement;
                            nodeList = tableElementFrom.getElementsByTagName("Field");
                            int j = 0;
                            while (j < nodeList.getLength()) {
                                workElement = (Element)nodeList.item(j);
                                fieldValueMap.put(workElement.getAttribute("ID"), result.getObject(workElement.getAttribute("ID")));
                                ++j;
                            }
                            connectionInto = this.frame_.databaseConnList.get(this.frame_.databaseIDList.indexOf(tableElementInto.getAttribute("DB")));
                            statement = connectionInto.createStatement();
                            statementBuf = new StringBuffer();
                            statementBuf.append("insert into ");
                            statementBuf.append(tableID);
                            statementBuf.append(" (");
                            firstField = true;
                            nodeList = tableElementInto.getElementsByTagName("Field");
                            j = 0;
                            while (j < nodeList.getLength()) {
                                if (!firstField) {
                                    statementBuf.append(", ");
                                }
                                workElement = (Element)nodeList.item(j);
                                statementBuf.append(workElement.getAttribute("ID"));
                                firstField = false;
                                ++j;
                            }
                            statementBuf.append(") values(");
                            firstField = true;
                            j = 0;
                            while (j < nodeList.getLength()) {
                                String basicType;
                                if (!firstField) {
                                    statementBuf.append(", ");
                                }
                                if ((basicType = this.frame_.getBasicTypeOf((workElement = (Element)nodeList.item(j)).getAttribute("Type"))).equals("INTEGER") | basicType.equals("FLOAT")) {
                                    statementBuf.append(fieldValueMap.get(workElement.getAttribute("ID")));
                                } else if (fieldValueMap.get(workElement.getAttribute("ID")) == null) {
                                    statementBuf.append("NULL");
                                } else {
                                    statementBuf.append("'");
                                    statementBuf.append(fieldValueMap.get(workElement.getAttribute("ID")));
                                    statementBuf.append("'");
                                }
                                firstField = false;
                                ++j;
                            }
                            statementBuf.append(")");
                            try {
                                String sql = statementBuf.toString();
                                int recordCount = statement.executeUpdate(sql);
                                if (recordCount != 1) continue;
                                ++countInsertSucceeded;
                            }
                            catch (SQLException e) {
                                ++countInsertFailed;
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    message = "Table " + tableID + " " + countInsertSucceeded + res.getString("ImportMessage38") + countInsertFailed + res.getString("ImportMessage39");
                    break;
                }
                ++i;
            }
        } else {
            message = res.getString("ImportMessage37");
        }
        return message;
    }

    private void setupDBConnection() {
        File file = new File(this.jTextFieldFileNameFrom.getText());
        NodeList nodeList = this.domDocumentImportingFrom.getElementsByTagName("System");
        Element systemElementImportFrom = (Element)nodeList.item(0);
        String databaseName = systemElementImportFrom.getAttribute("DatabaseName");
        databaseName = databaseName.replace("<CURRENT>", file.getParent());
        String user = systemElementImportFrom.getAttribute("DatabaseUser");
        String password = systemElementImportFrom.getAttribute("DatabasePassword");
        this.databaseIDList.add("");
        this.databaseNameList.add(databaseName);
        this.databaseConnList.add(this.frame_.createConnection(databaseName, user, password));
        NodeList subDBList = systemElementImportFrom.getElementsByTagName("SubDB");
        Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(subDBList, "ID");
        int i = 0;
        while (i < sortingList.getSize()) {
            Element element = (Element)sortingList.getElementAt(i);
            databaseName = element.getAttribute("Name");
            databaseName = databaseName.replace("<CURRENT>", file.getParent());
            user = element.getAttribute("User");
            password = element.getAttribute("Password");
            this.databaseIDList.add(element.getAttribute("ID"));
            this.databaseNameList.add(databaseName);
            this.databaseConnList.add(this.frame_.createConnection(databaseName, user, password));
            ++i;
        }
    }

    private String getErrorWithTable(Element newElement, Element currentElement) {
        String error = "";
        boolean isTheSamePK = false;
        if (!this.isValidDatabaseID(newElement.getAttribute("DB"))) {
            error = res.getString("ImportMessage33");
        } else {
            Element workElement;
            int i;
            NodeList nodeList;
            if (currentElement == null) {
                isTheSamePK = true;
            } else {
                nodeList = newElement.getElementsByTagName("Key");
                i = 0;
                block0: while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (workElement.getAttribute("Type").equals("PK")) {
                        NodeList nodeList2 = currentElement.getElementsByTagName("Key");
                        int j = 0;
                        while (j < nodeList2.getLength()) {
                            Element workElement2 = (Element)nodeList2.item(j);
                            if (workElement2.getAttribute("Type").equals("PK") && workElement.getAttribute("Fields").equals(workElement2.getAttribute("Fields"))) {
                                isTheSamePK = true;
                                break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            if (isTheSamePK) {
                nodeList = newElement.getElementsByTagName("Refer");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (error.equals("") && !this.isValidTableID(workElement.getAttribute("ToTable"))) {
                        error = res.getString("ImportMessage7");
                    } else if (error.equals("") && !workElement.getAttribute("ToKeyFields").equals("") && !this.isValidFields(workElement.getAttribute("ToTable"), workElement.getAttribute("ToKeyFields"))) {
                        error = res.getString("ImportMessage8");
                    } else if (error.equals("") && !workElement.getAttribute("Fields").equals("") && !this.isValidFields(workElement.getAttribute("ToTable"), workElement.getAttribute("Fields"))) {
                        error = res.getString("ImportMessage9");
                    } else if (error.equals("")) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                error = res.getString("ImportMessage10");
            }
        }
        return error;
    }

    private void mergeTableElement(Element newElement, Element currentElement) {
        Element element;
        Element workElement2;
        int j;
        NodeList nodeList2;
        Element workElement;
        boolean isElementToBeAdded = true;
        currentElement.setAttribute("Name", newElement.getAttribute("Name"));
        currentElement.setAttribute("Remarks", newElement.getAttribute("Remarks"));
        currentElement.setAttribute("UpdateCounter", newElement.getAttribute("UpdateCounter"));
        currentElement.setAttribute("DetailRowNumberAuto", newElement.getAttribute("DetailRowNumberAuto"));
        NodeList nodeList = newElement.getElementsByTagName("Field");
        int i = 0;
        while (i < nodeList.getLength()) {
            workElement = (Element)nodeList.item(i);
            nodeList2 = currentElement.getElementsByTagName("Field");
            isElementToBeAdded = true;
            j = 0;
            while (j < nodeList2.getLength()) {
                workElement2 = (Element)nodeList2.item(j);
                if (workElement2.getAttribute("ID").equals(workElement.getAttribute("ID"))) {
                    isElementToBeAdded = false;
                    workElement2.setAttribute("Name", workElement.getAttribute("Name"));
                    workElement2.setAttribute("Order", workElement.getAttribute("Order"));
                    workElement2.setAttribute("Remarks", workElement.getAttribute("Remarks"));
                    workElement2.setAttribute("Type", workElement.getAttribute("Type"));
                    workElement2.setAttribute("Size", workElement.getAttribute("Size"));
                    workElement2.setAttribute("Decimal", workElement.getAttribute("Decimal"));
                    workElement2.setAttribute("Nullable", workElement.getAttribute("Nullable"));
                    workElement2.setAttribute("NoUpdate", workElement.getAttribute("NoUpdate"));
                    workElement2.setAttribute("TypeOptions", workElement.getAttribute("TypeOptions"));
                    break;
                }
                ++j;
            }
            if (isElementToBeAdded) {
                element = (Element)this.frame_.getDomDocument().importNode(workElement, false);
                currentElement.appendChild(element);
            }
            ++i;
        }
        nodeList = newElement.getElementsByTagName("Key");
        i = 0;
        while (i < nodeList.getLength()) {
            workElement = (Element)nodeList.item(i);
            if (!workElement.getAttribute("Type").equals("PK")) {
                nodeList2 = currentElement.getElementsByTagName("Key");
                isElementToBeAdded = true;
                j = 0;
                while (j < nodeList2.getLength()) {
                    workElement2 = (Element)nodeList2.item(j);
                    if (workElement2.getAttribute("Type").equals(workElement.getAttribute("Type")) && workElement2.getAttribute("Fields").equals(workElement.getAttribute("Fields"))) {
                        isElementToBeAdded = false;
                        break;
                    }
                    ++j;
                }
                if (isElementToBeAdded) {
                    element = (Element)this.frame_.getDomDocument().importNode(workElement, false);
                    currentElement.appendChild(element);
                }
            }
            ++i;
        }
        nodeList = newElement.getElementsByTagName("Refer");
        i = 0;
        while (i < nodeList.getLength()) {
            workElement = (Element)nodeList.item(i);
            nodeList2 = currentElement.getElementsByTagName("Refer");
            isElementToBeAdded = true;
            j = 0;
            while (j < nodeList2.getLength()) {
                workElement2 = (Element)nodeList2.item(j);
                if (workElement2.getAttribute("ToTable").equals(workElement.getAttribute("ToTable")) && workElement2.getAttribute("TableAlias").equals(workElement.getAttribute("TableAlias"))) {
                    isElementToBeAdded = false;
                    workElement2.setAttribute("Order", workElement.getAttribute("Order"));
                    workElement2.setAttribute("ToKeyFields", workElement.getAttribute("ToKeyFields"));
                    workElement2.setAttribute("WithKeyFields", workElement.getAttribute("WithKeyFields"));
                    workElement2.setAttribute("Fields", workElement.getAttribute("Fields"));
                    break;
                }
                ++j;
            }
            if (isElementToBeAdded) {
                element = (Element)this.frame_.getDomDocument().importNode(workElement, false);
                currentElement.appendChild(element);
            }
            ++i;
        }
        nodeList = newElement.getElementsByTagName("Script");
        i = 0;
        while (i < nodeList.getLength()) {
            workElement = (Element)nodeList.item(i);
            nodeList2 = currentElement.getElementsByTagName("Script");
            isElementToBeAdded = true;
            j = 0;
            while (j < nodeList2.getLength()) {
                workElement2 = (Element)nodeList2.item(j);
                if (workElement2.getAttribute("Name").equals(workElement.getAttribute("Name"))) {
                    isElementToBeAdded = false;
                    workElement2.setAttribute("Order", workElement.getAttribute("Order"));
                    workElement2.setAttribute("EventP", workElement.getAttribute("EventP"));
                    workElement2.setAttribute("EventR", workElement.getAttribute("EventR"));
                    workElement2.setAttribute("Text", workElement.getAttribute("Text"));
                    break;
                }
                ++j;
            }
            if (isElementToBeAdded) {
                element = (Element)this.frame_.getDomDocument().importNode(workElement, false);
                currentElement.appendChild(element);
            }
            ++i;
        }
    }

    private String importFunctionElement(Element importingElement) {
        String error;
        String message = "";
        String functionID = importingElement.getAttribute("ID");
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("System");
        Element systemElementImportInto = (Element)nodeList.item(0);
        Element subsystemElementImportInto = this.subsystemNodeListInto.get(this.jComboBoxSubsystemInto.getSelectedIndex());
        String subsystemIDImportInto = subsystemElementImportInto.getAttribute("ID");
        Element newElement = (Element)this.frame_.getDomDocument().importNode(importingElement, true);
        newElement.setAttribute("SubsystemID", subsystemIDImportInto);
        NodeList currentElementList = this.frame_.getDomDocument().getElementsByTagName("Function");
        int i = 0;
        while (i < currentElementList.getLength()) {
            Element currentElement = (Element)currentElementList.item(i);
            if (currentElement.getAttribute("ID").equals(functionID)) {
                if (currentElement.getAttribute("SubsystemID").equals(subsystemIDImportInto)) {
                    error = this.getErrorWithFunction(newElement);
                    if (error.equals("")) {
                        systemElementImportInto.replaceChild(newElement, currentElement);
                        message = "Function " + functionID + " " + res.getString("ImportMessage3");
                        this.anyElementsImported = true;
                        break;
                    }
                    message = "Function " + functionID + " " + res.getString("ImportMessage5") + error;
                    break;
                }
                message = "Function " + functionID + " " + res.getString("ImportMessage6");
                break;
            }
            ++i;
        }
        if (message.equals("")) {
            error = this.getErrorWithFunction(newElement);
            if (error.equals("")) {
                systemElementImportInto.appendChild(newElement);
                message = "Function " + functionID + " " + res.getString("ImportMessage4");
                this.anyElementsImported = true;
            } else {
                message = "Function " + functionID + " " + res.getString("ImportMessage5") + error;
            }
        }
        return message;
    }

    private String getErrorWithFunction(Element element) {
        Element workElement2;
        int j;
        NodeList nodeList2;
        Element workElement;
        int i;
        NodeList nodeList;
        String wrkStr;
        StringTokenizer workTokenizer;
        String error = "";
        boolean isInvalidType = true;
        String functionType = element.getAttribute("Type");
        if (functionType.equals("XF000")) {
            isInvalidType = false;
        }
        if (functionType.equals("XF100") || functionType.equals("XF110")) {
            isInvalidType = false;
            if (!this.isValidTableID(element.getAttribute("PrimaryTable"))) {
                error = res.getString("ImportMessage11");
            }
            if (error.equals("") && !element.getAttribute("KeyFields").equals("") && !this.isValidFields(element.getAttribute("PrimaryTable"), element.getAttribute("KeyFields"))) {
                error = res.getString("ImportMessage12");
            }
            if (error.equals("") && !element.getAttribute("OrderBy").equals("")) {
                workTokenizer = new StringTokenizer(element.getAttribute("OrderBy"), ";");
                while (workTokenizer.hasMoreTokens()) {
                    wrkStr = workTokenizer.nextToken();
                    if (this.isValidDataSourceName(element.getAttribute("PrimaryTable"), wrkStr)) continue;
                    error = res.getString("ImportMessage13");
                    break;
                }
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Column");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("PrimaryTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage14");
                        break;
                    }
                    ++i;
                }
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Filter");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("PrimaryTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage15");
                        break;
                    }
                    ++i;
                }
            }
        }
        if (functionType.equals("XF110")) {
            isInvalidType = false;
            if (error.equals("") && !element.getAttribute("BatchTable").equals("")) {
                if (!this.isValidTableID(element.getAttribute("BatchTable"))) {
                    error = res.getString("ImportMessage16");
                }
                if (error.equals("") && !element.getAttribute("BatchKeyFields").equals("") && !this.isValidFields(element.getAttribute("BatchTable"), element.getAttribute("BatchKeyFields"))) {
                    error = res.getString("ImportMessage17");
                }
                if (error.equals("") && !element.getAttribute("BatchWithKeyFields").equals("")) {
                    workTokenizer = new StringTokenizer(element.getAttribute("BatchWithKeyFields"), ";");
                    while (workTokenizer.hasMoreTokens()) {
                        wrkStr = workTokenizer.nextToken();
                        if (this.isValidDataSourceName(element.getAttribute("PrimaryTable"), wrkStr)) continue;
                        error = res.getString("ImportMessage17");
                        break;
                    }
                }
            }
        }
        if (functionType.equals("XF200")) {
            isInvalidType = false;
            if (!this.isValidTableID(element.getAttribute("PrimaryTable"))) {
                error = res.getString("ImportMessage11");
            }
            if (error.equals("") && !element.getAttribute("KeyFields").equals("") && !this.isValidFields(element.getAttribute("PrimaryTable"), element.getAttribute("KeyFields"))) {
                error = res.getString("ImportMessage12");
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Field");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("PrimaryTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage18");
                        break;
                    }
                    ++i;
                }
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Tab");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    nodeList2 = workElement.getElementsByTagName("TabField");
                    j = 0;
                    while (j < nodeList2.getLength()) {
                        workElement2 = (Element)nodeList2.item(j);
                        if (!this.isValidDataSourceName(element.getAttribute("PrimaryTable"), workElement2.getAttribute("DataSource"))) {
                            error = res.getString("ImportMessage24");
                            break;
                        }
                        ++j;
                    }
                    if (!error.equals("")) break;
                    ++i;
                }
            }
        }
        if (functionType.equals("XF290")) {
            isInvalidType = false;
            if (!this.isValidTableID(element.getAttribute("PrimaryTable"))) {
                error = res.getString("ImportMessage11");
            }
            if (error.equals("") && !element.getAttribute("KeyFields").equals("") && !this.isValidFields(element.getAttribute("PrimaryTable"), element.getAttribute("KeyFields"))) {
                error = res.getString("ImportMessage12");
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Phrase");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidFontID(workElement.getAttribute("FontID"))) {
                        error = res.getString("ImportMessage31");
                        break;
                    }
                    ++i;
                }
            }
        }
        if (functionType.equals("XF300")) {
            isInvalidType = false;
            if (!this.isValidTableID(element.getAttribute("HeaderTable"))) {
                error = res.getString("ImportMessage19");
            }
            if (error.equals("") && !element.getAttribute("HeaderKeyFields").equals("") && !this.isValidFields(element.getAttribute("HeaderTable"), element.getAttribute("HeaderKeyFields"))) {
                error = res.getString("ImportMessage20");
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Field");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("HeaderTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage21");
                        break;
                    }
                    ++i;
                }
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Detail");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidTableID(workElement.getAttribute("Table"))) {
                        error = res.getString("ImportMessage22");
                    }
                    if (error.equals("") && !workElement.getAttribute("KeyFields").equals("") && !this.isValidFields(workElement.getAttribute("Table"), workElement.getAttribute("KeyFields"))) {
                        error = res.getString("ImportMessage23");
                    }
                    if (error.equals("") && !workElement.getAttribute("HeaderKeyFields").equals("") && !this.isValidFields(element.getAttribute("HeaderTable"), workElement.getAttribute("HeaderKeyFields"))) {
                        error = res.getString("ImportMessage23");
                    }
                    if (error.equals("") && !workElement.getAttribute("OrderBy").equals("")) {
                        workTokenizer = new StringTokenizer(workElement.getAttribute("OrderBy"), ";");
                        while (workTokenizer.hasMoreTokens()) {
                            wrkStr = workTokenizer.nextToken();
                            if (this.isValidDataSourceName(workElement.getAttribute("Table"), wrkStr)) continue;
                            error = res.getString("ImportMessage13");
                            break;
                        }
                    }
                    if (error.equals("")) {
                        nodeList2 = workElement.getElementsByTagName("Column");
                        j = 0;
                        while (j < nodeList2.getLength()) {
                            workElement2 = (Element)nodeList2.item(j);
                            if (!this.isValidDataSourceName(workElement.getAttribute("Table"), workElement2.getAttribute("DataSource"))) {
                                error = res.getString("ImportMessage24");
                                break;
                            }
                            ++j;
                        }
                    }
                    if (error.equals("")) {
                        nodeList2 = workElement.getElementsByTagName("Filter");
                        j = 0;
                        while (j < nodeList2.getLength()) {
                            workElement2 = (Element)nodeList2.item(j);
                            if (!this.isValidDataSourceName(workElement.getAttribute("Table"), workElement2.getAttribute("DataSource"))) {
                                error = res.getString("ImportMessage15");
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!error.equals("")) break;
                    ++i;
                }
            }
            if (error.equals("") && !element.getAttribute("StructureTable").equals("")) {
                if (!this.isValidTableID(element.getAttribute("StructureTable"))) {
                    error = res.getString("ImportMessage34");
                }
                if (error.equals("") && !element.getAttribute("StructureTableKeys").equals("") && !this.isValidFields(element.getAttribute("StructureTable"), element.getAttribute("StructureTableKeys"))) {
                    error = res.getString("ImportMessage34");
                }
                if (error.equals("") && !element.getAttribute("StructureChildKeys").equals("") && !this.isValidFields(element.getAttribute("StructureTable"), element.getAttribute("StructureChildKeys"))) {
                    error = res.getString("ImportMessage34");
                }
                if (error.equals("") && !element.getAttribute("StructureNodeText").equals("") && !this.isValidFields(element.getAttribute("StructureTable"), element.getAttribute("StructureNodeText"))) {
                    error = res.getString("ImportMessage35");
                }
                if (error.equals("") && !element.getAttribute("StructureNodeIconsField").equals("") && !this.isValidFields(element.getAttribute("StructureTable"), element.getAttribute("StructureNodeIconsField"))) {
                    error = res.getString("ImportMessage36");
                }
            }
        }
        if (functionType.equals("XF310")) {
            isInvalidType = false;
            if (!this.isValidTableID(element.getAttribute("HeaderTable"))) {
                error = res.getString("ImportMessage19");
            }
            if (error.equals("") && !element.getAttribute("HeaderKeyFields").equals("") && !this.isValidFields(element.getAttribute("HeaderTable"), element.getAttribute("HeaderKeyFields"))) {
                error = res.getString("ImportMessage20");
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Field");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("HeaderTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage21");
                        break;
                    }
                    ++i;
                }
            }
            if (error.equals("") && !this.isValidTableID(element.getAttribute("DetailTable"))) {
                error = res.getString("ImportMessage22");
            }
            if (error.equals("") && !element.getAttribute("DetailKeyFields").equals("") && !this.isValidFields(element.getAttribute("DetailTable"), element.getAttribute("DetailKeyFields"))) {
                error = res.getString("ImportMessage23");
            }
            if (error.equals("") && !element.getAttribute("DetailOrderBy").equals("")) {
                workTokenizer = new StringTokenizer(element.getAttribute("DetailOrderBy"), ";");
                while (workTokenizer.hasMoreTokens()) {
                    wrkStr = workTokenizer.nextToken();
                    if (this.isValidDataSourceName(element.getAttribute("DetailTable"), wrkStr)) continue;
                    error = res.getString("ImportMessage13");
                    break;
                }
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Column");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("DetailTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage24");
                        break;
                    }
                    ++i;
                }
            }
        }
        if (functionType.equals("XF390")) {
            isInvalidType = false;
            if (!this.isValidTableID(element.getAttribute("HeaderTable"))) {
                error = res.getString("ImportMessage19");
            }
            if (error.equals("") && !element.getAttribute("HeaderKeyFields").equals("") && !this.isValidFields(element.getAttribute("HeaderTable"), element.getAttribute("HeaderKeyFields"))) {
                error = res.getString("ImportMessage20");
            }
            if (error.equals("") && !this.isValidTableID(element.getAttribute("DetailTable"))) {
                error = res.getString("ImportMessage22");
            }
            if (error.equals("") && !element.getAttribute("DetailKeyFields").equals("") && !this.isValidFields(element.getAttribute("DetailTable"), element.getAttribute("DetailKeyFields"))) {
                error = res.getString("ImportMessage23");
            }
            if (error.equals("") && !element.getAttribute("DetailOrderBy").equals("")) {
                workTokenizer = new StringTokenizer(element.getAttribute("DetailOrderBy"), ";");
                while (workTokenizer.hasMoreTokens()) {
                    wrkStr = workTokenizer.nextToken();
                    if (this.isValidDataSourceName(element.getAttribute("DetailTable"), wrkStr)) continue;
                    error = res.getString("ImportMessage13");
                    break;
                }
            }
            if (error.equals("") && !this.isValidFontID(element.getAttribute("TableFontID"))) {
                error = res.getString("ImportMessage32");
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("HeaderPhrase");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidFontID(workElement.getAttribute("FontID"))) {
                        error = res.getString("ImportMessage31");
                        break;
                    }
                    ++i;
                }
            }
            if (error.equals("")) {
                nodeList = element.getElementsByTagName("Column");
                i = 0;
                while (i < nodeList.getLength()) {
                    workElement = (Element)nodeList.item(i);
                    if (!this.isValidDataSourceName(element.getAttribute("DetailTable"), workElement.getAttribute("DataSource"))) {
                        error = res.getString("ImportMessage24");
                        break;
                    }
                    ++i;
                }
            }
        }
        if (isInvalidType) {
            error = res.getString("ImportMessage30");
        }
        return error;
    }

    private boolean isValidFontID(String id) {
        boolean isValid = false;
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("PrintFont");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getAttribute("ID").equals(id)) {
                isValid = true;
                break;
            }
            ++i;
        }
        return isValid;
    }

    private boolean isValidDatabaseID(String id) {
        boolean isValid = false;
        if (id.equals("")) {
            isValid = true;
        } else {
            NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("SubDB");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute("ID").equals(id)) {
                    isValid = true;
                    break;
                }
                ++i;
            }
        }
        return isValid;
    }

    private boolean isValidTableID(String id) {
        boolean isValid = false;
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("Table");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getAttribute("ID").equals(id)) {
                isValid = true;
                break;
            }
            ++i;
        }
        return isValid;
    }

    private boolean isValidFields(String tableID, String fields) {
        boolean isValid = false;
        int countOfFields = 0;
        int countOfMatch = 0;
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("Table");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getAttribute("ID").equals(tableID)) {
                NodeList workList = element.getElementsByTagName("Field");
                StringTokenizer workTokenizer = new StringTokenizer(fields, ";");
                countOfFields = workTokenizer.countTokens();
                block1: while (workTokenizer.hasMoreTokens()) {
                    String wrkStr = workTokenizer.nextToken();
                    int j = 0;
                    while (j < workList.getLength()) {
                        Element workElement = (Element)workList.item(j);
                        if (workElement.getAttribute("ID").equals(wrkStr)) {
                            ++countOfMatch;
                            continue block1;
                        }
                        ++j;
                    }
                }
                if (countOfFields != countOfMatch) break;
                isValid = true;
                break;
            }
            ++i;
        }
        return isValid;
    }

    private boolean isValidDataSourceName(String ownerTableID, String dataSourceName) {
        boolean isValid = false;
        dataSourceName = dataSourceName.replace("(D)", "");
        StringTokenizer workTokenizer = new StringTokenizer(dataSourceName, ".");
        String alias = workTokenizer.nextToken();
        String fieldID = workTokenizer.nextToken();
        NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName("Table");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getAttribute("ID").equals(ownerTableID)) {
                if (alias.equals(ownerTableID)) {
                    NodeList workList = element.getElementsByTagName("Field");
                    int j = 0;
                    while (j < workList.getLength()) {
                        Element workElement = (Element)workList.item(j);
                        if (workElement.getAttribute("ID").equals(fieldID)) {
                            isValid = true;
                            break;
                        }
                        ++j;
                    }
                    if (isValid) break;
                    break;
                }
                NodeList workList = element.getElementsByTagName("Refer");
                int j = 0;
                while (j < workList.getLength()) {
                    Element workElement = (Element)workList.item(j);
                    if (workElement.getAttribute("TableAlias").equals(alias)) {
                        workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                        while (workTokenizer.hasMoreTokens()) {
                            if (!workTokenizer.nextToken().equals(fieldID)) continue;
                            isValid = true;
                            break;
                        }
                        if (!isValid) {
                            break;
                        }
                    } else if (workElement.getAttribute("ToTable").equals(alias)) {
                        workTokenizer = new StringTokenizer(workElement.getAttribute("Fields"), ";");
                        while (workTokenizer.hasMoreTokens()) {
                            if (!workTokenizer.nextToken().equals(fieldID)) continue;
                            isValid = true;
                            break;
                        }
                        if (!isValid) break;
                    }
                    ++j;
                }
                if (isValid) break;
                break;
            }
            ++i;
        }
        return isValid;
    }

    private String getNewMessage(String newMessage1, String newMessage2) {
        StringBuffer bf = new StringBuffer();
        if (!this.jTextAreaMessage.getText().equals("")) {
            bf.append(this.jTextAreaMessage.getText());
            bf.append("\n");
        }
        bf.append("> ");
        bf.append(newMessage1);
        if (!newMessage2.equals("")) {
            bf.append(" ");
            bf.append(newMessage2);
        }
        this.calendar = Calendar.getInstance();
        bf.append("(");
        bf.append(this.formatter.format(this.calendar.getTime()));
        bf.append(")");
        return bf.toString();
    }

    boolean isReadyToStartImport() {
        boolean isReady = false;
        if (this.jComboBoxSubsystemInto.getSelectedIndex() > 0) {
            int i = 0;
            while (i < this.tableModelTableListFrom.getRowCount()) {
                if (this.tableModelTableListFrom.getValueAt(i, 1).equals(Boolean.TRUE)) {
                    isReady = true;
                    break;
                }
                ++i;
            }
            if (!isReady) {
                i = 0;
                while (i < this.tableModelFunctionListFrom.getRowCount()) {
                    if (this.tableModelFunctionListFrom.getValueAt(i, 1).equals(Boolean.TRUE)) {
                        isReady = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return isReady;
    }

    boolean isReadyToCheckImportData() {
        boolean isReady = false;
        if (this.jComboBoxSubsystemInto.getSelectedIndex() > 0) {
            int i = 0;
            while (i < this.tableModelTableListFrom.getRowCount()) {
                if (this.tableModelTableListFrom.getValueAt(i, 1).equals(Boolean.TRUE) && this.tableModelTableListFrom.getValueAt(i, 4).equals("MERGE")) {
                    isReady = true;
                    break;
                }
                ++i;
            }
        }
        return isReady;
    }

    void jButtonCloseDialog_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void jComboBoxSubsystemFrom_actionPerformed(ActionEvent e) {
        if (this.subsystemNodeListFrom != null && this.jComboBoxSubsystemFrom.getSelectedIndex() >= 0) {
            int i;
            int rowCount;
            this.checkBoxHeaderRendererTableListFrom.setSelected(false);
            this.checkBoxHeaderRendererFunctionListFrom.setSelected(false);
            Element subsystemElement = this.subsystemNodeListFrom.get(this.jComboBoxSubsystemFrom.getSelectedIndex());
            if (this.tableModelTableListFrom.getRowCount() > 0) {
                rowCount = this.tableModelTableListFrom.getRowCount();
                i = 0;
                while (i < rowCount) {
                    this.tableModelTableListFrom.removeRow(0);
                    ++i;
                }
            }
            if (this.tableModelFunctionListFrom.getRowCount() > 0) {
                rowCount = this.tableModelFunctionListFrom.getRowCount();
                i = 0;
                while (i < rowCount) {
                    this.tableModelFunctionListFrom.removeRow(0);
                    ++i;
                }
            }
            if (subsystemElement != null) {
                Object[] Cell;
                Element element;
                String subsystemID = subsystemElement.getAttribute("ID");
                int rowNumber = 1;
                NodeList nodelist = this.domDocumentImportingFrom.getElementsByTagName("Table");
                Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodelist, "ID");
                int i2 = 0;
                while (i2 < sortingList.getSize()) {
                    element = (Element)sortingList.getElementAt(i2);
                    if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                        Cell = new Object[]{new TableRowNumber(rowNumber++, element), Boolean.FALSE, element.getAttribute("ID"), element.getAttribute("Name"), this.jComboBoxSubsystemInto.getSelectedIndex() == 0 ? "?" : this.getProcessType("Table", element.getAttribute("ID"), element)};
                        this.tableModelTableListFrom.addRow(Cell);
                    }
                    ++i2;
                }
                rowNumber = 1;
                nodelist = this.domDocumentImportingFrom.getElementsByTagName("Function");
                sortingList = this.frame_.getSortedListModel(nodelist, "ID");
                i2 = 0;
                while (i2 < sortingList.getSize()) {
                    element = (Element)sortingList.getElementAt(i2);
                    if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                        Cell = new Object[]{new TableRowNumber(rowNumber++, element), Boolean.FALSE, element.getAttribute("ID"), element.getAttribute("Name"), this.jComboBoxSubsystemInto.getSelectedIndex() == 0 ? "?" : this.getProcessType("Function", element.getAttribute("ID"), null)};
                        this.tableModelFunctionListFrom.addRow(Cell);
                    }
                    ++i2;
                }
                if (this.jComboBoxSubsystemInto.getSelectedIndex() == 0 && this.subsystemNodeListInto.size() > 1) {
                    i2 = 1;
                    while (i2 < this.subsystemNodeListInto.size()) {
                        element = this.subsystemNodeListInto.get(i2);
                        if (element.getAttribute("ID").equals(subsystemID)) {
                            this.jComboBoxSubsystemInto.setSelectedIndex(i2);
                        }
                        ++i2;
                    }
                }
                this.jButtonImport.setEnabled(false);
                this.jCheckBoxImportData.setEnabled(false);
            }
        }
    }

    String getProcessType(String tagName, String id, Element fromElement) {
        String processType = "";
        Element subsystemElement = this.subsystemNodeListInto.get(this.jComboBoxSubsystemInto.getSelectedIndex());
        if (subsystemElement != null) {
            Element element;
            String subsystemID = subsystemElement.getAttribute("ID");
            processType = "ADD";
            NodeList nodeList = this.frame_.getDomDocument().getElementsByTagName(tagName);
            int i = 0;
            while (i < nodeList.getLength()) {
                element = (Element)nodeList.item(i);
                if (element.getAttribute("ID").equals(id)) {
                    if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                        if (tagName.equals("Table")) {
                            processType = "MERGE";
                            break;
                        }
                        processType = "REPLACE";
                        break;
                    }
                    processType = "UNMATCH";
                    break;
                }
                ++i;
            }
            if (tagName.equals("Table") && !processType.equals("UNMATCH")) {
                nodeList = fromElement.getElementsByTagName("Refer");
                i = 0;
                while (i < nodeList.getLength()) {
                    element = (Element)nodeList.item(i);
                    if (!this.isValidTableID(element.getAttribute("ToTable"))) {
                        processType = "NO_JOINNED";
                        break;
                    }
                    ++i;
                }
            }
            if (tagName.equals("Function")) {
                processType.equals("UNMATCH");
            }
        }
        return processType;
    }

    void jComboBoxSubsystemInto_actionPerformed(ActionEvent e) {
        if (this.subsystemNodeListInto != null && this.jComboBoxSubsystemInto.getSelectedIndex() >= 0) {
            int i;
            int rowCount;
            Element subsystemElement = this.subsystemNodeListInto.get(this.jComboBoxSubsystemInto.getSelectedIndex());
            if (this.tableModelTableListInto.getRowCount() > 0) {
                rowCount = this.tableModelTableListInto.getRowCount();
                i = 0;
                while (i < rowCount) {
                    this.tableModelTableListInto.removeRow(0);
                    ++i;
                }
            }
            if (this.tableModelFunctionListInto.getRowCount() > 0) {
                rowCount = this.tableModelFunctionListInto.getRowCount();
                i = 0;
                while (i < rowCount) {
                    this.tableModelFunctionListInto.removeRow(0);
                    ++i;
                }
            }
            if (subsystemElement != null) {
                TableRowNumber tableRowNumber;
                Object[] Cell;
                Element element;
                String subsystemID = subsystemElement.getAttribute("ID");
                int rowNumber = 1;
                NodeList nodelist = this.frame_.getDomDocument().getElementsByTagName("Table");
                Editor.SortableDomElementListModel sortingList = this.frame_.getSortedListModel(nodelist, "ID");
                int i2 = 0;
                while (i2 < sortingList.getSize()) {
                    element = (Element)sortingList.getElementAt(i2);
                    if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                        Cell = new Object[]{rowNumber++, element.getAttribute("ID"), element.getAttribute("Name")};
                        this.tableModelTableListInto.addRow(Cell);
                    }
                    ++i2;
                }
                rowNumber = 1;
                nodelist = this.frame_.getDomDocument().getElementsByTagName("Function");
                sortingList = this.frame_.getSortedListModel(nodelist, "ID");
                i2 = 0;
                while (i2 < sortingList.getSize()) {
                    element = (Element)sortingList.getElementAt(i2);
                    if (element.getAttribute("SubsystemID").equals(subsystemID)) {
                        Cell = new Object[]{rowNumber++, element.getAttribute("ID"), element.getAttribute("Name")};
                        this.tableModelFunctionListInto.addRow(Cell);
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.tableModelTableListFrom.getRowCount()) {
                    tableRowNumber = (TableRowNumber)this.tableModelTableListFrom.getValueAt(i2, 0);
                    this.tableModelTableListFrom.setValueAt(this.getProcessType("Table", tableRowNumber.getElement().getAttribute("ID"), tableRowNumber.getElement()), i2, 4);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.tableModelFunctionListFrom.getRowCount()) {
                    tableRowNumber = (TableRowNumber)this.tableModelFunctionListFrom.getValueAt(i2, 0);
                    this.tableModelFunctionListFrom.setValueAt(this.getProcessType("Function", tableRowNumber.getElement().getAttribute("ID"), null), i2, 4);
                    ++i2;
                }
                this.jButtonImport.setEnabled(this.isReadyToStartImport());
                this.jCheckBoxImportData.setEnabled(this.isReadyToCheckImportData());
            }
        }
    }

    class CheckBoxHeaderListener
    implements ItemListener {
        private CheckBoxHeaderRenderer rendererComponent_ = null;
        private JTable table_ = null;

        CheckBoxHeaderListener(JTable table) {
            this.table_ = table;
        }

        public void setRenderer(CheckBoxHeaderRenderer rendererComponent) {
            this.rendererComponent_ = rendererComponent;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.rendererComponent_ != null) {
                int i;
                if (this.table_.equals(DialogImport.this.jTableTableListFrom)) {
                    if (this.rendererComponent_.isSelected()) {
                        i = 0;
                        while (i < DialogImport.this.tableModelTableListFrom.getRowCount()) {
                            DialogImport.this.tableModelTableListFrom.setValueAt(Boolean.TRUE, i, 1);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < DialogImport.this.tableModelTableListFrom.getRowCount()) {
                            DialogImport.this.tableModelTableListFrom.setValueAt(Boolean.FALSE, i, 1);
                            ++i;
                        }
                    }
                }
                if (this.table_.equals(DialogImport.this.jTableFunctionListFrom)) {
                    if (this.rendererComponent_.isSelected()) {
                        i = 0;
                        while (i < DialogImport.this.tableModelFunctionListFrom.getRowCount()) {
                            DialogImport.this.tableModelFunctionListFrom.setValueAt(Boolean.TRUE, i, 1);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < DialogImport.this.tableModelFunctionListFrom.getRowCount()) {
                            DialogImport.this.tableModelFunctionListFrom.setValueAt(Boolean.FALSE, i, 1);
                            ++i;
                        }
                    }
                }
                DialogImport.this.jButtonImport.setEnabled(DialogImport.this.isReadyToStartImport());
                DialogImport.this.jCheckBoxImportData.setEnabled(DialogImport.this.isReadyToCheckImportData());
            }
        }
    }

    class CheckBoxHeaderRenderer
    extends JCheckBox
    implements TableCellRenderer,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected CheckBoxHeaderRenderer rendererComponent = this;
        protected int column;
        protected boolean mousePressed = false;

        public CheckBoxHeaderRenderer(CheckBoxHeaderListener itemListener) {
            this.rendererComponent.addItemListener(itemListener);
            itemListener.setRenderer(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                header.addMouseListener(this.rendererComponent);
            }
            this.setColumn(column);
            this.rendererComponent.setText("");
            this.rendererComponent.setBackground(new Color(219, 219, 219));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this.rendererComponent;
        }

        protected void setColumn(int column) {
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }

        protected void handleClickEvent(MouseEvent e) {
            if (this.mousePressed) {
                this.mousePressed = false;
                JTableHeader header = (JTableHeader)e.getSource();
                JTable tableView = header.getTable();
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (viewColumn == this.column && e.getClickCount() == 1 && column != -1) {
                    this.doClick();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleClickEvent(e);
            ((JTableHeader)e.getSource()).repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mousePressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            DialogImport.this.jButtonImport.setEnabled(DialogImport.this.isReadyToStartImport());
            DialogImport.this.jCheckBoxImportData.setEnabled(DialogImport.this.isReadyToCheckImportData());
            return this;
        }
    }

    class TableModelFunctionListFrom
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelFunctionListFrom() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }
    }

    class TableModelReadOnlyList
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelReadOnlyList() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class TableModelTableListFrom
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelTableListFrom() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }
    }

    class TableRowNumber {
        private Element element_;
        private int number_;

        public TableRowNumber(int num, Element elm) {
            this.number_ = num;
            this.element_ = elm;
        }

        public String toString() {
            return Integer.toString(this.number_);
        }

        public Element getElement() {
            return this.element_;
        }
    }
}

