/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogScanField_jButtonCloseDialog_actionAdapter;
import xeadEditor.DialogScanField_jButtonGenerateListData_actionAdapter;
import xeadEditor.DialogScanField_jButtonScan_actionAdapter;
import xeadEditor.Editor;

public class DialogScanField
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private Editor frame_;
    private BorderLayout borderLayoutMain = new BorderLayout();
    private JPanel panelMain = new JPanel();
    private JPanel jPanelNorth = new JPanel();
    private JPanel jPanelSouth = new JPanel();
    private JLabel jLabelFieldID = new JLabel();
    private JTextField jTextFieldFieldID = new JTextField();
    private JLabel jLabelFieldName = new JLabel();
    private JTextField jTextFieldFieldName = new JTextField();
    private JButton jButtonScan = new JButton();
    private JScrollPane jScrollPaneScanResult = new JScrollPane();
    private TableModelReadOnlyList tableModelScanResult = new TableModelReadOnlyList();
    private JTable jTableScanResult = new JTable(this.tableModelScanResult);
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private TableColumn column4;
    private TableColumn column5;
    private TableColumn column6;
    private TableColumn column7;
    private TableColumn column8;
    private DefaultTableCellRenderer rendererTableHeader = null;
    private DefaultTableCellRenderer rendererAlignmentCenter = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rendererAlignmentLeft = new DefaultTableCellRenderer();
    private JScrollPane jScrollPaneMessage = new JScrollPane();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JPanel jPanelButtons = new JPanel();
    private JButton jButtonCloseDialog = new JButton();
    private JButton jButtonGenerateListData = new JButton();
    private JProgressBar jProgressBar = new JProgressBar();
    private ArrayList<String> fieldIDList = new ArrayList();
    private ArrayList<String> fieldNameList = new ArrayList();

    public DialogScanField(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogScanField(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.panelMain.setBorder(null);
        this.panelMain.setLayout(this.borderLayoutMain);
        this.panelMain.add((Component)this.jPanelNorth, "North");
        this.panelMain.add((Component)this.jPanelSouth, "South");
        this.panelMain.add((Component)this.jScrollPaneScanResult, "Center");
        this.jPanelNorth.setBorder(null);
        this.jPanelNorth.setPreferredSize(new Dimension(100, 45));
        this.jLabelFieldID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFieldID.setHorizontalAlignment(4);
        this.jLabelFieldID.setHorizontalTextPosition(10);
        this.jLabelFieldID.setText(res.getString("FieldID"));
        this.jLabelFieldID.setBounds(new Rectangle(5, 9, 120, 28));
        this.jTextFieldFieldID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldFieldID.setBounds(new Rectangle(130, 9, 300, 28));
        this.jLabelFieldName.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelFieldName.setHorizontalAlignment(4);
        this.jLabelFieldName.setHorizontalTextPosition(10);
        this.jLabelFieldName.setText(res.getString("FieldName"));
        this.jLabelFieldName.setBounds(new Rectangle(440, 9, 120, 28));
        this.jTextFieldFieldName.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldFieldName.setBounds(new Rectangle(565, 9, 300, 28));
        this.jButtonScan.setBounds(new Rectangle(880, 9, 120, 28));
        this.jButtonScan.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonScan.setText(res.getString("ScanStart"));
        this.jButtonScan.addActionListener(new DialogScanField_jButtonScan_actionAdapter(this));
        this.jProgressBar.setBounds(new Rectangle(880, 9, 120, 28));
        this.jProgressBar.setVisible(false);
        this.jPanelNorth.setLayout(null);
        this.jPanelNorth.add(this.jLabelFieldID);
        this.jPanelNorth.add(this.jTextFieldFieldID);
        this.jPanelNorth.add(this.jLabelFieldName);
        this.jPanelNorth.add(this.jTextFieldFieldName);
        this.jPanelNorth.add(this.jButtonScan);
        this.jPanelNorth.add(this.jProgressBar);
        this.jTableScanResult.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTableScanResult.setBackground(SystemColor.control);
        this.jTableScanResult.setAutoResizeMode(0);
        this.jTableScanResult.setSelectionMode(0);
        this.jTableScanResult.setRowSelectionAllowed(true);
        this.jTableScanResult.setRowHeight(24);
        this.tableModelScanResult.addColumn("No.");
        this.tableModelScanResult.addColumn(res.getString("SubsystemName"));
        this.tableModelScanResult.addColumn(res.getString("TableID"));
        this.tableModelScanResult.addColumn(res.getString("TableName"));
        this.tableModelScanResult.addColumn(res.getString("FieldID"));
        this.tableModelScanResult.addColumn(res.getString("FieldName"));
        this.tableModelScanResult.addColumn(res.getString("FieldType"));
        this.tableModelScanResult.addColumn(res.getString("FieldExtType"));
        this.tableModelScanResult.addColumn(res.getString("Remarks"));
        this.column0 = this.jTableScanResult.getColumnModel().getColumn(0);
        this.column1 = this.jTableScanResult.getColumnModel().getColumn(1);
        this.column2 = this.jTableScanResult.getColumnModel().getColumn(2);
        this.column3 = this.jTableScanResult.getColumnModel().getColumn(3);
        this.column4 = this.jTableScanResult.getColumnModel().getColumn(4);
        this.column5 = this.jTableScanResult.getColumnModel().getColumn(5);
        this.column6 = this.jTableScanResult.getColumnModel().getColumn(6);
        this.column7 = this.jTableScanResult.getColumnModel().getColumn(7);
        this.column8 = this.jTableScanResult.getColumnModel().getColumn(8);
        this.column0.setPreferredWidth(40);
        this.column1.setPreferredWidth(200);
        this.column2.setPreferredWidth(100);
        this.column3.setPreferredWidth(200);
        this.column4.setPreferredWidth(150);
        this.column5.setPreferredWidth(200);
        this.column6.setPreferredWidth(150);
        this.column7.setPreferredWidth(200);
        this.column8.setPreferredWidth(200);
        this.rendererAlignmentCenter.setHorizontalAlignment(0);
        this.rendererAlignmentLeft.setHorizontalAlignment(2);
        this.column0.setCellRenderer(this.rendererAlignmentCenter);
        this.column1.setCellRenderer(this.rendererAlignmentLeft);
        this.column2.setCellRenderer(this.rendererAlignmentLeft);
        this.column3.setCellRenderer(this.rendererAlignmentLeft);
        this.column4.setCellRenderer(this.rendererAlignmentLeft);
        this.column5.setCellRenderer(this.rendererAlignmentLeft);
        this.column6.setCellRenderer(this.rendererAlignmentLeft);
        this.column7.setCellRenderer(this.rendererAlignmentLeft);
        this.column8.setCellRenderer(this.rendererAlignmentLeft);
        this.jTableScanResult.getTableHeader().setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.rendererTableHeader = (DefaultTableCellRenderer)this.jTableScanResult.getTableHeader().getDefaultRenderer();
        this.rendererTableHeader.setHorizontalAlignment(2);
        this.jScrollPaneScanResult.getViewport().add((Component)this.jTableScanResult, null);
        this.jPanelSouth.setBorder(null);
        this.jPanelSouth.setLayout(new BorderLayout());
        this.jPanelSouth.add((Component)this.jScrollPaneMessage, "Center");
        this.jPanelSouth.add((Component)this.jPanelButtons, "South");
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setWrapStyleWord(true);
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setBackground(SystemColor.control);
        this.jScrollPaneMessage.getViewport().add((Component)this.jTextAreaMessage, null);
        this.jPanelSouth.setPreferredSize(new Dimension(100, 95));
        this.jPanelButtons.setBorder(null);
        this.jPanelButtons.setPreferredSize(new Dimension(100, 43));
        this.jButtonCloseDialog.setBounds(new Rectangle(40, 8, 100, 27));
        this.jButtonCloseDialog.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCloseDialog.setText(res.getString("Close"));
        this.jButtonCloseDialog.addActionListener(new DialogScanField_jButtonCloseDialog_actionAdapter(this));
        this.jButtonGenerateListData.setBounds(new Rectangle(880, 8, 100, 27));
        this.jButtonGenerateListData.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonGenerateListData.setText(res.getString("GenerateList"));
        this.jButtonGenerateListData.addActionListener(new DialogScanField_jButtonGenerateListData_actionAdapter(this));
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.add(this.jButtonGenerateListData);
        this.jPanelButtons.add(this.jButtonCloseDialog);
        this.setResizable(false);
        this.setTitle(res.getString("ScanField"));
        this.getContentPane().add(this.panelMain);
        this.getRootPane().setDefaultButton(this.jButtonScan);
        this.setPreferredSize(new Dimension(1024, 768));
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public void request() {
        if (this.tableModelScanResult.getRowCount() > 0) {
            int rowCount = this.tableModelScanResult.getRowCount();
            int i = 0;
            while (i < rowCount) {
                this.tableModelScanResult.removeRow(0);
                ++i;
            }
        }
        this.jTextAreaMessage.setText(res.getString("ScanFieldHintMessage"));
        super.setVisible(true);
    }

    void jButtonScan_actionPerformed(ActionEvent e) {
        boolean isToBeSelected = false;
        int rowNumber = 0;
        String subsystemID = "";
        String subsystemName = "";
        try {
            StringTokenizer tokenizer;
            int i;
            this.setCursor(new Cursor(3));
            if (this.tableModelScanResult.getRowCount() > 0) {
                int rowCount = this.tableModelScanResult.getRowCount();
                i = 0;
                while (i < rowCount) {
                    this.tableModelScanResult.removeRow(0);
                    ++i;
                }
            }
            this.fieldIDList.clear();
            this.jTextFieldFieldID.setText(this.jTextFieldFieldID.getText().toUpperCase());
            String wrkStr = this.jTextFieldFieldID.getText().replaceAll(" ", "");
            if (wrkStr.contains(";")) {
                tokenizer = new StringTokenizer(wrkStr, ";");
                while (tokenizer.hasMoreTokens()) {
                    this.fieldIDList.add(tokenizer.nextToken());
                }
            } else {
                this.fieldIDList.add(wrkStr);
            }
            this.fieldNameList.clear();
            wrkStr = this.jTextFieldFieldName.getText().replaceAll(" ", "");
            if (wrkStr.contains(";")) {
                tokenizer = new StringTokenizer(wrkStr, ";");
                while (tokenizer.hasMoreTokens()) {
                    this.fieldNameList.add(tokenizer.nextToken());
                }
            } else {
                this.fieldNameList.add(wrkStr);
            }
            NodeList tableList = this.frame_.getDomDocument().getElementsByTagName("Table");
            Editor.SortableDomElementListModel sortedTableList = this.frame_.getSortedListModel(tableList, "SubsystemID");
            this.jProgressBar.setValue(0);
            this.jProgressBar.setMaximum(sortedTableList.getSize());
            this.jProgressBar.setVisible(true);
            this.jButtonScan.setVisible(false);
            NodeList subsystemList = this.frame_.getDomDocument().getElementsByTagName("Subsystem");
            i = 0;
            while (i < sortedTableList.getSize()) {
                int j;
                this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
                this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
                Element tableElement = (Element)sortedTableList.getElementAt(i);
                if (!subsystemID.equals(tableElement.getAttribute("SubsystemID"))) {
                    subsystemID = tableElement.getAttribute("SubsystemID");
                    j = 0;
                    while (j < subsystemList.getLength()) {
                        Element subsystemElement = (Element)subsystemList.item(j);
                        if (subsystemElement.getAttribute("ID").equals(subsystemID)) {
                            subsystemName = subsystemElement.getAttribute("Name");
                        }
                        ++j;
                    }
                }
                NodeList fieldList = tableElement.getElementsByTagName("Field");
                Editor.SortableDomElementListModel sortedFieldList = this.frame_.getSortedListModel(fieldList, "Order");
                j = 0;
                while (j < sortedFieldList.getSize()) {
                    Element fieldElement = (Element)sortedFieldList.getElementAt(j);
                    isToBeSelected = false;
                    if (this.jTextFieldFieldID.getText().equals("") && this.jTextFieldFieldName.getText().equals("")) {
                        isToBeSelected = true;
                    } else {
                        int k = 0;
                        while (k < this.fieldIDList.size()) {
                            if (this.fieldIDList.get(k).startsWith("*")) {
                                if (this.fieldIDList.get(k).endsWith("*")) {
                                    if (fieldElement.getAttribute("ID").contains(this.fieldIDList.get(k).replaceAll("\\*", ""))) {
                                        isToBeSelected = true;
                                    }
                                } else if (fieldElement.getAttribute("ID").endsWith(this.fieldIDList.get(k).replaceAll("\\*", ""))) {
                                    isToBeSelected = true;
                                }
                            } else if (this.fieldIDList.get(k).endsWith("*")) {
                                if (fieldElement.getAttribute("ID").startsWith(this.fieldIDList.get(k).replaceAll("\\*", ""))) {
                                    isToBeSelected = true;
                                }
                            } else if (fieldElement.getAttribute("ID").equals(this.fieldIDList.get(k))) {
                                isToBeSelected = true;
                            }
                            ++k;
                        }
                        if (!isToBeSelected) {
                            k = 0;
                            while (k < this.fieldNameList.size()) {
                                if (this.fieldNameList.get(k).startsWith("*")) {
                                    if (this.fieldNameList.get(k).endsWith("*")) {
                                        if (fieldElement.getAttribute("Name").contains(this.fieldNameList.get(k).replaceAll("\\*", ""))) {
                                            isToBeSelected = true;
                                        }
                                    } else if (fieldElement.getAttribute("Name").endsWith(this.fieldNameList.get(k).replaceAll("\\*", ""))) {
                                        isToBeSelected = true;
                                    }
                                } else if (this.fieldNameList.get(k).endsWith("*")) {
                                    if (fieldElement.getAttribute("Name").startsWith(this.fieldNameList.get(k).replaceAll("\\*", ""))) {
                                        isToBeSelected = true;
                                    }
                                } else if (fieldElement.getAttribute("Name").equals(this.fieldNameList.get(k))) {
                                    isToBeSelected = true;
                                }
                                ++k;
                            }
                        }
                    }
                    if (isToBeSelected) {
                        Object[] Cell = new Object[9];
                        Cell[0] = ++rowNumber;
                        Cell[1] = String.valueOf(tableElement.getAttribute("SubsystemID")) + " " + subsystemName;
                        Cell[2] = tableElement.getAttribute("ID");
                        Cell[3] = tableElement.getAttribute("Name");
                        if (this.frame_.getOptionList(fieldElement.getAttribute("TypeOptions")).contains("VIRTUAL")) {
                            Cell[4] = "(" + fieldElement.getAttribute("ID") + ")";
                            Cell[5] = fieldElement.getAttribute("Name");
                        } else {
                            Cell[4] = fieldElement.getAttribute("ID");
                            Cell[5] = fieldElement.getAttribute("Name");
                        }
                        Cell[6] = this.frame_.getDescriptionsOfTypeAndSize(fieldElement.getAttribute("Type"), fieldElement.getAttribute("Size"), fieldElement.getAttribute("Decimal"));
                        Cell[7] = this.frame_.getDescriptionsOfTypeOptions(fieldElement, false, null);
                        Cell[8] = this.frame_.getFirstParagraph(fieldElement.getAttribute("Remarks"));
                        this.tableModelScanResult.addRow(Cell);
                    }
                    ++j;
                }
                ++i;
            }
        }
        finally {
            this.jProgressBar.setVisible(false);
            this.jButtonScan.setVisible(true);
            this.setCursor(new Cursor(0));
        }
        if (rowNumber == 0) {
            this.jTextAreaMessage.setText(res.getString("ScanFieldNotFound"));
        } else {
            this.jTextAreaMessage.setText(String.valueOf(rowNumber) + res.getString("ScanFieldFound"));
        }
    }

    void jButtonGenerateListData_actionPerformed(ActionEvent e) {
        try {
            this.frame_.getDesktop().browse(this.getExcellBookURI());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, "IOException : " + e1.getMessage());
            e1.printStackTrace(this.frame_.getExceptionStream());
        }
    }

    URI getExcellBookURI() {
        File xlsFile = null;
        String xlsFileName = "";
        FileOutputStream fileOutputStream = null;
        HSSFWorkbook workBook = new HSSFWorkbook();
        HSSFSheet workSheet = workBook.createSheet(this.getTitle());
        workSheet.setDefaultRowHeight((short)300);
        HSSFFooter workSheetFooter = workSheet.getFooter();
        workSheetFooter.setRight(String.valueOf(this.getTitle()) + "  Page " + HSSFFooter.page() + " / " + HSSFFooter.numPages());
        HSSFCellStyle styleHeader = workBook.createCellStyle();
        styleHeader.setAlignment((short)1);
        HSSFCellStyle styleHeaderNumber = workBook.createCellStyle();
        styleHeaderNumber.setAlignment((short)1);
        HSSFCellStyle styleDataInteger = workBook.createCellStyle();
        styleDataInteger.setAlignment((short)3);
        styleDataInteger.setVerticalAlignment((short)0);
        styleDataInteger.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0"));
        HSSFCellStyle styleDataString = workBook.createCellStyle();
        styleDataString.setAlignment((short)1);
        styleDataString.setVerticalAlignment((short)0);
        styleDataString.setWrapText(true);
        styleDataString.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        int currentRowNumber = -1;
        try {
            File outputFolder = null;
            String wrkStr = this.frame_.getSystemNode().getElement().getAttribute("OutputFolder");
            if (wrkStr.equals("")) {
                outputFolder = null;
            } else {
                if (wrkStr.contains("<CURRENT>")) {
                    wrkStr = wrkStr.replace("<CURRENT>", this.frame_.getCurrentFileFolder());
                }
                if (!(outputFolder = new File(wrkStr)).exists()) {
                    outputFolder = null;
                }
            }
            xlsFile = File.createTempFile("XeadEditor_CheckFunctionsCalled_", ".xls", outputFolder);
            if (outputFolder == null) {
                xlsFile.deleteOnExit();
            }
            xlsFileName = xlsFile.getPath();
            fileOutputStream = new FileOutputStream(xlsFileName);
            HSSFRow rowCaption = workSheet.createRow(++currentRowNumber);
            int i = 0;
            while (i < this.tableModelScanResult.getColumnCount()) {
                HSSFCell cell = rowCaption.createCell(i);
                cell.setCellStyle(styleHeaderNumber);
                cell.setCellValue((RichTextString)new HSSFRichTextString(this.tableModelScanResult.getColumnName(i)));
                Rectangle rect = this.jTableScanResult.getCellRect(0, i, true);
                workSheet.setColumnWidth(i, rect.width * 40);
                ++i;
            }
            i = 0;
            while (i < this.tableModelScanResult.getRowCount()) {
                HSSFRow rowData = workSheet.createRow(++currentRowNumber);
                HSSFCell cell0 = rowData.createCell(0);
                cell0.setCellType(0);
                cell0.setCellStyle(styleDataInteger);
                cell0.setCellValue((double)(i + 1));
                int j = 1;
                while (j < 9) {
                    HSSFCell cell = rowData.createCell(j);
                    cell.setCellType(1);
                    cell.setCellStyle(styleDataString);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(this.tableModelScanResult.getValueAt(i, j).toString()));
                    ++j;
                }
                ++i;
            }
            workBook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception ex1) {
            JOptionPane.showMessageDialog(null, "Exception : " + ex1.getMessage());
            ex1.printStackTrace(this.frame_.getExceptionStream());
            try {
                fileOutputStream.close();
            }
            catch (Exception ex2) {
                ex2.printStackTrace(this.frame_.getExceptionStream());
            }
        }
        return xlsFile.toURI();
    }

    void jButtonCloseDialog_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class TableModelReadOnlyList
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        TableModelReadOnlyList() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

