/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xeadEditor.DialogToEditValuesOfKUBUN_jButtonCancel_actionAdapter;
import xeadEditor.DialogToEditValuesOfKUBUN_jButtonStart_actionAdapter;
import xeadEditor.DialogToEditValuesOfKUBUN_jTextAreaValues_keyAdapter;
import xeadEditor.Editor;

public class DialogToEditValuesOfKUBUN
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JPanel panelMain = new JPanel();
    private JButton jButtonStart = new JButton();
    private JButton jButtonCancel = new JButton();
    private JTextArea jTextAreaNotes = new JTextArea();
    private JTextArea jTextAreaValues = new JTextArea();
    private JScrollPane jScrollPane = new JScrollPane();
    private String originalValues = "";
    private String idKubun = "";
    private boolean isExecuted = false;
    private Editor frame_;
    private Element systemElement;
    private HashMap<String, String> kubunMapOriginal = new HashMap();
    private HashMap<String, String> kubunMapEditted = new HashMap();
    private HashMap<String, String> kubunMapEdittedProcess = new HashMap();
    private StringTokenizer tokenizer;

    public DialogToEditValuesOfKUBUN(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogToEditValuesOfKUBUN(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.setTitle(res.getString("EditValuesOfKUBUN"));
        this.jTextAreaNotes.setText(res.getString("EditValuesOfKUBUNNotes"));
        this.jTextAreaNotes.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaNotes.setEditable(false);
        this.jTextAreaNotes.setLineWrap(true);
        this.jTextAreaNotes.setBackground(SystemColor.control);
        this.jTextAreaNotes.setBounds(new Rectangle(0, 0, 435, 100));
        this.jTextAreaNotes.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextAreaValues.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaValues.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextAreaValues.setEditable(true);
        this.jTextAreaValues.setBackground(Color.white);
        this.jTextAreaValues.addKeyListener(new DialogToEditValuesOfKUBUN_jTextAreaValues_keyAdapter(this));
        this.jScrollPane.setBounds(new Rectangle(0, 100, 435, 257));
        this.jScrollPane.getViewport().add((Component)this.jTextAreaValues, null);
        this.jButtonStart.setBounds(new Rectangle(200, 370, 200, 30));
        this.jButtonStart.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonStart.setText(res.getString("Execute"));
        this.jButtonStart.addActionListener(new DialogToEditValuesOfKUBUN_jButtonStart_actionAdapter(this));
        this.jButtonCancel.setBounds(new Rectangle(30, 370, 110, 30));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("Close"));
        this.jButtonCancel.addActionListener(new DialogToEditValuesOfKUBUN_jButtonCancel_actionAdapter(this));
        this.panelMain.setLayout(null);
        this.panelMain.setPreferredSize(new Dimension(440, 413));
        this.panelMain.setBorder(BorderFactory.createEtchedBorder());
        this.panelMain.add((Component)this.jTextAreaNotes, null);
        this.panelMain.add((Component)this.jScrollPane, null);
        this.panelMain.add((Component)this.jButtonStart, null);
        this.panelMain.add((Component)this.jButtonCancel, null);
        this.getContentPane().add((Component)this.panelMain, "South");
        this.getRootPane().setDefaultButton(this.jButtonStart);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public boolean request(String id, String values) {
        this.idKubun = id;
        this.originalValues = values;
        this.kubunMapOriginal.clear();
        this.tokenizer = new StringTokenizer(values, "\n");
        while (this.tokenizer.hasMoreTokens()) {
            String lineData = this.tokenizer.nextToken().replaceAll(" ", "");
            if (lineData.indexOf(":") <= -1) continue;
            String key = lineData.substring(0, lineData.indexOf(":"));
            String value = lineData.substring(lineData.indexOf(":"), lineData.length());
            this.kubunMapOriginal.put(key, value);
        }
        this.jTextAreaValues.setText(values);
        this.jTextAreaValues.setCaretPosition(0);
        this.jTextAreaValues.requestFocus();
        this.isExecuted = false;
        this.jButtonStart.setEnabled(false);
        this.getRootPane().setDefaultButton(this.jButtonStart);
        super.setVisible(true);
        return this.isExecuted;
    }

    public void jTextAreaValues_keyTyped(KeyEvent e) {
        if (this.jTextAreaValues.getText().equals(this.originalValues)) {
            this.jButtonStart.setEnabled(false);
        } else {
            this.jButtonStart.setEnabled(true);
        }
    }

    void jButtonStart_actionPerformed(ActionEvent e) {
        this.isExecuted = true;
        ResultSet result = null;
        Statement statement = null;
        StringBuffer buf1 = null;
        Connection connection = null;
        try {
            try {
                this.setCursor(new Cursor(3));
                NodeList elementList = this.frame_.getDomDocument().getElementsByTagName("System");
                this.systemElement = (Element)elementList.item(0);
                String tableID = this.systemElement.getAttribute("UserVariantsTable");
                Editor.MainTreeNode tableNode = this.frame_.getSpecificXETreeNode("Table", tableID);
                connection = this.frame_.databaseConnList.get(this.frame_.databaseIDList.indexOf(tableNode.getElement().getAttribute("DB")));
                if (connection != null && !connection.isClosed()) {
                    String checkValue;
                    String value;
                    String key;
                    this.kubunMapEditted.clear();
                    this.kubunMapEdittedProcess.clear();
                    this.tokenizer = new StringTokenizer(this.jTextAreaValues.getText(), "\n");
                    while (this.tokenizer.hasMoreTokens()) {
                        String lineData = this.tokenizer.nextToken();
                        if (lineData.indexOf(":") <= -1) continue;
                        key = lineData.substring(0, lineData.indexOf(":"));
                        value = lineData.substring(lineData.indexOf(":") + 1, lineData.length());
                        this.kubunMapEditted.put(key, value);
                        checkValue = this.kubunMapOriginal.get(key);
                        if (checkValue == null) {
                            this.kubunMapEdittedProcess.put(key, "INSERT");
                            continue;
                        }
                        if (checkValue.equals(value)) {
                            this.kubunMapEdittedProcess.put(key, "IGNORE");
                            continue;
                        }
                        this.kubunMapEdittedProcess.put(key, "UPDATE");
                    }
                    Set<String> keys = this.kubunMapOriginal.keySet();
                    int i = 0;
                    while (i < keys.size()) {
                        String originalKey = keys.toArray(new String[0])[i];
                        checkValue = this.kubunMapEditted.get(originalKey);
                        if (checkValue == null) {
                            this.kubunMapEditted.put(originalKey, "");
                            this.kubunMapEdittedProcess.put(originalKey, "DELETE");
                        }
                        ++i;
                    }
                    statement = connection.createStatement();
                    keys = this.kubunMapEditted.keySet();
                    i = 0;
                    while (i < keys.size()) {
                        buf1 = new StringBuffer();
                        key = keys.toArray(new String[0])[i];
                        value = this.kubunMapEditted.get(key);
                        String process = this.kubunMapEdittedProcess.get(key);
                        if (process.equals("INSERT")) {
                            buf1 = new StringBuffer();
                            buf1.append("insert into ");
                            buf1.append(tableID);
                            buf1.append(" (IDUSERKUBUN, KBUSERKUBUN, TXUSERKUBUN, SQLIST) values ('");
                            buf1.append(this.idKubun);
                            buf1.append("', '");
                            buf1.append(key);
                            buf1.append("', '");
                            buf1.append(value);
                            buf1.append("', '");
                            buf1.append(key);
                            buf1.append("')");
                        }
                        if (process.equals("UPDATE")) {
                            buf1.append("update ");
                            buf1.append(tableID);
                            buf1.append(" set ");
                            buf1.append("TXUSERKUBUN = '");
                            buf1.append(value);
                            buf1.append("'");
                            buf1.append(" where IDUSERKUBUN = '");
                            buf1.append(this.idKubun);
                            buf1.append("' and KBUSERKUBUN = '");
                            buf1.append(key);
                            buf1.append("'");
                        }
                        if (process.equals("DELETE")) {
                            buf1.append("delete from ");
                            buf1.append(tableID);
                            buf1.append(" where IDUSERKUBUN = '");
                            buf1.append(this.idKubun);
                            buf1.append("' and KBUSERKUBUN = '");
                            buf1.append(key);
                            buf1.append("'");
                        }
                        statement.executeUpdate(buf1.toString());
                        ++i;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, res.getString("EditValuesOfKUBUNError"));
                }
                this.isExecuted = true;
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog(this, "SQL Error: " + ex.toString());
                try {
                    if (result != null) {
                        result.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                this.setCursor(new Cursor(0));
                super.setVisible(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (result != null) {
                        result.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
                this.setCursor(new Cursor(0));
                super.setVisible(false);
            }
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            this.setCursor(new Cursor(0));
            super.setVisible(false);
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

