/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xeadEditor.DialogToListChangesOfFiles_jButtonCancel_actionAdapter;
import xeadEditor.DialogToListChangesOfFiles_jButtonStart_actionAdapter;
import xeadEditor.Editor;

public class DialogToListChangesOfFiles
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JPanel panelMain = new JPanel();
    private JScrollPane jScrollPane = new JScrollPane();
    private JProgressBar jProgressBar = new JProgressBar();
    private JButton jButtonStart = new JButton();
    private JButton jButtonCancel = new JButton();
    private JTextArea jTextArea = new JTextArea();
    private JLabel jLabel1 = new JLabel();
    private JTextField jTextFieldImportFileName = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JTextField jTextFieldImportSystemName = new JTextField();
    private Editor frame_;
    private Document domDocumentOld;
    private Element systemElementOld;
    private Element systemElementNew;
    private int countOfChanges = 0;
    private StringBuffer buffer;

    public DialogToListChangesOfFiles(Editor frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.frame_ = frame;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DialogToListChangesOfFiles(Editor frame) {
        this(frame, "", true);
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.setTitle(res.getString("FileDiff"));
        this.jLabel1.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(res.getString("FileDiffTargetFile"));
        this.jLabel1.setBounds(new Rectangle(5, 12, 170, 20));
        this.jTextFieldImportFileName.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldImportFileName.setBounds(new Rectangle(180, 9, 650, 25));
        this.jTextFieldImportFileName.setEditable(false);
        this.jLabel2.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(res.getString("FileDiffTargetSystem"));
        this.jLabel2.setBounds(new Rectangle(5, 43, 170, 20));
        this.jTextFieldImportSystemName.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldImportSystemName.setBounds(new Rectangle(180, 40, 650, 25));
        this.jTextFieldImportSystemName.setEditable(false);
        this.jScrollPane.setBounds(new Rectangle(9, 73, 822, 458));
        this.jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane.getViewport().add(this.jTextArea);
        this.jTextArea.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextArea.setEditable(false);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setBackground(SystemColor.control);
        this.jTextArea.setBorder(null);
        this.jProgressBar.setBounds(new Rectangle(30, 540, 640, 30));
        this.jProgressBar.setStringPainted(true);
        this.jProgressBar.setVisible(false);
        this.jButtonStart.setBounds(new Rectangle(30, 540, 640, 30));
        this.jButtonStart.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonStart.setText(res.getString("Start"));
        this.jButtonStart.addActionListener(new DialogToListChangesOfFiles_jButtonStart_actionAdapter(this));
        this.jButtonCancel.setBounds(new Rectangle(700, 540, 110, 30));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("Close"));
        this.jButtonCancel.addActionListener(new DialogToListChangesOfFiles_jButtonCancel_actionAdapter(this));
        this.panelMain.setLayout(null);
        this.panelMain.setPreferredSize(new Dimension(840, 583));
        this.panelMain.setBorder(BorderFactory.createEtchedBorder());
        this.panelMain.add((Component)this.jLabel1, null);
        this.panelMain.add((Component)this.jLabel2, null);
        this.panelMain.add((Component)this.jTextFieldImportFileName, null);
        this.panelMain.add((Component)this.jTextFieldImportSystemName, null);
        this.panelMain.add((Component)this.jScrollPane, null);
        this.panelMain.add((Component)this.jProgressBar, null);
        this.panelMain.add((Component)this.jButtonStart, null);
        this.panelMain.add((Component)this.jButtonCancel, null);
        this.getContentPane().add((Component)this.panelMain, "South");
        this.getRootPane().setDefaultButton(this.jButtonStart);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = this.getPreferredSize();
        this.setLocation((scrSize.width - dlgSize.width) / 2, (scrSize.height - dlgSize.height) / 2);
        this.pack();
    }

    public void request(String fileName) {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(fileName)));
            this.domDocumentOld = parser.getDocument();
            NodeList elementList = this.domDocumentOld.getElementsByTagName("System");
            this.systemElementOld = (Element)elementList.item(0);
            elementList = this.frame_.getDomDocument().getElementsByTagName("System");
            this.systemElementNew = (Element)elementList.item(0);
            float importFileFormat = Float.parseFloat(this.systemElementOld.getAttribute("FormatVersion"));
            float appliFormat = Float.parseFloat("1.2");
            if (importFileFormat > appliFormat) {
                JOptionPane.showMessageDialog(null, "Format versions of files are not the same. Process is canceled.");
            } else {
                this.jTextFieldImportFileName.setText(fileName);
                this.jTextFieldImportSystemName.setText(String.valueOf(this.systemElementOld.getAttribute("Name")) + " V" + this.systemElementOld.getAttribute("Version"));
                this.jTextArea.setText(res.getString("FileDiffMessage"));
                this.jProgressBar.setValue(0);
                this.jButtonStart.setEnabled(true);
                this.getRootPane().setDefaultButton(this.jButtonStart);
                super.setVisible(true);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "XML format of the file is invalid. Process is canceled.");
        }
    }

    void jButtonStart_actionPerformed(ActionEvent e) {
        try {
            this.setCursor(new Cursor(3));
            this.jButtonStart.setVisible(false);
            this.jProgressBar.setVisible(true);
            this.setupProgressMaxValue();
            this.buffer = new StringBuffer();
            this.countOfChanges = 0;
            this.listChangesOfBasicInfo();
            this.listChangesOfMenu();
            this.listChangesOfSubsystem();
            this.listChangesOfTable();
            this.listChangesOfFunction();
        }
        finally {
            this.jTextArea.setText(String.valueOf(this.countOfChanges) + res.getString("FileDiffMessage10") + this.buffer.toString());
            this.jTextArea.setCaretPosition(0);
            this.jProgressBar.setVisible(false);
            this.jButtonStart.setVisible(true);
            this.jButtonStart.setEnabled(false);
            this.getRootPane().setDefaultButton(this.jButtonCancel);
            this.setCursor(new Cursor(0));
        }
    }

    void setupProgressMaxValue() {
        int countOfElementsProcessed = 0;
        NodeList workElementList = this.systemElementOld.getElementsByTagName("SubDB");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("SubDB");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("PrintFont");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("PrintFont");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("MaintenanceLog");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("MaintenanceLog");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Menu");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Menu");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Subsystem");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Subsystem");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Table");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Table");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Field");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Field");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Key");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Key");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Refer");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Refer");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Script");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Script");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementOld.getElementsByTagName("Function");
        countOfElementsProcessed += workElementList.getLength();
        workElementList = this.systemElementNew.getElementsByTagName("Function");
        this.jProgressBar.setMaximum((countOfElementsProcessed += workElementList.getLength()) + 3);
    }

    void listChangesOfBasicInfo() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        String label = res.getString("System");
        this.buffer.append("\n\n<" + res.getString("SystemInfo") + ">");
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "Name", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "Version", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "Remarks", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "FormatVersion", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "DatabaseName", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "DatabaseUser", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "DatabasePassword", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "DBCP", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "AppServerName", label);
        this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
        this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "VariantsTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "UserTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "UserFilterValueTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "NumberingTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "UserVariantsTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SessionTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SessionDetailTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "TaxTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "CalendarTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "CurrencyTable", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "CurrencyDetailTable", label);
        this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
        this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "AutoConnectToEdit", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "EditorUser", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "EditorUserPassword", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "DriverVMOptions", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SkipPreload", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SkipModuleCheck", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SmtpHost", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SmtpPort", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SmtpUser", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SmtpPassword", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SmtpAdminEmail", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "ImageFileFolder", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "OutputFolder", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "SystemFont", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "HashFormat", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "WelcomePageURL", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "DateFormat", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "LoginScript", label);
        this.compareNewAndOldElements(this.systemElementNew, this.systemElementOld, "ScriptFunctions", label);
        this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
        this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
        String tagName = "SubDB";
        attrList.clear();
        attrList.add("Name");
        attrList.add("User");
        attrList.add("Password");
        attrList.add("DBCP");
        attrList.add("Description");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Description");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Description");
        tagName = "PrintFont";
        attrList.clear();
        attrList.add("FontName");
        attrList.add("PDFFontName");
        attrList.add("PDFEncoding");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "FontName");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "FontName");
        tagName = "MaintenanceLog";
        attrList.clear();
        attrList.add("Headder");
        attrList.add("Descriptions");
        oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "Headder");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "Headder");
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("FileDiffNone"));
        }
    }

    void listChangesOfMenu() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("Menu") + ">");
        String tagName = "Menu";
        attrList.clear();
        attrList.add("Name");
        attrList.add("CrossCheckersToBeLoaded");
        attrList.add("FunctionsToBeLoaded");
        attrList.add("HelpURL");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "ID");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "ID");
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("FileDiffNone"));
        }
    }

    void listChangesOfSubsystem() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("Subsystem") + ">");
        String tagName = "Subsystem";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Remarks");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "ID");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "ID");
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("FileDiffNone"));
        }
    }

    void listChangesOfTable() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("Table") + ">");
        String tagName = "Table";
        attrList.clear();
        attrList.add("Name");
        attrList.add("DB");
        attrList.add("ModuleID");
        attrList.add("Remarks");
        attrList.add("SubsystemID");
        attrList.add("UpdateCounter");
        attrList.add("DetailRowNumberAuto");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "ID");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "ID");
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("FileDiffNone"));
        }
    }

    void listChangesOfFunction() {
        ArrayList<String> attrList = new ArrayList<String>();
        int workCount = this.countOfChanges;
        this.buffer.append("\n\n<" + res.getString("FunctionDefinition") + ">");
        String tagName = "Function";
        attrList.clear();
        attrList.add("Name");
        attrList.add("Type");
        attrList.add("SubsystemID");
        NodeList oldElementList = this.systemElementOld.getElementsByTagName(tagName);
        NodeList newElementList = this.systemElementNew.getElementsByTagName(tagName);
        this.checkIfNewElementChangedOrAdded(newElementList, oldElementList, attrList, tagName, "ID");
        this.checkIfNewElementDeleted(newElementList, oldElementList, tagName, "ID");
        if (this.countOfChanges == workCount) {
            this.buffer.append("\n" + res.getString("FileDiffNone"));
        }
    }

    void compareNewAndOldElements(Element elementNew, Element elementOld, String attribute, String elementLabel) {
        if (!elementNew.getAttribute(attribute).equals(elementOld.getAttribute(attribute))) {
            String attrName = this.getElementNameByTagName(attribute);
            ++this.countOfChanges;
            if (attribute.equals("Remarks") || attribute.equals("Descriptions") || attribute.equals("Text") || attribute.contains("Script")) {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("FileDiffMessage02") + attrName + res.getString("FileDiffMessage01"));
            } else {
                this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("FileDiffMessage02") + attrName + res.getString("FileDiffMessage03") + elementOld.getAttribute(attribute) + res.getString("FileDiffMessage04") + elementNew.getAttribute(attribute) + res.getString("FileDiffMessage05"));
            }
        }
    }

    void checkIfNewElementChangedOrAdded(NodeList newElementList, NodeList oldElementList, ArrayList<String> attrList, String tagName, String nameAttr) {
        String elementName = this.getElementNameByTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            Element newElement = (Element)newElementList.item(i);
            boolean isNotFound = true;
            int j = 0;
            while (j < oldElementList.getLength()) {
                Element oldElement = (Element)oldElementList.item(j);
                if (oldElement.getAttribute(nameAttr).equals(newElement.getAttribute(nameAttr))) {
                    int k = 0;
                    while (k < attrList.size()) {
                        String elementLabel = String.valueOf(elementName) + res.getString("FileDiffMessage06") + newElement.getAttribute(nameAttr) + res.getString("FileDiffMessage07");
                        this.compareNewAndOldElements(newElement, oldElement, attrList.get(k), elementLabel);
                        ++k;
                    }
                    isNotFound = false;
                    if (tagName.equals("Table")) {
                        this.checkTableDetails(oldElement, newElement);
                    }
                    if (!tagName.equals("Function")) break;
                    this.checkFunctionDetails(oldElement, newElement);
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("FileDiffMessage06") + newElement.getAttribute(nameAttr) + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
            }
            ++i;
        }
    }

    void checkIfNewElementDeleted(NodeList newElementList, NodeList oldElementList, String tagName, String nameAttr) {
        String elementName = this.getElementNameByTagName(tagName);
        int i = 0;
        while (i < oldElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            Element oldElement = (Element)oldElementList.item(i);
            boolean isNotFound = true;
            int j = 0;
            while (j < newElementList.getLength()) {
                Element newElement = (Element)newElementList.item(j);
                if (oldElement.getAttribute(nameAttr).equals(newElement.getAttribute(nameAttr))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + elementName + res.getString("FileDiffMessage06") + oldElement.getAttribute(nameAttr) + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
            }
            ++i;
        }
    }

    void checkTableDetails(Element oldElement, Element newElement) {
        int k;
        String elementLabel;
        Element oldElementWork;
        int j;
        boolean isNotFound;
        Element newElementWork;
        ArrayList<String> attrList = new ArrayList<String>();
        String tableLabel = String.valueOf(res.getString("Table")) + res.getString("FileDiffMessage06") + newElement.getAttribute("ID") + res.getString("FileDiffMessage07");
        String tagName = "Field";
        String elementName = this.getElementNameByTagName(tagName);
        attrList.clear();
        attrList.add("Name");
        attrList.add("ColumnName");
        attrList.add("Order");
        attrList.add("Remarks");
        attrList.add("Type");
        attrList.add("Size");
        attrList.add("Decimal");
        attrList.add("Nullable");
        attrList.add("NoUpdate");
        attrList.add("TypeOptions");
        NodeList oldElementList = oldElement.getElementsByTagName(tagName);
        NodeList newElementList = newElement.getElementsByTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("ID").equals(newElementWork.getAttribute("ID"))) {
                    elementLabel = String.valueOf(tableLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("ID") + " " + newElementWork.getAttribute("Name") + res.getString("FileDiffMessage07");
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("ID") + " " + newElementWork.getAttribute("Name") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Name").equals(newElementWork.getAttribute("Name"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("ID") + " " + oldElementWork.getAttribute("Name") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
            }
            ++i;
        }
        tagName = "Key";
        elementName = this.getElementNameByTagName(tagName);
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (newElementWork.getAttribute("Type").equals("PK") && oldElementWork.getAttribute("Type").equals("PK")) {
                    if (!oldElementWork.getAttribute("Fields").equals(newElementWork.getAttribute("Fields"))) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + "[PK]" + res.getString("FileDiffMessage03") + oldElementWork.getAttribute("Fields") + res.getString("FileDiffMessage04") + newElementWork.getAttribute("Fields") + res.getString("FileDiffMessage05"));
                    }
                    isNotFound = false;
                    break;
                }
                if (oldElementWork.getAttribute("Type").equals(newElementWork.getAttribute("Type")) && oldElementWork.getAttribute("Fields").equals(newElementWork.getAttribute("Fields"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + "[" + newElementWork.getAttribute("Type") + "]" + "{" + newElementWork.getAttribute("Fields") + "}" + res.getString("FileDiffMessage08"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Type").equals(newElementWork.getAttribute("Type"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + "[" + oldElementWork.getAttribute("Type") + "]" + "{" + oldElementWork.getAttribute("Fields") + "}" + res.getString("FileDiffMessage09"));
            }
            ++i;
        }
        tagName = "Refer";
        elementName = this.getElementNameByTagName(tagName);
        attrList.clear();
        attrList.add("Order");
        attrList.add("ToKeyFields");
        attrList.add("WithKeyFields");
        attrList.add("Fields");
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (newElementWork.getAttribute("ToTable").equals(oldElementWork.getAttribute("ToTable")) && newElementWork.getAttribute("TableAlias").equals(oldElementWork.getAttribute("TableAlias"))) {
                    elementLabel = newElementWork.getAttribute("TableAlias").equals("") ? String.valueOf(tableLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("ToTable") + res.getString("FileDiffMessage07") : String.valueOf(tableLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("TableAlias") + res.getString("FileDiffMessage07");
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                if (newElementWork.getAttribute("TableAlias").equals("")) {
                    this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("ToTable") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                } else {
                    this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("TableAlias") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                }
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (newElementWork.getAttribute("ToTable").equals(oldElementWork.getAttribute("ToTable")) && newElementWork.getAttribute("TableAlias").equals(oldElementWork.getAttribute("TableAlias"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                if (oldElementWork.getAttribute("TableAlias").equals("")) {
                    this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("ToTable") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                } else {
                    this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("TableAlias") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                }
            }
            ++i;
        }
        tagName = "Script";
        elementName = this.getElementNameByTagName(tagName);
        attrList.clear();
        attrList.add("Order");
        attrList.add("EventP");
        attrList.add("EventR");
        attrList.add("Hold");
        attrList.add("Text");
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (newElementWork.getAttribute("Name").equals(oldElementWork.getAttribute("Name"))) {
                    elementLabel = String.valueOf(tableLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Name") + res.getString("FileDiffMessage07");
                    k = 0;
                    while (k < attrList.size()) {
                        this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                        ++k;
                    }
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Name") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            this.jProgressBar.setValue(this.jProgressBar.getValue() + 1);
            this.jProgressBar.paintImmediately(0, 0, this.jProgressBar.getWidth(), this.jProgressBar.getHeight());
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (newElementWork.getAttribute("Name").equals(oldElementWork.getAttribute("Name"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                ++this.countOfChanges;
                this.buffer.append("\n" + this.countOfChanges + "." + tableLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Name") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
            }
            ++i;
        }
    }

    void checkFunctionDetails(Element oldElement, Element newElement) {
        ArrayList<String> attrList = new ArrayList<String>();
        String functionLabel = String.valueOf(res.getString("FunctionDefinition")) + res.getString("FileDiffMessage06") + newElement.getAttribute("ID") + res.getString("FileDiffMessage07");
        if (newElement.getAttribute("Type").equals(oldElement.getAttribute("Type"))) {
            int k;
            String elementLabel;
            Element oldElementWork;
            int j;
            boolean isNotFound;
            Element newElementWork;
            NodeList newElementList;
            NodeList oldElementList;
            String elementName;
            String tagName;
            int i;
            if (newElement.getAttribute("Type").equals("XF000")) {
                attrList.clear();
                attrList.add("TimerOption");
                attrList.add("TimerMessage");
                attrList.add("ServiceName");
                attrList.add("Script");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF100") || newElement.getAttribute("Type").equals("XF110")) {
                attrList.clear();
                attrList.add("PrimaryTable");
                attrList.add("KeyFields");
                attrList.add("OrderBy");
                attrList.add("FixedWhere");
                attrList.add("InitialListing");
                attrList.add("Size");
                attrList.add("InitialReadCount");
                attrList.add("InitialMsg");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF100")) {
                attrList.clear();
                attrList.add("DetailFunction");
                attrList.add("ParmType");
                attrList.add("ParmAdditional");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF110")) {
                attrList.clear();
                attrList.add("BatchTable");
                attrList.add("BatchKeyFields");
                attrList.add("BatchWithKeyFields");
                attrList.add("BatchRecordFunction");
                attrList.add("BatchRecordFunctionMsg");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF200")) {
                attrList.clear();
                attrList.add("PrimaryTable");
                attrList.add("KeyFields");
                attrList.add("FixedWhere");
                attrList.add("FunctionAfterInsert");
                attrList.add("Size");
                attrList.add("UpdateOnly");
                attrList.add("InitialMsg");
                attrList.add("DataName");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF290")) {
                attrList.clear();
                attrList.add("PrimaryTable");
                attrList.add("KeyFields");
                attrList.add("PageSize");
                attrList.add("Direction");
                attrList.add("Margins");
                attrList.add("WithPangeNumber");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF300")) {
                attrList.clear();
                attrList.add("HeaderTable");
                attrList.add("HeaderKeyFields");
                attrList.add("FixedWhere");
                attrList.add("HeaderFunction");
                attrList.add("HeaderParmAdditional");
                attrList.add("Size");
                attrList.add("StructureTable");
                attrList.add("StructureUpperKeys");
                attrList.add("StructureChildKeys");
                attrList.add("StructureOrderBy");
                attrList.add("StructureRootText");
                attrList.add("StructureNodeText");
                attrList.add("StructureNodeDefaultIcon");
                attrList.add("StructureNodeIconsFieldID");
                attrList.add("StructureNodeIconsFieldValues");
                attrList.add("StructureNodeIcons");
                attrList.add("StructureViewWidth");
                attrList.add("StructureViewTitle");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF310")) {
                attrList.clear();
                attrList.add("HeaderTable");
                attrList.add("HeaderKeyFields");
                attrList.add("HeaderFixedWhere");
                attrList.add("DetailTable");
                attrList.add("DetailKeyFields");
                attrList.add("DetailFixedWhere");
                attrList.add("DetailOrderBy");
                attrList.add("Size");
                attrList.add("StartInAddMode");
                attrList.add("InitialMsg");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF390")) {
                attrList.clear();
                attrList.add("HeaderTable");
                attrList.add("HeaderKeyFields");
                attrList.add("HeaderFixedWhere");
                attrList.add("DetailTable");
                attrList.add("DetailKeyFields");
                attrList.add("DetailFixedWhere");
                attrList.add("DetailOrderBy");
                attrList.add("PageSize");
                attrList.add("Direction");
                attrList.add("Margins");
                attrList.add("WithPageNumber");
                i = 0;
                while (i < attrList.size()) {
                    this.compareNewAndOldElements(newElement, oldElement, (String)attrList.get(i), functionLabel);
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF100") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable")) || newElement.getAttribute("Type").equals("XF110") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable")) || newElement.getAttribute("Type").equals("XF310") && newElement.getAttribute("DetailTable").equals(oldElement.getAttribute("DetailTable"))) {
                tagName = "Column";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Order");
                attrList.add("FieldOptions");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF100") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable")) || newElement.getAttribute("Type").equals("XF110") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable"))) {
                tagName = "Filter";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Order");
                attrList.add("FieldOptions");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF110") && newElement.getAttribute("BatchTable").equals(oldElement.getAttribute("BatchTable"))) {
                tagName = "BatchField";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Order");
                attrList.add("FieldOptions");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF200") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable")) || newElement.getAttribute("Type").equals("XF300") && newElement.getAttribute("HeaderTable").equals(oldElement.getAttribute("HeaderTable")) || newElement.getAttribute("Type").equals("XF310") && newElement.getAttribute("HeaderTable").equals(oldElement.getAttribute("HeaderTable"))) {
                tagName = "Field";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Order");
                attrList.add("FieldOptions");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF200") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable"))) {
                tagName = "Tab";
                elementName = this.getElementNameByTagName(tagName);
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("Caption").equals(newElementWork.getAttribute("Caption"))) {
                            if (!oldElementWork.isEqualNode(newElementWork)) {
                                ++this.countOfChanges;
                                this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Caption") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage11"));
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Caption") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("Caption").equals(newElementWork.getAttribute("Caption"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Caption") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF100") || newElement.getAttribute("Type").equals("XF110") || newElement.getAttribute("Type").equals("XF200") || newElement.getAttribute("Type").equals("XF310")) {
                tagName = "Button";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Position");
                attrList.add("Caption");
                attrList.add("Action");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("Number").equals(newElementWork.getAttribute("Number"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + "F" + newElementWork.getAttribute("Number") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + "F" + newElementWork.getAttribute("Number") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("Number").equals(newElementWork.getAttribute("Number")) && oldElementWork.getAttribute("Action").equals(newElementWork.getAttribute("Action"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + "F" + oldElementWork.getAttribute("Number") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF290") && newElement.getAttribute("PrimaryTable").equals(oldElement.getAttribute("PrimaryTable"))) {
                tagName = "Phrase";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Block");
                attrList.add("Order");
                attrList.add("Alignment");
                attrList.add("AlignmentMargin");
                attrList.add("SpacingAfter");
                attrList.add("FontID");
                attrList.add("FontSize");
                attrList.add("FontStyle");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("Value").equals(newElementWork.getAttribute("Value"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Value") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Value") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("Value").equals(newElementWork.getAttribute("Value"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Value") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF390") && newElement.getAttribute("HeaderTable").equals(oldElement.getAttribute("HeaderTable"))) {
                tagName = "HeaderPhrase";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Block");
                attrList.add("Order");
                attrList.add("Alignment");
                attrList.add("AlignmentMargin");
                attrList.add("SpacingAfter");
                attrList.add("FontID");
                attrList.add("FontSize");
                attrList.add("FontStyle");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("Value").equals(newElementWork.getAttribute("Value"))) {
                            elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Value") + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Value") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("Value").equals(newElementWork.getAttribute("Value"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Value") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF300") && newElement.getAttribute("HeaderTable").equals(oldElement.getAttribute("HeaderTable"))) {
                tagName = "Detail";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Caption");
                attrList.add("Order");
                attrList.add("HeaderKeyFields");
                attrList.add("OrderBy");
                attrList.add("FixedWhere");
                attrList.add("DetailFunction");
                attrList.add("ParmType");
                attrList.add("ParmAdditional");
                attrList.add("InitialReadCount");
                attrList.add("InitialListing");
                attrList.add("InitialMsg");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("Table").equals(newElementWork.getAttribute("Table")) && oldElementWork.getAttribute("KeyFields").equals(newElementWork.getAttribute("KeyFields"))) {
                            elementLabel = newElementWork.getAttribute("KeyFields").equals("") ? String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{PK}" + res.getString("FileDiffMessage07") : String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{" + newElementWork.getAttribute("KeyFields") + "}" + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            this.compareSubElementsOfXF300Details(newElementWork, oldElementWork, elementLabel);
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        if (newElementWork.getAttribute("KeyFields").equals("")) {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{PK}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                        } else {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{" + newElementWork.getAttribute("KeyFields") + "}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("Table").equals(newElementWork.getAttribute("Table")) && oldElementWork.getAttribute("KeyFields").equals(newElementWork.getAttribute("KeyFields"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        if (oldElementWork.getAttribute("KeyFields").equals("")) {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Table") + "{PK}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                        } else {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Table") + "{" + oldElementWork.getAttribute("KeyFields") + "}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                        }
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF390") && newElement.getAttribute("HeaderTable").equals(oldElement.getAttribute("HeaderTable"))) {
                tagName = "Detail";
                elementName = this.getElementNameByTagName(tagName);
                attrList.clear();
                attrList.add("Caption");
                attrList.add("CaptionFontSize");
                attrList.add("CaptionFontStyle");
                attrList.add("Order");
                attrList.add("HeaderKeyFields");
                attrList.add("OrderBy");
                attrList.add("FixedWhere");
                attrList.add("FontID");
                attrList.add("FontSize");
                attrList.add("FontStyle");
                oldElementList = oldElement.getElementsByTagName(tagName);
                newElementList = newElement.getElementsByTagName(tagName);
                i = 0;
                while (i < newElementList.getLength()) {
                    newElementWork = (Element)newElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(j);
                        if (oldElementWork.getAttribute("Table").equals(newElementWork.getAttribute("Table")) && oldElementWork.getAttribute("KeyFields").equals(newElementWork.getAttribute("KeyFields"))) {
                            elementLabel = newElementWork.getAttribute("KeyFields").equals("") ? String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{PK}" + res.getString("FileDiffMessage07") : String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{" + newElementWork.getAttribute("KeyFields") + "}" + res.getString("FileDiffMessage07");
                            k = 0;
                            while (k < attrList.size()) {
                                this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                ++k;
                            }
                            this.compareSubElementsOfXF390Details(newElementWork, oldElementWork, elementLabel);
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        if (newElementWork.getAttribute("KeyFields").equals("")) {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{PK}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                        } else {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("Table") + "{" + newElementWork.getAttribute("KeyFields") + "}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < oldElementList.getLength()) {
                    oldElementWork = (Element)oldElementList.item(i);
                    isNotFound = true;
                    j = 0;
                    while (j < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(j);
                        if (oldElementWork.getAttribute("Table").equals(newElementWork.getAttribute("Table")) && oldElementWork.getAttribute("KeyFields").equals(newElementWork.getAttribute("KeyFields"))) {
                            isNotFound = false;
                            break;
                        }
                        ++j;
                    }
                    if (isNotFound) {
                        ++this.countOfChanges;
                        if (oldElementWork.getAttribute("KeyFields").equals("")) {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Table") + "{PK}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                        } else {
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("Table") + "{" + oldElementWork.getAttribute("KeyFields") + "}" + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                        }
                    }
                    ++i;
                }
            }
            if (newElement.getAttribute("Type").equals("XF390") && newElement.getAttribute("DetailTable").equals(oldElement.getAttribute("DetailTable"))) {
                oldElementList = oldElement.getElementsByTagName("Detail");
                newElementList = newElement.getElementsByTagName("Detail");
                if (newElementList.getLength() == 0 && newElementList.getLength() == 0) {
                    tagName = "Column";
                    elementName = this.getElementNameByTagName(tagName);
                    attrList.clear();
                    attrList.add("Order");
                    attrList.add("Width");
                    attrList.add("Alignment");
                    attrList.add("FieldOptions");
                    oldElementList = oldElement.getElementsByTagName(tagName);
                    newElementList = newElement.getElementsByTagName(tagName);
                    i = 0;
                    while (i < newElementList.getLength()) {
                        newElementWork = (Element)newElementList.item(i);
                        isNotFound = true;
                        j = 0;
                        while (j < oldElementList.getLength()) {
                            oldElementWork = (Element)oldElementList.item(j);
                            if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                                elementLabel = String.valueOf(functionLabel) + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07");
                                k = 0;
                                while (k < attrList.size()) {
                                    this.compareNewAndOldElements(newElementWork, oldElementWork, (String)attrList.get(k), elementLabel);
                                    ++k;
                                }
                                isNotFound = false;
                                break;
                            }
                            ++j;
                        }
                        if (isNotFound) {
                            ++this.countOfChanges;
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + newElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage08"));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < oldElementList.getLength()) {
                        oldElementWork = (Element)oldElementList.item(i);
                        isNotFound = true;
                        j = 0;
                        while (j < newElementList.getLength()) {
                            newElementWork = (Element)newElementList.item(j);
                            if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource"))) {
                                isNotFound = false;
                                break;
                            }
                            ++j;
                        }
                        if (isNotFound) {
                            ++this.countOfChanges;
                            this.buffer.append("\n" + this.countOfChanges + "." + functionLabel + res.getString("FileDiffMessage02") + elementName + res.getString("FileDiffMessage06") + oldElementWork.getAttribute("DataSource") + res.getString("FileDiffMessage07") + res.getString("FileDiffMessage09"));
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void compareSubElementsOfXF300Details(Element newElement, Element oldElement, String elementLabel) {
        Element oldElementWork;
        int j;
        boolean isNotFound;
        Element newElementWork;
        boolean isAnyDifferent = false;
        String tagName = "Column";
        NodeList oldElementList = oldElement.getElementsByTagName(tagName);
        NodeList newElementList = newElement.getElementsByTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource")) && oldElementWork.getAttribute("Order").equals(newElementWork.getAttribute("Order")) && oldElementWork.getAttribute("FieldOptions").equals(newElementWork.getAttribute("FieldOptions"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource")) && oldElementWork.getAttribute("Order").equals(newElementWork.getAttribute("Order")) && oldElementWork.getAttribute("FieldOptions").equals(newElementWork.getAttribute("FieldOptions"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        if (isAnyDifferent) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("FileDiffMessage11"));
        }
        isAnyDifferent = false;
        tagName = "Filter";
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource")) && oldElementWork.getAttribute("Order").equals(newElementWork.getAttribute("Order")) && oldElementWork.getAttribute("FieldOptions").equals(newElementWork.getAttribute("FieldOptions"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource")) && oldElementWork.getAttribute("Order").equals(newElementWork.getAttribute("Order")) && oldElementWork.getAttribute("FieldOptions").equals(newElementWork.getAttribute("FieldOptions"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        if (isAnyDifferent) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("FileDiffMessage12"));
        }
        isAnyDifferent = false;
        tagName = "Button";
        oldElementList = oldElement.getElementsByTagName(tagName);
        newElementList = newElement.getElementsByTagName(tagName);
        i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("Position").equals(newElementWork.getAttribute("Position")) && oldElementWork.getAttribute("Number").equals(newElementWork.getAttribute("Number")) && oldElementWork.getAttribute("Caption").equals(newElementWork.getAttribute("Caption")) && oldElementWork.getAttribute("Action").equals(newElementWork.getAttribute("Action"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("Position").equals(newElementWork.getAttribute("Position")) && oldElementWork.getAttribute("Number").equals(newElementWork.getAttribute("Number")) && oldElementWork.getAttribute("Caption").equals(newElementWork.getAttribute("Caption")) && oldElementWork.getAttribute("Action").equals(newElementWork.getAttribute("Action"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        if (isAnyDifferent) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("FileDiffMessage11"));
        }
    }

    private void compareSubElementsOfXF390Details(Element newElement, Element oldElement, String elementLabel) {
        Element oldElementWork;
        int j;
        boolean isNotFound;
        Element newElementWork;
        boolean isAnyDifferent = false;
        String tagName = "Column";
        NodeList oldElementList = oldElement.getElementsByTagName(tagName);
        NodeList newElementList = newElement.getElementsByTagName(tagName);
        int i = 0;
        while (i < newElementList.getLength()) {
            newElementWork = (Element)newElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < oldElementList.getLength()) {
                oldElementWork = (Element)oldElementList.item(j);
                if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource")) && oldElementWork.getAttribute("Order").equals(newElementWork.getAttribute("Order")) && oldElementWork.getAttribute("Width").equals(newElementWork.getAttribute("Width")) && oldElementWork.getAttribute("Alignment").equals(newElementWork.getAttribute("Alignment")) && oldElementWork.getAttribute("FieldOptions").equals(newElementWork.getAttribute("FieldOptions"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < oldElementList.getLength()) {
            oldElementWork = (Element)oldElementList.item(i);
            isNotFound = true;
            j = 0;
            while (j < newElementList.getLength()) {
                newElementWork = (Element)newElementList.item(j);
                if (oldElementWork.getAttribute("DataSource").equals(newElementWork.getAttribute("DataSource")) && oldElementWork.getAttribute("Order").equals(newElementWork.getAttribute("Order")) && oldElementWork.getAttribute("FieldOptions").equals(newElementWork.getAttribute("FieldOptions"))) {
                    isNotFound = false;
                    break;
                }
                ++j;
            }
            if (isNotFound) {
                isAnyDifferent = true;
                break;
            }
            ++i;
        }
        if (isAnyDifferent) {
            ++this.countOfChanges;
            this.buffer.append("\n" + this.countOfChanges + "." + elementLabel + res.getString("FileDiffMessage11"));
        }
    }

    private String getElementNameByTagName(String tagName) {
        String elementName = "";
        try {
            elementName = res.getString(tagName);
        }
        catch (Exception e) {
            elementName = tagName;
        }
        if (tagName.equals("MaintenanceLog")) {
            elementName = res.getString("SystemMaintenanceLog");
        }
        if (tagName.equals("Function")) {
            elementName = res.getString("FunctionDefinition");
        }
        return elementName;
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

