/*
 * Decompiled with CFR 0.152.
 */
package xeadEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import xeadEditor.Editor;

class Editor_DialogStructureTableEdit
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("xeadEditor.Res");
    private JButton jButtonOK = new JButton();
    private JButton jButtonCancel = new JButton();
    private Editor frame_;
    private JLabel jLabelStructureTableID = new JLabel();
    private JLabel jLabelStructureUpperKeys = new JLabel();
    private JLabel jLabelStructureChildKeys = new JLabel();
    private JLabel jLabelStructureOrderBy = new JLabel();
    private JTextField jTextFieldStructureTableID = new JTextField();
    private JTextField jTextFieldStructureTableName = new JTextField();
    private JTextField jTextFieldStructureUpperKeys = new JTextField();
    private JTextField jTextFieldStructureChildKeys = new JTextField();
    private JTextField jTextFieldStructureOrderBy = new JTextField();
    private JTextArea jTextAreaMessage = new JTextArea();
    private JPanel jPanelCenter = new JPanel();
    private JPanel jPanelButtons = new JPanel();
    private Editor.MainTreeNode tableNode = null;
    private String headerTableID_ = "";
    private String headerTableKeys_ = "";
    private String currentStructureTableID = "";
    private String nodeText_ = "";
    private int returnCode;

    public Editor_DialogStructureTableEdit(Editor frame) {
        super(frame, "", true);
        this.frame_ = frame;
        try {
            this.init();
        }
        catch (Exception ex) {
            this.frame_.processError(ex);
        }
    }

    private void init() throws Exception {
        this.jPanelButtons.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelButtons.setPreferredSize(new Dimension(350, 43));
        this.jPanelButtons.setLayout(null);
        this.jButtonOK.setBounds(new Rectangle(440, 8, 100, 27));
        this.jButtonOK.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor_DialogStructureTableEdit.this.jTextFieldStructureTableID.equals("") || Editor_DialogStructureTableEdit.this.valuesValidated()) {
                    Editor_DialogStructureTableEdit.this.returnCode = 1;
                }
                Editor_DialogStructureTableEdit.this.setVisible(false);
            }
        });
        this.jButtonCancel.setBounds(new Rectangle(50, 8, 100, 27));
        this.jButtonCancel.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jButtonCancel.setText(res.getString("Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor_DialogStructureTableEdit.this.setVisible(false);
            }
        });
        this.jPanelButtons.add((Component)this.jButtonOK, null);
        this.jPanelButtons.add((Component)this.jButtonCancel, null);
        this.jPanelCenter.setBorder(null);
        this.jPanelCenter.setLayout(null);
        this.jLabelStructureTableID.setText(res.getString("StructureTable"));
        this.jLabelStructureTableID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelStructureTableID.setHorizontalAlignment(4);
        this.jLabelStructureTableID.setHorizontalTextPosition(10);
        this.jLabelStructureTableID.setBounds(new Rectangle(5, 12, 150, 20));
        this.jTextFieldStructureTableID.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldStructureTableID.setBounds(new Rectangle(160, 9, 120, 25));
        this.jTextFieldStructureTableID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Editor_DialogStructureTableEdit.this.setTableAttribute();
            }
        });
        this.jTextFieldStructureTableName.setEditable(false);
        this.jTextFieldStructureTableName.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldStructureTableName.setBounds(new Rectangle(285, 9, 300, 25));
        this.jLabelStructureUpperKeys.setText(res.getString("StructureUpperKeys"));
        this.jLabelStructureUpperKeys.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelStructureUpperKeys.setHorizontalAlignment(4);
        this.jLabelStructureUpperKeys.setHorizontalTextPosition(10);
        this.jLabelStructureUpperKeys.setBounds(new Rectangle(5, 43, 150, 20));
        this.jTextFieldStructureUpperKeys.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldStructureUpperKeys.setBounds(new Rectangle(160, 40, 425, 25));
        this.jLabelStructureChildKeys.setText(res.getString("StructureChildKeys"));
        this.jLabelStructureChildKeys.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelStructureChildKeys.setHorizontalAlignment(4);
        this.jLabelStructureChildKeys.setHorizontalTextPosition(10);
        this.jLabelStructureChildKeys.setBounds(new Rectangle(5, 74, 150, 20));
        this.jTextFieldStructureChildKeys.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldStructureChildKeys.setBounds(new Rectangle(160, 71, 425, 25));
        this.jLabelStructureOrderBy.setText(res.getString("StructureOrderBy"));
        this.jLabelStructureOrderBy.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jLabelStructureOrderBy.setHorizontalAlignment(4);
        this.jLabelStructureOrderBy.setHorizontalTextPosition(10);
        this.jLabelStructureOrderBy.setBounds(new Rectangle(5, 105, 150, 20));
        this.jTextFieldStructureOrderBy.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextFieldStructureOrderBy.setBounds(new Rectangle(160, 102, 425, 22));
        this.jTextAreaMessage.setFont(new Font(this.frame_.mainFontName, 0, Editor.MAIN_FONT_SIZE));
        this.jTextAreaMessage.setBounds(new Rectangle(7, 133, 579, 80));
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setBackground(SystemColor.control);
        this.jTextAreaMessage.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelCenter.add((Component)this.jLabelStructureTableID, null);
        this.jPanelCenter.add((Component)this.jTextFieldStructureTableID, null);
        this.jPanelCenter.add((Component)this.jTextFieldStructureTableName, null);
        this.jPanelCenter.add((Component)this.jLabelStructureUpperKeys, null);
        this.jPanelCenter.add((Component)this.jTextFieldStructureUpperKeys, null);
        this.jPanelCenter.add((Component)this.jLabelStructureChildKeys, null);
        this.jPanelCenter.add((Component)this.jTextFieldStructureChildKeys, null);
        this.jPanelCenter.add((Component)this.jLabelStructureOrderBy, null);
        this.jPanelCenter.add((Component)this.jTextFieldStructureOrderBy, null);
        this.jPanelCenter.add((Component)this.jTextAreaMessage, null);
        this.setTitle(res.getString("StructureTableTitle"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.getContentPane().add((Component)this.jPanelCenter, "Center");
        this.setResizable(false);
        this.pack();
    }

    public int request(String tableID, String tableKeys, String childKeys, String orderBy, String headerTableID, String headerTableKeys, String nodeText) {
        this.currentStructureTableID = tableID;
        this.jTextFieldStructureTableID.setText(tableID);
        this.setTableAttribute();
        this.jTextFieldStructureUpperKeys.setText(tableKeys);
        this.jTextFieldStructureChildKeys.setText(childKeys);
        this.jTextFieldStructureOrderBy.setText(orderBy);
        this.headerTableID_ = headerTableID;
        this.headerTableKeys_ = headerTableKeys;
        this.nodeText_ = nodeText;
        this.returnCode = 0;
        this.jTextAreaMessage.setText(res.getString("StructureTableComment"));
        this.setSize(new Dimension(600, 305));
        Dimension dlgSize = this.getSize();
        Dimension frmSize = this.frame_.getSize();
        Point loc = this.frame_.getLocation();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        super.setVisible(true);
        return this.returnCode;
    }

    void setTableAttribute() {
        this.tableNode = null;
        this.jTextFieldStructureTableName.setText("");
        if (!this.jTextFieldStructureTableID.getText().equals("")) {
            this.jTextFieldStructureTableName.setText("N/A");
            this.tableNode = this.frame_.getSpecificXETreeNode("Table", this.jTextFieldStructureTableID.getText());
            if (this.tableNode == null) {
                this.tableNode = this.frame_.getSpecificXETreeNode("Table", this.jTextFieldStructureTableID.getText().toUpperCase());
                if (this.tableNode != null) {
                    this.jTextFieldStructureTableName.setText(this.tableNode.getElement().getAttribute("Name"));
                    Element tablePKElement = this.frame_.getSpecificPKElement(this.jTextFieldStructureTableID.getText());
                    if (this.jTextFieldStructureUpperKeys.getText().equals("")) {
                        this.jTextFieldStructureUpperKeys.setText(tablePKElement.getAttribute("Fields"));
                    }
                }
            } else {
                this.jTextFieldStructureTableName.setText(this.tableNode.getElement().getAttribute("Name"));
                Element tablePKElement = this.frame_.getSpecificPKElement(this.jTextFieldStructureTableID.getText());
                if (this.jTextFieldStructureUpperKeys.getText().equals("")) {
                    this.jTextFieldStructureUpperKeys.setText(tablePKElement.getAttribute("Fields"));
                }
            }
        }
    }

    public String getUpperKeys() {
        return this.jTextFieldStructureUpperKeys.getText();
    }

    public String getChildKeys() {
        return this.jTextFieldStructureChildKeys.getText();
    }

    public String getOrderBy() {
        return this.jTextFieldStructureOrderBy.getText();
    }

    public String getTableID() {
        return this.jTextFieldStructureTableID.getText();
    }

    public Element getTableElement() {
        return this.tableNode.getElement();
    }

    boolean valuesValidated() {
        boolean isValid = true;
        ArrayList<String> headerKeyFieldList = new ArrayList<String>();
        ArrayList<String> upperKeyFieldList = new ArrayList<String>();
        ArrayList<String> childKeyFieldList = new ArrayList<String>();
        ArrayList<String> orderByFieldList = new ArrayList<String>();
        if (this.tableNode != null) {
            this.jTextFieldStructureUpperKeys.setText(this.jTextFieldStructureUpperKeys.getText());
            this.jTextFieldStructureChildKeys.setText(this.jTextFieldStructureChildKeys.getText());
            this.jTextFieldStructureOrderBy.setText(this.jTextFieldStructureOrderBy.getText());
            if (this.jTextFieldStructureUpperKeys.getText().contains(".") || this.jTextFieldStructureChildKeys.getText().contains(".") || this.jTextFieldStructureOrderBy.getText().contains(".")) {
                isValid = false;
                this.jTextAreaMessage.setText(res.getString("ErrorMessage109"));
            } else {
                String wrkStr;
                Element workElement2;
                Element workElement1;
                int i;
                this.jTextFieldStructureUpperKeys.setText(this.jTextFieldStructureUpperKeys.getText());
                this.jTextFieldStructureChildKeys.setText(this.jTextFieldStructureChildKeys.getText());
                StringTokenizer workTokenizer = new StringTokenizer(this.headerTableKeys_, ";");
                while (workTokenizer.hasMoreTokens()) {
                    headerKeyFieldList.add(workTokenizer.nextToken());
                }
                workTokenizer = new StringTokenizer(this.jTextFieldStructureUpperKeys.getText(), ";");
                while (workTokenizer.hasMoreTokens()) {
                    upperKeyFieldList.add(workTokenizer.nextToken());
                }
                workTokenizer = new StringTokenizer(this.jTextFieldStructureChildKeys.getText(), ";");
                while (workTokenizer.hasMoreTokens()) {
                    childKeyFieldList.add(workTokenizer.nextToken());
                }
                workTokenizer = new StringTokenizer(this.jTextFieldStructureOrderBy.getText(), ";");
                while (workTokenizer.hasMoreTokens()) {
                    orderByFieldList.add(workTokenizer.nextToken());
                }
                if (headerKeyFieldList.size() != upperKeyFieldList.size()) {
                    isValid = false;
                    this.jTextAreaMessage.setText(res.getString("ErrorMessage110"));
                } else {
                    i = 0;
                    while (i < headerKeyFieldList.size()) {
                        workElement1 = this.frame_.getSpecificFieldElement(this.jTextFieldStructureTableID.getText(), (String)upperKeyFieldList.get(i));
                        if (workElement1 == null) {
                            isValid = false;
                            this.jTextAreaMessage.setText(res.getString("ErrorMessage110"));
                            break;
                        }
                        workElement2 = this.frame_.getSpecificFieldElement(this.headerTableID_, (String)headerKeyFieldList.get(i));
                        if (!workElement1.getAttribute("Type").equals(workElement2.getAttribute("Type")) || !workElement1.getAttribute("Size").equals(workElement2.getAttribute("Size"))) {
                            isValid = false;
                            this.jTextAreaMessage.setText(res.getString("ErrorMessage111"));
                            break;
                        }
                        ++i;
                    }
                }
                if (isValid) {
                    if (headerKeyFieldList.size() != childKeyFieldList.size()) {
                        isValid = false;
                        this.jTextAreaMessage.setText(res.getString("ErrorMessage112"));
                    } else {
                        i = 0;
                        while (i < headerKeyFieldList.size()) {
                            workElement1 = this.frame_.getSpecificFieldElement(this.jTextFieldStructureTableID.getText(), (String)childKeyFieldList.get(i));
                            if (workElement1 == null) {
                                isValid = false;
                                this.jTextAreaMessage.setText(res.getString("ErrorMessage112"));
                                break;
                            }
                            workElement2 = this.frame_.getSpecificFieldElement(this.headerTableID_, (String)headerKeyFieldList.get(i));
                            if (!workElement1.getAttribute("Type").equals(workElement2.getAttribute("Type")) || !workElement1.getAttribute("Size").equals(workElement2.getAttribute("Size"))) {
                                isValid = false;
                                this.jTextAreaMessage.setText(res.getString("ErrorMessage113"));
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (isValid) {
                    i = 0;
                    while (i < orderByFieldList.size()) {
                        wrkStr = ((String)orderByFieldList.get(i)).replace("(A)", "");
                        wrkStr = ((String)orderByFieldList.get(i)).replace("(D)", "");
                        workElement1 = this.frame_.getSpecificFieldElement(this.jTextFieldStructureTableID.getText(), wrkStr);
                        if (workElement1 == null) {
                            isValid = false;
                            this.jTextAreaMessage.setText(res.getString("ErrorMessage117"));
                            break;
                        }
                        ++i;
                    }
                }
                if (isValid) {
                    workTokenizer = new StringTokenizer(this.nodeText_, ";");
                    while (workTokenizer.hasMoreTokens()) {
                        wrkStr = workTokenizer.nextToken();
                        if (!wrkStr.startsWith(String.valueOf(this.currentStructureTableID) + ".")) continue;
                        wrkStr = wrkStr.replace(String.valueOf(this.currentStructureTableID) + ".", "");
                        workElement1 = this.frame_.getSpecificFieldElement(this.jTextFieldStructureTableID.getText(), wrkStr);
                        if (workElement1 != null) continue;
                        isValid = false;
                        this.jTextAreaMessage.setText(res.getString("ErrorMessage122"));
                        break;
                    }
                }
            }
        }
        return isValid;
    }
}

